var library = [
{"paperid":"1210","title":"The influence of trailing edge profiles on vertical axis turbine blades performance","keywords":"A numerical lock-in prediction method of a NACA 0012 foil employed for tidal turbine blades in a flow having a Re of 3.07x106 is proposed in this paper. The method observes the foil's response as a part of a fluid-structure interaction analysis. The response is modelled by foil's vibration which is represented by spring and damper components. The method identifies and predicts the foil's lock-in when it vibrates. The prediction is examined using the Phase Averaged Method which employs the Hilbert Transform Method. The aim of this paper is to propose a numerical method to identify a locked-in condition experienced by a NACA 0012 foil in a high Reynolds number flow. The foil's mechanical properties are selected and its motions are restricted in two modes which are in pitch and heave direction. The rotational and transverse lock-in modes are identified in the model. The existence of lock-in is verified using pressure distribution plot, the history of trailing edge displacement, and fluid regime capture. The history of total force coefficients are also shown to justify the result. The result shows that the method can predict the lock-in condition on the foil's interaction quite well. Three main fluid induced vibration frequencies are generated in the interaction. None of them are close to natural frequency of the foil and lock-in is apparently not found in the typical operational condition.    ","authors":"Nu R. Arini, Stephen R. Turnock, and Mingyi Tan","topic":"6","file":"1210-4980-2-DR-OK.pdf","bib":"TIDHYD-1210.bib"},
{"paperid":"1212","title":"Hydrodynamic performance characterisation of a tidal energy generation system buoyancy assembly using CFD ","keywords":"The TidGen 2.0 Power System is an electricity generation system which functions by harnessing energy from tidal currents.  It consists of a moored turbine assembly that is kept in tension by a buoyancy system which has an elongated cylinder profile. The current work looks to define the hydrodynamic characteristics of the buoyancy assembly using Computational Fluid Dynamics (CFD). This is to confirm the design efficacy in terms of having low in-line drag which in turn minimizes lateral and pitching deflection of the entire system. A buoyancy assembly model is created and CFD simulation performed using a transient k-epsilon Reynolds-averaged Navier-Stokes (RANS) numerical scheme. Different scenarios are analyzed in terms of varying flow attack angles to represent system pitch, as well as proximity effects between the lower turbine and buoyancy assemblies. Variation in time of the lift coefficient is monitored in all scenarios analyzed to ensure the buoyancy assembly is not susceptible to regular periodic vortex shedding, which is a pre-cursor to vortex-induced vibrations (VIV) and would negatively impact component structural strength and fatigue life. The selected variations aim to mimic operational conditions and ensure they are within design limits. This also has wider implications on the TidGen system’s stability and performance. ","authors":"Lawrence S. H. Lai, Nathaniel C. Hayes","topic":"4","file":"1212-4928-1-DR-OK.pdf","bib":"TIDDEV-1212.bib"},
{"paperid":"1214","title":"Sensitivity of bathymetry and choice of tidal constituents on tidal-stream energy resource characterization in the Gulf of California, Mexico","keywords":"There have been a larger number of tidal-stream energy resource assessments in recent years due to increased availability of open-source hydrodynamic models, and freely available bathymetry data. This study examines how the choice of batrhymetry and tidal constituents affects the quantification of a tidal-stream energy resource. We conducted sensitivity tests for the Gulf of California. The mean KPD (Kinetic power density) and annual mean power are significantly underestimated when using just GEBCO or ETOPO bathymetry data resources on their own. For the Midriff region, between San Lorenzo and San Esteban Islands, the annual mean power was estimated to be around 50 MW when using freely available bathymetry data while the annual mean power increased to 200 MW when using bespoke data set that was a combination of GEBCO and Bathymetry provided by CICESE (The Centre for Scientific Research and Higher Education at Ensenada). Finally, we compared the estimated energy using 29 tidal constituents compared with simulations that included just M2 and S2. The annual mean KPD decreased by almost 1/3rd in the channel between San Lorenzo and San Esteban Islands, when just considering M2 and S2 constituents, suggesting that diurnal and higher order harmonic constituents are important for accurate resource assesments in the region.","authors":"Carlos Joel Mejia-Olivares, Ivan D. Haigh, Matt J. Lewis and Simon P. Neill","topic":"2","file":"1214-4778-1-DR-OK.pdf","bib":"TIDRES-1214.bib"},
{"paperid":"1219","title":"Predicting and optimizing the energy-generation performance of an in-stream turbine operating with twin, unconfined, counter-rotating screws by means of CFD Modeling","keywords":"The overall objective of this numerical investigation consists of predicting and optimizing the energy-generation performance of an in-stream turbine undergoing preliminary design. This turbine is unconventional as its energy extraction surfaces are composed of twin, counter-rotating, unconfined screws aligned at an oblique angle with respect to the water current. First, a cost-effective computational fluid dynamics (CFD) model of the water flow in the vicinity of the turbine was implemented in a commercial package. This CFD model was benchmarked by comparing predicted power coefficient values with available, empirically-obtained, data provided by the client. During this benchmarking exercise, it was determined that a rotating (sliding) mesh approach was necessary to obtain accurate predictions. The CFD model was then used to predict power coefficient values over a range of tip-speed ratios at the design free-stream water velocity for the proposed (initial) screw design. Lastly, additional simulations were performed to investigate the performance of additional screw designs in the hope of optimizing the energy-generation performance while respecting the provided design constraints. ","authors":"Alexandre Lamoureux, Duane J. M. Baker, Jean Doyon, and Ross Sinclaire","topic":"6","file":"1219-4982-2-DR-OK.pdf","bib":"TIDHYD-1219.bib"},
{"paperid":"1224","title":"Efficiency of an array of OWC devices equipped with air turbines with pitch control","keywords":"Abstract   Among several classes of designs proposed for wave energy conversion, the oscillating water column device (OWC) has received considerable theoretical attention. The most common shape of an OWC consists of a vertical cylinder partly submerged as an open bottom chamber in which air is oscillating. The chamber is connected with the outer atmosphere by a duct housing an air turbine. Forced by incident waves from any direction, the water surface inside pushes the dry air above through a Wells turbine system to generate power. As far as the case of arrays of those devices is concerned, it is more likely to be deployed in the future in preference to single isolated OWC’s in order to increase the exploitable wave energy in an installation site and to facilitate installation and electrical power transmission.   Based on the theoretical studies on isolated or arrays of OWC devices reported in recent years ([1]-[5]) the efficiency of an oscillating water column device is affected by several parameters related to: a) the climate environmental conditions at the candidate installation location; b) the hydrodynamic characteristics of the OWC device as they are related to the design of the oscillating chamber; c) the characteristics of the installed air turbine; and d) the device’s position in the array relevant to the wave train propagation.   In practice, it is difficult to maximize the efficiency of an OWC array in every wave condition at the installation site by changing rapidly the position of each OWC device in the array or by varying the geometric characteristics of the oscillating chambers in relation to the wave frequency of the incoming wave. However, the air turbine characteristics in each oscillating chamber can vary rapidly, according to the wave frequency at the installation location, using an air turbine with pitch control.   In the present paper the efficiency of an array of floating OWC devices, as being described in the REFOS multi-purpose floating platform ([6]-[8]), equipped with air turbines with pitch control is examined. Numerical results such as the absorbed power by each OWC; the volume flow; and the inner air pressure distribution inside the oscillating chambers are compared for various air turbine’s pitch angles aiming at maximizing system’s wave energy absorption in wider range of wave conditions at the installation site. In addition the analysis further extends to the investigation of the optimum air turbine characteristics that maximizes the absorbed wave power by the REFOS platform for possible installation in the Mediterranean Sea based on wave records near Sicily Island.   References   [1]        Mavrakos, S.A., Konispoliatis, D.N., “Hydrodynamic analysis of a vertical axisymmetric oscillating water column device floating in finite depth waters”,  Proceedings, 31 st  OMAE 2012 , 2012. Rio deJaneiro, Brazil.   [2]        Konispoliatis, D.N., Mavrakos, S.A., “Hydrodynamic analysis of an array of interacting free–floating oscillating water column devices”, Ocean Eng., vol. 111, 179–197, 2016.   [3]        Delaure, Y,M,C,, &amp; Lewis, A., “3D hydrodynamic modelling of fixed oscillating water column wave power plant by a boundary element methods”, Ocean Eng., vol. 30; 309–330, 2003.   [4]        Weber, J.W., Thomas, G.P., “An investigation into the importance of the air chamber design of an oscillating water column wave energy device”,  Proceedings of the 11th International Offshore and Polar Engineering Conference , Stavanger, Norway; 2001, vol. 1, 581-588.   [5]        Dorrell, D.G, Fillet, W., “Investigation of a small scale segmented oscillating water column utilizing a Savonius rotor turbine”,  Proceedings of the International Conference on Energy and Environment , Malaysia; 2006, 23–32.   [6]        Konispoliatis, D.N., Mazarakos, T.P., Soukissian, T.H., Mavrakos, S.A., “REFOS: A multi - purpose floating platform suitable for wind and wave energy exploitation” ,   Proceedings of the 11th International Conference on Deregulated Electricity Market Issues in South Eastern Europe  (DEMSEE 2018), Nicosia ,  Cyprus.   [7]        Mazarakos, T., Konispoliatis, D., Manolas, D., Voutsinas, S., Mavrakos, S., “Modelling of an offshore multi-purpose floating structure supporting a wind turbine including second-order wave loads,”  Proceedings of the 11th EWTEC 2015 , Nantes, France.   [8]        Konispoliatis, D.N., Mazarakos, T.P., Mavrakos, S.A., “Hydrodynamic an analysis of three-unit arrays of floating annular oscillating-water-column wave energy converters”, Applied Ocean Research, vol. 61; 42–64, 2016.        ","authors":"Dimitrios N. Konispoliatis, Thomas P. Mazarakos, Eirini ?. Katsidoniotaki, Antonios ?. Vamiadakis, Takvor H. Soukissian, Spyridon A. Mavrakos","topic":"3","file":"1224-4959-2-DR-OK.pdf","bib":"WAVDEV-1224.bib"},
{"paperid":"1225","title":"Wind effects in the parametrisation of physical characteristics for a nearshore wave model","keywords":"In order to properly assess the energy and metocean conditions at a region, long term metocean conditions are vital. Although, wave buoys are a significant source of information, they are not able to provide a detail and complete resource assessment. Therefore, numerical wave models are used estimate metocean and subsequently wave power conditions. However, they require detail representation of physical processes and careful tuning of parameters that are often based on empirical coefficients.  The study presents the calibration of a wave numerical model and examines its performance. Parametrisations of wind growth and whitecapping coefficients have direct effects on evolution of locally generated waves, swells, and can reduce uncertainty in the results of a hindcast. The results are used to explain the physical meaning of the differences, and provide a detail comparison of metocean parameters with nearshore and shallow water buoys. Inter-model comparisons also indicate differences in spatial wave generation and propagation, as affected by wind growth and dissipation rates. The optimal solution will result in a model that will be used to provide the first long-term high resolution metocean and wave power assessment for the Netherlands. ","authors":"George Lavidas and Henk Polinder","topic":"1","file":"1225-4674-1-DR-OK.pdf","bib":"WAVRES-1225.bib"},
{"paperid":"1226","title":"Wave energy in the Netherlands: Past, Present and Future perspectives","keywords":"With the renewable targets of 2020 reaching ever closer, Europe is continuing its ambitious plans for 2030 of developing innovative projects that assist tackling climate change and increase renewable energy integration. The Netherlands are trying to develop their renewable energy portfolio in order to create a long-term sustainable energy strategy. So far majority of development has fallen on wind and solar, with offshore wind gaining significant traction over the past years. However, in order to truly transition to a renewable energy society all indigenous resources must be evaluated and utilized.  The Netherlands have a long history of dealing with water resources and have an extensive industrial base in ocean engineering. However, when it comes to the development of wave energy the sector is lacking behind. In this paper we focus and discuss the past, present and future status of wave energy research and industrial development in the Netherlands. With wave technologies in early stages of development in terms of technology and regional applications, there are numerous opportunities that can assist in unlocking the wave energy industry in the Netherlands. ","authors":"George Lavidas and Henk Polinder","topic":"10","file":"1226-5041-1-DR-OK.pdf","bib":"ECONOM-1226.bib"},
{"paperid":"1228","title":"Speed control of multiple tidal turbines connected to a shared onshore converter","keywords":"A novel control strategy is proposed for the control of two fixed pitch tidal turbines subjected to discrete flow speeds whilst interconnected in an array. It is suggested that reliability will be increased by locating all power conversion and control equipment onshore, thereby reducing Operating Expenditure (OPEX) incurred through offshore equipment failure. An added benefit is utilisation of a single shared export cable for both turbines, thereby reducing Capital Expenditure (CAPEX). By lowering the cost of installing and maintaining an array, it is anticipated that the commercial viability of the project will be enhanced.   Speed regulation of each Induction Generator (IG) is carried out individually through Field Oriented Control (FOC) with the torque reference calculated using Optimal Torque Control (OTC). This provides Maximum Power Point Tracking (MPPT) whilst allowing individual generators to run at different speeds by varying the Tip Speed Ratio (TSR) at which each turbine operates. Estimated current waveforms calculated by FOC are averaged between both turbines and fed to a Pulse Width Modulation (PWM) generator for comparison against actual averaged currents from both generators. A shared Insulated Gate Bipolar Transistor (IGBT) inverter is controlled by the PWM pulses to maintain the currents of both generators in phase.    ","authors":"Simon M. Reynolds,  Aristides E. Kiprakis, and Mohammad Abusara ","topic":"7","file":"1228-5034-2-DR-OK.pdf","bib":"GRDPTO-1228.bib"},
{"paperid":"1232","title":"Multi-directional waves and time domain perturbed field visualization of the WaveSub device","keywords":"Wave Energy Converters (WECs) are very often simulated in bi-dimensional waves but a more accurate simulation that represents a more realistic sea state should account for multi-directional waves. Directional distribution can be expressed as a Gaussian spreading model or other forms such as cos2s(µ) but with the same equal effect. Here we show a multi-directional waves simulation of the WaveSub device and a visualization of the perturbed field generated. Effects on the power produced for some simulation cases are also shown. Linear potential flow has been used for this purpose as compared to a CFD method used previously. Directional spreading has been modelled as a Gaussian spreading model. This result can give a reduced computational cost compared to CFD and a perturbed field visualization could be used for future benchmarking purposes. The paper also presents a method for perturbed field visualization to show more confidence in the results obtained. Implementation of the multi-directional simulation has been completed in WEC-Sim and this modification to the software has been adopted in the official version. The authors recommend further cross-validation of the model should be carried out as further work. ","authors":"E. Faraggiana, I. Masters, J. Chapman, G. Foster and G. Stockman","topic":"5","file":"1232-3856-4-DR-OK.pdf","bib":"WAVHYD-1232.bib"},
{"paperid":"1234","title":"New MoonWEC concept and its device optimization","keywords":"The   MOONWEC, a new concept of point absorber is here presented for the first time after its patent submission.   The new concept of WEC merges several working principles, with the aim to benefit from the assets of each single principle. It consists in a hollow floating structure, where the sea water fills a central whole creating a moonpool. The idea is to create a relative motion between the floater and the moonpool’s water and then, absorb the energy via a Wells turbine placed in the moonpool. The model takes into account the structure motion in heave, surge and pitch; the relative displacement of the moonpool, the Wells turbine rotation and its coupling to a permanent magnet generator in order to obtain the absorbed instantaneous power.   Three main parts of the device have been simulated: a hollow floating structure, a central moonpool and CALM mooring system. All the parts of the model have been coupled to obtain the general behaviour of the device under the effect of irregular sea states.   The paper will present the new concept and the dimensioning and optimisation of the device based on a numerical potential flow model.                             ","authors":"Adria Moreno Miquel and Renata Archetti","topic":"3","file":"1234-4784-3-DR-OK.pdf","bib":"WAVDEV-1234.bib"},
{"paperid":"1238","title":"Modelling and testing of hydraulic power take-off for wave energy converter on artificial breakwater ","keywords":"The development of new energy has become a historical trend and an inevitable choice in today's world, facing the problem that the possible greenhouse gas emissions and the decline of traditional fossil reserves including oil and coal. Marine energy is a renewable energy source that is green, clean and has huge reserves. The oscillating wave energy converter can effectively convert wave energy into power resources for human society. In this paper, an oscillating wave energy-converting device based on artificial breakwater is designed. Wave energy is captured by a buoy floating on the water, and then electricity generated with rotating generator driven by hydraulic power take-off (PTO) system. Design of the overall wave energy converter device is introduced in this paper. In addition, hydrodynamic parameters of the buoy are analysed by ANSYS/AQWA software including additional mass, damping coefficient and RAO. After that, the parameters of linear PTO are analysed with MATLAB/Simulink software. The hydraulic PTO system is designed and its electromechanical system is simulated with AMESim software. In addition, the damping is optimized with the simulation results of linear PTO and hydraulic PTO. The motion limitation of the buoy is accomplished by introducing the damping in PTO system. Finally, the feasibility of the designed hydraulic PTO system is examined by setting up a test bench.   Fig. 1 The wave energy converter model on artificial breakwater             Fig. 2  Hydraulic PTO simulation by AMESim     Fig. 3  Optimal power generation under different wave periods        ","authors":"Jianan Xu, Tao Xu, and Yansong  Yang","topic":"3","file":"1238-4888-1-DR-OK.pdf","bib":"WAVDEV-1238.bib"},
{"paperid":"1240","title":"Effects from wave power generators on the distribution of two sea pen species on the Swedish west coast","keywords":"Global electricity demand doubled between 1990 and 2016 (1) and several countries are planning for a significant increase in offshore renewable energies along the European coast by 2020 (2). In 2015 renewable energy accounted for more than half of the new generating capacity installed in the power sector worldwide (3). These activities emerge an increased interest about possible environmental impacts or additional values of the new technologies. At the west coast of Sweden, 120 km north of Gothenburg, the Wave Energy Park “Sotenäs Project” is located. This area has been the location of environmental impact studies from wave energy generators on two sea pen species,  Virgulia mirabilis  (Müller, 1776) and  Pennatula phosphorea  (Linnaeus, 1758).   Sea pens and burrowing mega fauna communities are assigned as threatened or declining habitats or species as by the OSPAR convention, the Convention for the Protection of the Marine Environment of the North-East Atlantic (4). Investigation on those taxa in relation to marine renewable energies are thereby interesting and important. For the first time, a ROV aided seabed survey in the wave power park and respective control areas were conducted to assess and compare the abundance of the two sea pen species.   Preliminary results do not show a clear trend between the three transects and survey years. Long-term observations and complementary studies are necessary in order to draw firm conclusions.      Key words: Wave power, sea pens,  Virgulia mirabilis, Pennatula phosphorea , ROV survey, Environmental studies, Marine renewable energy       References   [1.]     Jamieson P, Jamieson P. Offshore Renewable Energy. IEA. 2018;(September):13–4.   [2.]     European Union. L 140/16. 2009.   [3.]     International Energy Agency (IEA), IEA. World Energy Outlook 2016. Secur Sustain Together [Internet]. 2016;684. Available from: www.iea.org/t&amp;c/   [4.]     OSPAR, Curd A. Background Document for Seapen and Burrowing megafauna communities [Internet]. Biodiversity Series. 2010. Available from: internal-pdf://76.162.41.45/OSPAR 2010.pdf ","authors":"Anke Bender, Jan Sundberg","topic":"9","file":"1240-4899-1-DR-OK.pdf","bib":"ENVIRO-1240.bib"},
{"paperid":"1243","title":"Wave-turbulence separation with empirical orthogonal function analysis","keywords":"The combined action of waves and turbulence greatly impacts the load variability of tidal energy converters. Quantifying these phenomena from field measurements, however, is not a trivial task. The most widely-employed tools for measurement of flow conditions are acoustic Doppler current profilers (ADCPs). ADCP data can be used to estimate turbulence properties; among the most important of these is turbulent kinetic energy (TKE), which is most often calculated using the variance method. The variance method is not capable of picking out velocity variance due to turbulence from variance arising from other physical phenomena, most significantly the orbital particle velocity associated with waves. Thus, estimates of TKE obtained from ADCPs are biased high by wave action, sometimes by up to an order of magnitude. Empirical orthogonal functions (EOFs) are a very useful tool for disentangling physical phenomena that are coupled in this way. The paper discusses how to best set up EOF analysis of TKE estimates from ADCP measurements, and provides quantified estimates of how well the technique is able to decouple wave and turbulence contributions to the measured values of TKE based on ADCP measurements taken off Anglesey in 2014. ","authors":"Michael Togneri, Ian Masters, and Iain Fairley","topic":"2","file":"1243-4895-1-DR-OK.pdf","bib":"TIDRES-1243.bib"},
{"paperid":"1249","title":"Italian wave energy: state of the art and challenges of exiting full scale pilots ","keywords":"In this review, the experience made during the last decade by Italian researcher and engineers of full scale pilots of wave energy device is described. Focus is on the development of three prototypes. 1) The ISWEC, Inertial Sea Wave Energy Converter, is a device based on a floating body slack-moored to the seabed, using a gyroscope as a reference frame to produce electric power. The real scale pilot was installed offshore of Pantelleria island (south Italy). 2) The REWEC3 (REsonant Wave Energy Converter 3) REWEC3 is the first worldwide application in the Med Sea (and one of the biggest in the world) of an innovative WEC, which improves the classical Oscillating Water Column technology. The full-scale prototype has been installed at the Port of Civitavecchia. 3) OBREC represents the world’s first overtopping WEC totally integrated in an existing breakwater. The full-scale pilot is operative at the Port of Naples.   The research of low marginal cost and low marginal environmental impact coupled with very high potential for electricity production represents the distinguishing feature and the most important challenge of the Italian research on the marine energy. The three pilots corresponds to three different ways of solving such trilemma.     ","authors":"Pasquale Contestabile, Giuliana Mattiazzo, Alessandra Romolo, Giovanni Bracco, Felice Arena, Diego Vicinanza ","topic":"3","file":"1249-4967-1-RV-OK.pdf","bib":"WAVDEV-1249.bib"},
{"paperid":"1250","title":"Speed converter controlled river turbines","keywords":"The author invented mechanical rotary motion control system is a speed converter. A speed converter is designed with transgears. A transgear is an assembly of gears that has three variables and can control torque (?) and angular velocity (?) separately: therefore, transgears can be used to convert infinitely variable speed to constant. The speed converter used in this experiment is called Speed Converter Hummingbird. Hummingbird is designed with two transgears and has three variables. When the three variables are assigned with three functions, i.e., a variable input (first independent variable), a control input (second independent variable), and an output (dependent variable), the first transgear identifies the speed differences (delta speed) between the variable input speed and the control input speed, and the second transgear eliminates the identified speed differences (delta speed) so that the output of the two transgears or Speed Converter Hummingbird is always constant. Properly designed Hummingbird circuit is torque and speed balanced, and the output power is greater than the control power (mechanical advantage). River turbines controlled by speed converter Hummingbird is scalable and can harness grid-quality baseload electricity with grid (grid-tied) or without grid (distributed generation). The converters can be used for tidal and wave turbines.    ","authors":"Key. S. Han","topic":"7","file":"1250-4759-3-DR-OK.pdf","bib":"GRDPTO-1250.bib"},
{"paperid":"1252","title":"Preliminary load assessment: UMBRA’s 250kW EMG power take-off","keywords":"The IMAGINE (Innovative Method for Affordable Generation IN ocean Energy) project aims to develop an Electro-Mechanical Generator (EMG), an innovative Power Take-Off (PTO) concept for wave energy applications which is able to convert slow speed, reciprocating linear motion into electricity. The EMG is based on a recirculating ball screw and a permanent magnet generator, an architecture that stems from the aerospace industry.  In this paper, details of the concept design activities conducted under the IMAGINE project are provided. Firstly, a database of WEC models, suitable for integration in both mode of operation and size / scale with a 250kW EMG PTO, was created in WEC-Sim. Secondly, a high-level site assessment in European waters was conducted with the aim of selecting the type(s) of sites that are most likely to suit a 250kW WEC prototype. Thirdly, critical DLCs were selected following a risk assessment workshop. And finally, load calculations exercises were conducted for the target DLCs. All of the phases are described in this paper, and the key findings are summarised in a range of quantitative metrics associated with the types of analysis conducted (ULS / FLS).    ","authors":"Joao Cruz, Mairead Atcheson, Tiago Martins, Luca Castellini and Michele Martini","topic":"8","file":"1252-4600-2-DR-OK.pdf","bib":"STRMAT-1252.bib"},
{"paperid":"1262","title":"Sliding Mode Control of an Array of Three Oscillating Water Column Wave Energy Converters to Optimize Electrical Power ","keywords":"Most of the work in the field of wave energy conversion has been done for different types of single wave energy converters (WECs), e.g. floating point absorbers (PAs) and oscillating water columns (OWCs). Some research has been done to characterize the dynamic behavior of arrays of uncontrolled WECs arranged in specific configurations and the resulting changes in the wave field and absorbed power have been described. Analyses by various researchers have also shown that an array configuration with WECs does not necessarily result in the multiplication of the energy of a single device by the total number of devices. Furthermore, researchers in the field have suggested that wave energy farms could be used to reduce and equalize output fluctuations for a smooth supply of the power grid. Further advantages consist in reduced costs for moorings, grid connections, and maintenance.   Our paper presents the development of a direct generator torque control strategy using a sliding mode control approach to optimize the power output of an array of three oscillating water column (OWC) wave energy converters. The OWC WEC is a device that has a submerged vertical tail tube open at both ends, which is fixed to a floater that moves only in the heave direction. The ocean waves cause an oscillating motion of the air inside the tube, which drives a bi-radial turbine. To convert the mechanical energy of the turbine into electrical energy, a doubly-fed induction generator (DFIG) is attached to the turbine. A direct torque control strategy using a sliding mode control approach is then developed to optimize the power output of the OWC WECs. The closed-loop stability of the SMC controller is proven by applying Lyapunov stability theory. The control of the DFIG in irregular waves scenarios and different angles of arrival of the wave front is investigated by means of tests run in the MATLAB/SIMULINK environment. The simulated results provide a validation of the ability of the proposed sliding mode control algorithm to increase the power output of an OWC WEC device.  Specifically, we use a comprehensive hydrodynamic model of three OWCs fully developed from scratch by our research group and its collaborators, namely, a model that takes into account the frequency dependency of the converters, the hydrodynamic interaction between the three WECs, the effects of the nonlinear dynamical behavior of air inside the chamber of vertical tail tube of the OWC WEC, the dynamics of  bi-radial turbine-generators attached to the upper end of the OWC WECs, and the electrical dynamic effects of synchronous DFIGs which transform the mechanical energy delivered by the turbines into electrical energy. In order to design the control algorithm, we first cast the 3-OWC WEC array dynamics into a nonlinear state space model of order 21 and then select simple sliding surfaces to force the error between the desired synchronous rotational speed of the DFIG and the rotational speed of the turbine to slide toward zero, in order to achieve rotational speed tracking.","authors":"Mario E. Magaña, Danielle R. Brown, Daniel T. Gaebele, Joao C. C. Henriques, and Ted K. A. Brekken ","topic":"7","file":"1262-5067-1-DR-OK.pdf","bib":"GRDPTO-1262.bib"},
{"paperid":"1263","title":"Wave farm effects on coastal flooding under climate change","keywords":"The study of wave energy has received increasing research attention in the past few years and recent works have highlighted the dual function of wave farms as carbon-free energy generators and coastal protection elements against erosion (Rodriguez-Delgado et al., 2018a, b, 2019). However, the effects of wave farms on coastal flooding have not been analyzed so far. This work investigates the efficiency of a wave farm in reducing storm-induced coastal flooding on a gravel-dominated beach (Playa Granada, southern Spain) for three sea-level rise scenarios: present situation (SLR0), optimistic projection (SLR1) and pessimistic projection (SLR2).       With this purpose, the SWAN and XBeach-G models, previously validated for the study site, were coupled and applied to 22 equally-spaced beach profiles (100 m apart) in order to assess wave propagation patterns, total run-up values (including water level) and flooded areas for the prevailing storm directions (SW and SE) and the three aforementioned scenarios. The results were compared to the baseline (no farm) case.       The wave farm affects wave propagation by absorbing part of the incoming wave energy flux, which reduces wave heights in its lee. Under SW storms, significant wave heights at breaking are reduced in the eastern part of the study area; whereas under SE storms the reductions extend along most of the coastline, with maximum values in the western part. The alongshore-averaged reductions under SW (SE) storms are 9.3% (24.8%), 9.8% (25.7%) and 9.9% (26.3%) for scenarios SLR0, SLR1 and SLR2, respectively.       The total run-up is reduced in the central and eastern parts of the beach under SW storms, with maximum (alongshore-averaged) values in scenarios SLR1, SLR2 and SLR3 of 14.1% (5.9%), 8.7% (2.6%) and 8.3% (1.5%), respectively. Under SE storms, the total run-up decreases along most of the study area, with maximum (alongshore-averaged) reductions equal to 13.6% (6.8%), 12% (6.1%) and 10.1% (5.1%) for scenarios SLR0, SLR1 and SLR2, respectively. The run-up values under SE storms are generally lower than those under SW storms, influenced by the shoreline orientation, which is almost normal to the incoming SW waves.       Finally, the farm-induced decreases in flooded dry beach area under SW (SE) storms are 5.7% (3.2%), 3.3% (4.9%) and 1.99% (4.5%) in scenarios SLR0, SLR1 and SLR2, respectively. These findings prove that a wave farm can be used not only for purposes of renewable energy generation and protection against erosion, but also to mitigate coastal flooding.        References    Rodriguez-Delgado, C., Bergillos, R. J., Ortega-Sánchez, M., &amp; Iglesias, G. (2018a). Protection of gravel-dominated coasts through wave farms: Layout and shoreline evolution. Science of The Total Environment, 636, 1541-1552.   Rodriguez-Delgado, C., Bergillos, R. J., Ortega-Sánchez, M., &amp; Iglesias, G. (2018b). Wave farm effects on the coast: The alongshore position. Science of the Total Environment, 640, 1176-1186.   Rodriguez-Delgado, C., Bergillos, R. J., &amp; Iglesias, G. (2019). Dual wave farms and coastline dynamics: The role of inter-device spacing. Science of the Total Environment, 646, 1241-1252. ","authors":"Rafael J. Bergillos, Cristobal Rodriguez-Delgado, and Gregorio Iglesias","topic":"9","file":"1263-4629-2-DR-OK.pdf","bib":"ENVIRO-1263.bib"},
{"paperid":"1265","title":"Contribution to the CCP-WSI Blind Test Series 2: CFD-based numerical wave tank experiments employing an impulse source wave maker","keywords":"With the increased availability of high-performance computing resources, high-fidelity CFD-based numerical wave tanks (CNWTs) become more feasible during the research and development of wave energy converters (WECs). Compared to lower-fidelity numerical models, such as Boundary element method (BEM) based models using linear hydrodynamic models, CNWTs have the advantage of capturing all relevant hydrodynamic non-linearities for a large range of operational conditions, specifically under controlled conditions.  To prove the capability of the CNWT to realistically represent the dynamics of the modelled system it is well known that CNWTs require extensive model verification and validation (V\&amp;V). Four main V\&amp;V strategies are found in the literature, where different reference data are used for the comparison of the CFD results. These reference data can be: (a) analytical results; (b) potential Flow simulations; (c) third-party CFD simulations; (d) experimental data. It can be stated that the validation using experimental data is the most prominent strategy. Here, mostly small scale physical wave tank data for e.g. free surface elevation and body dynamics are compared to numerical results.  For the validation of numerical models to experimental data, it is important to have high quality data sets. As part of the Collaborative Computational Project Wave-Structure Interaction (CPP-WSI) such a set of high quality data is used for a blind tests series. A first series has been presented in conjunction with the ISOPE2018 Conference, where a fixed FSPO was subject to focused waves. For the blind tests, experimental surface elevation data, as well as the physical properties of the structure and information on the physical wave tank layout are provided. Participants are then invited to submit results of e.g. pressure data and surface elevation for a blind comparison to all other submissions. For the EWTEC2019 conference, a blind test series is designed, considering the interaction of focused waves with floating structures, representing generic WEC-like systems. Two different physical models are considered: a hemispherical-bottomed buoy and a cylinder with moon-pool. Again, experimental surface elevation data, as well as the physical properties of the structure and information on the physical wave tank layout are provided.  This paper presents the numerical model setup and results for the contribution to the CCP-WSI Blind Test Series 2. A CNWT based on OpenFOAM, specifically OpenFOAM 4.1, is employed. In the OpenFOAM NWT, for wave generation, a recently developed impulse-source wave maker is used. For wave absorption a numerical beach is implemented. The calibration of the numerical beach and the wave generation source term are shown. An analysis of the selection of the employed turbulence model in the Reynolds Averaged Navier-Stokes Equations is also included in the paper. Convergence studies on the temporal and spatial discretisation are shown. Furthermore, device position, surface elevation and mooring forces are presented. ","authors":"Christian Windt, Josh Davidson, Pal Schmitt and John V. Ringwood","topic":"5","file":"1265-4459-2-DR-OK.pdf","bib":"WAVHYD-1265.bib"},
{"paperid":"1266","title":"Developing an Environmental Impact Assessment model for nearshore wave energy devices","keywords":"There is an increasing recognition of the importance of establishing standards for environmental monitoring applied to the wave energy industry to understand the potential impacts of a device in early stages of its development. The fact that wave energy projects have unique characteristics, different from any other marine projects, results in a lack of methodological approaches for environmental and socio-economic impacts evaluation.   This paper proposes a model for Environmental Impact Assessment (EIA), including a Socioeconomic Impact Analysis (SEIA) for nearshore wave energy projects. An Adaptive Management approach is adopted to manage the project impacts regarding mitigation measures’ adaptation and monitoring plan review. This model is intended to work as a guideline for regulators and managers to apply in nearshore wave energy devices and sets the basis for the development of a decision-making tool on the delineation of best monitoring activities schedule and planning which will later be validated through its application on the MegaRoller device final design, an oscillating wave surge converter (OWSC) technology.   An exhaustive literature review was carried out on previous EIAs for similar installations, leading to the identification of a set of receptors and stressors potentially related to the development of nearshore wave energy devices. Their interaction was then crossed in a Summary Impact Matrix which resulted in a set of key impact at both environmental (physical and biological effects) and socioeconomic levels based on a classification provided by the European Marine Energy Centre (EMEC). A set of parameters and mitigation measures was also taken from literature for each receptor.   The user should start with the prioritization of impacts (Step 1) by listing the most significant key effects and assign a level of impact to each of them according to EMEC guidelines and considering the project specific characteristics and baseline characterization. This stage is followed by the selection of mitigation measures (Step 2), in which the user should be able to distinguish which key impacts are fully eliminated through the implementation of a mitigation measure. The ones that don’t, move further to the next step. Finally, the use of decision trees works as a decision-support tool for the identification of monitoring protocols/techniques (Step 3). After the identification of the most appropriate monitoring techniques and protocols per parameter and receptor, the model will provide information on the monitoring planning and schedule specific to each development phase considering the parameters monitoring spatial coverage, duration and frequency.  The method developed under this study represents a significant step towards the standardization of EIA for nearshore wave energy devices. Moreover, the data collected for the elaboration of this framework provides a means for deepening our knowledge of the potential environmental and socioeconomic impacts of nearshore wave energy projects, allowing regulators and managers for better decision-making.","authors":"Maria Apolonia, Ana Silva, and Teresa Simas ","topic":"9","file":"1266-4633-2-DR-OK.pdf","bib":"ENVIRO-1266.bib"},
{"paperid":"1267","title":"Preliminary validation of a 1MW oscillating wave surge converter WEC-Sim model","keywords":"1. Keywords  Wave energy; Oscillating Wave Surge Converter (OWSC); Power Take-Off (PTO); numerical modelling; fully coupled load assessment; validation; MegaRoller. 2. Abstract  Efficiency and reliability are two key challenges for Power Take-Offs (PTOs) because waves generate slow and irregular oscillations, which require processing of large alternating forces in order to extract power. The MegaRoller project aims to design, build and validate a generic high performance, cost-efficient and reliable 1MW PTO that can be integrated into Oscillating Wave Surge Converter (OWSC) designs. The development of the PTO for a 1MW OWSC device is based on multiple software and hardware innovations.   In this context, increasing the knowledge of localised effects associated with the wave resource and their coupling with a 1MW OWSC is of crucial importance to the design, implementation and integration activities to be completed in the MegaRoller project. Therefore, one of the consortium’s key focus is to contribute to the understanding of the wave-structure interaction problem, via the development of a distributed, fully coupled, nonlinear WEC loads model, suitable for performance, load and structural assessments from an early design stage up to the transition to detail design.   In this paper, the development of an initial model of a 1MW OWSC is presented. The model was developed in a customised version of WEC-Sim, introducing a range of nonlinearities (hydrodynamic and mechanic) considered as part of the model developments. The model aims to assess the influence of the distributed loading contributions over the WEC prime mover, i.e. the flap, accounting for the coupled nature of interaction(s) between the flap and the PTO load sources. Non-rigid body structural dynamics were also introduced as part of the model enhancements.   Prior to the application of the baseline model to the MegaRoller project, an initial model based on the previous design iteration of the WaveRoller WEC was built. A preliminary validation exercise was then conducted to assess model accuracy, comparing numerical estimates with the key outputs from a model testing campaign conducted by AW-Energy at Queen’s University of Belfast (QUB) between August 2017 and January 2018. A range of regular and irregular wave tests were selected for initial comparisons, and the key findings are summarised in this paper.   Ultimately, it is expected that the WEC-Sim model will contribute to the detailed understanding of the asynchronous loading affecting the MegaRoller WEC main sub-systems (namely its prime mover and PTO system), and therefore support the structural design of the 1MW MegaRoller WEC.   3. Acknowledgements   This project has received funding from the European Union’s Horizon 2020 research and innovation programme under grant agreement No 763959. ","authors":"Pauline Laporte Weywada, Joao Cruz, Joshua Scriven, Matti Vuorinen, Tuula Maki","topic":"7","file":"1267-4916-1-DR-OK.pdf","bib":"GRDPTO-1267.bib"},
{"paperid":"1268","title":"Survey and numerical model analysis for siting kilowatt-scale tidal turbines","keywords":"Kilowatt-scale tidal turbines, while inappropriate for commercial utility applications, are under consideration for powering highly specialized marine markets and users. We aim to hasten maturity of such turbines by focusing research on deployment, operation, and maintenance. A demonstration array of a pair of cross-flow turbines will be deployed at a test site at the inlet of Sequim Bay, WA. General site selection leverages experience and infrastructure of the Pacific Northwest National Laboratory's Marine Sciences Lab (MSL), which has been developing the site for such applications. An existing pre-permitted area adjacent to the MSL dock has been used by The Applied Physics Laboratory (APL) as a testing ground for a sensor platform. This area, however, does not extend far enough into the inlet to experience swift flow. Therefore, a new, faster site is required. The process of determining and specifying the exact location for turbine deployment can be described as ‘micro siting', as the footprint of deployment is small relative to the area of available sites.   Preliminary siting consisted of analyzing the output of a Finite Volume Coastal Ocean Model (FVCOM) covering Sequim Bay and its surrounding waters provided by PNNL. Though deemed to be of greatest importance, energy density was not the only concern in siting the turbine array, given the objectives of deployment, operation, and maintenance. Additional factors, such as maintaining a minimum depth of water above deployed structures and avoidance of the strongest overturning forces (a combination of bottom slope and peak speed) were also considered. Three candidate sites, each separated by no more than 200 m, exemplifying combinations of high power and strong ratings for ancillary factors were identified.  Given the small footprint of the devices (turbine diameter is less than 1 m), variation in the resource characteristics over small spatial distances are likely to greatly influence location suitability. Therefore, a subsequent shipboard survey using a ‘station keeping' resource characterization method was deemed necessary to increase knowledge and confidence in a siting decision. A downward-looking shipboard ADCP was held for five minute intervals at each prospective location several times, bracketing peak ebb and flood currents during a greater tide at the onset of a spring phase of the fortnightly tidal cycle. The ADCP’s bottom tracking feature was also used to determine suitability of each site for deployment. Results (shown in Fig. 1) indicate significant ebb/flood variation in kinetic power density (kW/m^2) at each site and between sites. In general, the FVCOM output indicates higher magnitude speeds than those observed. The ‘central’ site was chosen due to its high average velocity, well-defined ebb/flood axes, sufficient depth at low water, and having the closest proximity to shore.       ","authors":"Robert J. Cavagnaro, Jim Thomson, Trent Dillon, Andy Stewart, Taiping Wang, and Zhaoqing Yang","topic":"2","file":"1268-4983-1-DR-OK.pdf","bib":"TIDRES-1268.bib"},
{"paperid":"1270","title":"Retiring Environmental Risks: Facilitating Marine Renewable Energy Development through Accelerated Consenting","keywords":"Concerns about the potential effects of marine renewable energy (MRE) devices on the marine animals, habitats, and environment continue to slow siting and permitting/consenting of devices worldwide. Learning lessons and applying data collected from consented/permitted projects can help to move future regulatory processes forward. Transferring data and information from early projects and making that information readily available to regulators can help achieve this goal. Data from baseline assessments and post-installation monitoring programs should be collected consistently to more readily compare results and increase understanding of the environmental effects, supporting more efficient and shorter permitting/consenting processes, reducing uncertainty, and decreasing the financial risk for MRE development.   Under OES Annex IV, a data transferability process has been developed and vetted with the MRE community, consisting of four components: (1) data transferability framework; (2) approach to data collection consistency; (3) process for data discoverability; (4) best management practices for data transferability and data collection consistency.   Examples of consented/permitted projects from the UK, US, Canada, and other Annex IV nations have been developed as case studies to illustrate and test the process. The data transferability process, data collection and analysis consistency, and the international case studies will be presented. ","authors":"Andrea E. Copping, Mikaela C. Freeman, Alicia M. Gorton","topic":"9","file":"1270-4760-2-DR-OK.pdf","bib":"ENVIRO-1270.bib"},
{"paperid":"1271","title":"Mooring system reliability analysis of an ORE device using general Polynomial Chaos","keywords":"We present a reliability analysis of the mooring system designed for the Floating Power Plant P60 wave energy converter. However, instead of using Monte Carlo or analytic expressions to obtain the probability density functions, we apply generalised Polynomial Chaos (gPC). GPC has the advantage of, for a specified tolerance, reducing the number of simulations required to obtain the probability distribution of a quantity when compared with random sampling methods. In our case, the quantity of interest is the Most Probable Maximum tension in cables, computed in OrcaFlex, for a range of values of rope stiffness and water depth.   The mooring system analysed was designed to fulfil the requirements for offshore structures considering extreme sea states and it was optimized according to minimum lifetime cost by variation of line type and mooring layout. It was a deterministic design, based on safety factors.   The goal of the reliability analysis is to obtain the probability of failure of the mooring system, using the first order reliability method, and compare it with the reliability requirements of the standard DNV-OS-E301 - Position Mooring. In the analysis, we will account for uncertainties in both environmental and material parameters: water depth, cable stiffness, and cable breaking strength. The analysis is simplified, in that only three parameters are judged to have uncertainties. We will see that the mooring system analysed has a probability of failure one order of magnitude lower than required. This shows some of the disadvantages of using deterministic over probabilistic design.   ","authors":"Guilherme Moura Paredes, Jonas Bjerg Thomsen, Francesco Ferri and Claes Eskilsson","topic":"12","file":"1271-5011-1-DR-OK.pdf","bib":"MRGFND-1271.bib"},
{"paperid":"1274","title":"CCP-WSI Blind Test Series 2: A Nonlinear Froude-Krylov Modelling Approach","keywords":"The Collaborative Computational Project in Wave Structure Interaction (CCP-WSI) is an internationally coordinated effort aiming to standardize numerical modelling approaches to describe wave-structure interactions. The driver of this project is the necessity of building higher confidence in numerical hydrodynamic models, while creating a baseline of comparison for the large plurality of existing modelling approaches. On the one hand, the problem of WSI interactions representation can be tackled in a variety of ways, from velocity-potential-based models (linear, or partially-, weakly-, or fully-nonlinear), to Navier-Stokes-based models (computational fluid dynamics (CFD) or smoothed-particle hydrodynamics (SPH)). On the other hand, the accuracy strongly depends on the floater geometry and dimensions, wave and control conditions, making a meaningful comparison between different models in different publications challenging. Therefore, the objective of the CCP-WSI is to provide different institutions with the details of the same test case, in order to draw significant conclusions about the different modelling approaches implemented. The blind test approach is chosen, so that each participant has access only to input data (geometry, moorings, external loads), while output data (motion response) is hidden. Two geometries are considered, a cylinder with moonpool and a cylinder with hemispherical bottom. The geometries are allowed to move in all degrees of freedom (DoFs). Focused waves are considered, which can be challenging to model, due to large steepness and height, compared to the buoys height and draft. The modelling approach implemented in this paper is a partially-nonlinear model based on linear velocity potential theory. Diffraction and radiation forces are considered linear, based on the assumption that the diameter of the buoys is small compared to the wave length. On the other hand, a  novel and computationally efficient nonlinear representation of Froude-Krylov (FK) forces is implemented, since they are the most important hydrodynamic force component in point absorbers. Thanks to the axial-symmetry of the tested geometries, computationally convenient formulation of the nonlinear FK forces can be used. In fact, the main advantage of this modelling approach is the ability to achieve a good level of accuracy, despite the reduced computational time (with respect to fully nonlinear models). The objective of the paper is to study the performance of the nonlinear FK model under such demanding wave conditions. Its ability to articulate higher order effects is  discussed. A comparison with fully-linear and fully-nonlinear CFD simulations is also included, focusing on their computational time and accuracy, in order to evaluate how beneficial it is to implement a nonlinear FK force model in such conditions. ","authors":"Giuseppe Giorgi","topic":"5","file":"1274-4552-2-DR-OK.pdf","bib":"WAVHYD-1274.bib"},
{"paperid":"1275","title":"Discussion on the mode mixing in wave energy control systems using the Hilbert-Huang transform","keywords":"Recent studies have shown that tuning the power take-off (PTO) damping of a wave energy converter to time-frequency estimations obtained from the Hilbert-Huang transform (HHT) result in greater energy absorption than tuning the PTO to a constant frequency of the wave spectrum, or to time-frequency estimations from the extended Kalman filter [1] .  The HHT method relies on the use of the empirical mode decomposition (EMD) to decompose the wave signal into a number of components (intrinsic mode functions, IMFs) from the highest to the lowest frequency. However, the decomposition process may result in mode mixing, and an IMF will consist of signals of widely disparate frequency scales, or different IMFs will consist of signals with similar frequency scales. Mode mixing can be caused by an intermittent/noisy signal, and by specific amplitude and frequency relations of the original modes in the signal.  The aim of this paper is to extend the studies on the use of the HHT for tuning purposes of wave energy converters by verifying how the EMD mode mixing problem affects the WEC performance. Thus, a comprehensive study using initially two-tones signal (superposition of two sinusoidal waves) will be performed.   In order to illustrate the mode mixing phenomenon, Figure 1 shows a summary of how the EMD behaves for two-tones signal [2]. Two well-defined regions (Fig. 1.a) are observed depending on the amplitude and frequency ratios of the original modes: the white region indicates a perfect separation of the two components, and the darkest region indicates the separation is not perfect. In such a case, the EMD either consider the signal as a single modulated component or it does something else. Furthermore, it is important to distinguish between the single modulated component area and the area which EMD does something else. Notice that in the single modulated component area the first IMF should be equal to the original signal. Figure 1.b illustrates a comparison of the first IMF with the original signal for the cases when the separation of components is not perfect. Therefore, three domains are defined [2]: (D1) the components are separated and correctly identified; (D2) the components are considered as a single waveform; (D3) the EMD does something else (the darkest areas in Fig. 1.b), either the components are halfway between D1 and D2 or fake oscillations might derive from the decomposition process. Thus, this study will initially verify how the map (Fig. 1.b) affects the power absorbed by the WEC when the HHT is applied for tuning purposes in two-tones signal. The analysis will focus on domains that present mode mixing (D2 and D3) and will be then extended to real ocean waves from the Northeast coast of Brazil.  References:   [1] P.B.Garcia-Rosa, J.V.Ringwood, O.B.Fosso, M.Molinas, The impact of time-frequency estimation methods on the performance of wave energy converters under passive and reactive control (Accepted for publication DOI: 10.1109/TSTE.2018.2870966);  [2] G.Rilling, P.Flandrin, One or two frequencies? The empirical mode decomposition answers, IEEE Trans. Signal Processing, 56(1), 2008.       ","authors":"Paula B. Garcia-Rosa, Marta Molinas, and Olav B. Fosso","topic":"7","file":"1275-4841-2-DR-OK.pdf","bib":"GRDPTO-1275.bib"},
{"paperid":"1276","title":"First round of MaRINET 2 Tidal Energy Round Robin Tests: combined wave and current tests","keywords":"Prototype testing is an integral part of the development process for many technologies. Testing at small scale can be relatively quick and inexpensive, while testing within a controlled environment enables experiments to be repeated for a range of different parameters. However, uncertainties on the experimental results can also be related to laboratories, even when similar protocols are being followed. Therefore, a Round Robin test is designed to enable first stage quantification of a facility’s impact on the technology being tested and on the quality of the tests results. This results in the same testing program being repeatedly undertaken on the same device model and monitoring program at a number of facilities so that variations in term of results can be identified and the causal factors investigated and quantified.            A previous comparative ‘‘Round Robin’’ test program was conducted, as part of the FP7 MaRINET program, to evaluate the impact of four facilities on the performance of a scaled tidal turbine [1]. This first Round Robin test was focused on the investigation of a tidal stream turbine under unidirectional flow of constant velocity,        i.e.        with no or low flow turbulence and approximately uniform velocity profile with depth. It was concluded that the influence of turbulence induced in flume based test facilities was about as significant as the blockage effects due to the difference in the size of the facilities, once Reynolds independence was established.              Building on this previous Round Robin test, a second Round Robin program is conducted within the H2020 MaRINET 2 program. This project extends the first program to capture the effects that the facilities may have on the power capture performance when the turbine is subjected to wave and current interactions. A three bladed horizontal axis turbine developed by Ifremer is used for entire program [2], similar to  the one utilized during the first Round Robin test. The hub includes instrumentation to measure rotor torque and thrust as well as edgewise, flap-wise and pitching bending moments at the root of each of the blades. Acoustic Doppler Velocimeter, Laser Doppler Velocimeter and wave probes are used for the flow characterisation: wave-current conditions and water surface elevation.             The second Round Robin test program aims to collect data from four facilities by end of 2019. At EWTEC 2019, we will present the results obtained in the first two selected facilities: the Ifremer wave and current circulating tank [3] and the CNR-INM wave towing tank. These facilities were selected on the basis that their dimensions along with the rotor diameter of the turbine translate into low blockage ratio conditions and that both facilities can afford the same range of experimental conditions. The experimental campaigns have been carried out in 2018      . T      he data comparisons are ongoing but a first glance of the turbine’s power performance obtained during the Ifremer testing campaign can be observed in Figure 2.        [1] Tidal Energy Round Robin Tests, B. Gaurier &amp; al., IJOME, 2015.     ","authors":"Benoît Gaurier, Stéphanie Ordonez-Sanchez, Jean-Valéry Facq, Grégory Germain, Cameron Johnstone, Rodrigo Martinez, Ivan Santic and Francesco Salvatore","topic":"4","file":"1276-4717-2-DR-OK.pdf","bib":"TIDDEV-1276.bib"},
{"paperid":"1279","title":"Definition of metrics and significance hydrodynamic mode-maps for BEM mesh convergence analysis","keywords":"In the topic of wave energy converter (WEC) modelling, boundary element methods (BEMs) are one of the most utilised tools, especially in the early-stage device design, thanks to their lower computation effort, if compared to computational fluid dynamics (CFD) or smoothed particle hydrodynamics (SPH). The accuracy of BEM calculation can be increased by reducing the mesh panel size, but only paying the price of a higher required computation time. Therefore, the balance between the required accuracy and the computation time has to be the result of a pragmatic compromise. The utilised mesh can be considered sufficiently fine, if a further mesh resolution increment does not bring significant changes in the calculated BEM hydrodynamic curves. In the case of a single floating body with 6 degrees of freedom (DoF), 36 different added mass curves are calculated, together with 36 different radiation damping curves and 6 excitation force curves; therefore, even in the case of a single body, the visual inspection of the BEM results could be long and onerous. Furthermore, in the case of multiple body WECs or WEC arrays, the number of the hydrodynamic curves to inspect could increase considerably. For example, in the case of an array with 20 bodies, the visual inspection would involve 14,400 hydrodynamic curves only for the radiation impedance damping matrix! It is clear that the visual inspection of BEM hydrodynamic parameters could be too arduous and time consuming; therefore, the use of metrics for an automatic convergence analysis is very desirable. This paper proposes the definition and the use of a metric, to be applied to the BEM results, in order to automatically calculate if a given mesh is sufficiently fine, or if a further resolution increment is required. In this way, the BEM computing time can be optimised, removing unnecessary and unjustified overtime calculations, which wouldn’t bring any significant improvement. This is a crucial point, since the excessive calculation time could make the use of BEMs unfeasible. In the case of multiple body WECs or WEC arrays, wave radiation and scattering can generate unexpected interaction effects between the different modes of the system; therefore, the paper also proposes the definition and use of “Significance hydrodynamic mode-maps”, in order to visualize the more relevant modes of the multiple body system. The paper presents the use of the defined tools in the study of a floating body array, illustrating the calculation of the most significant modes of the system and the optimum compromise for the BEM mesh resolution. ","authors":"Simone Giorgi, Ronan Costello and Ben Kennedy","topic":"5","file":"1279-4994-1-DR-OK.pdf","bib":"WAVHYD-1279.bib"},
{"paperid":"1280","title":"A novel wave-energy device with enhanced wave amplification and induction actuator","keywords":"A novel wave-energy device will be presented. Both a preliminary proof-of-principle of a working, scaled laboratory version of the energy device will be shown as well as the derivation and analysis of a comprehensive mathematical and numerical model of the new device. The wave-energy device consists of a convergence in which the wave energy is amplified, a constrained wave buoy with a (curved) mast and direct energy conversion of the buoy motion into electrical power via the (linear) induction motor, see the accompanying figure. The wave-energy device is designed for use in breakwaters and it is possible to take the device out of action during severe weather. The idea of wave-focusing in a contraction emerged due to our work (OB&amp;AK) on creating and simulating crossing rogue waves at sea, including a “bore-soliton-splash”. We have recreated and modeled such crossing seas in the laboratory and in simulations by using a geometric channel convergence. Our design is a deconstruction of elements of existing wave-energy devices, such as the TapChan, IP wave-buoy and the Berkeley Wedge, put together in a different manner to enhance energy conversion and, hence, efficiency. Novel is also our mathematical and numerical modeling. We will present one monolithic variational principle, including the combined (potential-flow) hydrodynamics, the buoy motion and the power generation via the induction motor, to which we have added, a posteriori, the dissipative elements such as the electrical resistance of the circuits and power loads. Moreover, our numerical modeling is a direct and consistent discretization of this comprehensive variational principle. We will show preliminary numerical calculations of the wave-energy device, concerning the linearized dynamics, and are in the process of optimizing its efficiency.       Figure: Artistic rendering of the rogue-wave-energy device corresponding to our initial laboratory set-up, with magnets and LEDs, the latter connected in parallel. Courtesy: Wout Zweers. See also Anna Kalogirou’s YouTube channel for simulations/movies of the experiments:  https://www.youtube.com/channel/UCUZAYHtVoiMqepQflisp66g","authors":"Onno Bokhove, Anna Kalogirou, David Henry, and Gareth P. Thomas","topic":"5","file":"1280-4640-3-DR-OK.pdf","bib":"WAVHYD-1280.bib"},
{"paperid":"1283","title":"Simulation of Digital Displacement Hydraulic Power Take-Off for Wave Energy Converters","keywords":"Developing power take-off (PTO) systems for wave energy converters (WECs) which can cope with the high ratio of peak to mean power in ocean waves, and are fully controllable is a significant challenge. The quantised PTO in Pelamis was proved to be an efficient (88-94% primary transmission efficiency [1]) way of dealing with high peak loads, but the quantised torque meant that no smooth optimising control strategy could be supported. Under the Wave Energy Scotland (WES) PTO Stage 3 project, the Pelamis quantising system will be combined with Artemis Digital Displacement ® technology to produce the Quantor PTO, which will have smooth and fully controllable PTO torque.  Artemis are specialists in producing highly efficient and controllable hydraulic pump-motors, which were originally designed for the challenging requirements of wave PTO systems.   A dry test rig with a rating of 300kW has been constructed on Artemis premises with a significant physical inertia and the capability to simulate the motion of a WEC in an irregular sea. The Quantor PTO will be tested on this rig in the coming months, demonstrating its power-handling performance and control stability in representative conditions. The test rig was carefully modelled in Simulink and its performance validated as representative of various WECs in a range of irregular seas. The Quantor PTO was also extensively modelled, including detailed representations of the hydraulic circuit. This Quantor PTO model will be validated on the test rig, proving its performance.  This paper will discuss the design of the Quantor PTO, the modelling and validation of the test rig and the modelling and testing to date of the Quantor PTO.      Figure 1: Quantor PTO operating principle, where the quantised load is smoothed by the contribution of the Digital Displacement Pump Motor (DDPM) [2]     Figure 2: General assembly of wave PTO test rig and Quantor PTO; in the centre foreground is the DDPM and generator assembly, the red accumulators on the left are part of the Quantor PTO hardware and the large grey flywheel in the centre provides the rig inertia, which is controlled by the 300kW electric motor on the right.      [1]     R.Henderson, “Design,   simulation, and testing of a novel hydraulic power take-off system for the   Pelamis wave energy converter,”  Renewable Energy,  vol. 31, no. 2, pp.   271-283, 2006.       [2]     Artemis Intelligent   Power, “Hybrid Digital Displacement ® hydraulic PTO for wave energy: WES   Power Take Off Stage 2 Project Public Report,” Wave Energy Scotland, 2017.        ","authors":"Sarah Acheson, Ross Henderson and Daniil Dumnov","topic":"7","file":"1283-5042-1-DR-OK.pdf","bib":"GRDPTO-1283.bib"},
{"paperid":"1285","title":"Numerical study of an inclined OWC chamber combined breakwater and turbine interaction under waves","keywords":"In this study, a breakwater effect on the performance of OWC-type wave energy converter is numerically investigated, respectively an inclined OWC chamber. A time-domain numerical method based on a three-dimensional potential flow solver is applied to wave field around an inclined OWC chamber with breakwater. Boundary value problem of Laplace equation is directly solved by using a finite element method. To validate the present numerical method, the simulation results were compared with the model test data about three-dimensional unit inclined OWC chamber.   The response of an inclined OWC chamber was analyzed based on the velocity and differential pressure of the airflow developed by the motion of the water column and surface elevation inside the chamber. The relationship between the response of the inclined OWC chamber and the surrounding wave field transformed by the breakwater and OWC chamber was analyzed. Generally, the standing waves parallel to the front of the breakwater are developed. On the other hand, at the front of the breakwater where the inclined OWC chamber is installed, the spatial distribution of the standing waves in the transverse and latitudinal directions appears, due to the influence of excited flow motion of the water column. The spatial distribution of the standing wave has a complex interrelationship depending on the incident wavelength and the characteristics length of the OWC chamber and breakwater. Also, the spatial distribution of the standing wave around the chamber affected the performance of the inclined OWC chamber. ","authors":"Jeong-Seok Kim, Bowoo Nam, Kyong-Hwan Kim, Sewan Park, Keyyong Hong","topic":"5","file":"1285-4470-3-DR-OK.pdf","bib":"WAVHYD-1285.bib"},
{"paperid":"1289","title":"A novel point absorber wave energy harvester with a Scotch Yoke mechanism","keywords":"Ocean waves energy harvesting is not a new idea; the concepts have emerged since the late eighteen hundreds. Wave energy harvesters (WECs) and especially point absorbers are very theoretically mature, but only a handful of devices were tested at full scale levels and there is very limited or no commercial WEC development. There are many reasons for the retardation of industrial development; One of the main reasons is the difficulties for testing at full scale levels because of the harsh ocean waves environment , and another one is that most of the Power Take Off (PTO) techniques used with WECs, and especially point absorbers are linear generators, which are very expensive to manufacture. Therefore, this paper suggests a novel PTO concept, based on the scotch yoke mechanism where the harmonic linear motion of the buoy is transferred to rotary motion of a shaft connected to an off the shelf generator. The mechanism is designed and simulated to work with a point absorber WEC. The linear to rotary mechanism equations are incorporated with a hydrodynamic model and solved. Ansys Aqwa is used to simulate the hydrodynamic properties, and matlab is utilized to solve the full dynamic equations. The novel WEC PTO device with a Scotch Yoke mechanism is compared to the WEC PTO device with a crank slider mechanism which has already been developed and studied in the literature. The comparison of the power output, shaft rotational velocity, and general characteristics of both the PTO devices will be focused. The scotch yoke mechanism offers many advantages, such as the fact that the motion is harmonic, which makes it very compatible with the harmonic nature of ocean waves. Also it’s an old and very mature mechanism, which renders the PTO cheap to manufacture and robust, pushing the WEC development closer towards industrial development. Finally, the device doesn’t really rely on resonance to capture power, this translates to even simpler concepts, as the buoy doesn’t have to be immense in dimensions to resonate with high ocean waves periods, and control algorithms don’t have to be complex to increase the capture width ratio of the novel WEC. The device can also be designed to be fixed to oil rigs or moored ships, as it can operate both on and off shores. The hydrodynamic model can be linearized to be solved in the linear frequency domain. As the scotch yoke PTO mechanism is nonlinear, one must run the simulations in the time domain. Only regular waves are covered in this paper, with irregular waves, the scaled down experimental testing, optimization studies and the possibility of incorporating control algorithms are set for future work. This paper mainly focuses around the design concepts and simulation analysis and the advantages/disadvantages of the novel mechanism.   Keywords: wave energy converter, point absorber, power take off, linear to rotary mechanism, scotch yoke. ","authors":"Elie Al Shami, Xu Wang, Zhenwei Liu","topic":"3","file":"1289-4669-2-DR-OK.pdf","bib":"WAVDEV-1289.bib"},
{"paperid":"1294","title":"CCP-WSI Blind Test Series 2: Assessment of focused wave impacts on floating WECs using OpenFOAM","keywords":"The presented work represents an individual contribution to the CCP-WSI Blind Test Series 2, in which the submitted results are compared against both physical and alternative numerical solutions for varying wave steepness achieved through changes in peak frequency. Reducing the time taken to provide reliable results is critical if computational fluid dynamics (CFD) is to become a routine design tool for offshore renewable energy devices. This can potentially be achieved by simplifying simulation setup, and hence reducing the required man-hours, through standardised `best practice' procedures. Therefore, in the absence of validation data, the scope of this study is to provide a `blind' estimation of numerical accuracy in simulations of focused wave interactions with floating wave energy converters (WECs).  The present numerical results are obtained using open-source CFD with waves generated via linear superposition of first order wave components, derived from empty tank data. Two geometries are considered and the effect of wave steepness on surge, heave and pitch motion, along with the load in the mooring, is examined. Based solely on the reproduction of the known empty tank data, the numerical predicitons are estimated to be within 10% of the experimental data in peak motion and mooring loads. ","authors":"Scott A. Brown, Edward J. Ransley, Deborah Greaves","topic":"5","file":"1294-5026-1-DR-OK.pdf","bib":"WAVHYD-1294.bib"},
{"paperid":"1295","title":"The effects of surge motion on floating horizontal axis tidal turbines","keywords":"Wave-induced motions due to actual sea state conditions will impact on the performance of floating horizontal axis tidal turbine systems. This paper presents the results from numerical simulations of a 3-bladed horizontal axis tidal turbine oscillating in surge motion in a moving reference frame. The optimum tip-speed ratio, = 4.4 and  k-? SST  turbulence model was used in the present study. Modification to the Navier-Stokes equation was made by adding an inertial term to the right-hand side of the equation and the Dirichlet boundary condition was also modified in order to simulate in the moving reference frame. Three tests were conducted which varies the parameters of oscillation which are the ratio of surge amplitude over the radius of the rotor,  A* , frequency ratio,  ?* , and tip-speed ratio. These tests were conducted to study the effects of each parameter to the hydrodynamic performance of the tidal turbine. The result shows that stalling effects occur when the velocity relative to the rotor is at the maximum. In certain cases, negative thrust and power coefficients were found when the velocity relative to the rotor is at the minimum. The fluctuation amplitude of the loading increases together with the amplitude and frequency of oscillation, which will contribute to the fatigue on the rotor.  The inertial and damping coefficients for a range of  A*  and * were presented in this paper and the occurrence of negative inertial and damping coefficients was also explored.","authors":"Mohamad H. B. Osman, Richard H. J. Willden, and Christopher R. Vogel","topic":"6","file":"1295-4903-1-DR-OK.pdf","bib":"TIDHYD-1295.bib"},
{"paperid":"1296","title":"Wave power extraction from a multi OWC platform","keywords":"I. KEYWORDS       Wave energy, Hydrodynamics, Analytical model, OWCs, Power extraction.       II. ABSTRACT       In this paper, a rectangular barge consisting of multiple oscillating water columns (OWCs) is considered, hereinafter referred to as a multi-OWC platform. Each OWC chamber is enclosed by two vertical side walls with its bottom submerged and open to the sea (see Fig. 1). As ocean waves propagate through the multi-OWC platform, the water column enclosed in each chamber rises and falls, causing an oscillating air pressure inside the chamber and driving the air to flow through a turbine installed at the chamber top.       In previous analytical models of the hydrodynamics of OWCs, to the best of the authors’ knowledge, either a thin-wall restriction or a shallow draught restriction has been applied [1~3]. Instead, in this work an analytical model based on linear potential flow theory and eigen-function expansion method is developed to solve wave diffraction and radiation problems from the multi-OWC platform with neither the thin-wall nor the shallow draught restriction [4-6]. In other words, the effect of both the thickness and the draught of the walls of the OWC chambers is taken into consideration in the present model.       The wave excitation volume flux of each OWC and the hydrodynamic coefficients are evaluated based on the diffracted and radiated velocity potentials, respectively. The hydrodynamic interaction between the motions of every two OWCs is considered. Additionally, an indirect method based on the Haskind Relation is adopted to calculate certain hydrodynamic coefficients [4], the comparison of which with those obtained from the direct method can be used to validate the correctness of the analytical model.       Assuming the effect of the turbine and air compressibility as a linear power take-off (PTO) system [7], the analytical model is further applied to calculate the motion response, power absorption, and reflection/transmission coefficients of the multi-OWC platform. The energy conservation relationship is also checked to indirectly validate the present analytical model.       A relevant advantage of the analytical model is its computational efficiency and accuracy, which allow us to carry out a sensitivity analysis on a large range of device parameters. Specifically, the effects on the power extraction of the multi-OWC platform of the PTO coefficients, the number of constituent chambers, the overall device dimensions and the relative dimensions of adjacent chambers (width, thickness and draught of chamber walls) are investigated.         References       [1] Evans and Porter, 1995. Hydrodynamic characteristics of an oscillating water column device. APOR.       [2] Falnes and McIver, 1985. Surface wave interactions with systems of oscillating bodies and pressure distributions. APOR.        [3] Noad and Porter, 2017. Wave energy absorption by a shallow-draughted rectangular barge of oscillating water columns. 12   th    EWTEC   .       [4] Falnes, 2002. Ocean waves and oscillating systems. Cambridge University Press, Cambridge.       [5] Zheng and Zhang, 2016. Wave diffraction and radiation by multiple rectangular floaters. JHR.       [6] Zheng and Zhang, 2018. Analytical study on wave power extraction from a hybrid wave energy converter. OE,     [7] Sarmento and Falcão, 1985. Wave generation by an oscillating surface-pressure and its application in wave-energy extraction. JFM.         ","authors":"Siming Zheng, Alessandro Antonini, Yongliang Zhang, Jon Miles, Gregorio Iglesias","topic":"5","file":"1296-5054-1-DR-OK.pdf","bib":"WAVHYD-1296.bib"},
{"paperid":"1303","title":"CFD surface effects on flow conditions and tidal stream turbine performance","keywords":"There is a rising demand for energy around the world and yet a finite supply of fossil fuels. This, amongst other environmental concerns, has provoked increased research and development into identifying sources of sustainable energy. Tidal energy is an abundant resource in the UK and has an estimated potential of 18 TWh / year [1]. With over half the world’s tidal energy developers being based in the EU [2], the industry is beginning to grow and have a positive impact.   The diurnal tidal flow is a predictable and regular form of renewable energy, where Tidal Stream Turbines (TST’s) can extract energy from these flows to generate electrical energy. The ocean is a harsh, very complex and diverse environment, where challenging conditions arise from interaction between tidal currents, surface waves and turbulence from the bathymetry of the seabed. These conditions can make the operation and maintenance of full-scale devices very difficult. Experimental testing of model scale TST’s has therefore been carried out in tow tanks and recirculating flume facilities. These facilities can be used to establish a wide range of flow conditions and investigate the loadings and performance on a turbine.   Computational Fluid Dynamics (CFD), in more recent years, has been used to create numerical models as a cheaper alternative to experimental testing. These numerical models can replicate experimental conditions and investigate TST operation in various subsea flow conditions, as found in [3]–[5]. Although all flume tanks possess a free surface experimentally, most CFD modelling is done without and uses adjusted boundary conditions instead. This is because it is important to have an increased mesh resolution at the fluid interface and in doing this, increases the overall size of the mesh and therefore the run time of the model. This paper aims to investigate the differences of the surface boundary conditions in a model with and without a free surface. The simulations will model one TST in a uniform flow condition with comparable meshes in order to isolate the variation of the surface effects and directly compare them. Experimental data from the French Research Institute for Exploitation of the Sea (IFREMER) is then used to make comparisons with, and validate the accuracy, of each model.   [1]         Black and Veatch Ltd, “UK Tidal Current Resource and Economics,” 2011.   [2]         European Commission,  Strategic Energy Technology Plan . 2017.   [3]         R. McSherry, J. Grimwade, I. Jones, S. Mathias, A. Wells, and A. Mateus, “3D CFD modelling of tidal turbine performance with validation against laboratory experiments,”  EWTEC 2011 Proc. , 2011.   [4]         C. H. Frost, P. S. Evans, M. J. Harrold, A. Mason-Jones, T. O’Doherty, and D. M. O’Doherty, “The impact of axial flow misalignment on a tidal turbine,”  Renew. Energy , vol. 113, pp. 1333–1344, 2017.   [5]         M. E. Harrison, W. M. J. Batten, L. E. Myers, and A. S. Bahaj, “Comparison between CFD simulations and experiments for predicting the far wake of horizontal axis tidal turbines,”  IET Renew. Power Gener. , vol. 4, no. 6, pp. 613–627, 2010. ","authors":"Catherine Lloyd, Matthew Allmark, Robert Ellis, Stephanie Ordonez, Allan Mason-Jones, Cameron Johnstone, Tim O’Doherty, Gregory Germain and Benoit Gaurier ","topic":"6","file":"1303-4902-1-DR-OK.pdf","bib":"TIDHYD-1303.bib"},
{"paperid":"1306","title":"Preliminary design of a hybrid wave energy converter integrated into a rubble mound breakwater","keywords":"The development of the wave energy sector is expected to benefit significantly from the creation of synergies with other sectors, as pointed out by the International Renewable Energy Agency [1]. Hence, opportunities must be found for the multi-purpose use of already existing or proposed marine and harbour infrastructures.This can be achieved, for instance, by integrating wave energy converters (WECs) into breakwaters, which are designed to promote the dissipation of wave energy, creating sheltered conditions for port activities. Moreover, ports are infrastructures with substantial and quantifiable energy demands, being often a major source of air pollution and other environmental impacts.Many ports worldwide already started the transition to cleaner energy sources in order to decarbonize their activities and meet their future renewable energy targets. The high potential of port breakwaters for the integration of WECs, due to their high exposure to ocean waves, triggered the European SE@PORTS project, which intends to demonstrate that this approach is a win-win solution for both breakwaters and WEC solutions. Despite the lack of investment in the application and utilization of WECs at ports, such concepts have already been proposed and some onshore pilot projects exist, but most of them are based on the application of an Oscillating Water Column (OWC) only, e.g., Mutriku in Spain [2], REWEC3 in Civitavecchia [3].The present paper discusses the development of a cost-efficient and flexible hybrid WEC concept to harness energy at sea ports, while ensuring their functionality, reliability and robustness. In this work the preliminary design of this novel solution, integrated into the proposed extension of the rubble-mound breakwater at the Port of Leixões, Porto, Portugal [4] (one of the case studies of SE@PORTS), is presented .The hybrid WEC combines the overtopping and oscillating water column principles, taking into consideration the characteristics of the harbour infrastructure. A wave-to-wire model in MATLAB Simulink was developed to estimate the performance of this innovative concept and to assist in the improvement of its design. The results of the preliminary numerical simulations are presented in this paper.  References  [1] IRENA (International Renewable Energy Agency), “Wave Energy - Technology Brief,” 2014.  [2] Y. Torre-Enciso, I. Ortubia, L. De Aguileta, and J. Marqués, “Mutriku Wave Power Plant: from the thinking out to the reality,” in 8th European Wave and Tidal Energy, 2009, pp. 319–329.  [3] F. Arena, A. Romolo, G. Malara, and A. Ascanelli, “On Design and Building Of a U-OWC Wave Energy Converter In The Mediterranean Sea: A Case Study,” in Proceedings of the ASME 2013 32nd International Conference on Ocean, Offshore and Arctic Engineering, 2013, pp. 1–8.  [4] C. Juana Fortes et al., “Estudos realizados com vista à melhoria das condições de segurança do acesso marítimo ao porto de Leixões,” in 9as Jornadas Portuguesas de Engenharia Costeira e Portuária, PIANC Portugal, LNEC, Lisboa, Portugal [In Portuguese], 2017, pp. 1–25. ","authors":"Ashank Sinha, Pedro Mendonça, Filipe Belga, Henrique Cestaro, Tiago Morais, Daniel Clemente, Tomás Cabral, Francisco Taveira-Pinto, Paulo Rosa-Santos , Hugo Guedes Lopes","topic":"3","file":"1306-5014-2-DR-OK.pdf","bib":"WAVDEV-1306.bib"},
{"paperid":"1307","title":"Surface profile prediction from bottom pressure measurements with application to marine current generators","keywords":"There is a requirement for wavepower applications to predict the wavefield at a Wave Energy Converter (WEC), particularly for the application of control algorithms.  Often this involves the measurement of the incident wavefield at one or more locations and an approximate method is then employed to predict the incident wavefield in the vicinity of the WEC.  This topic is both an interesting and difficult one and one relevant study has previously been reported in EWTEC in [10].   For marine current generators a similar requirement arises, with horizontal and vertical variations in the current being associated with the additional difficulty of the current possessing horizontal and vertical distributions of vorticity.  One demonstration of the importance of vorticity to the local kinematics is given in [8].   Accurate measurement of the surface wavefield, from which the wave kinematics may be determined, is not a trivial task.  In the absence of a non-uniform current, where the wavefield is irrotational, there is a substantial body of recent work associated with the measurement of the pressure at or near to the bed and the use of transfer functions to determine the free surface motions ( cf . [1,4,5]).  This is not universally useful, since it depends upon a classification of the wavefield and a reasonable practical correlation between the pressure at the bed and at the free surface.  However, in appropriate circumstances it can provide a valuable input into the wave prediction algorithms.   For marine current generators, there is less applicable work but there is the important advantage that most devices are fixed to the sea bed and not restrained by the wave classification difficulty identified above.  Flows with vorticity are relevant in several physical contexts and techniques originating in coastal and nearshore engineering may be adapted to be for direct use for the description of the wavefield in the vicinity of marine current generators.   The modelling of wave-current interactions possesses a rich history ( cf . [3,6,7,9]), yet the presence of vorticity immediately introduces major mathematical complications into modelling considerations.  Improving the understanding of the relationship between the dynamic pressure function and the underlying fluid kinematics for rotational ocean waves has implications for both wave and tidal resource characterization.   Using a novel pressure-streamfunction reformulation of the governing equations recently derived by the authors in [2], an explicit formula was obtained in terms of series solutions detailing the relationship between the pressure, streamfunction and the vorticity distributions.   This paper considers the pressure-streamfunction relationship for a train of regular water waves propagating on a steady current, which may possess an arbitrary distribution of vorticity, in two dimensions.  The application of such work is targeted towards marine current generators.  In particular, for linear waves, a description is provided of the role which the pressure function on the sea-bed plays in determining the free-surface profile elevation.  The approach is shown to provide a good approximation for a range of current conditions.  References:     ","authors":"Alan Compelli, David Henry and Gareth P. Thomas","topic":"6","file":"1307-5002-1-DR-OK.pdf","bib":"TIDHYD-1307.bib"},
{"paperid":"1309","title":"Performances of a breakwater for wave energy conversion","keywords":"To break the economical barrier that still holds the Wave Energy Converters (WECs) behind the brink of commercialization, several researchers are developing devices integrated in traditional breakwaters. This allows to exploit the consequent management and economic advantages, such as: i) easier access to the device, which simplifies its construction, maintenance and connection to electrical grid; ii) similarity with the traditional rubble mound breakwaters, which simplifies both design and construction activities; iii) reduced sea waves intensity compared to offshore sites, which diminishes the mechanical stress undergone by the device (as well as the amount of energy extractable).   A new WEC called OBREC (Overtopping BReakwater for Energy Conversion) has been recently conceived (see Figure 1). Such a device is totally embedded in a traditional rubble mound breakwater and it can extract energy from the overtopping discharges. It consists of a concrete frontal ramp that reduces the friction of the breakwater facilitating the overtopping of the waves into a reservoir above the sea level, to maintain a flow from the reservoir to one or more low-head turbines.   Nowadays the optimization of a device requires to carry out physical model experiments or time expensive numerical simulations based, for example, on the Reynolds Averaged Navier-Stokes Equation. To overcome such limits a numerical model based on a stochastic approach of the overtopping discharges is proposed.   More in details, the performance of the OBREC was recently tested in the Hydraulic Laboratory of the University of Catania, with the purpose of identifying the probability distribution of the overtopping volumes for an OBREC device. This validated method has represented the basis for the implementation of a numerical model able to simulate the behavior of the OBREC operating under any assigned sequence of sea states.   The model was applied to optimize a new device to embed in the new breakwater of the port of Bosa Marina (Sardinia, Italy). The analysis carried out allow to identify the most relevant parameter which could influence the device performance: the height of the ramp above the sea level (R r ), the height of the bottom of the reservoir above the sea level (h s ), the length of the submerged ramp (d d ) and the number of turbines installed (N). The influence of such parameters on the output power of the OBREC has been evaluated, so allowing to correctly dimension the device (see Figure 2).   ","authors":"Federico Castiglione, Luca Cavallaro, Claudio Iuppa, Pasquale Contestabile, Diego Vicinanza, and Enrico Foti ","topic":"3","file":"1309-5001-1-DR-OK.pdf","bib":"WAVDEV-1309.bib"},
{"paperid":"1311","title":"Introducing the Theory of Constraints to explore the tidal and marine energy supply chain","keywords":"This paper presents the importance of understanding supply chain capacity for the production and implementation of tidal technologies enabling the sustainable future of the industry sector.  The research incorporates identified risks and barriers to explore the renewable technology supply chain from a systems perspective via the Theory of Constraints (ToC) approach.  The methodology enables a holistic supply chain exploration of the Undesirable Effects (UDE) via a Current Reality Tree diagram.  Identifying the UDE of the system will promote discussion into the areas of focus to enable the future needed rapid capacity growth requirements to expand and develop the tidal energy sector supply chain.  Using the ToC Current Reality Tree within a holistic supply chain context, therefore, allows the exploration of the interconnectivity of the sector as a whole, through a systems thinking approach.  This offers a high level strategic view of the renewable sector supply chain ensuring the wider context of the whole system can be examined.  The ToC approach provides an effective way of understanding the impact of a range of factors across the Triple Bottom Line.  The paper presents the research findings that there are three key area's of focus impacting the tidal industry sector's sustainable future.  Firstly the political aspect of shaping policy developmanet and implementation that is critical to tidal technologoes.  Secondly, the social dimension which is evident in the identified skills agenda.  Finally the research analysis showed that the supply chain investment and development is fundemental to the economic reality for the sectors growth.  The detailed mapping of these factors enables the constraints and opportunities within the wider environment to be visible to multiple stakeholdrs who will shape the furture tidal sector. ","authors":"Rachel K. Mason-Jones, Paul Davies, and Andrew J. Thomas","topic":"10","file":"1311-4830-2-DR-OK.pdf","bib":"ECONOM-1311.bib"},
{"paperid":"1313","title":"Power capture gains for the WaveSub submerged WEC using active control","keywords":"WaveSub is a submersed point absorber with a unique multi-tether configuration and variable geometry which can be tuned to the prevailing sea state. A float moves with the waves and reacts against a moored reactor. The tethers are sprung and pull on rotational drums which are attached to a PTO providing damping. WaveSub has geometric controllability also – the float-reactor separation is adjustable for mean sea state tuning and survivability. It is modular in construction, allowing multiple units to be combined. Figure 1 shows an illustration of a full-scale three-float WaveSub system. The block diagram of the complete system is shown in Figure 2.         Fig. 1  Illustration of full-scale WaveSub WEC with 3-float configuration                            Fig. 2  Block diagram representation of WEC/PTO systems        A 1:25 scale WEC-Sim model of a single float system using four PTO tethers and a taut mooring system has been validated against experimental data from wave tank testing. A full-scale WEC-Sim model has been extrapolated from the 1:25 scale model and is the subject of this study. The optimum passive spring-damper combinations have been established across the full range of operational irregular sea conditions and this system is used as a benchmark for performance comparison against an actively controlled PTO system.  The active control system is based upon the Simple and Effective method, whereby a float velocity trajectory is evolved from the estimated wave excitation force acting on the float for each relevant degree of freedom.  The wave excitation force instantaneous amplitude and frequency are estimated using an Extended Kalman filter and used to generate the 6DOF velocity trajectory. Position constraints are incorporated into the velocity reference to prevent the float from impacting on the reactor. A linearised state-space model of the WEC system is developed, including fourth-order approximation of radiation damping. This State-space model is used to design a fully coupled six degree of freedom controller to enforce velocity tracking through the action of the PTO. The controller uses the Linear Quadratic Integral architecture and the weighting matrices are tuned to balance tracking performance against control effort. The active and passive (optimal) systems were tested with the full-scale WecSim model across a wide range of simulated irregular sea states. Figure 3 shows a typical velocity tracking result for surge and heave motion. The differential power matrix is shown in Figure 4. These initial results are for 4-quadrant control and indicate that a power gain of up to 61% is possible across the most commonly occurring operational sea states. The full paper will present updated results for both four and two-quadrant control together with discussions of robustness and practical implementation.     Figure 3 – Velocity reference and tracking performance under active control in surge and heave DOFs. Irregular sea state with peak period Te = 6s and significant wave height Hs = 3m.                             Figure 4 – Power matrix showing power percentage increase compared to optimal passive benchmark system for a range of irregular seas with peak period Te and significant wave height Hs.  ","authors":"Andrew J. Hillis, Craig Whitlam, Annette Brask, John Chapman and Andrew R. Plummer","topic":"7","file":"1313-4799-3-DR-OK.pdf","bib":"GRDPTO-1313.bib"},
{"paperid":"1315","title":"Web-based atlas to facilitate marine renewable energy site selection in western Canada","keywords":"Growing concern regarding climate change and increased emphasis on sustainable decision making has sparked an interest in renewable energy, with great attention and focus being directed toward energy harnessed from tidal, wave, and river hydrokinetic resources. Despite a growing body of research and technological advances, deployment of marine renewable energy (MRE) devices within Canada remains relatively low, with the exception of a few exploratory technology demonstrations. Previous research has shown that Canada’s coastal regions are abundant in MRE resources. However, most of the valuable resource information generated in marine resource assessments is stranded and is not readily accessible to Canadians and industry stakeholders in a manner that supports their needs. Of course, deployment feasibility is also influenced by many other important factors including, but not limited to, socio-economic criteria, environmental criteria, installation feasibility, and electrical grid integration. Although datasets associated with these criteria are available from various literature and data repository sources, they have not yet been collected into a single and easily accessible database focussed on MRE. Furthermore, these datasets are not yet available to MRE stakeholders in a manner that supports site selection investigations through flexible and interactive decision making techniques.   A web-based Marine Energy Resource Atlas was developed to facilitate preliminary marine renewable energy site selection and feasibility investigations within the rivers and coastal waters in British Columbia, Canada. The Atlas contains a number of geospatial layers derived from relevant datasets. The Atlas supports multi-criteria decision analyses driven by user-specified criteria to compute and visualize MRE hotspots. The Atlas was developed as a decision support system (DSS) such that users are able to interact with the underlying datasets that drive the hotspot delineation. As such, the Atlas is an effective tool to quickly investigate multiple scenarios with different resource, socio-economic, and environmental criteria. Resulting hotspot delineations are visualized in the web browser and are updated in real-time in response to user-interaction and criteria adjustments. It is anticipated that the flexibility and ease-of-use of the Atlas will facilitate site selection and ultimately contribute to well-informed MRE resource management. Additionally, the Atlas represents the first tool to offer decision support capabilities for tidal, wave, and river hydrokinetic resources under a common system and interface. ","authors":"Julien Cousineau and Sean Ferguson","topic":"2","file":"1315-4647-3-DR-OK.pdf","bib":"TIDRES-1315.bib"},
{"paperid":"1318","title":"The O&M driven design of a multi-row platform tidal project","keywords":"A number of tidal projects with different design, sizes and conceptual approaches, have been developed in recent years [1]. While the technology has proven to be effective in converting tidal streams into electric energy, the economic viability is still far from being achieved due to unforeseen complications following the installation of the devices [2].   In this paper, the authors provide an overview of the major challenges tidal energy developers should consider in order to design a viable tidal energy device. In addition, based on past field experiences, the typical issues encountered by offshore contractors during the deployment of one or an array of devices are presented. As a consequence, paying special attention to the operational requirements of the devices, the solutions to these problems are proposed. Hence, a novel tidal concept is presented, using lifecycle O&amp;M costs as a top driver for the development of the device.   Subsequently, the iterative improvement of the project is achieved by means of a verified and calibrated integrated framework [3], based on Monte Carlo simulation and evolutionary algorithms, in order to support the decision-making process and management of the assets. Thus, the pivotal role of computational tools to improve the profitability of the project while ensuring satisfactory levels of availability and reliability is highlighted, and the potential for cost reduction in the design of a tidal energy project, in order to achieve financial viability, is shown.  The approach proves to be fundamental in order to assess the feasibility of a project, understand limitations and challenges for its management, advance strategies for the mitigation of the criticalities and, most importantly, support the concept development.       Fig. 1 Preliminary sketch of the tidal design concept [confidential].                        Fig. 2 Flowchart of the implemented optimization methodology.        References   [1]        M. Z. Zainol, N. Ismail, I. Zainol, A. Abu, W. Dahalan, A review on the status of tidal energy technology worldwide, Sci.Int.(Lahore), 29(3), 659-667, 2017.   [2]        I. Lazakis, O. Turan, T. Rosendahl, Risk assessment for the installation and maintenance activities of a low-speed tidal energy converter, Marine &amp; Offshore Renewable Energy, 2012.   [3]        G. Rinaldi, P.R. Thies, L. Johanning, A coupled Monte Carlo - Evolutionary Algorithm approach to optimise offshore renewables O&amp;M, Proceedings of the 12th European Wave and Tidal Energy Conference, Cork, Ireland, 2017.     ","authors":"Giovanni Rinaldi, George Crossley, Richard Parkinson, and Lars Johanning","topic":"11","file":"1318-4641-2-DR-OK.pdf","bib":"OPANDM-1318.bib"},
{"paperid":"1319","title":"Income optimisation of a fleet of tidal lagoons","keywords":"Tidal lagoons represent a form of renewable electricity generation that remain untested. In the UK, a perceived lack of value for money to the consumer triggered the government's rejection of a recent plan to build and operate a system of six tidal lagoons along the west coast of England and Wales. Tidal energy benefits from a high degree of predictability in its resource, as well as flexibility with regards to the control of the constituent hydraulic structures. An adaptive operation can utilise these factors in order to optimise the operation of a tidal lagoon. We explore here the potential to optimise economically by targeting generation periods to match high demand in the day-ahead energy market, increasing the return on electricity sold. Gradient-based optimisation techniques are applied to a finite difference 0D model of a fleet of seven idealised tidal lagoons. For the generation of site-specific inputs, the model is in turn coupled with  Thetis , a coastal ocean modelling framework based on the finite element engine  Firedrake . An adjustment is made to the price signal which reflects the presence of tidal lagoons in energy market trading. Results converge towards a system which utilises the inherent phase difference of the operation of the tidal lagoons to limit price reduction and make significant gains in income when optimising the entire fleet. The high variability of site conditions present in the tidal lagoon fleet is also highlighted, emphasising the importance of flexibility in tidal lagoon operation and design.","authors":"Lucas Mackie, Frederick Harcourt, Athanasios Angeloudis and Matthew D. Piggott","topic":"11","file":"1319-4919-1-DR-OK.pdf","bib":"OPANDM-1319.bib"},
{"paperid":"1322","title":"Condition monitoring for wave energy converters","keywords":"Wave Energy Converters (WEC) have for many years been regarded as one of the most promising marine renewable energy sources. However, since marine energy devices operate in harsh environments and still need to perform with a high level of reliability to keep the levelized cost of energy (LCoE) at a competitive level, there are significant technological challenges to overcome. In this paper we explore an approach to achieving high WEC reliability at an affordable cost by relying heavily on condition-based monitoring, whereby operational data captured from in-WEC sensors are communicated and processed to detect abnormal behaviours indicating impending malfunctions, to predict and respond to needs for maintenance before serious damage occurs. The hypothesis is that by being able to reliably predict the state of health of individual WECs in a WEC farm from captured sensor data, a required reliability level can be achieved without over-engineering of components (i.e. dimensioning for worst case scenarios with huge safety margins), lowering costs of production, maintenance and operation. Additionally, the captured data used for condition monitoring can be reused for simulation model validation and in knowledge-based development of next generation WECs.   Different conceptual approaches to condition monitoring are discussed and the specific challenges related to WEC condition monitoring are identified. A reference architecture for condition monitoring systems targeting marine energy applications is presented and a use case focusing on fatigue of a critical WEC component is described. The proposed architecture is based on a multi-tiered model, designed with a modular System-of-Systems approach, based on open interfaces and affordable Internet-of-Things technology, in contrast to the monolithic and highly expensive systems available today for e.g. offshore wind applications.   Additionally, a distributed data processing approach is proposed, whereby computations required for the analytics can be performed both onboard the WEC and in a back-end data processing infrastructure, enabling trade-offs between onboard computational capacity and data communication bandwidth requirements. The concept of Smart Monitoring of WECs is introduced to optimize the data communication trade-off and enable secure, robust and efficient communication between onboard processing and back end offloading by utilizing both wired and wireless communication.  Altogether the paper captures the essence of next generation wave energy devices enabled by sensor fusion, ad hoc connectivity, status monitoring, predictive and preventive maintenance reliability, and data-driven innovation.","authors":"Mathias Johanson, August von Hacht, Charlotte Strang-Moran, Johannes Hüffmeier, Pär Johannesson","topic":"11","file":"1322-4901-1-DR-OK.pdf","bib":"OPANDM-1322.bib"},
{"paperid":"1323","title":"RiaSoR2: Roadmap for Condition Based Monitoring and Reliability Centered Maintenance","keywords":"Marine energy devices operate in a harsh environment but still need to perform reliably and produce the expected amount of energy, which give rise to huge engineering challenges. The Reliability in a Sea of Risk (RiaSoR) project addresses the strategic need for the marine energy industry to assess reliability that largely impact the LCoE of emerging wave and tidal device technology. RiaSoR brings together three leading European research and testing sites from the north of Scotland, England and Sweden to develop industry approved reliability methodologies.         The RiaSoRII project leverage technology and practices from the automotive industry, thereby going beyond the current state of the art in condition monitoring for offshore applications. Utilizing IoT principles for monitoring of sensor data and cloud-based service architectures for Big Data processing and analytics, the ocean energy sector will benefit from access to large volumes of data to improve reliability. A reliability centered maintenance framework is established within the project.          The evolution of the Internet into an “Internet of Things” whereby a large number of connected devices are continuously feeding real-time data into a remote data processing infrastructure, often referred to as a cloud is enabling many new concepts and business opportunities for remote operation and control of industrial applications, including condition monitoring, predictive and preventive maintenance. When the number of connected devices and sensors grow, sophisticated high-performance data processing services are required in order for the systems to be scalable to increasing data volumes.          Benefits of the projects can be listed as:          Requirements analysis regarding data capture, processing and communication for Condition Monitoring of WECs      RiaSoR 2 methodology fully utilized in planned test programs for technology developers      Based on offshore wind energy industry best practice in condition monitoring systems, the training and material developed will help transfer skills in reliability analysis and use of the monitoring framework to WEC and TEC developers      The educational material that help wave and tidal energy developers adopt an informed approach to condition monitoring   and also make a significant and lasting impact      Structured, FMECA based approach for condition-based monitoring for ocean energy devices      Use case to exemplify based on data from dry and offshore testing      State of the art in capturing failure modes by sensor techniques      Adoption of data capturing and processing from other industries      Numerical modelling for capturing and quantifying the uncertainties in reliability assessment      RiaSoR roadmap for CBM of ocean energy devices (as partly shown in the pictures below)      Dissemination at various conferences on content to spread results and receive feedback      Interaction with other parallel projects (Waveboost, etc.)          Achievements of the project include:          Overview of condition monitoring system requirements for wave energy converters to include sensor technology selection, data processing and communication.       Protoype implementation of WEC condition monitoring system      Completion of condition monitoring educational and training package.       Delivery of workshop on the training package to ensure guidelines are understood and welcomed by industry.      System architecture for data handling and data communication      VMEA study for critical parts and for CBM      Data assessment, tolerances, data quality and handling of outliers      Structural health, remaining lifetime, safety factors and uncertainties                        ","authors":"Johannes Hüffmeier, and Pierre Ingmarsson ","topic":"11","file":"1323-4843-2-DR-OK.pdf","bib":"OPANDM-1323.bib"},
{"paperid":"1325","title":"Physical model study of the wake produced by multiple cross-flow turbines","keywords":"Tidal and river currents have the potential to become a viable long-term source of renewable energy, provided that the environmental and economic costs of producing energy from these flows can be lowered to competitive levels. In order for developers to achieve a good business return, the energy extracted at each project site needs to be maximized by deploying multiple turbines in an array. However, available information on the performance of turbine arrays is limited and there is a need for new knowledge concerning the interactions between adjacent turbines, the performance of individual turbines deployed in arrays and the impact of turbine arrays on the flow and surrounding environment.  This knowledge will make it possible to optimize turbine array layouts with respect to power generation and environmental footprint by adjusting the turbine configuration, the spacing of the turbines and the numbers and types of turbines deployed.  While scaled experimental models have previously been used to investigate the wake produced by both single horizontal-axis turbines and multiple horizontal-axis turbines in several array configurations, a knowledge gap remains concerning the wake produced by single and multiple vertical-axis cross-flow turbines. This knowledge gap makes it difficult to optimize cross-flow turbine array layouts for maximum power output with minimal environmental impact.   The objective of the experimental work to be discussed in this paper was to document the size, extent and character of the velocity deficit downstream from a single vertical-axis cross-flow turbine (see Figure 1a) and a pair of cross-flow turbines in several different array configurations.  The experiments were conducted in a 95 m long by 2 m wide flume in which steady flows with various speeds can be generated.  The three-dimensional velocity field downstream of the model turbine(s) was mapped using five 3-axis acoustic current meters suspended from a traversing overhead beam.  The velocity data was processed and analysed to document the three-dimensional shape and character of the flow disturbance and velocity deficit caused by the turbine(s) (see Figure 1b).  The experimental data obtained from this study is being used to calibrate and validate a CFD model of the turbine-fluid interaction and to inform the development of guidelines for the layout of cross-flow turbine arrays.               Figure 1. a) single cross-flow turbine installed in the flume; b) measured mean velocity deficit at mid-depth. ","authors":"Mitchel Provan, Paul Knox, Andrew Cornett, Julien Cousineau","topic":"4","file":"1325-4999-1-DR-OK.pdf","bib":"TIDDEV-1325.bib"},
{"paperid":"1326","title":"Tidal stream resource assessment with TELEMAC-2D of the Churchill Barriers, Scotland","keywords":"Mohammad Yousef*, University of Edinburgh, Edinburgh, EH9 3BF   Professor Lars Johanning, University of Exeter, Cornwall, TR10 9FE   Professor Vengatesan Venugopal, University of Edinburgh, EH9 3DW       *Corresponding author:   m.yousef@ed.ac.uk         Tidal energy is harnessing the power from tidal currents to provide clean renewable energy, mainly in the form of electricity. In order to tackle climate change challenges, various renewable energy sources are required to provide sufficient energy to phase out fossil fuel. The UK is the world leader in this newly emerging industry with the potential for tidal energy to provide 20% of the country’s electricity needs.   This paper presents a systematic approach to tidal energy resource assessment of the Churchill Barriers, Orkney Islands, Scotland. TELEMAC-2D is employed for the study; it simulates free-surface flows in two dimensions of horizontal space, calculates the depth of water and the two velocity components. TELEMAC-2D solves the shallow water equations (Saint-Venant equations) using the finite-element method and a computation mesh of triangular elements. Model set-up, calibration and validation are discussed herein.   Current velocity data in the water column are measured using Acoustic Doppler Current Profiler (ADCP). The results of the model simulation compare favourably to ADCP field data observed over the same time period of the simulation.   This approach can aid developers in site selection and preliminary tidal farm design including potential energy available for extraction at a study site. In the future, the approach will be used in the investigation of the potential for extracting tidal energy at the Churchill Barriers. A series of scenarios will be explored involving the deployment of turbines either in the barriers’ infrastructure or in a channel formed by opening up a proportion of the barriers. ","authors":"Mohammad Yousef , Vengatesan Venugopal, and Lars Johanning ","topic":"6","file":"1326-4930-1-DR-OK.pdf","bib":"TIDHYD-1326.bib"},
{"paperid":"1328","title":"Motion tracking of a free-yawing floating tidal stream turbine platform","keywords":"SURFTEC (SUrvivability and Reliability of Floating Tidal Energy Converters) is a three year collaboration between Swansea University, Sustainable Marine Energy Ltd, Black and Veatch and the European Marine Energy Centre which aims to investigate loadings on floating tidal energy converters, including loads due to extreme events and longer term fatigue issues. Increasing our understanding of these loads will improve predictions of structural fatigue and component life. Understanding the motion of these floating platforms and how this impacts on power extraction will allow simulation and design tools to better account for the change in relative motion between the turbine and the incoming water flow.   As part of this project, instrumentation was designed and deployed onto PLAT-I – a floating tidal energy platform. The platform is built from three separate hulls joined towards the stern by a raised deck structure from which 4 turbines are mounted. Of note is the free-yawing design of the platform, which allows it to passively respond to the dominant current flow.   In order to capture the motion of the platform, including its free-yawing behaviour, two sensor units were constructed and mounted to the outer ends of the device. These sensors contained a pair of inertial measurement units (IMUs), consisting of 3 axis linear accelerometers, 3 axis gyroscope and 3 axis magnetometer. These were supplemented by an additional 3 axis linear accelerometer and GPS receiver in a commercial datalogging unit which recorded the IMU data at up to 85Hz. An acoustic doppler velocimeter (ADV) was also deployed in order to measure the water flow relative to the platform at 64Hz.   Offline processing of this data allows the platform motion to be investigated against the incoming flow and compared to records of the environmental conditions and operational information such as generated power. A Kalman filter process has been used to model the platform motion using GPS and data from a single IMU, with further work ongoing to extend this to combine the data from multiple IMUs.   The figure below shows a sample of this data analysed showing platform position as modelled using GPS and a single IMU against the input GPS data alone. The axes show change in position in metres as measured from a fixed point selected for convenience during this analysis. The model output shows smoother transitions on the edges of the main cluster of points, with the horizontal banding present in the GPS data no longer evident – consistent with the error in reported position being reduced using the information from the accelerometers.       ","authors":"Thomas Lake, Alison Williams, and Ian Masters","topic":"4","file":"1328-4891-1-DR-OK.pdf","bib":"TIDDEV-1328.bib"},
{"paperid":"1331","title":"Investigation into the control strategy for a long spine of Edinburgh Duck modules, using an efficient numerical model","keywords":"When first proposed as a concept to facilitate large-scale energy extraction from ocean waves, the Salter Duck modules were envisioned to be connected to long spines and able to take advantage of this common reference structure. The design of such a spine then evolved towards a fully controlled, flexible-jointed assembly of at least many tens of modules, with a specially tailored mooring system. The proposed introduction of on-board, gyroscopic power take-off systems (PTOs) would even remove the need for a common rigid reference point altogether, whilst avoiding unwanted reaction forces on the ducks themselves. Truly significant levels of wave energy extraction from the seas and oceans would demand this type of more integrated, freely-floating system.   Though the design of the duck spine system is geometrically geared towards efficiency, full utilisation of the available resource will require active control of the device. A pitch-heave-surge rig was used to mimic the behaviour of a single member of a full duck spine, and the control strategy tuned using a neural network approach, with the duck model in a narrow wave tank [1]. A key finding was that the optimisation of the control forces often led to increased proportions of the total power deriving from the heave and surge motions, suggesting that significant power extraction from the joints of a spine could be expected. Related work on long spines of cylindrical modules, not optimised for power extraction, uncovered that oblique wave directions could induce the propagation of flexural waves along the spine itself [2]. This leads to vastly more complex dynamic behaviour, especially when combined with the presence of other modules interacting both mechanically and hydrodynamically.   This paper aims to bridge the chasm between these two studies, focusing on the control strategies for a full spine of Salter Ducks. This is made possible by way of a computationally efficient, frequency-domain, numerical model, which uses generalised modes in order to model the system with maximal efficiency. Having all the body motions, including two degree of freedom spine joints, encapsulated naturally within the linear wave-body interaction problem also conveniently permits the use of complex conjugate control, at least for the case of regular waves. Both constrained and unconstrained versions of this control method are considered, especially with regards to the fact that not all degrees of freedom would be controlled on the freely-floating structure. It is thought that a full spine should constitute at least 10 ducks to achieve adequate stability by spanning multiple wave crests, but the model can be easily extended to much larger numbers. The complex control coefficients are optimised for a range of sea conditions, including a focus on oblique wave directions. Trends within the optimal damping and stiffness coefficients are investigated, along with the behaviour of the spine of ducks under these operational conditions.  [1] H. E. Young, J. Pollock, 1985, ‘Variable Coefficient Control of a Wave-Energy Device’, Edinburgh University Wave Power Project Report.   [2] S. Salter  et al. , 1984, ‘Bending Moments in Long Spines’, Edinburgh University Wave Power Project Report. ","authors":"Alfred Cotten and David I. M. Forehand","topic":"5","file":"1331-4599-2-DR-OK.pdf","bib":"WAVHYD-1331.bib"},
{"paperid":"1332","title":"Quantification of load uncertainties in the design process of a WEC","keywords":"Reliability has been identified as a key issue for the successful development of the marine energy sector. The RiaSoR (Reliability in a Sea of Risk) project addresses this strategic industrial need for guidance in reliability design. The RiaSoR 1 project developed a reliability framework, building on established practices from the automotive industry, by implementing and adapting the Variation Mode and Effects Analysis (VMEA) methodology to ocean energy applications. The RiaSoR 2 project builds on the theoretical framework developed in RiaSoR 1, aiming to develop methodologies that enable optimal reliability and performance of wave energy converters (WECs), while minimising cost and time-to-market.   Under RiaSoR 2, the project team applied the VMEA methodology to the WEC design process. The application of the VMEA methodology in combination with a numerical load analysis tool provides a methodology to quantify load uncertainties at a preliminary WEC design stage. Developers could use this information to assess the reliability of critical WEC components from an early-stage of design. In RiaSoR 2, the numerical modelling tool, WEC-Sim, was used to estimate loads, and combinations of simulations were run to identify key load uncertainty sources and to quantify the effects of variations associated with identified uncertainty sources.   In this paper, details of the integration of the VMEA methodology in the WEC design process under the RiaSoR 2 project are provided. Firstly, a design basis was developed to establish baseline conditions for a preliminary numerical load assessment. A reference generic WEC design was used, along with a high-level definition of environmental conditions and design situations that may be experienced during the lifetime of a WEC. A model of the WEC was developed in WEC-Sim, which was used to generate load estimates for select design load cases (DLCs). Secondly, the probabilistic VMEA process was applied. The initial steps in the process included the definition of a target function to be assessed and the identification of uncertainty sources related to the target function (e.g. design basis inputs, numerical modelling assumptions, post-processing methodologies applied). Following the identification of uncertainty sources, a sensitivity and uncertainty assessment was conducted using WEC-Sim. The impact of univariate changes of each uncertainty source on the target function was assessed, and the dispersion in the load estimate associated with each uncertainty source was quantified. Thirdly, the results from the numerical sensitivity and uncertainty size assessment were input into the VMEA template developed in RiaSoR 1 to calculate the combined total load uncertainty. All of the stages of the process are described in this paper.   In summary, this paper aims to provide both an overview of activities conducted under the RiaSoR 2 project, more specifically the application of the VMEA methodology to assess the uncertainty associated with numerical estimates of dominant WEC loads at a preliminary design stage, and general guidance to stakeholders that wish to follow a similar load uncertainty assessment approach when tackling WEC design.   Acknowledgements   RiaSoR 2 is funded under OCEANERA-NET in association with the Swedish Energy Agency and Highlands and Islands Enterprise. ","authors":"Mairead Atcheson, Joao Cruz, Tiago Martins, Pär Johannesson, and Thomas Svensson","topic":"8","file":"1332-4628-2-DR-OK.pdf","bib":"STRMAT-1332.bib"},
{"paperid":"1336","title":"Numerical simulation of a latching controlled heaving-buoy-type point absorber by using a 3D numerical wave tank","keywords":"The aim of this study is to simulate the entire process of a latching controlled heaving-buoy-type point absorber (HPA) by using three-dimensional potential numerical wave tank (NWT). A HPA consists of a vertical circular cylinder and the hydraulic Power take-off (PTO) system. The latching control, a discontinuous phase control technique, is one of the promising control technique for maximum power efficiency of wave energy converter (WEC). When the displacement of the buoy reaches its apex, the motion of the buoy is constraint to change the phase of the motion. The phase change causes the displacement of the buoy to be significantly amplified. This phenomenon is noticeable in the time domain analysis.   In this study, a novel three-dimensional potential numerical wave tank was developed to simulate the HPA WEC including the latching control of body motion in the time domain. The developed NWT is able to consider the influence of high amplitude nonlinear waves, nonlinear body motion, and wave-body-PTO interaction. The WEC NWT can  also consider instantaneous nonlinear PTO force acting on the buoy.   This technique can simulate various nonlinear phenomena of WEC by rearranging the calculation points and updating conditions at every time step in accordance with their physical variation. The developed NWT is based on the potential-flow theory and the boundary element method. The mixed Eulerian and Lagrangian (MEL) method was adopted to express nonlinear propagating waves. The acceleration potential approach was also applied to represent wave-body interaction accurately. In order to satisfy the open sea condition, the numerical beach scheme was adopted and installed at frontal and end boundaries and side of the numerical wave tank. In addition, a hydraulic PTO system was numerically modeled as an approximate coulomb damping type force. This technique is fairly accurate in simulating the PTO system in the form of a hydraulic device.   Using the WEC NWT technique, the effect of the latching control on the performance of HPA was analyzed. The variation of buoy displacement and the efficiency of power generation by the latching control were compared with the results of linear analysis. ","authors":"Sung-Jae Kim, and Weoncheol Koo","topic":"5","file":"1336-4631-2-DR-OK.pdf","bib":"WAVHYD-1336.bib"},
{"paperid":"1338","title":"Model scale testing of multi-rotor arrays designed to exploit constructive interference effects","keywords":"The tidal energy sector has recently seen the installation of the first arrays with Nova Innovation and MeyGen both successfully installing arrays of two (capacity 200kW) and four (capacity 6MW) turbines respectively.   Multi-rotor floating systems have also gained momentum as they take advantage of shared support structures and some aspects of the power train. For example, Orbital Marine Power’s 2MW SR2000 device has two rotors with shared power electronics on one platform, and Sustainable Marine Energy’s PLAT-I uses four Schottel SIT250 turbines.   Placing rotors in close side-by-side configurations, coupled with the near proximity of the seabed and free surface, can lead to increased turbine performance. Nishino and Willden (2013) considered the dynamics of turbine fences, showing an up to 35% increase in an ideal turbine’s performance if they are designed to take advantage of this so-called constructive interference effect.   That a turbine’s performance can increase in a blocked flow is not significant in itself. However, Schluntz and Willden (2015) demonstrated that by incorporating blockage in the design process the benefits can be exploited further. More recently, Vogel &amp; Willden (2018) simulated a fence of four tidal turbines with a tip-to-tip spacing of 1D (diameter), demonstrating the variability of thrust and power across the fence due to different rotor designs and control strategies.   A multi-rotor fence system is currently being developed at the University of Oxford with the turbines designed to exploit the constructive interference effects. A rotor has been designed using a RANS embedded Blade Element design tool to account for the higher blockage conditions, with a higher than usual blade solidity. The simulated maximum performance coefficient is around 0.6 when the rotor is simulated in a fence-type configuration and features flatter-than-usual performance variation with tip-speed ratio (TSR).   To validate the rotor-design methodology a series of experimental tests are being performed on two identical 1.2m diameter rotors in early 2019 at FloWave in Edinburgh. Tests will be performed on a single rotor and the two rotors when in side-by-side configuration with a tip spacing of 0.25D to demonstrate the constructive interference effect.   The blade root bending moments will be recorded in the flapwise and edgewise directions to understand interactions of the rotors as blades pass towards and away from each other. Rotor thrust and torque will also be measured for validation of the numerical design approach.   Flow measurements will be performed with a Nortek ADV in planes immediately upstream and downstream of the rotors, as well as at points either side of and between the rotors in the rotor plane. These measurements will enable better understanding of how the flow behaves in the vicinity of two closely spaced rotors and used to inform further developments for the multi-rotor fence system.   To the authors knowledge there are no other tidal turbines currently being designed for blocked conditions and so the work provides the opportunity to inform industry leaders of opportunities for designing for and exploiting constructive interference in future array designs. The paper will report on the completed multi-rotor tests.    ","authors":"James McNaughton, Bowen Cao, Christopher R. Vogel, and Richard H.J. Willden","topic":"4","file":"1338-4716-1-DR-OK.pdf","bib":"TIDDEV-1338.bib"},
{"paperid":"1341","title":"Comparison of numerical software for predicting the performance of a horizontal axis tidal turbine","keywords":"As the global community, and more locally the UK, look to move away from the burning of finite fossil fuels, marine energy extraction has gained greater interest as one possible alternative energy resource. This is due to the perceived impact that wave and tidal energy extraction could have in helping achieve the desired renewable energy targets of 20% that the UK are trying to hit by 2020 [1]. A small number of projects around the UK coastline are starting to highlight the potential that could be achieved, however these are both costly and time consuming.   To help mitigate this cost and time factor a large number of small-scale tests are being, and have been, undertaken at several facilities [2], [3]. The use of small-scale testing allows a platform from which computational models can be validated and compared to when looking at the performance of tidal stream turbines under a variety of flow conditions.   The use of computational fluid dynamics (CFD) allows for a rapid and cheap alternative when determining a preliminary estimate for the performance of a horizontal axis tidal turbine. Previous studies have shown that CFD can be used to produce accurate predictions, especially when looking at the performance of a tidal turbine, however emphasis needs to be placed on the solver and the set up of the model in question to ensure the conditions are being represented as accurately as possible.   Given the complexity of the CFD models a large number of different CFD codes and packages now exist, each of which allow the user unique control of the simulation in question. With such a variety of codes, the ability to replicate results on different platforms would be beneficial to increase the confidence in CFD models when looking at the preliminary predictions of tidal turbines.   This paper aims to look at comparing the prediction of a tidal stream turbine using the commercial code ANSYS CFX and the open source code OpenFOAM. Alongside producing repeatable results, the implementation of the desired boundary conditions was compared. The results were to be compared to the experimental results obtained during testing conducted at the INSEAN tow tank facility in Rome. The dimensions of the tank and the turbine used were replicated in the CFD models. Further details of the turbine and the measurement systems used to obtain the results can be found in (REF). As well as using the experimental models for validation the two numerical sets of data were also compared and analysed to see how and if they differed based on the program being used.          References       [1]         DECC (Department of Energy and Climate Change), “UK Renewable Energy Roadmap Update 2013,” no. November, p. 76, 2013.   [2]         T. Ebdon, D. M. O. Doherty, and T. O. Doherty, “Simulating Marine Current Turbine Wakes Using Advanced Turbulence Models.”   [3]         S. Ordonez-Sanchez  et al. , “Numerical Modelling Techniques to Predict Rotor Imbalance Problems in Tidal Stream Turbines,”   P roceedings of the  T welfth  E uropean  W ave and  T idal  E nergy  C onference , p.  752\hyphen 1 -- 752\hyphen 9 , 2017. ","authors":"Robert Ellis, Joshua Bowman, Matthew Allmark, Shanti Bhushan, David Thompson, Allan Mason-Jones, Tim O’Doherty","topic":"6","file":"1341-4926-1-DR-OK.pdf","bib":"TIDHYD-1341.bib"},
{"paperid":"1343","title":"Reliability evaluation using variation mode and effect analysis: Application to CorPower’s mooring pre-tension cylinder","keywords":"Marine energy devices operate in harsh environments but still need to perform reliably and produce the expected amount of energy, which give rise to huge engineering challenges. Reliability has been identified as a key issue for the successful development of the marine energy sector. The RiaSoR (Reliability in a Sea of Risk) project addresses this strategic industrial need for guidance in reliability design. The RiaSoR 1 project developed a reliability framework, building on established practices from the automotive industry, by implementing and adapting the Variation Mode and Effects Analysis (VMEA) methodology to ocean energy applications. The RiaSoR 2 project builds on the reliability framework developed in RiaSoR 1, aiming at further developing the methodologies, especially considering fatigue assessment, load uncertainty assessment and condition monitoring, enabling more refined designs and efficient maintenance of wave energy converters (WECs).  This paper presents a case study of a fatigue design assessment of a critical component in the CorPower C3 half-scale prototype WEC. The aim is to evaluate a design case for the structural reliability of the pre-tension cylinder subjected to internal pressure, which through the piston rod connects to the mooring. The fatigue design calculations are based on the pressure vessel standards that has predetermined safety factors. The reliability assessment is re-evaluated by means of the probabilistic VMEA tool where relevant uncertainty sources are identified. Each source is characterized by its size and sensitivity to the fatigue load-strength measure. All uncertainties are then combined into a reliability measure in terms of a total uncertainty that can be converted into a safety factor for design. In this case, the uncertainty assessment shows that three uncertainty factors connected to the fatigue strength (scatter, notch factor and fatigue model) dominates the total uncertainty. The safety requirements based on the standard and on the VMEA are evaluated, compared and discussed. Furthermore, the VMEA result will feed into the condition monitoring and maintenance strategies.  In summary, this paper aims firstly to compare the VMEA methodology to the established reliability design codes regarding the safety judgements, and secondly to investigate if the VMEA evaluation gives better ground for improvement work, design updates and maintenance planning, compared to the standard.  ACKNOWLEDGEMENTS  RiaSoR 2 is funded under OCEANERA-NET in association with the Swedish Energy Agency and Highlands and Islands Enterprise.  REFERENCES  [1] Johannesson, P. et al. (2016). Reliability Guidance for Marine Energy Converters. RiaSoR Report.  [Online]. Available: http://riasor.com/wp-content/uploads/2016/12/ ReliabilityGuidanceMECs_v1.0_20161216.pdf  [2] Johannesson, P., et al. (2009). Variation mode and effect analysis: an application to fatigue life prediction. Quality and Reliability Engineering International, 25: 167 – 179. ","authors":"Pär Johannesson, Thomas Svensson, and Hervé Gaviglio  ","topic":"3","file":"1343-4785-5-DR-OK.pdf","bib":"WAVDEV-1343.bib"},
{"paperid":"1344","title":"Adaptive Collective Control using Consensus Estimation in Arrays of Wave Energy Converters","keywords":"A Collective Control is developed in this paper that aims at maximizing the harvested energy from arrays of Wave Energy Converters with the wave information estimated by   a   consensus estimator.   The proposed   collective   controller applies the Proportional-Derivative feedback control law.  A surrogate model composed of mechanical elements is implemented to replace the hydrodynamic model for propagating the system responses.  The proposed control accounts for the displacement and control limitations; these constraints are implemented in the cost function as an exterior penalty function.  The weight of the penalty function is evaluated iteratively by applying   a   Sequential Unconstrained Minimization Technique.  The Continuous-Discrete Kalman-Consensus Filter is implemented to estimate the wave field which fuses the information of the WECs in the array to improve the estimation.   Three sets of numerical simulations are presented. First   collective control   is tested   assuming physical constraints   and   perfect knowledge of the wave field.   Second,      results of using   the Kalman-Consensus Filter   are presented and compared to   the standard Kalman Filter in terms of the speed of convergence and the estimation error.  Finally, the performance of the   combined   collective control   and   wave field estimat  ion using   the Kalman-Consensus Filter is   demonstrated via numerical simulations.  ","authors":"Shangyan Zou, Ossama Abdelkhalik","topic":"7","file":"1344-4607-2-DR-OK.pdf","bib":"GRDPTO-1344.bib"},
{"paperid":"1346","title":"Experimental study of the wall-mounted cylinder wake effects on a tidal turbine behaviour compared to free stream turbulence","keywords":"During the past ten years, it has been shown that the majority of the tidal energy sites have a quite high level of turbulence [1]. Most often, this turbulence comes from large bathymetry variations and affects the entire water column. Furthermore, it impacts significantly the performance and fatigue of tidal turbines [2], [3].       At laboratory scale, in the wave an current circulating tank of Ifremer at Boulogne-sur-mer, France, these seabed variations are experimentally represented with wall-mounted obstacles, with a height of H=0.25m. Experimental conditions are chosen to be representative of in-situ conditions at a 1:20 scale, in Froude similitude (Fr=0.23 and Re=10e5). Recent experiments [5] have shown that such a large aspect ratio bottom-mounted obstacle produces a very extended wake, with large velocity fluctuations.       At the same scale, an experimental 3-bladed turbine model, with D=3H diameter, has been recently developed at Ifremer [4]. This turbine model is equipped with 5-components blade root load-cells, measuring 2 forces and 3 moments for all 3 blades, in addition to torque and thrust transducers for the main rotation axis. In order to characterize the effect of the turbulence produced by the obstacle on the turbine, this model has been positioned into the wake of the obstacle (see joined picture) at a distance of 16H from the obstacle. In order to monitor the velocity fluctuations reaching the turbine, two types of measurement are performed in synchronisation with the turbine parameters: Particle Image Velocimetry (PIV) and Laser Doppler Velocimetry (LDV).           In this work, a full temporal and spectral analysis will be achieved on the turbine performance, in term of thrust and torque, but also on the blades load, in term of flapwise and edgewise bending moments, against of the incoming velocity characteristics (see first PIV fluctuating fields measurement upstream of the turbine). Then, a comparison will be proposed as well, between the impact on the turbine of these perturbations induced by the bottom-mounted obstacle and a classical high ambient turbulent intensity flow, with I=15%, that is close to an isotrope homogeneous turbulence in the flume.             References     [1] J. Thomson et al., “Measurements of Turbulence at Two Tidal Energy Sites in Puget Sound, WA,” IEEE Journal of Oceanic Engineering, vol. 37, no. 3, pp. 363–374.   [2] O. Durán Medina et al., “Turbulence analysis and multiscale correlations between synchronized flow velocity and marine turbine power production,” Renewable Energy, vol. 112, pp. 314 – 327.   [3] P. Mycek et al., “Experimental study of the turbulence intensity effects on marine current turbines behaviour. Part II: Two interacting turbines,” Renewable Energy, vol. 68, pp. 876 – 892.   [4] B. Gaurier et al., “Experimental study of the Marine Current Turbine behaviour submitted to macro-particle impacts,” in Proceedings of the 12th European Wave and Tidal Energy Conference, Cork, Ireland.   [5] M. Ikhennicheu et al., “Experimental study of coherent flow structures past a wall-mounted square cylinder,” In review in Exp. Fluids.       ","authors":"Maria Ikhennicheu, Beno?t Gaurier, Gregory Germain, Philippe Druault, Gregory Pinon and Jean-Valery Facq","topic":"6","file":"1346-5025-1-DR-OK.pdf","bib":"TIDHYD-1346.bib"},
{"paperid":"1347","title":"Model performance predicting extreme wave heights for project risk assessment and WEC design","keywords":"Extreme sea state statistics are needed to evaluate and classify project risk and extreme wave loads used for the structural design of marine structures and energy conversion devices. For wave energy resource assessments, it is also desirable to elucidate the spatial and temporal variation of these statistics at a high resolution among different wave climates. These statistics are calculated from time series of bulk wave climate parameters, e.g., significant wave height, ","authors":"Vincent S. Neary, Bibiana Seng, Zhaoqing Yang, Nabi Allahdadi, Ruoying He, and Taiping Wang","topic":"1","file":"1347-5036-1-DR-OK.pdf","bib":"WAVRES-1347.bib"},
{"paperid":"1354","title":"Endwall blade profile contouring on wave energy harvesting Impulse turbine ","keywords":"Oscillating water column (OWC) based wave energy device incorporates a self-rectifying bidirectional airflow turbine for the conversion of wave energy to mechanical energy. The objective of this paper is to predict the effect of endwall blade profile contouring on bidirectional impulse turbine under the steady state conditions. A 0.3 m diameter of the turbine with endwall contour is modeled and meshed in ICEM CFD 16.1. The performance characteristics were found by solving the Reynolds–averaged Naiver-Stokes equations with turbulence model SST through commercial CFD code ANSYS CFX 16.1. The detailed flow physics of the turbine with endwall contouring has been presented and compared it with existing (i.e. no endwall features) turbine. For the turbine, Endwall loss is a major source of loss of efficiency, which gives further scope for improvisation in performance characteristics by incorporating endwall contouring. ","authors":"Gautam Maurya, Rishav Raj, Aravind George, Dhiman Chatterjee, Abdus Samad ","topic":"3","file":"1354-4723-3-DR-OK.pdf","bib":"WAVDEV-1354.bib"},
{"paperid":"1357","title":"Development and assessment of a new geometry for CECO wave energy converter","keywords":"Ocean wave energy is one of the most promising sources of renewable energy due to the vast resource available worldwide. Nevertheless, its exploitation is often considered technologically challenging and uneconomical. Hence, research is still needed to optimize technologies used to harvest wave energy, namely to increase their efficiency and robustness.   CECO is a wave energy converter (WEC) that was designed to convert simultaneously the kinetic and the potential energy of waves in electricity, from the translational motions of a floating part in relation to a reference supporting structure, along an inclined axis, Figure 1. The experimental proof of concept of the device was carried out at the Hydraulics, Water Resources and Environment Division, of the Faculty of Engineering of the University of Porto, Portugal (Rosa-Santos  et al ., 2015). Since then several numerical studies were carried out to get more insight on its response under the action of wave and optimize its performance ( e.g ., Lopez  et al ., 2017a,b, 2018; Ramos  et al ., 2017, 2018; Rodriguez  et al ., 2018).      Figure 1: New geometry of the CECO wave energy converter.   This paper presents the numerical work carried out to optimize the geometry of CECO lateral mobile modules and to define the best PTO damping, in order to improve its efficiency for wave conditions typical of the Portuguese west coast. For the selected geometry, a new physical model study of CECO on a geometric scale of 1/25 was conducted at the multidirectional wave basin of the SHRHA-FEUP, for several wave conditions and different PTO damping levels.   The performance of CECO was analysed based on the instantaneous power produced by the electrical generator. For the new geometry, it was possible to reach relative capture widths above 40% for particular wave conditions. The new experimental data and conclusions will be the starting point of future developments of CECO.    References     López, M., Taveira-Pinto, F., Rosa-Santos, P., 2017a. “Numerical modelling of the CECO wave energy converter”, Renewable Energy (Elsevier), doi: 10.1016/j.renene.2017.05.066. ISSN: 0960-1481.   López, M., Taveira-Pinto, F., Rosa-Santos P., 2017b. “Influence of the power take-off characteristics on the performance of CECO wave energy converter”, Energy (Elsevier), doi: 10.1016/j.energy.2016.11.121.   López M, Ramos V, Rosa-Santos P, Taveira-Pinto F. 2018. “Effects of the PTO inclination on the performance of the CECO wave energy converter”, Marine Structures (Elsevier), 61:452–66.   Rodríguez, C., Rosa-Santos, P., Taveira-Pinto, F., 2018. “Assessment of the power conversion of wave energy converters based on experimental tests”, Energy Conversion and Management (Elsevier), 173:692-703, doi: 10.1016/j.enconman.2018.08.009. ISSN: 0196-8904.   Ramos, V., López, M., Taveira-Pinto, F., Rosa-Santos, P., 2017. “Influence of the wave climate seasonality on the performance of a wave energy converter: A case study”. Energy (Elsevier), 135:303–16. doi: 10.1016/j.energy.2017.06.080.   Ramos, V., López, M., Taveira-Pinto, F., Rosa-Santos, P., 2018. “Performance assessment of the CECO wave energy converter: Water depth influence”, Renewable Energy, 117:341–56. doi: 10.1016/j.renene.2017.10.064.  Rosa-Santos P., Taveira-Pinto F., Teixeira L., Ribeiro J., 2015. “CECO wave energy converter: Experimental proof of concept”, Journal of Renewable and Sustainable Energy, 7:061704.","authors":"Paulo Rosa-Santos, Francisco Taveira-Pinto, Claudio A. Rodríguez, Gonçalo Coelho, Daniel Clemente, Hélio Mendonça, A. Paulo Moreira","topic":"3","file":"1357-4977-1-DR-OK.pdf","bib":"WAVDEV-1357.bib"},
{"paperid":"1360","title":"Numerical simulation of the full non-linear behaviour of Wave Energy Converters","keywords":"The open-source DualSPHysics code based on Smoothed Particle Hydrodynamics methods is employed to simulate the interaction of sea waves with floating moored Oscillating Water Column Wave Energy Converters (abbreviated as OWC WECs). DualSPHysics captures accurately the highly nonlinear behaviour of wave-structure interactions and fluid-driven objects, and here is coupled with MoorDyn (a lumped-mass mooring dynamics model) and an air model, to simulate the full OWC WEC behaviour and to solve mooring dynamics and air effects inside the OWC WEC chamber. MoorDyn calculates the tensions of the mooring lines, which are added as external forces in order to compute the resulting response and motions of the floating OWC WEC in DualSPHysics. The implemented air model solves the pressure changes inside the OWC chamber by assuming the air as an ideal gas and the air flux through the OWC WEC chamber orifice as function of the pressure changes. The resulting coupled model is validated using experimental data generated during the experimental campaigns of the European MaRINET2 EsflOWC project (2017), and include free-surface elevations, OWC WEC response, mooring tensions and air flux velocity. It is worth to point out that the numerical modelling approach validated in the present work constitutes a very flexible and powerful tool to foster the technological development of floating moored OWCs WECs, to support the achievements of new results e.g. regarding structure survivability under high energetic sea states, and to obtain the optimum mooring layout to increase structure’s lifetime.    The figure shows an instant of the simulation of a floating OWC WEC using DualSPHysics coupled with MoorDyn. The colour of the water surface corresponds to the horizontal velocity. The dimensions of the tank and the device follow the experimental ones and the four mooring lines are reproduced in the numerical model to mimic the behaviour of the four chains in the experiments.       ","authors":"Alejandro J. C. Crespo, Moisés Brito, José M. Domínguez, Ricardo B. Canelas, Matthew Hall, Corrado Altomare, Minghao Wu, Vasiliki Stratigaki, Peter Troch, Lorenzo Cappietti, Rui M. Ferreira, Moncho Gómez-Gesteira ","topic":"5","file":"1360-5027-1-DR-OK.pdf","bib":"WAVHYD-1360.bib"},
{"paperid":"1362","title":"Resource assessment of the marine current developed in the Cozumel Channel","keywords":"The implementation of marine renewable energy technologies in developing countries will contribute to satisfy the energy demands of those growing economies [1], while reducing the consumption of fossil fuels and providing a renewable energy based system [2].  In Mexico, the Cozumel Channel (CCh) located in the Caribbean Sea (Fig.1), has been identified as a potential energy source in the region. Previous studies have demonstrated that the current in the CCh is almost uniform and unidirectional with flow velocities of up to 2 m/s [3]. Therefore, the aim of this study is to undertake a detailed resource assessment of sites potentially suitable for the installation of marine energy converters in shallow waters of the CCh.   Data measurements were taken using an Acoustic Doppler Current Profiler (ADCP) to describe the spatial variation of the marine current velocities at various points along the CCh. Transects were covered in the coastal area at water depths less than 50 m along the east-side of the CCh (Fig.1): from Punta Sur to Punta Norte with transverse measurements in the north part of the channel from Punta Norte to Punta Molas. Preliminary analysis of the ADCP data can be observed in Fig. 1b, where flow velocities close to Punta Norte are in the region of 1.0 m/s along the water column. Currently, water levels from pressure sensors in the mainland and in the Cozumel Island (Fig. 1a) are monitored to understand their variation in relation to the velocity field.   ADCP measurements will be useful to establish higher resolution velocity exceedance curves for the site, while pressure sensors will be relevant for the development of numerical models and to better understand the variations experienced in the Cozumel current at various locations. An indication of the turbulence scales will be relevant as a critical factor to inform the turbine architecture development when deployed at specific locations.   The reduced presence of sensitive coral reefs and shallower waters make the development of an operational monitoring platform more feasible in the north area of Cozumel Island, where sandy seabeds and platforms are located. Nevertheless, the sites also need to be further evaluated by addressing the interests and engagement of other interested stakeholders and potential environmental or legislative restrictions and limitations.         References   [1]        Graziano, M., Billing, S. L., Kenter, J. O., &amp; Greenhill, L. (2017). A transformational paradigm for marine renewable energy development.  Energy research &amp; social science , 23, 136-147.   [2]        Jenniches, S. (2018). Assessing the regional economic impacts of renewable energy sources–A literature review.  Renewable and Sustainable Energy Reviews , 93, 35-51.   [3]        Carrillo, L., Johns, E. M., Smith, R. H., Lamkin, J. T., &amp; Largier, J. L. (2015). Pathways and hydrography in the mesoamerican barrier reef system part 1: circulation.  Continental Shelf Research , 109, 164-176.           ","authors":"Juan C. Alcérreca-Huerta, Mariana E. Callejas-Jiménez, Stephanie Ordonez-Sanchez, Gabriel Gallegos, Matthew J. Allmark, Cameron M. Johnstone, Ismael Marino-Tapia, Tim O’Doherty, Rodolfo Silva and Laura Carrillo","topic":"2","file":"1362-4889-1-DR-OK.pdf","bib":"TIDRES-1362.bib"},
{"paperid":"1363","title":"Global and regional tidal range resource","keywords":"Although tidal barrages have been in operation for over 50 years, no tidal lagoon power plant has yet been developed. However, the Hendry Review, published in 2017, supported the development of the Swansea Bay tidal lagoon, termed a “pathfinder project”, with the key recommendation that the lagoon should be operational for a reasonable period of time prior to construction of any larger scale project, so that the impacts can be monitored over time. Here, we make use of the FES2014 tidal atlas to assess the scale of the global tidal range resource, applying appropriate technical constraints associated with tidal lagoon construction and operation. We also consider a key region in more detail – the northwest European shelf seas, using a higher resolution 3D (ROMS) model.   The global annual energy production potential (neglecting feedbacks between lagoon operation and the resource) is 5792 TWh, which is around 30% of global electricity consumption. However, the resource is generally confined to a number of regions. We find that 30% of the tidal range resource is in Australia, followed by Canada (23%), the UK (13%), and France (13%).   Our refined model simulations of the NW European shelf seas show that there is 683 TWh of tidal range energy available per annum in the UK, and 578 TWh in France, which is around 7% (UK) and 20% (France) lower than the global estimate. This is based on a minimum energy density threshold (for commercial viability) of 50 kW/m 2 ; but if the threshold energy density is increased to 84 kW/m 2  (the energy density of Swansea Bay), the resource reduces by 34%. To put these figures into context, the total M2 energy flux onto the European shelf is around 250 GW, which equates to an annual energy yield of 2190 TWh. Although feedbacks between resource exploitation and the available resource have yet to be considered, there does seem to be a significant resource available for electricity production; around 60% of the M2 energy flux. Further, it is important to consider model resolution and the tidal constituents used for tidal range resource assessment.  In the full paper, we shall expand the analysis of the NW European shelf seas. In particular, we shall examine how the phasing of tidal range energy could complement the temporal variability of electricity generated via tidal stream energy conversion in this region.","authors":"Simon P. Neill and Peter E. Robins","topic":"2","file":"1363-4989-1-DR-OK.pdf","bib":"TIDRES-1363.bib"},
{"paperid":"1365","title":"Towards reliability-based geometry optimization of a point-absorber with PTO reliability objectives","keywords":"As the wave energy industry progresses towards commercialization, research and development efforts to characterize and improve reliability of wave energy converters (WECs) have increased. Issues with reliability and survivability of WEC designs have previously led to setbacks for private developers including closure [1] and delayed or limited testing of devices. Moreover, component or system failure rates directly affect capital costs, operational costs, and power production. Therefore, designing WECs to withstand highly energetic wave conditions without over-engineering them is critical to overcoming industrial and development challenges and enable their implementation.   Despite the importance of considering WEC reliability in early design phases, it is often considered secondary to power production. Maximizing power production across sea states can increase revenue potential, but also loads and costs. Thus, there is a design tradeoff between power production and component reliability that should be considered throughout the WEC design process. Particularly in device geometry design, there is an opportunity to reduce structural and PTO loads [1]. Optimizing WEC shape for reliability and power could decrease downtime and required maintenance costs. Ensuring that WECs perform as they were designed for their intended lifespan, while decreasing levelized costs of energy, is integral to improving their feasibility.   In previous work, WEC hull geometries have been optimized for cost and power production, where costs varied with device size [2]. Reliability-based design optimization of hull geometries has not yet been explored, but would allow for hull geometries with advantageous reliability scores to be prioritized, balancing cost, power production, and reliability objectives. However, to develop this optimization method, we first need to develop analysis methods that relate environmental loads the WEC experiences to its reliability, as well as evaluate the sensitivity of its reliability to varying hull geometries. In this study, we will explore the relationship between WEC floater geometry and Power Take-Off (PTO) reliability, focusing on developing a reliability assessment method to evaluate PTO failure.   To complete this analysis, we will leverage previous work that generates WEC hull geometries and performs hydrodynamic analysis, from which power production and PTO forces for each geometry can be obtained [2, 3]. From this PTO force time series, we will then use Rainflow Counting and appropriate S-N Curves to count the number of fatigue cycles and relate it to Damage Equivalent Load metrics. The flexible definition of the WEC hull geometry will allow us to evaluate and compare several hull shapes and their resulting PTO damage. This study will provide insight about how hull geometries affect PTO damage, and enable future work incorporating this reliability assessment method within a geometry optimization process.     REFERENCES:   [1] R. Coe et al., “A Survey of WEC Reliability, Survival and Design Practices,”  Energies , Dec. 2017.   [2] A. McCabe, et al., “Optimizing the shape of a surge-and-pitch wave energy collector using a genetic algorithm,”  Renew. Energy , Dec. 2010.  [3] A. Garcia-Teruel, and D. Forehand “Optimal wave energy converter geometry for different modes of motion”  3rd Int. Conf. on Renewable Energies Offshore , 2018.","authors":"Caitlyn E. Clark, Anna Garcia-Teruel, Bryony DuPont, and David Forehand","topic":"8","file":"1365-5007-1-DR-OK.pdf","bib":"STRMAT-1365.bib"},
{"paperid":"1368","title":"Experimental investigations of Turbine Induced Damping for wave energy conversion","keywords":"Oscillating Water Column (OWC) is one of the simple and popular methods for wave energy extraction which uses air turbine for the conversion of pneumatic energy to mechanical energy. The turbine induces damping (i.e. ratio of square root of the pressure drop to the volume flow rate) on the OWC which greatly affects its overall efficiency. Early studies on damping characteristics were carried out by using different dimensions of orifice plates instead of an actual turbine. Thus, a bi-directional airflow impulse turbine of 196 mm diameter was fabricated and tested in an oscillatory airflow test rig facility at Wave Energy and Fluids Engineering Laboratory, IIT Madras. The test rig has a piston-cylinder arrangement and the stroke length of the piston was fixed at 0.4 m. The reciprocation of the piston is achieved through the rotation of crank which was varied at a different cycle time of 6, 8, 10 and 12 s. This article reports the time series analysis of the pressure drop across the turbine and its speed. Furthermore, turbine induced damping and its effect on chamber damping along with power coefficient were estimated and studied based on the varying airflow rates generated by the test rig. ","authors":"Rishav Raj, Rayan Anandanarayanan, Aravind George, Gautam Maurya,  Prasad V. Dudhgaonkar,  Abdus Samad ","topic":"3","file":"1368-5000-1-DR-OK.pdf","bib":"WAVDEV-1368.bib"},
{"paperid":"1371","title":"Weakly nonlinear theory of an array of surging wave energy converters with curved geometry","keywords":"We analyse the nonlinear behaviour of an array of curved gate-type wave energy converters (WECs) in a semi-infinite channel of constant depth. Gate-type WECs have attracted interests by researchers and industry, mainly because of their capability to absorb energy with potentially large efficiency when excited by incident waves. The vast majority of the theoretical models developed so far on the dynamics of such devices neglect nonlinear contributions. This can be unjustified when nonlinear resonances of trapped modes occur. Indeed, Michele et al. (2018b) recently showed that subharmonic resonance and mode competition of trapped modes can increase energy production of a system of gate-type WECs. Moreover, recent investigations on curved flap-type gates suggest that using curved structures could further improve wave energy extraction efficiency. Motivated by these new aspects, in this work we investigate the effect of gate surface curvature on the nonlinear dynamics of an array of surging WECs. We show that a small horizontal deviation of the gate surface produces significant changes in the dynamical behaviour of the system. Using perturbation-harmonic expansion up to the third order, we decompose the nonlinear governing equations in a sequence of linearised boundary-value problems of order n and harmonic m. The gate shape effects resonate the first harmonic at the second order, so that three timing with two slow time scales is necessary. First, we consider the subharmonic excitation of a single mode. We show the occurrence of new terms in the Ginzburg-Landau evolution equation, which are not present in the case of flat gates. Using action-angle variables, we analyse the occurrence of stable and unstable branches for the fixed points. Then we define an optimized  PTO coefficient which maximises power extraction under subharmonic resonance. The capture factor reaches much larger values than the theoretical maximum of a WEC in a channel described by the linearised theory. Furthermore, we show that subharmonic resonance is associated with increased efficiency of wave power extraction, though the effects of curvature are not always beneficial as we initially thought. Finally, we analyse the occurrence of synchronous nonlinear resonance by monochromatic incident waves with constant small amplitude and frequency equal to the eigenfrequency of the array. Products between the gate shape function and the second-order terms force the first harmonic at the third order. Perturbation expansion of the unknowns leads to an evolution equation similar to that obtained for the subharmonic case, except for a forcing term proportional to the amplitude of the incident waves. This particular excitation is not possible for flat gates, because in that case the corresponding evolution equation would be damped and unforced. We show that this synchronous resonance is less powerful than the subharmonic one, yet it is substantial for design purposes in real sea states when a broad spectra of frequencies is present so that both mechanisms can concur to the total oscillations.","authors":"Simone Michele, Emiliano Renzi and Paolo Sammarco","topic":"5","file":"1371-5066-2-DR-OK.pdf","bib":"WAVHYD-1371.bib"},
{"paperid":"1372","title":"Numerical modelling of an undulating membrane tidal energy converter","keywords":"Interactions between a semi-rigid membrane and a fluid flow can result in an undulatory motion. Undulating membrane tidal energy converters use these undulations to convert tidal kinetic energy into electricity trough linear generators. Above a certain critical current speed, flutter instabilities lead the membrane to get a periodic motion on a given wavemode with an associated frequency.   The membrane is pre-stressed by lateral cables that buckle it. This innovation lowers the critical speed and controls the deformation shape whereas increasing the importance of non-linear dynamics on the system. Curvature variations of the membrane activate electromechanical linear generators placed in the central line. They slow down the motion while converting deformation energy into electrical potential. Transverse rigid bars ensure a 2D motion and transmit forces from the membrane to the generators.   This device has been characterized experimentally [Träsch et al., 2018] and described by an analytical linear model [Träsch et al., 2019] and a CFD finite element model [Déporte, 2016]. Both models present interesting but in some cases inaccurate results. Therefore, a new numerical model has been developed using a 2D corotational finite element method to represent the structure and the vortex method to compute the flow. These methods as well as the interaction process will be presented.   Results of the numerical model will be compared with experimental results from a 1/20 th  scale prototype tested in the IFREMER flume tank of Boulogne-sur-mer. Trajectory and frequency of the undulating motion, hydrodynamic forces on the structure and velocity field in the wake will be presented. Comparison shows an improvement from precedent models and validates the new model for a future use in optimization process.        [Träsch et al., 2019] M. Träsch, A. Déporte, S. Delacroix, G. Germain, J-B. Drevet.  Analytical linear modelization of a buckled undulating membrane tidal energy converter .   Renewable Energy  .  Volume 130 , January 2019, Pages 245-255.       [Träsch et al., 2018] M. Träsch, A. Déporte, S. Delacroix, G. Germain, J-B. Drevet.  Power estimates of an undulating membrane tidal energy converter .   Ocean    Engeneering . Volume 148, January 2018, Pages 1-658       [Déporte, 2016] A. Déporte.  Caractérisation du fonctionnement d'une hydrolienne à membrane ondulante pour la récupération de l'énergie des courants marins .  Thèse de doctorat de l’Université de Bretagne Occidentale , Brest, 2016.    ","authors":"Martin Trasch, Anais Chambon, Astrid Deporte, Jean-Baptiste Drevet, Gregory Germain, Didier Lemosse, Gregory Pinon","topic":"6","file":"1372-4656-2-DR-OK.pdf","bib":"TIDHYD-1372.bib"},
{"paperid":"1374","title":"Advances in resource characterization in Alderney Race (English Channel)","keywords":"The northern Channel Isles region, located west of the Cotentin peninsula in France, has one of the largest tidal stream potentials in the world. Most of this potential is found in Alderney Race -15 km large, relatively shallow water strait where tidal current velocity attains 5 m/s due to flow amplification by topography. The powerful tidal stream, proximity to the shore and industrial centres in the Cotentin peninsula make the site very attractive for tidal energy conversion.   During the last two years, tidal circulation in the French sector of Alderney Race was extensively assessed by combing modelling,  in situ  and underway measurements of flow velocity, and also surface current velocities  remotely sensed by High Frequency radars (HFRs). A total of six oceanographic surveys were organized in the area for deploying on the seabed, recovering, and re-deploying of three Acoustic Doppler Current Profilers (ADCPs) for a long period. Underway ADCP velocity measurements and drifting buoys release were a part of these surveys. A large amount of high quality, high resolution, and large coverage data was collected and is being actually analyzed.   In this study we focus on a joint analysis of current velocity data derived from (a) bottom mounted ADCP measurements, (b) continuously evolving (in space and time) velocity measurements by two towed ADCP and (c) tidal model outputs. First, we applied the Optimal Interpolation (OI) technique to reprocess the underway velocity measurements recorded during successive flood and ebb tidal stages. The interpolation allows reconstructing space-time evolution of the velocity field within the whole domain by using velocity covariances derived from numerical simulations by a 2D hydrodynamic model MARS. This extensively validated model was configured for high-resolution simulations of tidal motions in the surveyed area. The major advantage of OI is that it shows where, within the study domain, the model results are in agreement/disagreement with measurements and how large the discrepancy is. Moreover, using the velocity data, OI corrects the model outputs and reduces the discrepancy. On the second step, OI technique was extended to reprocess the static point ADCP measurements.   After reconstructing space-time evolution of the tidal stream, resulting velocity fields were used for assessing the tidal stream resource at site. The results demonstrated that constraining the model by velocity measurements can lead to a significant reduction (up to 30%) of the energy resource compared to pure model estimates, especially during ebbing tide.  Velocity profiles from the towed ADCP measurements and independent bottom-mounted ADCP observations were compared. The results showed a very good overall agreement with relative error varying from 6% to 11% with respect to the tidal stage. The shape of velocity profiles was identified for different sub-areas of the domain. This indicates an interesting possibility of reconstructing the entire 3D evolution of the velocity field within the tidal cycle by blending the model by velocity profiles obtained during both static and towed ADCP surveys.","authors":"Alexei Sentchev, Maxime Thiébaut, Lucille Furgerot, Pascal Bailly du Bois, and Mehdi Morillon","topic":"2","file":"1374-4771-1-DR-OK.pdf","bib":"TIDRES-1374.bib"},
{"paperid":"1375","title":"Influence of floater geometry on snap loads in mooring systems for wave energy converters","keywords":"Point absorbing wave energy converters require mooring systems with significant compliance to accommodate the large buoy motions required for an efficient power take-off. The design of such moorings has proven a challenge, particularly at sites of relatively shallow water and large tidal range, where the relative displacement of the mooring becomes large. Design rules advocate that snap loads should be avoided in mooring design, however such a crude restriction might prove hard to achieve for wave energy converters given the additional requirements put on the mooring system: (i) low capital and operational costs; (ii) little to no negative impact on the power absorption; (iii) sufficient station-keeping action to avoid excessive forces on  the power cable; and (iv) ensuring survival in storm conditions.   The paper investigates the occurrence of snap loads in the moorings of point-absorbing wave energy converters by simulation in Moody, a high-order discontinuous Galerkin method for mooring dynamics. Increased compliance and elasticity of the mooring response are common tools to mitigate the severity of a snap load. Starting from a baseline design, we investigate the effect of increasing geometric compliance with floaters and sinkers, as well as increasing material elasticity via compliant fibre ropes like nylon and polyester or hyper-elastic materials such as the Seaflex mooring solution (with up to 80% elongation). The paper will discuss the dynamic effects of the snap load and its propagation through the mooring system. ","authors":"Johannes Palm and Claes Eskilsson","topic":"12","file":"1375-4541-2-DR-OK.pdf","bib":"MRGFND-1375.bib"},
{"paperid":"1377","title":"Full- and model scale Testing of two different Rotor Diameters for Instream Power  Generation","keywords":"See abstract in the uploaded PDF  Figure below: PLAT-I operational in Scotland with 4m turbines  JJ  ","authors":"Ralf Starzmann, Nicholas Kaufmann and Penny Jeffcoate","topic":"4","file":"1377-4811-2-DR-OK.pdf","bib":"TIDDEV-1377.bib"},
{"paperid":"1382","title":"Preparing for AMOG’s WEC prototype testing at Falmouth Bay Test site - Advancing Technology Readiness Level","keywords":"A particularly challenging phase in the commercial technology development of wave energy converters is the transition to higher Technology Readiness Levels of level 7 (system prototype demonstration in operational environment) and above. This is due to the required capital investment, installation and operation challenges when deploying technology at sea. ‘Nursery’ test sites have been established, in order to support this transition, allowing prototype installation and demonstration in relative sheltered environments, whilst offering relevant offshore conditions.  AMOG Consulting Ltd are set to deploy their Wave Energy Converter (WEC) device at the Falmouth Bay Test Site (FaBTest). Commissioning will begin at the site in May 2019, following fabrication of a novel floating WEC system designed at 1/3 rd  scale for summer conditions at the FaBTest site. In the time leading up to AMOGs deployment the system design has undergone several iterations to optimise the device for site conditions and the local supply chain. Key lessons learned during this period are portrayed in this paper.  Initial design of the WEC looked at a roll activated power take-off with a deep righting keel. Analysis of the specific conditions at the South Cornwall site led to design of a pitch driven system. Model tank testing at the Plymouth COAST laboratory demonstrated the devices ability to operate in a range of seas, with subsequent iterations resulting in minor modifications to the vessel shape, and mooring system. Following further computer modelling, reiteration, and tank testing the device will begin fabrication in Falmouth Cornwall for spring deployment.  This paper will be of interest to technology developers, researchers and practitioners, as well as certification agencies and regulators, as it documents the development and preparation of a wave energy converter concept at a nursery test site, seeking to advance the TRL towards a complete and qualified system (TRL8).    ","authors":"Hayden Marcollo, George Crossley, Philipp R. Thies, Jon Gumley, Lars Johanning ","topic":"3","file":"1382-5056-1-DR-OK.pdf","bib":"WAVDEV-1382.bib"},
{"paperid":"1383","title":"Laboratory experiments on the performance of an OWC-WEC: fixed condition versus floating platform-embodied condition","keywords":"The shortage of fossil fuel and the environmental impact related to their use motivate the growing attention toward renewable energies. In this perspective the exploitation of marine renewable energies can contribute to cope with these issues. Many wave energy converters have been proposed to date and the so-called Oscillating Water Column device (OWC) has already achieved a full-scale demonstrative Technology Readiness Level.               At the same time, the increasing population density will have a relevant impact on the limited availability of land, especially in coastal areas of some world regions. In this context, Very Large Floating Structures (VLFS) might represent an alternative to the commonly adopted land reclamation approach for creating usable spaces.    Moreover, the development of offshore floating infrastructure, based on VLFS, also constitutes a strategic vision for aiding the management of sea borders, such as the EU Mediterranean Sea border.            So far, OWC devices have been proposed both for harvesting the wave energy and for attenuating the motion of floating platforms.    In order to study the performance of the OWC device embodied on a VLFS, a small-scale physical model was manufactured and tested in the wave-current flume of the LABIMA (University of Florence, Italy). The model was constrained to move in heave direction only. Both regular and irregular waves were tested. The floating behaviour of the VLFS under the action of waves with different steepness was measured by using contactless ultrasonic distance sensors installed along the VLFS length. Moreover, the oscillation of the water level inside the OWC device, the differential pressure and the related air flow velocity through the duct hosing the power take off were measured.            This work aims at describing the conducted laboratory experiments and to discuss the performance of the OWC devices integrated in the VLFS in terms of the comparison with the performance of the same OWC tested in fixed conditions.    ","authors":"Lorenzo Cappietti, Irene Simonetti, Ilaria Crema","topic":"3","file":"1383-4911-1-DR-OK.pdf","bib":"WAVDEV-1383.bib"},
{"paperid":"1384","title":"Optimisation of wave-power arrays without prescribed geometry over incident wave angle","keywords":"This paper describes the optimisation of small arrays of wave energy converters (WECs) of point absorber type.  The WECs are spherical in shape and operate in heave only. Previous work in [1]-[5] is extended to a general layout, without any prescribed array geometry.  The WECs are optimised from a hydrodynamic perspective with respect to their positions.  Due to the complex nature of the numerical problem, the number of WECs considered is limited to five and maximum/minimum device separations are imposed.  This results in an optimisation of 18 variables in the constrained case.  In principal, this optimisation can be performed in a more general arena, but this will significantly increase the computational demand.   The aim is to find array geometries that give constructive interaction over the range of incident wave angles considered.  However, it is crucial that destructive interference be avoided as a first priority.  The objective function of the optimisation is taken to be the mean of the interaction factor over the incident wave angle range employed.   Previous work (e.g. [6]-[11]) has sought to maximise the interaction factor or power absorbed.  This has often resulted in large objective values; however, the array geometry associated with this process is very specific and slight changes/errors in array parameters (e.g. non-dimensional spacing) can result in large negative changes in performance.  This is also true for changes in sea conditions, such as incident wavelength or wave angle and is due to the high sensitivity of these types of optimisations.  By maximising the mean performance over the range of wave angles considered, arrangements can be obtained which exhibit good stable performance for the majority of this range, ideally with an average improvement obtained compared to isolated devices.   Both constrained and unconstrained optimisations are considered, with upper limits imposed on the WEC motions in the constrained case.  In the unconstrained case, the optimisation variables are the coordinates of the four free WECs, giving eight variables in total.  For the constrained optimisation, the theory of [6] and [12] is utilised and the amplitude and phase of the motions of each WEC are also fed into the optimisation, resulting in an additional ten variables.   Due to the large number of variables in the constrained optimisation, the results are not advertised as globally optimal, but rather the best that were achieved given computational limitations, in contrast to the unconstrained results, which are presented as optimal.   Several ranges of wave angles representing broad, intermediate and narrow-banded variation are investigated.  As expected, better performance is achieved for the narrow-banded ranges due to being able to tune the array performance to incident wave parameters.  Closely spaced groups of WECs are found in optimal unconstrained array layouts, while more separated and symmetric layouts, with the WECs surrounding the origin, are seen to be optimal when constrained device motions are enforced.  It also is shown for a general 2D array layout that it is possible to achieve an array that performs relatively well with respect to both incident wavelength and wave angle variations.    ","authors":"Justin P. L. McGuinness, Gareth Thomas","topic":"5","file":"1384-4606-2-DR-OK.pdf","bib":"WAVHYD-1384.bib"},
{"paperid":"1386","title":"Development of the IEC TC114 Technical Specification for mechanical load measurements for Marine Energy Converters","keywords":"In 2016, Interreg 2SEAS gave the green light to the MET-CERTIFIED project, which stands for Marine Energy Technologies Certification. The project aims to contribute towards the development of new technical specifications under the umbrella of the IEC TC 114 committee.   The field measurement of mechanical loads for marine energy converters (MECs) at full scale is an important tool to verify simulation results and to determine if the MEC can withstand the loads that it will be subjected to during its service life. This type of testing helps to reduce risks and thus increase investor confidence in the technology.   Within Technical Committee 114 on Marine Energy (Wave, Tidal and Other Water Current Converters) of the IEC (International Electrotechnical Committee) a Project Team is developing a technical specification (TS) for measurement of mechanical loads (IEC TS 62600-3). There is a wide variety of MEC types, especially concerning wave energy converters (WECs). For the tidal energy converters (TECs) the working principle of a turbine comprising blades connected to a rotor shaft is most common (Atlantis, Orbital, Verdant, Schottel, Tocardo, Sabella and others). However there are also other types of TECs under development without blades connected to a rotor shaft. Also there are WECs under development with blades connected to a rotor shaft. MECs can be seabed mounted, shore mounted or mounted to floating structures.   This part of the IEC 62600 series aims to cover all possible types of MECs. The following subsystems can be found in almost all MECs:   –             prime mover   –             power take-off (PTO)   –             control   –             substructure with foundation or floating device with mooring   The mandatory load tests are concentrated around the interfaces between these subsystems. For MECs with blades connected to a rotor shaft, the requirements for all MEC devices are specified in more detail, since in this case there is more knowledge about the technical components of the device. Full scale laboratory blade testing is added to determine the load bearing ability of rotor blades for static loads and fatigue.   The IEC TS 62600-3 is comparable to the wind international standard IEC 61400-13 for mechanical load measurement and IEC 61400-23 for full scale structural testing of rotor blades. A committee draft (CD 62600-3) was published in November 2018. All member countries have had the opportunity to comment on the CD and these comments have been reviewed. The Project Team is now developing a draft technical specification (DTS).  If the development goes according to plan the technical specification (TS) will be available in the first half of 2020.   The work of the convener (organiser) of this Project Team is part of the international MET-CERTIFIED project. It is executed by ten partners from the so called “2 seas region” of the EU. The project is  funded by the European Interreg 2 Seas programme. Also the Ministry of Economic Affairs in the Netherlands, Province of South-Holland and North-Holland and the Belgian Province of West Flanders are offering financial support. ","authors":"Anton Schaap, Nicholas Fyffe, Kimon Argyriadis, Peter Davies, Alan Henry, Budi Gunawan, Frederick Driscoll, Jeffrey Steynor and Peter Scheijgrond","topic":"8","file":"1386-4985-1-DR-OK.pdf","bib":"STRMAT-1386.bib"},
{"paperid":"1387","title":"Array modeling and testing of fixed OWC type Wave Energy Converters","keywords":"Many contemporary visions of commercial wave energy production include array of devices working in concert. Current research in development of these arrays include device spacial placement and advance control techniques. Although related research was conducted for this project in these areas, this paper describes the software modeling and physical testing process of an array of Oscillating Water Column (OWC) Wave Energy Converter (WEC) devices. Modeling techniques are outlined and preliminary results from the test data are presented. The information presented here is part of a larger project on Advanced Laboratory and Field Arrays (ALFA), funded by the U.S. Department of Energy. The content will build upon a paper presented at EWTEC in 2017 [1] where a single device was modeled, tested, and characterized. Array placement decisions were based on research in genetic algorithms where initial results were also presented at EWTEC in 2017 [2]. Array testing was conducted in the Directional Wave Basin (DWB) at the O.H. Hinsdale Wave Research Laboratory (HWRL) at Oregon State University. Two array configurations were chosen, including an optimized layout and an non-optimized layout. The non-optimized testing layout isshown in Figure 1. A total of 11 wave conditions were tested, including six regular, four random uni-directional, and one multi-directional. For each wave condition, a set of nonoptimized, and optimized damping values were tested. For the non-optmized, one damping was applied to all OWCs in the array. For optimized damping each OWC had a unique damping. A sample result is shown in Figure 2 where average power capture by each OWC is shown for the wave conditions listed. The top row are non-optimized layout and the bottom row is optimized layout results. WEC-Sim will be used to model an array of OWCs and the results will be compared to the physical testing.     Fig. 1. Scaled array model testing at the O.H. Hinsdale Wave Research Laboratory at Oregon State University (non-optimal layout).     Fig. 2. Average power capture for long crested random wave conditions where fixed valve angles are shown. Top row is non-optimal layout and bottom row is optimal layout.  [1] B. Bosma, T. Brekken, P. Lomonaco, A. McKee, B. Paasch, and B. Batten, “Physical model testing and system identification of a cylindrical owc device,” in EWTEC, 2017. [2] C. Sharp, B. DuPont, B. Bosma, P. Lomonaco, and B. Batten, “Array optimization of fixed oscillating water columns for active device control,” in EWTEC, 2017. ","authors":"Bret Bosma, Ted Brekken, Pedro Lomonaco, Bryony DuPont, Chris Sharp, and Belinda Batten","topic":"3","file":"1387-4684-2-DR-OK.pdf","bib":"WAVDEV-1387.bib"},
{"paperid":"1388","title":"A submerged point absorber wave energy converter for the Mediterranean Sea","keywords":"Regarding the serious environmental and energy problem existing in the world, renewable technology has taken the global attention. The unexploited huge potential of wave energy challenges the world scientific community, to achieve a sustainable wave energy absorption. With an outlook on the Mediterranean, Pantelleria is one of the most energetic wave sites. In this work, the device targeted is a submerged point absorber, deployed in the North West coast of the Pantelleria Island. The design and selection of the technical characteristics of the WEC follows the method proposed by Falnes. In order to control and test the performance of the device in different working conditions, a mathematical model has been built in the Matlab/Simulink environment based on the Cummins Equation with Morison correction. The model shows both regular and irregular waves and includes the nonlinearities. The paper shows the design process, the device characteristics and expected performances in Pantelleria.","authors":"Panagiotis Dafnakis, Mauro Bonfanti, Sergej A. Sirigu, Giovanni Bracco and Giuliana Mattiazzo","topic":"5","file":"1388-5028-1-DR-OK.pdf","bib":"WAVHYD-1388.bib"},
{"paperid":"1389","title":"Geometric optimization of a hinge-barge wave energy converter","keywords":"Keywords   Multi-body wave energy converters, hinge barge, geometry optimization, energy maximising control.   Abstract   To date, a number of hinge-barge wave energy converters have been developed, e.g., by SeaPower [1], Mocean [2], the McCabe wave pump [3] and the M4 device [4]. Numerical simulation and tank test results indicate that hinged devices have good performance in terms of power production or capture width ratio [5]. However, it is still not clear whether to use two bodies or three bodies, or what the optimal dimensions are, also considering the control strategies employed by the power take-off system [6].   Based on a small-scale prototype of the McCabe wave pump device, this paper studies the optimal size of main interconnected pontoon system, where the power take-off system is equipped with an optimal linear passive controller. To this end, an optimization procedure is developed, where the objective is to maximize the generated energy of the device under a given set of sea states. A multi-DOF hydrodynamic model is presented to describe the device motion, and hydrodynamic parameters are computed using a boundary element model tool, based on linear potential flow theory. Numerical results under regular and irregular waves are presented.   Simulation results show that increasing barge length does not always improve the energy generation of the three-body hinge-barge device, and the optimal dimension can be found using the developed methodology for the device under given sea states. In addition, it is found that the optimal control significantly enlarges energy production difference of two generators in some geometry sets and sea states, which indicates a two-barge control system may be a better design solution in those situations, considering the high cost of power take-off system and minor loss of energy generation.   References   [1]        “Seapower  website.” [Online]. Available: http://www.seapower.ie/our-technology/. [Accessed: 29-Oct-2018].   [2]        “Mocean website.” [Online]. Available: http://www.moceanenergy.com/. [Accessed: 29-Oct-2018].   [3]        F. Paparella and J. V. Ringwood, “Optimal Control of a Three-Body Hinge-Barge Wave Energy Device Using Pseudospectral Methods,”  IEEE Transactions on Sustainable Energy , vol. 8, no. 1, pp. 200–207, Jan. 2017.   [4]        L. Sun, J. Zang, P. Stansby, E. C. Moreno, P. H. Taylor, and R. E. Taylor, “Linear diffraction analysis of the three-float multi-mode wave energy converter M4 for power capture and structural analysis in irregular waves with experimental validation,”  J. Ocean Eng. Mar. Energy , vol. 3, no. 1, pp. 51–68, Feb. 2017.   [5]        S. Zheng, Y. Zhang, and W. Sheng, “Maximum Wave Energy Conversion by Two Interconnected Floaters,”  J. Energy Resour. Technol , vol. 138, no. 3, pp. 032004-032004–11, Mar. 2016.   [6]        P. Garcia-Rosa, G. Bacelli, J. Ringwood, P. B. Garcia-Rosa, G. Bacelli, and J. V. Ringwood, “Control-Informed Geometric Optimization of Wave Energy Converters: The Impact of Device Motion and Force Constraints,”  Energies , vol. 8, no. 12, pp. 13672–13687, Dec. 2015. ","authors":"LiGuo Wang, and John V. Ringwood","topic":"5","file":"1389-5030-1-DR-OK.pdf","bib":"WAVHYD-1389.bib"},
{"paperid":"1390","title":"An assessment of efficient tidal stream energy extraction using 3D numerical modelling techniques","keywords":"Tidal stream energy is an emerging sector of the energy generation industry.  It has more potential than other renewable energy resources to provide base-load power due to the predictability of the speed and direction of tidal currents. However, the practical use of tidal stream energy requires efficient energy extraction - including an efficient device or array at a suitable location – to make it economically viable. A tidal stream array is one of the most practical extraction methods, but the design of an efficient array is a challenging and complex process. The current knowledge of the effects of tidal stream arrays on hydrodynamic processes and wake interaction between tidal turbines is still limited. Several studies have tried to investigate the optimal array configuration for maximum and economically viable power extraction. This paper investigates some key factors that affect the power extraction by a tidal array, exploring the various approaches to design an efficient tidal array layout, and validating the outcome using numerical modelling techniques. A number of numerical experiments were conducted using a model of a real tidal channel, Hoy Sound, in Orkney to evaluate tidal array performance with different layout configurations. The paper proposes a new concept of Staggered Sub-Array SSA layout which combines the benefit of packed partial-fence and the staggered grid. It allows increasing the local blockage within the sub-array, while the gaps between the sub-arrays in a row can be increased to avoid array-choking or wake interaction with the downstream sub-arrays. ","authors":"Mohammed A. Almoghayer  and David K. Woolf","topic":"6","file":"1390-4802-2-DR-OK.pdf","bib":"TIDHYD-1390.bib"},
{"paperid":"1392","title":"Predicting the Dynamic Characteristics of a Fully Submerged Wave Energy Converter Subjected to a Power Take-Off Failure using a High-Fidelity Computational Fluid Dynamics Model","keywords":"The development of wave energy converter (WEC) technologies is playing an indispensable role in the emergence of renewable energy technologies. WEC components, including an absorber, power take-off (PTO) machinery, and sub-components needs to be robust and efficient throughout its deployment lifetime. A fault occurrence on the WEC, such as mooring failure, PTO failure, loss of grid power, etc., may result in a significant increase of structural and mechanical loading that can compromise the structural integrity of the WEC. In the past few years, a few design standards and guidance proposed a set of design load cases (DLCs) for the events of device failure that needs to be considered in determining the design load for a WEC. However, none of the standards and guidance has been widely accepted, mainly due to the lack of practical experience in implementing these design recommendations. Numerical models often do not have built-in functions/feature to model the PTO or mooring lines/tethers, for instance, so that a custom feature may need to be developed specifically for the project.   In this study, we develop an algorithm (Figure 1) to implement the physics of a mooring tether connected to a submerged WEC. The algorithm, built as a java subroutine, was implemented and tested on the commercially available high-fidelity computational fluid dynamic (CFD) code STAR-CCM+. A fluid-structure interaction (FSI) model for a fully submerged buoy absorber WEC connected to a single mooring tether, with an internal fault in the PTO system, was simulated. The PTO fault, i.e. a seized PTO drive shaft or generator short circuit in electrical systems, which may feasibly happen during the WEC’s lifetime, is being modeled and simulated using the high-performance computing (HPC) clusters at Sandia National Laboratories and University of California Berkeley.   The algorithm and simulation results are verified and partially compared to the mid-fidelity open source code, WEC-Sim. The results include the dynamic responses of the WEC body, tether tension, and PTO stroke. Based on the simulation results, the significance of a PTO failure event on the WEC integrity is discussed. Additionally, the complex flow features around the WEC body will be graphically illustrated and discussed in details.    Keywords : Fully submerged wave energy converter (WEC), Power take-off (PTO) failure, Slack tether, Fluid-Structure Interaction (FSI), WEC-Sim    ","authors":"Toan T. Tran, Aaron M. Krueger, Budi Gunawan, Mohammad-Reza Alam","topic":"5","file":"1392-5005-1-DR-OK.pdf","bib":"WAVHYD-1392.bib"},
{"paperid":"1399","title":"Analytical and physical modelling of a quayside Wave Energy Converter (WEC) and study of its impact on overtopping","keywords":"Many technologies of Wave Energy Converters (WEC) have been developed. WEC may be classified in offshore, near-shore and quayside systems [1,2]. Although wave energy potential is lower at coast than offshore, quayside systems offer several advantages: more protection against oceanic storms [3] and grid connection and maintenance costs reduced [4]. Moreover the impact of a quayside floating system on overtopping has not been previously considered to the authors’ knowledge.  In this context, the aim of the present project is twofold: the modeling of a quayside wave energy converter, and the study of the impact of the floating system on overtopping. Rectangular WECs in heave motion are considered close to a vertical wall in intermediate water depth.   Two models are used to represent the WEC behavior. In both models, the WEC considered is an oscillating buoy including a linear damper representing the Power Take Off (PTO). Firstly, a physical modeling is carried out, based on experimental tests performed in the flume of the LOMC laboratory at scale 1:15, where the PTO is represented by an hydraulic damper. Experimental results are compared with a linear analytical model based on potential flow theory [5]. The analytical PTO is modelled by a linear damping whose values are obtained from experimental calibration. The experimental results are in good agreement with the analytical model. In the preliminary cases where no PTO is added to the floating system, the analytical model requires a correction (FIG. 1). The efficiency of the PTO system in irregular waves is studied. The maximum efficiency obtained is superior to 30% (FIG. 2). The results are encouraging because no optimization was performed.         In a second time, the impact of the floating buoy on overtopping is studied. The experimental results are compared with the analytical model, where the wave height at the dike is given using Van der Meer formula [6]. Experimental and analytical results show that the presence of the floater can reduce overtopping when at the same time the toe clearance is small and the wave length is high (FIG. 3).          REFERENCES   [1] A. F. de O. Falcão, Wave energy utilization: A review of the technologies,  Renew. Sustain. Energy Rev. , vol. 14, no. 3, pp. 899–918, Apr. 2010   [2] J. Falnes, ‘A review of wave-energy extraction’,  Mar. Struct. , vol. 20, no. 4, pp. 185–201, Oct. 2007   [3] M. Folley and T. J. T. Whittaker, ‘Analysis of the nearshore wave energy resource’,  Renew. Energy , vol. 34, no. 7, pp. 1709–1715, Jul. 2009   [4] G. Elchahal, R. Younes, and P. Lafon, ‘The effects of reflection coefficient of the harbour sidewall on the performance of floating breakwaters’,  Ocean Eng. , vol. 35, no. 11, pp. 1102–1112, 2008   [5] Y.H. Zheng, Y.M. Shen, Y.G. You, B.J. Wu and D.S. Jie, “On the radiation and diffraction of water waves by a rectangular structure with a sidewall”,  Ocean Engineering , vol. 31, pp.2087-2104, 2004.   [6] Van der Meer, J., 2002. Technical report wave run-up and wave overtopping at dikes. TAW report incorporated in the EurOtop manual. ","authors":"Sixtine Neuveglise, Gaele Perret, Hassan Smaoui, Francois Marin and Philippe Sergent","topic":"3","file":"1399-5032-1-DR-OK.pdf","bib":"WAVDEV-1399.bib"},
{"paperid":"1401","title":"Small scale optimization of an OWC device","keywords":"Waves interacting with an Oscillating Water Column (OWC) device transfer part of their energy to the air, which flows through a turbine. For terminator OWC devices, all the remaining amount of incident wave energy is reflected offshore; wave heights and wave related loads at the front wall depend strongly on the characteristics of air-water interactions inside the pneumatic chamber. Therefore, the device efficiency and stability are strictly related to each other. Both issues must be considered in order to carry out a holistic optimization of OWC devices.   Here, a small scale physical model of OWC has been adopted (shown in Figure 1). The internal chamber geometry and the front wall can be modified easily to test different configurations of the system. Laboratory tests have been executed at the Hydraulic Laboratory of the University of Catania, in a wave flume 18.0 m long and 1.2 m high, with a set of 9 irregular wave conditions having mean JONSWAP spectra. The characteristics of waves are similar (Froude scale 1:18) to those simulated in the large scale tests carried out by Allsop et al. (2014) at the GWK facility in Hannover, having significant wave heights Hs=0.4-1.0m and peak wave period Tp=3-6s (see for details Viviano et al. 2016).   The wave flume in Catania is equipped with six wave probes placed along the flume and at the OWC device, for investigating wave reflection and hydrodynamics at the device, respectively. Furthermore, three pressure sensors provide information on the wave impacts at the front wall and within the internal chamber.   The optimization of the OWC is faced here by varying the geometry conditions of the pneumatic chamber (width B and height h t ) and the submergence a of the front wall. Furthermore, the characteristics of the Power Take Off (PTO) have been simulated by a circular orifice, whose diameter d 0  has been varied.   Since the small scale OWC adopted in Catania is scaled 1:18 with respect to the GWK large scale model, the consequent small scale effects have been analyzed in Viviano et al (2018). Such scale effects are taken into account in the present application. In particular, here the variation of the height of the chamber aims at compensating for the differences in scaling water and air inside the chamber.   The results of the optimization procedure highlight that the reflection coefficient is highly dependent on the submergence a of the front wall. In particular, the optimal conditions are achieved when the ratio between such a submergence and the still water depth (d) is about 1/3.   The variation of the orifice dimension in a range compatible with the PTO functionality does not show a strong effect on the OWC response.  Finally, the influence of the width of chamber (B) is significant in the OWC optimization and is related to the wave length corresponding to the peak period of the incident waves (L p ). The optimal values of the ratio B/L p  are obtained in the range 0.1-0.15. ","authors":"Antonino Viviano, Stefania Naty, Rosaria E. Musumeci, and Enrico Foti","topic":"3","file":"1401-4710-2-DR-OK.pdf","bib":"WAVDEV-1401.bib"},
{"paperid":"1402","title":"A stochastic method to account for the ambient turbulence in Lagrangian Vortex computations","keywords":"Summary       :      This paper presents recent developments performed in a Lagrangian Vortex Method software to account for ambient turbulence.     The results on wakes formed behind arrays of 3 bladed tidal turbines in various inflow conditions will be presented and discussed.              The development of marine current turbines arrays has been an active research topic for some years. However, many studies are still necessary in order to fully understand the behaviour of such arrays,     one of which concerns     the impact of ambient turbulence on the behaviour of tidal turbines. Indeed recent     investigations     have shown that ambient turbulence intensity highly modifies the behaviour of interacting turbines [3]. Consequently, numerical simulations must represent the ambient turbulence or at least its effects on the turbines performance and wake. This paper presents the latest numerical developments carried out at LOMC in collaboration with IFREMER in order to take into account the effects of ambient turbulence [1] and wake interaction [4].              A module based on the Synthetic-Eddy-Method initially proposed by Jarrin et al. [2] was implemented in the numerical code in order to represent the ambient turbulence.     This ambient turbulence model is capable of reproducing a perturbed flow of any given turbulence intensity I     ?      and any anisotropic ratio (?     u     :?     v     :?     w     ),     which was verified mathematically in the absence of turbines.     The ambient turbulence model has been further validated by comparing wakes computed for individual turbines with test data from IFREMER, carried out with     low or high turbulence intensities    .                      The final goal of this study is the computation of an entire farm of marine current turbines for any       type of turbulent inflow      .       Computations of various configurations of 3 interacting      turbines have been     performed     in order to compare the results with     the latest experimental trials performed at IFREMER    .     Further simulations were then carried out,     using the full range of the numerical model in order to investigate the impact of different turbulence parameters    .     These tests will allow for a more realistic account of turbulent conditions in the context of numerical simulation.                           Fig    ure         1:     Example of     the wake of     3 interacting turbines.                           References:           [1] C. Carlier, G. Pinon, B. Gaurier, G. Germain, and E. Rivoalen. A synthetic eddy-method to represent the ambient turbulence in numerical simulation of marine current turbine. In 10th European Wave and Tidal Energy Conference (EWTEC), 6-11th Sept. 2015. Nantes, France.         [2] N. Jarrin, S. Benhamadouche, D. Laurence, and R. Prosser. A synthetic- eddy-method for generating inflow conditions for large-eddy simulations. International Journal of Heat and Fluid Flow, 27:585–593, 2006.         [3] P. Mycek, B. Gaurier, G. Germain, G. Pinon, and E. Rivoalen. Experimental study of the turbulence intensity effects on marine current turbines behaviour. part II: Two interacting turbines. Renewable Energy, 68(0):876 – 892, 2014.           [4]      P. Mycek, G. Pinon, C. Lothodé, A. Dezotti, and C. Carlier. Iterative solver approach for turbine interactions: application to wind or marine current turbine farms. Applied Mathematical Modelling, 41:331 – 349, 2017.       ","authors":"Camille Choma Bex, Clement Carlier, Benoist Gaston, Gregory Pinon, Gregory Germain, and Elie Rivoale","topic":"6","file":"1402-4958-2-DR-OK.pdf","bib":"TIDHYD-1402.bib"},
{"paperid":"1403","title":"On the Effect of elastic Blade Deformation on the Performance of a horizontal Axis Tidal Current Turbine","keywords":"An elastic deformation of the blades of modern small tidal turbines with blades manufactured from composites is unavoidable and even used to control their performance. In first model scale tests of a new turbine, however,  a rigid model is preferred. Due to the delicacy of model turbines, however, undesired blade deformation can not be excluded. Axial bending, i.e. in direction of the ingested inflow, may have a minor impact, but torsion around the radial axis and the thus effect of a variation of pitch angle distribution  is seen of utmost relevance. The objective of this contribution is a numerical and experimental assessment of the torsion-related performance modification of a model scale test turbine made of brass.   To predict the bending and twisting an extended and validated blade element momentum (BEM) model, predicting the turbine performance including the cavitation characteristics, was coupled to the finite element method (FEM) solver from ANSYS Mechanicals ® . Based on an initial load prediction by the BEM, the deformation of blades was determined via the FEM iteratively. Eventually, the resulting power, thrust and cavitation characteristics were derived.   The deformation of a 1:12.6 brass model of a 6.3 m fixed pitch horizontal axis tidal turbine was predicted for a wide operating range utilizing the BEM-FEM coupling. It was found that the axial bending of the blades was accompanied by a distinctive torsion which led to increased pitch angels. Comparing the performance predictions for the rigid and flexible rotor blades showed that the obtained variation in pitch angle distribution led to i) a slightly decreased power output, ii) a considerably reduced thrust loads and iii) somewhat lower critical cavitation number.   Experimental performance characteristics of the - unavoidably flexible - model scale turbine were obtained in comprehensive towing tank and cavitation tunnel tests. A comparison with the prediction strongly suggests, that the model-scale turbine experienced the deformation as obtained from the FEM.     ","authors":"Nicholas Kaufmann, Thomas H. Carolus, and Ralf Starzmann","topic":"4","file":"1403-4734-2-DR-OK.pdf","bib":"TIDDEV-1403.bib"},
{"paperid":"1405","title":"An investigation into Reynolds scaling and solidity for a HATT tidal turbine","keywords":"For the last 15-20 years, testing and development of scale model turbines has been utilised in both research and by turbine developers. The use of scale model testing has allowed developers to further understand design decisions during early technology readiness levels ( TRLs ) with relatively small investments needed. In terms of research, the use of scale model  HATTs  has proliferated and allowed researchers to understand the fundamental fluid dynamics, loading mechanisms and efficiencies associated with a variety of  HATT  rotor set ups.   Scale model testing has formed a vital part of modelling research activities, allowing modelling researchers to validate code and model set ups against experimental data.  Generally, scale testing to-date has proceeded at the 1/30th to 1/20th scale which is in line with the size of facilities available for testing such devices. The use of nursery sites, however, has allowed for the development and testing of 1/5th scale devices - which is often a crucial step in moving towards a higher  TRL  full-scale deployments. As the turbine development detailed within this paper is specific to a 1/20th scale  HATT  this review section will be constrained to consider the form case exclusively.   This paper presents a fundamental study into the effects of Reynolds Number and Rotor Solidity when testing HATTs at 1/5 th  scale, 1/20 th  scale and 1/30 th  scale. The paper utilises a mixture of 1/30 th  scale (0.5 m diameter) experimental data for two, three and four rotor setups, 1/20 th  scale (0.9m diameters) experimental data for a three blade rotor setup as well as CFD data at the 1/5 th , 1/20 th  and 1/30 th  scale for a variety of rotor setups.   To study the effects of Reynold scaling and solidity on HATT performance, non-dimensional performance parameters for all the data sources are compared. The characteristic curves are considered for, ‘Reynolds Independence’, whereby momentum forces in the fluid become dominant in the setup, to such a degree as to provide comparable non-dimensional characteristics for rotors of differing dimensions. Here Reynolds number is generated using the characteristics length of the blade chord at 75% of the blade length.   Initially the point of, so called, ‘Reynolds Independence’ is found for the three bladed rotor case. The point of Reynolds Independence is then found for the differing rotor setups and compared. The results show a power shift of the performance curve against tip speed ratios with a slight change in power capture.   The paper closes with discussion on the practicalities of identifying Reynolds scaling effects in experimental data, the apparent effect of solidity on Reynolds Independence and lastly, a brief comparison of the performance of the two, three and four bladed HATTs is made. ","authors":"Matthew Allmark, Stephanie Ordonez-Sanchez, Sujin Wang, Yo Seop Kang, Chul- Hee Jo, Tim O'Doherty, Cameron Johnstone","topic":"4","file":"1405-4800-2-DR-OK.pdf","bib":"TIDDEV-1405.bib"},
{"paperid":"1412","title":"Preliminary results from a scaled test of arrays of point-absorbers with 6 DOF","keywords":"In the context of wave energy development, it is well-known that wave energy converters (WECs) will have to be deployed in arrays of multiple units in order to satisfy a large scale energy demand. In particular, this is true for point-absorbing WECs. At the present stage of the research, developers need to rely on simulations tools in order to predict the power output of the park and to optimize the design variables (such as, for example, the geometrical layout of the park and many others). Few real scale tests of arrays have been performed until now, and even fewer full scale off-shore tests, resulting in a very small data set available for validation of numerical models.   This paper present preliminary results from an experimental campaign of an array of point absorber WECs conducted in the COAST Lab at Plymouth University, UK. The experimental setup consist of 6 identical ellipsoidal floaters connected via ropes and pulleys to 6 power take-off systems (PTO) located on the main gantry. The model represents a 1:10 scaled prototype of an array of point absorber composed by a 5 m buoy installed at 25 m depth, based on the WEC concept developed at Uppsala University, Sweden. The buoys are connected via a line to generators; the motion of the waves is transferred to the linear generator and electricity is produced by Faraday’s law.   The full experiment consists of studying the performance of different array layouts and compare the results with earlier optimization simulations performed with genetic algorithms [1], and also to study the performance using different control algorithms. In this paper, the focus is on one array layout, where the buoys are arranged in 3 rows parallel to the wave front (Figs. 1 and 2). The PTO is performed by passive damping using a rotatory system appositely designed for the wave tank experiment (Fig. 3), described in details in [2]. During the experiment the position of the ?oater in 6 DoF, the wave elevation at 10 different point in the wave tank and PTO data (position, velocity, damping values) were acquired. Different regular and irregular unidirectional waves have been tested.   The results in terms of motion response and power output for different sea states (regular and irregular) and for each buoy have been compared to the behaviour of the isolated device presented in [3], allowing the calculation of the q-factor to evaluate how the WECs in the array perform as compared to single devices.      References:   [1] Giassi, M., &amp; Göteman, M. (2018). Layout design of wave energy parks by a genetic algorithm.  Ocean Engineering ,  154 , 252-261.   [2] Thomas, S., et al (2018). Performance of a Direct-Driven Wave Energy Point Absorber with High Inertia Rotatory Power Take-off.  Energies ,  11 (9), 2332.   [3] Giassi M. et al (2018). Experimental Results from a Scaled Test of a Point Absorber Wave Energy Converter with direct-driven Power Take–Off, manuscript.        ","authors":"Marianna Giassi, Simon Thomas, Zahra Shahroozi, Jens Engstrom, Jan Isberg, Tom Tosdevin, Martyn Hann, and Malin Goteman","topic":"3","file":"1412-4917-1-DR-OK.pdf","bib":"WAVDEV-1412.bib"},
{"paperid":"1413","title":"NoiseSpotter: A rapidly deployable acoustic monitoring and localization system","keywords":"NoiseSpotter is a cost-effective environmental monitoring system that characterizes, classifies, and provides accurate location information for anthropogenic and natural sounds. It has been developed with the primary goal of supporting the evaluation of potential environmental effects of offshore energy devices. NoiseSpotter consists of a compact array of three acoustic vector sensors that measures acoustic pressure and the three-dimensional particle velocity vector associated with the propagation of an acoustic wave, thereby inherently providing bearing information to an underwater source of sound. By utilizing an array of three vector sensors, the NoiseSpotter triangulates individual bearings to provide sound source localization, allowing for a characterization of the acoustic signature of specific acoustic sources located in different regions of the ocean. NoiseSpotter data are currently stored locally onboard, and continued development will result in onboard processing and real-time transmission of data digests for web-based data presentation. Data digests will include acoustic metrics for noises of interest such as source location, peak sound levels, and signal-to-noise levels, along with ambient noise levels.  A series of NoiseSpotter field trials have been conducted to evaluate its ability to locate and characterize sources of sound. Controlled transmissions of pure acoustic tones were recorded by NoiseSpotter at frequencies ranging between 100 Hz and 3000 Hz in a quiescent basin (26 m water depth), an energetic tidal channel (8 m water depth), and a deeper site in 70 m water depth. Tones were transmitted from a fixed vessel at distances that varied between 50 m and 1 km from the NoiseSpotter. Results from the field trials indicate that the NoiseSpotter is a suitable technology for noise characterization and geolocation of offshore sounds, such as those made by a controlled acoustic source or a passing vessel. The accuracy of NoiseSpotter’s geolocation is currently within 5% of true bearing and azimuth and within 5% of the range between the known source and the vector sensor array, assuming a known source depth.  The geolocation and characterization of sounds in the ocean is particularly important when there are multiple sources of sound in the ocean that can confound traditional sensing technologies. Acoustic sensing techniques typically involve the use of hydrophones that measure acoustic pressure, a scalar quantity that provides no directional information as to the location of the source of sound. As a result, sound source localization is typically achieved by large arrays consisting of multiple time-synchronized hydrophones. A technology such as the NoiseSpotter demonstrates the ability to locate and characterize sounds in the ocean using a compact array of vector sensors, which provides a reliable method to discriminate varied sources of sound in its vicinity.   Figure 1. True and  estimated source locations using the location estimation algorithm. The  estimated location is within 3.6 m of the source over a separation  distance of 200 m. ","authors":"Kaustubha Raghukumar, Grace Chang, Frank W. Spada, and Craig A. Jones","topic":"9","file":"1413-4833-1-DR-OK.pdf","bib":"ENVIRO-1413.bib"},
{"paperid":"1414","title":"Development towards a nested hydrodynamic model for the numerical analysis of ocean wave energy systems","keywords":"Numerical wave tanks (NWTs) provide a cost efficient and accurate tool to assess the complex fluid dynamic phenomena around wave energy converters (WECs), interacting with waves. With the increased availability of computational resources, high fidelity methods based on the Reynolds-averaged Navier-Stokes (RANS) equations are increasingly applied to this type of analysis.   Especially for an assessment of WECs in power production mode, i.e., resonant motion with the incident wave field and subject to control action, RANS-based NWTs can provide accurate solutions, while simpler models, e.g. based on potential flow (PF) theory, may meet their boundaries.   However, the computational cost for a RANS based analysis of WECs is usually very high and may become prohibitive, when large scale wave propagation effects have to be considered, as in the case of WEC arrays. These phenomena can more efficiently be modelled using PF solvers.   Nested hydrodynamic models can be used to combine the advantages of RANS and PF solvers. Here, only the near flow field of the WEC is considered by the RANS solver, whereas the pure wave propagation problem in the far field is solved by the PF model. Thus, the overall solution effort can be decreased while maintaining high fidelity in the area around the WEC.   This paper presents the development of a new, two-way coupled, nested hydrodynamic model with special emphasis on typical wave energy applications.   The proposed approach is based on the work done by Paulsen et al. (Bo Terp Paulsen, Henrik Bredmose, and Harry B. Bingham. An efficient domain decomposition strategy for wave loads on surface piercing circular cylinders. Coastal Engineering, 86:57-76, april 2014) and establishes a two-way information exchange between the fully non-linear potential flow solver OceanWave3D and the wave generation and absorption toolbox waves2Foam for the OpenFOAM environment. The new nested model is successfully verified and validated against both theory and experimental data.  Furthermore, it is shown for some typical NWT applications that the computational cost may be decreased by using the nested model while maintaining similar accuracy with respect to pure RANS solutions. Some limitations are found which hamper a broader applicability of the method and must be addressed as part of future work. ","authors":"Jost Kemper, Christian Windt, Kai Graf and John V. Ringwood","topic":"5","file":"1414-4689-2-DR-OK.pdf","bib":"WAVHYD-1414.bib"},
{"paperid":"1415","title":"Modelling Wave Interaction with thin porous Structures using OpenFOAM","keywords":"KEYWORDS:  CFD, OlaFlow, OpenFOAM, thin porous structures, wave structure interaction  In coastal and ocean engineering porous structures are often used to dissipate the energy of incoming waves onto fixed or floating bodies. This work is an initial step to investigate the application of a porous shroud around the platform of floating offshore wind turbines or similar marine renewable energy systems.   Most Computational Fluid Dynamics (CFD) models for porous structures have focused on large-volume porous structures such as concrete or rubble-mound breakwaters. In contrast to that, this paper looks at thin porous structures, such as perforated steel plates. It presents the development of a robust set-up for a numerical wave tank (NWT) and an assessment of the use of CFD for modelling the wave interaction with fixed thin porous sheets.   For the CFD simulations, the open-source code OpenFOAM was used together with the OlaFlow toolbox, which provides wave modelling methods as well as a macroscopic porosity implementation.   The main objective is to analyse the wave interaction with fixed vertical porous sheets in regard to the pressure loss across the sheet. Basic studies are carried out to achieve a robust set-up of a NWT including thin porous media, which can be used for further, more detailed studies. The CFD simulations are compared against measurements from tank test results. ","authors":"Anna Feichtner, Ed B. L. Mackay, Gavin Tabor, Philipp R. Thies, Lars Johanning","topic":"5","file":"1415-4993-1-DR-OK.pdf","bib":"WAVHYD-1415.bib"},
{"paperid":"1418","title":"Excitation force estimation for wave energy systems using a moment-domain representation","keywords":"To maximise the energy converted from a Wave Energy Converter (WEC), a real-time control law is required, which, due to its non-causal nature, necessitates the knowledge of the wave excitation force (F x ) (input to the system) in future time. This future excitation force time series is usually obtained using forecasting strategies, which are essentially based on present and past values of F x . Unfortunately, the excitation force is virtually always a non-measurable quantity, which leads to the necessity of a suitable estimation. Though there have been several methods developed for both the estimation and forecasting problems, some drawbacks can be identified. The main deficiency comes from the convolution term accounting for the effect of radiation forces acting on the WEC. The usual approach is to approximate this convolution operation by a state-space representation. However, the more accurate the approximation, the higher the dimension of the model representing the WEC dynamics. This can potentially constitute a problem for real-time capabilities as it naturally increases the computational complexity.       In this paper, we propose a moment-based excitation force estimator which has no requirement of an approximation of the radiation force convolution term, thus greatly reducing the computational complexity, leading to improved real-time capabilities. This strategy is based on recent advances in moment-based theory (particularly in the control area), and exploits a particular parameterisation of the steady-state response of the WEC, providing a sensible set of mappings to compute the estimation of the excitation forces, which is intrinsically related to the WEC dynamics. To the best of our knowledge, this is the first application of the moment-based framework to any estimation problem. The potential of this method is illustrated by the means of a numerical example for a single degree of freedom WEC. ","authors":"Jake Cunningham, Nicolàs Faedo, and John V. Ringwood","topic":"7","file":"1418-4810-4-DR-OK.pdf","bib":"GRDPTO-1418.bib"},
{"paperid":"1420","title":"Investigation on the sea-state performance of a horizontal axis tidal turbine designed for less energetic flows","keywords":"Current installations of tidal stream turbines are mainly done in regions with higher energetic tidal currents that reach speeds greater than 3 m/s. While higher velocity flows contain more energy, TST’s require engineering to withstand higher loads. This increases the cost of TST projects, making the LCOE of TST technologies to be relatively high compared to other renewable energy technologies, except for wave [1].   Lesser energetic flows (v &lt; 2m/s), such as those in South East Asia [2,3] and even those in the west coast of the UK [4, 5] would generate far less energy; only a quarter of the power extracted in energetic sites may be produced if traditional TSTs are to operate at these regions. Nonetheless, lower structural loading will be experienced, which could translate to lower cost of manufacturing, operation, and maintenance.   The potential reduction in system capital cost may be realised in ways other than just downsizing and using cheaper materials. Current TST design is based on the operation within a typical TSR range (TSR &lt; 4) resulting in large torque production. This level of torque cannot be attained in lesser energetic flows without severely impacting on device rotational speed and power production. This reduced torque may be offset by increasing the rotational speed of a rotor, resulting in smaller generators operating at higher rpm for the same amount of power. However, operation of TSTs within a higher TSR range (TSR &gt; 6) is not normally adopted for energetic flows due to the risk of cavitation, although operating at these TSRs may not be a problem in lesser energetic flows.   A modified NACA 638xx blade with a lower solidity [6] has been evaluated. This is found to have a slight reduction in maximum Cp of less than 5% compared to the base NACA 638xx blade, with the location of the maximum Cp increasing from TSR ? 5.5 to TSR ? 6.75. A static simulation found that the stresses on the blade are substantially low to allow further analysis on unsteady conditions. This work extends the exploration of a blade operating at high TSR’s within lesser energetic flow and unsteady sea-state condition, including time-varying loads, which induce fatigue on each blade.   Loads and performance are determined using the ESRU BEM code that incorporates unsteady sea-state conditions [7]. The results are now compared to the loads and performance at steady state conditions. The comparison provides an estimate of the contributions of the unsteady sea conditions and the wave-current interaction on the loads and performance of a blade designed for less energetic tidal flow.   Resulting wave-current interactions in the flow is evaluated for representative of lesser energetic tidal sites. The flow parameters are subject to accuracy checking via data obtained from a Philippine ocean energy developer with site data. This serves as a representative data set against which assessments can be undertaken. The time-varying forces on each annular blade section is calculated using the measured velocity for the specific depth along the water column.    ","authors":"Job I. Encarnacion, Cameron Johnstone","topic":"4","file":"1420-5021-1-DR-OK.pdf","bib":"TIDDEV-1420.bib"},
{"paperid":"1421","title":"Peak-shaving control - a new control paradigm for OWC wave energy converters","keywords":"The OWC (oscillating water column) is a class of wave energy converters (WECs) whose power take-off system comprises a turbine/generator set typically. Since its introduction in 2011, the biradial self-rectifying air turbine has set a new performance level against all other turbines for this type of applications. The biradial turbine designed and constructed within the framework of the ongoing European project OPERA – Open Sea Operating Experience to Reduce Wave Energy Cost is expected to contribute to further improve the OWC technology through the use of a high-speed safety valve (HSSV) installed in series with the turbine. The HSSV can be used, not only for phase control – latching – but notably also for peak-shaving control. Peak-shaving can be achieved by performing real-time control of the valve position to limit the turbine rotational speed. By constraining the power available to the turbine, the new control allows the WEC operation under more energetic sea states without overloading the generator, while increasing the capacity factor of the wave energy converter and improving the quality of the electrical energy supplied to the grid. The contribution of the paper is the introduction of a new non-linear feedback control algorithm to adjust the valve position as a function of the rotational speed. The proposed control algorithm was calibrated and tested at the new IST V-Flow Turbine Lab, a variable-flow turbomachinery test-rig with a 30 kW biradial air turbine-generator prototype. The turbine was designed at Instituto Superior Técnico, Lisbon (IST) and manufactured by the company Kymaner, for open-sea testing at the Mutriku breakwater plant and later to be installed at the OCEANTEC spar-buoy deployed at BIMEP, Basque Country, Spain, in the OPERA project. Results are presented to demonstrate the effectiveness of the control under simulated oscillating flow induced by irregular waves. Additional results include the turbine performance curves with the valve partially closed. These curves can be easily incorporated into time-domain models of OWC WECs. ","authors":"Joao C.C. Henriques, Ana A.D. Carrelhas, Luis M.C. Gato, Antonio F.O. Falcao, Juan C.C. Portillo, and J. Varandas","topic":"7","file":"1421-4935-2-DR-OK.pdf","bib":"GRDPTO-1421.bib"},
{"paperid":"1426","title":"Requirements for Realistic and Effective Wave Energy Technology Performance Assessment Criteria and Metrics","keywords":"Technology assessment criteria are often also referred to as metrics.  The idealized wish list for technology assessment criteria includes the following:   Criteria ideally are: objective, transparent, specific, measurable, simple, easy to understand, holistic, quantitative, also carry qualitative information, capturing all drivers and trade-offs, meaningful, repeatable, easy to use, no subject matter experts, low effort providing input for criteria determination, low time effort, fast assessment and evaluation time, existing or easy to develop assessment and measurement tools, low equipment requirements, low staff requirement, low cost, also carry qualitative information, applicable at all development stages while consistent in criteria and statement and at different levels of content and detail and accuracy, comparability of development progress across different technology archetypes.   It is not possible to satisfy all of the above-mentioned properties for assessment criteria at the same time, as there are several contradictions and related trade-offs to be considered.  To be in a position to develop realistic techno-economic wave energy performance assessment criteria that are applicable for effective use, supporting successful technology development, it is crucial to formulate all relevant requirements for these assessment criteria. In the process of formulating these requirements it is helpful to consider and answer several fundamental and guiding questions including the following:   At what system level should criteria be applicable? Wave energy plant level as an investment product, Wave farm with specific site conditions, Wave farm, WEC device, Balance of plant, Device sub-systems, Component level. Should criteria be agnostic? Across different marine renewable energy types, Across different wave energy archetypes, Across different archetype subsystems, Across different subsystem components? Where is the connection between criteria, observables and measurables? Different technologies types and designs have different observables and measurables. E.g. Air pressure in OWC, torque in hinged barge. Should the same criteria be determinable from the different measurables? Power absorption in OWC, hinged barge. Are criteria justified solely to ensure awareness? Known unknown versus Unknown unknown. Are criteria justified when it is difficult to quantify but important for the overall system performance? What level of accuracy of criteria is acceptable and realistic? Should systems of criteria be usable for sensitivity analysis? What level of consistency and similarity is desired across different markets? Could the adaptation of the criteria be achieved with the same fundamental criteria or combined with strongly differing weightings? Should there be required thresholds for individual criteria or combinations of these? What should the cost for the criteria determination and assessment be as a portion of the technology development cost? What should the time effort for the criteria determination and assessment be as a portion of the technology development time?  The above list contains only a selection of key questions to be answered for a development of wave energy technology assessment criteria. The paper will formulate and consider the full set of questions and give recommendations on the development of realistic and effective wave energy technology development criteria to further international development and success.","authors":"Jochem Weber, Ronan Costello, Kim Nielsen and Jesse Roberts","topic":"3","file":"1426-4792-1-DR-OK.pdf","bib":"WAVDEV-1426.bib"},
{"paperid":"1427","title":"Influence of Near-blade hydrodynamics on Cross-flow Turbine performance","keywords":"Within the wind and marine energy sectors, axial-flow (i.e., horizontal axis) turbines are a well-established and well-understood approach to converting the kinetic energy in a moving fluid to electricity. Recently, a renewed interest in cross-flow (i.e., vertical axis) turbines has yielded substantial performance gains through exploitation of unsteady hydrodynamics for individual turbines and mutually beneficial interactions between closely-spaced turbines in arrays. However, an understanding of the flow physics responsible for these gains remains incomplete. As one example, the coefficient of performance for a cross-flow turbine can exceed unity when evaluated on an instantaneous or phase-average basis. This could be interpreted as an energy harvesting phase that follows a period of energy accumulation, but the role of unsteady phenomena, such as dynamic stall, has not been established in this context. In contrast to axial-flow turbines, the unsteady hydrodynamics of cross-flow turbines means that a generalizable understanding of the relation between blade-level hydrodynamics and power performance cannot be obtained from analytical frameworks and remains an active area of computational fluid dynamics.   One way to explore the flow physics experimentally is through near-blade particle image velocimetry (PIV). In a few cases, researchers have conducted such measurements, but they are compared to turbine performance in a phase-average, rather than time-resolved manner. Here, we conduct a series of experiments on a cross-flow turbine and explore the phase-averaged and time-resolved relationships between near-blade hydrodynamics and power performance. Experiments are conducted on a two-bladed cross-flow turbine (NACA 0018 foils, chord length of 4.06 cm, turbine radius of 8.6 cm, blade height of 23.4 cm) instrumented with 6-axis load cells to measure torque produced and structural loads. For these experiments, the turbine is operated in a constant-velocity mode (i.e., angular velocity is invariant with azimuthal position) which minimizes cycle-to-cycle variations in power performance. Planar, two-component PIV measurements are collected around the turbine rotor by sequential illumination of the inner and outer blade surfaces allowing for an examination of both pressure- and suction-side flow fields. Near-surface laser reflections are reduced by a fluorescent coating on the blades and employing narrow band-pass optical filters at the laser wavelength. Two cameras are used, allowing for simultaneous examination of upstream and downstream blades and their interactions with the in-rotor flow field. Comparison of the time-resolved planar PIV fields and turbine performance data show a clear link between the formation of the leading edge vortex associated with dynamic stall and the torque produced by the turbine.  Such information provides insights into the blade-level hydrodynamics and suggests pathways for subsequent optimization of cross-flow turbines when operated in isolation or as part of a dense array. ","authors":"Abigale Snortland, Brian Polagye, and Owen Williams","topic":"4","file":"1427-4878-2-DR-OK.pdf","bib":"TIDDEV-1427.bib"},
{"paperid":"1428","title":"Hydrodynamic impact and power production of tidal turbines in a storm surge barrier","keywords":"To estimate the impact on energy production and environment of tidal turbines placed in the Eastern Scheldt Storm Surge Barrier a Computational Fluid Dynamics (CFD) study has been carried for a section of the barrier.      The Eastern Scheldt Storm Surge Barrier consists of 62 gates, and is constructed of concrete pillars, top beams and sill beams connecting to a rockfill sill construction and about 600m of bed protection on both sides. During ebb and flood the maximum head loss over the barrier is about 1 m, with maximum velocities of 4 m/s and higher, making it an ideal site for the generation of tidal stream energy.   The CFD model focusses on Gate No. 08 of the Roompot Section of the Storm Surge Barrier and includes half of the adjoining gates on either side. In this 40 m wide Gate a 1 MW array existing of Tocardo T200 tidal turbines will be installed as part of a demonstration project in 2015.   The CFD computations have been performed using STAR-CCM+. The flow through the barrier is simulated as a two-phase air-water system via the Volume of Fluid (VOF) method. The highly detailed pillar and sill geometry result in an extremely turbulent flow down steam of the barrier.   Transient computations of the barrier with and without the turbine array were carried out for a range of quasi stationary tidal phases. The turbines are resolved in detail as rotating equipment: real-time rotation of the turbine blades (involving the displacement of the mesh nodes in an unsteady setting) is implemented, and torque and thrust for the prescribed speed of rotation is provided as output. This output, along with velocity profiles, is successfully validated against measurements (directly measured from the generated power and from ADCPs).  Based on these computations an estimate of the effect of turbines on the discharge capacity of the storm surge barrier is given. This information can be used to parameterize the tidal turbines in the far-field hydrodynamic model of Eastern Scheldt estuary for an assessment of the effect of the placement of tidal turbines on energy production and on the environment.    ","authors":"Tom S. D. O’Mahoney, Anton de Fockert, Arnout C. Bijlsma and Pieter de Haas","topic":"6","file":"1428-4839-2-DR-OK.pdf","bib":"TIDHYD-1428.bib"},
{"paperid":"1432","title":"Playing with Currents","keywords":"Playing with Currents          Ir. J.H. Maas and ir. S.J. van Schaick, dr. ir. J. van Berkel, HZ University of Applied Sciences, Vlissingen       Due to the growing share of renewables, electricity companies are faced with growing needs for flexibility of their generating assets to follow the variations.   Gas-fired power plants are the most favorite power plants to deliver this flexibility, because of the fast control behavior of gas turbines.   On the other hand it is less attractive to produce power with these plants because they are less competitive on the present market due to the high gas prices compared with the low price of coal and the cheap (subsidized) renewables.   Because gas-fired power plants are low in the merit order at present, it is very expensive to put them in operation only to provide control and balancing power.   That is the reason that electricity companies are looking for other strategies and technologies to balance their portfolio and provide flexibility, like smart grids, load and demand management, energy storage, power- to-gas and power- to-heat.       In 2017 a research project is started in The Netherlands to investigate if a tidal power plant in the Brouwersdam could be operated in a ultra-flexible way, to balance the portfolio of an electricity supplier and to prevent congestion in the electricity grid of the network operator at the same time.   Therefore the turbines of the tidal power plant should be able to switch over between turbining mode, holding mode and pumping mode in a very short time, preferably within 10 sec:   [figure]        On the one hand the question is whether a very fast (&lt;10 s) switching of tidal power plants is technically feasible, on the other hand this will have an effect on the ecology and morphology of the tidal basin. Nowadays the lake has a lack of oxygen during dry summers, which can be partly prevented by opening the dam and allowing water exchange between the sea and the lake. The fast switching feature of the turbines could create a pulsation, increasing the water velocity and enhancing thus erosion.       In phase 1 of the project a laboratory model has been built to simulate these operation modes on lab scale, and to prove that this fast switching between the operation modes is feasible, using a very fast switching Louvre valve.   In phase 2 of the project the ecological effects of this flexible tidal power plant on the water quality, coastal erosion, flora and fauna of the tidal basin are being investigated.       Results of laboratory experiments will be shown, as well as the results of the investigation of the erosion effects of the fast switching tidal power plant. ","authors":"Jan H. Maas, Samantha J. van Schaick, and Jacob van Berkel ","topic":"4","file":"1432-4789-2-DR-OK.pdf","bib":"TIDDEV-1432.bib"},
{"paperid":"1433","title":"Gyroscopically enhanced vertical axis pendulum for wave energy conversion","keywords":"Extended abstract:   The vertical axis pendulum is a type of point absorber which can absorb wave power from a width exceeding the physical width of the device. The basic concept consists of a direct connection at the pivot point to the generator. Mechanical power is harvested from the rotation of the pendulum. In this paper, a new concept of the vertical axis pendulum device is proposed, adding a spinning flywheel to create a gyroscopic effect with the aim of controlling the motions of the pendulum and increasing its efficiency, when compared to the classical vertical axis pendulum. Efficiency can be increased by the reduction of start-up and stopping losses as well as motion control in different sea states.   An integrated model is established, using the Lagrangian method to couple the six degrees of freedom of the floater with the two degrees of freedom pendulum system. In the vertical axis of the pendulum, the electromagnetic torque from the generator is included as a linear function of the pendulum rotation velocity to model the mechanical power conversion into electrical power. The spinning velocity of the flywheel is controlled using an iteration method to obtain the maximum electrical power.   The pendulum initially rotates, just like a classical vertical axis pendulum, due to wave actions on the floater and produces the mechanical power directly from the pendulum rotation. Part of the mechanical power is then used to control the spinning of the flywheel, creating the gyroscopic effect used to control the motion, while the rest is absorbed by the generator. To demonstrate the effect of having the flywheel in the pendulum system, two models are simulated and compared, i.e. a classical vertical axis pendulum and a ‘gyroscopic-pendulum’. The result of the comparison is presented in terms of the electrical power converted.   Further study of the gyroscopic-pendulum is planned, namely verification and validation of the numerical model and developing power take-off (PTO) model to optimize the power production of the system.       Keyword: gyroscopic effect, coupled pendulum, wave energy harvesting ","authors":"Lurohman M. Masturi, Hayo Hendrikse, Antonio J. Laguna, and Andrei V. Metrikine","topic":"3","file":"1433-4988-1-DR-OK.pdf","bib":"WAVDEV-1433.bib"},
{"paperid":"1434","title":"Climate Power Plant for Water Safety and Renewable Energy","keywords":"Dr. ir. J. van Berkel, Ir. J. Maas and Ir. S. van Schaick, HZ University of Applied Sciences, Vlissingen, The Netherlands.  Ir. Ing. A. Heutink, Dutch Ministry of Infra Structure and Water management, Rijkswaterstaat, The Netherlands.  Barrage type tidal power plants can be an effective measure to combine production of renewable electricity with protection of estuaries and adjacent area against rising sea water levels. The concept of Pumping Tidal Power Plants is new, not demonstrated before and relevant for Delta areas around the world.  All Delta areas are subject to a changing climate, involving weather extremities and rising sea levels. When in a Delta region extreme wet weather coincide with high sea water levels, high river discharges can no longer be discharged to sea, resulting in extremely high water levels in the delta and flooding of cities. Worldwide this has been observed to occur more regularly and is expected to happen more frequently due to additional rising sea levels.  The concept of Pumping Tidal Power Plants may be used in extreme conditions to actively pump river discharge to sea. In addition it can also be used under “normal” conditions in cases where the (rising) mean sea level lies above the mean basin level. In these cases Tidal Power can be generated flood-mode, when sea water (at elevated level) is allowed to enter the basin. In the counter eb-mode, pump action can actively force the river discharge (via the basin) towards sea.  The advantage of the concept is that one structure (civil works and pump/turbines) has a double functionality and likely is more costs-effective than a separate pumping station and Tidal Power Plant. In addition, due to the regenerative nature, the structure may deliver energy rather than it consumes in case of a pumping station alone.  The concept of the “Pumping Tidal Power Plant” is currently under investigation for application in the Brouwersdam (The Netherlands). Within the framework of another project “Playing with Current(s)” the hydro-mechanical characteristics of “Pumping Power Plant” is tested to scale in the laboratory of HZ University (Vlissingen). For that purpose an axial (propeller) pump/turbine supplied by Nijhuis-Pentair is built into a dedicated test rig. Aim of the test set-up is to prove (in 4 quadrants) that the concept is technically realizable, with adequate reliability (mechanical integrity and hydrodynamic stability), acceptable efficiency and at acceptable costs.         Figure          a) Modelled tidal variation b) laboratory test set-up and c) Pump/turbine.   The paper provides details about the design of the Brouwersdam system and laboratory system, the test results and modelled performance of full scale Pumping Tidal Power Plants.  The paper also provides insights in how this concept can be realized in practice, by combining the concept of Pumping plants in deltas with water safety and water level management. This concept is also economically feasible from a recent business case study. In this respect, the government pays for water quality and water level management and funds the market for sustainable energy production, maintenance and connection to the network.    ","authors":"Jacob van Berkel, Jan H. Maas, Samantha J. van Schaick and Andreas Heutink","topic":"4","file":"1434-5061-1-DR-OK.pdf","bib":"TIDDEV-1434.bib"},
{"paperid":"1435","title":"Introducing non-rigid body structural dynamics to WEC-Sim","keywords":"Keywords   Wave Energy Converter (WEC); concept design; numerical modelling; load analysis; structural analysis; coupled analysis; hydro-elastic analysis; WEC-Sim.     Abstract   WEC-Sim is an open-source code dedicated to the dynamic analysis of Wave Energy Converters (WECs). It implements a time-domain formulation using linear-wave theory and coefficients generated from a frequency-domain solver (e.g. WAMIT), allowing for additional load sources such as those associated with the Power Take-Off (PTO) system to be simultaneously accounted for.   When calculating the dynamic response of a body, WEC-Sim currently uses a rigid body dynamics approach, where each hydrodynamic body is treated as a single point with mass and inertia properties. Such an approach ignores the potential effects of structural deformation on the WEC, which can potentially affect e.g. distributed load sources and / or the hydrodynamic loads. As an extreme example, hydrodynamic loads may excite fundamental frequencies of the structure, leading to resonance and potentially the destruction of the device.   Several software tools used in the offshore wind industry (e.g. HydroDyn) follow coupled, hydro-elastic, time-domain formulations. These tools typically use a Finite-Element (FE) approach to solve the structural dynamics. Following a similar approach, a structural dynamic add-on using a FE solver in conjunction with WEC-Sim can be proposed to enable hydro-elastic, time-domain analysis of WECs.   In this paper, a loose coupling approach is described, where the FE solver takes loads calculated by WEC-Sim at each time step as an input. This allows calculation of distributed loads and reaction forces on a WEC through time. The deformed shape is passed back to WEC-Sim to update the inputs for the calculation at the next step.   The add-on is then tested using an Oscillating Wave Surge Converter (OSWC), currently developed as part of the H2020 MegaRoller project. A range of stiffnesses are investigated to assess the sensitivity of the WEC to the hydro-elastic coupling. In particular, the dynamic response of a near-rigid body, a more realistic structural design and a reduced-stiffness material are investigated and compared.   The results are expected to contribute to increasing the fidelity of concept-level load calculations, by facilitating the interface with structural design orientated tasks.      Acknowledgements   This project has received funding from the European Union’s Horizon 2020 research and innovation programme under grant agreement No 763959. ","authors":"Joshua Scriven, P. Laporte-Weywada, J. Cruz","topic":"5","file":"1435-4909-1-DR-OK.pdf","bib":"WAVHYD-1435.bib"},
{"paperid":"1436","title":"An initial characterisation of a tidal stream turbine on a drive train test rig","keywords":"The long-term operational availability and reliability of marine energy tidal stream turbines (TST) devices have yet to be proven. There are therefore risks of higher operational costs and a major uncertainty surrounding their operation and maintenance [1]. A condition-based maintenance (CBM) strategy has the potential to increase availability and reduce maintenance costs while improving the competitiveness of TSTs when compared with other renewable energy technologies [2]. Different approaches, from computational modelling to experimental testing, have allowed researchers to explore the use of CBM approaches. However, one of the most considerable remaining challenges is to establish the capability to translate the results from experimental to full scale TSTs.   This paper presents an approach to characterise turbine behaviour by the use of a simulator drive train test bed. The aim is to develop and validate CBM strategies. The test rig consists of two coupled Bosch Rexroth IndraDyn MSK 050Cs rotors that are coupled via a GTE 120 gearbox. The rotor and generator are synchronous permanent magnet machines rated with a maximum velocity of 4300 RPM and a maximum torque of 15 Nm, using a gearbox with a gear ratio of 20:1 [3]. The test bed will be used to predict the capabilities of future turbine performance monitoring with realistic and site-specific conditions.   Research undertaken by the Cardiff Marine Energy Research Group (CMERG) has developed representative TSTs simulations which will be adapted to run the drive test rig at 1/20th scale. A non-dimensional analysis will be presented to confirm the ability of the simulator test-bed to support a realistic flow resource characterisation. This will then be extended to model other inputs such as turbulence intensity, wake and wave measurements. The response and interaction of the drive train components within a TST will then be investigated. The purpose of this paper is to demonstrate the effectiveness of the simulator in replicating different inlet velocities and torque measurement data from experimental results of an existing CMERG turbine.   The flexibility that this test rig constitutes is essential in the engineering of cost-effective CBM outcomes. The test rig can also be used to determine appropriate parameters, such as tip-speed ratio and rotor angular velocity, given a low velocity profile with other realistic flow characterisation inputs. The longer-term intention of this work is to support the appropriate selection and subsequent CBM of a device able to extract the peak offered energy yield from low velocities, such as the ones found in Mexico.    References    [1] R. I. Grosvenor, P. W. Prickett, C. Frost, and M. J. Allmark, Performance and condition monitoring of tidal stream turbines, presented at the Second European Conference of the Prognostics and Health Management Society 2014, Nantes, France, 8-10 July 2014, 2014.   [2] A. Mérigaud and J. V. Ringwood, Condition-based maintenance methods for marine renewable energy,  Renewable and Sustainable Energy Reviews,  vol. 66, pp. 53-78, 2016.   [3] M. Allmark, R. Grosvenor, and P. Prickett, An approach to the characterisation of the performance of a tidal stream turbine,  Renewable Energy,  Article vol. 111, pp. 849-860, 2017. ","authors":"Edith Rojo-Zazueta, Matthew Allmark, Paul Prickett, Roger Grosvenor","topic":"7","file":"1436-4652-3-DR-OK.pdf","bib":"GRDPTO-1436.bib"},
{"paperid":"1438","title":"An upgraded model for the design of spar-type floating oscillating water column devices","keywords":"The design of floating oscillating water column devices to efficiently extract energy from the ocean waves depends on a wide variety of parameters. The limited range of frequencies of interest and the large sensitivity of some design parameters to the system power output makes this a complex design problem. Optimization algorithms are a common option to overcome these issues.This work is focussed on a floating oscillating water column (OWC) converter with an axisymmetric geometry, the spar-buoy OWC device. The device consists of a floater pierced by a small thickness tube open at the bottom to the sea water and at the top to the OWC chamber. The power extraction occurs due to the relative heave motion between the buoy and the OWC, which compress and expand the air chamber volume. The air chamber is connected to the exterior atmosphere through an air turbine. The dynamic system is modelled using a formulation in the frequency domain, based on linear wave theory and small amplitude motions. The buoy moves in six degrees of freedom and the OWC inner free surface is limited to heave. Linear hydrodynamic coefficients are calculated using a boundary-element method. Linearized approximations of drag forces due to real fluid effects are taken into account. The overall power output from real ocean waves is determined through a stochastic model using an idealised wave spectrum and the wave climate data from a coastal European Atlantic site.The converter optimization is focused on the maximization of the annual-averaged power output. Design parameters such as the shape of buoy, mass distribution and turbine damping are considered. Since the computationally demanding hydrodynamic coefficients calculation is only dependent on geometrical parameters, the optimization problem is divided in two different sub-problems to reduce the overall computational time: (i) main optimization; and (ii) internal optimization. The internal optimization problem is used exclusively to optimize the turbine and mass distribution parameters for a given converter geometry. This sub-problem is part of the main optimization problem, which is only dedicated to solving the geometrical problem. This strategy guarantees that each buoy geometry is evaluated with the optimum turbine and mass distribution parameters, therefore reducing the number of computations of the hydrodynamic coefficients. The optimizations are solved using gradient-free algorithms capable of dealing with constraints. The impact of parametric resonance on the system dynamics is accounted for empirically through the data of stability diagrams. Unrealistic geometries are avoided through the application of constraints.The results present optimized spar-buoy OWC geometries and corresponding power output values. The model suggested here proved to be a fast method to obtain efficient device configurations.","authors":"Rui P. F. Gomes, João C. C. Henriques, Luis M. C. Gato, and Antonio F. O. Falcão","topic":"3","file":"1438-4779-2-DR-OK.pdf","bib":"WAVDEV-1438.bib"},
{"paperid":"1439","title":"Methodology for fast iterations of tidal turbine blade designs using thermoplastic composite materials ","keywords":"Tidal energy is still in the early research and development phases, therefore the ability to quickly manufacture and evaluate prototype blades with new blade designs and materials is critical. This paper investigates using a Stratasys three-dimensional printer to rapidly prototype scale-model turbine blades by printing the blade tooling and using vacuum-assisted resin transfer molding to manufacture blades. The objective of this work is to develop a methodology for cost effectively designing and manufacturing model-scale tidal turbine blades to be used in testing campaigns, and to investigate the stresses developed in blades subjected to high energetic flows.   Even with the advantages of composite materials, commonly used thermoset resin composites have been shown to have significantly reduced tensile static and fatigue strengths when exposed to seawater conditions. New research on infusible two-part reactive thermoplastic resins has shown improved seawater saturated properties and a higher percentage recovery of mechanical properties upon being dried after saturation [ 1 ]. Infusible thermoplastic resins are also recyclable at the end of their lives and have reduced manufacturing cycle times, energy requirements, and manufacturing costs [ 2 ].   Demonstration blades were designed in ANSYS and manufactured using an infusible thermoplastic resin system called Elium ® . Figure 1 shows the 3-D printed mold, as well as the manufacturing infusion process and the final carbon-fiber tidal turbine blade. The tooling was printed in four sections and took just over a day to manufacture.   The 400 mm long blade geometry was developed as part of an international collaborative project called DyLoTTA led by Strathclyde and Cardiff Universities in the UK. The blade design used in this project is based on a Wortmann FX  63-137 profile and was optimised from a previous blade model using Blade Element Moment Theory. To investigate the structural reliability of the thermoplastic composites at a small-scale, the blade was analysed using ANSYS. The ANSYS blade was subjected to a pressure distribution similar to what it is expected to occur in tidal turbine blades following the methodology shown in [ 3 ]. Figure 2 shows the preliminary results of the ANSYS analysis.        Figure   1. left) 3D-printed mold, middle) infusion process, right) final blade         Figure   2 ANSYS design of the 400 mm long blade    The development of scale-model thermoplastic blades enables research into their fatigue performance in realistic conditions at a cost-effective scale, and manufacturing using 3-D printed tooling enables fast and low-cost blade design iterations.   References   1.                 Davies, P. and M. Arhant, Fatigue Behaviour of Acrylic Matrix Composites: Influence of Seawater .   Applied Composite Materials , 2018.   2.                 Murray, R.E., D. Swan, D. Snowberg, D. Berry, R. Beach, and S. Rooney. Manufacturing a 9-Meter Thermoplastic Composite Wind Turbine Blade. in ASC 32nd Technical Conference. 2017. Purdue University, USA.   3.                 Porter, K., S. Ordonez-Sanchez, T. Nevalainen, S. Fu, and C. Johnstone. Comparative Study of Numerical Modelling Techniques to Estimate Tidal Turbine Blade Loads. in Asian Wave and Tidal Energy Conference. 2016. Singapore.    ","authors":"Robynne E. Murray, Song Fu, Stephanie Ordonez-Sanchez, Kathryn Trubac, Tim O’Doherty, and Cameron M. Johnstone","topic":"8","file":"1439-4864-1-DR-OK.pdf","bib":"STRMAT-1439.bib"},
{"paperid":"1440","title":"Effects on the loading of horizontal axis turbines when operating under wave and currents","keywords":"The UK has set an ambitious goal to supply at least 15% of the energy demands of the country by 2020, with 30% coming from electricity, 12% from heat and 10% from transport [1]. According to the UK Renewable Roadmap [2], up to 300MW of marine renewables could be deployed by 2020. In the latest years, the sector has seen the rise–and fall–of full-scale, commercial tidal turbines. However, the effects of the dynamic loadings on a turbine caused by wave-current interactions are yet to be fully understood. And, in order to achieve this, controlled laboratory-scale testing has to be performed.       Previous studies related to wave-current interactions have been undertaken [3] [4]. According to [3], it was observed that the control strategy had a substantial effect on fluctuations of the thrust load when the turbine operated in waves, with the thrust fluctuations an order of magnitude higher when torque was held constant in regular or irregular wave-current conditions than when speed was set constant. It was also observed that the control mode did not affect the time history data under tow only conditions, because the variation in the loads was very small in this case.       The programme of work described by [3], has now been extended to take into account the effects of turbulent flows interacting with waves. Experiments were undertaken in the wave-current circulating tank at IFREMER, Boulogne Sur Mer. The tests were carried out at 1.0 m/s with regular and irregular wave heights. The regular and irregular wave cases were set so the wave height and period in regular waves matched the significant wave height and peak period in the irregular wave case. The wave frequency used during testing was set as 0.7 Hz along with a wave height of 0.2 m. The three bladed horizontal axis turbine of 0.9 m rotor diameter was equipped with appropriate sensors to measure torque and thrust. Additionally, strain gauges attached to the blade roots were used to measure the forces on the turbine blades. The effect of the control strategies to establish a set torque or speed is also investigated in this paper.           [1]     Official     Journal of the European Union, “Renewable Energy Directive 2009/28/EC,”     2009.       [2]     Department     of Energy &amp; Climate Change, “UK Renewable Energy Roadmap,” 2011.       [3]     K.     Porter, S. Ordonez-Sanchez, M. Allmark, R. Ellis, C. Lloyd, T. O'doherty     and C. Johnstone, “Laboratory Study of Tidal Turbine Performance in     Irregular Waves,” in  4th Asian Wave and Tidal Energy Conference ,     Taipei, 2018.       [4]     R.     Martinez, G. Payne and T. Bruce, “Experimental investigation of the effects     of oblique waves and current on the loadings and performance of tidal     turbines,”  Ocean Engineering,  vol. 164, pp. 55-64, 2018.             ","authors":"Rodrigo Martinez, Stephanie Ordonez-Sanchez, Matthew Allmark, Cameron Johnstone, Tim O’Doherty, Catherine Lloyd, Gregory Germain, Benoit Gaurier","topic":"4","file":"1440-4942-1-DR-OK.pdf","bib":"TIDDEV-1440.bib"},
{"paperid":"1443","title":"Evaluation of wave energy converter arrays within a sheltered bay","keywords":"Conversion to renewable energy sources is currently presented like an identity marked as a possible solution to the global energy crisis. Ocean wave energy is the least developed renewable energy source, despite having the highest energy per unit area. Decision-makers and the public are increasingly interested in converting wave energy into electricity. This study analyzes and compares the harvested wave energy generated by different Wave Energy Converters (WECs) arrays and their profitability within Todos Santos Bay, Baja California. Through numerical simulations, a realistic range of WEC device type, array configurations, locations, and incident wave conditions were examined. A hindcast of 22 years of wave climate data was used as boundary condition for the numerical models. For each chosen mooring site, a decision-support tool was applied to assist siting wave energy facilities, which allowed to balance the need for profitability of the facilities with the need to minimize conflicts with other ocean uses. Results indicate that the WEC device type and subsequently its size directly resulted in wave height variations in the lee of the WEC array. The wave power and harvestable wave energy gradually increased offshore as wave conditions intensify. On average the significant wave heights decreased up to 20% between modeled scenarios with and without WECs, without significant changes in the peak period and wave directions. However, sites with high economic potential for wave energy facilities were closer to cable landing points because of the cost of bringing energy ashore and thus in nearshore areas that support a number of different human uses. ","authors":"Emiliano N. Gorr-Pozzi, Héctor García-Nava, Melissa G. Jaramillo-Torres, Marco J. Larrañaga-Fu, Francisco J. Ocampo-Torres","topic":"1","file":"1443-5038-1-DR-OK.pdf","bib":"WAVRES-1443.bib"},
{"paperid":"1444","title":"Results of Wave Energy Experiments in the Maldives","keywords":"A Wave Energy Converter (WEC) to harness the power of breaking waves was discussed in previous papers (AWTEC2016, EWTEC2017, AWTEC2018). We have developed two units of scaled-down model, having a waterproof electric generator, and a turbine 35 cm in diameter, which is capable of generating 1 kW peak power with a water flow of 6m/sec. We tested on Kandooma Island in the Maldives since 2018 May. Our WEC devices are suitable for small islands where electricity costs are high, and fuel consumption needs to be reduced by development of renewable energy sources. It is essential that installation and maintenance of WECs require only a mobile crane. Here we report the results of field test at Maldives and future R&amp;D plan.  T. Shintake, Harnessing the Power of Breaking Waves, AWTEC2016  T. Shintake et al., Technical R&amp;D on a Surf Zone WEC, EWTEC2017  T. Shintake et al., Wave Energy Experiment at Maldives, AWTEC2018    ","authors":"Tsumoru Shintake, Katsutoshi Shirasawa, Jun Fujita, Shuji Misumi, Paresh Halder, Tamotsu Nagahama, Toshio Shindou, Hamish Taggart, Hikaru Kamimura and Hideki Takebe","topic":"3","file":"1444-4682-2-DR-OK.pdf","bib":"WAVDEV-1444.bib"},
{"paperid":"1446","title":"Lift-based wave energy converters – an analysis of their potential","keywords":"Lift forces on a body are generated when there is asymmetrical flow around the body resulting in a differential pressure field and net body force. The resultant potential flow field can be represented as the addition of circulation around the body to an irrotational flow field, so that the body force is proportional to the product of fluid velocity and the intensity of circulation. Thus, this hydrodynamic force sits neatly between buoyancy forces, which are due to fluid displacement, and diffraction forces, which are due to fluid acceleration.   To date only a few wave energy converters (WECs) have attempted to exploit lift forces, whilst hundreds have been developed that exploit buoyancy and/or diffraction forces. The major challenge for lift-based WECs appears to be a perceived difficulty in generating and maintaining the circulation required to generate lift forces in waves. This perception is understandable when the flow is viewed as oscillating but using a reference frame that rotates about a horizontal axis with the wave the flow is no longer oscillatory, but unidirectional (although not rectilinear). Circulation about a body is significantly easier to generate and maintain in unidirectional flow potentially overcoming a major perceived difficulty.   A WEC that rotates about an axis in a single direction driven by lift forces has two very attractive characteristics. Firstly, unidirectional rotation dramatically simplifies the power take-off (PTO) system as the rotation can be coupled to a conventional electrical generator relatively easily; there is no need for rectification. Secondly, the wave loads on the WEC can easily be reduced in storms by removing the circulation (in the same way that a wind-turbine survives storms) so the challenges of survivability are significantly reduced.  Although lift-based WECs have two very attractive characteristics, they also have two significant challenges to overcome. Firstly, the rotation of the body must be kept in-phase with the incident wave, which in irregular waves means continuous control of the angular velocity. Secondly, the lift force needs to be controlled to correctly match the incident waves. This paper presents a range of possible technical solutions to these two challenges that form the basis of a morphological analysis of lift-based WECs. In addition, first-order estimates of the potential performance of key configurations are also developed to help identify areas of most promise for lift-based WECs.","authors":"Matt Folley, Trevor Whittaker","topic":"3","file":"1446-4822-2-DR-OK.pdf","bib":"WAVDEV-1446.bib"},
{"paperid":"1448","title":"Finite-Order hydrodynamic Approximation by Moment-Matching (FOAMM) toolbox for wave energy applications","keywords":"The motion of a Wave Energy Converter (WECs) can be described in terms of the well-known Cummins’ equation. This dynamical model is an integro-differential equation, of the convolution class. Such a convolution term is related to the memory effect of the radiation forces acting on the body of the device. However, this mathematical operator often represents a drawback for several applications relevant to marine fields, and specifically, to wave energy. Firstly, from a simulation point of view, the convolution term represents a drawback due to the high computational effort that requires. Additionally, from an estimation/control point of view, such an operation is inconvenient since modern estimation/control techniques are usually based on the availability of a state space representation of the system (i.e. a set of first order differential equations). To overcome these disadvantages, authors usually approximate the convolution term using a suitable parametric model. Several methods can be found in the literature which attempt to identify a parametric model which approximates the infinite dimensional convolution mapping introduced by Cummins, with different strengths and weaknesses.    Recently, we (the Centre for Ocean Energy Research, COER) have presented a moment-matching based identification method for both the radiation convolution term and the complete force-to-motion WEC dynamics (wave excitation force to device velocity).To briefly summarise, this strategy allows for the computation of a model that exactly matches the frequency response of the target system at a set of user-selected frequencies, depicting an efficient method to compute a state-space representation for the dynamics of WEC. In fact, this moment-based strategy can inherently guarantee essential physical properties in the approximating model, such as internal stability. Motivated by both the theoretical and practical results obtained, that we have already reported in the literature, we have now developed the open source Finite-Order Approximation by Moment-Matching (FOAMM) MATLAB application, that implements this identification method systematically in a user-friendly fashion, using only raw frequency-domain data provided by hydrodynamic solvers.    The aim of this paper is, after a short description of the theoretical background behind our strategy, to thoroughly describe the structure, organisation and characteristics of the FOAMM toolbox. In addition, the relevant modes of operation and different options that the software comprises are explained, making special emphasis in their impact on the obtained parametric model. Moreover, we explicitly describe how to specify the required input variables from a user-perspective, which are shown to be directly obtained from frequency-domain hydrodynamic solvers. Finally, we provide a full step-by-step example on how to use the FOAMM application, to show how to fully exploit its characteristics.   ","authors":"Yerai Pena-Sanchez, Nicolas Faedo, Markel Penalba, Giuseppe Giorgi, Alexis Merigaud,Christian Windt, Demian Garc?a Violini, LiGuo Wang and John V. Ringwood","topic":"5","file":"1448-4992-1-DR-OK.pdf","bib":"WAVHYD-1448.bib"},
{"paperid":"1449","title":"Moment-Matching-Based Input-Output Parametric Approximation for a Multi-DoF WEC Including Hydrodynamic Nonlinearities","keywords":"We present in this paper a moment-matching method to compute aparametric approximation of the input-output (force-to-motion)response of a multiple Degree of Freedom (DoF) Wave Energy Converter(WEC), based on the algorithm presented in [1]. This method allows the user to select a set ofinterpolation frequencies where the approximating model exactly matches thesteady-state response of the target WEC under analysis, while being able toretain key underlying physical properties of the device. Furthermore, we show how to systematicallyaccommodate nonlinear effects using this approximation method,depicting an efficient and versatile approach to compute a parametric representation for WEC design, control and estimation procedures. Weillustrate the capabilities and characteristics of this method by means of a study case,using a CorPower-like (heaving point absorber) device. Our numerical analysis shows that, whencompared to the currently most-used methodology to parameterise thedynamics of a multi-DoF WEC, the proposed approach can computemathematical models with the same degree of accuracy and up to 50% of improvement in terms of computational time. ","authors":"Nicolas Faedo, Yerai Pena-Sanchez, Giuseppe Giorgi and John V. Ringwood","topic":"7","file":"1449-4933-1-DR-OK.pdf","bib":"GRDPTO-1449.bib"},
{"paperid":"1450","title":"CCP-WSI Blind Test 2: Modelling Focused Wave Interactions with Floating Structures with WEC-Sim","keywords":"The CCP-WSI Blind Test Series involves experimental and numerical modelling of focused wave interactions with floating bodies, though only the properties of the focused waves and floating bodies are disclosed at the beginning of the campaign. The experimental campaign was carried out in the COAST laboratory ocean basin and involved subjecting two cylindrical geometries, one with hemispherical bottom and the other with a cylindrical moon-pool in the centre, to a series of focused waves. In this paper, numerical modelling of the blind test will be carried out using existing open-source codes WEC-sim and OpenFAST.   WEC-sim and OpenFAST are mid-fidelity codes which use inputs from frequency domain Boundary Element Method (BEM) solvers to determine dynamics in the time domain dynamics of Wave Energy Converter (WEC) and Floating Offshore Wind Turbine (FOWT) devices, respectively. The use of linear potential flow theory in BEM relies on a number of assumptions which need to be rectified in the model to capture nonlinear effects present in extreme wave events.   WEC-sim [1]  models WEC devices by solving Cummins’ equation about the device centre of mass. This accounts for linear wave excitation, radiation damping, hydrostatic restoring, viscous drag and externally applied forces, such as power take off and mooring forces. Nonlinear contributions are modelled using a weakly nonlinear approach that captures nonlinear restoring and Froude-Krylov forces [2] . The BEM solver only considers the wetted surface of a body at rest in the water which may have an impact on the accuracy of the prediction of different motion and load responses for surface piercing bodies as shown in Quon et al. [2] .   OpenFAST is built upon the wind energy industry accepted and validated code FAST v8, which includes a hydrodynamics module, HydroDyn, to support modelling of FOWTs [3] . Like WEC-sim, HydroDyn relies on hydrodynamic coefficients from potential flow theory solvers, namely commercial BEM solver WAMIT. Nonlinear effects are accounted for from viscous drag, sea currents, platform motions and free-surface memory but nonlinear steep waves and some second-order effects are neglected. It is possible to include second-order potential-flow terms in OpenFAST via a Newman approximation from first-order hydrodynamic coefficients, but compatibility with Nemoh may be an issue.   Fig. 1 shows the preliminary heave displacement results from subjecting the hemispherical-bottomed buoy to a focused wave as predicted by linear WEC-sim.       Fig. 1: Linear WEC-sim prediction of heave displacement of hemispherical bottomed buoy subjected to focused wave (1TB2).       References   [1]         Ruehl, K.M. and Michelen, C., 2015. Improving and validating the WEC-sim wave energy converter modeling code (No. SAND2015-4877C). Sandia National Lab.(SNL-NM), Albuquerque, NM (United States).   [2]         Quon, E., Platt, A., Yu, Y.H. and Lawson, M., 2016, June. Application of the Most Likely Extreme Response Method for Wave Energy Converters. In ASME 2016 35th International Conference on Ocean, Offshore and Arctic Engineering (pp. V006T09A022-V006T09A022). American Society of Mechanical Engineers.   [3]         Jonkman, J.M., 2007. Dynamics modeling and loads analysis of an offshore floating wind turbine (Vol. 68, No. 11). ","authors":"Jack Hughes, Alison Williams and Ian Masters","topic":"5","file":"1450-4794-1-DR-OK.pdf","bib":"WAVHYD-1450.bib"},
{"paperid":"1451","title":"Calculation of PWM Induced Rotor Can Losses in Flooded Generators","keywords":"Generators for tidal turbines are usually placed in a nacelle sealed by a rotary mechanical seal placed over the turbine shaft.  Over time the leakage from the mechanical seals can cause faults in the generator due to corrosion, insulation failure, etc. This makes the bilge pump system inside the nacelle with dehumidifying systems necessary, which adds to the cost and the reliability issues for the turbine system. To overcome these issues, a flooded generator has been proposed in the literature.  The flooded generator is similar to the conventional airgap generator, except that it has a stator and a rotor sleeve to protect the stator and the rotor materials from the seawater. The sleeve materials need to be of good strength, waterproof and corrosion resistant. High thermal conductivity is an advantage to prevent the occurrence of hot spots inside the generator. In a permanent magnet generator, the stator sleeve material needs to be made of an electrically non-conductive material to avoid excessive eddy current losses. On the other hand, rotor sleeve materials can be made of different materials, either electrically conductive or non-conductive. Both types of material have their pros and cons. For conductive rotor sleeve materials, time and space harmonics arising from the stator magneto motive force gives rise to the eddy current losses in the rotor sleeve. This not only affects the efficiency of the machine, but can also risk the demagnetization of the magnets due to higher temperature in the rotor. Therefore, it’s important to estimate these rotor losses prior to the manufacture. Furthermore, conductive rotor sleeve material can also introduce electromechanical damping reducing the generator speed and current oscillations. This has the potential to limit high current swings in the power converter, and thus prolonging the useful lifetime of the converter. To a certain extent, this may also improve the converter efficiency.  The objective of this paper is to investigate these effects of the rotor sleeve material in detail. The eddy current losses in the rotor shall be calculated using the finite element method. The differential equations governing the dynamic characteristics of the generator and the power electronic converter shall be modelled in MATLAB Simulink using the state-space model. Additional differential equations for the rotor sleeve shall also be included in the permanent magnet machine model. In addition to characterizing the rotor eddy current losses due to the stator space and time harmonics, the goal is also to develop a faster algorithm to calculate time and space harmonic losses in the rotor due to various effects such as swell and turbulence in the sea. These algorithms can be used in an optimization study for a generator design.  Results will show that considering turbulence and swell effects in the sea can lead to increased eddy-current losses in the rotor sleeve. This will have an impact on the choice of rotor sleeve materials and the overall design of the power take-off system. ","authors":"Faisal Wani, Udai Shipurkar, Jianning Dong, and Henk Polinder","topic":"7","file":"1451-4498-2-DR-OK.pdf","bib":"GRDPTO-1451.bib"},
{"paperid":"1452","title":"Numerical Simulation of Focused Wave Interaction with WECs using a Hybrid FNPT/NS Solver","keywords":"This presents the numerical investigation of focused wave impact on a floating structure by the QALE-FEM, which solving the fully nonlinear potential theory using a finite element method.  In the numerical investigation, the wave is generated by using 2 nd -order wavemaker theory and the wavemaker motion is specified by using the measured wave elevation in the cases without floating structures. The simulation conditions are specified by the CCP-WSI Blind test workshop, in which two floating structures, i.e. a hemispherical cylinder and cylinder with a hollow part, are moored and subjected to the acting of extreme waves. The wave run-up and the motion response of the structures are analysed.   ","authors":"Shiqiang Yan, Junxian Wang, Qingwei. Ma, Jinghua Wang, and Zhihua Xie ","topic":"5","file":"1452-4918-1-DR-OK.pdf","bib":"WAVHYD-1452.bib"},
{"paperid":"1453","title":"A review of wave energy conversion and its place in the Caribbean region","keywords":"This study reviews the global wave energy industry and the design of various wave energy conversion systems globally. Its purpose was to assess the state of the industry, identify the limitations, challenges and barriers developers have faced and determine the applicability of it to the Caribbean region.   The use of an energy dense and accessible renewable resource like wave energy in the Caribbean region is important since most nations are Small Island Developing States (SDIS) with limited or no natural conventional energy resources. As such, they’re economy, safety and security is often impacted significantly by decisions from the world’s major energy producers. The advancement of wave energy conversion within the region will also contribute to the reduction of green-house gas emissions as dictated within the Paris Agreement.   This study was conducted via a detailed research of varying literature related to the topic and an analysis of the key traits of the Caribbean. It was identified that though the Caribbean possesses some of the lowest levels of ocean wave energy in the world, this circumstance can lead to the region being identified as one of the most practical destinations for wave energy harvesting. Traditionally, most research on wave energy devices focus on powerful ocean waves with large wave heights found in the higher latitude regions globally. The inherent challenges that these possess are low survivability, small maintenance windows, complicated installation procedures and high developmental, operating and maintenance costs. Focus on the growth of wave energy harvesting within the Caribbean produces the opportunity for improvements in all of these aspects.   The significantly lower amounts of energy that can be harvested in the Caribbean is hypothesised to be truly impactful when one considers that the most commonly shared economy in the Caribbean Community (CARICOM) is tourism and agriculture. Historically, these two particular industries are not energy intensive, as such they do not pose any unreasonable demand of electricity on utility companies. In addition to this, the relatively low population of CARICOM nations will result in a relatively low energy demand, thus making the technology potentially viable.   To date, no major effort has ever been made to the development of a wave energy industry within the Caribbean. This may be due to lack of capital funding, low levels of research and development in the jurisdiction, or little attention given by wave energy developers globally because it is not as energy dense as other regions. It was recommended that a project be initiated for the design and development of a wave energy converter specifically focused for the Caribbean region, that will be effective on wave heights ranging between 0.8 metres to 1.8 metres. Currently, no wave energy device found in literature has ever been developed around these parameters. ","authors":"Kevin G. Lemessy, Krishpersad Manohar and Anthony Adeyanju","topic":"10","file":"1453-4670-1-DR-OK.pdf","bib":"ECONOM-1453.bib"},
{"paperid":"1454","title":"Tank Test of an Active Power Rectification in Wave-to-Wire Energy Conversion","keywords":"Maximum power control algorithms in wave energy converter (WEC) are mainly based on the fluid-structure dynamics with impedance matching from power take-off (PTO) damping or model predictive control through the buoy dynamics. However, the conventional buoy characteristics study can not satisfy estimation of maximum output power in a practical wave-to-wire (W2W) system due to significant losses on mechanical and electrical components from PTO to power converter in comparison with the losses on the buoy.     To   analysis the   non-ideal   effects from mechanical transmission and energy conversion characteristics of   WEC   with a power converter output, a wave-to-wire (W2W) simulation and tank testing is performed. The 1:20 scale WEC system with 1.12m buoy diameter includes a single body heaving buoy, mechanical-motion-rectifier based power-take-off, and power converter that store its output energy to a battery load.     From the tank testing results, a circuit model of the system is built and is used to estimate the system performance. The non-ideal effects such as viscous damping between buoy and power take-off, gearbox loss, generator loss, and power converter loss in the system are included in the circuit model with efficiencies from 60 - 80%. The maximum extracted power results under various wave conditions are dominated by these non-ideal effect.     ","authors":"Chien-An Chen, Xiaofan Li, Dillon Martin, and Lei Zuo","topic":"3","file":"1454-5064-1-DR-OK.pdf","bib":"WAVDEV-1454.bib"},
{"paperid":"1455","title":"Tidal current turbine in a non?homogeneous  turbulent inflow: performance and near wake  statistics","keywords":"In light of the 2018 special report on climate change compiled by the United Nations, there is a renewed urgency to the rapid adoption of renewable energy technologies. A key challenge to the large-scale/commercial conversion of tidal energy is the survivability of existing technologies in the inhomogeneous, turbulent and corrosive marine environment. A thorough understanding of the aforementioned aspects of full-scale deployment is vital in developing robust and cost-effective turbine designs. The ongoing experimental work at Lehigh University aims to better the understanding of turbine performance and wake in homogeneous and inhomogeneous turbulent flows, similar to actual marine conditions. All experiments are conducted in a recirculating water tunnel with a test section 0.6m wide, 0.6m tall and 2m long. The facility is equipped with an active grid type turbulence generator, placed at the entrance to the test section. It consists of 10 rotating winglet shafts, (5 horizontal + 5 vertical), with a total of 60 rotating winglets and 24 fixed winglets. Each winglet shaft is controlled by a dedicated, programmable stepper motor. Commonly used forcing protocols, such as synchronous, single random and double random, (programmed via LabVIEW) are used to generate both homogeneous and inhomogeneous turbulent flow conditions. Homogeneous inflows have near-constant depth wise values of mean and turbulent kinetic energy, whereas inhomogeneous inflows have a depthwise varying profile of mean and turbulent kinetic energies.  The turbine model tested has a rotor diameter of 0.28m, and is made of constant chord, no twist, SG6043 cross-section. It is equipped with thrust-torque sensors that decouple and measure loads acting on the rotor and a stepper motor that facilitates precise control of rotor angular velocities. Homogeneous turbulence, while not dramatically affecting time averaged hydrodynamic loads, was found to have a considerable impact on load fluctuations. An Acoustic Doppler Velocimeter is used to map the flow characteristics in the upper half of the rotor plane at downstream locations, X/ D  =0 (without the turbine), 0.5, 1, 2 and 4. Flow parameters such as time-averaged velocities, turbulence intensities, integral length scales, turbulent spectra, Reynolds stresses, and anisotropy ratios are assessed at each of the downstream locations and are used to illustrate the differences in wake evolution in a quasi-laminar (turbulence intensity,  T i=2.25%) and homogenous turbulent inflow conditions ( T i=12.63%). The time-averaged wake velocities recover quicker in turbulent inflows due to increased diffusion of energy from the undisturbed freestream. Generation of wake turbulence, beginning at the blade tip can be seen in both cases. The integral length scales (ILS) are computed to show the transformation of scales in the flow as they pass through the turbine. Interestingly, the downsizing of scales was more dramatic for the quasi-laminar inflow when compared to the turbulent inflow case (see figure 1). Performance and wake characterization of a turbine in inhomogeneous turbulent inflow conditions are currently underway and will be presented at the conference.    ","authors":"Ashwin Vinod and Arindam Banerjee","topic":"4","file":"1455-4565-2-DR-OK.pdf","bib":"TIDDEV-1455.bib"},
{"paperid":"1456","title":"Influence of yaw misalignment on the propagation of Tidal Turbine Wake","keywords":"A yaw misalignment to the in-flow for tidal current turbines are known to result in performance degradation and deflection of the downstream wake. A comprehensive analysis of the wake behavior under yaw is thus essential to provide insights to marine energy developers for optimizing farm layouts. A detailed understanding of wake propagation and wake deflection by a yawed turbine is crucial, as, with this knowledge, the wake can be steered away from the downstream turbine. Wake propagation can be quantified by tracking the center of the wake and is expected to meander both horizontally and vertically. Several methods are used to determine the center of the wake; common ones found in scientific literature include: (a) fitting a Gaussian shape to extract the center, (b) using the  center of mass  of the velocity deficit, and, (c) finding the location of the maximum velocity deficit in the wake. The variability in these definitions acts as a source of uncertainty in evaluating the wake center at downstream locations. In this paper, we aim to discuss the various methods and evaluate the usefulness of each technique based on the fidelity of the data set that is available. To this effect, we will use results from a three-dimensional transient computational fluid dynamics analysis for a tidal turbine subjected to 0° and 15° yaw cases; turbulence is modeled using the  k-w SST  model. A computational domain size of 4.4D × 4.4D × 5D (where D is the diameter of the turbine, 0.2794m) was chosen to minimize the wall effects. It is observed that at 15° yaw, the wake adapts a C shape as it propagates downstream due to the formation of two counter-rotating vortices (see figure 1). Similar observations have been reported in the literature with actuator disks operated at yaw inside a wind tunnel; the wake evolves into a C-shaped structure. This change in shape must be taken into consideration while selecting the location for the downstream turbine. Furthermore, based on our center of the wake estimates, optimum locations for a lateral offset of the downstream turbine will be proposed.    ","authors":"Pranav K. Modali, Ashwin Vinod, and Arindam Banerjee","topic":"6","file":"1456-4630-final-OK.pdf","bib":"TIDHYD-1456.bib"},
{"paperid":"1460","title":"Morphing blades for passive load control of tidal turbines","keywords":"Tidal turbines encounter a range of unsteady flow conditions, some of which may induce severe load fluctuations. A rotor’s blade can experience stall delay, load hysteresis and dynamic stall, which can result in leading edge vortex (LEV) shedding. Yet, the range of flow conditions which cause these effects for a full-scale axial-flow turbine are unclear. In this work we carry out a parameter study across a range of flow conditions by modelling root bending moment responses.   Using our recently developed unsteady load model for arbitrary forcing, which is available to download from our GitHub repository [1], we identify the conditions which elicit the most significant load fluctuations. Then, for these conditions, we investigate how unsteadiness manifests along the span of the blade, the unsteady phenomena occurring and the conditions which induce the most significant load fluctuations.   Figure 1 shows where the unsteady effects are most significant along the blade span for a combination of different flow conditions: (a) turbulence and yaw, (b) waves and yaw, (c) waves, turbulence and yaw and (d) waves and turbulence. Here  r  is the radial (spanwise) coordinate from the root of the blade, and  c  is the chordwise coordinate. Key thresholds of the reduced frequency  of the unsteady fluctuations are also shown. The flow is typically classed as highly unsteady for  k  &gt; 0.2 [2]. From the theory of Loewy [3], returning wakes are found to elicit a slight amplitude increase in the loadings for  k  &lt; 0.3,  and from Theodoren’s theory [4] added mass is shown to increase the load fluctuations for  k  &gt; 0.56.   We find that waves and turbulence are the main sources of unsteadiness, and that extreme waves dominate over extreme turbulence. A yaw misalignment increases the load fluctuations but reduces the maximum peak. Large yaw angles, low tip-speed ratios, and very large waves lead to dynamic stall increasing the mean loads. Conversely, added mass effects mostly attenuate the loadings.       Caption    Figure 1. Parameterisation of unsteady effects along the blade span for, (a) turbulence and yaw, (b) waves and yaw, (c) waves, turbulence and yaw and (d) waves and turbulence.   Bibliography    [1] Scarlett GT, Viola IM. Tidal turbine hydrodynamic model. 2017. URL: https://github.com/gabscarlett.   [2] Leishman JG. Principles of Helicopter Aerodynamics. Cambridge University Press; 2006.   [3] Loewy RG. A two-dimensional approximation to the unsteady aerodynamics of rotary wings. Journal of the Aeronautical Sciences 1957;24(2):81 - 92. [4] Theodorsen T. General theory of aerodynamic instability and the mechanism of flutter. NACA Technical Report 496 1935:413 - 33.","authors":"Weidong Dai, Gabriele Pisetta, Ignazio Maria Viola","topic":"6","file":"1460-4790-2-DR-OK.pdf","bib":"TIDHYD-1460.bib"},
{"paperid":"1461","title":"Morphing blades for passive load control of tidal turbines","keywords":"A passive load-control system is proposed to reduce the load fluctuations on tidal turbine blades. Load fluctuations may result in fatigue failures, and thus they are one of the main factors that affect the reliability of tidal turbines. In this paper, we analyse the fluid-structure interaction of surface-morphing blades. While the results can be equally applied to wind and tidal turbines, a tidal turbine blade is chosen as a test case.   We consider a bi-dimensional model that can represent two possible physical designs: (1) a blade with a flexible trailing edge from root to tip and, (2) a rigid blade that can passively rotate around its pitch axis. We show that both designs are capable of almost perfect cancellation of the load fluctuations without affecting the mean power generated. The optimal structural parameters are identified by a mathematical model based on first principles. The static force coefficients of the blade section are informed by Reynolds-Averaged Navier-Stokes (RANS) simulations. The morphing blade is modelled with a mass-damper-spring system which is weakly coupled to a quasi-steady fluid mechanics model. This theoretical model is used to undertake a parameter study and to identify the optimal structural parameters that minimise the load fluctuations. The optimum blade design is validated with unsteady RANS simulations, which also provide insights on how the turbine wake is modified by the morphing blade.   Figure 1 shows an example of results for a 9-m-diameter, 1MW tidal turbine operating in shear current (such that the flow speed is higher near the free surface and lower near the seabed). The flow speed and the inflow angle experienced by a blade section varies over the period of one revolution. Here, we consider a section at a distance from the hub of 75% of the turbine radius, and we define the inflow angle (phi) as the sum of the angle of attack (alpha) and the blade twist (beta), which is constant. Figure 1(a) shows that the morphing blade enables a lower angle of attack fluctuation, and also to reverse the sign of the fluctuation. It will be shown in the paper how, this sign inversion, is what allows the complete cancellation of the load fluctuation. For instance, figure 1(b) shows the sectional thrust-force coefficient over the period of one revolution. While the rigid blade experiences a force fluctuation in excess of 15% of the mean value, the morphing blade enables a constant load equal to the mean value of the rigid blade. These results confirm that morphing blades can be an effective mean for passive load control of wind and tidal turbines, and the proposed theoretical model may be used to develop an efficient design tool for morphing blades.       Figure caption           Figure   1  .  (a) Variation of the inflow angle  and of the angle of attack  for a rigid and morphing blade over the azimuthal coordinate  of the blade. (b) Variation of the sectional thrust-force coefficient. ","authors":"Weidong Dai, Gabriele Pisetta, Ignazio M. Viola","topic":"4","file":"1461-4842-2-DR-OK.pdf","bib":"TIDDEV-1461.bib"},
{"paperid":"1463","title":"Simulation of focused wave impact on point absorber wave energy converters - CCP-WSI Blind Test Series 2","keywords":"In the present work, the open source toolbox OpenFOAM is applied for analysing the hydrodynamic forces and motion of two generic floating point absorber wave energy converters under the action of the focused wave groups. The Reynolds averaged Navier-Stokes (RANS) equations are solved and the free surface tracking is achieved by using the volume of fluid method. An overset mesh grid is applied to represent the moving boundaries of a solid object, in which a hexahedral background mesh is firstly generated to cover the entire computational domain and an overlapping body-fitted mesh is then generated around the floating buoy using the snappyHexMesh utility. During the simulation, the boundary conditions for the flow variables, which are needed for the minor overalpping mesh and the internal boundary of the background mesh are interpolated from the relevant regions (cells) of the other mesh. The hydrodynamics of the floating buoy moored with a simple linear spring are simulated for a number of crest focused wave groups, and whenever possible,  the soltuions will be examined for grid convergence and validated against the experimental data. ","authors":"Zaibin Lin, Ling Qian, Zhihua Ma, Hao Chen, Derek Causon, and Clive Mingham","topic":"5","file":"1463-4934-1-DR-OK.pdf","bib":"WAVHYD-1463.bib"},
{"paperid":"1464","title":"Hydrodynamic performance of an array of Wave Energy Converters in front of a vertical wall","keywords":"Nowadays, there is an extensive interest regarding the effective and economically efficient exploitation of the indigenous wave energy potential, contributing, therefore, to the reduction of the greenhouse gas emissions and the long-term economic growth. For absorbing a significant amount of wave power, the deployment of multiple Wave Energy Converters (WECs) arranged in arrays is required. The arrays can be installed and operate in offshore areas, where waves of higher energy content can be exploited or at near-shore locations, with the potential to overcome specific drawbacks (e.g. survivability issues) and reduce construction and operation/maintenance costs. In near-shore sites, cost-efficient solutions can be also realized by integrating WEC arrays with existing coastal structures, such as vertical (wall-type) breakwaters. In those cases, hydrodynamic interactions between the WECs and the breakwater are additionally introduced, which have a direct effect on the produced power and, generally, on the overall performance of the array.  Motivated by this, the present paper focuses on the numerical investigation of the performance (hydrodynamic behavior and energy absorption) of an array of WECs in front of a bottom-mounted vertical wall. The wall is considered to have finite length, while the array consists of a sufficient number of floating WECs of cylindrical cross-section. Each WEC is assumed to oscillate freely along its vertical axis, while energy is produced through a linear power take off mechanism, which is actuated from the heave motion of each WEC. The numerical analysis is implemented in the frequency domain and the corresponding diffraction/radiation problem, including hydrodynamic interaction effects among the WECs and between the wall and the WECs, is solved by utilizing the conventional boundary integral equation method. The action of perpendicular to the wall regular and irregular waves is taken into account, while focus is mainly given on the effect of the center-to-center distances between the WECs and the distance between the WECs and the wall on the hydrodynamic forcing (excitation forces, hydrodynamic coefficients), the response and the power absorption of the array. Moreover, results are compared with the case of an “isolated” array (no existence of the wall) in order to illustrate more clearly the effect of the existence of the wall on the performance of the array. Finally, the present study investigates the limitations of the widely used method of images along with the assumption of a “pure” wave reflection by the wall, which inevitably leads to the “infinite wall” concept.","authors":"Eva Loukogeorgaki and Ioannis K. Chatjigeorgiou ","topic":"5","file":"1464-4974-1-DR-OK.pdf","bib":"WAVHYD-1464.bib"},
{"paperid":"1465","title":"Hydrodynamic analysis of a full-scale U-OWC breakwater: comparison between analytical models and CFD simulations","keywords":"An Oscillating Water Column device consists of a chamber with an opening to the sea below the water line. Under the wave action, the surface of water column rises and compresses (or decreases and decompresses) the air volume in the plenum chamber. The air is forced through a duct containing the self-rectifying turbine, which connects the plenum to the atmosphere. The REsonant Wave Energy Converters ([1], [2], [3], [4]), belongs to the family of OWC. The main difference in respect to a conventional OWC is the presence of an additional vertical duct on the wave beaten wall conferring to the structure a typical U–shape.   The first experimental test on a small-scale model of a U-OWC plant was placed in Reggio Calabria [5] in the eastern coast of the Straits of Messina (Southern Italy). The performance of a U-OWC with a Wells turbine has been investigated through a small-scale field experiment by [4].   The first prototype of a full-scale U-OWC is under construction in Civitavecchia harbour (Rome, Italy) in the Tyrrhenian sea and the plant is described in Arena et al., [6].   In this work we carried out a numerical simulation in a 2D wave flume equipped by a wave maker piston type to generate waves. The U-OWC has the same size of the plant described in [6] and it was subjected to different wave conditions.   We used an equivalent model of the air turbine in order to overcome the problem related to 2D simulation of the air turbine. In this way we reproduced the pressure drops induced by the presence of the turbine using a porous media. Obviously, this equivalent model has less computational effort than a 3D simulation maintaining an accurate representation of the air turbine characteristic.   The multi-phase flow, in the CFD simulation, was solved by the unsteady Reynolds-Averaged Navier-Stokes equations using the the commercial code Ansys Fluent 17.0, Academic version. The water-air interaction is taken into account by means of the Volume Of Fluid (VOF) model.   Analysing the interaction between waves and the full-scale model of the U-OWC plant we were able to reproduce the hydrodynamic behaviour of the plant. These analyses highlighted the importance of a preliminary design of the plant, being the capability of energy absorption strongly influenced by shape of the plant.   In order to determine a preliminary design, choosing relationship to the dimension of the chamber and the vertical duct, we made numerical simulation making use of analytical 1-D models, already developed by Boccotti et al. [5].  The 1-D simulations have been carried out considering the records of the fluctuating pressure head on the outer opening of the plant obtained by means of the CFD simulation.   The paper shows comparisons   of    1D simulations with the results of CFD simulation. This procedure can be applied to optimize    the shape of the absorber reducing internal    head losses in order to improve the overall plant efficiency. An instance of the optimization procedure is shown.    ","authors":"Luana Gunari, Pasquale Filianoti, Sergio M. Camporeale, Marco Torresi","topic":"3","file":"1465-5060-1-DR-OK.pdf","bib":"WAVDEV-1465.bib"},
{"paperid":"1468","title":"Demonstration of blade pitch control for horizontal-axis tidal turbines","keywords":"The majority of utility-scale horizontal-axis tidal turbines use speed control or pitch control to maintain power output once the currents exceed a threshold value (the “rated speed”) for the device. Here, we experimentally characterize power performance and structural loading over a wide range of blade pitch settings and tip speed ratios for a three-bladed horizontal-axis turbine. We then implement a control strategy to maintain power output in unsteady currents using blade pitch and compare its performance and loading profiles against those from overspeed and underspeed control for a fixed pitch turbine.     The experiments are conducted with a 0.45-meter diameter turbine that was tested in a 0.6-meter deep, 0.76-meter wide open channel flume, resulting in a blockage ratio of 35%. An acoustic Doppler velocimeter was placed 3-diameters upstream of the rotor plane to measure the free stream velocity. During pitch characterization experiments, inflow velocity was maintained at 0.8 m/s and 4% turbulence intensity. A six-axis load cell at the blade root allowed fluctuations in blade loads to be characterized separately from overall loads on the rotor, which were measured by a similar six-axis cell in the rotor hub. Loads were measured over a blade pitch range from -10° to +30° and tip speed ratios 0.25-8 (Figure 1). This captures the full range of pitch angles required for a constant speed controller and the full range of tip-speeds for a comparable underspeed control strategy. For tip speeds higher than optimal for maximum power production, increasing the blade pitch (towards feather) decreases the efficiency and thrust, in line with previously reported experimental results. This performance trend is reversed at lower tip speed ratios because the point of flow separation along the blade moves closer to the trailing edge.     To demonstrate the effectiveness of pitch control in maintaining power output in time-varying inflow, a proportional-integral feedback controller actuating blade pitch was implemented and the resulting fluctuations in power and structural loading were recorded. A similar controller actuating rotor speed was also implemented, and the comparison with the pitch controller demonstrates that pitch control substantially reduces torque or thrust relative to underspeed or overspeed control, respectively. Experiments also provide insight into the challenges of pitch controllers, such as maximum pitch rate and the corresponding limit to the rate of change in inflow speed to which the controller can respond.    ","authors":"Katherine Van Ness, Craig Hill, Alberto Aliseda, Brian Polagye","topic":"4","file":"1468-5019-1-DR-OK.pdf","bib":"TIDDEV-1468.bib"},
{"paperid":"1469","title":"High-resolution Hindcasts for U.S. Wave Energy Resource Characterization","keywords":"The marine and hydrokinetic (MHK) industry is at an early stage of development and has the potential to play a significant role in diversifying the U.S. energy portfolio and reducing the U.S. carbon footprint. Wave energy is the largest among all the U.S. MHK energy resources, which include wave energy, ocean current, tidal-instream, ocean thermal energy conversion, and river-instream. Wave resource characterization is an essential step for regional wave energy assessments, Wave Energy Converter (WEC) project development, site selection and WEC design. However, energy planners and the WEC industry currently lack sufficient information and knowledge of resource characteristics due to the absence of accurate high-resolution spatial and temporal wave spectral data; particularly in shallow nearshore regions. These data are needed to accurately compute wave energy resource and wave conditions parameters, e.g., extreme sea state statistics and environmental contours, recommended by international standards, including the International Electrotechnical Commission (IEC). These important wave energy resource parameters are the building blocks for upgrading the U.S. Department of Energy’s (USDOE) web-based GIS tool, the MHK ATLAS, designed to archive and disseminate information on resource characteristics; and for developing the USDOE’s resource classification systems for streamlining resource assessment and WEC design. The present paper provides an overview of a joint modelling effort by the Pacific Northwest National Laboratory and Sandia National Laboratories on high-resolution wave hindcasts to support the USDOE’s Water Power Technologies Office’s program of wave resource characterization, assessment and classifications in all US coastal regions. Topics covered include the modelling approach, model input requirements, model validation strategies, high performance computing resource requirements, model outputs and data management strategies. Examples of model setup and validation for different regions are provided along with application to development of classification systems, and analysis of regional wave climates. Lessons learned and technical challenges of the long-term, high-resolution regional wave hindcast will be discussed.   The present study demonstrates that the nested-grid modeling approach by coupling WaveWatchIII and UnSWAN models provides a powerful and efficient method to accurately calculate IEC parameters that characterize wave energy resources with sufficient spatial and temporal coverage, and at fine resolutions to support IEC  design class  assessments within a  feasibility class  study domain. Comparing results to a previous NOAA WWIII® hindcast that was used by the USDOE for an IEC  reconnaissance class  national resource assessment, the present study’s USWAN hindcast provides a significant improvement in model skill predicting IEC wave energy resource parameters and extreme sea state statistics. In addition, the USWAN model domain covers shallow near shore regions not modelled in the previous WWIII® hindcast. Model skill at resolving large waves and extreme sea statistics is improved compared to previous U.S. wave hindcasts, but underbias in model predictions compared to buoy observations remains a challenge until wind forcing inputs are improved. The IEC 50-m spatial resolution requirement for  design class  assessments are excessive for most wave sites as grid-independency is achieved at around 300-m. ","authors":"Zhaoqing Yang and Vincent S. Neary","topic":"1","file":"1469-5045-1-DR-OK.pdf","bib":"WAVRES-1469.bib"},
{"paperid":"1470","title":"Experimental investigation into the effects of waves on blade loading for a model scale horizontal axis tidal turbine","keywords":"As tidal current turbine technology matures it is important to assess the long-term survivability of such devices in the harsh ocean environment in which they operate. Waves can have a significant impact on the operation of a tidal turbine by imposing cyclic loads, thus increasing blade fatigue and affecting the yielded power quality. This study presents an experimental assessment of the in-plane (chordwise) and out-of-plane (flapwise) blade root bending moments on a model-scale tidal current turbine under wave conditions.   The two-bladed turbine rotor had a diameter of 800 mm (1/25 th  scale) and a NACA 63-618 profile. One of the blades was instrumented with two strain gauges (CEA-06-250UW-350) to measure the blade root bending moments in the flapwise and chordwise directions. The rotor was tested at towing speeds of 1.25 m/s and 2.25 m/s in a 100 m long, 3.5 m wide towing tank with a water depth of 1.5 m at the Australian Maritime College. The blade loads, rotor rotational speed, towing speed, wave height, wave phase and rotor blade position were measured for tip speed ratios (TSR) in the range 4 &lt; TSR &lt; 9 at a sampling rate of 3 kHz. The TSR was controlled by setting the rotational speed with an AC motor.   The rotor was tested under current-only, wave-only, and current and wave conditions in both the stationary and rotating state. The wave scenarios tested included both regular and irregular waves which were scaled using the relative depth method based on the met-ocean conditions of the Banks Strait, Australia, an area with high tidal kinetic energy and a potential installation site for tidal current turbines. The structural performance of the rotor was evaluated using the non-dimensional tip speed ratio, flapwise bending moment coefficient and chordwise bending moment coefficient in both the time-averaged and wave-phase averaged domains. The current-only results were validated against an existing Blade Element Momentum Theory model of the same turbine.   It was found that the waves did not have a significant impact on the time-averaged bending moment coefficient values. However, significant fluctuations in instantaneous parameters were found over each wave period. ","authors":"Pragya Gupta, Malwattage Peiris, Jessica Walker, Sascha Kosleck and Irene Penesis ","topic":"6","file":"1470-4793-2-DR-OK.pdf","bib":"TIDHYD-1470.bib"},
{"paperid":"1480","title":"Application of a hybrid Eulerian Lagrangian PIC model to focused wave interaction with WEC type floating buoys","keywords":"This paper presents a numerical study of focused wave interaction with two different floating, surface-piercing structures (moored with a simple linear spring mooring) meant to represent simplified wave energy convertors (WECs). The numerical model employed is a 3D parallel particle-in-cell (PIC) method based incompressible Navier-Stokes solver. The PIC solver uses both an Eulerian grid and a set of Lagrangian particles to solve the governing equations for free-surface flows, and incorporates a Cartesian cut cell method based two-way strong coupling scheme for fluid-structure interaction. The numerical model is capable of handling large free-surface deformations with considerable accuracy and efficiency due to its hybrid particle-mesh nature. In addition, because of the employed cut cell based strong fluid-solid coupling algorithm the model can deal with large structure motions under wave action with both stability and efficiency.       The test cases presented in this paper are those from the CCP-WSI Blind Test Series 2 website (https://www.ccp-wsi.ac.uk/blind_test_series_2), where experimental data are available for comparison. In the physical experiment, the two structures are: 1) a hemispherical-bottomed cylinder, and; 2) a cylinder with a moon-pool, thus increasing the complexity in the latter case by introducing an ‘internal’ body of water. Each structure is individually subjected to the same set of incident wave cases consisting of 3 focused wave events with a range of steepness, kA (0.129 – 0.193). The steepness of the waves is varied parametrically by altering the peak frequency (whilst maintaining the same crest height).      A numerical wave tank is established in the PIC model. The focused waves are generated using a piston-type wave paddle based on the linear wave theory, and the generated waves are absorbed at the downstream end using a relaxation method. The numerical results are validated against existing physical experimental data. The effect of wave steepness and float geometry on the motion of the buoy and the load in the mooring line, as well as the accuracy of the numerical model as a function of these parameters are discussed.","authors":"Qiang Chen, Haoyu Ding, and Jun Zang","topic":"5","file":"1480-4724-1-DR-OK.pdf","bib":"WAVHYD-1480.bib"},
{"paperid":"1482","title":"Turbulent flow mapping around a floating in-stream tidal energy platform","keywords":"Ambient turbulence impacts hydrokinetic turbine performance and durability. Wake induced turbulence impacts the flow around the turbines and is critical in the design of turbine arrays. As hydrokinetic turbines reach a full-commercial scale, it becomes necessary to field map turbulent inflow conditions, and the real impacts that energy extraction causes to the natural environment. However, turbines are typically installed in sites with strong currents, where field measurements are challenging and expensive, thus most field surveys are sparse and of limited duration. Hence, efficient field methods that can accurately map the spatial structure of these turbulent flows are critical in this growing industry.  In this investigation, a novel technique based on mobile platforms is applied to spatially map turbulent flows in Grand Passage, one of Bay of Fundy’s tidal channels, located in Nova Scotia, Canada. Specifically, the measurements aim at characterizing the flow around the PLAT-I floating tidal energy platform developed by Sustainable Marine Energy (SME). PLAT-I supports four 6.3 m diameter Schottel Hydro turbines. GPS-tracked surface drifters equipped with fast sampling Acoustic Doppler current profilers (ADCPs) provide turbulence-resolving vertical profiles of velocity along the drifter trajectory. These data are used to obtain estimates of the mean flow and turbulence parameters as a function of position both within and outside the wake. Controlled transect measurements using vessel-mounted ADCPs capture inflow conditions and across wake data. These new measurements provide insights about the spatial structure of the turbines’ combined wakes for unsteady flow conditions, and contribute to the development of numerical models used in the assessment of marine energy extraction environmental impacts. ","authors":"Maricarmen Guerra, Alex E. Hay, Richard A. Cheel, Greg Trowse, and Richard Karsten","topic":"2","file":"1482-4704-5-DR-OK.pdf","bib":"TIDRES-1482.bib"},
{"paperid":"1483","title":"Validation of simulated wave energy converter responses to focused waves for CCP-WSI Blind Test Series 2 ","keywords":"Increasingly, focused waves are used as a design method to predict extreme loads for offshore structures, such as wave energy converters (WECs). However, the ability of computational methods to accurately simulate the prescribed focused waves and resulting wave structure interactions are not well-validated. As a participant in the Collaborative Computational Project in Wave Structure Interaction Blind Test Series 2, this study uses two computational fluid dynamics methods, WEC-Sim and STAR-CCM+, to evaluate three focused waves on two WEC-like bodies. WEC-Sim is a computationally efficient, midfidelity model based on linearized potential flow theory. STAR-CCM+ is a high-fidelity, three-dimensional, unsteady, Reynolds-averaged Navier-Stokes-based model. The two geometries considered are a hemispherical buoy and a cylindrical moon pool. The experimentally measured focused waves are reproduced in both codes, and the simulated displacements and mooring loads are obtained for each of the hydrodynamic bodies. The resulting STAR-CCM+ generated focused waves have approximately the same accuracy, in comparison to the analytic solution, as the experimentally generated focused waves. And, the WEC-Sim and STAR-CCM+ simulated displacements and mooring loads are, on average, within 5% of each other. ","authors":"Jennifer van Rij, Yi-Hsiang Yu, and Nathan Tom","topic":"5","file":"1483-5051-1-DR-OK.pdf","bib":"WAVHYD-1483.bib"},
{"paperid":"1485","title":"Assessment of tidal current resources in Banks Strait, Australia","keywords":"Tidal stream turbines are now approaching suitable technology readiness levels for deployment in large-scale arrays. However, the characteristics of prospective tidal energy sites in Australia are not well understood, as only low-resolution numerical models and very limited field campaigns have previously been performed, limiting the development of tidal turbines sites in Australian waters.  However, current research conducted as part of the ARENA (Australian Renewable Energy Agency) AUSTEn (Australian Tidal Energy) “Tidal Energy in Australia – Assessing Resource and Feasibility to Australia’s Future Energy Mix” project has identified the Banks Strait as a promising site, an approximately 15km wide channel located between the Furneaux Island Group and the north-eastern corner of mainland Tasmania, Australia with suitable depth ranges for tidal turbine array installations from 20m to 60m. To determine the suitability of this site, a series of four nested two and three-dimensional structured mesh models were developed using the Sparse Hydrodynamic Ocean Code (SHOC) hydrodynamic model. The model bathymetry was generated by combining pre-existing Australian Hydrographic Office charts with sub-5m resolution multibeam field survey data obtained as part of the ARENA AUSTEn project.  Tidal boundary forcing for the largest nested model was generated using the Ohio State University TPXO global tidal model, with atmospheric forcing for all models produced using the ERA5 climate reanalysis dataset. The simulated SHOC model tidal elevations, current profiles and harmonic constituents were calibrated and validated against collated opportune data as well as extensive Acoustic Doppler Current Profiler (ADCP) field data collected as part of the ARENA AUSTEn project. Simulation results indicate that considerable tidal resources exist in the Banks Strait region, with maximum tidal currents in excess of 3m/s found in both westward and eastward directions covering large areas of the strait at suitable depths for large-scale tidal turbine array installations. The models developed as part of this work will be extended by incorporating arrays of tidal turbines into the numerical models, to enable the full examination of the feasibility of the Banks Strait region for future turbine array deployments. ","authors":"Philip Marsh, Irene Penesis, Jean-Roch Nader, Camille Couzi , Remo Cossu ","topic":"2","file":"1485-4634-2-DR-OK.pdf","bib":"TIDRES-1485.bib"},
{"paperid":"1486","title":"Offsetting of wave and wind resource and resultant economic benefits: a GB case study","keywords":"This paper presents an analysis of historical time series of UK spot prices, wind generation and wave resource, showing up to 76% greater revenues for wave generation at times of low wind resource. These results are presented as part of a wider discussion of the potential added technical, economic and social value that wave energy generation could bring to electricity systems with high penetrations of renewable energy.   This work incorporates both qualitative and quantitative analysis to explore the concept that wave energy can provide value to power systems and markets in a different way than other, more developed, stochastic renewable generation technologies. Previous work has shown that wave resource is more predictable than wind resource [1], and is often temporally offset [2]. The UK has a large proportion of Europe’s wave resource, and is also at a latitude in which the seasonal variability results in a higher wave resource in the winter months, coinciding with times of greater energy demand. The UK has also seen a large amount of installed wind capacity of the past five years, which has been found to result in higher instances of price spikes at times of low wind resource and network stress [3].   An analysis of historical wind, wave and market index data has been undertaken to illustrate the potential for wave energy generation to capture these price spikes due to the offset in wind and wave resource. Figure 1 shows a comparison between wind generation in GB and the N2EX GB spot market data for half hourly time steps in March 2015. It can be seen that the highest price spikes occur at times of high demand and low wind resource. Figure 2 shows the comparative revenues for an example in which 1MW of installed wind capacity and 1MW of installed wave capacity are able to access the spot market prices illustrated in Figure 1. Results show 21.6% greater revenues overall for this month of data, with up to 76.5% greater revenues found for other months of time series data analysed.       [1] W. Sasaki, “Predictability of global offshore wind and wave power”  International Journal of Marine Energy  17 (2017) pp98-109   [2] C. Kalogeri et al, “Assessing the European offshore wind and wave energy resource for combined exploitation”  Renewable Energy  101 (2017) pp224-264   [3] European Commission Directorate-General for Energy, “Quarterly Report on European Electricity Markets”, September 2017 ","authors":"Shona Pennock, Nieraj R. K. Bharathi, David Crooks, Henry Jeffrey, Patrik Möller ","topic":"10","file":"1486-4637-2-DR-OK.pdf","bib":"ECONOM-1486.bib"},
{"paperid":"1487","title":"Linear analysis of fluid-filled membrane structures using generalised modes","keywords":"Wave energy is an extremely large resource but to date its harvesting has suffered from, among other things, a high predicted cost of energy. Wave energy converters (WECs) which utilise flexible membranes have the potential to provide similar or better performance to a rigid body WEC but at a much lower weight. The result could be a significant cost reduction of the WEC structure, installation and maintenance without reducing the WEC energy production. However, there is no single method for analysis of flexible membrane WECs.  This study describes the implementation of a general purpose tool-set for the analysis of a wide range of flexible membrane WEC types. The tool-set aims to reduce the complexity of generic flexible membrane WEC analysis and allow for a more thorough exploration of the potential of flexible membrane WECs that could provide a step-change reduction in costs compared to rigid body WECs.  The tool analyses the static shape of a flexible membrane WEC using an FEA code. The membrane dynamic motion is described by generalised mode shapes, which couple the external domain, the internal domain, the membrane dynamics and the effect of the power take-off (PTO) system. The effect of the external domain is analysed using an open source linear potential flow boundary element method and a generalised mode hydrostatic stiffness method. When water is the internal working fluid the internal domain is analysed using a linear potential flow boundary element method solver adapted for internal domains, combined with an adapted internal domain generalised mode hydrostatic stiffness method.  When air is the internal working fluid a lumped-parameter approach based on the linearised compressibility of air is used.  The membrane dynamics are analysed using a generalised mode mass, stiffness and damping method.  The PTO is analysed by application of linear damping based on the volume change in a cell (for a turbine PTO) and the surface area change of a membrane (for an electroactive polymer PTO).  The system is solved in the frequency domain and the tool is validated against experimental results for two different types of flexible membrane WECs.  One WEC has an inelastic membrane surface, air as the internal fluid, and a turbine PTO.  The other WEC has a hyperelastic membrane, water as the internal fluid and an electroactive polymer PTO.  Successful modelling has demonstrated that the tool, unlike existing flexible membrane analysis methods, is capable of analysing a wide range of flexible membrane WECs. ","authors":"Anthony McDonald, Qing Xiao, David Forehand, and Ronan Costello","topic":"3","file":"1487-4727-2-DR-OK.pdf","bib":"WAVDEV-1487.bib"},
{"paperid":"1488","title":"Salmonid response to a vertical axis hydrokinetic turbine in a stream aquarium","keywords":"During a decade, tidal energy conversion has developed from a handful tests with single turbines to pre-commercial installations of arrays. As with all renewables, environmental concern has arisen for tidal energy – particularly collision risks for marine mammals, fish and seabirds. In parallel to the marine ventures similar technologies are developed and tested in riverine systems and concerns are similar. Up until today a few studies have focused on interactions between turbines and marine organisms, e.g. seals, fish and birds. Methodologies include passive and active acoustics and video recordings, as direct observations in the field are impracticable; laboratory experiments and modelling studies are also included. Given the few studies performed the worst apprehensions can be disregarded, evasive behaviours are strong and collisions have only been observed during experiments. However, given the large number of variables that may affect risks, e.g. site, species, season, light regime and not the least different technologies including turbine rotation speed and the effect of larger arrays, more studies are needed.   At Uppsala University a directly driven generator technique has been developed, with low rpm, including tidal/riverine application with vertical turbines. A riverine turbine (6 m diameter, 3 m high) was launched in 2014 in a river and fish studies were performed in 2017-18. Here we report on complementary and first part of a related laboratory experiment initiated in 2018. It was performed in a stream aquaria, a circular tank system (7 m long) using Salmonid smolt (juveniles of 2 species) and with the possibility to vary e.g. velocity, turbine speed and turbine models and thereby wing tip speed. The vertical axis model turbine was ca 50x 50 cm, with free passages on each side (50 cm), above and under.   Eighty 15min trials, with single fish, were performed from June to August. First results show that factors of importance include species specific behaviour and velocity, but also experimental artefacts affecting behaviour due to the experimental conditions. No collisions and clear avoidance behaviour were observed during the daylight conditions of the first tests. Extension possibilities of the experimental setup will also be discussed. ","authors":"Madeleine Berry, Jan Sundberg, and Francisco Francisco","topic":"9","file":"1488-4448-2-DR-OK.pdf","bib":"ENVIRO-1488.bib"},
{"paperid":"1491","title":"Wave energy projections in Western Indian Ocean; a regional assessment for southeast Africa","keywords":"Wave energy is a promising alternative to exhaustible fossil fuels to mitigate the negative impacts of climate change in the areas with absorption potential. However, the available resources are subject to alter due to climate change. The Indian Ocean as a high potential area for wave energy harvesting has been considered for downscaling of wave climate in regional and local scales to provide high resolution dataset. Previous studies on climate change impact in this region have shown that southeast Africa can be a potential area due to its exposition to higher energy and lower variability in terms of both short-term fluctuations and long-term change. The spectral wave model, SWAN, was utilized to develop a downscaled numerical wave model nested in the Indian Ocean scale parent which provides the boundary condition for the whole period of simulation. In order to assess the impact of climate change on available wave energy, wind data of super-high-resolution atmospheric climate model MRI-AGCM3.2S with temporal and spatial resolutions of 1 hr and 20 km, respectively was used to force the wave model to generate the time series of wave characteristics for two 25 yearly periods of projection (historical: 1979-2003 and future (RCP8.5): 2075-2099). The regional model covering the southeast Africa was performed with (1/6)° computational resolution and outputs were extracted on the same grids while being nested in (1/2) ° resolution parent model. The wave power was calculated based on the time series of Significant wave height and mean wave period for two 25 yearly periods. The spatial distribution of the mean annual wave power shown in Fig. 1 implies the higher values in Reunion and Mauritius as well as southern Madagascar due to the dominant waves propagating from south and southeast. Despite being exposed to higher amount of wave energy, southern Madagascar and south of Reunion and Mauritius experience less variability in monthly mean wave power according to monthly variability index (MVI). In addition, stable long-term wave climate, especially in southern parts of Reunion and Mauritius can be seen from comparison of historical and future projections. This study shows that despite the less investigations done in the southern Indian Ocean due to scarcity of high resolution and reliable wave data, this area has a very good potential for wave energy extraction and providing parts of energy demands in coastal areas due to its stable condition in both short and long-term which is in line with the goals of sustainable development.     Fig. 1. Spatial distribution of wave power in the study area based on historical and future projections and relative change of it in the future          ","authors":"Bahareh Kamranzad, Nobuhito Mori ","topic":"1","file":"1491-4651-2-DR-OK.pdf","bib":"WAVRES-1491.bib"},
{"paperid":"1492","title":"Wave power measurement at breaking  wave zone in Maldives using horizontal-axis turbine WEC ","keywords":"As we believe that energy harvesting from breaking waves is also very important. In order to investigate water velocity at the seashore breaking wave zone, we performed the experimental test of a wave energy converter (WEC) using horizontal turbine in June 2015, Okinawa Japan. The observed peak power was only 101W with a 60cm diameter turbine at 200 rpm and the maximum water speed was 2.1 m/sec, estimated from the tip speed ratio. ?In 2016, we placed ADCP water speed measurering devices around reef edge, and we observed water speed of 3.8m/s near breaking wave zone (reported at EWTEC2017, Cork).            In Summer 2017, for confirming ADCP water speed data, using electro-magnet (EM) water speed sensors mounted on poles near the reef edge. Two EM sensors (two dimension type) were set in different depths for one month. Nevertheless, the pole was inclined by typhoon in October 2017, we changed to have an experiment of the half-scale turbine generators (WEC1and WEC2) in the Maldives Island seashore at a breaking wave zone in May 2018. The AC peak voltages of those WECs output are measured by the data logger’s wave-form module in every 1ms by event driven procedure.  DC voltage and current are continuously saved in every 1s for 24 hours every day.  The observed peak voltages were 100~510V with a 35cm diameter turbine at 200~1350 rpm and the maximum water speeds were 1.4~9 m/sec, estimated by using turbine characteristics, measured in advance. The wave power measurement on Kandooma Island in the Maldives for a long period, and is still ongoing.  This paper describes experiments with our self-built WEC monitoring system and obtained wave energy histogram data. ","authors":"Hideki Takebe, K. Shirasawa, J. Fujita, S. Misumi, P. Halder and T. Shintake ","topic":"3","file":"1492-4924-1-DR-OK.pdf","bib":"WAVDEV-1492.bib"},
{"paperid":"1495","title":"Influence of turbulence and wave flow conditions on different scaled tidal turbines","keywords":"In the framework of the Atlantic Area Interreg programme called MONITOR   [1]   , a collaborative ‘multi-model’ investigation of Tidal Energy Converter (TEC) blade reliability is proposed, which brings together multiple testing methodologies (numerical, laboratory and at-sea). The global objectives of the MONITOR project is to investigate TEC reliability for converters subjected to real in-situ flow conditions, which are with possible high ambient turbulence and possibly with severe wave conditions. Therefore, laboratory testing and in-situ observations for our two industrial partners will be performed and analysed.   Comparisons with the two numerical software   [2]    are also scheduled. Finally, these three approaches will be used to feed in a Variation Mode and Effect Analysis (VMEA) conducted by ORE Catapult and a cost analysis conducted by University College Cork.           ","authors":"Gregory Pinon, Charifa El Hadi, Myriam Slama, Jose Nuno, Pablo Mansilla, Erwann Nicolas, Julie Marcille, Jean-Valery Facq, Ines Belarbi, Beno?t Gaurier, Gregory Germain, Andre Pacheco, and Michael Togneri","topic":"4","file":"1495-4904-1-DR-OR.pdf","bib":"TIDDEV-1495.bib"},
{"paperid":"1496","title":"Comparison of biofouling communities among European regions","keywords":"Marine biofouling is a well-known problem across maritime sectors (e.g., shipping, oil and gas, ocean energy) worldwide. Among other negative impacts, biofouling may obstruct cooling pipeline systems, decrease marine sensor efficiency and increase biocorrosion, weight and drag. Marine biofouling should be highly regarded especially concerning the ocean energy devices which must be operational offshore for 10-20 years, where in situ maintenance is extraordinarily costly and risky due to the ocean conditions, and which are not designed to have short dry-dock intervals.   Furthermore, offshore structures act as artificial reefs creating new surfaces on which the organisms attach, settle and grow, which may contribute to the propagation of non-native species in the marine environment, serving as ‘stepping stones’ for the organisms, often impacting biodiversity, habitats or ecological processes, and posing great ecological and economic threats. Our work characterizes assemblages from different biogeographical regions (Portugal, Basque Country, Scotland) settled on different metallic substrates by different biological parameters (e.g., weight, abundance, size) of the organisms most problematic to the marine renewable energy sector: mussels (and other relevant bivalves), barnacles, calcareous tubeworms and bryozoans. This will increase the knowledge on Atlantic biofouling assemblages, where less information is available when compared to the North Sea. Information on biofouling assemblages as well as non-native species occurring in those regions is going to be presented and compared to understand their features and contribute to more effective and eco-friendly anti-fouling strategies for marine renewable energy projects.   ","authors":"Pedro A. Vinagre, Enara Mardaras, Emiliano Pinori, Johan Svenson, Erica Cruz, Teresa Simas","topic":"9","file":"1496-4635-3-DR-OK.pdf","bib":"ENVIRO-1496.bib"},
{"paperid":"1499","title":"Estimating the stability of a bed protection of a weir-mounted tidal turbine","keywords":"Coastal structures, such as bridges and open flood defenses, can constrain the flow in tidal straight, offering a prospect for harvesting tidal energy. The use of existing infrastructure to mount a turbine may lower the costs compared to offshore deployments. While often stone layers are applied downstream of hydraulic structures to protect the sea bed from scouring, limited is known about the potential effect of tidal energy extraction on the stability of this granular bed protection.   Since the end of 2015, five horizontal axis turbines have been operating in the storm surge barrier of the Eastern Scheldt, a former estuary in the south of the Netherlands. The flow velocity in the barrier is high –up to5 m/s– and the flow is highly turbulent, hence a granular bed protection is applied up- and downstream of the structure. While the design of the bed protection of the barrier is conservative, the turbine influence is - strictly speaking - not considered in the design calculations. The stones of the bed protection may move, as turbines may enhance the flow non-uniformity and increase the turbulence level of the flow.   Hofland[1] postulated a method to estimate the stability of a granular bed protection under non-uniform flows. Hofland[1] proposed a local stability parameter, which is a Shield parameter adapted for turbulence of variable intensities, to represent the flow attack on the bed. His stability parameter can be used to predict the start of stone movement in a granular bed, using profiles of mean velocity and turbulence kinetic energy in the water column above the bed.   This paper predicts the stability of a bed protection in the changed non-uniform flow downstream of a hydraulic structure with a tidal turbine, using detailed hydrodynamic measurements (Fig.1) of a physical model test and the method of Hofland [1]. The physical model (Fig.2) closely resembles the flow past the storm surge barrier with turbines as no measurements close to the bed could be conducted at the field site. Eventually, a general approach may be set up to design bed protections downstream of turbines in barriers. In this way, commercial exploitation of coastal structures using tidal turbines may be brought a step closer.    Fig. 1  The mean flow velocity along the centre cross-section of the flume for a situation with a broad-crested weir (a) and the situation with a weir and turbine (b). These velocity profiles are an input to the model that estimates bed stability.        Fig. 2 The physical model of the barrier weir with a two-bladed Tocardo Power Turbine (scale 1:9, rotor diameter = 0.4 m) in a recirculating current flume.    Acknowledgements   The authors acknowledge Tocardo Power Turbines B.V. for the assistance in the test. This work was supported by the Netherlands Organization for Scientific Research (NWO) within The New Delta programme (project number 869.15.008) and the European Regional Development Fund (EFRO) OP-Zuid 2014-2020.   References   [1] B. Hofland,  Rock and Roll, Turbulence-induced damage to granular bed protections, PhD Thesis , Delft University of Technology, 2005. ","authors":"Merel C. Verbeek, Robert Jan Labeur, Wim S. J. Uijttewaal","topic":"9","file":"1499-4907-1-DR-OK.pdf","bib":"ENVIRO-1499.bib"},
{"paperid":"1501","title":"A laboratory study on the effects of waves on the performance and structural deflection of a tidal stream turbine","keywords":"A number of studies predict the significant effect of waves on the ability of a tidal turbine to extract power from a resource. It is also well-stated that waves will have significant fatigue implications for the support structure of the tidal turbine. This study aims to quantify these effects through scale model testing, and to understand the effect of combinations of tidal flow velocity and wave amplitude, period and direction on tidal turbine device performance and support structure deflection.   This work is ongoing and it is intended that the ultimate outcome will be a computational model of support structure fatigue over the lifetime of a tidal turbine, at a given location.         A scale model tidal stream turbine was tested in the LABIMA Wave-Current Flume at the University of Florence, Italy. The turbine blade geometry was based on a commercial design and blades were manufactured by 3D printing in polyacrylate. The turbine was instrumented to record generator power output and structural deflection on the support structure shaft.   A scale of 1:81 was used. The real case simulated was a 17.5m blade diameter turbine in 25m water depth. Regular wave conditions (2.4m &lt; H &lt; 5.7m and 6.5s &lt; T &lt; 9.7s), and tidal flow velocities of 1 to 2.1m/s were simulated. Tests with tidal flow and wave propagation both in the same and opposite directions were executed. Turbulence-generating structures were used in the channel to ensure a realistic turbulent flow profile. A schematic diagram of the experimental arrangement is shown below.   &lt;srjw_channel_schematic&gt;      As expected, in general, power generation increased with flow speed. The effect of waves was found to be significant on both performance and structural deflection. The greatest structural deflection was found during high flow speed cases with large amplitude, short period waves. This wave case also corresponded to the lowest power generation within each flow case. Turbine performance variation over each test was clearly influenced by wave height, and power output variation was greatest during tests with the largest and shortest period waves. In cases with large waves, the turbine was observed to stop as the wave minima passed, then to restart as the maxima passed. This performance variation was also in phase with large structural deflection. An image of the turbine just after the passing of a wave minima is shown below.  &lt;srjw_turbine_image&gt;      The results of the first part of this project highlight the significant structural forces placed on a turbine due to the presence of waves in a tidal environment, even in the relatively calm conditions. The second part of this study will focus on specific Mediterranean and North Sea environments. Tests with Irregular wave will be conducted before using both data sets to develop computational models of the forces placed on a tidal turbine over a lifetime in either location. ","authors":"Stuart Walker, Lorenzo Cappietti, Irene Simonetti","topic":"4","file":"1501-4596-2-DR-OK.pdf","bib":"TIDDEV-1501.bib"},
{"paperid":"1504","title":"Significant motions of a multi-purpose floating offshore structure due to environmental conditions","keywords":"This paper presents a coupled hydro-aero-elastic analysis method for the loads of a multi-purpose floating structure, which is suitable for offshore wind and wave energy sources exploitation. The analysis method incorporates properly, the solutions of the diffraction, the pressure- and motion- dependent radiation problems around the floating structure along with the aerodynamics of the Wind Turbine (WT). The floating structure, which is exposed to the action of regular and irregular waves in finite depth waters, encompasses an array of three hydrodynamically interacting Oscillating Water Column (OWC) devices consisting of concentric vertical cylinders, moored through tensioned tethers as a TLP platform supporting a 10 MW WT. The wave loads on the floater are approximated using matched axisymmetric eigenfunction expansions. The objective of the analysis is to investigate which sea states yield the significant motions due to operating wave conditions in offshore structures based on wave records, in the Mediterranean Sea near to Sicily Island.   Offshore wind energy is currently attracting most of the research attention within the sector. In the present paper, a multi-cylinder TLP design concept for the support structure of the DTU 10MW WT is analyzed.   As far as the case of multi wave energy converters (WEC) is concerned, OWC devices that consisted of circular or concentric cylindrical chambers have been mainly examined. Theoretical studies in the context of freely floating WEC’s have been developed in regular and irregular wave fields. In the present contribution, each examined OWC device consisted of an exterior partially immersed toroidal oscillating chamber of finite volume supplemented by a concentric interior piston- like truncated cylinder in which the tension tether is attached.   The main difference between an isolated OWC device and an array of such devices is the hydrodynamic interaction phenomena between the array’s members. Each device of the configuration scatters waves towards the others, which in turn scatter waves contributing to the excitation of the initial device and so on. Thus, the total wave field around each body of the multi-body configuration is obtained by superposing the incident wave potential and various orders of successively reflected waves emanating from all the devices of the arrangement using the physical idea of multiple scattering.   Another challenge that has presented the last years is the design of devices that absorbs not only wind but also wave energy. Lately, many attempts have been conducted related to the hydrodynamic analysis and the optimization of devices, studying different arrays and characteristics of the configuration. In Mazarakos et. al. 2014, 2015, 2016 studied the coupled hydro-aero-elastic analysis of a device like the above, under the action of regular surface waves. The numerical results were dealt with the motions and the mean second order loads of the floating structure.   Furthermore, Mazarakos et. al. 2016, made a parametric hydrodynamic analysis that compared the analytical results of a triangular, quadrate and pentagonal floater with three, four and five identical OWC devices respectively. ","authors":"Thomas P. Mazarakos, Dimitrios N. Konispoliatis, Takvor H. Soukisian, and Spyridon A. Mavrakos","topic":"5","file":"1504-4711-3-DR-OK.pdf","bib":"WAVHYD-1504.bib"},
{"paperid":"1507","title":"Evaluation of Composite Materials for Wave and Current Energy Technologies","keywords":"Composites are promising materials that could provide lightweight marine durable structures for wave and tidal energy conversion technologies.  However, some composite materials are expensive and are unproven under required performance conditions.  To reduce uncertainty in using composites, we are investigating their performance, potential for manufacture, and providing validated resources to industry.     Sandia National Laboratories, along with Pacific Northwest National Laboratories, National Renewable Energy Laboratory, Montana State University, and Florida Atlantic University have partnered to investigate carbon and glass reinforced composites.   We are evaluating environmental effects (biofouling, salt water, corrosion) on performance of composites coupons using materials provided by U.S. Marine &amp; Hydrokinetic (MHK) technology developers and supply chain vendors. Coupons were submersed in actual and simulated seawater to learn how to mitigate composite biofouling/environmental effects &amp; metal-carbon fiber interconnect corrosion in saltwater. Tensile static and fatigue testing on 33 different laminates, from five suppliers were also conducted. Testing was performed on unconditioned and simulated seawater conditioned coupons of each laminate. Preparation for substructure testing and understanding of wave and tidal load challenges are current tasks in which developers have been directing our program.        Results will provide industry a better understanding of the materials science and engineering behind MHK composite structures to avoid costly redesigns. Data will be housed in the open source U.S. DOE MHK Materials &amp; Structures Database. This talk will focus on our understanding of marine composites and share with the audience that data will be housed in the open source U.S. DOE MHK Materials &amp; Structures Database.       Funding statement:   Sandia National Laboratories is a multimission laboratory managed  and  operated  by  National Technology and Engineering Solutions of Sandia LLC, a wholly owned subsidiary of Honeywell International Inc., for the U.S. Department of Energy’s National Nuclear Security Administration under contract DE-NA0003525. ","authors":"Bernadette A. Hernandez-Sanchez, James Nicholas, Budi Gunawan, David A. Miller, George T. Bonheyo, Francisco Presuel-Moreno, and Scott Hughes","topic":"8","file":"1507-4425-4-DR-OK.pdf","bib":"STRMAT-1507.bib"},
{"paperid":"1508","title":"Influence of Tidal Energy Converters on sediment dynamics in tidal channel","keywords":"Tidal stream turbines are one of the most advanced marine renewable energy technologies. Nonetheless, the application of the technology still faces considerable challenges, as uncertainties exist about the potential impacts of these devices on the marine environment. For instance, sediment dynamics have important implications to local fauna as well as turbine foundations, design and longevity. As a result, understanding of local sediment dynamics is an important element for environment influence and site assessments. However, full-scale environment surveys of tidal farms are sparse and limited, as it is at early stage of development. An alternative to study the potential impacts on the sediment transport is numerical modelling. Nevertheless, validation of these models remains challenging as it is difficult to acquire the necessary sediment data from these high-energy sites.   To address these challenges a series of idealised simulations, using hydrodynamic and sediment transport of MIKE21 and MIKE3 flexible mesh, are developed to investigate processes and interaction of Tidal Energy Converters (TECs) in an artificial high energetic flow system under a range of conditions (seabed type, arrays size, shape foundations, climate conditions). This is the first step of a larger project whose ultimate aim is to use multiples test cases to improve the prediction of the effects of TECs on sediment transport in Banks Strait, Tasmania, a promising tidal energy site, identified as part of the ARENA “Tidal Energy in Australia – Assessing Resource and Feasibility to Australia’s Future Energy Mix” project. ","authors":"Christelle Auguste, Jean-Roch Nader, Philip Marsh, and Remo Cossu","topic":"9","file":"1508-4712-2-DR-OK.pdf","bib":"ENVIRO-1508.bib"},
{"paperid":"1512","title":"Evaluation of the forecasting model for wave climate prediction at DanWEC","keywords":"In response to the political energy policies on the global level, a race has been initiated for renewable energy sources to become primary, and in some case the only, source of energy in some decades. To attain this goal, a drastic increase of renewable energy deployment and a diversification of the energy mix are compulsatory. Wave energy is considered as a candidate to enter the energy mix as it has complementary advantages with respect to both wind energy and photovoltaics. In order to bring wave energy to the level needed for deployment, lower levelised cost of energy (LCoE) is required. Similarly to wind energy, reduction of operation and maintenance (O&amp;M) associated costs is believed to have a major effect on the LCoE. One strategy to reduce the O&amp;M cost is to improve forecast models in order to better predict weather windows in terms of duration and wave height levels. This strategy has been implemented at a smaller scale at the Danish wave energy center (DanWEC) located at the northwestern coast of mainland Denmark. In collaboration with the department of civil engineering at Aalborg University and DHI, a forecast model for the test site area was developed based on the MIKE 21 spectral wave model. Based on its experience, DanWEC has built a database of O&amp;M activities undergone at the test site. An O&amp;M tool combining both the database of O&amp;M and the forecast model predicting the weather windows was established as a support tool for both the staff at the test site and the wave energy converter developers testing in the area. In this work we will present the forecast model developed for DanWEC, which updates a range of parameters related to the wave conditions, wind conditions and current speed throughout the modelling area twice every 24 hours. The forecast model provides a five days prognostic of the conditions at the test site and the model forcing comprises input from regional DHI models and wind fields. Its accuracy in terms of prediction errors with respect to measurements of wave height from wave measuring buoys deployed at the test site will also be given. We will give an introduction to the database of O&amp;M activities at the DanWEC test site. This includes, among others, the type operation, the type of vessel, the number of persons required for the operation and the duration of the operation. The O&amp;M tool developed based on the forecast model and the list of O&amp;M activities will also be presented. Quantification of the assistance provided by the tool is currently undergoing and will concluded this work. ","authors":"Amélie Têtu and Jens Peter Kofoed ","topic":"11","file":"1512-4900-1-DR-OK.pdf","bib":"OPANDM-1512.bib"},
{"paperid":"1513","title":"Capability Assessment of DTOcean Array Design Tool for Ocean Energy","keywords":"Enabling Future Arrays in Tidal (EnFAIT) is an EU tidal energy project to demonstrate the development, operation and decommissioning of the world’s largest tidal array (six turbines) over a five-year period. The project will demonstrate a grid-connected tidal energy array that delivers a step change in the lifetime cost of energy for tidal power. Part of the EnFAIT project is utilising DTOcean (Optimal Design Tools for Ocean Energy Arrays) to consider the effects of deploying arrays, using the results of the NOVA Innovation array at the Bluemull Sound (Scotland) to compare and validate these modelling tools.   This paper outlines the main characteristics of DTOcean and its potential to support the development of tidal arrays. DTOcean has five modules. The hydrodynamics module designs the layout of converters in a chosen region and calculates their power. The electrical module designs an electrical layout for the array and calculates the energy exported. The moorings and foundations module designs the foundations and moorings required to secure the converters. The installation module designs the installation plan for the energy converters and the array components. Finally, the operations and maintenance module calculates the required maintenance actions and downtime resulting from the operation of the converters over the lifetime of the array.   Three thematic assessments are then applied to the: economics, reliability and environment. The economic assessment tool produces economic indicators for the design, in particular the Levelised Cost of Energy (LCOE). The reliability assessments provide indicators for each sub-component of the overall system: system, sub-system, and component mean time to failure, risk priority and percentage of reliability. Finally, the environmental impact assessment identifies the most sensitive receptors/stressors, which are combined into different environmental functions.   The work by the University of Edinburgh EnFAIT project team to validate the DTOcean tool by applying it to the actual environment in the Bluemull Sound is then presented. DTOcean metrics are compared with the real-world array and the capabilities of the tool are assessed, along with areas for potential improvements.   The application of numerical models such as DTOcean to help plan the development of tidal arrays is an innovative strategy which can optimise power output and efficiency, reducing costs and improving confidence in the tidal energy sector. ","authors":"Tianna Bloise Thomaz, Leonore van Velzen, Henry Jeffrey, Encarni Medina Lopez, and Tom Wills","topic":"4","file":"1513-5009-1-DR-OK.pdf","bib":"TIDDEV-1513.bib"},
{"paperid":"1516","title":"A novel framework for the Digital Representation of physical and functional characteristics of Ocean Energy Systems","keywords":"The digitalisation process has already become widespread       in several engineering sectors, e.g. the building sector, pioneering this progress through the introduction of the Building Information Modelling (BIM) approach. It turns out that the attempt of modelling the real physical world building an architecture of the information through       digital twins, i.e. digital representation of       physical assets       and processes, seems to be successful, achieving the purpose of driving innovation and performance       by allowing testing of concepts in a virtual environment.         Whilst the ocean energy sector       -in this       case limited to tidal       and wave source-       is moving step forwards towards the first deployments and commercial projects, the challenge of establishing an integrated architecture of interacting digital objects representing the various components, subsystems and devices forming an ocean energy array project has become of crucial importance. Not only such       an       integrated architecture       is       aimed at representing the physical features of ocean energy systems, but also facilitates       the assessment of economic (e.g. lifetime costs) and technical (e.g. performances, energy yield, reliability and maintainability) impacts, as well as the social and environmental       acceptance of       such systems. This way, the digital representation will allow an easier identification of       the readiness level of the current technologies       and criticalities, focusing       on the innovation       efforts. The digitalisation       process of ocean energy systems       can count also on easy expandability and scalability among its features,       thus enabling representation of early designs, more mature technologies or commercial projects.         This       novel framework for the digital representation of physical and functional characteristics of ocean energy systems       is developed within the EU-funded DTOceanPlus       project.       The aim of DTOceanPlus       is twofold:  to produce a digital representation of the architecture of ocean energy systems, and to provide a set of tools (namely, Structured Innovation tools,       Stage Gate Design Tools, Deployment Design Tools and Assessment Tools), whose usage is demonstrated in real case studies.       The digitalisation process will accelerate the definition of a standard framework for the description of ocean energy systems at different TRLs, significantly enhancing       the ability of sector stakeholders to work collaboratively, thus accelerating development of the sector, whilst also further supporting stakeholders who wish to make objective comparisons between various technologies.         In this paper, the process of defining the architecture of the digital representation for ocean energy system within the project DTOceanPlus       is reported. The transition from the physical reality towards the digital representation, through the establishment of a data model defining the objects in the array, their topology (groupings), design datasets, attributes,       was done accounting for       the experience of previous projects and the first deployments.       It was necessary not only to model the physical objects, but       also to       include in the models the marine operations, in order to allow a continuous follow-up of the project throughout the life of the project as they can affect significantly the economic viability of the projects. The outcome       of this modelling effort is therefore presented and a proposal for solving issues like the instantiation process       and       the connectivity among instances is developed and critically analysed.      ","authors":"Vincenzo Nava, Pablo Ruiz- Minguela, Jonathan Hodges","topic":"10","file":"1516-4798-2-DR-OK.pdf","bib":"ECONOM-1516.bib"},
{"paperid":"1517","title":"An efficient numerical framework for the assessment of free surface effects on crossflow tidal turbines","keywords":"Crossflow turbines offer several advantages over horizontal axis turbines when trying to exploit natural flows like rivers or tidal streams. In the summers of 2014 and 2015, Ocean Renewable Power Company deployed its RivGen® Power System in Igiugig Alaska. Turbine performance was improved compared to previous barge testing for the same turbine design. This improvement was due in part to the river based deployment. In shallow waters, the turbine causes surface deformation and development of a bore. The strong interaction between the bore and turbine operating state make it a highly challenging design parameter. Characterizing this interaction with accuracy is essential to predicting the performance and thus economic viability of a given power system in many installation sites. However, the application of numerical methods for the simulation of Crossflow turbines is still a major challenge and design simulations of tidal turbines usually neglect the free surface to reduce computational burden. We present a numerical investigation of a cross flow turbine considering the effect of a free surface using OpenFOAM. A novel impulse based wavemaker and numerical beaches are used to create a numerical wave and current tank. To take the free surface into account efficiently, a surface tracking algorithm is used, based on the potentialFreeSurfaceDyMFoam solver class. Firstly, the formation of the bore and the relation to power output of the turbine is investigated. In a second step we use the numerical wave tank to assess the effect of surface waves on power output. Issues like accuracy and mesh/time step dependency are also discussed.","authors":"Milo Feinberg, Pàl Schmitt, James Donegan and Jarlath McEntee","topic":"6","file":"1517-4773-2-DR-OK.pdf","bib":"TIDHYD-1517.bib"},
{"paperid":"1519","title":"Performance assessment of different RANS turbulence models in numerical simulations for BH?OWSC","keywords":"Ocean wave energy has attracted many attentions from researchers and developers mainly because of its great energy potential. In order to capture and transform wave energy, the Wave Energy Converter (WEC) has to be designed and developed. In order for a WEC prototype to be successfully developed, modeling must be used to simulate the physical processes involved in operations of the WEC. Modeling can be analytical, physical, or numerical. As the computing power has been fast increasing, numerical modeling has become the most effective tool to be used in the processes of design and development. However, numerical modeling still has considerable amount of issues to be resolved in order to achieve its best performance. Some of these issues are related to turbulence models, most of which are formulated in the context of the Reynolds Averaged Navier-Stokes (RANS) equations.   The Bottom-Hinged Oscillating Wave Surge Converter (BH-OWSC) is a pitching device that extracts wave energy mainly in the surge direction. It has been shown that the BH-OWSC has the potential of achieving larger capture factor (or capture width ratio) than that of many other types of WEC. In addition, owing to the retractability of its prime mover toward the seabed (i.e. the whole device can be fully submerged) to minimize the wave impact, the BH-OWSC has much higher survivability during extreme weather events. Therefore, for regions like Taiwan whose wave resources are at low to median levels and weathers have extreme events like typhoon, the BH-OWSC seems to be the most appropriate choice for the development of wave energy.   This paper reports a performance assessment of three widely-used RANS turbulence models incorporated in the numerical simulations for the BH-OWSC. These turbulence models are the standard k-? model, the Renormalized Group (RNG) k-? model, and the k-? model. The dimensions of the BH-OWSC model and the incoming wave conditions used in the numerical simulations are identical to that of a previous experiment. And the damping coefficient of the PTO (Power Take-Off) in the numerical simulations is set to be the measured average value of the PTO (hydraulic pump) in the experiment. The angular strokes of the BH-OWSC model obtained in the numerical simulations using the three turbulence models will be compared to that measured in the experiment. The characteristics of turbulence computed using the three turbulence models will also be compared against one another to highlight the performance differences in capturing flow complexities. ","authors":"Duy Tong Nguyen, Yi?Chih Chow, Jiahn?Horng Chen, and Chen?Chou Lin","topic":"5","file":"1519-4921-1-DR-OK.pdf","bib":"WAVHYD-1519.bib"},
{"paperid":"1522","title":"Three-Dimensional Unsteady Hydrodynamic Modelling of Tidal Turbines","keywords":"Tidal channel flows present unique challenges to turbine designers due to the high level of large-scale turbulence (or “gusts”), which result in time-varying inlet conditions. This variation causes fluctuating loads on the turbine blades, which affect their fatigue life. In order to prevent either premature failure or over-cautious designs, it is vital to be able to evaluate the unsteady load accurately at the design stage. Over-simplifying the modelling will lead to errors in load prediction, but high-order simulations are too computationally expensive and time-consuming to be used on several candidate designs by engineers in industry. Because of this, suitable corrections and approximations for 3D and nonlinear flow features must be applied to established low-order models, in order to fully capture the unsteady load response. This work uses a low-order inviscid vortex lattice method and unsteady RANS simulations to investigate the load response of tidal turbine blades to three-dimensional gusts, and to understand which high-order phenomena must be considered by designers.   Current methods for predicting unsteady load response are based on two-dimensional models used in conjunction with Blade Element Momentum Theory (BEMT). Unsteady transfer functions obtained from 2D inviscid linear analytic models are used, and these have been verified as giving reasonably accurate results in experimental tests with 2D aerofoils encountering 2D gusts. However, due to the strongly three-dimensional nature of the interaction between the turbine and the unsteady flow, these models are not appropriate for use on a tidal turbine. Using an inviscid 3D vortex lattice model, this work shows that using 2D models on 3D geometry can give uncertainties of 20-50% in the prediction of unsteady fatigue loading. This generates an order of magnitude error on the fatigue life prediction of a composite turbine blade.   This paper outlines the results from a parametric study of the unsteady hydrodynamic response of a tidal turbine, using both low-order inviscid and high-order viscous methods. The effects of blade rotation, of 3D blade geometry, and of gusts that are non-uniform in the spanwise direction are shown using the vortex lattice model, and the results are compared with 2D load predictions. In this way, the limitations of low-order 2D models are found, and associated risk to fatigue lifetime established.  In order to assess the impact of viscous and non-linear effects, a parametric study of turbine response to unsteady inflow conditions is performed using URANS simulations of a turbine undergoing a series of harmonic, oscillating inlet flows. A stable and easily parameterised flow state is achieved by moving the turbine blade through circumferentially varying axial inlet flow, as if rotating through a series of jets. An illustration of the inlet flow conditions can be seen in figure 1. By comparing the URANS results with those from the vortex lattice model, the limitations of inviscid modelling are explored.  <img src=data:image/png;base64,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","authors":"Amanda S. M. Smyth, and Anna M. Young","topic":"6","file":"1522-4409-3-DR-OK.pdf","bib":"TIDHYD-1522.bib"},
{"paperid":"1523","title":"Experimental compressibility study on a Coaxial-Duct OWC","keywords":"Experimental and theoretical investigation are both required when studying wave energy converters (WECs). Experimental testing may become prohibitively expensive for prototype-scale testing, and, in general, it is only feasible at small-scale. However, small-scale tests do not always simulate all features of prototype-scale systems. Scaling issues may arise for these complex systems due to the impossibility to replicate all the geometric, kinematic and dynamic conditions of the prototype-scale device simultaneously. Despite this, physical modelling at small-scale tests are necessary within WECs development pathways. In oscillating-water-columns (OWCs), appropriate scaling of the power take-off system and the thermodynamic effects associated with air compressibility in the chamber involve special problems that are frequently ignored or tackled inadequately. This paper deals with the issues of scaling compressibility effects in OWCs. For this purpose, use was made of a coaxial-duct (CD) OWC WEC designed at Instituto Superior Técnico (IST). A small-scale model (1:100) of a fixed CD-OWC was built and tested at the wave flume of the Hydraulic Laboratory of Instituto Superior Técnico. Two configurations were tested (i) one in which the air chamber is scaled as the submerged part of the structure (as it is done in most cases reported in the literature), which does not allow the spring-like compressibility effect to be adequately modelled, and (ii) by connecting the air chamber of the model to a rigid-walled air reservoir whose volume allows that effect to be adequately simulated. It is important to remark that not much experimental data is available for model testing considering the scaling of the thermodynamic effects associated with air compressibility and compared to the more common procedures without additional air chamber reservoir. Results confirm the importance to study the compressibility effects on physical model testing which, in general, is not performed by developers due to the difficulties that arise when down-sizing the air chamber volume appropriately. These results represent a valuable source of data that may help the wave-energy community to understand, predict or better simulate large-scale devices.   ","authors":"Juan C. C. Portillo, Antonio F. O. Falcao, Joao. C. C. Henriques, and Luis M. C. Gato","topic":"3","file":"1523-5003-1-DR-OK.pdf","bib":"WAVDEV-1523.bib"},
{"paperid":"1527","title":"Evaluation of predictionless control for wave energy converters","keywords":"The acausality problem in control of a wave energy converter (WEC) plays a critical role in designing high-performance controllers. This problem has led to considerable research into wave prediction and feedforward WEC control strategies. It is well known that perfect knowledge of past and future events enables immediate corrective or optimal action, thereby improving control performance remarkably. However, it is also well known that the underlying system must be well designed; control cannot fix a bad design and the control quality highly depends on the accuracy of the system design. Additionally, one must consider the practical implementation of a control design, which relies on measurements and actuation systems. There are major implications to cost and reliability, for instance, when relying on remote sensors requiring real-time data-streaming (e.g., remote wave buoys). On the other hand, feedback control, based only on past and current measurements, does not necessitate future knowledge and therefore is easily implemented in real applications at a relatively low cost.  In this paper, a new feedback control strategy with no prediction is proposed that provides rivaling performance to a prediction-based controller, even when assuming perfect prediction. This innovative control scheme is derived first by abstracting the WEC in the same structure as an electrical circuit and by applying the Jacobi's maximum power transfer law to optimize WEC power absorption. However, this so-called complex conjugate approach suffers initially from the acausality problem. The situation improves by considering the complex conjugate control problem over a finite bandwidth (which neglects only the small amounts of energy in surface ripples and tsunami waves at high and low frequencies, respectively). Then, a causal controller, which we call the feedback resonating (FBR) controller, can be defined such that its frequency response follows that of the complex conjugate controller as closely as possible using fitting techniques such as system identification. This suboptimal controller requires no prediction and only the device velocity needs to be measured to calculate control signals. It is shown that this new controller can achieve more than 90% of the theoretical maximum expected to be obtained by the complex conjugate controller.  More specifically, as shown in Figure 1, the FBR controller performs much better than the existing proportional (P) or proportional-integral (PI) controllers in absorbing power  from waves. Even more, its performance lies only within 0.1% of a model predictive controller (MPC) with perfect future knowledge (something which is not practically attainable). To obtain these numerical results, a single degree of freedom heaving point absorber was selected for the study and ten different sea states, all of which are of JONSWAP type spectra, were considered as the incoming waves. Given the challenges and cost for accurate and robust wave prediction, this study provides a major argument and incentive for utilizing predictionless feedback for WEC control.     Figure 1: Summary of study results showing average power across model-scale sea states. ","authors":"Hancheol Cho, Giorgio Bacelli, Victor Nevarez, Felipe Wilches-Bernal, and Ryan G. Coe","topic":"7","file":"1527-4859-3-DR-OK.pdf","bib":"GRDPTO-1527.bib"},
{"paperid":"1528","title":"The wave-powered adaptable monitoring package: hardware design, installation, and deployment","keywords":"In October, 2018 the BOLT Lifesaver, a BOLT-class wave energy converter (WEC) developed by Fred. Olsen Ltd., was deployed at the Wave Energy Test Site in Kane’ohe Bay, Hawaii. For a full year prior to the deployment, researchers and industry partners at the University of Washington, University of Hawaii, Fred. Olsen Ltd., and Wibotic collaborated on the development of an autonomous wave-powered environmental monitoring system. The Lifesaver WEC, which was staged in Hawaii after a previous deployment, was instrumented with an Adaptable Monitoring Package (AMP), as well as an onboard control computer and power handling system. The AMP instrumentation suite included stereo-optical cameras, an acoustic camera, a multibeam sonar, two hydrophones, and a demonstration unit from Wibotic that could allow for wireless recharging of an underwater vehicle. At full power, the instrumentation and recharge system draws 600 W of power, which is relatively high in oceanographic terms. As a first of its kind deployment, this system demonstrates the transformative potential of wave energy to power oceanographic instrumentation and extend the endurance of autonomous underwater vehicles.   The Lifesaver WEC uses three power take-off units (PTOs) to convert energy from ocean waves into electrical power. For this deployment, the WEC was set up to supply power to the AMP system “on-demand” from the renewable “on-supply” resource. The AMP power handling system included a battery bank for backup storage, solar panel to maintain basic system function during periods with low wave power, and programmable logic controller (PLC) to automatically change the operational states. Electrical integration of the WEC’s supply to the AMP was thus a single power cable and signal cable to indicate the level of power production from wave energy.   Integrating the AMP’s underwater instruments with the hull of the Lifesaver required the design of a custom mounting frame. Since the Lifesaver has five PTO wells in its hull, but only three PTOs, the instrument frame was designed to deploy the AMP sensors through one of the unused wells. This frame allowed the instruments to be raised out of the water for towing and maintenance and then lowered to a depth of 2 m after WEC deployment. The instruments were also angled to center one of the PTO mooring lines in the fields of view of the cameras and sonars to characterize any interaction with marine animals.   Onboard the Lifesaver, the AMP control computer continuously acquires data from all of the instruments into rings buffers for real-time target detection and classification. When a target of interest is detected, the data is saved to disc and subsequently transmitted to shore for further review. Connectivity with the AMP system is maintained by a point-to-point wireless modem from a shore-side computer, as well as a cellular modem and a low bandwidth GSM connection.  This paper presents an overall description of the Lifesaver and AMP integration, as well as operational results from the field deployment. A discussion of challenges faced in permitting, integration, and operations provides a valuable resource to future deployments of this type.  ","authors":"James B Joslin, Emma D Cotter, Paul G Murphy, Paul J Gibbs, Rob J Cavagnaro, Corey R Crisp, Andy R Stewart, Brian Polagye, Patrick S. Cross, Even Hjetland, Andrew Rocheleau, and Benjamin H Waters","topic":"9","file":"1528-4748-2-DR-OK.pdf","bib":"ENVIRO-1528.bib"},
{"paperid":"1531","title":"Scale model testing of the WASP - a novel wave measuring buoy","keywords":"In order to assess the viability of locations for proposed wave energy farms, and design optimal wave energy converters and wave farm layouts, wave farm developers will need knowledge of local wave regimes. Furthermore, with the increasing occurrence of extreme weather events, coupled with rising sea-levels as a results of climate change, local authorities will also require knowledge of wave regimes in order to design effective coastal protection measures. Wave conditions at a point may be measured using existing buoys such as the range of wave rider buoys made by Datawell BV. However, such devices are expensive. The work described in the proposed paper has been undertaken as part of an effort to develop a low-cost, wave-powering buoy to measure wave conditions to meet the needs of both developers and local authorities. A number of low-cost buoys may potentially be deployed at a location to measure the local wave climate both temporally and spatially. The proposed device, christened the Wave-Activated Sensor Power Buoy (WASP) will comprise a floating body with a centre moonpool. The relative motion of the water level in the moonpool to the buoy will pressurise and depressurise the air above the water column and be used to drive a bidirectional turbine in the manner of an oscillating water column, which will be used in conjunction with a generator to recharge an on-board battery pack. Once the WASP has been suitably calibrated, the wave spectrum may be estimated from measurements of the pressure of the air above the water column. Important statistical parameters relating to the sea-state, such as the significant wave height, zero-cross period etc. may then be estimated from the spectral moments of the wave spectrum. Mathematical techniques may be used to determine sea-sates from the time series of the air pressure. Such techniques include inverse transfer functions, neural networks and numerical estimators, each of which is currently the subject of further investigation, once the WASP has been calibrated. The initial prototype of the WASP will use a modified, off-the-shelf buoy, the Seagull navigation buoy manufactured by JFC Manufacturing Company Ltd., Ireland.  In order to investigate if the spectrum contained within a polychromatic wave may be determined from the variation of air pressure in the chamber of the moonpool of a floating buoy, a testing campaign was conducted on a 1:20 scale model of the Seagull buoy in the narrow wave flume test facility located at the Dundalk Institute of Technology, Ireland. The proposed paper will describe the issues encountered in the creation of the 1:20 scale model using 3-D printing techniques. The testing campaign conducted to calibrate the model and validate the measurement process will next be described. Results will be presented to demonstrate that the statistical parameters of a polychromatic wave may be estimated from the measurement of pressure variation in a floating buoy with a moonpool using an inverse transfer function. Finally, an issue with using the inverse transfer function approach is described, as well as proposed improvements to the measurement process.     ","authors":"Mark Boland, Thomas Kelly, Robert Carolan, Brendan Walsh, Thomas Dooley","topic":"3","file":"1531-4749-2-DR-OK.pdf","bib":"WAVDEV-1531.bib"},
{"paperid":"1533","title":"Experimental visualisation of heave plate flow regimes","keywords":"When used as reaction bodies for point absorbing wave energy converters, heave plates generate complex, oscillating flow fields. These hydrodynamics must be well-understood to optimize heave plate design for wave energy converter performance, survivability and cost. Prior work has identified the dominant forces (drag and added mass) and their relationship to the Keulegan-Carpenter number (KC). For sinusoidal motion, this non-dimensional number reduces to a ratio of the amplitude of oscillation to the diameter of the plate. Over regimes of interest for wave energy conversion, hydrodynamic coefficients are primarily a function of the KC number, with smaller, secondary dependence on the Reynolds number. Drag coefficients exponentially decay with the KC number, but added mass has two distinct flow regimes. There appears to be a critical KC number, of about two, which represents a transition point between two linear trends. We consider KC numbers below two representative of typical operating conditions for most heave plates on utility-scale wave energy converters. Larger KC numbers would correspond to an extreme operating condition.   Here, we utilize flow visualization to gain understanding of the fluid phenomena associated with heave plate motion in the different KC number regimes and the relation of these phenomena to the hydrodynamic force imposed on the plate. This includes an in-depth study of how this vortex behavior changes with KC numbers. Plates are oscillated in a laboratory tank by a linear actuator. Flow structure visualization is achieved by dye injection, and vortex size, development, and persistence are measured. Simultaneously, a data acquisition system records plate position (linear resolver) and the force acting on the plate (load cell). Results show that vortex formation and detachment occur during both regimes, but the specifics of that vortex behavior changes between regimes. For short stroke lengths (i.e., KC &lt; 2), vortex growth occurs throughout the stroke, vortex detachment occurs only during the change of direction of the plate, and advection of vortices away from the plate appears to be driven by a vortex pair interaction. For long stroke lengths (i.e., KC &gt; 2), additional momentum is imparted to the fluid surrounding the plate, leading to vortex formation during deceleration at the stroke extremes. Vortex growth is rapid, and during reversing acceleration of the plate, the vortex is destroyed by previously accelerated fluid flowing past the plate. The included figure shows snapshots at mid stroke for KC numbers of 1, 2, and 3, illustrating how the vortex becomes much less prominent at larger amplitude oscillations. It remains to be seen if this vortex behavior is the cause of the two coefficient regimes, or if it is merely a diagnostic for additional flow structures present around the plate. The results provide insight into the underlying hydrodynamics of heave plates, in turn lowering the energy cost and enhancing survivability of wave energy converters. ","authors":"Curtis J. Rusch, Brian L. Polagye and Benjamin D. Maurer","topic":"3","file":"1533-4706-2-DR-OK.pdf","bib":"WAVDEV-1533.bib"},
{"paperid":"1534","title":"Comparative study and test on a Wave Energy Point Absorber under various constrains","keywords":"Power generation and motion response of the floating wave energy converters is of great importance in the research topic of ocean energy harvesting. As a classic design for harvesting the ocean wave energy, the two body wave energy point absorber is commonly studied theoretically using the idealized 2DoF dynamic model where the mooring system is ignored and only the heave motion is considered. In this paper, in addition to the traditional 2DoF model, a 6DoF model which not only considers the motions in all DoF, but also takes in account of the mooring system is built for modelling the two body wave point absorber.  Numerical analysis using both models is conducted and presented for a comprehensive study on the difference of the two different models. In addition, to verify and validate the numerical analysis, a prototype is developed and tested in the water tank. With linear guide rails added to both of the body, the prototype is restricted in linear heave motion only for the test of 2DoF model verification. For the 6DoF validation, the prototype is moored to the wall of the water tank without additional constraints, allowing the bodies to move freely in all DoF. The data of the power generation and motion response under various constraints is monitored, recorded and analyzed for evaluating the models and conclude the work. ","authors":"Xiaofan Li, Qiuchi Xiong, Chien An Chen, Boxi Jiang, Shuo Chen, Khai Ngo, Robert Parker and Lei Zuo ","topic":"3","file":"1534-4834-1-DR-OK.pdf","bib":"WAVDEV-1534.bib"},
{"paperid":"1538","title":"A case study of high frequency AD2CP measurements for tidal site characterisation in Banks Straits, Tasmania, Australia","keywords":"The use of Acoustic Doppler Current Profilers (ADCPs) in order to measure and estimate parameters such as tidal current velocities, Reynolds stresses, turbulent kinetic energy and energy density spectrums is well known. However, ADCPs most commonly used can only obtain measurements at low frequencies and data collected from these instruments are usually averaged in order to reduce noise often leading to a loss of small-scale turbulence fluctuations. Moreover, the Doppler shift technology limits the accuracy for turbulence estimations (Nystrom, Oberg et al. 2002).   More recently, advanced technology instruments such as Nortek Signature AD2CPs – allow for higher frequency measurements at and with lower noise levels. Data from these instruments is promising to provide turbine developers important information regarding small-scale turbulence in highly energetic tidal channels and, therefore, contribute to the design of more resistant structures, reducing the unsteady loading on turbine blades. Here, we report measurements taken with two Nortek Signature AD2CPs deployed in two different locations within Banks Strait, a highly energetic tidal channel located in Australia. The instruments were set to obtain measurements at 8Hz for bursts lasting 15min with 15min intervals and have been deployed for a period between March and July 2018. We discuss turbulence intensities (turbulent kinetic energy, Reynolds stresses etc.) and compare these parameters at both sites. Results will also be compared to measurements taken from different ADCP devices available in the literature. To our knowledge, this is the longest field measurement done using this technology and its results could represent a significant advance in tidal site characterization and provide advanced information to turbine developers at an early stage.       Nystrom, E. A., et al. (2002). Hydraulic Measurements and Experimental Methods. T. L. Wahl, C. A. Pugh, K. A. Oberg and T. B. Vermeyen :  346-355.    ","authors":"Larissa Perez, Remo Cossu, Irene Penesis, Alistair Grinham, Jean R. Nader and Camille Couzi","topic":"2","file":"1538-4650-2-DR-OK.pdf","bib":"TIDRES-1538.bib"},
{"paperid":"1539","title":"A floating/submersible shrouded tidal  current turbine system applicable in low speed tidal flo","keywords":"Research and development of a floating/submersible type tidal current turbine system which can be used with low cost and in low speed tidal current is introduced. The system consists of the power generator by a horizontal axis turbine with a shroud or diffuser and a slack mooring system with four ropes. The shroud has a large buoyancy so that the tidal current turbine floats on the free-surface when the tidal current is small but it submerges in the middle layer to generate power when the tidal current is greater than certain speed. The tidal current turbine moored by the ropes changes its direction passively according to the direction of tidal current. Results of the model experiments in the circulating water channel and the towing tank are reported to show the performance of the system. The demonstration experiments by the larger model with 5kW generator in the sea is planning from March to April 2019 will be introduced in the presentation.   ","authors":"Yusaku Kyozuka, Daisaku Sakaguchi, Makoto Sueyoshi and Changhong Hu","topic":"4","file":"1539-4816-3-DR-OK.pdf","bib":"TIDDEV-1539.bib"},
{"paperid":"1540","title":"Empirical Far Wake Model of a Seabed-Mounted Tidal Turbine","keywords":"Tidal turbines farms are used for harnessing kinetic energy from oceans. Prior to conceive a project with industrial interest, the analysis of hydrokinetic interactions between the devices in a farm should be analysed. In fact, the power produced by a cluster of tidal turbines is affected by the turbines’ layout because of the wake effects. The latter can be analysed using analytical models because of their relatively high precision and lower computational cost compared to the numerical model.   In the literature, it is possible to find two analytical tidal turbine wake models. Stallard et al. [1] developed a semi-analytical wake model from measurements of a tidal turbine wake in shallow waters. Lo Brutto et al. [2-3] adapted the Jensen model from wind farm literature [4] in order to analyse the wake of a tidal turbine installed in deep waters. Both models are characterised by high precision results in their fields of application; however they can be applied only in the case that the turbine wake expansion is symmetrical with respect to the axis of the device, in order to respect the hypothesis of self-similar wake (as in Stallard et al. [1]) or axial-symmetric wake (as in Lo Brutto et al. [2-3]). This is possible if the turbine is installed at mid-depth in the exploited site.   The aim of this paper is to present an analytical model to estimate the tidal velocity in the wake of a tidal turbine installed on the seabed, considering the effect of the latter on the wake expansion. The model is developed using CFD simulations with a turbine represented by an actuator disk as a reference [5]. The impact of the ambient turbulence will be considered in this study. This analysis will allow extending the applicability of the existing tidal turbine wake models.  ","authors":"Christian Orgiazzi, Sylvain S. Guillou, Ottavio A. Lo Brutto, Alina Santa Cruz, Céline Mayousse, Mohamad N. Shiekh Elsouk, and Alan Jean-Marie","topic":"6","file":"1540-4819-2-DR-OK.pdf","bib":"TIDHYD-1540.bib"},
{"paperid":"1545","title":"Dynamic loads arising from broken wave impacts on a cylindrical turbine substructure in shallow waters","keywords":"Global warming and a fossil fuel shortage have led to an increased use of renewable energies in recent years. Among the technologies being used, the market of tidal and offshore wind turbines are constantly growing. In this regard, support sub-structures are categorised into different types on the basis of the water depth and soil characteristics of the seabed.  Although monopiles are typically the preferred option, the use of the so-called Gravity Base Foundations is still needed at sites where installation of piles in the underlying seabed is difficult. So far, composite gravity base foundations have been demonstrated to be technically feasible and economically viable in shallow water depths, ranging from 2 to 15 m. In these situations, the probability of occurrence of broken impacts increases due to the depth-limited condition. Broken waves are characterised by turbulent bores that can have a relatively high residual celerity, especially when the wave propagates on steep slopes. The peak load due to broken waves on slender piles can be estimated by determining the drag force component of the Morison equation. However, such a formulation does not allow a proper evaluation of the dynamic load on the structure as the load impact duration is not explicitly taken into account. In this regard, several investigations have highlighted the fact that the impulse and the impact duration should be carefully considered in dynamic analyses as they play a key role in the structural response. In this paper, the dynamic load due to broken waves on a generic cylindrical base foundation in depth-limited condition is discussed by comparing results with Morison equation.   To this aim, small scale regular tests were carried out at Plymouth University. Horizontal forces on the cylindrical model were obtained by means of load cells measurements. Nine wave probes and 3 cameras were also used during the experiments.   Dimensionless force and load duration values were obtained by dividing force peaks (F max ) by the specific weight of the water (?= ?g ), breaking wave height (H b ), water depth at the toe of the cylindrical model (h t ) and average diameter of the cylinder (D); while the rise time (t r ) – time taken to get to F max  from 0 – was divided by the wave period (T).   Results show that the dimensionless force peak (F’) has a tendency to decrease as the dimensionless impact duration (t’) increases. The data set (128 regular tests) caused 28 broken impacts (turbulent bores) with dimensionless force peaks ranging between 2.1 and 0.8. An envelope third order polynomial has been used to delimit maximum peak forces on the dimensionless force-rise time plane. On the basis of the tested wave conditions, the maximum measured force results to be 38% larger than the drag force calculated by means of the Morison equation (Fig.1). With respect to such condition, the Morison force is then underestimated for polynomial values between 0.12&lt;t’?0.175 and overestimated for 0.175&lt;t’&lt;0.24 (Fig.2). Although the polynomial provides a possible 120% variation in the peak force, the scatter of the impulse is much lower i.e. 18%.           ","authors":"Davide Banfi, Alison Raby, and David Simmonds ","topic":"12","file":"1545-3949-3-DR-OK.pdf","bib":"MRGFND-1545.bib"},
{"paperid":"1546","title":"A review of flexible membrane structures for Wave Energy Converters  ","keywords":"Since the renewed interest in the technology, there have been numerous approaches to harvesting wave energy. Significant progress is being made, however, one of the major challenges which still faces the industry is the high Levelised Cost of Energy (LCoE) compared to other renewable energy sources such as offshore wind. In recent years, there is a growing interest in the use of elastomeric materials in Wave Energy Converters (WECs). Rubber provides excellent durability, corrosion resistance and can undergo large deformations during cyclic loading. The utilisation of these materials should provide greater survivability and reduce the design complexity of WECs. With this comes better reliability requirements which should lower the LCoE.   Firstly, this paper reviews some of the key technological developments since the inception of these novel WECs. A comparison has been made between the traditional and elastomeric attenuator, point absorber and terminator devices, detailing the benefits and limitations of each. WECs which operate via a pumping method such as the Bombora, Anaconda, AWS III and Wave Carpet are studied in depth. Additionally, the advent of di-electric elastomers has been recognised for wave energy devices as a power take-off (PTO) method. Results published by Edinburgh University with Poly-WEC and the elastomeric attenuator named S3 developed by Single Buoy Mooring (SBM) Offshore are reviewed. The potential benefits and drawbacks of having a dual PTO using di-electric energy generation as well as a pumping method are also discussed.   Secondly, this paper provides some context on the challenges that still face elastomeric devices. Reliability information on elastomer performance under wave loading conditions is not a well-researched area. Ifremer have undertaken research into the uniaxial fatigue life of elastomers in a seawater environment. However, further fatigue testing under multiaxial cyclic loading taking into account seawater conditions is required for successful device development. Furthermore, the non-linearity of elastomeric materials provide an additional challenge when characterising their performance in a numerical model. Hydroelasticity studies of highly deformable bodies can be extremely computationally demanding. Consequently, research into a simplified hydro-elastic analysis is needed for a numerical performance characterisation with an acceptable simulation time. In order to validate the PTO for di-electric elastomers, the coupling of the hydro-elastic response to an electrical generation equation is required. There have been hydro-elastic-electro analyses undertaken on the Poly-WEC devices and the SBM S3 which are also reviewed in this paper.    ","authors":"Ieuan Collins, Mokarram Hossain, and Ian Masters","topic":"8","file":"1546-4747-2-DR-OK.pdf","bib":"STRMAT-1546.bib"},
{"paperid":"1553","title":"Marine energy resource characterization, and classification in the United States","keywords":"Comprehensive, detailed and reliable data on marine energy resource characteristics is essential for advancing the marine renewable energy industry. In this paper, we showcase the U.S. Department of Energy’s resource characterization and assessment project. This multi-year project, conducted by three national labs, is delivering data and results designed to reduce the uncertainty, risk, and cost of marine energy technology.   Over its first three years this project has: 1) completed high-resolution, long-term regional wave hindcasts for the U.S. east and west coasts, 2) completed high-resolution tidal models of five top-ranking tidal energy sites, 3) completed detailed resource measurements following International Electrotechnical Commission (IEC) technical specifications at four wave energy sites and four tidal energy sites, and 4) developed wave classification schemes. The project has been guided by an international steering committee composed of industry partners and academic experts.   As the project moves toward completion the team will: complete high-resolution modeling efforts for all U.S. coastal waters, complete wave and tidal resource measurement efforts, refine the national resource assessments, propose classification schemes to the IEC standards body, and upgrade the Marine and Hydrokinetic (MHK) Atlas to make the project’s data public and accessible. These data and tools can be used for: device design processes for technology developers, economic assessments for project developers, energy assessments (power supply and energy portfolio diversification) for regional planners and policy makers, operational reliability and economic assessments for utilities and investors, and baseline data for environmental impacts studies needed by regulatory agencies.  This paper will summarize the project’s approaches, accomplishments, challenges, lessons learned, next steps, and dissemination strategies. This will include an overview of refined resource assessment methods, high-resolution regional model hindcasts, new tidal turbulence measurement methods and results, classification schemes, and the MHK Atlas web-portal.","authors":"Levi F. Kilcher, Vincent S. Neary, Zhaoqing Yang","topic":"1","file":"1553-4984-1-DR-OK.pdf","bib":"WAVRES-1553.bib"},
{"paperid":"1554","title":"Towards characterisation of the Australian national tidal power resource","keywords":"Australia’s tidal resources are known to be significant, being home to the second highest tides in the world. Best present estimates suggest Australia’s possesses about one to two per-cent of the global tidal stream resource, and about 30% of the global tidal range resource.   These estimates have little foundation, with few studies investigating Australia’s resource at a national scale, and no prior assessment has had sufficient information (validated models of sufficient resolution) to provide an appropriate estimate of the tidal stream resource. This lack of information hampers potential investors of tidal energy projects in Australia, seeking to understand the opportunities and risks.   As part of the Australian Renewable Energy Agency supported AusTEN (Australian Tidal Energy) project, a national scale model is being developed to better resolve Australia’s national tidal resources, to identify the most prospective tidal energy development sites.   Australia is a large island nation, having some 60000km of coastline, with considerable variation in tidal properties around the coastline. To resolve tidal circulation at appropriate scales in the energetic regions of interest, and balance computational requirements, an unstructured grid approach is necessary. Here, a national scale configuration of CSIRO’s Coastal Ocean Model Prediction Across Scales (COMPAS) model is deployed to simulate Australia’s national tidal circulation. The unstructured mesh is constructed, using a weighting function on the basis of bathymetry and tidal range, to capture higher resolution in more energetic regions. The resolution spans a range of approximately 400m in the highest resolution energetic regions, to over 50km on the shelf edge in low energetic regions.   This paper will outline the configuration of the national model, and present estimates of the national scale tidal stream and range energy resource.     ","authors":"Mark A. Hemer, Mike Herzfeld, Farhan Rizwi and Uwe Rosebrock","topic":"2","file":"1554-4602-1-DR-OK.pdf","bib":"TIDRES-1554.bib"},
{"paperid":"1555","title":"WEC-Sim Array Development and Experimental Comparison Study ","keywords":"In this paper, we will conduct a validation study to investigate the accuracy and ability of WEC-Sim to model arrays of WECs. This research work is also part of a study on power management and control for WEC arrays, which aims on reducing the power fluctuations and the integration impacts of WEC plants in both distribution and transmission grids, and in the standalone isolated power systems. This study is the first step of the code development and validation efforts for the project. The results from the WEC-Sim array simulations are compared to those from an existing experimental study. In addition, the array model will be used to investigate the influence of array spacing on the WEC hydrodynamic performance.   Wave energy is still considered to be an emerging industry, and one significant contribution that researchers are making is to find solutions that reduce costs. The National Renewable Energy Lab (NREL) and Sandia National Laboratory (SNL) have contributed to this by creating WEC-Sim, an open-source modeling toolbox, to assist with early design decisions related to the design of Wave Energy Converters (WECs). Since the release of WEC-Sim in 2014, studies conducted using the toolbox have investigated simulations of a single WEC. Although this research is advantageous for the design of single devices, there is a gap in knowledge of the performance for multiple WECs located in an array. A baseline for simulating arrays is therefore required to assess the capabilities of more complex systems in WEC-Sim. Investigating the array modeling capabilities of WEC-Sim will provide a reference for future studies using the toolbox for more complex systems and for grid impact analysis. The first part of the study is focused on model validation. The WEC-Sim simulations will also use a NEMOH based boundary element model to calculate the hydrodynamic coefficients. The experiment was conducted by SNL and Aalborg, which consists of five scale-model devices that were tested through varying regular and irregular sea states. A set of wave cases are chosen from the tank tests to compare the pitch response of the simulated array. The experimental comparison will illustrate WEC-Sim’s ability to model arrays of WECs with multiple bodies. In addition, a minimum-separation-distance study will be conducted to investigate the interaction between the WECs in the array. This investigation will work to optimize the layout and provide initial steps for smoothing the power captured from the array.  ","authors":"Hannah Mankle, Yi-Hsiang Yu, and Bryony DuPont","topic":"5","file":"1555-5063-1-DR-OK.pdf","bib":"WAVHYD-1555.bib"},
{"paperid":"1556","title":"Marine energy classification systems: Tools for resource assessment and design ","keywords":"The success of wind classification systems has motivated interest in similar classification systems for the wave and tidal energy industry. Wave and tidal energy  resource attribute  classification systems, used to appraise the resource in terms of opportunity for energy generation based on power density as well as project constraints and risks, serve as a useful resource assessment tool that facilitates siting, project scoping studies and regional energy planning.  Resource   condition  classification systems, by establishing standard classes for the environmental conditions, streamline design procedures and reduce design and manufacturing costs while minimizing technical and financial risk. Few in the marine energy industry, however, understand the underlying methods and approaches in formulating classification systems, and how they benefit a variety of industry stakeholders. We address this general lack of knowledge and understanding by reviewing the common themes, methods, and lessons learned among three renewable energy resource classification systems at various stages of development: mature wind classification systems, preliminary ( experimental ) wave classification systems, and conceptual tidal classification systems.   Wind resource classification systems, widely used for decades and fully integrated into design standards, provide a useful model for the present study’s efforts developing wave and tidal classification analogues. Important steps in building resource classification systems are presented, namely the selection of resource parameters, including  base  or  reference  parameters that are correlated with other parameters of interest, the calculation of these parameters for populations of resource sites representing the full range of resource attributes and conditions, class and subclass delineation, classification matrix formulation, and classification mapping.   For  resource attribute  classification, the main and most important parameter representing energy generation opportunity is power density, but additional parameters that gauge resource quality, constraints and risks should be calculated and archived to allow flexibility to develop more comprehensive or alternative classification systems as project experience is gained and the industry matures. What constitutes a balanced classification system that is simple but effective is largely subjective. While the US wind  resource attribute  classification is based only on power density, other systems, like the EU wind  resource attribute  classification, introduce subclasses based on topographical condition (terrain, surface roughness). Ideally the main classification parameters serve as base or reference parameters from which other parameters can be derived. This requires research investigating correlations between reference parameters and their derivatives. In the wind  resource condition  classification system, the reference wind speed (the wind speed recurring every 50-years on average) is correlated with the mean wind speed, which is used to derive the power density in wind  resource attribute  classification systems. Similar correlations are found in the present study for US wave climate sub-regions between the wave height recurring every 50-years and its mean value. High-resolution hydrodynamic model hindcasts are the main data source for building classification systems and maps from large populations of sites, but measurement databases are also needed to accurately compute parameters not resolved by these models, including turbulence and extreme wave height statistics. Future efforts are focused on improving the spatial coverage, resolution and accuracy of these databases. ","authors":"Vincent S. Neary, Kevin A. Haas, and Jonathan A. Colby","topic":"1","file":"1556-4672-2-DR-OK.pdf","bib":"WAVRES-1556.bib"},
{"paperid":"1558","title":"Numerical investigation of shallow-water effects on hydrokinetic turbine wake recovery","keywords":"A priori estimation of the hydrokinetic (HKT) turbine array performance requires an improved understanding of the wake recovery.  The authors past research (Salunkhe et al. 2017) focused on evaluation of HKT wake recovery for deep water conditions (or single-phase flow) using high-fidelity computational fluid dynamics (CFD) simulations. The results demonstrated that wake recovery is primarily due to the growth of shear layers (originating from the blade tips) towards the turbine axis, which is primarily caused by the cross-plane turbulent velocity. The far-wake develops around 8-diameters downstream of the turbine and shows a self-similar Gaussian deficit profile with isotropic turbulence structures. However, an HKT array could be located in shallow water, thus wake recovery can be significantly affected by the free-surface. This research will extend the previous research to understand the effect of the air-water interface on the mean and turbulent wake recovery. To achieve these objectives, detached eddy (DES) and large eddy (LES) simulations are performed for two-phase water flows over a bump. The simulations are performed for several free-surface clearances  h/H  = 0.22, 0.33 and 0.44, where  H  is the bump height. The mean and turbulent flow predictions in the bump wake are compared with Gui et al. (2014) experimental data, to validate the OpenFOAM predictive capability to accurately reproduce the interaction of wake and free-surface. DES and LES are performed for an isolated HKT turbine in shallow calm water using OpenFOAM (Jasak et al. 2007) on hexahedral meshes with around 12 -15 million cells. The study uses geometry and flow configuration employed by Tedds et al. (2014) plume experiments, which includes a 3-blade 0.5m diameter (D) HTK turbine with Wortmann FX 63-137 profile and 6° pitch, turbine rotating with a tip-speed ratio ? = 6.15, and blade tip located 0.35D below the free-surface. The validation study focuses on the mean and turbulent wake profiles in the intermediate wake between  x  = 1.5D to 7D, including an investigation of the plume blockage effects. The wake recovery will be compared with those predicted in single-phase simulations to evaluate the effect of shallow waters on mean and turbulent wake structures. ","authors":"Oumnia El Fajri, Shanti Bhushan, David Thompson, Tim O' Doherty","topic":"6","file":"1558-4885-2-DR-OK.pdf","bib":"TIDHYD-1558.bib"},
{"paperid":"1559","title":"Enhancement of a 3-DOF submerged wave energy device using bistability","keywords":"Harvesting energy from oscillating systems with bistability has been shown to enhance energy yield. The application of a nonlinear stiffness in the context of ocean wave energy harvesting is a relatively new concept. Various models have been present in the past few year demonstrating a variety of techniques to form bistable systems for wave energy converters (WECs). However, present work is restricted to a single degree of freedom (DOF) and often ignore drag effects. While current work has demonstrated some benefit for bistable WEC, one limitation of a single DOF is the absence of phase relationships between motion and excitation forces.  The working principle behind the inclusion of bistability is that motion between the two stable regions of a bistable system can lead to excitation of superharmonics, consequently converting low frequency to high frequency oscillations – favourable for energy generation. As shown heuristically in Figure 1. However, for higher frequencies and therefore higher velocities, the assumption of negligible drag forces may be erroneous.        Figure 1: The potential energy well for a heuristic bistable system with phase portraits of intrawell and interwell motion.     In this study, a submerged single tether point absorber (PA) with a bistable power take off(PTO) is modelled in 3 DOF subject to regular and irregular waves. The bistable condition is constructed using a simple magnetic dipole model to develop the required force profile. The degree of bistability is quantified by a dimensionless parameter applicable to any bistable system irrespective of the mechanism employed to induce bistability. The impact on theoretical power generation for the assumption of no viscous drag effects and no excitation force phase shift due to position is explored.  This work demonstrates the influence of bistability on submerged PA WEC systems, and shows the importance of drag effects and phase relationships between 3 DOF. With additional modelling fidelity to capture 3 DOF and drag forces, the hypothesised benefit of bistability was not consistently obtained in these simulations. Simulations of regular wave conditions, which are optimized for a single frequency, shows a reduction in generated power when including bistability. However results for an irregular wave with a tuned PTO configuration are shown in Figure 2 and demonstrate a substantial improvement.        Figure 2: Power generated for varying levels of bistable potential.     These findings emphasise the importance of accurate dynamic modelling and the inclusion of nonlinear factors in the design of WECs. Bistable effects were also shown to improve power generated in irregular wave conditions. ","authors":"Benjamin W. Schubert, William S. P. Robertson, Benjamin S. Cazzolato, and Mergen H. Ghayesh","topic":"3","file":"1559-4638-2-DR-OK.pdf","bib":"WAVDEV-1559.bib"},
{"paperid":"1560","title":"Performance analysis of wave energy resources at a WEC test site in Keelung, Taiwan ","keywords":"In Taiwan, one of the prior marine energy resources is wave energy and higher potentials in coastal waters are concluded to be located in the northeast Taiwan (Tzang, et al. 2012). Thus, to facilitate the development of the wave energy conversion technology, a permitted field test site was established in 2011 offshore Keelung in northeast Taiwan. A wave data buoy was then installed at the offshore boundary of the test site since 2012 to continually collect wave information entering the test site. Tzang, et al. (2018) reported the analysis of collected waves for three years from May 2012 to May 2015. They found from results of waves’ joint probability distributions and monthly variations of averaged wave energy resources that waves are larger and longer resulting in higher wave energy potential especially in the Northeast Monsoon season (Oct. to next March). For a specific wave energy converter (WEC), performance analysis from the derived annual distributions of wave and power scatter diagrams were carried out by selecting studied cases from the power scatter diagram based on rankings of energy production and occurrence as proposed by Lopez et al. (2016). As shown in Figs. 1 &amp; 2, the draft 16 cases (J01 to J16) consist of 55% of total occurrence probability while of 74% of total annual energy production per meter. For each of the case, corresponding spectral characteristics of a JONSWAP type were derived and subsequently converted to a time series of water surface displacements with random phases following the Normal Distribution (ed. Folley, 2016). Then, the capture factors for a case-studied model OWC were calculated from the interactions between waves and the WEC. The results of energy captured would further illustrate the performance analysis of a model OWC WEC based on the wave energy resources at the test site. Detailed results and discussions shall be given in the full paper.   ","authors":"S. Y. Tzang, Y. L. Chen, H. Z. Chen, J.H. Chen, Y. H. Lee, Y. C. Chow","topic":"1","file":"1560-4603-2-DR-OK.pdf","bib":"WAVRES-1560.bib"},
{"paperid":"1568","title":"Interaction of Ocean Wave Energy Converters","keywords":"Ocean wave energy is growing as a potentially viable source of renewable energy. It is expected that dozens of identical Point Absorber Wave Energy Converters (PAWECs) will be arranged in arrays to form a highly efficient Wave Energy Farm. One of the key challenges in designing such a WEC array is their spatial conguration, as the WECs in the farm interact hydrodynamically with each other. In this paper, we isolate this complex hydrodynamic problem and focus on the hydrodynamic interaction of just two cylindrical PAWECs in close vicinity. We apply the BEM model (NEMOH) and a time domain WEC Simulator (WEC-Sim) to compute the power output of two WECs while varying their relative position. We seek to validate the trends found in the simulation by experimentally testing scaled versions of two-WEC configurations in a wave tank. The simulations show that by wisely choosing, the relative position can significantly increase a WEC's individual power output. Spatial bands of higher potential power extraction were shown, with increases up to 20% compared to a single WEC on its own. However, the computational results showed realistic results for only a select number of configurations. As for the experiment, unexpected variations in test conditions occurred, inhibiting the possibility to isolate certain events. Therefore, when cross-checking results from both simulations and experiments, the identied simulated trends only partially showed adherence to the experimental data. Henceforth, the knowledge gathered from the simulations can't conclusively be validated by the experiments conducted in this study. This study shows that the spatial conguration of two WECs does, in fact, influence their individual power outputs. Our hypothesis is that a pattern of potential higher energy output is caused by the interference of radiation waves between both WECs. Further research is needed to validate the signicance and the exact locations of these areas of potential higher power output. ","authors":"Bruis van Vlijmen, Reinier Goudswaard, Remco Boere, Thomas Schneider, Henk Polinder and George Lavidas","topic":"3","file":"1568-4750-2-DR-OK.pdf","bib":"WAVDEV-1568.bib"},
{"paperid":"1572","title":"Model for evaluating the electric power output of Pressure Retarded Osmosis generation plants","keywords":"The demand for electric energy has importantly increased in the last decades due to population growth and economic development, which has unlaced a faster consumption of fossil fuels and greenhouse gas emissions (GHGs). At the same time, however, our planet is experiencing an undesirable climatic change and the depletion of non-renewable energy resources is a global concern. These concerns provide more than sufficient incentives to reduce the consumption of fossil fuels and to increase the electric power production based on clean, green and renewable energy sources. The oceans are one of such a friendly energy sources and can provide vast amounts of energy for electric power production from different mechanisms. The pressure retarded osmosis (PRO) is one of those mechanisms and is performed in PRO-based generation plants installed at rivers mouths, where energy from the chemical potential produced by the salinity gradient between fresh (river) water and salt (sea) water can be harnessed. For this purpose, in these PRO-based generation plants the two water bodies with different salinity concentrations are pumped into a membrane module, where the fresh and salt water bins are separated by a membrane permeable to water but not to salt. Hence, due to the chemical potential, a flux of fresh water is produced toward the already pressurized bin of salt water. The flux equivalent to the permeated flux is the input of a turbine-electric generator system to produce the electric power that must be integrated to the distribution network.    For the proper electric network operation and power generation-demand balancing, however, the effects produced by the integration of the electric power coming from new technologies must be inherently studied. Accordingly, in this work a unified mathematical model is assembled to evaluate the electric power output of a PRO-based generation plant. Different to related works already reported in the literature, the unified model is assembled bearing in mind the steady state analysis of electric distribution networks under the integration of PRO-based generation plants. The mathematical model collects the main factors affecting the PRO process through the semipermeable membrane; internal concentration polarization, external concentration polarization and spatial variations. The induction generator is selected to transform the turbine mechanical power output to electric power. Based on the salinity gradient between the fresh water and salt water the assembled model can assess the complex power output of the electric generator. Accordingly, the proposed model could be directly included into the tools for steady state analysis of electric power systems, which is an undergoing product of this research work.     Two case studies are reported where the proposed model is used to evaluate the electric power output of the PRO-based generation plant. The results obtained show that the electric power output of the PRO-base plant decreases with the reduction of the water pressurized flux. Moreover, results suggest that for the selected generator, the integration of the produced active power would require a compensation of reactive power. These concluding remarks are supported by results illustrated in Fig. 1.              Figure 1. Power electric ","authors":"Mario Llamas-Rivas, Alejandro Pizano-Martínez, Claudio R. Fuerte-Esquivel, Luis R. Merchan-Villalba and Víctor J. Gutiérrez-Martínez","topic":"7","file":"1572-4621-2-DR-OK.pdf","bib":"GRDPTO-1572.bib"},
{"paperid":"1573","title":"Characterizing the dynamic behavior and performance of a scaled prototype point absorber wave energy converter in a large","keywords":"Designing a wave energy converter (WEC) often involves characterizing the dynamic behavior and performance of a scaled prototype of the WEC in order to de-risk a development project.  The paper will present a scaled prototype testing of a second generation point-absorber WEC, designed by AquaHarmonics, Inc., at the Oregon State University’s large wave flume.  The second generation AquaHarmonics WEC has a similar working mechanism as to the first generation AquaHarmonics WEC that was awarded the first prize during the Wave Energy Prize competition [1], but with improved hardware and protocols.   An analytical model to describe the input and output behavior of the WEC system was developed.  The model consist of two parts: a hydro-mechanical part that describes the wave-body interaction of the WEC, and an electromechanical part that describes the WEC power take-off (PTO) dynamics. System identification analyses were used in conjunction with experimental datasets to derive model parameters.  A set of regular and irregular wave cases were designed and selected for developing multiple power generation performance curves for three different tuning variables: spring stiffness, PTO damping and spring pretension force.  The analyses of the performance curves for selecting optimal performance and cost balance will be described in detail. In addition, the power generation performance of two different hull shapes (a cylinder and a semi-irregular shape) that were tested, as well as their impact on the device hydrodynamics will be presented.   References:   [1] Department of Energy (2016). Wave Energy Prize Official Webpage (https://www.energy.gov/eere/water/wave-energy-prize-home).   Funding statement:   Sandia National Laboratories is a multimission laboratory managed and  operated  by  National Technology and Engineering Solutions of Sandia LLC, a wholly owned subsidiary of Honeywell International Inc., for the U.S. Department of Energy’s National Nuclear Security Administration under contract DE-NA0003525.         ","authors":"Giorgio Bacelli, Max Ginsburg, Alex Haegmueller, and Budi Gunawan","topic":"3","file":"1573-5055-1-DR-OK.pdf","bib":"WAVDEV-1573.bib"},
{"paperid":"1574","title":"Advanced measurement and analysis of waves and turbulence using 5-, 7- or 8-beam ADCPs","keywords":"Multi-beam Acoustic Doppler Current Profilers (ADCPs) are increasingly being used for both tidal and wave resource analysis. Two areas where multi-beam ADCPs are being used are in the analysis of currents, turbulence and waves. The performance of different ADCP beam configurations is compared, showing that using ADCPs with more than 6-beams it is possible to fully resolve the turbulence parameters. The minimum measurable Reynolds stresses is calculated for 7 and 8-beam ADCPs, correcting an error in a previous calculation by Vermeulen. Although ADCPs have long been used for tidal resource analysis, they are increasingly being used for wave resource analysis due to their suitability for relatively shallow water where wave energy converters may be deployed. The use of surface-tracking to estimate the directional wave spectrum is investigated. The need to use surface-tracking for the directional wave spectrum is particularly relevant where there are strong currents because the use of the beam-velocities for directional analysis can break-down in these circumstances. However, it is shown that weak along-beam reflections, associated with smooth water surfaces when there are light winds, results in difficulties with implementing surface tracking for slanted beams. Specifically, it is shown that reflections from directly above the ADCP could mask the weak reflection along the beam. By masking the slanted beam data using the vertical range to the surface (available from the vertical beam) the data quality could be significantly improved, although some spurious echoes remain. In addition, it was found that standard surface-tracking techniques can lead to bias in the estimate of the surface elevation and thus significant wave height due to the interpolation technique used. An alternative asymmetric interpolation technique is proposed, which is shown in significantly improve the estimate of the significant wave height when relatively large bin widths are used.","authors":"Eloi Droniou, Matt Folley, Yves Perignon and Cuan Boake","topic":"3","file":"1574-5015-1-DR-OK.pdf","bib":"WAVDEV-1574.bib"},
{"paperid":"1575","title":"Recent developments at the U.S. Navy wave energy test site","keywords":"The U.S. Navy’s Wave Energy Test Site (WETS) in Hawaii has hosted two wave energy conversion (WEC) devices since its June 2015 commissioning – the Fred. Olsen Lifesaver and the Northwest Energy Innovations Azura – each for two deployments.  Several additional devices will be tested in the coming years, beginning with the Ocean Energy device in spring 2019.  The Hawaii Natural Energy Institute (HNEI) is funded by the Naval Facilities Engineering Command (NAVFAC), through the Applied Research Laboratory at the University of Hawaii, to provide research and logistics support to WETS.  We will provide an overview of three major activities that we have recently undertaken for the Navy – the modification and redeployment of the Northwest Energy Innovations (NWEI) Azura WEC, the design of mooring modifications at the two deeper berths, and the redeployment of the Fred. Olsen BOLT Lifesaver.   The Azura was deployed from June 2015 to December 2016.  Based on performance and motion data from that deployment, HNEI funded NWEI to redesign the device in an attempt to improve power performance.  A larger float with increased moment arm was installed to improve motion response in the dominant wave periods representative of WETS, and a heave plate was installed at the base.  The device was redeployed for six months in 2018, and while device motions improved in ways similar to those predicted by modeling, this did not equate to improved electrical generation.  These results will be discussed.   HNEI has undertaken a redesign of the deeper berth moorings at WETS, with principal engineering guidance from DNVGL.  This has included extensive numerical analysis of strength and fatigue aimed at establishing moorings that can persist for many years.  The resulting design incorporates heavier chain and associated joining links, more robust surface floats, and a “no-WEC hawser” system for maintaining sufficient pretension, with major impacts on fatigue life, during times when the berth is not supporting a test.  The resultant design will be detailed.   Lifesaver was deployed from March 2016 to April 2017.  Based on lessons learned, primarily relating to mooring methodology, HNEI undertook a second deployment beginning in October 2018, with the intent of achieving improvements in both reliability and power performance.  Also, HNEI partnered with the Applied Physics Laboratory at the University of Washington to integrate their Adaptable Monitoring Package (AMP) into the hull of Lifesaver.  This system includes hydrophones, a multibeam sonar, and acoustic and optical cameras, and is designed to monitor marine life near marine energy converters.  Further, a subsea inductive charging capability from Seattle startup WiBotic, Inc. was incorporated, providing an important demonstration of an autonomous undersea vehicle recharge capability.  As the WEC is not cabled to shore in this test, these systems are powered by electricity generated by the Lifesaver itself and stored in onboard batteries.  We will discuss this project, emphasizing mooring strategy and resultant changes in performance and reliability, and provide a high-level view of the significance of this deployment to alternate maritime market applications. ","authors":"Patrick Cross, Krishnakumar Rajagopalan, Andrew Druetzler, Alex Argyros, James Joslin, Even Hjetland, Andrew Stewart","topic":"3","file":"1575-4910-1-DR-OK.pdf","bib":"WAVDEV-1575.bib"},
{"paperid":"1578","title":"Wave energy resource and its conversion efficiency along the coast of Argentina ","keywords":"The paper presents an evaluation of the wave energy resource and an analysis of wave energy potential output for three of the most widely diffused Wave Energy Converters (WEC) along the Argentine coast.   With its almost 5000 km of coastline, Argentina provides an ideal scenario for the exploitation of this renewable energy. Unfortunately, no direct (buoy) wave data are available in this area, so the analysis has been carried out by using WAVEWATCH III and WAM hindcast data produced respectively by NOAA Marine Modeling and Analysis Branch (available from 1979 to 2009) and by European Centre for Medium-Range Weather Forecasts (ECMWF) ERA-Interim project (available from 1979 to present). Different model grid points at a depth of about 100 meters and at a distance not exceeding 200 km from the coast have been considered. For each point a statistical analysis of the average yearly energy has been performed as well as its  monthly, seasonal and directional variability. Results show that for different points the mean yearly potential power is higher than 20 kW/m, with peaks of about 25 kW/m. By making use of the Load Factor and of the Wave Energy Transformation Index (IWET), an estimate of the power generated by three WEC devices (Aquabuoy, Langlee, Pelamis) and their relative efficiency has been performed, as well as the optimal orientation for the directional WECs.   It is shown that Langlee and Pelamis in practice provide the same amount of energy (more than three times as much as Aquabuoy) with the same IWET values; however by analyzing the load factor values, it appears that the most efficient device is Pelamis with a load factor of 25% compared to 12% supplied by Langlee. ","authors":"Ferdinando Reale, Fabrizio T. Abbondandolo, Fabio Dentale, Angela Di Leo, and Eugenio Pugliese Carratelli","topic":"1","file":"1578-4764-3-DR-OK.pdf","bib":"WAVRES-1578.bib"},
{"paperid":"1583","title":"Structural design and optimisation of a full-scale tidal turbine blade","keywords":"This paper focuses on the structural design and optimisation of a 2 MW tidal turbine blade, with the goal of reducing the blade design and manufacturing costs. This scale of blade is relevant to the newest generation of   Orbital Marine Power   commercial turbine. The blade model optimisation was conducted using an in-house software    BladeComp   , developed in the Large Structures Research Group at NUI Galway. The blade design and modelling cover a range of properties, such as: aerodynamic profiles, composite materials and layup distributions. The structural response of the blade is analysed using the Finite Element (FE) software Abaqus.         Full-scale static blade testing has been conducted as part of the H20  20    FloTEC    project and through the MaRINET2 transnational access programme at NUI Galway.   To   verify the accuracy of the   FE   model  s  , the full-scale test   of the blade design   is simulated and analysed.       Using the verified FE models further optimisation of the design is conducted.   The material costs contribute a significant proportion to the total blade manufacturing costs, hence, optimisation of the layups is carried out, using genetic algorithms (GA), to reduce the blade mass. During the optimisation, the blade’s safe operation is assured by controlling its stiffness and ultimate stress/strain levels. The resultant blade design, chosen from a large set of potential blades within the constraints of the problem, demonstrates optimised design and manufacturing costs in addition to high structural performance characteristics.      ","authors":"Yadong Jiang, Edward Fagan, and Jamie Goggins","topic":"8","file":"1583-4755-2-DR-OK.pdf","bib":"STRMAT-1583.bib"},
{"paperid":"1585","title":"Metrics for wave energy converter hull geometry optimisation","keywords":"To find an economically competitive design of a Wave Energy Converter (WEC), device geometry has been optimised in previous studies not only for performance maximisation, but also for cost minimisation - with the cost usually represented by the device’s size. However, resulting shapes can be inadequate to survive in high energetic seas or not cost-effective to manufacture. Additionally, these studies were restricted to the analysis of devices with predefined shapes of variable dimensions or pre-specified modes of oscillation.   Some of these limitations were overcome by using a flexible geometry definition, as in McCabe [1], and by expanding the analysis to assess different factors related to the device’s geometry that can have an effect on costs. However, it has been found that the volume is not a good proxy for costs in the objective function of a geometry optimisation process. For this reason, a new parameter will be investigated in this study to find a more suitable metric for cost representation in the objective function. This will then affect the optimal device shape.   This study is performed for a point absorber with a single-objective optimisation approach, based on a frequency-domain hydrodynamic model, together with a genetic algorithm for geometry generation and selection, as used in [1]. In that previous study, each WEC geometry was defined by a set of variable control points and an initial population of WEC shapes was created by varying these points randomly. By means of algorithms defining selection and mutation processes, as they are known from evolution theory, geometries which best fulfil the defined requirements were used to create further generations of WECs. After a number of iterations (generations), it was hoped that the genetic algorithm would converge on an optimal WEC shape. The objective functions used in the optimisation method were the maximal power extraction, the ratio of maximal power extraction to the cube root of the displaced volume and the ratio of maximal power extraction to the displaced volume. However, as mentioned previously, resulting shapes were very complex; difficult to manufacture; and had large surface areas; and, thus, increased costs.   The aim of this study is therefore to substitute the cost proxies based on the device’s submerged volume with cost proxies based on its actual submerged surface area. This is expected to generate more realistic solutions, since structural costs will be directly related to the amount of material required, which is represented by the surface area and wall thickness of the device. These will be compared with results obtained using the objective functions of the original study with the aim of finding the most suitable representation of costs for this particular application.       [1]      A. P. McCabe, “Constrained optimization of the shape of a wave energy collector by genetic algorithm,”  Renew. Energy , vol. 51, pp. 274–284, Mar. 2013. ","authors":"Anna Garcia-Teruel, David I. M. Forehand, and Henry Jeffrey","topic":"5","file":"1585-4594-2-DR-OK.pdf","bib":"WAVHYD-1585.bib"},
{"paperid":"1586","title":"Numerical Benchmarking of selected Efficiency-Aware Reactive Control Strategies on the InfinityWEC Wave Energy Converter","keywords":"Wave energy research has shown that reactive control can achieve highest power capture from a wave energy converter (WEC). However, not accounting for the efficiency of the power take-off (PTO) leads to high reciprocating power flows between the WEC and PTO, causing increased losses and, thus, lower reduced export/output power from the system as an end result.  Therefore, an optimal balance between captured power and losses, if the controller is designed considering the losses in the drivetrain.    Main objective of this paper is to present a benchmarking study with three different efficiency-aware reactive control strategies using a nonlinear hydrodynamic model in heave of the InfinityWEC wave energy converter.   InfinityWEC, developed by Ocean Harvesting Technologies (OHT), is a novel single point pre-tensioned wave energy converter that utilizes an energy storage unit to provide detailed PTO force control, that includes the return power required for optimal performance and pre-tensioning, in combination with constant / time shifted output. The technology originates from the automotive industry, where it is referred to as a regenerative braking system, or Kinetic Energy Recovery System (KERS). The unique design of the InfinityWEC unlocks the capability of precise force control, thus allowing advanced phase control strategies to be used in a way that: 1) balances power capture vs. losses in the PTO system to maximize output power, 2) provides buoy motion control to prevent hard end-stops and improve reliability, and 3) limit PTO force, stroke-length, velocity and power, to reduce cost.   The control strategies under investigation are: linear reactive control (LRC), novel “polynomial” reactive control (PRC) and nonlinear model predictive control (NMPC). All three control strategies have the objective to maximize export power, while considering the losses and constraints of the system. LRC and PRC are passive control techniques, whose coefficients are optimally tuned for each sea state using an optimization algorithm. LRC is studied extensively in the wave power literature and serves as the reference case in the study. PRC is novel to authors knowledge and can be considered as a higher-order extension that gives extra degree of flexibility to LRC with the objective to improve performance and constraint handling capability. NMPC is an active control strategy, which optimizes the PTO force and buoy motion at each time instant by knowing the incoming wave a few seconds in advance.       Annual simulations are run with the three control strategies in a selected sea site and results are analyzed in terms of performance, load case and constraint handling capability.          Fig. 1 InfinityWEC wave energy converter.     ","authors":"Ahmed Rashid, and Mikael Sidenmark","topic":"7","file":"1586-5035-1-DR-OK.pdf","bib":"GRDPTO-1586.bib"},
{"paperid":"1587","title":"Hydrodynamic modelling of flexible tidal turbine blades","keywords":"Tidal streams are a promising energy source as they are a renewable and predictable energy resource. Deriving from experience in the wind industry, the majority tidal stream turbine designs to date are of the horizontal-axis turbine type (e.g. MCT SeaGen S, Hydro Hammerfest HS1000, Voith Hydro). Although these devices are conceptually similar to the rotors used to extract energy from the wind there are important differences in terms of the environmental and flow conditions that affect the loads experienced by the rotors. In particular, the higher fluid density and the effect of flow confinement due to the proximity of the seabed, sea surface, and potentially neighbouring turbines, may all lead to significant loading of tidal turbine blades.   During operation, a rotor may experience blade deformations large enough to influence its hydrodynamic behaviour. These deformations can be categorised into two main types: flapwise or out-of-plane deflections which are primarily caused by the thrust forces; and twist deformations that are caused by twisting moments developed along the blade span and result in a spanwise modification of the incidence angle. The magnitude of these deformations and their impact on the rotor performance is a consequence of the interaction between the hydrodynamic forces and structural response that arise under operational conditions.   This work analyses the influence of blade deformations on the hydrodynamics of a tidal turbine designed for blocked flow conditions by using a coupled hydroelastic model and also blade-resolved computational fluid dynamics (CFD) simulations.   The hydroelastic model is based on coupling Blade Element Momentum (BEM) theory with a shell-based finite element structural model. BEM theory is used to obtain the inflow angle and the inflow speed over a finite number of blade sections, which is then used to rebuild a three-dimensional pressure field over the blade surfaces using pre-calculated 2D CFD pressure coefficients. The pressure field is then interpolated over a static shell-based finite element structural model of the rotor in order to obtain blade deformations. The deformations are applied in the form of twist-angles to the BEM model in order to complete the coupled hydrodynamic model, which is solved iteratively. This coupled model at present neglects the influence of flapwise deformations along the blade, and work is ongoing to better understand the significance of these deformations.   A comparison is being made between the computationally efficient coupled hydroelastic model and high-fidelity CFD simulations of the deformed blades, in order to better understand the coupling between blade deformation and hydrodynamic performance and to assess the predictive accuracy of the coupled model. Deformed blade geometries, as predicted by the coupled model, for selected flow speeds and tip speed ratios are being simulated in ANSYS Fluent. Preliminary results indicate that the out-of-plane deformations may significantly influence the force distributions and the near-tip three-dimensional flow effects, and changes in the induction factors occur. This paper will present an analysis of the hydrodynamics of deformed tidal turbine blades and a comparison between the coupled hydroelastic model and CFD analysis.        ","authors":"Federico Zilic de Arcos, Christopher Vogel, Richard H. J. Willden","topic":"6","file":"1587-4645-3-DR-OK.pdf","bib":"TIDHYD-1587.bib"},
{"paperid":"1589","title":"Market, Investments and deployment scenarios for ocean energy in Europe","keywords":"Ocean energy is one of few untapped sources for renewable energy. Its potential in the EU is vast, thus it can play a key role in decarbonising energy supply and increasing energy security and fuelling economic growth in coastal regions. The European Commission is supporting the development of the ocean energy sector through the Energy Union, the SET-Plan, and the Blue Growth Strategy policy initiatives. The aim of these activities is to drive the development of ocean energy within the transformation of the European energy system and to exploit is potential to create growth and jobs in the EU.       In Europe, tidal and wave energy are those poised to provide the most significant contribution in the short-term., with about 71 MW of tidal and 37 MW of wave energy capacity expected to be deployed within the EU by 2020, and in the long term the sector aims to reach 100 GW of ocean energy capacity installed in European waters by 2050. Over 400 000 jobs could be generated if this industrial target is met.       Meeting the 2050 targets requires that ocean energy technologies reduce their cost considerably, which will help unlock investments in the sector to support the projected market growth. The SET-Plan Declaration of Intent has set out ambitious targets for the ocean energy industry, which indicate that the costs of generating electricity from the ocean need to be reduced by 75 % for tidal energy converters and 85% for wave energy converters by 2025.       In this paper, we assess the investments required for the ocean energy sector to meet the SET-Plan targets through an assessment of the potential deployment of wave and tidal energy in an energy-system model. We employ the JRC-EU-TIMES model we assess the deployment of ocean energy converters in the EU with current cost assumptions and under the assumption that SET-Plan cost-reductions are met.       The analysis takes into account the current cost-reduction achieved through the deployment of first-of-a-kind farms which are helping building investors' confidence and reducing the cost of borrowing capital, and the performance achieved by ocean energy converters during tests. By taking into consideration the current ratio of public/private funds required to ensure financial close of fist-of-a-kind ocean energy arrays, recommendations will be made to what type of effort will be required to support the sector in 2020, 2025 and 2030.       Initial results shows that the tidal energy could reach up to 6 GW of installed capacity by 2030, prompting significant investments (3 billion EUR/GW) in the sector, and the consequent job creation. The paper will then address short and long term ocean energy employment as a results of the creation of the ocean energy market in Europe.     ","authors":"Davide Magagna, Wouter Nijs and Pablo Ruiz Castello","topic":"10","file":"1589-4742-2-DR-OK.pdf","bib":"ECONOM-1589.bib"},
{"paperid":"1591","title":"Implementation of an energy extraction control including PTO-losses in a complete WEC model for PTO design procedure","keywords":"The knowledge of the efficiency of the PTO, or a model of PTO losses, is necessary when defining a power extraction control in a wave energy converter (WEC). In particular, the use of reactive mechanical power can increase the extracted mechanical power. However, when the reactive mechanical power is used, the control algorithm must take into account the losses of the PTO in order to avoid an excessive penalization of the electrical power generated by the WEC.   The manuscript will present the loss model of a PTO in the case of a linear electric generator type. The different sources of losses in an electric generator will be analyzed and modeled, such as: mechanical losses of the guidance bearings; losses in the magnetic circuit; losses in the electric circuit; and losses in the associated power electronics. This model will be presented in a parametric form in order to modify its rated force and velocity values. Modeling the PTO using a loss model is considered sufficiently precise to be included in a complete WEC model due to the electrical dynamics are faster than the mechanics.   In addition, a modified energy extraction control algorithm will be proposed according to the previously mentioned PTO losses model. It will be based on a control algorithm that considers the optimal control theory, but modifying the objective of the optimization from mechanical power generated to electric power.   Both the losses model and the modified control algorithm will be included in a complete model of a WEC (so called Wave to Wire model). The presented study case considers as prime mover a point absorber. The complete WEC model (point absorber + PTO + control strategy) will be developed in the time domain and implemented through a state space. Although the dynamic model of the prime mover will be particularized for a specific case study, another type of prime movers will be easily implementable.   This complete WEC dynamic model will be used in a methodology for the selection and optimization of the PTO (see Fig. 1). The purpose of this methodology is to analyze the impact of the values ??of the nominal PTO characteristics, both in extracted energy and in the PTO size. This methodology can be used as assessment tool for determining the best PTO characteristics for a particular prime mover in a particular sea location (with a specific ocean wave climate).   The development of the model and the methodology is part of the tasks proposed in the H2020 SEA-TITAN project.      Fig. 1. Scheme of the methodology to characterize a PTO under a specific prime mover and location.  ","authors":"Miguel Vicente, Marcos Blanco, Jorge Torres, Gustavo Navarro, Luis Garcia-Tabares, Marco Alves, and Marcos Lafoz","topic":"7","file":"1591-5022-1-DR-OK.pdf","bib":"GRDPTO-1591.bib"},
{"paperid":"1593","title":"Crosscutting open source technology applied to Wave Energy Converters","keywords":"Currently each original equipment manufacturer system has different requirements, and pursuing the development of bespoke components not only limits the utility of the end product but also multiplies the development costs. To break this practice an ongoing H2020 project aims to offer the developed of open source technology to promote update and accelerate innovation: SEA-TITAN.  Technology developers have felt compelled to create patents out of concern that the big energy companies would copy their technology and then use their massive manufacturing, sales and marketing power to overwhelm these technology developers. They couldn’t have been more wrong. The unfortunate reality is the opposite: wave energy programs at the major utilities or independent power producers are small to non-existent, constituting an average of far less than 0,1% of their total R&amp;D resources.  In the software industry, the success of open innovation strategies through open sourcing is widely known and acknowledged. The open source approach to create software innovations has become a vital alternative to in-house developments for many firms. In fact, in Open-source software (OSS) projects, the major innovations come from the users, the open source community.  SEA-TITAN will advance in business models based on “open hardware models” (new concept to be developed and implemented within SEA-TITAN Project) where methods and work environments from OSS are translated into hardware environments. By opening the innovation process to the open source community. Through this, firms can improve quality and applicability of their technologies. Moreover, the open source concept allows the developers to base their developments and contributions on an already existent basis of technology.  With SEA-TITAN network offering easy and free use of hardware the final users will take advantage of a standard and crosscutting technology.    ","authors":"Aleix Arenas, Francisco García, Nuno Filipe","topic":"3","file":"1593-4668-2-DR-OK.pdf","bib":"WAVDEV-1593.bib"},
{"paperid":"1594","title":"The design and construction of a prototype WASP - a novel wave measuring buoy","keywords":"In order to assess the viability of locations for proposed wave energy farms, and design optimal wave energy converters and wave farm layouts, wave farm developers will need knowledge of local wave regimes. Furthermore, with the increasing occurrence of extreme weather events, coupled with rising sea-levels as a results of climate change, local authorities will also require knowledge of wave regimes in order to design effective coastal protection measures. Wave conditions at a point may be measured using existing buoys. However, such devices are expensive. The work described in the proposed paper has been undertaken as part of an effort to develop a low-cost, wave-powering buoy to measure wave conditions to meet the needs of both developers and local authorities. A number of low-cost buoys may potentially be deployed at a location to measure the local wave climate both temporally and spatially. The proposed device, christened the Wave-Activated Sensor Power Buoy (WASP) will comprise a floating body with a centre moonpool. The relative motion of the water level in the moonpool to the buoy will pressurise and depressurise the air above the water column and be used to drive a bidirectional turbine in the manner of an oscillating water column, which will be used in conjunction with a generator to recharge an on-board battery pack. Once the WASP has been suitably calibrated, the wave spectrum may be estimated from measurements of the pressure of the air above the water column. Important statistical parameters relating to the sea-state, such as the significant wave height, zero-cross period etc. may then be estimated from the spectral moments of the wave spectrum. Mathematical techniques may be used to determine sea-sates from the time series of the air pressure. Such techniques include inverse transfer functions, neural networks and numerical estimators, each of which is currently the subject of further investigation, once the WASP has been calibrated. The concept has been investigated through tank testing of a 1:20 scale model. The initial full-scale prototype of the WASP will use a modified, off-the-shelf buoy, the Seagull navigation buoy manufactured by JFC Manufacturing Company Ltd., Ireland, and will be tested and calibrated at the SmartBAY   Marine and Renewable Energy test site off the West coast of Ireland. The purpose of the prototype is to investigate the use of the pressure time series to estimate sea-state parameters in the real world at full scale. The prototype will not be wave powered.       This paper describes the process of designing and constructing the prototype and focuses on the physical, electrical and electronic, communications and programming aspects of the prototype buoy. The rationale behind design decisions is explored. Pre-deployment testing of the prototype on land is described. A number of issues which arose during the on land testing, and the steps taken to overcome the issues, are discussed.    ","authors":"Robert Carolan,Brendan Walsh, Mark Boland, Thomas Dooley, Thomas Kelly","topic":"1","file":"1594-5010-1-DR-OK.pdf","bib":"WAVRES-1594.bib"},
{"paperid":"1596","title":"Power hardware-in-the-loop simulations of grid integration of a wave power park","keywords":"This paper describes experiments conducted at the Centre for Marine and Renewable Energy Ireland (MaREI) in Cork, Ireland. Integration of a single wave energy converter (WEC) and a wave power park consisting of three and ten WECs in a (micro-) grid is studied in real time using the hardware-in-the-loop (HIL) equipment.   An Opal-RT power HIL system allows advanced emulation of large grid models, including interaction with DC microgrids and effects of long transmission lines, as well as islanded microgrid models with loads, sources, transformers, transmission lines and batteries. The emulation can be implemented using software-based models, MATLAB/Simulink models and laboratory hardware. Particularly, interaction of renewable energy conversion systems with different grid models can be studied for different controls and algorithms to emulate the output power from a renewable energy converter. The MaREI facilities are equipped with the real-time simulator (RTS) Opal-RT OP5600, IGBT-based power converters made by Triphase NV, that can exchange powers between a battery bank, the main grid and the microgrid [1].   Two different ways to emulate a WEC and a wave power park were used. A single WEC is emulated using a squirrel cage induction generator (SCIG) run by a grid-powered motor. A hydrodynamic model of a point absorber with a permanent magnet synchronous generator is implemented in MATLAB/Simulink and used to emulate an irregular output power from a WEC to a grid model. The model is run for different sea states. Power fluctuations, ability to control the status of battery bank under various load conditions are investigated.   In the other case, single and several WECs are emulated using a Triphase power converter where the DC currents are injected at the DC-link of the converter. The currents time series for the DC-link injection are based on data obtained in offshore experiments conducted in April 2010 at the Lysekil research site, Sweden. One WEC operated in different sea states connected to different resistive loads, and the generator output voltages and currents were measured onshore. To emulate a wave power park, the experimental output currents from one WEC are replicated three and ten times, superimposed following different scenarios and rectified. The rectified currents are used as an input for the DC-link. Different scenarios of superimposing are considered covering the worst and the best case scenarios. The worst case scenario is the situation when the output from all WECs comes simultaneously resulting in large currents. The best case scenario is the situation when the output from all WECs comes at different time instances resulting in power smoothening and limited currents from the generator. Interaction with the main grid, microgrid, load bank, and batteries is studied.   Bibliography   [1] A. Monterrat, D. Murray, R. Christie, and J. Kelly, “Grid integration for marine renewable energy devices in a real time application,” in  the 12th European Wave and Tidal Energy Conference (EWTEC17), 27th Aug -1st Sept 2017, Cork, Ireland , 2017, pp. 1–7. ","authors":"Irina Temiz, Arvind Parwal, James Kelly, Tatiana Potapenko, Jennifer Leijon, Sara Anttila, Johannes Hjalmarsson, Laure Hebert, and Cecilia Boström","topic":"7","file":"1596-4570-3-DR-OK.pdf","bib":"GRDPTO-1596.bib"},
{"paperid":"1597","title":"Feasibility of magnetic continuously variable transmission concept within a tidal turbine power train","keywords":"Tidal stream turbine installations are rapidly developing within the renewable energy industry. The power train is an integral component of the tidal turbine. Reliability is among the most important aspects of a component of a tidal turbine. Wind turbines have indicated that there are issues with mechanical gear boxes and fully rated converters. Current tidal power trains have mechanical gears and fully rated converters. This paper proposes a new power train topology where the mechanical gear and fully rated converter are replaced with magnetic gearing and a partially rated converter improving reliability. This is achieved by a magnetic continuously variable transmission (CVT).This paper sets out the state of the art magnetic CVT technology. The CVTs are compared with the requirements for tidal turbine operation. The achievable torque density is high enough for a tidal turbine power train and the values for the gear ratio range are also consistent with those required. A number of additional challenges have been put forward. It was also shown that there is an interdependence between parameters for regulation of the power train, namely the electromagnetic torque and the gear ratio of the magnetic CVT.","authors":"Adam Harris, Ben McGilton, and Markus Mueller","topic":"7","file":"1597-5006-1-DR-OK.pdf","bib":"GRDPTO-1597.bib"},
{"paperid":"1598","title":"Economic optimisation of large scale tidal stream turbine arrays","keywords":"Tidal stream electricity generation represents a relatively new technology and industry, with the world's first demonstration arrays only recently being deployed. These arrays are small scale with only three turbines installed by Nova Innovation off the coast of Shetland and four turbines installed by Meygen in Pentland Firth. Further development of the industry and the deployment of large scale arrays consisting of perhaps hundreds of turbines will only occur if these arrays can be proven to be economically viable. There is therefore a need for numerical tools that can predict and maximise the yields of large scale arrays. This can be done through modelling the hydrodynamics and optimising the number of turbines in an array as well as the location of each turbine within the array. Such tools have been developed within Thetis, a finite element coastal hydrodynamics modelling software, which enables efficient gradient-based optimisation through an adjoint model. Studies so far have shown that optimising for power alone results in a design with an unrealistically high optimal number of turbines. Optimisation functionals that introduce a penalty for the costs of a device, such as a break even power, produce arrays with a higher average power per device. The present work explores the impact of this variation in functional.","authors":"Zoe L. Goss, Stephan C. Kramer, Alexandros Avdis, Colin J. Cotter, and Matthew D. Piggott","topic":"10","file":"1598-4752-2-DR-OK.pdf","bib":"ECONOM-1598.bib"},
{"paperid":"1599","title":"Characterization of mode I interlaminar properties of novel composites for tidal turbine blades ","keywords":"Tidal turbine blades are exposed to very high loads and are shorter than wind turbine blades requiring thicker composite sections making manufacturing a slow process. However, powder epoxy, which has a low viscosity and a low exothermic reaction, is suitable for rapid out-of-autoclave manufacturing of large composite structures such as turbine blades. In this paper, we describe a process that has been developed to manufacture powder epoxy based carbon and glass fibre reinforced plastic (CFRP and GFRP, respectively) laminates. Through thickness measurements, resin burn-off and microscope observations, the process was shown to be reliable and to produce consistent parts. The in-plane mechanical properties were measured through tensile testing and low scatter was observed in the GFRP coupons as compared to the CFRP coupons. Difficulties experienced in maintaining uniform alignment of the carbon fibre bundles explains the higher scatter obtained on the longitudinal tensile strength. The mode I interlaminar fracture toughness was obtained for the CFRP samples with a G IC  of 1.92 kJ/m 2 . It was found to be substantially higher than values reported in literature for carbon/epoxy prepreg systems, making it suitable for use in areas of a tidal turbine blades exposed to high stresses such as near ply drops where the risk of delamination is enhanced.    ","authors":"Christophe Floreani, Colin Robert, Parvez Alam, Peter Davies and Conchur M. ´O Bradaigh","topic":"8","file":"1599-4428-3-DR-OK.pdf","bib":"STRMAT-1599.bib"},
{"paperid":"1600","title":"On the calibration of a WEC-Sim model for heaving point absorbers","keywords":"The outcomes of reliability based design methods applied to WECs in the early stages of development depend heavily on the uncertainty in the variables used to determine the loads acting on, and responses of, devices. Free and open source software has been developed in recent years to aid in the response modelling of devices such as NEMOH, WEC-Sim and OpenFOAM. Uncertainty in the estimation of the viscous drag forces acting on a device has been identified as a key source of error in diffraction and radiation based hydrodynamic models. The question over the extent to which the calibration of such models can reduce modelling uncertainty and the consequences of reducing said uncertainty will be discussed in this paper.   This study uses physical model decay tests to try and quantify the viscous damping for Uppsala’s model WEC, a bottom referenced point absorber similar to the full scale Seabased device. The approach will be validated by applying the values obtained for the drag coefficients to the hydrodynamic model WEC-Sim which is then compared to physical model tank tests in regular waves. The results of the decay test are also compared to a basic CFD model which is developed as a calibration tool with the intention of using it to generate initial estimates of the viscous damping terms for subsequent devices.   The estimated drag coefficient will be compared to the extracted values from the experimental and CFD decay tests and input to the WEC-Sim model to determine the impact of the variability on the model outputs. The accuracy of the model compared to the physical test results will then be discussed.   There is scope for examining how generic estimates of coefficients based on the buoy geometry effect the variability in key design objectives of a device, such as the power output and the loads experienced, compared to values obtained through experiment and CFD. ","authors":"Tom Tosdevin, Marianna Giassi, Simon Thomas, Jens Engström, Martyn Hann, Jan Isberg, Malin Göteman, Edward Ransley, Pierre H. Musiedlak, David Simmonds, Deborah Greaves  ","topic":"5","file":"1600-4753-2-DR-OK.pdf","bib":"WAVHYD-1600.bib"},
{"paperid":"1607","title":"The Bryden Centre for Advanced Energy Research: building critical mass for marine and bio energy development in Northern Ireland, Ireland, and Scotland","keywords":"Named in honour of the late Professor Ian Bryden, the Bryden Centre is a new ‘virtual centre of competence’ designed to support industry-led applied/pre-commercial collaborative energy research that is focused marine renewable energy. Supported by the EU’s Interreg VA programme, managed by the Special EU Programmes Body (SEUPB), the Bryden Centre brings together partners from Western Scotland, Northern Ireland, and the Republic of Ireland. Using a Doctoral Training Centre model, the centre leverages existing R&amp;D infrastructure at five research institutes, working with ~40 companies to award over 30 PhD industrially relevant studentships and 6 PDRAs, producing applied research outcomes with the potential for commercial exploitation and resulting in economic growth within the region.   The west coasts of Ireland, Northern Ireland, and Scotland have many geographic, economic and demographic characteristics that combined represent a unique opportunity for the development of renewable technologies and should provide a distinctive competitive advantage in a global marketplace. These include the tidal power sites at Strangford and the North Antrim Coast, the offshore wind activity in Western Scotland, and the potential for wave power generation in Donegal and Lewis. However, a number of challenges have prevented regional industry from fully capitalising on this opportunity. Foremost among these is the profile of the regional industry, with companies typically being small- or micro-sized enterprises. As is true for all industries, small enterprises in the renewables sector struggle to dedicate the resource needed to innovate. This is exacerbated by a lack of funding for research and innovation that would allow industry and research partners from across the region to collaborate on early-stage innovative concepts. There is also a lack of critical mass of highly-qualified scientists and engineers capable of translating research into commercial success within these companies.  The Bryden Centre aims to address these challenges, building capacity and facilitating knowledge exchange across disciplines and across the region.   In this paper, we discuss these challenges specifically associated with wave and tidal energy, highlighting the state of the art for key research topics being progressed by Bryden Centre PhD researchers, including optimisation methods, operational device monitoring, energy storage, social licence to operate, and environmental impacts. We also discuss opportunities for information exchange and collaboration across the sector. ","authors":"Raeanne G. Miller, John Doran, Lilian Lieber, and others in the Bryden Centre","topic":"10","file":"1607-5033-1-DR-OK.pdf","bib":"ECONOM-1607.bib"},
{"paperid":"1609","title":"Power control strategies for a smoother power output from a wave power plant","keywords":"This paper presents power output and power control strategies for a wave power plant. Three cases are presented; active power output without power smoothing control, active power output with an energy storage to smooth the power output to the grid, active and reactive power control using the grid side inverter and an energy storage. The model is constructed in MATLAB Simulink and is based on the wave energy converter technology developed at Uppsala University. The model input is wave height data from the Wave Hub test site, UK. The study shows that without power control, the output power is fluctuating significantly during a 60 second time period. The difference between the average power output and the maximum power peaks can be as high as a factor of 6. A battery energy storage can significantly reduce the power fluctuations, approximately ± 10 % deviation from the average power output. Even with the high intermittency of the input power, it is possible to control the active and reactive power output to the grid. Thus, it is shown that it is possible to provide grid support functions, which are needed in the transition to a higher penetration of renewable energy sources on the grid.","authors":"Sara Anttila, Dalmo Cardoso da Silva Júnior, Irina Temiz, Janaína G. Oliveira, Jennifer Leijon,   Arvind Parwal and Cecilia Boström","topic":"7","file":"1609-4589-3-DR-OK.pdf","bib":"GRDPTO-1609.bib"},
{"paperid":"1612","title":"Simulation of a resonance-amplified floater oscillation in an open-type circular caisson","keywords":"In the present paper, we studied a new wave-energy harnessing system which houses the wave energy converter (WEC) inside an open circular caisson (or arc-shape caission). A floater connected to a power take-off (PTO) system is placed in the caisson. The open circular caisson serves to amplify the incident wave through the effect of harbour resonance. Then, the amplitude of heaving motion of the floater is significantly increased and, hence, the wave energy harnessed. In the present study, the arc caisson is of 300 degrees (or the opening of the caisson is 60 degrees). The PTO is modelled as a damping force which is applied to the floater.  The study was conducted computationally. The free open source CFD software OpenFOAM was employed for simulating the wave and floater motions inside the caisson. The incident wave approached the caisson with zero-degree angle of attack. The optimum wave amplification without the presence of floater and PTO was first addressed and the corresponding wave period determined. Then the effect of PTO damping and the motion of the floater were studied at the best incident wave found previously. The interaction of floater motion and wave was computed. The damping force was taken as a parameter and varied at different values. The damping significantly affects the motion of the floater and the pressure distibution acting on it. The optimal damping force will be determined at the present setup of caisson system. The amplification effects were also investigated in details. ","authors":"Yan-Xiang Lin, Da-Wei Chen, and Jiahn-Horng Chen","topic":"3","file":"1612-4574-2-DR-OK.pdf","bib":"WAVDEV-1612.bib"},
{"paperid":"1615","title":"Use of HF radar for replicating wave-current combined wave conditions for testing of wave energy converters","keywords":"Wave tank testing is a useful tool to assess the performance of Wave Energy Converters (WEC) in different technology readiness levels (TRL). At early TRL the use of systematically varying wave conditions is acceptable. However at later stages there is a need to use testing conditions representative of potential prototype deployment sites. Environmental data at these deployment sties can be collected by various instruments, such as buoys, ADCP, radars etc. The most commonly used method to re-create the measured environmental testing conditions in a wave tank is to represent a sea state using the measured significant wave height and peak period and a parametric wave spectrum such as the JONSWAP or Pierson-Moskowitz spectrum. Although a useful tool these parametric spectrum represent a simplification which omits a lot of the site specific spectral information, such as the directional information of the sea state, which have the potential to significantly impact WEC performance. In most wave tanks it is possible to directly reproduce a measured spectrum. However this raises questions about which measured cases to reproduce. Such an approach still also fails to account for the influence of current, which affects the dispersion relationship of the waves, as well as wave parameters such as the wavelength and wave steepness.       The use of HR radar data provides the opportunity to select sea-states for wave tank testing that are more representative of a potential deployment site. Current data and the directional wave spectrum can be obtained simultaneously by the superposition of the scanning areas of two HF radars. These wave-current combined complex conditions can then be reproduced in scale wave tank conditions.       It is necessary to develop a methodology to systematically select a set of representative experimental test cases from the combined wave-current datasets obtained from HF-Radar. Previous research has demonstrated the use of K-means clustering to obtain representative wave cases from measured wave spectrum. Here the expansion of this method to wave-current combined cases is demonstrated. The dependency of the clustering results on the wave and current parameters used for the clustering and the number of groups chosen to test are presented. Finally the influence of using this approach to select tests cases is assessed by comparing a WECs performance measured under these conditions and those measured using a traditional parametric wave spectrum approach. HF-Radar data obtained at Wave-Hub, a wave energy test site in Cornwall, UK, is used in this study.     ","authors":"Daming Wang, Daniel Conley, Martyn R. Hann, Keri M. Collins and Deborah Greaves","topic":"1","file":"1615-4610-2-DR-OK.pdf","bib":"WAVRES-1615.bib"},
{"paperid":"1617","title":"A novel system for monitoring biofouling and testing antifouling and anticorrosion coatings in marine renewable energy areas","keywords":"Corrosion","authors":"Andrew Want, Robert E. Harris, Caitlin R. Long, and Joanne S. Porter","topic":"9","file":"1617-4975-1-DR-OK.pdf","bib":"ENVIRO-1617.bib"},
{"paperid":"1618","title":"Modelling the wake of a tidal turbine with upstream turbulence: LBM-LES versus Navier-Stokes LES","keywords":"Tidal turbines are Marine Renewable Energy (MRE) devices that extract the kinetic energy from tidal currents. Most tidal turbines only work in areas where tidal currents are over  2.0 m.s -1  . These sites are characterized by high turbulence rates. For example, turbulence rate at EMEC site, Fall of Warness, is around 10% [5]. Turbulence acts on the machine in several ways [3]. It can affects the power coefficient [2] and the wake [4]. Like wind turbines, tidal turbines will be set up in farms in order to maximize energy extraction and reduce costs. A good knowledge of the wake of a single tidal turbine in a turbulent flow is therefore essential to optimize the layout of a farm.        In situ  field measurements and experimental data are expensive to acquire. Computational Fluid Dynamics (CFD) is an interesting way to predict turbines behaviour at moderate cost. To account for ambient turbulence, Large Eddy Simulation (LES) coupled with synthetic turbulence generation is reliable [1]. The study presented here uses LBM-LES and Navier-Stokes (NS) LES models to compute the wake of a tidal turbine. The Lattice Boltzmann Method (LBM) is an unsteady method rarely used for MRE studies. It is explicit and low dissipative and thus quite efficient to compute large volumes needed for wake studies.       The studied turbine is a scale model tested in Ifremer flume tank at Boulogne-sur-Mer. Wake data for upstream turbulence intensity of 3% and 15% are provided in Mycek  et al.  2014 [4]. Both cases are simulated with LBM-LES and NS-LES. LBM-LES model is blade resolved and uses a boundary layer model. LBM-LES simulations are compared with experimental results and blade resolved Navier-Stokes LES simulations.      <img src=data:image/png;base64,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","authors":"Mikael Grondeau, Jean-Charles Poirier, Sylvain Guillou, Yann Mear, Philippe Mercier, Emmanuel Poizot","topic":"6","file":"1618-4644-2-DR-OK.pdf","bib":"TIDHYD-1618.bib"},
{"paperid":"1620","title":"The prediction of high turbulence lift and drag characteristics for use with marine turbine modelling","keywords":"Analytical and computational tools such as Blade Element Momentum Theory (BEMT) and Blade Element (CFD BE-CFD) are useful in predicting the performance of horizontal axis tidal turbines. In the case of BE-CFD the downstream wake and interactions can also be predicted. However these tools rely on input data such as lift and drag. Thus it is important to use accurate data to be confident on the results of such tools. The lift and drag characteristics of a given foil section profile changes with differing flow conditions. This can in part be captured using Reynolds number interpretations of the flow conditions, and matching that with lift and drag data at the same conditions. However, differing levels of turbulence can also significantly effect the foil section performance, particularly in stall conditions. Traditionally experiments examining the lift and drag characteristics of foil sections are run with minimal turbulence effects, i.e. laminar flow. This produces idealised or optimal lift and drag profiles. These are not a good reflection of actual deployed or flume conditions with respect to horizontal axis tidal turbines, and there successful prediction. Using lift and drag data that does not correctly represent the target environment can negatively influence predictive tools which rely on such data. This work investigates these issues and looks for trends in the data using CFD to simulate this phenomena.  ","authors":"Matt Edmunds, Ross Gwenter, Alison J. Williams, and Ian Masters","topic":"6","file":"1620-5065-1-DR-OK.pdf","bib":"TIDHYD-1620.bib"},
{"paperid":"1625","title":"Multi-model analysis of tidal turbine reliability","keywords":"Generation of renewable electricity from tidal currents is a significant potential contribution to the future of the energy industry in Europe. The biggest obstacle to this technology becoming economically-viable is its cost of generation. One of the most significant contributors to these costs is the expense of operations at sea: for current-generation technology, operational costs are much higher than other renewable sources such as wind. Improving tidal energy converter (TEC) reliability, and therefore reducing the number of at-sea operations required for maintenance and repair, will be an important step in bringing costs down.     This paper describes a collaborative ‘multi-model’ investigation of TEC blade and structure reliability, uniting multiple testing methodologies (numerical, laboratory and at-sea) through a central reliability model. This central model is variation mode and effect analysis (VMEA), which systematically identifies and quantifies the factors contributing to load variability. By using VMEA to more accurately quantify technical risk, the investigation will enable more robust TECs with less conservative engineering safety factors.     The quantification of risk requires knowledge of both flow conditions and the resulting structural loads. The ideal for this is simultaneous measurement of flow conditions and loads on a real turbine, but neither is straightforward to measure. Acoustic Doppler current profilers (ADCPs) are commonly used to measure flow, and although powerful they rely on several simplifying assumptions to obtain measurements. Instrumentation for loads on TECs at real sites is somewhat simpler, but data from full-scale device is usually commercially sensitive and therefore not publicly available. The multi-model project reported here will use measurements from two full-scale TEC deployments, in French and UK waters.     To supplement full-scale TEC data, laboratory testing offers greater control over flow conditions, with the tradeoff of introducing scaling and boundary effects. Nonetheless, this is an invaluable technique for understanding the link between flow conditions and load variability, and thus provides useful data to the VMEA model. Lab-scale tests of the TEC deployments mentioned above have been carried out and are discussed in the paper.     Numerical modelling offers still greater control over flow conditions, enabling investigation of extreme events or fine-grained distinctions in turbulence that are not possible even with lab testing. However, care must be taken in validating models against empirical data, otherwise we can have no confidence in the numerical data for test cases that cannot be physically realised.     Reliability is not a purely technical problem but also an economic one. This paper therefore also considers how the findings from the different modelling approaches impact not just the reliability of the devices but also the cost of developing and operating them. A well-established model from wave energy devices is adapted for use in a tidal stream application.     The multi-model investigation of TEC reliability has been running since early 2018, and is foreseen to conclude by 2021. We present a summary of what has been achieved so far, and our expectations for how it will proceed in the coming years.   ","authors":"Michael Togneri, Elaine Buck, Alasdair MacLeod, Erwann Nicolas, José Nuño, Michael O’Connor, André Pacheco, Grégory Pinon and Ian Masters ","topic":"8","file":"1625-4987-1-DR-OK.pdf","bib":"STRMAT-1625.bib"},
{"paperid":"1628","title":"The WETFEET Project – A disruptive approach to wave energy","keywords":"The H2020 funded WETFEET project, which ran between May 2015 and April 2018, started from the identification and in-depth understanding of the main constraints that have been slowing down the development of wave energy to propose, study and develop a set of technology solutions to address these constraints. The following issues were identified as major obstacles to the desired success of wave energy: a) Reliability of technical components, particularly respecting to the PTO system; b) Survivability of overall system (moorings, geometry, operational philosophy); c) The long, complex and cost-intensive path towards a marketable product; d) The unclear path towards economic competitiveness, including uncertainty on support mechanisms; e) The unclear path towards industrial scalability, i.e. farms in the range of hundreds of MW. In view of their disruptive nature, the technology solutions that were proposed as a response to these issues were taken and classified in the scope of the project as ‘breakthrough features’. These breakthroughs were studied having as a reference two wave energy concepts, the OWC (Oscillating Water Column) and the Symphony, being developed by members of the consortium. The main avenues of research in the project were: 1) Survivability breakthrough via device submergence under storm conditions; 2) O&amp;M (operation and maintenance) breakthrough via continuous submergence and adaption of components and strategies; 3) PTO (power take-off) breakthrough via the development of new materials for submerged polymeric PTO and the analysis and development of innovative electro-mechanic solutions; 4) Array breakthrough via sharing of mooring and electrical connections between nearby devices, as well as integral approach to device interaction and compact aggregates; 5) Increased device performance via the practical implementation and functionality of a negative spring for an OWC. The paper summarizes the scope of the project and  the comprehensive methodological framework that was developed for the evaluation of the potential benefits of the breakthroughs, relying on the comparison with reference cases with no integration of breakthroughs. The main results (including numerical modelling and physical testing) and conclusions are presented. In general, the implementation of the breakthroughs revealed improvements in the LCOE (levelized cost of energy – the main metrics considered in the methodology). Shared moorings shown the most promising results, with LCOE reductions in the order of 20-25%. Although these breakthroughs were developed and tested in laboratory via the integration into specific WEC concepts (the OWC and the Symphony), they are expected to be of broad application to several other concepts. The new ideas that were launched by the project will ultimately contribute to improved and less varied WEC designs.","authors":"Josè Cândido, Antonio Sarmento, Fred E. Gardner, Luis M.C. Gato, Marco Fontana and Keri Collins, for the WETFEET Consortium","topic":"3","file":"1628-4954-2-DR-OK.pdf","bib":"WAVDEV-1628.bib"},
{"paperid":"1629","title":"Design of a horizontal axis marine current turbine with dedicated hydrofoil sections","keywords":"A reference turbine, based on work published by Bahaj et.al, is redesigned through the use of a lifting line (LL) routine developed at Instituto Superior Técnico, in Lisbon, Portugal. The turbine blades are composed of sections NACA 63-824, 63-821, 63-818, 63-815 and 63-812, from root to tip, respectively. These sections are studied interms of aerodynamic performance L/D and cavitation performance with the software XFOIL. The influence of the Ncrit factor on the foil performance for relevant Reynolds numbers is studied for the hydrofoil NACA 63-815 (see figure 1). This factor is the exponent in what is called the e^n method, and is a user-specified parameter in XFOIL. The value of this parameter depends on the ambientdisturbance level in which the foil operates, and mimics the effect of such disturbances on transition. It is concluded that value Ncrit = 4 is appropriate. Design conditions for the reference turbine match Bahaj’s specifications, with tip speed ratio TSR = 6 and ratedspeed U0 of 2 m/s. Power coefficient CP distribution vs TSR of the reference turbine in design conditions can be seen in figure 2. In figure 3, LL predictions of the reference turbine CP vs TSR distribution are shown for U0 = 1.73 m/s. Onthe same figure, LL predictions of the Bahaj model turbine6 and a curve fit to the experimental data of the Bahaj model turbine are shown. The LL routine analysis of the model turbine predicts a lower maximum CP of 0.439 (3.68% lower), which is predicted for a higher TSR of 7, than is obtained through experimentation, which measuresa maximum CP of 0.456 at a TSR of 6. It can also be observed that the LL routine predicts a higher CP of 0.483 for the reference turbine than for the Bahaj model turbine (CP is higher by 10%), at the same TSR. Subsequently, the reference turbine is redesigned, incorporating optimized hydrofoils IST-MT1-XX (see table 1and figure 5), using the same LL routine. The redesigned turbine displays a power coefficient of 0.486 at designconditions, TSR = 6 and U0 = 2 m/s (see figure 7). Comparing with the reference turbine at design conditions, an increase of 0.33% is verified and a reduction of chord size of up to 41% is achieved (see figures 6a and 7). The redesigned turbine also presents higher value of CP for higher values of TSR. Table 2 presents the chord, thickness,pitch, Reynolds number and chord reduction radial distributions at the design conditions of the designed turbinealong the blade span.                     ","authors":"Francisco Espenica, Ricardo B. Santos Pereira, João Baltazar and José A.C. Falcão de Campos","topic":"6","file":"1629-4730-3-DR-OK.pdf","bib":"TIDHYD-1629.bib"},
{"paperid":"1630","title":"Tidal resource and environmental effects of energy extraction in the Pentland Firth: sensitivity to array layouts and turbulence changes","keywords":"Keywords   tidal stream energy, hydrodynamic modelling, tidal stream turbine arrays, Pentland Firth.  Abstract   The Pentland Firth (UK) is a channel between Scotland’s mainland and the Orkney Islands which has high-speed currents. This high tidal stream resource has encouraged the development of a tidal stream energy sector in Scotland, motivated to develop commercial scale tidal farms. It is important to consider how such developments may affect physical processes in the region, and the layout of arrays could influence this.   Tidal dynamics in the Pentland Firth and Orkney Waters (PFOW) have been reproduced by a high spatial resolution, unstructured grid, three-dimensional FVCOM model implementation (O’Hara Murray &amp; Gallego, 2017). The tidal stream turbines were then represented in the model as sub grid scale objects by using two different parameterizations: (1) a momentum sink approach (O’Hara Murray &amp; Gallego, 2017); (2) a momentum sink approach plus changes in turbulence generation and dissipation (Li et al, 2018).   The practical resource available from the Pentland Firth, which includes feedbacks of the turbine realistic operations on the flow, has been estimated. In particular, this work explored how different tidal stream turbine arrays can interact in terms of both power resource availability and environmental effects. It has been found that different array layouts (location, number of turbines, spacing between turbines) can allow achieving very different amount of power resource, as well as degree of change to flow velocities. It has also been verified that turbulence changes can lead to an increase in bottom currents in the vicinity of the tidal turbines, which were not detectable using a simple momentum sink approach.  References   [1]         O’Hara Murray R., Gallego A., A modelling study of the tidal stream resource of the Pentland Firth, Scotland, Renewable Energy (2017), vol. 102, pp. 326-340;   [2]         Li X., Li M., McLelland S.J., Jordan L., Simmons S.M., Amoudry L.O., Ramirez-Mendoza R., Thorne P.D., Modelling tidal stream turbines in a three-dimensional wave-current fully coupled oceanographic model, Renewable Energy (2017), vol 114, pp. 297-307. ","authors":"Simone Zazzini, Michela De Dominicis, Giovanni Leuzzi, Rory O’Hara Murray, Xiaorong Li, Agnese Pini","topic":"2","file":"1630-5013-1-DR-OK.pdf","bib":"TIDRES-1630.bib"},
{"paperid":"1632","title":"Improving reliability of tidal turbines: a new step by step methodology for initial quantification of criticality and recommendations","keywords":"With the aim to understand and increase the reliability of tidal energy converters (TEC’s), the EU-funded RealTide project led by certification company Bureau Veritas is developing a new reliability methodology based on Failure Modes and Effect Analysis (FMEA) with inputs from a wide and diverse set of partners including marine energy project specialist Enerocean and tidal turbine developer Sabella. FMEA is a systematic and comprehensive analysis, the objective of which is to increase the reliability by recommending actions which will mitigate or eliminate critical failures.   The first step was to define the taxonomy of a generic tidal turbine, i.e., its decomposition into systems, assemblies and components. With the diversity of existing Tidal Turbines concepts and components, taxonomy was defined for 4 generic TEC’s to reflect as closely as possible future likely commercial designs: 1) Complex bottom fixed TEC ; 2) Simple bottom fixed; 3) Floating multi rotor; and 4) Cross flow turbine. The combination of these 4 concepts resulted in an overall taxonomy for a generic TEC.   Next, the FMEA methodology was redefined to obtain a Reliability analysis adapted for use on a “generic” Tidal Turbine. The challenge was to reach a methodology that allows an exhaustive analysis of Failure Modes, without going too much into details so as to keep the methodology applicable to a “generic“ tidal turbine concept.   The analysis was conducted on the 4 generic tidal concepts. Many traditional failure modes of components in offshore conditions are already referenced in databases such as OREDA (from the O&amp;G sector). In addition, tidal turbine power trains have similarities to wind turbines, so they share certain failure modes that have been identified and are known and documented for these. In RealTide, Failure Mode and Effects Analysis (FMEA) was performed to highlight  new  failure modes induced by the specific operating conditions of tidal turbines.   The analysis identifies types of means of mitigation to increase reliability of devices, leading to recommendations on the design and/or monitoring activities to be implemented on TEC’s.   The recommendations are selected based on the criticality of the mitigated failure mode in order to prioritize the recommendations with best chances of increasing reliability of the TEC, providing a method that suggest the best type of action to select from the potential set of options available, or even to start figuring out the type of solution to look for.   The FMEA analysis performed resulted in a total of 243 recommendations for the 4 concepts, where 137 are monitoring recommendations and 106 are redesign recommendations. The specificities of each design affect strongly the type and number of recommendations.   Perhaps surprisingly, the greatest number of recommendations resulted for the category (1) of bottom-fixed, pitching horizontal axis tidal turbines, which are in many sources considered the most mature class of TEC’s. The paper discusses the possible reasons behind this finding.       ","authors":"Pedro M. Mayorga, Vincent P. Le Diagon, Ana I. Mayorga, Ningxiang Li, Manunggal Sukendro, José M. Barranco, Mairi Dorward and Jan E. Hanssen","topic":"11","file":"1632-4501-2-DR-OK.pdf","bib":"OPANDM-1632.bib"},
{"paperid":"1633","title":"Progress update on the development and testing of an advanced power take-off for marine energy applications","keywords":"The Electro-Mechanical Generator (EMG) consists of a recirculating ball screw (Fig. 1) integrated with a rotational permanent magnet generator and is able to convert reciprocating linear motion, typical of many marine energy devices, into electricity (Fig. 2).  The EMG is based upon technology from mature industrial and aerospace sectors and is undergoing adaptation, development and testing for application to marine energy.  The proving of this technology has progressed through several projects for a range of mechanical and electrical configurations to reach TRL6/7.  The results of the hardware-in-the-loop and offshore tests being undertaken will describe the performance of the EMG including efficiency (Fig. 3), reliability, peak load ratios and other key metrics.  In addition, conceptual designs for integration of the EMG with different marine energy devices will be presented.  The results of the techno-economic modelling of the EMG for various scenarios will be presented in terms of levelised cost of energy and €/MWh.  This will draw upon up-to-date data from Wave Energy Scotland projects and the ongoing Horizon 2020 funded IMAGINE project. Italian manufacturer UMBRAGROUP leads the development of the EMG and is supported by a range of industrial and academic partners including the University of Edinburgh.  ","authors":"Simon Robertson, Donald R. Noble, Henry Jeffrey, Luca Castellini, and Michele Martini","topic":"7","file":"1633-4729-2-DR-OK.pdf","bib":"GRDPTO-1633.bib"},
{"paperid":"1635","title":"Improving tidal turbine efficiency using winglets","keywords":"Cost is a key issue for tidal power generation. Implementing design changes to reduce losses from the turbine blades would reduce the loading on the turbine for a given power output and increase the efficiency. Having lower loads reduces the need to reinforce the blades and support structure, leading to lower capital costs and thus cheaper power.   Sequeira (2013) showed that one third of avoidable hydrodynamic loss occurs near the blade tip, and so reducing tip loss could lead to substantial reductions in loading. One way of increasing power density, therefore, is to reduce the tip loss. This work discusses the effect of winglets on the tip losses of a tidal turbine and, as a result, the effect on device efficiency.   After preliminary design work using an inviscid code, a small-scale turbine with different tip geometries was tested at Ifremer. The datum case with a straight tip was compared with three sets of winglets: the first at 90 degrees from the pressure surface, the second at 90 degrees from the suction surface, and the third at 60 degrees from the pressure surface. The effect on the power generated is shown in Figure 1. The pressure surface (red line) and 60-degree winglets (green line) generate up to 20% more power than the datum case (black line) and suction surface winglets (blue line).   The effect of tip geometry on the flowfield downstream of the rotor is shown in Fig. 2. The plot shows axial velocity taken from phase-locked PIV 0.5 diameters downstream of the rotor plane, with the turbine operating at TSR 4. Figure 2 (a) shows the result with the suction surface winglet, while Fig 2 (b) is the flowfield downstream of the pressure surface winglet. The tip loss region is shown as a region of low velocity (dark blue), paired with a region of high velocity (bright yellow) just outside the rotor tips (black line). The mixing of these regions of non-uniform flow is a major source of loss, with larger region of non-uniform flow generating more loss. Comparing the sizes of the regions of non-uniformity in Fig. 2, it can be seen that the region is larger in the case of the suction surface winglets (Fig. 2(b)) than that of the pressure surface winglets (Fig. 2(a)), indicating that more loss is being generated by the suction surface winglets than the pressure surface winglets. This higher loss explains the lower power output of the suction surface winglets than the pressure surface winglets.   In the paper, the design process will be explained in more detail, and further insight into the development of the tip flow will be given from the phase-locked PIV.             Figure   1  : Performance curves for the turbine with different tip geometries.                          Figure 2: Contours of axial velocity 0.45 diameters downstream of the rotor plane with (a) pressure surface winglets, and, (b) suction surface winglets.  ","authors":"Anna M. Young, Amanda S. M. Smyth, Viraj Bajpai, Ruth F. Augarde, Judith R. Farman, and Carl L. Sequeira","topic":"4","file":"1635-4894-1-DR-OK.pdf","bib":"TIDDEV-1635.bib"},
{"paperid":"1638","title":"Design and optimization of hydrofoils tailored for marine current turbines","keywords":"The routine used for this work was conceived as a new airfoil design strategy, relying on the mathematical descriptionof the foil shape with CST parametrization and the NSGA-II multi-objective optimization algorithm to render optimal compromises between design goals. The genetic algorithm considers 100 foil candidates per generation and each simulation runs for 50 generations. The initial reference genetic pool is composed of 40-60 airfoils and hydrofoils. Two specific hydrofoil performance cost functions (CF) are defined as design goals: CF1 relates to hydrodynamic performance; CF2 refers to cavitationperformance. Increasing cavitation performance is defined as increasing the margin between the minimum cavitation number felt at a specific blade section r/R during rotation and the minimum pressure coefficient (-Cpmin)max, which corresponds to the minimum Cp value found within the range of operating angles of attack of the hydrofoil at the section during blade rotation.The performance of each candidate hydrofoil is obtained with free transition (no prescribed transition location - termed clean regime) and forced transition (trip located at x/c = 10% of the lower surface and 5% of the upper surface of the hydrofoil - termed rough regime) for angles of attack between -5 and 15 degrees, for a specified Reynolds number and Ncrit = 4. Maximum lift to drag ratio L/D and lift coefficient CL at the optimal (maximum L/D)angle of attack (AOA) are optimized for both flow regimes (free and forced transition). The final version of CF1 also directly compares the candidate hydrofoil performance with that of reference hydrofoils of series NACA 63-8XX and 66-8XX. Several versions of CF1 were tested and adapted according to the obtained results. The final version of this cost function, CF1 FIVE C, simulates the conditions experienced at different horizontal axis turbine (HAT) blade sections and pre-defined maximum thicknesses (t=c) of a reference turbine blades. Overall, for all sections and thicknesses tested, hydrofoils with higher cavitation margin display less camber and maximum thickness chord-wise location farther from the leading edge. For r/R = 75% (with turbine rotor radius of 10 meters) and maximum t/c = 15%, CF1 FIVE C yields the resultsin figures 1, 2 and 3. As can be seen on figure 3, the reference hydrofoils are outperformed. For the same cavitationmargin as the reference hydrofoil NACA 63-815, the optimized hydrofoil displays increases in maximum L=D and optimum CL of 66.10% and 20.98%, respectively, for the clean regime and an increase in optimum CL of 0.90% in rough regime. Overall, for all sections considered, increases in maximum L/D and optimum CL for both regimes are achieved, as well as cavitation margin of up to 3 relative to the local cavitation number.     ","authors":"Francisco Espenica, Ricardo B. Santos Pereira, Gael L. Oliveira Andrade, João Baltazar and José A.C. Falcão de Campos ","topic":"6","file":"1638-4731-3-DR-OK.pdf","bib":"TIDHYD-1638.bib"},
{"paperid":"1639","title":"Experimental and numerical analysis of GEMSTAR, a tethered tidal current energy harvester","keywords":"This work describes the patented tethered system GEMSTAR for the exploitation of tidal current energy. Tidal currents represent a valuable energy source, where available, mainly due to their repetitive and predictable behavior, which allows reliable production estimations. The GEMSTAR (  G  eneratore   E  lettrico   M  arino,   S  ustainable   T  ethered   A  dvanced   R  otors) is an innovative system developed over several years of applied research at the University of Naples in cooperation with SEAPOWER research consortium. It represents the evolution of the first prototype GEM, The Ocean Kite, developed since 2005 and tested in real condition in 2012. The GEMSTAR essentially comprises a submerged floating body with streamlined hydrodynamic shape, tailfins improving its static and dynamic stability, and two hydrokinetic turbines, symmetrically mounted on sides of the main body, acting as prime movers for two electrical generators.      Full-scale GEM prototype   The system is linked to the seabed by a flexible mooring cable, fixed at one end on an external anchoring point and at the other end to an attachment point on the floating structure; an actuated winch sets the length of the mooring cable, controlling the operating depth of the system and allowing its recovery from the submerged position for maintenance interventions with low O&amp;M costs. The mooring system also allows the self-alignment of GEMSTAR to the flow during current direction changes and its deployment even at sites characterized by high sea depth.  Differently from other similar technologies, GEMSTAR does not need to move in the water to produce power.  In the rest condition, it is positioned with an almost vertical mooring cable at a suitable depth under the water level; in presence of tidal currents, it reaches an equilibrium condition, with mooring cable making an angle less than 90 degrees respect to the seabed, due to the balance between buoyancy, system drag and turbines thrust.     Experimental results obtained on a scaled model in towing tank and on the full-scale first GEM prototype in real condition will be presented along with the comparison between shrouded and bare rotor performances. Furthermore, an innovative design of the second generation 300 kW GEMSTAR rotor blades will be presented and the choice of not using the previously developed shrouded rotor configuration will be discussed using cost/benefits analysis.    REFERENCES    [1]           D.P. Coiro et al., “Development, deployment and experimental test on the novel tethered system GEM for tidal current energy exploitation”,  Renewable Energy .  114 - A , 2017, pp. 323-336.   [2]           O. Igra, Research and development for shrouded wind turbines,  Energy Conversion and Management ,  21-1 , pp. 13-48, 1981.   [3]           G. J. van Bussel, The science of making more torque from wind: Diffuser experiments and theory revisited.,  Journal of Physics: Conference Series 75 , 2007, pp. 1-12.   [4]           E. Daniele, E. Ferrauto and D. P. Coiro, Horizontal Axis Hydroturbine Shroud Airfoil Optimization,  Advances in Evolutionary and Deterministic Methods for Design, Optimization and Control in Engineering and Sciences .  36 , 2014, pp. 241-256.   [5]           N. Mehmood., Z. Liang. and J. Khan., Harnessing Ocean Energy by Tidal Current Technologies,  Research Journal of Applied Sciences, Engineering and Technology .  4-18 , 2012, pp. 3476-3487.        ","authors":"Domenico P. Coiro, Giancarlo Troise, Nadia Bizzarrini and Guido Lazzerini","topic":"4","file":"1639-4865-2-DR-OK.pdf","bib":"TIDDEV-1639.bib"},
{"paperid":"1641","title":"Incorporating different tidal energy device designs into 4D collision risk simulations allowing increased flexibility for industry","keywords":"Development of the marine renewable energy industry has created a wide variety of device designs. One key issue in consenting these devices is the risk of animal collision with the infrastructure. Current efforts in addressing collision risk use formulaic modelling to calculate probabilities over the swept area of a tidal turbine. A variety of tidal energy devices are now being tested at sites such as European Marine Energy Centre, Orkney and Strangford Lough, Northern Ireland with each design presenting different issues in predicting collision risk. The 4D collision risk model is a simulation-based platform which, to date, has investigated a novel tidal energy kite, with a figure-of-eight trajectory, and its collision risk with an object. This early work demonstrated the effectiveness of this model to assess sensitivities to variations in the device configuration, with respect to collision probabilities. In a continuation of this work we simulate the collision risk probabilities of two tidal devices: the Minesto Deep Green tidal kite and a generic horizontal axis tidal turbine. The flexibility and ease in which this 4D model can be adapted to other device types as well as allowing variation in device configuration, gives the user the ability to quantify a wide range of scenarios which could therefore be of use to developers, consultants and regulators for project design and assessments. ","authors":"Nicholas Horne, Ross Culloch, Pal Schmitt and Louise Kregting ","topic":"9","file":"1641-4941-1-DR-OK.pdf","bib":"ENVIRO-1641.bib"},
{"paperid":"1643","title":"Influence of resource definition on defining a WEC optimal size","keywords":"The size (or scale) of a wave energy converter (WEC) for a given wave climate and a given market is a critical parameter whose choice impacts the energy production in many ways. This study expands on a previous series of publications, exploring the differences between the wave resource at different sites, and the associated WEC optimal size. In [1], new metrics were introduced to explore the consequences of a WEC scale, both in term of annual energy production and annual production imbalance. The main conclusions were that the optimum scale of a concept might probably evolve as the WEC maturity increases, mainly due changes in the annual production imbalance and impact of preventive and reactive maintenance. As the device reliability increases and the target markets shifts from off grid projects to large scale utility size farms, larger versions of a WEC concept should be favoured. All the work was carried out using occurrence table as a base for the resource description.   In the present work, the influence of the nature of the resource description on the conclusion of [1] are explored. To allow direct results comparison with [1], the same WEC concept (the sloped IPS buoy [2]) performance model is used. Spectral time series at two test sites, EMEC and Semrev, are used to recompute the previously introduced metrics, and compare them with the results obtained from the occurrence tables only. Seasonal variations in the production pattern are quantified instead of being only described qualitatively in the precedent publication. The effect of WEC scale on this imbalance is commented upon and analysed according to which markets are pursued.   Using spectral time series also allows to attempt modelling the effect of changing the ratio of preventive and reactive maintenance. The lost in annual production due to preventive maintenance during the summer months as a function of scale is estimated. The effect of reactive maintenance is modelled by randomly generating faults through the year. Multiple runs through the time series data allows an averaging of the downtime effect and the evaluation of its effect on the annual WEC production.   The present study therefore expands on the previously published work, establishes a method to scrutinize the consequences of a WEC scale upon key economic parameters and evaluates the pertinence of related metrics. The study lays the ground for future investigations linked to the RESOURCECODE project, where the effect of uncertainties in the resource spectral description are investigated.   [1]        R. C. R. Pascal, F. Gorintin, G. S. Payne, and V. Cliquet, “The right size for a WEC?: a study on the consequences of the most basic design choice .,” in  Proceedings of the 7th International Conference on Ocean Energy , 2018.   [2]        G. S. Payne, R. C. R. Pascal, and G. Vaillant, “On the concept of sloped motion for free-floating wave energy converters,”  Proc. R. Soc. A , vol. 417, no. 2182, 2015. ","authors":"Remy CR Pascal, Felix Gorintin, Gregory S. Payne, David Darbinyan, and Yves Perignon","topic":"3","file":"1643-4675-2-DR-OK.pdf","bib":"WAVDEV-1643.bib"},
{"paperid":"1646","title":"Surface hydrodynamics of the Alderney Race from HF radar measurements","keywords":"Sites with high tidal stream potential   are   often   characterised by   complex environment  s   where   the   interaction between numerous physical processes produces complex hydrodynamics.   C onsequently, an accurate quantification of the tidal stream energy requires, at the very least, an understanding of not only the current itself, but the wave field and the interactions between the two.  One of such sites is   the   Raz Blanchard (Alderney Race),   a strait   located   between the French coast and   the Channel Isl  and  s   that   constitutes   the   focus of the    HYD2M project (HYDrodynamics of Raz Blanchard: Measurements and Modelling). HYD2M is a research program designed to improve numerical results with the support of a comprehensive dataset collected at the site. In addition to traditional point measuring devices, a pair of HF radars has been installed on the adjacent coast to collect the first spatial measurements at the Raz Blanchard. The HF radar measurement scheme is a novel approach in which two frequencies, 13.5 MHz and 24.5 MHz, are alternated two times per hour. Since the penetration depth of the two frequencies is slightly different, this offers the possibility to observe the surface current measured at different effective depths close to the surface, as well as at different resolutions.           In areas like the Raz Blanchard, characterised by high topographic complexity and a tidal current that can reach speeds as high as 5 m/s, the deployment of in situ devices can be a daunting challenge, hence long term records are scarce. On the other hand, since they are deployed on the coast, HF radars are not directly subjected to the marine conditions in the same way in situ devices are, and can therefore help to overcome this problem. This feature along with the capability for providing a spatial snapshot of the surface current as well as the wave field over the area of interest, constitute the main interests of this technology for the HYD2M project. Nonetheless, given the extreme oceanographic conditions that can occur in the area, challenges to the technique still arise. All the aforementioned advantages and limitations are discussed in this contribution.            The performance of HF radar in measuring the highly energetic current of Raz Blanchard is examined, and the most representatives cases found in the yet short dataset available are interpreted. Additionally, time series of wave parameters and surface current velocities are compared against the measurements collected by a bottom-mounted ADCP deployed in the area. Over a tidal cycle, the bias between the radar and ADCP velocity estimates is 11 cm/s, while the absolute differences range between few mm/s to a maximum of 53 cm/s at the time of maximum current velocity. Similarly, the quality and extent of the wave results is seen to vary over the tidal cycle, showing the best results at and around slack tide. The reasons of the discrepancies are discussed, and the driving mechanisms of such differences examined.     ","authors":"Guiomar Lopez, Anne-Claire Bennis, Yves Barbin, Laurent Benoit, Remi Cambra, Daniel C. Conley, Louis Mari´e, Alexei Sentchev, and Lucy R. Wyatt","topic":"2","file":"1646-4751-2-DR-OK.pdf","bib":"TIDRES-1646.bib"},
{"paperid":"1647","title":"The performance of the Mocean M100 wave energy converter described through numerical and physical modelling","keywords":"Mocean Energy has designed a 100-kW hinged-raft wave energy converter (WEC), the M100, which has a novel geometry that reduces the cost of energy by improving the ratios of power per size and power per torque.   The performance of the M100 is shown through the outputs of frequency-domain and time-domain numerical models, which are compared with those from 1/20 th  scale wave-tank testing.   Results show that for the undamped, frequency-domain model, there are resonant peaks in the response at 6.6 and 9.6 s, corresponding to wavelengths that are 1.9 and 3.7 times longer than the machine. With the inclusion of power-take-off and viscous damping, the power response as a function of frequency shows a broad bandwidth and a hinge flex amplitude of 12-20 degrees per meter of wave amplitude.   Comparison between the time-domain model and physical data in a variety of sea states, up to a significant wave height of 4.5 m, show agreements within 10% for average power absorption, which is notable because only simple, nonlinear, numerical models were used.   The M100 geometry results in a broad-banded, large-amplitude response due to its asymmetric shape, which induces coupling between modes of motion.    ","authors":"J. Cameron McNatt, and Christopher H. Retzler","topic":"3","file":"1647-5016-1-DR-OK.pdf","bib":"WAVDEV-1647.bib"},
{"paperid":"1649","title":"Hardware in the loop test of a U?Oscillating Water Column converter coupled with a Dielectric Elastomer Generator","keywords":"This paper deals with hardware-in-the-loop (HIL) simulation of U-OWC wave energy converters coupled with dielectric elastomer generators (DEGs). The U-OWC is a special type of oscillating water column (OWC) with a U-shaped collector suitably designed to match the device natural frequency with target wave frequencies. DEGs are polymeric variable-capacitance transducers that enable direct conversion of mechanical work into electrical energy while rejecting rigid corrosion-sensitive components. The potential of coupled DEG/U-OWC systems has been preliminarily investigated theoretically and with small scale sea tests. In this work, HIL tests are designed which combine a fully-functional scaled DEG prototype with a hydrodynamic model of a U-OWC. These tests allow to test control strategies for the system and measure the performance in terms of generated electrical energy, while requiring a remarkably lower effort than wave tank or sea tests. In the paper, a scope of the experimental test-bench and the hydrodynamic model is presented, and procedures for the implementation of HIL tests are defined. ","authors":"Andrea Scialò, Giacomo Moretti, Giovanni Malara, Marco Fontana, Alessandra Romolo, Felice Arena ","topic":"3","file":"1649-4703-2-DR-OK.pdf","bib":"WAVDEV-1649.bib"},
{"paperid":"1650","title":"Lans-? and Leray turbulence models for coastal simulations: application to Alderney Race ","keywords":"Alderney race in France, represents one of the most promising exploitation site from the tidal stream industry. The particularity of this site is the presence of strong currents  reaching  to  5m/s. So the tidal energy estimate of this site requires the use of an accurate turbulence model. The main objectives of this work are to augment the coastal circulation model MARS (Lazure et Dumas, 2008), with the Lagrangian Averaged Navier–Stokes–alpha (LANS-?), and to study the turbulence structures in Alderney race, induced by the bathymetry variations. In comparison with standard dissipative turbulence models include in MARS (e.g. two equations eddy viscosity turbulence models), the main advantage of LANS-? is to produce more realistic eddy structures near the grid scale. Firstly, validation of our implementations is made within an idealized rectangular periodic domain forced by a sinusoidal wind stress and Coriolis parameter. This test shown the ability of LANS-? model to reproduce both horizontal and vertical kinetic energy and patterns obtained at higher-resolution simulations with MARS. Finally, the LANS-? is applied in the Alderney race with a fine realistic bathymetry and meteo-oceanic forcings. It appears that LANS-? produces higher kinetic and eddy kinetic energy more realistic than MARS with eddy viscosity model and allow to capture small turbulence structures induced by the bathymetry variations. ","authors":"Feddy Adong, and Anne-Claire Bennis","topic":"6","file":"1650-4538-3-DR-OK.pdf","bib":"TIDHYD-1650.bib"},
{"paperid":"1651","title":"“Far Field” effects of arrays of wave energy converters in irregular long–crested and short-crested waves: a comparative study","keywords":"Ocean waves are a vast resource of marine renewable energy that has the potential to contribute reducing the world’s dependency on fossil fuels. In the recent years, a large number of Wave Energy Converters (WECs) have been under development with none of them yet reaching commercial stage. Nonetheless, WECs will have to be deployed in large numbers with a closely spaced configuration, commonly  known in literature as WEC arrays, in order to be economically viable.   Due to the hydrodynamics interactions between the WECs of an array the surrounding wave field will be affected, both close to the WECs (“near field” effects) and in the coastal zone (“far field” effects).  Substantial research has been carried out to study the “near field” effects focusing on optimizing the array configuration to maximize power output using wave structure interaction solvers. Far field effects have also been studied using wave propagation models to identify the location of “hot spots” (increased wave height regions) and “wake areas” (reduced wave height regions) due to the presence of the WEC array. In the recent years, coupling methodologies between wave-structure interaction solvers and wave propagation models have been developed to combine the strength of both types of models and obtain a better understanding of the “near field” and “far field” effects [1,2] .   Typically, studies with those three numerical approaches (wave-structure interaction solvers to calculate the “near field” effects, wave structure interaction solvers to calculate the “far field” effects and coupling models to calculate both “near” and “far-field” effects) are carried out using unidirectional irregular long-crested waves. Nevertheless, real ocean waves are short crested waves and as pointed out in [4] the performance of WEC arrays changes in short-crested sea states. A change in the performance of the WEC array will then have an impact in the “far field” effects.   The objective of this paper is to compare the difference between the “far field” effects of 9 heaving point absorber WECs in unidirectional long-crested waves and short-crested waves using a recently developed coupling methodology [3] between the wave propagation model MILDwave and the wave-structure interaction solver NEMOH. The difference in the “far field” effects will be studied for the case of “swell waves” (narrow directional spreading) and “wind waves” (broad directional spreading) for different mean wave directions. A complete overview of the comparison of the “far field effects” for the different cases will be presented in the final paper.   1. Troch, P.; Stratigaki, V. Phase-Resolving Wave Propagation Array Models. In Numerical Modelling of Wave Energy Converters; Folley, M., Ed.; Elsevier, 2016; chapter 10, pp. 191–216.   2. Verao Fernandez, G.; Balitsky, P.; Stratigaki, V.; Troch, P. Coupling Methodology for Studying the Far Field Effects of Wave Energy Converter Arrays over a Varying Bathymetry. Energies  2018 , 11.   3. Göteman, M.; McNatt, C.; Giassi, M.; Engström, J.; Isberg, J. Arrays of Point-Absorbing Wave Energy Converters in Short-Crested IrregularWaves. Energies  2018 , 11.        Normal   0       21       false   false   false     NL-BE   X-NONE   X-NONE                         MicrosoftInternetExplorer4                                for the different cases will be presented  in the final paper.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ","authors":"Gael Verao Fernandez, Philip Balitsky, Panagiotis Vasarmidis, Nicolas Quartier, Vasiliki Stratigaki, and Peter Troch","topic":"5","file":"1651-4870-2-DR-OK.pdf","bib":"WAVHYD-1651.bib"},
{"paperid":"1653","title":"Unsteady loading prediction on tidal turbine blades using computational fluid dynamics","keywords":"As the global tidal stream energy moves closer to commercial viability, additional challenges are presented as developers strive to lower the levelised cost of energy in order to challenge the low cost associated with generating energy from fossil fuels. As a result, a greater insight into environment in which tidal turbine blades are deployed in is sought in order to advance the design of key components to achieve these economic and sustainability targets.   The tidal turbine blades convert the pneumatic energy of the tidal current to usable mechanical energy and, therefore, the fatigue effects from the tidal current on the blades are detrimental to their design life, if not properly accounted for. With a number of tidal turbines being recently shown to be reaching commercial viability, there has been an increased understanding of the various fatigue loading on tidal turbine blades. There are four main aspects that that have been identified by tidal turbine developers that contribute to fatigue loadings on tidal turbine blades:    Variation in vertical velocity profile of the tidal flow;  Shadow effects from the support structure;  Forces generated from surface waves; and  Turbulence in incoming tidal flow.    Numerical modelling offers a relatively inexpensive method of testing and validation of early designs, compared to physical models. Therefore, in this paper, a computational fluid dynamics model is presented, which can be used to determine the total fatigue loading on a tidal turbine blade. A discussion on previous work performed in this area and the methodology on implementing these fatigue loadings into the model has been detailed in the paper.   In order to demonstrate the performance of the model, a concept 1 MW tidal turbine is used and the analysis is performed using the commercial software ANSYS CFX. The accuracy of the model has been validated against a blade element momentum theory model for a steady flow case. A detailed discussion into the use of the model, with regard to the design and testing of the tidal turbine blades, has also been included. ","authors":"William Finnegan and Jamie Goggins","topic":"6","file":"1653-4726-2-DR-OK.pdf","bib":"TIDHYD-1653.bib"},
{"paperid":"1654","title":"Review of tidal turbine wake modelling methods—state of the art","keywords":"Enabling Future Arrays in Tidal (EnFAIT) is an EU Horizon 2020 flagship tidal energy project. It aims to demonstrate the development, operation and decommissioning of the world’s largest tidal array (six turbines), over a five-year period, to prove a cost reduction pathway for tidal energy and confirm that it can be cost competitive with other forms of renewable energy.   To determine the optimal site layout and spacing between turbines within a tidal array, it is essential to accurately characterise tidal turbine wakes and their effects. There are several vital aspects that must be considered. Firstly, the amount of energy extracted from the flow by a given turbine will have a critical influence on the energy available for extraction by other turbines downstream, this is typically the primary driver of array orientation and spacing. Secondly, the effect of ambient turbulence on wake length and turbulence intensity can have very serious implications for other turbines in an array, through for example cyclic loading. Finally, flow bypass affects can concentrate tidal flow in specific areas, making these locations attractive for siting other turbines if the effect of turbulence is not too detrimental to operations.   This paper presents a state of the art review of tidal turbine wake modelling methods, briefly detailing an overview of the relevant fundamental theories. Numerical and physical modelling research completed by both academia and industry are considered to provide an overview of the contemporary understanding in this area. The scalability of single device modelling techniques to an array situation is discussed, particularly with respect to wake interactions. Input data requirements and validation methods are also briefly considered for each of the various modelling approaches. Reference is made to the availability and reliability of such data given current state-of-the-art flow and turbine characterisation techniques.   The EnFAIT project provides the first ever opportunity to validate tidal array modelling techniques at full scale on a grid-connected array of six turbines, thereby confirming the optimal layout for commercial farms. The paper concludes with an outline of the most effective methods and theory combinations for the assessment of a tidal array as required for the EnFAIT research project. ","authors":"Ellen Jump, Alasdair Macleod and Tom Wills ","topic":"6","file":"1654-4658-4-DR-OK.pdf","bib":"TIDHYD-1654.bib"},
{"paperid":"1657","title":"Tidal resource, turbine wake and performance modelling on the EnFAIT project","keywords":"Enabling Future Arrays in Tidal (EnFAIT) is an EU Horizon 2020 flagship tidal energy project. It aims to demonstrate the development, operation and decommissioning of the world’s largest tidal array (six turbines), over a five-year period, to prove a cost reduction pathway for tidal energy and that it can be cost competitive with other forms of renewable energy.   The astronomical forces that produce the tide are highly predictable but estimating the energy that can be extracted from a tidal stream requires the consideration of multiple influencing factors such as seabed shape, local flow effects and array interactions. To design a tidal energy project, the impact of ambient turbulence and turbine wakes on power output and system loads must also be considered. This paper presents work by Nova Innovation and ORE Catapult to validate a model of the world’s first grid-connected tidal array.   The EnFAIT tidal array is being simulated by developing and combining three numerical models with field recorded data. By integrating three numerical models: a) A tidal energy resource model of Bluemull Sound, b) A tidal turbine wake and interaction model and c) a structural loads and performance model, the EnFAIT array is being simulated. These three models, at the heart of the array model, are built using coastal process modelling software, computational fluid dynamics (CFD) and Blade Element Momentum (BEM) codes. The disparate models are then brought together into an Array Interaction Modelling (AIM) tool.  In a world-first, the EnFAIT project provides an opportunity to validate this work at full scale, on a grid-connected array, with two rows of a total of six turbines spaced along and across the flow.   Presented in this paper is the work done toward developing an Array Interaction Modelling tool based on three separate codes. Also presented here is the full-scale field work being carried out to validate this model. ","authors":"Alasdair Macleod, Andrew Watson, David Quantrell, Sam Porteous and Tom Wills","topic":"4","file":"1657-5020-1-DR-OK.pdf","bib":"TIDDEV-1657.bib"},
{"paperid":"1658","title":"Wave energy resource classification system as characterization and assessment tool: Application to the US coast","keywords":"Energy resource classification systems are useful assessment tools, supporting energy planning and project development, e.g., siting and feasibility studies. They typically establish standard classes of power, a measure of the opportunity for energy resource capture. In this study, we develop wave energy resource classification systems based on wave power (J, kW/m) and its distribution with peak period (T p , s). These metrics are calculated from partitioned bulk wave parameters generated from a validated 30-year WaveWatch III model hindcast. As the operating resonant period bandwidth of a wave energy converter (WEC) technology is an important design characteristic, the dominant period band containing the largest energy content is identified. The classification systems, comprised of four power classes and three peak period band classes, are based on the total wave power or the partitioned wave power in the dominant peak period band. They provide useful information for a variety of stakeholders including energy planners, project developers, and technology designers. They also establish a framework for investigating the feasibility of a compatible wave climate (design load) conditions and WEC technology classification system to reduce design and manufacturing costs. Additional wave energy attributes, wave energy potential, frequency, directional and temporal variability, and relative risk ratio (extreme significant wave height with 50-year return period relative to the mean significant wave height, ) are identified as useful secondary descriptors for the quality of the wave energy resource.       The partitioned data is used to compute the total wave energy potential as an annual available energy (AAE) density, which is a theoretical annual energy production without considering energy conversion efficiencies. This AAE density is quantified by peak period, wave direction, month, and year to calculate the attributes of wave energy resource: spectral width, energy-weighted period, directionality coefficient, direction of maximum directionally resolved AAE density, long-term AAE density trend, inter-annual variability, and monthly variability. These attributes of the wave energy resource can be parameterized by simple indices of the variability, or constancy, of the resource, which can affect the capacity factor and annual energy production of a wave energy generation project. While the general wave power resource classification system is beneficial for siting studies and national or regional policy development, the more detailed secondary parameters provide support for project and device developers. As an example application for the United States coastal waters, computed marginal and joint energy distributions of the wave resources energy in terms of the peak period, wave direction and month and corresponding resource attributes are compared for different wave climate regions. The spatial variation of relative risk ratio in US coastal waters shows distinct trends among US wave climates with important implications for wave energy project planning and development. The case study includes the demonstration of the utility of the classification system as an assessment tool for a national or regional resource assessment as well as a tool for device developers by providing the characterization of the expected range of wave conditions under which they would need to develop devices to operate. ","authors":"Kevin A. Haas, Seongho Ahn, and Vincent S. Neary","topic":"1","file":"1658-4887-1-DR-OK.pdf","bib":"WAVRES-1658.bib"},
{"paperid":"1659","title":"Numerical and experimental test on a large scale model of a pivoting wave energy conversion system","keywords":"This paper presents the main results and on-going activities related to the development of an innovative system for converting mechanical energy from waves directly to electricity. It consists of a point pivoted body which oscillates in presence of waves. Linked to the buoyant body, a ball screw based electrical actuator/generator converts floating movements induced by waves into electrical power. The PTO is linked to the oscillating arms connecting a floating body to the pivoting hinge. In this way, buoy rotational motion is converted into linear movements at the absorber (see figure 1). The prime mover, represented by the pivoting buoy, has been developed by Seapower in cooperation with University of Naples, while the PTO system has been designed and manufactured by Umbra Group Spa: the two main components have been integrated with the aim to optimize the overall system behavior. It has to be noted, anyway, that other possible PTO solutions may be coupled with the same pivoting buoy concept.   In the present studies, a linear relationship between PTO oscillation velocity and PTO force has been assumed and such assumption affects the motion response of the whole system and consequently also the power production.   After an initial phase, mainly devoted to numerical analyses and system optimization, several series of experimental tests have been performed in different times. A scaled model (1:5), first, and, then, a full-scale model of the system have been built and tested in the wave tank facility of the University of Naples to verify and to fine-tune numerical simulations. In this paper, some of the results of the experimental test campaign performed on the full-scale model (figure 2) will be reported. System response, in both regular and irregular waves, has been tested in wave tank on the full-scale prototype. The prototype was equipped with the necessary instrumentation to estimate the wave-to-wire conversion efficiency of the whole system (figure 3) and comparison between experimental test and numerical prediction will be reported in the full paper.  A further development of the project involves the installation of a prototype in real sea environment which will happen before the end of 2018. The demonstrator will be deployed on a breakwater installed in a harbor area. Among other problems arisen in the development of the system, the issues related to breakwater wave reflection and to the behavior in extreme wave conditions have to be taken into account and will be highlighted in the paper. Some of the project related advancements will be addressed in the paper.      Figure 1: System schematic            Figure 2: Test system installed in wave tank              Figure 3: Global efficiency in function of regular wave frequency for different electrical loads.         REFERENCES   [1] J. Falnes, Ocean Waves and Oscillating Systems, Cambridge Univesity Press, 2002.   [2] M. McCormick, Ocean Wave Energy Conversion, Dover, 2007, 7e15, 90-101.   [3] D. P. Coiro, G. Troise, G. Calise, N. Bizzarrini, Wave energy conversion through a point pivoted absorber: Numerical and experimental tests on a scaled model, Renewable Energy, Volume 87, Part 1, 2016, ISSN 0960-1481. ","authors":"Domenico P. Coiro, Giancarlo Troise, Nadia Bizzarrini, Luca Castellini and Guido Lazzerini","topic":"3","file":"1659-4762-2-DR-OK.pdf","bib":"WAVDEV-1659.bib"},
{"paperid":"1664","title":"A set-based design approach for the design of high-performance wave energy converters","keywords":"The objective of this paper is to introduce an approach for designing wave energy converters (WECs) that can be implemented early during the conceptual design phase, enabling downstream convergence on higher performance concepts. Currently, WEC concepts span a wide design space which includes a high number of functionally dissimilar devices, including oscillating water column, overtopping, heaving, pitching and surging devices [1]. Concept-agnostic assessment of WEC techno-economic performance using the Technology Performance Level (TPL) metric [2] allows for these concepts to be assessed during the late stages of the design process; however, this assessment itself is not intended to be a design approach. As TPL assessment requires detailed designs, it cannot guide design engineers in concept generation and refinement. This leaves WEC designers with limited guidance in the early stages of the design process, often resulting in premature commitment to a single functional concept that can limit device performance, even if later-stage design optimization techniques are used.     This paper proposes a Set-Based Design approach to WEC design which can enable the generation of high-performance concepts faster and with less expense. Set-Based Design is a design process in which engineers ideate a large set of potential solutions and work with critical stakeholders to ensure convergence on an optimal concept [3]. The process was chosen specifically due to its ability to directly facilitate design decision making both within companies and potentially across the market. Once a concept is chosen and refined, it can be evaluated using the TPL assessment. A high score on the TPL assessment indicates high techno-economic performance of a concept and thereby success of the Set-Based Design approach. When WECs are designed and assessed using intentional, objective-specific methods, both the design and assessment processes can be improved.    [1] Khan N, Kalair A, Abas N, Haider A. Renewable and Sustainable Energy Reviews, vol. 72 (2017) pp. 590-604 Published by Elsevier Ltd    [2] Bull D, Costello R,  Babarit A, Nielsen K, Bittencourt Ferreira C, Kennedy B, Malins R, Dykes K, Roberts J, Weber J. Technology Performance Level Assessment Methodology Version 3.01 (April 2017). SANDIA REPORT SAND2017-4471   [3]    Sobek II, D. K., Ward, A. C., and Liker, J. K., 1999, “Toyota’ s Principles of Set-Based Concurrent Engineering Toyota ’ s Principles of Set-Based Concurrent Engineering,” Sloan Manage. Rev.,   40  (2), p. 67.  ","authors":"Ali M. Trueworthy, Bryony L. DuPont, Benjamin R. Maurer, and Robert J. Cavagnaro","topic":"3","file":"1664-5017-2-DR-OK.pdf","bib":"WAVDEV-1664.bib"},
{"paperid":"1666","title":"High resolution large eddy simulation for tidal site turbulence characterisation","keywords":"Tidal power extraction sites are characterized by turbulent flows [1]. Turbulence characteristics have to be better known to optimize power extraction and anticipate structural damages on tidal turbines. The impact of rapid bottom variations is not well understood, in particular in the Raz Blanchard tidal site. The aim of this work is to improve knowledge about these flows by using high accurate numerical simulations.   LBM (Lattice Boltzmann Method) is a fast growing computational fluid dynamics method for massively parallel simulations [2]. It is well adapted to local study of Alderney Race in association with Large Eddy Simulation (LES). It has been validated for simulation of turbulence on rough bottom test cases [3], and successfully compared to macro-roughness flume tank experiment held by Ikhennicheu et al.[4].  Simulations of a portion of the Alderney Race are held. First results are presented in Figure 1. They show good numerical stability despite a coarse mesh resolution. Further work will allow optimizing the simulation for more accuracy. The paper will present the final results of these simulations. Time series of fluid velocity and Reynolds tensor will be compared to ADCP measurements carried on in this area of the Raz Blanchard. This comparison will qualify the ability of the method to properly recreate the biggest turbulent motions generated by the sea bottom asperities.  <img src=data:image/png;base64,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","authors":"Philippe Mercier, Mikael Grondeau, Sylvain Guillou, Jerome Thiebot, and Emmanuel Poizot","topic":"2","file":"1666-4646-3-DR-OK.pdf","bib":"TIDRES-1666.bib"},
{"paperid":"1669","title":"Resource estimates in Lombok Straits, Indonesia","keywords":"Bali Island and Lombok Island are amongst the most famous tourist locations in Indonesia. The straits in this area have high-velocity tidal streams and are already being considered by major turbine manufacturers as potential sites for tidal stream turbines. Three islands (Nusa Penida, Nusa Lembongan and Nusa Ceningan) separate the Lombok straits into three straits: Nusa Penida, Toyopakeh Strait and Lombok Strait. All of these sites have the potential for tidal energy extraction.            Atlantis Resources Ltd. (Atlantis) and DCNS Energies, two United Kingdom-based energy development companies, have announced an agreement to develop tidal stream energy in Bali Strait and Lombok Strait. The total cost of this commercial array has been estimated at $750 million for 150 MW electricity. It is unclear whether this number is on peak or average of energy extraction. As announced by Atlantis, this project is supported by a 25-year power purchase agreement with the state-owned electricity company, Perusahaan Listrik Negara (PLN)[ 1].            Various authors have previously addressed the resource potential in Nusa Penida and Lombok Straits. For example,  [2]  investigated the potential tidal energy using Delft3D at eleven straits between inner Indonesian seas and the Indian Ocean, which included the Lombok, and Nusa Penida Straits. They concluded that the maximum kinetic power densities are 2.36 kW/m 2  at Bali Strait and 1.52 kW/m2 at Badung (Nusa Penida) Strait. However, there are three significant limitations to their approach. Firstly, the potential assessment was only based on power density instead of extracted power. Secondly, the simulation did not consider the effects of turbine array interaction with the flow. Finally, their model domain is not large enough to minimise the interaction of the turbine and the boundaries.           This paper aims to set up and validate a robust numerical modelling of tides in this region using ADCIRC. Methods of incorporating the Indonesian throughflow in the model and selecting input data are described in detail. This paper also aims to present a preliminary estimate of tidal resources in these three straits using linear momentum actuator disc theory incorporated in the ADCIRC model.           Following  [3] , the Discontinuous Galerkin version of the ADvance CIRCulation Model (DG-ADCIRC)  [4]  is used to solve the Shallow Water Equations (SWEs) to model the tidal hydrodynamics. Tidal turbines are modelled using actuator disc theory [ 5,6]  and included in the model as line discontinuities at element boundaries. Using several values of wake factor and blockage ratio, we estimate the resources that could be harvested by certain configurations of turbine arrays. By comparing different array configurations, the interactions between deployments in the various straits are analysed.           Three sites have potential resources around Bali Island (Fig 1).  This paper will estimates the resources in each site the Nusa Penida (A), Toyopakeh (B) and Lombok (C) Straits, and examining possible interactions between the resources.  ","authors":"Ahmad M. Firdaus, Guy T. Houlsby, Thomas A.A. Adcock","topic":"2","file":"1669-4990-1-DR-OK.pdf","bib":"TIDRES-1669.bib"},
{"paperid":"1672","title":"Numerical modelling of a point?absorbing WEC model using DualSPHysics coupled with a multiphysics library","keywords":"The novel method called Smoothed Particle Hydrodynamics (SPH) is here proposed to simulate floating WEC devices. SPH describes a fluid by replacing its continuum properties with locally smoothed quantities at discrete Lagrangian locations named particles. Each of these particles is a nodal point for which physical quantities are computed as an interpolation of the values of the neighbouring particles solving the Navier-Stokes equations. Hence, the domain can be multiply-connected with no special treatment of the free surface, making it ideal for examining complicated flow situations. Therefore, the major advantage of SPH comparing with mesh-based methods for wave-structure interactions is that the highly nonlinear behaviour of the interface motion can be implicitly captured with a sharp interface and floating objects and external forces are easily handled.   DualSPHysics [1] is an open-source SPH based code developed for real engineering problems, recently coupled with Project Chrono. This library is developed as a general-purpose simulation package for multi-body problems with support for very large systems. The library is implemented under the DualSPHysics code, providing an integrated interface to define and run arbitrarily defined fluid–structure–structure coupled systems under the same framework. The DualSPHysics-Chrono coupled model was already validated [2] for fluid–structure–structure interaction cases and it is here applied to simulate a wave energy converter (WEC).   The model-scale WEC was designed and testing in the US Navy’s Maneuvering And Sea Keeping (MASK) basin. The WEC displaces 858 kg and is independently actuated in heave, surge, and pitch (all the degrees of freedom in a single plane). Tests have been conducted for the investigation of control to improve power generation and load reduction and to study system identification (SID) and model validation. Tests include monochromatic waves, idealized ocean spectra, and multi-sine waves designed for SID. Large waves, resulting in overtopping and slamming were included in the tests.   The figure shows the CAD model of the point absorber devices tested in MASK basin [3].     Therefore, DualSPHysics-Chrono coupled model will be employed to simulate not only the interaction of waves with the floating device, but also the internal mechanical constraints and could eventually be used to model the full PTO system, a challenging task for most CFD software.   Finally, the aim of this work is to validate the numerical model in order to propose it as a design tool to improve the efficiency and survivability of this floating WEC.       REFERENCES   [1] Crespo AJC, Domínguez JM, Rogers BD, Gómez-Gesteira M, Longshaw S, Canelas R, Vacondio R, Barreiro A, García-Feal O. 2015. DualSPHysics: open-source parallel CFD solver on Smoothed Particle Hydrodynamics (SPH). Computer Physics Communications, 187: 204-216.   [2] Canelas RBC, Crespo AJC, Brito M, Domínguez JM, García-Feal O. 2018. Extending DualSPHysics with a Differential Variational Inequality: modeling fluid-mechanism interaction. Applied Ocean Research, 76: 88-97.   [3] Coe RG, Bacelli G, Spencer SJ, Cho H. 2018. Initial results from wave tank test of closed-loop WEC control. Sandia National Laboratories, report SAND2018-1258.       ","authors":"Bonaventura Tagliafierro, Alejandro J. C. Crespo, José M. Domínguez, Orlando García?Feal, Moncho  Gómez?Gesteira, Ricardo B. Canelas, Ryan G. Coe, Giorgio Bacelli, Hancheol Cho, Steve J. Spencer,  Giacomo Viccione","topic":"5","file":"1672-4758-2-DR-OK.pdf","bib":"WAVHYD-1672.bib"},
{"paperid":"1674","title":"Advancing IEC standardization and certification for tidal energy converters","keywords":"Conformity assessment can mitigate technical and financial  risks of the technologies in terms of performance and structural integrity.  Which in turn attracts finance and encourages international trade . In Marine Energy, a s an emerging industry International Standards are yet to be published and consistently adopted. A conformity assessment system is still under development . The implementation of international standards and certification schemes de-risks the technology providing a good level of confidence to insurers, investors and licensing authorities.  This is one of the main recommendations from the Ocean Energy Forum Strategic Roadmap [1].   MET-CERTIFIED, an Interreg 2 Seas funded project [2], stands for Marine Energy Technologies (MET)–Certified. The aim is to accelerate the development of standards and certification schemes for marine energy technologies under the umbrella of the IEC [3].   The project enables the application of International Electrotechnical Commission (IEC) technical specifications 62600 for marine energy convertors to pilot projects and tank testing. The Technical Specifications are currently under development or revision. To date experimental campaigns and three of the pilot projects have been completed. The pilot project includes the Eastern Scheldt Tidal Power plant, the Texel Floating Platform installed at EMEC and the SME Plat-I installed in Connel near Oban.   The benefits are twofold. Firstly, the developer’s device is assessed to the technical specifications. Secondly feedback on the practicality is provided to the IEC Technical Committee 114 so that it can be utilised in the next edition to aid progression to International Standards.   It is the objective of this paper to present the learnings to date in the MET-CERTIFIED project, including:   -        how test facilities can provide services under the new certification system   -        how we interacted with finance and insurance community on the role of certification in financing commercial projects   -        results and recommendations from test and experiments to date   -        recommendations and developments in conformity assessment.   The Technical Specifications applied and recommendation for changes will be discussed, covering the IEC 62600 -2 for design Requirements, -10 for moorings, -30 for electrical power quality, -40 for acoustics, -200 for tidal power performance assessment, -201 for tidal resource assessment and -202 for scale testing.   The project is funded by Interreg 2 Seas, the Dutch ministry of Economic Affairs, the Provinces of South Holland, North Holland &amp; West-Flanders. ","authors":"Peter Scheijgrond , Anna Southall, Claudio Bittencourt, Peter Davies, Pieter Mathys, Grégory Germain, Martijn Geertzen & al.","topic":"4","file":"1674-5068-1-DR-OK.pdf","bib":"TIDDEV-1674.bib"},
{"paperid":"1680","title":"Characterization of in-stream tidal energy resources in the Gulf of California: implementation, calibration and validation of a hydrodynamic model.","keywords":"The Gulf of California (GoC) is a marginal sea located northwest of the Mexican coast, it’s about 180 km wide and 1100 km long, approximately, with a maximum depth of 3600 m at the mouth. Many studies (both numerical and experimental) have described different oceanographic features of the Gulf, such as trapped coastal waves, coastal upwelling, current and gyre dynamics and tidal mixing, to name but a few. However, so far very few studies have characterized tides in the GoC as a form of renewable energy resource. We present three different models where tides are generated by co-oscillation of the Gulf with the Pacific Ocean, with the aim of evaluating the regional and local tidal steam energy: GC_200m is a 3D, curvilinear grid model with a 200m mesh where the resolution is finest. GC_6480m is a 2D model with 6480m of resolution. GC_MD is a multi-domain model of variable resolution, with a mesh of 6480m at the entrance (deepest region), a mesh of 2160m in the coastal regions and the north part of the Gulf, and a fine resolution of 240m covering two bays located northeast of the Gulf. One of the bays is San Jorge Bay, where an Acoustic Doppler Current Profiler (ADCP) was installed in June 2017 to measure the flow velocity and validate the models, through model-data intercomparison. The statistical analysis shows a better correlation with the refinement of the models. We also found a decrease in the error through calibration of the model parameters, specifically, the friction coefficient. We run the model for a year, to generate maps of some tidal energy resource indicators, such as the annual mean spring tide maximum speeds, the yearly-averaged Tidal Power Density (TDP), or the Annual Energy Production (AEP). We found maximum values in areas where strong tidal mixing has already been described, such as the Midriff Islands and the channels that form between them and the continent, and the northern region of the Gulf, including San Jorge Bay and the bay next to it, Adahír Bay. These results give us a first characterization of the tidal stream energy resource in the Gulf of California and highlight some areas with more potential for tidal energy exploitation. ","authors":"Anahí Bermúdez-Romero, Vanesa Magar, Markus S. Gross, Victor M. Godínez, Manuel López, Erick Rivera-Lemus","topic":"2","file":"1680-5012-1-DR-OK.pdf","bib":"TIDRES-1680.bib"},
{"paperid":"1681","title":"Mapping review on recurrent modeling techniques applied to Ocean Wave Energy Point Absorbers in the Canary Islands","keywords":"Point Absorbers (PA) are found in principle nearly everywhere in engineering science. They can therefore be considered relevant ocean wave energy (OWE) identities. While clearly lacking industrial maturity and a current focus by means of determining prevailing efficient operating principles, latter field encompasses significantly increasing studies ever since the oil crisis. Emerging renewable concepts such as the upper one will play a major role in the energy mix as compared to offshore wind. Main advantages are its short-term predictability and higher energy density.  This paper proposes point absorbers as relatively adaptive, flexible, low cost, combinable, performant, resonant, robust and simple systems with respect to other remarkably more complex and less efficient concepts. Carried out in plurality, patterns develop into interactions, which enable the escalation of the technology. From the mathematical to the physical model relating input waves towards electricity generation, hydrodynamics stand as intermediate medium, evolving into efficient &amp; precise description of the fluid-structure interaction given. Hereby, the search for an ideal resonator is beneficial in order to find suitable geometries and operating principles for the floats. Software tools, gathered during the research, can find a broad application in fluid methods such as Boundary Element Method (BEM), Computer Fluid Dynamic (CFD) and Smooth Particle Hydrodynamic (SPH), for instance.  Point absorber research is employing key-modelling techniques, such as advanced algorithms, as well as high-performing computational techniques, outlined in this study. This produces a remarkable result: PA is a more condensed and empowering technology than Line absorbers (about nearly 4x the power per weight). Although the efficiency, addressed as capture width, is restricted as compared to Line Absorber (LA) devices. PA´s reveal themselves as feasible enough to be installed instead due to its Levelized Cost of Energy (LCOE). While resonance is determinant, it is de facto easier to tune the float to real waves, the smaller and simpler the geometry is. Examples reflect here, that it is a highly adaptive, e.g. combining Power-Take-Off mechanisms, or fitting alone its relative position, both in depth &amp; on surface.  For the heave mode, one can conclude that PA technology is by far the most promiscuous and researched OWE subject in the recent past (2011-2018). Furthermore, it is also the most underrated sector with respect to the volume of commercially deployed units. Finally, hybrid combinations of electro, hydraulic and mechanic PTO equipment, and control strategies on its top are determining assets for the right integration on the marine environment.  Far from promising, it is for certain that the technology will become real and valuable soon enough, even though it is restricted to coastal areas near &amp; offshore insular applications, such as the Canary Islands (Spain). Multidisciplinary concepts, fundamental for marine devices towards desalination, electricity generation and storage, artificial space generation, structural protection, transport, reinforcement of the ecosystem and concentration of flora and fauna around are optimal arguments to succeed. ","authors":"Lorenzo Banos Hernandez, Alexis Lozano Medina","topic":"5","file":"1681-5029-1-DR-OK.pdf","bib":"WAVHYD-1681.bib"},
{"paperid":"1682","title":"Development of WEC design loads: A comparison of numerical and experimental approaches","keywords":"The development of accurate design loads is critical for the design of wave energy converters (WECs) as this ultimately has a direct impact on the cost of energy. In this case study, we examine extreme wave loading on the Triton WEC, a 1-MW-rated two-body point absorber under development by Oscilla Power, Inc. (OPI). The device is composed of two bodies, a 30 m long surface float and a submerged reaction ring structure, coupled together by three flexible tendons. Here, we are interested in the maximum design loads for the tendons and moorings during a hypothetical Triton deployment off the US west coast.   In this study, we evaluate extreme wave loading on the Triton WEC using a combination of mid-fidelity and high-fidelity numerical modeling tools, complemented by scaled physical model tests. The mid-fidelity approach used is a time-domain model based on linearized potential flow hydrodynamics while the high-fidelity modeling tool is an unsteady RANS CFD model. A 1:30 scale physical model of the Triton WEC was constructed and tested at the Oregon State University Large Wave Flume.   The development of accurate design loads requires the consideration of important trade-offs including accuracy of the hydrodynamics, accuracy of the extreme wave forcing, and efficiency (speed) of the simulation or experiment. For example, the mid-fidelity model developed in this study can be efficiently run in irregular seas to achieve statistical convergence of the desired design load. Due to the impractically long computational times required for a similar convergence in CFD, two simplified design-wave approaches were evaluated: monochromatic waves and focused (most likely extreme response) waves [1,2]. These simplified design wave approaches aim to capture the extreme response of the WEC within a feasible amount of computational effort. Here, we will examine the accuracy and trade-offs of using a high-fidelity nonlinear hydrodynamics model with simplified wave forcing (CFD) versus using a linearized hydrodynamics model with fully-converged device statistics in a long-duration irregular sea (mid-fidelity model).   To complement the numerical efforts, physical model tank tests were conducted using long-duration irregular wave tests as well as recreations of the monochromatic wave and focused wave tests examined in CFD. A comparison will be presented between the design loads predicted by the mid-fidelity model, the CFD model, and the physical model tests, and an analysis of best practices will be offered.             [1] Coe RG, Yu YH, van Rij J (2018) A survey of WEC reliability, survival and design practices. Energies 11 (1):4   [2] Quon E, Platt A, Yu YH, Lawson M (2016) Application of most likely extreme response method for wave energy converters. In: 35 th  International Conference on Ocean, Offshore and Arctic Engineering (OMAE), ASME ","authors":"Brian J. Rosenberg, Tim R. Mundon, Ryan G. Coe, Eliot W. Quon, Chris C. Chartrand, Yi-Hsiang Yu, and Jennifer van Rij","topic":"5","file":"1682-4997-1-DR-OK.pdf","bib":"WAVHYD-1682.bib"},
{"paperid":"1683","title":"Numerical modelling of the impact of hydrokinetic turbine on the morphology of the near sandy bed","keywords":"The need of sustainable, predictable energy generation has led in recent years to the development of hydrokinetic Turbines (HKT) and has become a near reality, to reach 20% from the total energy production in France on 2020. Determining the impact of HKT on their environment is becoming a significant interest nowadays. Regional modeling with a representation of the turbines’ array with bed friction or momentum sink approach were proposed to quantify the impacts far away from the turbines. Sanchez and al. 2014, have studied the flow changes around a farm of stream turbines operated in Ria de Ortigueira. They concluded that the flow modifications were concentrated at local scale. Hill et al. 2015, utilized multi-scale physical experiments to study the interactions between axial-flow hydrokinetic turbines and sediment transport (local and far-field impacts). The results show that the flow accelerates between the tip of rotor bottom and the erodible surface in the presence of rotor, thereby increasing the scouring capabilities.   The present contribution investigates further numerically the preliminary insights into the interaction between multiple HKT and the surrounding sediment environment.   The transport of sediments is modeled by 3D multiphase Euler-Euler modelling using the open source CFD software package OpenFOAM (Field Operation And Manipulation), the turbine is added as volumetric source using Actuator Disk and Blade Element Momentum Theories. After validating these models, the figure below shows an applied case of the impact of riverine turbine on a sandy bed. The presence of turbine increases the local shear stress directly downstream of its location and greatly enhances scour below the turbine and deposition downstream.   In terms of perspectives, the upcoming work is dedicated to investigate the influence of turbine configuration, and other physical parameters.     Keywords:   Hydrokinetic Turbines, environmental impact, mobile sediment bed, numerical simulations, Euler-Euler Two-phase modelling, OpenFOAM         References:     M. Sánchez, R. Carballo, V. Ramos, G. Iglesias, Tidal stream energy impact on the transient and residual flow in an estuary: A 3D analysis   Craig Steven Hill, Interactions between Channel Topography and Hydrokinetic Turbines: Sediment Transport, Turbine Performance, and Wake Characteristics   Shives, Michael &amp; Crawford, Curran, 2016.Adapted two-equation turbulence closures for actuator disk RANS simulations of wind &amp; tidal turbine wakes   Zhen Cheng, Tian-Jian Hsu, Joseph Calantoni, SedFoam: A multi-dimensional Eulerian two-phase model for sediment transport and its application to momentary bed failure.       Paul Mycek, Benoît Gaurier, Grégory Germain, Grégory Pinon, Elie Rivoalen,Experimental study of the turbulence intensity effects on marine current turbines behaviour. Part I: One single turbine   Pham Van Bang, D., Lefrançois, E., Sergent, P., Bertrand, F. (2008). MRI experimental and ?nite elements modelling of the sedimentation–consolidation of mud.      Representation of the bathymetry of the bottom, contouring of volume fraction of sediments (0.58)  ","authors":"Fatima Khaled, Sylvain Guillou, Yann Méar and Ferhat Hadri ","topic":"9","file":"1683-4920-1-DR-OK.pdf","bib":"ENVIRO-1683.bib"},
{"paperid":"1684","title":"The design and build of a 75 kW linear C-Gen generator prototype for  wave eenergy power conversion ","keywords":"Introduction  The simplification of drive trains and power take off systems for wave and tidal devices can reduce both construction and O&amp;M costs as well as increase reliability and system efficiencies. Project Neptune is a Wave Energy Scotland Stage 3 Power Take Off (PTO) project, focusing on the development of the C-GEN medium to full scale direct drive generator topologies for the marine environment. Direct drive PTO’s contain minimal complex mechanical components, thus potentially leading to a reduction in O&amp;M costs and improved efficiencies over a wide range of load profiles. The C-GEN direct drive generator is a multi-stage Permanent Magnet Generator (PMG) that is applicable to direct-drive, slow or medium speed PTO applications and benefits from the additional aspects:    No magnetic attraction forces closing the airgap,  No cogging torque, and  Air cored coils that allow for a high level of modularity leading to multi stage machines for higher energy availability and a reduction of O&amp;M costs.    Over the course of this project, a 75kW C-GEN linear generator has been designed and built for testing within the offshore marine environment. To aid the survivability and efficiency of the generator system, polymer linear bearings, flooded airgaps and protective marine coatings have been utilised to remove complex mechanical bearings, seals and improving cooling. Testing of the generator assembly is to be completed by connecting it back to back with a C-GEN linear motor assembly to enable the emulation of varied wave loads.   Flooded Airgap Design.   Based on thermal modelling and experimental results from various flooded machine studies, it has been proven that a flooded C-Gen topology is capable of withstanding more than 5 times overload, without concern over temperature rise in the windings. Rather than size the generator converter for extreme wave events and loadings, these conditions will be absorbed within the generator and through resistive loading. The design and build of the flooded airgap for the prototype machine will be fully described including the protective coatings utilised for marine testing.   Bearing Design   To improve the operation of the C-Gen generator while operating in salt water, a polymer bearing assembly for the linear motor/generator assembly has been designed to allow the translational movement of the machines translator assemblies and for continuous operation within the salt water marine environment. The expected loads, bearing assembly manufacture and the operation of the bearings will be supplied in the final paper.   Control System   Although the linear motor will have the same geometry as the linear generator for back to back testing operation, the motor will have a different number of turns per coil so that the same supply can be used for both machines. The control design and operation of both the motor and generator testing assembly will be described.   Carnegie case study   This paper will also summarise a case study on how the design and build of Project Neptune’s C-Gen 75 kW prototype aids the design of a full scale linear generator for a device such as the Carnegie CETO6 wave energy extract buoy. ","authors":"Joseph Burchell, Ignacio Barajas-Solano, Mike Galbraith, Nisaar Ahmed, Okechukwu Ubani,  and Markus Mueller ","topic":"7","file":"1684-4884-2-DR-OK.pdf","bib":"GRDPTO-1684.bib"},
{"paperid":"1686","title":"Performance evaluation and analysis of a micro-scale wave energy system","keywords":"This paper explores the realm and concept of ‘micro-scale’ WEC as power sources for instrumentation and other low-power (&lt;50W average) ocean applications. We further discuss the applications and the possibilities/limitations for such a system.   Wave energy devices have been used to provide low levels of remote power; most notably, Y. Matsuda developed a very successful OWC WEC system to power navigation buoys [1]. The vast majority of the work in wave energy to date, however, has been focused on the development of larger systems.   This paper attempts to reconcile aspects of research and development of larger-scale WEC systems with what might be possible at a smaller scale. Importantly, we set a series of physical limitations on the converter that ensures it is one man deployable.   This work examines the most significant WEC archetypes that have been developed to date and addresses their performance within the above context of micro-scale power generation. We ultimately present two WEC archetypes that have the most potential for performance at a small scale. Further, we show that a well-designed micro-scale Wave Energy system can produce a constant annual power of around 25-50W that is somewhat independent of climate. Loss paths are examined and broken down and it becomes straightforward to see that geometric hull optimization has the largest potential to improve performance.  [1] Y. Masuda An experience with wave power generation through tests and improvement D.V. Evans, AF de O Falcão (Eds.), IUTAM symp. Hydrodynamics of ocean-Wave energy utilisation, Springer-Verlag (1986), pp. 445-452              ","authors":"Tim R. Mundon","topic":"3","file":"1686-4998-1-DR-OK.pdf","bib":"WAVDEV-1686.bib"},
{"paperid":"1687","title":"Experimental results of a self-rectifying impulse axial-flow air turbine with fixed guide-vanes","keywords":"The Wells turbine is one of the most frequent choices to equip oscillating water column devices because of its simplicity of construction. However, the stall occurs at the rotor blades above a critical flow rate coefficient, producing a sharp drop of the turbine torque, thereby limiting its efficiency when operating at the high energetic sea states [1]. The self-rectifying axial-flow impulse turbine is one popular alternative to the Wells turbine that does not exhibit the sharp efficiency drop at large flow rate coefficients, being able to operate under very energetic sea states with reasonable average efficiency. Self-rectifying impulse turbines are known to have limited peak efficiency due to the inherent misalignment between the flow direction and the inlet direction of the guide-vanes at the downstream stator, which introduces large flow stagnation pressure losses.   This paper reports the results of the experimental testing of an axial-flow self-rectifying impulse turbine with a new guide vanes geometry. The new stator’s design methodology is inspired by the methodology that was numerically and experimentally validated for the guide-vane design of concentric annular rows developed for the self-rectifying biradial air turbine validated [2]. In the present case, each inlet/exit guide vane system comprises three guide-vane rows which enable the correct deflection of flow into the rotor and simultaneously decrease of the blockage at the downstream guide-vane system, allowing a reduction of the stagnation pressure and therefore an increase of the efficiency, in comparison with the original design with a single row of guide-vanes at both rotor sides.   A 0.59 m rotor diameter turbine model was constructed and tested at the 55 kW IST Variable-flow blow-down test rig under unidirectional steady-state conditions. Measurements of air pressure head, the pressure difference across the rotor, flow rate, rotational speed, and power output will assess the performance of this turbine. Experimental results will also be used to validate the results from the CFD simulations of the turbine.   References   [1]    A.F.O. Falcão and J.C.C. Henriques. “Oscillating-water-column wave energy converters and air turbines: A review”, Renewable Energy, vol. 85, pp. 1391-1424, 2016.   [2]    A.F.O. Falcão A.R. Maduro, L.M.C. Gato, J.C.C. Henriques and D.N. Ferreira. “Design and optimization of fixed guide-vanes arranged into concentric annular rows for a self-rectifying biradial air-turbine”, In: Proc. of the 12 th  European Wave and Tidal Energy Conference, Cork, Ireland, 2017.   [3]    A.R. Maduro; A.A.D. Carrelhas; J.C.C. Henriques; D.N. Ferreira. “Design and experimental validation of guide-vanes arranged into multiple concentric annular rows for a self-rectifying biradial air-turbine”, IST Internal report, 2018.          ","authors":"Ana F. F. Ponte, Ana A. D. Carrelhas, Lu?s M. C. Gato, Joao C. C. Henriques, Antonio F. O. Falcao","topic":"7","file":"1687-5057-1-DR-OK.pdf","bib":"GRDPTO-1687.bib"},
{"paperid":"1691","title":"Assessment of tidal turbine load cycles using synthesised load spectra, including blade-scale ?uctuations","keywords":"Tidal turbines are currently being used for electrical generation in early-stage array projects, such as Meygen in the Pentland Firth. As these projects progress past the development phase longer life goals gain more importance. Unlike wind turbines, tidal turbines are located in a more complex working environment with onset flows comprising a sheared velocity profile and unsteady kinematics due to both turbulence of varying spatial and temporal scales and free-surface waves.      An efficient approach to evaluate the load spectrum of a turbine is of interest to evaluate the accumulation of fatigue loading across the wide combination of met-ocean conditions and turbine operating points that may apply during the operating life. Here frequency variation of loading is synthesised from a frozen velocity field generated from the turbulence spectrum of the undisturbed flow and distorted by induction, combined with a blade element model with both mean and variance of lift and drag defined as inputs. The blade coefficients are obtained with unsteady RANS for the time-varying onset relative velocity and angle of incidence experienced over a range of radii and tip speed ratios. The root bending moment on a blade and thrust on the rotor are shown to be consistent with experimental measurements from a 1.2 m diameter turbine (Payne et al. 2018) tested at the IFREMER facility. Accounting for the unsteady onset flow to the blade reduces the mean lift coefficient and increases the variance of both lift and drag. This reduces the gradient of the blade root bending moment spectrum over the high frequency range and relative to the onset turbulence spectrum.      Accumulated cyclic loading is determined through the use of damage equivalent loads (DEL) using Rainflow cycle counting for a representative turbine with velocity, turbulence and wave data at a site in the Pentland Firth. The influence of onset turbulence simulation method and blade scale load fluctuations on the damage equivalent load is established relative to simplified approaches such as direct scaling of experimental measurements of the turbulence load spectra.         Payne, G., Martinez, R., Bruce, T., and  Stallard, T.   2018  Variation of loads on a three-bladed horizontal axis tidal turbine with frequency and blade position. Journal of Fluids and Structures 83, 156-170 ","authors":"Hannah R. Mullings and Tim Stallard","topic":"6","file":"1691-4698-2-DR-OK.pdf","bib":"TIDHYD-1691.bib"},
{"paperid":"1692","title":"Design and testing of a full-scale 2 MW tidal turbine blade","keywords":"The Large Structures Research Group of MaREI, Orbital Tidal Power Ltd and ÉireComposites Teo. have designed and manufactured a full-scale blade for the next-generation 02-2000 2 MW tidal turbine as part of the H2020 FloTEC project. The nearly 9 m long resulting blade has been tested under static load conditions through the MaRINET2 transnational access programme. This paper provides an overview of an initial design study which analysed the impact of using a single shear web or two shear webs in the design. This design study was followed by optimisation of the laminates throughout the blade to reduce the cost of production and, hence, the levelized cost of energy of the device. The finite element analyses and structural optimisation studies were performed using the NUI Galway and MaREI in-house blade design software, BladeComp.   The present work also describes the set-up and preliminary results of the structural testing. An overview of the data acquisition, blade support, blade installation and test loading are provided. The blades were loaded using three hydraulic actuators with load capacities of up to 750 kN and a 1 m stroke length. The structural response was determined using a range of measuring equipment including: strain gauges, draw-wire displacement sensors and LVDTs, a digital image correlation device, a Leica C10 3D laser scanner and a scanning laser vibrometer. The results of structural testing and the blade FE models are compared, identifying regions for further analysis in a future fatigue testing campaign. ","authors":"Edward M. Fagan, Finlay Wallace, Yadong Jiang, Afrooz Kazemi and Jamie Goggins","topic":"4","file":"1692-4777-2-DR-OK.pdf","bib":"TIDDEV-1692.bib"},
{"paperid":"1693","title":"Methodologies for testing PTOs under real conditions in the laboratory using actuators and hardware-in-the-loop scheme","keywords":"As stated in the SET-Plan Ocean Energy, ocean energy must reduce costs. That is achieved by means of increasing the performance and reliability as well as reducing installation and maintenance in sea locations. In order to fulfill that, new testing methodologies, equipment and facilities can contribute to adjust and validate the technological solutions as well as to decide about the maturity level to pass from the lab to the sea operation in the appropriate moment.   Two different issues are considered in this paper related to improve the laboratory testing of a power take-off (PTO): a discussion about the selection of different solutions of actuator to emulate the wave performance and the description of the hardware-in-the loop (HIL) scheme provided to operate the PTO under real electrical conditions. The case of point absorbers is analysed in this work.   Related to the use of an actuator which reproduces similar mechanical conditions to the site where the system will be installed, different solutions can be considered: hydraulic, mechanical and direct-drive. Hydraulic has a very low efficiency and it requires a huge electric power capability to accomplish the tests. Mechanical has a delicate design but some solutions permit long strokes and high forces. Finally, electric drives, more efficient and accurate but more expensive. The experimental set described in the paper faces a mechanical solution based on a rack&amp;pinion system. This option, among other benefits, allows using both linear or rotational generators by modifying just some parts of the rig.   The scenarios to be tested are based on real sea locations, characterized by their sea states. After providing time profiles of position and velocities, obtained from previous simulations with a certain wave energy converter and controlled by a certain control strategy, the system behaves mechanically as the real one in a hardware-in-the-loop scheme. Figure 1 presents the control scheme used for the PTO validation.    <img src=data:image/png;base64,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","authors":"Marcos Lafoz, Marcos Blanco, Jorge Nájera, and Gustavo Navarro","topic":"3","file":"1693-4927-1-DR-OK.pdf","bib":"WAVDEV-1693.bib"},
{"paperid":"1699","title":"Submerged pressure differential plate wave energy converter with variable geometry","keywords":"The wave energy converter understudy can be modeled as a rectangular plate that is submerged at a given depth beneath the calm water surface. The plate will be connected directly to the seabed by four vertical tethers in a finite water depth. The tethers will be attached at the four concerns of the rectangular plate where a ball and socket joint will act as the connection between the plate-tether and the seabed-tether intersections. Each tether will not be allowed to bend but can rotate as well as extend and compress in the axial direction to satisfy the kinematic constraints. The kinetic and potential energy of the rectangular plate, driven by the incident waves, will be absorbed by the tethers that act as power-take-off (PTO) systems and will be modeled as separate spring-damper systems. This work will develop a linearized 3 DOF model that will be used to evaluate the power absorption capacity under regular waves as the size and submergence depth of the device is iterated. The device will incorporate variable geometry modules that allows for control over the hydrodynamic characteristics that was previously investigated for a bottom fixed oscillating surge wave energy converter [1]. These modules will be controlled to optimize power absorption in operating conditions while emphasizing load shedding in extreme sea states. In [1] the changing hydrodynamics only affected one DOF while in the proposed design the location and size of the variable geometry will affect the three DOFs differently.   [1] N. Tom, Y.-H., Yu, and Wright, A., “Balancing the Power-to-Load Ratio for a Novel Variable Geometry Wave Energy Converter with Nonideal Power Take-Off in Regular Waves,” in  Twelfth European wave and Tidal Energy Conference,  Cork, Ireland, 2017. ","authors":"Nathan Tom, Yi-Hsiang Yu, and Alan Wright","topic":"3","file":"1699-4736-2-DR-OK.pdf","bib":"WAVDEV-1699.bib"},
{"paperid":"1700","title":"Optimization of shape and control of nonlinear Wave Energy Converters","keywords":"This paper presents an optimization approach to design axisymmetric wave energy converters (WECs) based on a nonlinear hydrodynamic model.  This paper  adopts  analytical  formulas  for  the  nonlinear  Froude-Krylov  force  of  complex  buoy shapes, by combining basic shapes in an optimal sense.  The time domain  Froude-Krylov force can be computed for a complex buoy shape, then is decom-  posed  into  its  static  and  dynamic  components.   The  excitation  force  and  the  hydrostatic  force  are  calculated  by  the  dynamic  and  static  component  of  the  nonlinear Froude-Krylov force.  A nonlinear control is assumed in the form of  nonlinear and linear damping terms.  Genetic Algorithms are implemented in  searching for the optimal buoy shape along with the optimal control coefficients  simultaneously.  Simulation results presented in this paper show that it is possi-  ble to find non traditional buoy shapes that leverage nonlinear hydrodynamics  to harvest more energy. ","authors":"Jiajun Song, Ossama Abdelkhalik, Shadi Darani","topic":"3","file":"1700-4615-2-DR-OK.pdf","bib":"WAVDEV-1700.bib"},
{"paperid":"1703","title":"Submerged horizontal plate used for wave energy extraction and as a potential coastal defence alternative","keywords":"As an alternative to conventional breakwaters, a submerged horizontal plate can be design to be used as an effective coastal defence [1] , providing shelter for navigation or recreation purposes. Nevertheless, such structures can be expensive then the interest to share costs with other sectors, such as the energy industry. A plate breakwater is a long, box type open breakwater [2]  that produces several mechanisms for wave dissipation, depending on its location in the water column: wave breaking, generation of vortex [3–5]  and the interference with the orbital velocities of the incoming waves due to a reverse pulsating flow formed beneath the plate. The last process has been previously studied to analyse its viability to be used as an alternative energy source to be harvested by a turbine [6–8] . The numerical model FLOW-3D was used to simulate different wave scenarios using Second Order Stokes Waves with two different slopes, propagating in intermediate waters. Three different prototypes (1/50 scale) with different plate geometry were tested to evaluate their hydrodynamic coefficients (reflection, transmission and dissipation) and their efficiency to generate the under current: a) a solid plate (SP); b) a plate with an inner rectangular void with a Venturi tube type in the central section (VTP); and c) a plate with an inner rectangular void with a positive sloped section at the bottom of the rear end of the plate (VIP). The vertical dimension of the inner void and the submergence and length of the plate were varied within the experimental matrix. The results showed that the SP gave a pulsating reversed flow, as expected. The VTP and the VIP gave strongest currents, but unlike the SP configuration, the current was balanced in the positive and negative x direction (parallel to the direction of the wave propagation). From the three plate types, the VIP and VTP had the strongest pulsating flow reaching a maximum of ± 15 and +15 cms -1 , respectively, while the SP reached -10 cms -1 , making the VIP the most suitable prototype for harvesting the wave energy (Fig. 1). Considering the hydrodynamic coefficients obtained, the three plate configurations are appropriate to be used as coastal protection devices, which cost of construction and maintenance could be shared by Port and energy sectors.    ","authors":"Manuel  G.  Verduzco-Zapata,  Francisco  J.  Ocampo-Torres,  Ramòn  O.  Jiménez-Betancourt,  and Ernesto Torres-Orozco","topic":"3","file":"1703-4844-3-DR-OK.pdf","bib":"WAVDEV-1703.bib"},
{"paperid":"1705","title":"Discrete-time causal control of WECs with finite stroke, in stochastic waves","keywords":"In this paper we consider the design of controllers for WECs with finite stroke, when subjected to stochastic waves.In particular we consider causal control algorithms; i.e., control laws that do not require future wave loads to be known a priori (e.g., through preview sensors) in order to make decisions. In the absence of stroke limits on the WEC PTO hardware, and when linear response can be assumed, optimal causal control design for this class of problems is straight-forward. Specifically, it constitutes a special case of Linear Quadratic Gaussian (LQG) control, which may be solved in closed form in terms of a WEC's state space dynamic model. However, the presence of stroke limits complicates the control design significantly, when stochastic waves are assumed. A further challenge in the control design problem arises, when it is necessary to implement causal control algorithms in discrete-time.  We present a technique for discrete-time control of WECs with finite stroke, which is based on multi-objective optimal control, as well as passivity theory. The design technique is comprised of several components which can be designed in sequence.First, an optimal linear LQG controller is designed which accommodates a weakened, time-averaged version of the stroke limit constraint.This first design component makes use of multi-objective optimal control theory, and is cast in the context of a semidefinite program.Second, this controller is nested inside a nonlinear passive feedback law that guarantees to protect the stroke from saturation.This stage makes use of nonlinear passivity theory.Third, the two components are integrated together in a very specific way which guarantees robust stability in stationary response. This final step makes use of concepts from robust control.  In the discrete-time framework we consider here, the control of the WEC's PTO is presumed to be implemented via zero-order-hold control of the PTO force. We show that the discrete-time framework allows for control designs that operate effectively, even with a very low sampling rate. We also illustrate the tradeoff that exists between power generation performance and sampling time.  Finally, we illustrate that in the context of causal WEC control, there is sometimes a theoretical advantage to the use of controllers that are open-loop unstable. Even though this theoretical advantage is often tangible, there are certain impracticalities to the implementation of open-loop-unstable controllers.As such, we illustrate a technique whereby the proposed technique can be extended so as to produce an open-loop-stable control law. We illustrate the implementation of this controller on a simple floating buoy model. ","authors":"Jeffrey T Scruggs, Yejun Lao, Mirko Previsic, and Anantha Karthikeyan","topic":"7","file":"1705-4828-2-DR-OK.pdf","bib":"GRDPTO-1705.bib"},
{"paperid":"1708","title":"Comparison of five performance metrics applied to five WEC concepts ","keywords":"Abstract—In early stage technology design for wave energy conversion, comparison of alternative competing concepts is a key activity in determining the relative merits of candidate concepts. Careful selection of the measures (“metrics”) used in such a comparison is also of utmost importance since alternative metrics can be shown to give contradicting indications. To develop high performing wave energy technology it is vital that R&amp;D strategy is informed by high quality execution of the concept comparison and metric selection activities. This paper presents an analysis of five generic heaving wave energy converter (WEC) concepts drawn from a survey of current and past WEC technology. For each of the five concepts we calculate five metrics also drawn from previously published work. The analysis utilises hydrodynamics based on linear potential flow. The relative merits of the selected devices and the selected metrics are discussed in the context of the modelling methods used.  Keywords—. Dynamics, heave mode, numerical simulation, optimization, power production assessment, wave energy converter.  ","authors":"Ronan Costello, Morgan Jones and Ben Kennedy","topic":"5","file":"1708-5004-1-DR-OK.pdf","bib":"WAVHYD-1708.bib"},
{"paperid":"1712","title":"Integrity and Reliability Testing of a HDPE Taut Mooring System Belt","keywords":"The integrity of the mooring system is critical for the safe station-keeping of any floating structure. For motion dependent wave energy converters, the additional requirement is to provide sufficient compliance to allow the power take-off working principle to function.   This paper presents the physical testing carried out as part of the MARINET2 test programme. The mooring system design for the Calwave wave energy converter is tested in order to validate the actual physical performance of the mooring system.   The tests are carried out at the Dynamic Marine Component Test facility (DMaC), a purpose built test rig that aims to replicate the forces and motions that components are subjected to in offshore applications. The hydraulic test rig is capable to replicate dynamic tensile forces of up to 30 tonnes with submersed test specimens of up to 6 meters length.   The tests explore the Minimum Breaking Load (MBL) as a primary measure of integrity, but will also perform repeated cyclic loading, simulating low-cycle fatigue behaviour of the mooring system. Finally, the tests seek to assess the mooring response and integrity under simulated Accidental Limit State (ALS) conditions, where the device’s power take-off will be locked and the mooring loads are expected to increase considerably.   The paper will be of interest to technology developers, mooring designers and stakeholders concerned with the integrity and durability and validation of offshore mooring systems.     ","authors":"Philipp R. Thies, Peter Halswell, Marcus Lehmann and Lars Johanning","topic":"12","file":"1712-4944-1-OK.pdf","bib":"MRGFND-1712.bib"},
{"paperid":"1713","title":"Efficiency of Wave Energy converters off the Sicilian Channel","keywords":"Nowadays, in the international framework of renewable energies, we are observing an increasing interest in the production of energy from the sea waves. The latter indeed is a huge source of clean energy able to provide electricity to the whole world population, in principle. In this study, only the surface gravity waves energy was taken into account. In Italy the most energetic areas for the wave energy conversion were found around Sicily and Sardinia islands. In particular, off the coasts of western Sardinia the average annual power available reaches values of about 12 kW/m, nearby Alghero. Moreover, in the Sicilian channel we calculated an average annual power of about 9 kW/m. The main objective of this paper is to assess the amount of convertible energy, in the area identified by previous studies of the research group, and to evaluate the effects of WEC devices on coastal erosion protection. The waves propagation from offshore to nearshore was carried out using the SNL-SWAN spectral model (Sandia National Laboratories – Simulating WAves Nearshore). This open source numerical code makes possible to calculate the power extracted from WEC devices, arranged in arrays. Using the SLN-SWAN numerical code, it is possible to calculate the transmission coefficient K t  2 . One of the input data of the afore mentioned model are the WEC power matrices, expressed as a function of the wave height and period. These matrices are determined experimentally by the prototype manufacturers and allow to compute the extractable power, depending on the significant wave height and on the peak period. The parameter K t  2  was calculated as the ratio of the wave transmitted power and the wave incident power. In the used numerical model the WEC arrays were located parallel to the coastline, near the 20 m bathymetric isoline; the devices considered are Pelamis, Wave Dragon and Oyster 2. The analysis of results of the numerical model include the comparison between the significant height distribution both in the case of presence of WECs and in their absence. Among the simulated devices only the Oyster 2 has an high value efficiency whereas for the other two devices lower power values were obtained. This result can be justified because the prototypes was designed considering the oceans wave conditions, which are of an order of magnitude higher than the conditions that occur in a closed sea basin, as is the Mediterranean Sea. In order to improve the efficiency of the Wave Dragon for the typical Mediterranean wave conditions a further study was performed considering the device scaled according to the Froude similarity. Such a scaling approach allows Oyster 2 to work with a lower available power, that is more compatible with the wave conditions present in the Sicilian Channel. ","authors":"Carlo Lo Re, Giorgio Manno, Giovanni Besio and Giuseppe Ciraolo","topic":"1","file":"1713-4932-1-DR-OK.pdf","bib":"WAVRES-1713.bib"},
{"paperid":"1723","title":"Mooring system design for underwater floating tidal current power(TCP) device","keywords":"Tidal current is considered one of the most promising energy sources as tides are more predictable than wind energy and solar power. The tidal turbine consists of blades, rotor, generator and a foundation. There are various types of foundations - rigid monopile, gravity foundatons or floating structures etc.  The most common foundation for floating structure is moorings which are designed to position the structure in mid water colume or at the surface using buoyancy and tension forces of the moorings. The well designed mooring system can be an inexpensive option as this type of foundation does not require large footprint. However, the major obstacle in the design is to optimize the buoyancy of the device to counteract the weight of both the turbine and mooring lines, which makes it difficult to keep the device buoyant in mid water and may lower the amount of energy extracted.  The hydrodynamic analysis program, WADAM, is used herein to calculate wave-structure interaction. Firstly, response amplitude operators (RAOs) are obtained to conduct hydrodynamic analyses in time domain. Secondly, inclusion of the mooring system in calculation of motion is done in OrcaFlex 10.1a. With various hang-off and specific gravity of floater, the proper mooring system to minimize pitch motion has been simulated considering extreme ocean condition of south-west coastal line of South Korea. Lastly, model test are carried out to validate the computational results.  As a result, the most desirable hang-off and azimuth angles are 64 and 30 degrees respectively with the maximum pitch angle of 5.33 degrees, and the lower specific gravity of floater procures the better stability of floter itself. ","authors":"Chul-Hee Jo, Su-Jin Hwang, Seong-Ho Jo and Yo-Seop Kang","topic":"4","file":"1723-4705-2-DR-OK.pdf","bib":"TIDDEV-1723.bib"},
{"paperid":"1724","title":"The integration of a hybrid Wave Energy Converter in port breakwaters","keywords":"Sea ports are complex infrastructures with substantial energy needs.  On 12 May 2017 the International Association of Ports and Harbors decided to set up a World Ports Sustainability Program. Guided by the 17 UN SDGs the program wants to enhance and coordinate future sustainability efforts of ports worldwide and foster international cooperation with partners in the supply chain.  The integration of wave energy converters (WEC) in port breakwaters is a solution with potential to put such critical infrastructure on the right track in terms of commitment to sustainable development goals and move port development and operations in a more environmental friendly direction. The project ‘Sustainable Energy at Sea Ports’, acronym SE@Ports, being developed by International Marine and Dredging Consultants (IMDC) based in Belgium with partners from Portugal and Spain under the second Joint Call of Ocean Energy ERA-NET Cofund initiative.  The partners are investigating the integration of WEC in port breakwaters with a threefold objective: (1) to assess existing WEC’s (proven concept TRL 3) on their suitability to be integrated in port infrastructure and bring the selected concepts of WEC’s to the next TRL; (2) to demonstrate the win-win solution of incorporating WEC devices into port infrastructure; and (3) to facilitate end-users with key-technical requirements and tools to best reduce and assess the risks and barriers of that incorporation. The project incorporates work packages on both research and aspects on commercialisation. The research component is based on (1) a site characterisation of the ports of Las Palmas in Gran Canary Island – Spain and Leixões – Portugal; (2) numerical modelling from waves offshore to the toe of the structure, then the wave-WEC-breakwater interactions and finally to wire; and (3) small-scale physical modelling. The obtained results are then integrated into a work package dedicated to commercial aspects, including the preparation of a structured framework for end-users to best reduce and assess the risks and barriers of the technology for the integration with port infrastructure, and the design assessment and engineering evaluation. Within the SE@Ports project IMDC is developing an assessment tool to predict the energy production of a hybrid WEC when integrated with a port breakwater.  IMDC aims to apply the energy yield assessment tool to the two case study site ports, the rubble-mound north breakwater of the port of Leixões and the Nelson Mandela vertical breakwater of the port of Las Palmas. The HWEC is a concept that combines an Oscillation Water Column (OWC) device with either a Seawave Slot-Cone Generator (SSG) or an Overtopping Breakwater for Energy Conversion (OBREC).    ","authors":"Luciana das Neves, Zafar Samadov, Enrico Di Lauro, Kevin Delecluyse, Piet Haerens","topic":"5","file":"1724-4840-1-DR-OK.pdf","bib":"WAVHYD-1724.bib"},
{"paperid":"1728","title":"Novel Methodology for holistic assessment of wave energy design options","keywords":"Despite significant efforts in last decades, Wave Energy technologies have not reached commercial maturity yet. Wave Energy is not competitive with other renewable energy sources due to its poor performance, reliability levels and high costs. Conventional methodologies focused on Technology Readiness Levels (TRL) have proved insufficient to guarantee Wave Energy technologies meet their technical and economic goals.   Systems Engineering methods have been successfully applied in other industrial sectors (e.g. automotive, aerospace) to develop innovative products meeting very diverse and demanding customer requirements. Likewise, multicriteria analysis has been applied to inform the decision-making process in early design phases of complex engineering problems, particularly when alternative solutions can be heterogeneous.   This paper presents a novel methodology for the holistic assessment of wave energy design options based on sound systems engineering and multicriteria analysis principles. This approach is particularly useful during the first stages of technology development where up to 75% of the final product cost can be committed.   In order to guarantee stakeholder requirements are fully traceable throughout the design process, the methodology proposes a sequential mapping process among three different design domains:    Stakeholder Domain, defined by the Stakeholder Attributes (SA) the customer and associated stakeholders would like to see in their system. SA are grouped in four categories: benefits, opportunities, costs and risks.  Functional Domain, where requirements are transformed in a comprehensive Functional Specification (FS). Wave Energy technologies are decomposed at different levels following a generic functional taxonomy.  Physical Domain, in which the Engineering Parameters (EP) emerge. It describes the physical embodiment to achieve these functions.    The successful transition from different domains require effective design synthesis and analysis. The mapping is done following a matrix-based modelling approach. Using a combination of well-established tools, the relative importance of each of the design domain criteria is evaluated and the relationship matrix between domains filled in. Among the tools employed, it is worth mentioning the Analytical Hierarchical Process (AHP), Quality Function Deployment (QFD) and Design Structure Matrix (DSM).   Multicriteria ranking methods have often been criticised for its reliance on expert judgement and inherent subjectivity. To overcome this drawback, the analysis of alternatives is facilitated by the use of utility functions. Utility functions model the fundamental relationships between the physical design attributes and the actual value offered to stakeholders. A reduced set of parameters is used to produce different curves (e.g. S-shape, concave, convex or linear). For instance, convex exponential curves can be used to model risk-adverse stakeholder preferences, whilst concave ones can represent risk-seeking preferences.   The paper will present results and conclusions from the application of this novel methodology to Wave Energy, aiming at the identification of wave energy design concepts with greatest potential. ","authors":"Pablo Ruiz-Minguela, Jesus M. Blanco, Vincenzo Nava","topic":"10","file":"1728-4905-1-DR-OK.pdf","bib":"ECONOM-1728.bib"},
{"paperid":"1729","title":"Techno-Economical Tools for WEC Scale Optimisation","keywords":"The scale (or size) of Wave Energy Convertors (WEC) deployed are often constrained by many parameters, especially during early stages of technology development or pre-commercial project. Site specific aspects such as the proximity and availability of port infrastructures to assemble, install, operate and maintain the system are often key in that decision and tends to skew deployment scale towards smaller size. Similarly, funding constraints tends to favour smaller size system, larger units being more capital intensive to deploy. This must be balanced with the need to demonstrate the technology at a scale which is close to the final and commercially optimum scale of the system. This usually support the decision to deploy larger size systems.   To date, studies have been performed for various WEC technology types and have largely focussed on optimising WEC scale to deliver the highest power output. Less often the optimum WEC scale delivering the lowest Levelised Cost of Energy (LCOE) has been studied. This is understandable since this requires a deep understanding of both the technical and financial aspects of the technology studied. The optimised LCOE scale of a system also depends on the number of unit deployed for a project as well as existing infrastructure.   This paper presents the tools developed by Carnegie Clean Energy (CCE) to optimise the scale of its CETO technology in order to deliver the best LCOE for a 15 units project in Albany along the south coast of Western Australia. The model takes into account the cost sensitivity of all major components of the technology with the main design parameters of these components. These tools also provide crucial value during the design process of a technology. Design decisions are quite often related to a trade-off between cost and performance. The tools developed also facilitates those decision by informing on the optimum design parameter leading to the best LCOE.  Although developed specifically for the CETO technology at the Albany site the methodology used to develop these tools can be easily replicated for all WECs and at any development site.","authors":"Alexandre Pichard, Craig Wale, Ashkan Rafiee ","topic":"3","file":"1729-4797-2-DR-OK.pdf","bib":"WAVDEV-1729.bib"},
{"paperid":"1730","title":"New method for modelling air compressibility in OWC devices","keywords":"Air compressibility effects play an important role in large scale Oscillating Water Column (OWC) wave energy converters. Air compressibility effects are however not scalable with Froude similarity law and their correct reproduction at model scale is difficult. They are therefore commonly neglected in model scale tank testing which can lead to substantially unrealistic for the converter performance.   The Tupperwave device is a type of OWC device using non-return valves to rectify the flow across a unidirectional turbine. The device working principal relies entirely on air compressibility in fixed volume accumulator chambers. It is therefore essential to correctly reproduce air compressibility to test the device at model scale. The Tupperwave device has already been successfully tested at 1/24 th  scale using an existing method to reproduce air compressibility. But this method is expensive and would not be feasible if the device was to be tested at larger scale (1/10 th , 1/5 th ). In this paper, a new method for modelling air compressibility at model scale is presented. The method is based on variable volume chambers which mimic air compressibility by storing energy under the form of strain energy. ","authors":"Pierre Benreguig, Jimmy Murphy","topic":"3","file":"1730-5071-1-DR-OK.pdf","bib":"WAVDEV-1730.bib"},
{"paperid":"1731","title":"WECANet: The first open pan-European Network for Marine Renewable Energy with a focus on wave energy – COST Action CA17105","keywords":"Growing energy demand has increased interest in marine renewable energy resources, i.a. wave energy which is harvested through Wave Energy Converter (WEC) Arrays.   However, the wave energy industry is currently at a  significant juncture in its development , facing a number of challenges which require that research re-focusses onto a holistic  techno-economic perspective , where economics consider the full life-cycle costs of the technology. It also requires development of WECs suitable for  niche markets , because in Europe there are inequalities regarding wave energy resources, wave energy companies, national programmes and investments. As a result, in Europe there are  leading  and  non-leading  countries in wave energy technology. The sector also needs to increase confidence of potential investors by  reducing (non-)technological risks.  This can be achieved through an  interdisciplinary approach  by involving engineers, economists, environmental scientists, legislation, governmental bodies and policy experts. Consequently, the wave energy sector needs to receive the  necessary attention  compared to other more advanced and commercial ocean energy technologies (e.g. offshore wind).   The formation of the  first open pan-European Network  (Fig. 1) on an interdisciplinary approach will contribute to large-scale  WEC   A rray deployment by dealing with the current bottlenecks. The  WECANet  EU COST Action, presented in this paper, aims at a collaborative and inclusive approach, as it provides a strong networking platform that also creates the space for dialogue between all stakeholders in wave energy. An important characteristic of the Action is that participation is open to all parties interested and active in the development of wave energy. Previous activities organised by WECANet core group members have resulted in a number of joint European projects and scientific publications ([1]-[3]). WECANet’s main target is the equal research, training, networking, collaboration and funding opportunities for all researchers and professionals, regardless of age, gender and country in order to obtain understanding in the main challenges governing the development of the wave energy sector.   REFERENCES:    [1] Stratigaki, V., Troch, P., Stallard, T., Forehand, D., Kofoed, J. P., Folley, M., Benoit, M., Babarit, A., Kirkegaard, J. (2014). Wave basin experiments with large wave energy converter arrays to study interactions between the converters and effects on other users in the sea and the coastal area.  ENERGIES ,  7 (2), 701–734. doi: 10.3390/en7020701 .   [2]  Numerical modelling of wave energy converters: state-of-the-art techniques for single devices and arrays , (2016). M. Foley (Ed.). Book Contributors: M. Alves, D. Causon, B. Child, J. Davidson, B. Elsäßer, C.B. Ferreira, C.J. Fitzgerald, M. Folley, D. Forehand, S. Giorgi, J.P. Kofoed, L. Kregting, C. Mingham, L. Qian, P. Ricci, J.V. Ringwood, V. Stratigaki, P. Troch, &amp; S. Vaughan. ISBN: 978-0-12-803210-7, Elsevier.   [3] Folley, M., Babarit, A., Child, B., Forehand, D., O’Boyle, L., Silverthorne, K., Spinneken, J., Stratigaki, V., and Troch, P. (2013). A review of numerical modelling of WEC arrays. Proceedings of ASME 31 st  International Conference on Ocean, Offshore and Arctic Engineering (Vol.7, pp. 535–545).  http://dx.doi.org/10.1115/omae2012-83807  .    ACKNOWLEDGEMENTS:     WECANet is funded through the HORIZON2020 Framework Programme by COST (European Cooperation in Science and Technology,  www.cost.eu ), a funding agency for research and innovation networks.   ","authors":"Vasiliki Stratigaki, Peter Troch, Matthew Folley, David Forehand, Eva Loukogeorgaki, Liliana Rusu, Moncho Gomez Gesteira, Aleksander Grm, Francesco Ferri, Lorenzo Cappietti, Irina Temiz, Constantine Michailides, George Lavidas, Xenia Loizidou and Maxim Candries","topic":"5","file":"1731-5008-1-DR-OK.pdf","bib":"WAVHYD-1731.bib"},
{"paperid":"1733","title":"Numerical investigation on the effects of the pitch angle on the efficiency of an Archimedean-type turbine","keywords":"Extraction of clean energy from renewable sources is one of the main tasks of the current era and use of hydrokinetic turbines from water currents is promising, as the hydrokinetic technology reduces the number of operational infrastructure and minimize the impact on the ecosystem.   We study an innovative turbine: the Archimedean-Type Hydrokinetic Turbine. It is similar to the well-known Archimedean Screw, used in several small hydropower plants, but in the hydrokinetic mode all the devices for turbine protection and water canalization are removed and the turbine is settled in a fluid flow, with minimal support structures and transmission systems. Using this setup the operating principle totally changes: the classical Archimedean Screw exploits the difference in potential energy between two water reservoirs, while the Archimedean-Type Hydrokinetic Turbine exploits the kinetic energy of a flow and can be placed, for example, in a tidal current or in a harbour structure with available basins.   The combination of the operational requirements (i.e. installation and energy transfer) and of the current variability can change in time the pitch angle, i.e. angle between the flow direction and the turbine axis. Hence, numerical experiments are used to investigate the role of the pitch angle. The hydrodynamics of the Archimedean-Type Hydrokinetic Turbine are simulated using a three-dimensional numerical model that implements the Reynolds Averaged Navier-Stokes equations for incompressible water, closed with an SST k-? turbulence model [1]. The numerical model reproduces a two-stride helical turbine, with external diameter 0.1 m and stride length 0.16m. In particular, the efficiency for different pitch angles and different tip speed ratios is evaluated using Betz’s theory, which is commonly used for the evaluation of the efficiency of complex geometry hydrokinetic turbines [2]. Efficiency curves for different pitch angles are derived and compared, to quantify the power production in different operative condition.              REFERENCES    [1]     B. Andersson, R. Andersson, L. Hakansson, M. Mortensen, R. Sudiyo, B. Van Wachem, Computational fluid dynamics for engineers, Cambridge University Press, 2011.   [2]     M. S. Guney, Evaluation and measures to increase performance coefficient of hydrokinetic turbines, Renewable and Sustainable Energy Reviews 15 (8) (2011). ","authors":"Gianluca Zitti, Fernando Fattore, Alessandro Brunori, Bruno Brunori and Maurizio Brocchini","topic":"4","file":"1733-4995-1-DR-OK.pdf","bib":"TIDDEV-1733.bib"},
{"paperid":"1734","title":"Data-driven mode for the performance of hundreds megawatt wave energy converter in China: A case study","keywords":"The increasing development of wave and tidal energy technologies in China lead to huge open sea testing demands after experienced kind of laboratory experiments and small-scale model. More WECs (wave energy converter) and tidal devices owners put the devices into testing stations spontaneously and endured strict sea testing in order to improve the TRL (technology readiness level) and reliability. The paper introduces a data-driven model using deep learning algorithm associate with resource and testing data to evaluate performance of device. The result which jointed with model and censors data shows the specific relationship between resource and power output and the deep learning algorithm was confirmed to be a considerable method to do power predict based on testing data.     ","authors":"Ni Chenhua ","topic":"3","file":"1734-4807-3-DR-OK.pdf","bib":"WAVDEV-1734.bib"},
{"paperid":"1736","title":"Development of PRIMRE, the Portal and Repository for Information on Marine Renewable Energy","keywords":"The Marine Renewable Energy (MRE) industry is in the early stages of development corresponding to low technology readiness levels (TRLs) where the ability of the MRE community (developers, researchers, academics, stakeholders, labs, funding agencies and regulators) to work together to share knowledge, experience, and lessons learned is critical to the advancement of the entire MRE industry. Through collaboration on solving common problems, the MRE community has the potential to reduce cost and accelerate technology development. Currently, the US Department of Energy (US DOE) Water Power Technologies Office (WPTO) is addressing the challenge of storing, curating, and accessing MRE information by sponsoring development of MRE databases and information portals such as Tethys, OpenEI, MHK Data Repository (MHKDR), and open source code repositories (to name a few). These sites host a wealth of knowledge that includes scientific papers, news articles, reports, databases, open source codes, and stakeholder engagement information, but they are only a step towards facilitating global discovery and use. In short, there is an abundance of information available online, however it is located on many disparate sites and repositories that make data and information discovery difficult, see Figure 1.       A mutli-lab team from National Renewable Energy Laboratory (NREL), Pacific Northwest National Laboratory (PNNL) and Sandia National Laboratories (Sandia) has been funded from the US DOE to address the issues of data discoverability, shared knowledge, and interconnection of existing MRE databases and information portals. As a first stage in this effort, the lab team developed an MRE Data Vision and proposed development of PRIMRE (Portal and Repository for Information on Marine Renewable Energy). PRIMRE seeks to provide broad access to engineering, resource characterization, and environmental effects information on marine renewable energy projects to facilitate the commercial development of the MRE industry by:    Engaging the international MRE community to develop an understanding of the online tool and data needs  Improving existing databases and portals to better meet these needs  Coordinating efforts with the international community to ensure consistency and collaboration in development of online repositories     ","authors":"Kelley Ruehl, Frederick Driscoll, Andrea Copping, Jon Weers, and Anne Lilje","topic":"10","file":"1736-4761-2-DR-OK.pdf","bib":"ECONOM-1736.bib"},
{"paperid":"1737","title":"Development of a near shore WEC for the Brazilian coast","keywords":"The Brazilian coastal zone has as its distinctive features its wide range of species and ecosystems. In terms of area of ??coverage the coast line extends for 7367 km number that rises to more than 9200 km when considering the coastal cuts. This represents an EEZ of 3,500,000 km2 conventionally standardized inserted in the International plane. Offshore activities are common in the country which has accumulated state-of-the-art experience for more than 50 years in the offshore oil industry and is this the closest example of offshore activities. These aspects point to the development of technologies oriented to the ocean as an obligation.   The article presents a WEC concept of a nearshore apparatus under development in the Energy Planning Department from COPPE / UFRJ. The concept can be described as a conical body buoy following the vertical wave motion ensuring that portion of potential wave energy will be absorbed by the body. The inclined cone walls direct the flow of the fluid to the bottom of the floating body, thus increasing the kinetic energy portion. On the top surface of the float an axis of alternating movement moves according to the action of the waves transmitting the movement to the generator installed in a fixed engine room in the top of a lattice jacket.   The jacket is mounted on a net-type base formed by tubes, floating and towable, which in addition to the transport function works also as ballast after flooding of its compartments. This aspect contributes to decrease time to commissioning and decommissioning.   On top of this tube “raft” are four subsea reflectors with the main function of wave concentrator such as a Venture tube and additionally assisting in the structural equilibrium of the tower combating the active forces on the structural system and as auxiliary tanks for ballasting in the fixation of the structure in the seabed by the action of the gravity.   Maximization of the vertical movement of the floating body is desired and for this purpose the limitation of movement in other directions is limited by the action of the lattice tower. The floating body slides along the legs of the tower by the inclusion of polyethylene rolls arranged on the edges of the body.   The paper presents a preliminary analysis of the wave climate in the Brazilian north coast, which was used in the tank test of the LOC - Waves and Currents Laboratory of COPPE / UFRJ, presenting the main results of the experimental tests of small scale models.   It brings the stages of analytical, experimental and conceptual engineering development in the fundamental specialties as Hydrodynamics, Structures, Electric Generation and environmental care, among others. Finally it launches perspectives on the future development and possible applications of the use of the motive force of the sea waves not only for the electricity generation but other forms of energy that maximize the energy efficiency. ","authors":"Eliab Ricarte, Luiz  A. V. Pinto, Joel S. Sales Jr., and Marcos A. Freitas","topic":"3","file":"1737-5062-1-DR-OK.pdf","bib":"WAVDEV-1737.bib"},
{"paperid":"1738","title":"Hydroelastic modelling of flapping foils operating as flow and wave energy devices","keywords":"The performance of oscillating hydrofoils in the presence of waves and currents is studied for the exploitation of combined renewable marine energy sources in nearshore and coastal regions. The system operates as a semi-activated biomimetic energy device, with imposed pitching motion and induced heaving motion in harmonic incident waves and flow; see e.g. Xiao and Zhu (2014), Belibassakis et al (2015), Filippas et al. (2018). The use of aquatic inspired oscillating flexible fins for propulsion and exploitation of wave-current renewable resources has been recently the subject of several studies; with results showing that such systems are able to achieve high levels of efficiency either for propulsion (Priovolos et al, 2018) or for tidal energy extraction (Jeanmonod and Olivier, 2017).   In the present work, a hydroelastic model is proposed for the investigation of the effects of chord-wise flexibility on the performance of flapping foils with variable flexural rigidity. The foil structural response is actuated by an unsteady pressure field caused by the prescribed harmonic motion of the hydromechanical system. To study the time-dependent structural response of the oscillating hydrofoil, a fluid/structure interaction solver has been developed. The solver couples a low order Boundary Element Method (panel method) for the unsteady hydrodynamics with a Finite Element Method for the cylindrical bending of thin elastic plates, based on the classical Kirchhoff-Love theory.  Numerical results are presented concerning the performance of the system over a range of design and operation parameters, including reduced frequency, heaving and pitching amplitudes and effective angle of attack, and various flexural rigidity profiles inspired by nature. The results show that incorporating flexural rigidity profile variations and allowing chord-wise deformations to occur, enhances the performance of these systems. The present model could serve as a useful tool in the design, assessment and control of biomimetic systems for renewable energy extraction.  References 1. Xiao Q., Zhu Q. (2014). “A review on flow energy harvesters based on flapping foils”. In: Journal of fluids and structures 46: 174-191. 2. Belibassakis KA, Gerostathis Th.P., Filippas ES, Touboul J., Rey V. (2015) “Oscillating hydrofoils as energy devices operating in waves and currents”. Proceedings of the 11th European Wave and Tidal Energy Conference (EWTEC 2015), 6-11 Sept., Nantes, France. 3. Filippas E.S., Gerostathis Th.P., Belibassakis K.A. (2018). “Semi-activated oscillating hydrofoil as a nearshore biomimetic energy system in waves and currents”. Ocean Engineering 154:396-4154. 4. Priovolos A.K., Filippas E.S., Belibassakis K.A., (2018), A vortex-based method for improved flexible flapping-foil thruster performance, Engineering Analysis with Boundary Elements 95:69–84. 5. Jeanmonod G., Olivier M. (2017). Effects of chordwise flexibility on 2D flapping foils used as an energy extraction device. J Fluids Struct 70: 327-345. ","authors":"Dimitra E. Anevlavi, Evangelos S. Filippas, Angeliki E. Karperaki and Kostas A. Belibassakis ","topic":"6","file":"1738-5024-1-DR-OK.pdf","bib":"TIDHYD-1738.bib"},
{"paperid":"1739","title":"A GPU-accelerated method for the hydrodynamic analysis of a biomimetic flapping foil device for marine energy extraction","keywords":"In the present work a biomimetic flapping-foil device is studied for the exploitation of marine renewable energy resources. As a first approximation, the lifting body is submerged far from the free surface, neglecting the interaction with the additional boundary. The device is semi-activated, i.e. a pitching motion is enforced and a heaving motion is induced by an alternating lift, produced in the presence of the current. For this purpose a Boundary Element Method (BEM), developed by Filippas (2018 PhD thesis under preparation), in its 3-dimensional version is applied. A Morino-type Kutta condition is imposed on the trailing edge and, by linearising the trailing vortex sheet dynamics, a simplified wake model is used. However, the motion of the body and the initial shape of the wake are not linearised Filippas and Belibassakis (2014). The present method, after enhancement and further verification, can be applied to the design and control of such biomimetic devices extracting energy from waves and tidal currents nearshore; see e.g. Xiao and Zhu (2014), Belibassakis et al (2015), Filippas et al. (2018).   The performance of various integration quadratures for the calculation of singular integrals emerging in BEM are also investigated. Simple Gauss-Lobatto and Newton-Cotes quadratures, of arbitrary order, are embedded in an adaptive routine, enabling the treatment of singularities associated with the single/double layer potential induction factors. Different partitioning schemes are examined and the Richardson extrapolation technique is used to accelerate the convergence of the recursive quadrature routine (Lyness, 1969; Gander and Gautschi, 2000). The developed numerical integration method is able to evaluate efficiently integrals with multiple singularities on N-dimensional hyper-cubes.  The developed GPU-accelerated computational code (Filippas, 2018 PhD thesis under preparation) is reprogrammed, by using object-oriented programming, extending the method to solve the problem of the semi-activated system. The parallelization parameters that affect performance are determined and a mixed precision arithmetic scheme is used to optimize the performance of the algorithm. The concepts of polymorphism and inheritance, incorporated in object-oriented programming, encourage the extension of the solver to treat different problems with similar structure in an elegant manner.  References  1. Filippas, ES and KA Belibassakis (2014). “Hydrodynamic analysis of flapping-foil thrusters operating beneath the free surface and in waves”. In: Engineering Analysis with Boundary Elements 41: 47-59. 2. Xiao Q., Zhu Q. (2014). “A review on flow energy harvesters based on flapping foils”. In: Journal of fluids and structures 46: 174-191. 3. Belibassakis KA, Gerostathis Th.P., Filippas ES, Touboul J., Rey V. (2015) “Oscillating hydrofoils as energy devices operating in waves and currents”. Proceedings of the 11th European Wave and Tidal Energy Conference (EWTEC 2015), 6-11 Sept., Nantes, France. 4. Filippas E.S., Gerostathis Th.P., Belibassakis K.A. (2018). “Semi-activated oscillating hydrofoil as a nearshore biomimetic energy system in waves and currents”. Ocean Engineering 154: 396-415. 5. Lyness, J. N. (July 1969). “Notes on the Adaptive Simpson Quadrature Routine”. In: J. ACM 16.3: 483–495. 6. Gander, Walter and Walter Gautschi (2000). “Adaptive quadrature-revisited”. In: BIT Numerical Mathematics 40.1: 84-101. ","authors":"Panagiotis E. Koutsogiannakis, Evangelos S. Filippas, and Kostas A. Belibassakis","topic":"6","file":"1739-4815-1-DR-OK.pdf","bib":"TIDHYD-1739.bib"},
{"paperid":"1741","title":"Wave and hydro integration for remote communities: a break-even analysis","keywords":"Globally, many remote communities suffer from exorbitant electricity costs, a reliance on fossil fuel sources, and ageing energy infrastructure. Electricity costs, up to 10x utility costs, severely handicaps the communities ability to provide reliable basic services, limits opportunities for economic development, and results in migration away from historically, and culturally, significant community locations. Additionally, the reliance on fossil fuel based generation – generally diesel – is often at odds with the communities cultural view points on the interactions between people and place. Finally, the coupled effects of ageing infrastructure and diesel reliance conspire to place these communities as some of the least resilient to the economic and environmental change. With this in mind, many of these communities are actively transitioning their electricity systems to renewable energy resources and technologies to provide a sustainable electricity future, opportunities for economic growth and, hopefully, a harbinger for global change.   While commercial wave and tidal energy projects are still nascent, it is paramount to ensure that; 1) as these communities transition to renewables, the electricity systems they are designing allow for wave and tidal to play a future role in their decarbonization, and 2) that technology and project developers understand the appropriate technology scale (kW) and the economic break-even points for penetration.   On the west coast of Canada, the dependence of remote communities on diesel-based electricity generation is in direct conflict with their wealth of proximate, raw renewable energy resources. Dominant amongst these renewable resources are hydro, wave and tidal energy. This study focusses on the remote community of Hot Springs Cove on Vancouver Island, Canada. Hot Springs Cove are currently developing a small storage hydro system, yet continue to be interested by the opportunities associated with wave energy. As such, this study assesses the temporal compatibility of local demand, hydro and wave resources; the efficiency of the technology choice and scale; and, the system-wide economic break-even point for introducing wave energy, based on diesel mitigation.      The temporal correlation between the community demand and the availability of renewable resources is possibly the most important characteristic when assessing the value proposition for the integration of renewables in a remote community. Both hydro and wave resources have a remarkable positive correlation with the local demand, yet fluctuate significantly between years. This study conducts a scenario analysis to assess the impact of high/low hydro and wave years, differing technology rated capacities on system dynamics, and the associated economics.   As shown in the table, for an average water and wave year, the addition on the hydro system dramatically reduces the communities fuel consumption, electricity related emissions and results in a ~10% reduction in the Levelised Cost of Energy (LCOE). However, the inclusion of wave energy (assuming no cost for the WEC) results in ~ 48% reduction in LCOE. As a result, the break-even performance cost for the WEC technology, based solely on diesel fuel offset is $0.34/kWh*.    ","authors":"Bryson Robertson, Jessica Bekker, and Bradley Buckham","topic":"10","file":"1741-4745-1-DR-OK.pdf","bib":"ECONOM-1741.bib"},
{"paperid":"1744","title":"Effects of turbines deflection over the wake dynamics and turbine performance","keywords":"Marine hydrokinetic (MHK) turbines are developed to harness the energy of currents in tidal channels. Before installing multiple devices in underwater arrays, it is necessary to understand the interactions with the environment and with other nearby MHK turbines. In particular, it is crucial to understand the interactions between turbines and the upstream wakes generated by other devices. This is important to improve the understanding on how hydrodynamics changes can impact structural performance but also how they can change the magnitude and temporal variability of power extraction. In this investigation we analyze the wake properties of a scaled Sabella D10 turbine for different layouts. The spatial configurations include a single turbine, two turbines in tandem, and the later when different attack angles respect to their design position are considered. We perform three-dimensional numerical simulations of these cases using a Blade Element Momentum Actuator Disk (BEM-AD) model for the turbines, coupled with the Detached-Eddy Simulation (DES) approach for the flow. The work presents the characteristics of the mean and fluctuating flow field. We performed a modal analysis to the numerical results using a Proper Orthogonal Decomposition (POD) to study how the flow dynamics in the wake changes between cases. The results of the mean field characterization and modal decomposition, and in particular the spatial and temporal modifications of dominant structures, are presented in terms of the energy effects associated to the selection of different geometrical layouts.      Work supported by Chile’s Marine Energy Research &amp; Innovation Center (MERIC) CORFO project 14CEI2-28228.       ","authors":"Clemente Gotelli, Jorge Sandoval, Wernher Brevis, and Cristian Escauriaza","topic":"6","file":"1744-4744-2-DR-OK.pdf","bib":"TIDHYD-1744.bib"},
{"paperid":"1745","title":"Environmental monitoring at the Fundy Ocean Research Center for Energy (FORCE)","keywords":"The Fundy Ocean Research Center for Energy (FORCE) is Canada’s leading research centre for the demonstration and evaluation of in-stream tidal energy technology. Located in the Minas Passage of the Bay of Fundy, Nova Scotia, Canada, FORCE is designed to support the testing of in-stream tidal energy devices at five subsea ‘berths’ at its pre-consented test site. FORCE does this by providing common infrastructure such as a visitor/operations facility, subsea electrical cables, and connection to the Nova Scotia electrical grid.   Beyond providing the infrastructure for innovative tidal turbine technologies, FORCE also serves a stewardship role through environmental monitoring and public engagement. Since 2009, FORCE has been conducting or facilitating environmental data collection at its test site. Presently, FORCE’s monitoring efforts focus on a series of monitoring projects on lobster, fish, seabirds, marine mammals, and profiling turbine-generated sound. While limited data has been collected in relation to an operating turbine at the FORCE test site, initial findings are being presented and integrated to assess the impacts of tidal power development in the Minas Passage environment.   In 2012, FORCE created the Fundy Advanced Sensor Technology (FAST) program to enhance site characterization, environmental monitoring, and marine operations capabilities in the high-flows of the Minas Passage. The FAST program consists of a series of onshore and subsea monitoring equipment that can be integrated to suit specific research project requirements. Present projects focus on turbulence and wake assessments, fish distribution monitoring, and target identification. The program provides the necessary learnings to support continued improvement in data capture at the FORCE site.         In sum, FORCE’s research and development efforts are crucial components for achieving Canada’s vision of being a global leader in the development of technology and systems that produce environmentally sustainable electricity from the ocean. ","authors":"Daniel J. Hasselman, Melissa E. Oldreive, and James A. Wright","topic":"9","file":"1745-4741-2-DR-OK.pdf","bib":"ENVIRO-1745.bib"},
{"paperid":"1747","title":"Numerical simulation study on the offshore oscillating water column OWC integrated into a floating breakwater using CFD","keywords":"In this paper, hydrodynamic performance on oscillating water column (OWC) as a wave energy converter and a floating breakwater are studied via a 3D and 2D computational fluid dynamics (CFD) modeling. In order to make OWC device more Cost-effective in production and use, compared to other form of wave energy converters, using OWC devices with other offshore or coastal structures such as breakwaters is suggested. In This way, the wave energy can be attenuated to maintain costal structures in harbor zones, and in the same time energy can be gained from the ocean so the costs of producing OWC devices will be reduced through a integrate solution. In this research, first the numerical results of 3D model of OWC chamber with parabolic side walls are investigated then 2D numerical model are studied to analyze the performance of OWC as a floating breakwater to do that different types of OWC models analyzed. In the model, Finite volume method has been used and the continuity and momentum equations were selected as the governing equations .  Shear Stress Transport (SST) k-omega turbulence model is implemented to the Reynolds Stresses in RANS equations due to the high amount of turbulence in this system Also, interaction between water and air is analyzed with the Volume of Fraction (VOF) method. Finally, according to the numerical models the best model is selected due to the damping of the waves and its performance.   Renewable energy is an urgent matter in the world. Due to the reduction of fossil fuels and many irreversible harms they may cause, investigation in this industry and finding alternative sources of energy can be convenient. Wave energy could be a good fit. Among the different techniques used for wave energy converters, the Oscillating Water Column (OWC) devices stand as one of the most promising ones. In addition, its inherent simplicity is presumably the greatest advantage of OWC as a wave energy convector device which can generate sustainable energy, therefore using OWC devices can be convincing in many countries.   The Structure of OWC devices consists of a large chamber, one end is open to the sea, and the other leads into a orifice, when a wave approaches the device water is forced into the chamber, applying pressure on the air, already trapped inside the structure. As a result of this huge pressure the air escapes to atmosphere through the turbine on the other side of orifice, thereby producing electricity. When the wave retreats and the water surface level falls, the air from the outside the orifice is sucked back in to the chamber. As the water surface level inside the chamber moves up and down, it compresses and decompresses the air, respectively.as a result, electricity continues to be generated.  One of the goals of the present project is to promote the use of this device by increase the hydrodynamic performance of OWC devices integrated into a breakwater. So further investigation such as numerical (CFD) modelling need to be done to consider all challenges.","authors":"Madjid Ghodsi Hassanabad, Mojtaba Shegeft ","topic":"5","file":"1747-4836-2-DR-OK.pdf","bib":"WAVHYD-1747.bib"},
{"paperid":"1750","title":"Wake dynamics in a six-bladed horizontal axial turbine through a coupled DES-Actuator Lines Model","keywords":"The interaction between Marine Hydrokinetic (MHK) devices and the flow developed in tidal channels produces turbulent wakes with complex hydrodynamics. These flows are characterized by the presence of large-scale coherent structures of different temporal and spatial scales with a high rotational component induced by the turbines operation. These interactions have an important influence on the surrounding environment in many key aspects, i.e. local flow conditions, sediment transport, ecosystem dynamics, submarine noise, among others. Furthermore, wake interactions among devices in turbine arrays play a significant role in energy extraction performance. In order to study the complex phenomena associated to the wake dynamics and their implications, numerical simulations are a necessary tool to assess the dynamics of the flow, providing detailed information and supporting a wide range of application cases. This study presents a numerical investigation of the wake developed behind a Sabella D10 device using a coupled model: the flow is solved through a Detached-Eddy Simulation (DES) model, whereas the turbine is represented in the flow through an Actuator-Lines Model (ALM). The advantage of coupling these models is the combination of two relevant features: (1) a detailed representation of the turbulent flow through a resolved coherent dynamics approach; (2) the rotational effects of turbine blades on the local hydrodynamics incorporated as a body force on the flow. This combined scheme can be carried out with relatively low computational costs, and allows to study both the axial and helicoidal vortical structures, and their interaction processes for different turbines arrays.The study cases correspond to the experiments developed by Gotelli et al (2018) using scaled devices in an erodible channel for three different configurations: (1) a single turbine, (2) a two turbines array in tandem separated by six diameters and (3) a two turbines array in tandem separated by ten diameters. In this work, we seek to further the understanding of the hydrodynamic mechanisms that govern the wake evolution, specially focused on the large-scale coherent structures dynamics. Finally, this work seeks to elucidate some key aspects about the effects of the wakes interaction for different separation conditions and their influence in the surrounding flow and energy extraction performance.Work supported by Chile’s Marine Energy Research &amp; Innovation Center (MERIC) CORFO project 14CEI2-28228. Powered@NLHPC: This research was partially supported by the supercomputing infrastructure of the NLHPC (ECM-02) Gotelli, C., Musa, M., Guala, M. &amp; Escauriaza, C. (2018). Experimental and Numerical Investigation of Wake Interactions of Marine Hydrokinetic Turbines. Ocean Engineering, (under revision).","authors":"Jorge Sandoval, Cristian Escauriaza, and Clemente Gotelli","topic":"6","file":"1750-5023-1-DR-OK.pdf","bib":"TIDHYD-1750.bib"},
{"paperid":"1756","title":"The environmental effects of utilising tidal current energy devices for energy output","keywords":"Energy extraction using marine energy devices offers a sustainable alternative to conventional sources. The use of tidal current turbines to output energy will bring changes to the environment in which they are installed. Moreover, it is expected that the operation of tidal current turbines will potentially affect marine mammals and the marine environment. The primary focus of this work is to identify the effects of an operational tidal current turbine on the surrounding ecosystem. A number of authors have claimed that anthropogenic noise (offshore human activities) in the ocean has the potential to alter the interaction of marine species with their environment, this can compromise the mediation of important ecosystem properties. Furthermore, this is of particular relevance to the installation and operation of tidal current turbines. Tidal current turbines, much like wind turbines, emit noise during operation; however, there is an insufficient number of studies in this domain to quantify any significance effects.   Hydro-acoustic modelling of marine energy devices is paramount to comprehend how marine mammals and their environment may be affected. This paper will present a detailed description of a number of the most significant tidal current turbine operational aspects that may potentially influence the marine environment, such as blade strike modelling, swirl characteristics in the tidal current turbine’s wake, cavitation modelling, water pressure variation, noise generation, etc. This work will assess how these tidal current turbine performance parameters impact on the marine environment. The aim of this paper is to set out a modelling technique suitable to predict the environmental effects of tidal current turbines. Importantly, developing suitable detailed models for hydro-acoustic prediction at a tidal energy site will be crucial to further technological development. This key work will enable improvements in the design and performance of tidal current turbines while preserving the surrounding marine life ecosystem. ","authors":"Qui R. See, Sinead Kelly and Fergal O’Rourke ","topic":"9","file":"1756-4708-2-DR-OK.pdf","bib":"ENVIRO-1756.bib"},
{"paperid":"1757","title":"Energy and carbon audit of a tidal array equipped with an innovative power take-off","keywords":"If wave and tidal energy devices are to become a significant contributor to the electricity generation mix, their environmental impact and energy and carbon footprints need to be added to the traditional techno-economic assessment. This paper presents the life cycle carbon and energy study of an array of ten tidal stream turbines equipped with the innovative power take-off developed, built and tested under the European H2020 project TiPA. A  ‘cradle-to-grave’  evaluation was performed, taking account of all energy inputs and CO 2  emissions in the fabrication, transport, installation, lifetime maintenance and decommissioning (including recycling). The calculated energy and carbon intensities were at 445 kJ/kWh and 29.2 g CO 2 /kWh, respectively. Under relatively conservative assumptions, the energy payback period for the simulated array was calculated at 30 months, while the carbon payback period was 25 months. The obtained results on intensities and payback periods were found to be competitive with those of existing studies on alternative marine energy concepts, and low relative to the conventional nuclear or fossil-fuelled generation. Given the early developmental stage of the technology, these results are promising, and could be further improved by considering alternatives to steel as a structural material or by improving the environmental performance of the foundation element. ","authors":"Miguel Santos-Herran, Encarni Medina-Lopez, Lindsey Entwistle, Henry Jeffrey","topic":"9","file":"1757-4072-2-DR-OK.pdf","bib":"ENVIRO-1757.bib"},
{"paperid":"1758","title":"The Effects of Inflow Turbulence Intensity on predicting wake velocity in a two-dimensional RANS-Actuator disc model","keywords":"The advancement and improvement of new and efficient techniques to meet the ever-increasing demand on energy for economic and social development are of significant interest. The electricity demand is expected to increase over the coming years to deal with the growing demands, such as electric vehicles and heating systems. Renewable energy technologies offer an appealing option to supply this growing demand for electricity, while also assisting with the European Union’s sustainability policy theme. Tidal current turbines are becoming a competitive and promising option for renewable electricity generation as, for example, more than half of Ireland’s population live within 20km from the coast. Furthermore, tidal energy is a relatively untapped energy resource, with only a small number of full-scale turbines in operation. Tidal current turbines offer an exciting method of energy extraction as tidal current energy is highly predictable over long time periods compared to most other renewable energy resources, making it an excellent option as a base-load energy supply. However, tidal current energy is still in an early stage of development, with a huge number of significant operational, performance and economic issues still to be addressed and in particular, the interaction between devices in large-scale arrays. Therefore, the optimisation of single and multi-device arrays of tidal current turbines is paramount.   This work focused primarily on modelling techniques and methodologies to assess and optimise the hydrodynamic performance of tidal current turbines in large-scale arrays based on wake investigations using computational fluid dynamics (CFD). The flow field characteristics in the wake of an isolated tidal current turbine and turbine arrays of up to five devices were investigated by numerically solving the Reynolds Averaged Navier Strokes (RANS) equations in simulations using a CFD solver. This CFD model utilised the actuator disk approach to simplify the wake effects of a tidal current turbine and this approach greatly reduces the computational cost. The velocity and turbulence characteristics from the model were compared to experimental and numerical models presented in the published literature. The paper will also present findings of investigating the effects of various array configurations and conditions, such as staggering effects and yawing conditions. In future work, the model will be applied to a real site to predict the suitable array arrangement to achieve optimal power output. ","authors":"Chee M. Pang, David M. Kennedy, and Fergal O’Rourke ","topic":"6","file":"1758-4677-2-DR-OK.pdf","bib":"TIDHYD-1758.bib"},
{"paperid":"1759","title":"Tidal current turbine evaluation using blade element momentum theory and computational fluid dynamics","keywords":"Interest in renewable energy has continued to grow steadily over the past years as various forms of energy conversion technologies are developed. Furthermore, this technological development has been initiated by the ever-growing demand for energy and the effects of climate change and carbon emissions. There are a large number of renewable energy technologies at an early stage of development, such as tidal energy. Regarding tidal current turbine technology, a number of projects have been developed with largely positive results. However, it is still some years behind established renewable energy technologies such as wind energy, solar energy, hydro energy, etc.    There may be numerous reasons for the slow realisation of commercial projects, but it could be as a result of a non-consensus on the technology. The potential of tidal energy however is enormous with numerous highly energetic sites worldwide. Additionally, tidal energy has the advantage over most other renewable energy types as it is predictable over large time-scales.     This work investigated the design and evaluation of a tidal current turbine device. Initially, the tidal current turbine rotor was designed using corrected Blade Element Momentum (BEM) Theory. A graphical user interface (GUI) design tool was generated to incorporate the design method and this provides turbine performance details. The GUI design tool includes user inputs, such as the fluid parameters, number of blades, rotor parameters, aerofoil data, etc., whilst the output from the design tool includes the generated shape of a suitable tidal current turbine rotor for a real site. The result of the performance criteria, such as power, thrust, etc., are outputted. The generated profiles of the optimised tidal current turbine blade can be exported in point cloud format to allow post processing of the designed data. The profile of the optimised blade was thoroughly evaluated using a combination of a potential flow solver and computational fluid dynamics (CFD). The full three-dimensional effects of the fluid flow field can also be investigated using CFD and will be validated using experimental measurements obtained from the literature. The fluid interaction of the generated tidal current turbine rotor will be the primary focus of this project.  ","authors":"Eng J. Yeo, David M. Kennedy and Fergal O’Rourke","topic":"6","file":"1759-4721-2-DR-OK.pdf","bib":"TIDHYD-1759.bib"},
{"paperid":"1760","title":"A high-resolution operational system for the forecasting of sea state in the Mediterranean and the Black Sea for energy harvesting","keywords":"A high-resolution regional ocean circulation model of the Mediterranean Sea-Black Sea system (MITO) has been developed and tested, and is currently being run in operational mode. The model explicitly includes the effects of the main components of the astronomical tides and is therefore capable of providing valuable information on the best suitable sites for tidal energy exploitation in the basin. The model achieves a uniform resolution of 1/48° (about 2 km) over most of the domain, increased to a few hundred meters in correspondence of the Straits of Gibraltar, Dardanelles and Bosphorus, in order to correctly resolve the local dynamics. Higher resolution projections can be obtained by performing local nested simulations with a model configuration specifically tailored to the end-users’ needs. Operative wave forecasts complement the ocean circulation projections, providing basin-wide information on wave parameters at 1/32° resolution, which is further increased to 1/124° over interesting areas along the Italian coast.  The integrated system MITO + Wave Model represents an invaluable instrument for the design, testing and operative management of marine energy converters in the Mediterranean. ","authors":"Gianmaria Sannino, Andrea Bargagli, Adriana Carillo, Roberto Iacono, Emanuele Lombardi, Ernesto Napolitano, Massimiliano Palma, Giovanna Pisacane, and MariaVittoria Struglia","topic":"6","file":"1760-4829-2-DR-OK.pdf","bib":"TIDHYD-1760.bib"},
{"paperid":"1762","title":"Site selection for scaled open water testing of a wave energy converter","keywords":"Many WEC developers opt to carry out scaled prototype open water testing (SPOWT) of their device as part of their technology development. WEC developers who have done this recently include: AWS Ocean Energy (1/10 scale, Loch Ness, 2010), Sea Power (1/5 scale, Galway Bay, 2017), CorPower (1/4 scale, EMEC, 2018) and Marine Power Systems (1/4 scale, FaBTest, ongoing).   The developers progressing to Stage 3 of Wave Energy Scotland’s novel wave energy converter (NWEC) programme will carry out SPOWT in 2020.  In preparing for Stage 3 Wave Energy Scotland has considered criteria and methods for selecting a suitable SPOWT site in detail and this is discussed in this paper.   SPOWT offers several benefits:   •             Testing at a larger scale than is possible in many wave tank facilities.   •             Inclusion of more accurate/representative realisations of sub-systems (e.g. power take-off, mooring).   •             Ability to identify and resolve technological issues associated with scaling-up.   •             Demonstration of buildability and experience of marine operation procedures.   •             Lower cost, both manufacturing and operational cost, and risks than progressing directly to commercial-scale testing.   The approach for identifying a suitable SPOWT site is similar, in many ways, to that for identifying a commercial-scale test site or commercial project site. In common with commercial scale test site identification, SPOWT site identification is subject to:   •             Operational considerations: Proximity to suitable quayside facilities. [a more frequent return to base requirement]   •             Time and funding constraints.   •             The need to match the available resource, as best as possible, to a device’s power matrix and potentially also extreme sea states if survivability is also to be assessed.   The last two requirements are further complicated in the SPOWT case by the need to find a site where the commercial scale device’s power matrix and other sea states of interest (at the SPOWT scale) are reasonably likely to occur a useful number of times for prototype testing over the duration of the intended testing campaign and at a depth which is (at the SPOWT scale) comparable to the commercial scale device’s deployment depth.   Even in commercial scale site identification these requirements contradict each other and these contradictions are intensified by the additional SPOWT requirements. As a result, selection of a SPOWT site requires a pragmatic attitude (accepting that not all requirements can be perfectly met) and a clear acknowledgement of what intended test outcomes are achievable from testing.   For example, it might be necessary to test at multiple sites to achieve objectives relating to operational sea states (e.g. performance measurements) and/or survival sea states or to complement SPOWT with further small-scale wave tank testing.  The paper will discuss in greater detail the challenges of identifying a suitable site for SPOWT of WECs and pose some, to the best of the authors’ knowledge, unanswered questions on the best way to do this.","authors":"Niall D. McLean, Matthew A. Holland, Ruairi D. Maciver and Elva B. Bannon","topic":"3","file":"1762-4867-1-DR-OK.pdf","bib":"WAVDEV-1762.bib"},
{"paperid":"1764","title":"Optimisation of Tidal Lagoon using  Genetic Algorithm ","keywords":"Marine Renewable Energy, including tidal renewable energy, is one of the less exploited sources of energy which could contribute to energy demand, while reducing Green House Gas emissions. Amongst several proposals to build Tidal Range Structure (TRS) as shown in Figure 1, a tidal lagoon has been proposed to be constructed in Swansea Bay [1], in the South West of the UK. Although the scheme received positive feedback from an independent review [2], it did not get the UK government support due to the high electricity costs [3]. This reemphasis the importance of optimisation of such schemes for future projects.            Fig. 1 Lagoons proposals of TRS in the Severn Estuary and Bristol Channel (from Google Map).        This paper focused on facilitating the development of TRS by using an improved Genetic Algorithm (GA) model instead of common Grid Search (GS) method which has traditionally been used for optimizing the schemes. The GA model splits the operation of TRS into single tidal cycle and optimise the operation of TRS through the process of mutation, recombination and selection, which create the new schemes [4, 5]. The GA model which takes the 0-D approach as fitness functions was established and developed with a proposed Sequential Mutation Method (SMM) and two recombination methods, namely Linear Recombination Methods (LRM) and Ring Recombination Methods (RRM) [6, 7], respectively. The performance comparisons between LRM and RRM in terms of energy outputs were analysed, which proved that the RRM revealed an enhanced efficiency because of its higher convergence speed than the LRM. The optimised operational scheme using GA was in consist with the scheme utilising the GS method, as shown in Figure 2, with an approximately 10% increase of the energy generation, comparing to the fixed head schedule. It should be noted that the cost-time of the GA model could be dramatically reduced because of the parallel programming, in comparison with the GS method.           Fig. 2 Optimised operation heads comparison between the GS and GA models.   References   [1]       C.Hendry, The Role Of Tidal Lagoons, Sep.2016, Available: https://hendryreview.files.wordpress.com/2016/08/hendry-review-final-report-english-version.pdf.   [2]       S. Waters and G. Aggidis, A World First: Swansea Bay Tidal lagoon in review, Renewable and Sustainable Energy Reviews, vol. 56, pp. 916-921, 2016.   [3]        BBC. (2018). £1.3bn Swansea Bay tidal lagoon project thrown out. Available: https://www.bbc.co.uk/news/uk-wales-south-west-wales-44589083   [4]       S. R. Ladd, Genetic Algorithms in C++. Hungry Minds, Incorporated, 1995, p. 384.   [5]       J. R. Koza, Genetic programming as a means for programming computers by natural selection, Statistics and Computing, journal article vol. 4, no. 2, pp. 87-112, June 01 1994.   [6]       M. B. Nia and Y. Alipouri, Speeding Up the Genetic Algorithm Convergence Using Sequential Mutation and Circular Gene Methods, in 2009 Ninth International Conference on Intelligent Systems Design and Applications, 2009, pp. 31-36.   [7]       S. B. A. Bukhari, A. Ahmad, S. Auon Raza, and N. Siddique, A ring crossover genetic algorithm for unit commitment problem. 2016, pp. 3862 – 3876. ","authors":"Jingjing Xue, Reza Ahmadian, and Owen Jones ","topic":"6","file":"1764-4936-1-DR-OK.pdf","bib":"TIDHYD-1764.bib"},
{"paperid":"1766","title":"In?uence of grid resolution and bottom roughness on tidal resource characterization in Chacao channel, Chile ","keywords":"The resource characterization of tidal currents is of great importance for Marine Renewable Energy (MRE) devices implementation, to estimate the potential in specific sites. The estimation of current magnitudes and directions during tides are the most important features, which are mainly driven by the bottom friction, the tides and the bathymetry. Another interesting feature but is the nonlinear interactions between the tidal flow and the bottom non-uniformity, that leads to vorticity and residual eddy formation, that can affect MRE devices at larger scales. In our study, we focus on the Chacao channel, located in southern Chile, which is considered an energetic tidal channel due to its high tidal range and phase-lag, leading to strong currents of order 4 m/s. This is one of the most energetic areas in terms of tidal currents in Chile, which has been shown by a previous study (Gueraa et al., 2017)   The tidal channel is modeled using the Finite Volume Coastal Ocean Model (FVCOM) (Chen et al., 2003) on an unstructured grid, with tidal harmonic forcing. Using the Polymesh mesh generation tool, which allows to refine explicitely some areas using bathymetric gradient paremeters, and bathymetric data from nautical charts and a multibeam campaign, we intend to compare the error magnitude in terms of grid resolution of the unstructured triangular mesh and bottom roughness. The numerical model are compared in terms of tides and currents using data from 6 ADCPs and 6 Tidal Gauges that were put in place in the area for 45 days. The interest of this study is to assess the needs in terms of grid resolution and bathymetric data for accurate resource estimation in real tidal channels.  <img src=data:image/png;base64,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","authors":"Leandro Suarez Atias, Cristian Escauriaza, and Felipe Lucero","topic":"2","file":"1766-4746-2-DR-OK.pdf","bib":"TIDRES-1766.bib"},
{"paperid":"1768","title":"Resource Assessment for the GEMSTAR Tidal Current Energy Harvester Deployment in the Strait of Messina","keywords":"The paper concerns the present collaboration of a tidal technology developer, Seapower, with a global EPC contractor, Saipem. The two players will install a hydropower turbine in the Messina Strait for electricity energy generation tapping the strong tidal flow energy available there. This paper will focus on the survey campaign performed to identify the most suitable locations, on the data analysis and on the prediction of the device performances from measured and predicted tidal stream velocities. An economic analysis showing the bankability of the project will also be provided.  The GEMSTAR system comprises two horizontal axis marine turbines designed to be driven by slow moving flows of water, namely tidal, marine or river currents. It is a submerged floating moored device which has the least impact on the natural environment with respect to other technologies. The GEMSTAR can be easily lowered at its operating depth and risen to surface for periodic maintenance operations. It is stable in all circumstances and it aligns itself to the different flow directions. Thanks to its design, it is also easily transportable, and it needs a short time to be deployed and recovered for maintenance purposes making O&amp;M costs particularly low.  Given the great tidal energy resource, the Strait of Messina is the most attractive area in Italy where to install tidal turbines. A proper characterization of the available resource is a fundamental step for the preliminary sizing of tidal energy device and for the estimation of the annual energy production. After a preliminary survey in the strait, a set of experimental data has been retrieved. Data for a short period were acquired at a specific site close to Punta Pezzo, a location with the highest peak velocity in the strait. The gathered data concerns the velocity profile from seabed to surface as a function of time. This gave useful information for site assessment purposes. After characterizing the installation site, the device size was optimized and, through a performance prediction model based on empirical data, financial figures have also been calculated.  The paper will also present the advantages of the collaboration between the two actors involved in the development of the project, of which one is active in applied research and the other is a large company entering the world of the marine renewable energy system transferring its large experience gained in offshore engineering to the project, with particular attention to manufacturing, transportation from fabrication yard to site, deployment and general management of the project development as well as promoting the device to utilities and final users. The engineering support of Saipem will be also addressed to the optimization of the mooring device system since a vast experience has been accumulated over the years on the installation, operation and maintenance of different types of anchoring solutions. Saipem support will also be valuable for the development of tidal energy projects, since it will take care of all responsibilities, de-risking the project and increasing profitability. ","authors":"Francesco Balestrino, Domenico P. Coiro, Gianmaria Giannini, Dario Giudice, Giancarlo Troise ","topic":"2","file":"1768-4973-1-DR-OK.pdf","bib":"TIDRES-1768.bib"},
{"paperid":"1769","title":"Fault analysis of a marine current vertical-axis turbine missing two blades","keywords":"Results are presented from a vertical axis turbine used formarine current energy conversion. If the turbine is not directly connected to a load after it has been started, the rotationalspeed will overshoot before settling at the free-spin rotationalspeed. This is called runaway for the turbine and is describedin [1]. During runaway the forces on the turbine blades canreach up to two times the forces during nominal operation[2]. On two occasions the turbine has broken during startup,where several blades were deattached from the struts. Thispaper presents experimental results of the fault of the turbineduring startup.The converter was deployed on the river bed in the riverDal (Dal¨alven) in S¨oderfors, Sweden, during the spring of2013 [3]. The energy converter is a Permanent Magnet SynchronousGenerator (PMSG) connected directly to a VerticalAxis Current Turbine (VACT) with five fixed-pitch blades, see Fig. 1. The turbine and generator are controlled electricallyusing the electrical system placed in a measurement cabin,located onshore close to the river. The power and energynecessary during the startup sequence has been investigatedin [4].  REFERENCES  [1] S. Lundin, A. Goude, and M. Leijon, “One-dimensional modelling ofmarine current turbine runaway behaviour,” Energies, vol. 9, no. 5, pp.309–1–16, 2016.  [2] A. Goude and S. Lundin, “Forces on a marine current turbine duringrunaway,” International journal of Marine Energy, vol. 19, no.doi.org/10.1016/j.ijome.2017.09.007, pp. 345–356, 2017.  [3] S. Lundin, J. Forslund, N. Carpman, M. Grabbe, K. Yuen, S. Apelfr¨ojd,A. Goude, and M. Leijon, “The S¨oderfors project: Experimental hydrokineticpower station deployment and first results,” in Proceedings of the10th European Wave and Tidal Energy Conference, EWTEC13, Aalborg,Denmark, 2–5 September 2013.  [4] J. Forslund, K. Thomas, and M. Leijon, “Power and Energy needed forstarting a Vertical Axis Marine Current Turbine,” in Proceedings of the12th European Wave and Tidal Energy Conference, EWTEC17, Cork,Ireland, September 2017.    ","authors":"Minh Thao Nguyen, Johan Forslund, Karin Thomas, and Anders Goude","topic":"4","file":"1769-4673-2-DR-OK.pdf","bib":"TIDDEV-1769.bib"},
{"paperid":"1771","title":"From France to the Philippines: pioneering tidal stream energy","keywords":"San Bernardino strait is a narrow passage on the north-eastern side of the Philippine archipelago, separating the main islands of Luzon and Samar. With speeds reaching over 3 m/s during spring tides, this strait has a high potential for tidal stream energy converters. The area discussed in this paper is one of the four channels located between the islands of Capul and San Antonio.   In 2013, the Department of Energy awarded three leases for ocean energy harnessing to H&amp;WB, Filipino energy project developer. H&amp;WB partnered with SABELLA, French marine current technology developer, in October 2015 with the signature of a Memorandum of Agreement. The aim is to develop the Philippines’ first commercial ocean power plant deploying tidal stream turbines, based on H&amp;WB’s project development experience and SABELLA’s extensive technical expertise based a real field experience acquired with the full-scale turbine D10 in 2015 and 2018.   The first phase of the project, a 5MW pilot farm to be deployed off Capul Island by 2021, will feature SABELLA’s field-proven tidal turbine and onshore batteries for storage. The goal is to provide a reliable supply of clean power to this off-grid area and replace the costly and polluting diesel generators the island currently relies upon.   The project in Capul is backed by SABELLA’s field experience gained with the D10 project, featuring a 1MW turbine, first deployed for one year in 2015-2016 in the Fromveur strait and grid-connected to the island of Ushant, France, demonstrating the feasibility of an energy mix including tidal power. The D10 turbine was redeployed in October 2018 for a 3-year operation period, and has been generating and injecting power into the grid ever since.   A focus will be made on the similarities between the two projects, and how SABELLA’s tried and tested technology fits the needs of the population in Capul.   Then, this paper will present the development steps and the progress, from the feasibility study to the preliminary front-end engineering design carried out, preceding detailed engineering, construction and installation works. Steps described in this paper include: project planning in coordination with the DOE, fine resource assessment and detailed yield estimation (with in situ measurements acquired during bathymetric campaigns and ADPC deployments), basic design based on D10 proven technological principles, environment initial state study and impact assessment, permitting and social acceptation.   Finally, the technical, economic, social and environmental stakes of the project will be highlighted:    development and viability of an insular energy model based on tidal power generation in the Philippines, based on the return on experience gained with the D10 demonstration project, carried out in Ushant, France;  adaptation of the D10 technological principles to a turbine specifically designed to fit the site characteristics of San Bernardino Strait;  decarbonization of Capul‘s energetic mix  improvement of the energy security and cost competitiveness, economic development with a 24-hour reliable electricity access;  environmental and social acceptation of marine renewable energy project in the Philippines;  envisioned large-scale deployment.  ","authors":"Jean- Cristophe Allo","topic":"4","file":"1771-5049-1-DR-OK.pdf","bib":"TIDDEV-1771.bib"},
{"paperid":"1774","title":"Effective offshore operations in strong tidal currents locations","keywords":"Sabella D10 tidal turbine was immersed in the Fromveur Passage in June 2015, becoming the first and only full scale tidal turbine to inject electricity to the French grid. After one year of demonstration, SABELLA retrieved the turbine in order to gain return on experience, before putting her back in water in October 2018 for three more years.   The initial installation operation was performed by lowering the whole tidal turbine at once, including the gravity-based foundation and ballasts, using a standard heavy-lift vessel, without dynamic positioning, kept in position by two anchors and three tugs. The installation was partially successful, with the need for another operation for the connection between the cable jumper and the export cable, previously installed.   For the retrieval operation, only the turbine, a much lighter package, was lifted, the foundation and the export cable remaining at sea. Another kind of vessel, with dynamic positioning, was used. This proved to be much more reliable and safer, perfectly adapted to this kind of operations. A smaller DP vessel, with a smaller crane, was used for the turbine’s reinstallation operation.   Specific procedures and tools had to be developed for these operations. An offshore berth, allowing safe laying of the turbine on the vessel’s deck and transportation, had to be designed and constructed. A hydraulic tool to lift and relay the turbine from the structure also had to be designed and built. This “LARS” (Launch And Recovery System) is made of a frame fitting the nacelle and four grommets, activated by hydraulic actuators and closing around the lifting trunnions located on the nacelle. The difficulty in this tool’s development was to design it while the turbine was immersed, making it impossible to check any dimension, and no guiding system was placed on the turbine. Everything was perfectly managed and these tools enabled to recover safely the turbine and to reinstall her on her foundation, validating and strengthening SABELLA’s modular technology.   Another operation was performed in end of August 2017, in order to install a new connector at the end of the export cable. This operation was again carried out using a DP vessel, with lower lifting capacities as no heavy lift had no be performed. The specificité of this operation is that the vessel had to keep perfectly her position during more than 48 hours with the cable hanging, while the connector was being installed. This was possible thanks to a good choice of vessel, a perfect planning of operations and a good management onboard.   For the turbine’s reinstallation operation, the vessel dimensions and the crane capacities were the minimum needed for the operation regarding the turbine’s weight and dimensions. The preparation of the operations, the detailed engineering and the deck layout preparation were thus even more crucial for a successful operation.   All these innovative tools and methods bring costs reduction perspectives thanks to the use of smaller vessels, with lower lifting capacities, and to shorter operating time, with adapted tools, detailed engineering and well-prepared procedures.    ","authors":"Diane Dhomé, Aude Cessou, Jean-Christophe Allo","topic":"11","file":"1774-5070-1-DR-OK.pdf","bib":"OPANDM-1774.bib"},
{"paperid":"1783","title":"WaveSPARC: Evaluation of Innovation Techniques for Wave Energy","keywords":"The WaveSparC project includes invention, assessment, indification, verification and validation of novel and high techno-economic potential WEC technology concepts that will deliver high confidence seeds for subsequent industrial development to full commersial application and economic viability.  The WaveSPARC project has via Structured Innovation derived several new idears for WEC concepts. The concepts have been evaluated using a TPL assessment methodology developed as part of the project. At this stage the idears for WEC concepts that have been assessed has not yet reached the desired high TPL score to justify the build and tested in model scale.  This paper provides a critical review of the innovation process used. The initial approach includes a specification of requirements for the WEC, selection of critical subfunctions and then using the inventive technique TRIZ to find new and innovative subfunction solutions combined into new WEC designs. The learning from this initial approach will be described. The second approach took an existing WEC concept with high, TPL as a startingpoint - and then Applied TRIZ to improve sub functions with identified low TPL sub score. TRIZ is about finding contradictions and it appears that some contradictions are universal and apply to all WECs and some contradictions are WEC archetype specific.  Finally, alternative invention paths and tools are described. This includes the Whole System Analyses Tool (WSTAT) which supports the system engineering technical management process of decision analysis by identifying compromises, revealing opertunities, and communicating the impacts of decisions across a system's development lifecycle. Quality Function Deployment (QFD) a structured approach defining requirements and translating them into specific plans to produce products to meet those needs. The voice of the customer term to describe the stated and unstated customer needs or requirements. The decition-matrix method, or the Pugh Concept Selection, a qualitative technique used to rank the muliti-dimensional options of a set of options. The Set-Based Design process to encourage optimal convergence in WEC design and the gradual elimination of weaker concepts, as opposed to incremental improvement, which Oregon State University also part of the WaveSPARC project is working on will be described. ","authors":"Ronan Costello, Kim Nielsen, Jochem Weber, Nathan Tom and Jesse Roberts","topic":"3","file":"1783-5039-1-DR-OK.pdf","bib":"WAVDEV-1783.bib"},
{"paperid":"1787","title":"Environmental impacts of marine renewable energy infrastructures: what can we learn from the wind energy sector experience? ","keywords":"Ocean renewable energy sources are increasingly attractive in the perspective of satisfying the worldwide demand of clean energy. Research efforts have been increasing on the side of the technological development, however several non-technical barriers still need to be overcome. The most significant of these non-technical barriers is the necessity to comply with the EU Environmental Impact Assessment (EIA) Directive and associated national legislation, which requires regulatory authorities to make an informed decision on the proposed project and its potential environmental impacts at an early stage. The potential effects of the ocean renewable energy sector on marine ecosystem have been comprehensively discussed and include effects on nearshore intertidal and benthic habitats, fish, fish habitats, large marine vertebrates (sea birds, marine mammals and large fish), oceanographic and coastal processes. However, due to the novelty of wave and tidal energy device deployments, most of these discussed effects and impacts are just potential and not yet validated through observations, being the global picture still poorly known. On the other hand, being the offshore wind energy sector the most mature among all the ocean renewables, it is not a surprise that a growing number of offshore wind-related environmental studies are being conducted. Moreover, either the experience gained during the first EIA procedures for offshore wind farms, either the data made available from the environmental monitoring at the offshore wind farm sites, which now has been conducted for several years, have many lessons to teach to the less mature ocean renewable sectors. In the presented review the results from environmental monitoring conducted over several years at some wind farm sites are presented. The monitoring studies which have been considered in this review show limited and local impacts on the environment, either during their construction and during the operational phases. However, it is still open the question whether several little and locally related impacts may determine any biologically significant consequence at the population level. Notwithstanding, we believe that some key lessons can be learned from the wind energy sector experience as far as their implications for the other ocean renewable are concerned. Particularly, we believe these studies may give significant insights for similar monitoring studies, such as: 1) the area over which biological effects may occur, 2) the measured responses to marine renewable energy infrastructures construction and operation in terms of both positive and negative effects concerning different target organisms; 3) the effectiveness of mitigation measures (i.e. recovery over the years). As the number and size of ocean renewable energy developments will increase, there will be a growing need to consider the population level consequences and cumulative impacts of these activities on marine species. Still general recommendations may be drawn across the offshore wind farm sector, which might be relevant also for the future monitoring of other marine renewable energies.   ","authors":"Arianna Azzellino, Caterina Lanfredi","topic":"9","file":"1787-5053-1-DR-OK.pdf","bib":"ENVIRO-1787.bib"},
{"paperid":"1794","title":"Experimental assessment of a fixed Oscillating Water Column coefficients as a damped harmonic oscillator","keywords":"During experimental test campaigns, it is important to estimate the quality of the numerical methods developed during the design stages of a wave energy converter. One of the most used methods for this purpose is to measure the diffraction and radiation forces experimentally. The present work addresses the experimental assessment of fixed Oscillating Water Column (OWC) coefficients as a damped harmonic oscillator. This work is a first step for the complete experimental assessment of the radiation force impulse response function of that OWC. The experimental setup consists of a simplified two-dimensional geometry of a fixed OWC in a 12.5 meter long wave flume. The top of the OWC is initially closed and the air chamber is depressurized with respect to the atmosphere, raising water column to certain decay height. Afterwards, the OWC top cover is suddenly opened, column is dropped, and the motion of the oscillating water surface is recorded. Fitting the solution curve to a damped harmonic oscillation equation, its coefficients are calculated. The results are to be compared with a numerical model using SeaFEM software potential flow solver.  ","authors":"Iñigo Bidaguren, Iñigo Albaina, Iñaki Zabala, Alvaro Gómez, Juan C. C. Portillo, Jesús María Blanco and João C. C. Henriques ","topic":"3","file":"1794-4931-1-DR-OK.pdf","bib":"WAVDEV-1794.bib"},
{"paperid":"1796","title":"Overview on the installation of a U-Oscillating Water Column breakwater in the Port of Salerno","keywords":"This article describes the characteristics of a U-Oscillating Water Column plant, named also ReWEC3 (REsonant Wave Energy Converter), that will be installed in the Port of Salerno (Italy). The objective of the infrastructure is to enlarge the port basin area by taking advantage of the most recent developments in the field of caisson breakwaters. A general overview on the geometrical characteristics of the plant is given in conjunction with a description of its introduction in the existing port layout. Next, an example of expected plant performance is described by utilizing relevant Monte Carlo data. The article shows that the plant may absorb about 60-80% of the incident wave energy is certain sea states that available in the location under study. ","authors":"Felice Arena, Alessandra Romolo, Giovanni Malara, Valentina Laface, Elena Valentino, Francesco Messineo","topic":"3","file":"1796-5018-1-DR-OK.pdf","bib":"WAVDEV-1796.bib"},
{"paperid":"1797","title":"Hydrostatic Stability of Floating Oscillating Water Columns ","keywords":"Oscillating water columns (OWC) that are integrated to existing structures (e.g. breakwaters) or fixed to seabed have been shown to be effective wave energy conversion systems. Floating OWC have recently been studied from the viewpoint of design optimization and increasing efficiency. The floating variants provide the ability to deploy OWC systems in varying water depths, and can improve versatility while maintaining minimum disturbance to the sea floor.   The air chamber within a floating OWC is similar in many ways to an air cushion used in offshore applications. For the case of a concrete gravity sub-structure used for oil and gas production, air cushions are located within skirted base compartments to artificially lighten the structure during tow-out. The air cushion is sealed by a “water plug” so as to prevent air egress into the open water. The air chambers affect the overall hydrostatic stability in many ways, and can even provide favorable consequences at different length scales which arise due to the fixed value of the atmospheric pressure.  In this paper, we use first principles to obtain the restoring moments for a generic floating oscillating water column system with single or multiple compartments.  A control volume approach is used where the water masses are treated as added weights.  The working fluid (air) is treated using the adiabatic law and a simple power take off system is included. The resulting formulations are closed form expressions for the restoring moments in roll and pitch of the structure, which in turn are cast into stability metrics like the metacentric height. Results are compared with published experimental data as well as with air cushion structures for offshore applications.","authors":"Krish Thiagarajan Sharman  ","topic":"5","file":"1797-5047-1-DR-OK.pdf","bib":"WAVHYD-1797.bib"},
{"paperid":"1798","title":"Tide-to-wire model development for realistic tide environments","keywords":"Even though the free stream velocity of the tidal current can be predicted, the actual inflow at the turbine in a realistic environment is dynamically varying with time as well as the depth of the ocean. Theoretical predictions of the performance of the tidal turbine using the free stream velocity may produce reasonably accurate results in terms of an average power that can be produced; but in a dynamic environment, the forces experienced by the blades and the electrical output from the power grid would be fluctuating. Local flow acceleration and enhanced lift due to dynamic stall effects may create unanticipated high structural loads on the turbine blades, which could cause structural damage and might also be important for fatigue considerations. The variation of power output in time is also a primary concern for grid compliance. The rotation rate of the turbine will not be constant due to these dynamic effects, and this in turn further affects the flow. These are few of the factors which call for the simulation of tidal turbines in a realistic environment. Within the scope of this work, a numerical model based on BEMT is developed for prediction of the forces, torque and power output of the tidal turbine. The numerical model is developed using Python, and attempts to simulate the realistic working environment with a convenient user-friendly, multi-use implementation. In addition, the output torque of the BEMT is used as input to an electrical model developed in OpenModelica. The electrical model has an electrical generator which is actively controlled in order to perform maximum power point tracking and maximise the power capture from the tides. The rotational speed of the generator is fed back to the BEMT code in order to calculate the tip speed ratio. The exchange of information between the BEMT tidal turbine and the electrical model occurs at regular intervals in order to ensure high resolution results. The final part of the paper will focus on validating the complete model with experimental results from the FloWave tests of the XMED turbine at the University of Edinburgh.    ","authors":"Marios C. Sousounis, Joseph Praful Tomy, Stéphane Paboeuf and Jonathan K. H. Shek","topic":"4","file":"1798-4757-2-DR-OK.pdf","bib":"TIDDEV-1798.bib"},
{"paperid":"1799","title":"Laboratory experiments of wave interaction with submerged oscillating bodies","keywords":"This study is concerned with laboratory experiments of interaction of nonlinear water waves with submerged, oscillating bodies in shallow water.  Due to the propagation of surface waves, time-dependent pressure differential is formed above and under the body. This pressure differential results in oscillatory vertical force on the object. A vertical, thin guide rail, attached to the tank floor and extended to the free surface, is used to allow the object to oscillate in the vertical direction and restricts motions in other directions. Oscillations of the object is controlled by use of a spring attached to the object. A wide range of wave conditions are considered by changing the wave period and wave height. Submerged objects include a circular disc and a three-dimensional cone-shape body. Several springs with different stiffness are considered in this study. The wave-induced oscillations of the objects are recorded by a high-speed camera and data are processed and recorded as time-varying oscillations of the object. Discussion is provided on to the change of acceleration and oscillation height of the object under various wave conditions and spring stiffness. A vertically submerged disc or cone is the core component of a fully submerged wave energy device in shallow water. Mechanical oscillation of the submerged body is converted into electricity by use of a direct-drive power take-off system. A submerged oscillating body also acts as a wave breaker by mitigating the severity of waves approaching shorelines. The wave transformation above the oscillating body is recorded by several wave gauges upwave and downwave of the body and results of the gauges are compared and discussed.","authors":"Linda Eckel and Masoud Hayatdavoodi","topic":"5","file":"1799-5046-1-DR-OK.pdf","bib":"WAVHYD-1799.bib"},
{"paperid":"1800","title":"Relating fish distributions to physical characteristics of a tidal energy candidate site in the Banks Strait, Australia","keywords":"Tidal energy is an emerging form of marine renewable energy that utilises large, free-standing underwater turbines to generate electricity from tidally driven ocean currents. There are significant benefits resulting from commercial-scale developments of tidal energy converters (TECs) including clean, renewable and predicable power generation, yet potential interactions between TECs and the marine environment must be understood.  TEC placement in ecosystem sensitive areas could lead to population-level responses in fish by disrupting migratory pathways, posing increased collision risks and creating stressors in form of underwater noise and electromagnetic fields. In addition, large-scale TEC arrays have been found to influence current speed, turbulence and sediment transport processes that may cause changes to the marine habitat and impact fish populations utilising these regions.  Fish densities have been shown to vary by habitat, where different fish species display preferences for bottom type, depth, bathymetry, current speed and temperature. Identifying fish distributions at tidal energy candidate sites and exploring how these relate to the physical characteristics present would aid in the selection process for TEC placement and allow for potential impacts to the marine environment to be identified and mitigated early in the development process.  The Banks Strait, a tidal channel located in the northeast of Tasmania, Australia, was identified as a candidate site for tidal energy by the Australian Tidal Energy (AUSTEn) project. Fish abundance estimates were extracted from mobile hydroacoustic surveys performed with a vessel-based Simrad EK60 sampling at 38 kHz and 200 kHz during a sixteen-day research expedition in the Banks Strait in March of 2018. Multi-beam bathymetry, intermittent bottom-type samples, and CTD casts were also taken during this campaign. Tidal currents throughout the study site were extracted from a three-dimensional structured mesh model developed using Sparse Hydrodynamic Ocean Code (SHOC) and validated with long-term Acoustic Doppler Current Profiler (ADCP) deployments. Fish abundances were analysed to identify preferences for the physical characteristics present in the Banks Strait candidate site including depth, bottom type, bathymetry, current speed and temperature.  Quantifying potential impacts of TECs to the marine environment is a challenging, yet important step in evaluating the future of tidal energy. While the industry is looking to develop tidal energy sites, regulators aim to set appropriate guidelines to minimise environmental impacts, and fishing communities voice concerns about interactions between fish populations and tidal turbines. The need for research on the environmental effects of tidal energy devices is evident, yet specific case studies are limited. Overlaying favourable areas for turbine installation with regions that display high fish densities will help determine potential interactions between TECs and local fish populations. A similar approach may also be adopted at other tidal energy candidate sites to gain a baseline understanding about how local fish populations utilise these marine habitats. ","authors":"Constantin Scherelis, Irene Penesis, Philip Marsh, Remo Cossu, Mark Hemer, Jeffrey Wright  ","topic":"9","file":"1800-4616-2-DR-OK.pdf","bib":"ENVIRO-1800.bib"},
{"paperid":"1809","title":"Energy harvesting from waves using tandem floaters connected by piezoelectric beams","keywords":"In this paper, a small-scale floating system capable to extract energy from the waves is presented. The prototype floating structure consists of two box-shaped bodies joined by flexible beams and keeps its position with respect to the seabed via mooring lines. Due to the wave excitation, the platforms experience relative pitch rotations, and the mechanical energy related to this relative motion is then converted in electrical energy using a power take-off system based on piezoelectric beams. In this first arrangement, to facilitate the set-up of an illustrative experiment, it is supposed that the flexible linking beam is given by a piezoelectric device and two beams are set parallel to each other to connect the two floaters.   A simple experiment is arranged to demonstrate the feasibility of the concept and to obtain data to validate the numerical model. Two floaters are built in plastic materials, linked to each other with commercial PZT piezoelectric harvesters. The tests are carried out in a small basin with a plunge wavemaker properly designed to produce a wave amplitude around 1 cm. The tests are carried out in regular waves. Beside the motions of the floaters and the wave amplitude, the voltage and the power produced by the harvesters is measured after closing the circuit with a resistive load.   A detailed description of the piezoelectric beam and its electro-mechanical effects both in terms of the electrical charge production and the structural stiffness is carried out using an Euler-Bernoulli beam model and the equivalent electrical circuit for the piezo.  A comparison between the numerical simulations and the tests closes the paper to assess the accuracy of the model as well as some insight about the possibility to scale up this system.","authors":"Daniele Dessi, Giorgia Leonardi, and Fabio Passacantilli","topic":"3","file":"1809-4981-1-DR-OK.pdf","bib":"WAVDEV-1809.bib"},
{"paperid":"1811","title":"Wave energy assessment and spectral analysis: a case study in the Ionian Sea (South Italy)","keywords":"The paper reports the estimation of the offshore wave power offshore Apulian coasts (South Italy), with particular reference to the Ionian Sea. Half-hourly significant wave bulk parameters (e.g. height, peak period and mean wave direction) measured by the buoy are firstly used for the scope. Both zero-crossing and peak periods are here used for power calculation. The influence of the period is relatively low and the highest differences can be observed in correspondence of autumn and winter seasons (about 15%). Monthly wave energy calculated over the period 2006-2015 is reported, showing that, compared to the Italian coasts, the energy potential in the Ionian Sea is relatively low, highly influenced by season variability and mean wave direction. Wave power temporal variation over the observation period is here quantified by means of standard statistics (e.g. mean, minimum and maximum values), together with the Monthly Variation Index and the Coefficient of Variation of Power.     Moreover, in order to perform a further investigation on the influence of spectral parameters on the offshore wave energy assessment, a preliminary analysis of the wave spectra and spectral shape parameters estimated offshore Taranto and their temporal evolution during the recorded period is reported. The spectral narrowness and width parameters are used in order to measure the width of the spectral band. Looking at the monthly variation, it can be noted that the monthly averaged 1D spectrum tends to flatten going from the winter to the summer season evolving from an almost unimodal shape to spectra with very low energy density and multiple peaks from July to August.         ","authors":"Leonardo Damiani, Giuseppe R. Tomasicchio, Maria F. Bruno, Alessandra Saponieri ","topic":"1","file":"1811-4468-2-DR-OK.pdf","bib":"WAVRES-1811.bib"},
{"paperid":"1821","title":"On the experimental study of a concentric wave energy array adapted to an offshore floating platform","keywords":"This paper presents the experimental results of a small scale concentric wave energy converter array attached on a floating offshore platform. A 1:27 scale prototype, is designed, built and tested, in two main cases, without and with twelve cone shape heaving point absorbers. The free decay, regular and irregular wave tests are carried out in an ocean basin to understand the hydrodynamic interactions between various elements of the floating offshore platform and wave energy converter array. Meanwhile, the heave motions of the buoys are tested with and without dampers to understand the required damping range of the power take-off system. The results show that the interaction between the buoys and platform has a positive effect on the platform heave and pitch motions.  Keywords: Concentric array of wave energy converters, Floating offshore platform, Small scale prototyping, Heaving point absorber, Heave and pitch motions. ","authors":"Mojtaba Kamarlouei, Jose F. Gaspar, Miguel Calvário, Thiago S. Hallak, Mario J. G. C. Mendes, Florent Thiebaut, Carlos Guedes Soares","topic":"3","file":"1821-5031-1-DR-OK.pdf","bib":"WAVDEV-1821.bib"},
{"paperid":"1822","title":"Optimal power take-off parameters for a bottom-hinged plate wave energy converter","keywords":"The objective of this paper is to present optimal parameters of an oil-hydraulic power take-off system for a bottom-hinged plate wave energy converter and verify the impact of the state-of-the-art reactive control strategy on the converter performance. The power take-off concept relies on a concept of two-single rod oil-hydraulic cylinders working with a reciprocating movement on both sides of the bottom plate. The concept takes advantage of two possible hydraulic configurations to maximize their efficiency. The system is modelled with different controller’s, whose parameters are optimized with genetic algorithms in order to maximize the harvested power. The mechanical interface between the power take-off and converter is also optimized considering technological constraints on the power take-off system and converter motions. The simulations are performed for different sea sate conditions and cylinder models.  Keywords—Bottom-hinged plate, Power take-off system, Oil-hydraulics, Wave energy converter. ","authors":"Miguel Calvário, Josè F. Gaspar, Mojtaba Kamarlouei, Carlos Guedes Soares","topic":"7","file":"1822-4659-2-DR-OK.pdf","bib":"GRDPTO-1822.bib"},
{"paperid":"1824","title":"Preliminary study on a novel hybrid wave surge energy converter for nearshore applications","keywords":"Nowadays, the electrical energy production by waves is limited due to technological, economic and environmental problems related to the available solutions. In this context, hybrid structures coupling electroactive materials could represent an innovative solution to design promising concepts of submerged wave converters for nearshore applications. Here, we present the development of an hybrid prototype exploiting only horizontal component of the waves, and that utilizes piezoelectric technology in synergy with electroactive polymers (Dielectric Elastomer Generators, DEG) in order to drastically increase the global efficiency of the system, while maintaining very limited production costs.  Indeed, DEGs represent a high energy density technology not yet fully exploited. This approach can provide a smart, simple, cheap and robust solution for harvesting energy from coastal regions without creating encumbrances to navigation. This contribution presents the preliminary experimental studies on our small-scale prototypes (15cmx15cm), performed in a water channel, related to the hydrodynamics and the electrical extraction through piezoelectric elements of bottom-hinged plates, subjected to various conditions (frequency and amplitude of waves, position of prototype in standing waves). For the moment, piezoelectric elements scavenge few ?W with the dimensions adopted and the waves utilized, enough to start the hybridization with DEG. Besides, we also investigate and discuss the effect of deformable membranes integrated in the device, consisting the active materials of the DEG.","authors":"Gregorio Boccalero, Claire Jean-Mistral, Simon Chesne, Emmanuel Mignot and Nicolas Riviere ","topic":"3","file":"1824-4643-2-DR-OK.pdf","bib":"WAVDEV-1824.bib"},
{"paperid":"1830","title":"Numerical study on the energy extraction performance of coupled tandem flapping hydrofoils","keywords":"Tidal current energy is a promising renewable energy source for the future electricity supply. The flapping foil is regarded as a useful tool to extract the tidal current energy in shallow water. A concept of coupled tandem flapping hydrofoils is proposed in the present study. And a numerical study is carried out to optimize the system of the tandem flapping hydrofoils for more energy extraction. A two-dimensional numerical model, based on ANSYS-Fluent, is established to study the power extraction performance, which is validated by corresponding experiment data. Effects of the reduced frequency, pitching amplitude and moment of inertia are investigated. The vortices and pressure distribution of hydrofoils under various conditions are analysed to reveal the fluid-structure interaction between the shedding vortex and the foils. The energy extraction mechanism and hydrodynamic performance are analysed. The positive interactions for energy harvesting are expected to be identified for further improvements. The study could provide valuable information for the design and optimization of coupled tandem flapping hydrofoils.","authors":"Qu Hengliang, Xu Chuanli, Zhang Xiaoxia, Qu Na, Liu Zhen","topic":"4","file":"1830-4605-2-DR-OK.pdf","bib":"TIDDEV-1830.bib"},
{"paperid":"1836","title":"Mechanisms for reducing the cost of tidal stream energy","keywords":"This paper gives tangible examples of how the levelized cost of energy is reducing in the tidal stream energy industry from a leading technology and site developer perspective. We focus predominantly on the cost of energy reductions that are achievable through economies of scale, such as increases to rotor diameter, generator rating and hub height. Examples are also given for how economies of volume (e.g. number of turbines), technology innovation (e.g. sub-sea hubs to connect turbines) and finance (e.g. cost of capital) are bringing down cost of energy significantly. Results show that even a relatively small increase in rotor diameter and generator rating of 2 m (i.e. +11%) and 0.5 MW (+30%) respectively can result in significant uplifts in energy yield per turbine of 29%, and a reduction in LCoE of around   20%. These economies of scale are achievable in the near term (circa. 1 year from now) and are consistent with the design of the new AR2000 turbine, which is the upgrade to the AR1500 that is operational as part of the MeyGen Phase 1A array. Results presented here show that more significant economies of scale further into the future can lead to a doubling of the energy yield per turbine from the MeyGen resource.      Recent developments in the tidal stream energy     industry have seen the completion of demonstration and precommercialisation     arrays that are now operational and connected     to the grid. Importantly, these projects are delivering proof of     concept that provide a platform for the commercialisation of tidal     stream energy to develop larger scale arrays in the relatively near     future. An important key performance indicator for any energy     project is levelized cost of energy, a metric that is commonly     used to assess cost competitiveness of projects across the energy     sector. This paper gives tangible examples of how the levelized     cost of energy is reducing in the tidal stream energy industry     from a leading technology and site developer perspective. We     focus predominantly on the cost of energy reductions that are     achievable through economies of scale, such as increases to rotor     diameter, generator rating and hub height. Examples are also     given for how economies of volume (e.g. number of turbines),     technology innovation (e.g. sub-sea hubs to connect turbines) and     finance (e.g. cost of capital) are bringing down cost of energy     significantly. Results show that even a relatively small increase     in rotor diameter and generator rating of 2 m (i.e. +11%) and 0.5     MW (+30%) respectively can result in significant uplifts in energy     yield per turbine of 29%, and a reduction in LCoE of around     20%. These economies of scale are achievable in the near term     (circa. 1 year from now) and are consistent with the design of the     new AR2000 turbine, which is the upgrade to the AR1500 that     is operational as part of the MeyGen Phase 1A array. Results     presented here show that more significant economies of scale     further into the future can lead to a doubling of the energy yield     per turbine from the MeyGen resource.   ","authors":"Daniel S. Coles, Tom Walsh","topic":"10","file":"1836-5069-1-DR-OK.pdf","bib":"ECONOM-1836.bib"},
{"paperid":"1837","title":"Preliminary study on the effect of tidal current power on salinity distribution in the Zhoushan Area, China","keywords":"For the multi-channel marine system with significant transport of different water masses, harvesting energy from the tidal current may affect the transport regime of these waters. However, understanding of this effect is lacked by previous research. To address such issues, a highresolution three-dimensional model of the Zhoushan Area was developed. Through the momentum sink approach, a theoretical array of 200 turbines in the Guanmen Channel was embedded. Considering the realistic operation of a generic tidal stream turbine, the annual mean power production of this array is estimated to be 22.07 MW. As the removal of tidal current energy, significant deceleration of the currents is observed downstream of the turbines, with a maximum value of 0.15 m/s. It is also found that the blockage of the array not only induces the reduction of tidal flux in the Guanmen Channel but also causes the water flux increment in the neighboring channels. This, in turn, affects the transport of the Changjiang Diluted Water. Increments of the salinity are detected in the vicinity of the array. Simultaneously, due to the increase of the freshwater input, waters in the neighboring channel become fresher. These alterations indicate that tidal current energy extraction could influence the transport regime of local water masses and subsequently induce the redistribution of the ocean thermohaline fields.","authors":"Guizhong Deng, Ye Li, and Zhaoru Zhang","topic":"9","file":"1837-4598-2-DR-OK.pdf","bib":"ENVIRO-1837.bib"},
{"paperid":"1839","title":"Experimental study on performance analysis of Oscillating Water Column Wave Energy Converter integrated into breakwater","keywords":"Korea Research Institute of Ships and Ocean Engineering (KRISO) is developing an oscillating water column (OWC) wave energy converter through a government funded project to integrate the OWC into breakwaters for the purpose of supplying clean energy to the island area. In the previous study, a sloped OWC chamber that can be easily constructed on an existing conventional breakwater has been developed, and its performance for primary energy conversion has been evaluated by using various analysis methods. In this study, the performance of primary energy conversion for the sloped OWC chamber integrated into the breakwater was evaluated by the experimental method. The experiment was carried out in the shallow water wave basin with modelling the PTO (Power Take-OFF) as an orifice and the breakwater as scaled tetrapods and base structures with a scale ratio of 1/20. The regular wave test for various incident wave period as well as various wave slopes was performed to measure the water surface level inside the chamber, the differential pressure between the inside of the chamber and the atmosphere, and the airflow speed through the orifice. By comparing results for various wave condition and with or without the presence of the breakwater, effect of the wave slope dependency and the presence of the breakwater on the OWC performance was discussed.","authors":"Sewan Park, Kyong-Hwan Kim, Kwang Ho Lee, Jeong-Seok Kim, Bo-Woo Nam, Keyyong Hong","topic":"3","file":"1839-4480-3-DR-OK.pdf","bib":"WAVDEV-1839.bib"},
{"paperid":"1840","title":"Variable-fidelity CFD modelling of horizontal-axis tidal turbines and arrays","keywords":"The assessment of a design-oriented hydrodynamics model for horizontal axis tidal turbines is addressed. The methodology is based on a Boundary Integral Equation Model with a simple viscous flow correction (BIEM-VFC) and is valid to analyse the three-dimensional flow around a turbine in arbitrary onset flow at computational costs comparable to standard blade element methods. A validation study is performed by using benchmark data from full viscous flow simulations by RANS. Numerical results by BIEM-VFC are compared with RANS predictions of turbine global performance, thrust and power, as well as local flow quantities describing pressure distributions and wall streamlines on blades and trailing vorticity path in the wakefield. The validation study demonstrates that BIEM-VFC predictions of both global and local flow quantities are comparable with those obtained from more complex full viscous flow simulations for a range of turbine operating conditions where viscosity effects are significant but blades are free from massive separation and stall. For operating conditions characterized by blade stall, BIEM-VFC fails to describe local flow details while qualitative approximations of global loads are given.","authors":"Giulio Dubbioso, Francesco Salvatore, Zohreh Sarichloo, Danilo Calcagni, Roberto Muscari, Ralf Starzmann","topic":"6","file":"1840-4960-1-DR-OK.pdf","bib":"TIDHYD-1840.bib"}
]