var library = [
{"paperid":"629","title":"Modelling and Testing of a Submerged Oscillating Water Column","keywords":"<p>The Stellenbosch Wave Energy Converter (SWEC) is experimentally tested and mathematically modelled. The main objective of this research was to produce a verified and validated simulation model for the SWEC in different configurations. Experimental testing and mathematical modelling contributed to the development of the simulation models.</p> <p>The study resulted in a set of conversion efficiencies achieved by the device for various wave conditions, supported by simulated and experimentally obtained results. The model is critically analysed, verified and validated to a degree generally achieving errors of less than 10% on the conversion efficiencies.  The experimental results show that the Surface SWEC achieved a maximum conversion efficiency of 26% while the Submerged SWEC achieved a maximum conversion efficiency of 22%.</p> <p>In addition to validating the simulation models, this paper also presents an investigation carried out on a proposed new breakwater at the Port of East London to investigate the implementation of a hybrid breakwater-WEC as part of the harbour upgrade. The mathematical model was used in conjunction with measured wave energy resource data (recorded 1km away from the proposed site) to predict the potential output and performance of the proposed device.</p> <p> </p><p> </p>","authors":"J. Fairhurst, W. Van Niekerk","topic":"3","file":"WAVDEV-01-629.pdf","bib":"WAVDEV-01-629.bib"},
{"paperid":"630","title":"A method for the spatial targeting of tidal stream energy policies","keywords":"<p>Tidal stream energy is at the centre of global efforts towards climate change mitigation. Therefore, the interest of a policy framework to promote the large-scale penetration of tidal stream energy projects, which could contribute substantially to the reduction of carbon emissions, has become apparent. Taking this into account, the objective of this paper is twofold: (i) to develop a new method to delimit the most suitable target areas for tidal stream energy policy intervention within a coastal area of interest, and (ii) to apply it to the Bristol Channel (UK). The method includes spatial numerical analysis by means of a Matlab-based code coupled with a Navier-Stokes solver. The programme, which works in steps, carries out a zoning process, in which the most economical areas for tidal stream exploitation are selected through the spatial distribution of the LCOE. Aspects of relevance such as such as potential conflicts with other activities are mapped out. As a result, the present study provides a unique spatial distribution of tidal stream energy resource and related costs, benefits, impacts and conflicts with other activities, which can be viewed as a supporting decision mechanism for spatially targeted policy-making and management of tidal stream energy across the study area.</p><p class=IEEEParagraph> </p>","authors":"A. Vazquez, S. Astariz, G. Iglesias","topic":"10","file":"ECONOM-01-630.pdf","bib":"ECONOM-01-630.bib"},
{"paperid":"631","title":"Using NEMOH for modelling wave energy converters: A comparative study with WAMIT","keywords":"<p class=IEEEParagraph>BEM solvers are a crucial tool for the wave energy community. The aim of the present paper is to evaluate the usefulness of the open source NEMOH solver to the wave energy community. The evaluation is divided into two parts. The first part considers the pre-processing of input files for NEMOH. The second part compares the results obtained for the hydrodynamic parameters using NEMOH, with those obtained from WAMIT.</p><p>The evaluation of the pre-processing capabilities of NEMOH will focus on the means to generate the mesh to describe the geometry, studying tools such as the axiMesh function in NEMOH, the different mesh formats and the suitability of each format for the different solvers or the format conversion possibilities.</p><p>The second part of the investigation focuses on the results obtained for the hydrodynamic parameters from the NEMOH solver. Results for the hydrostatic stiffness, radiation damping and added-mass, and excitation force obtained from the NEMOH solver will be compared with the equivalent results obtained from WAMIT. Different types of WEC, based on real or proposed devices will be evaluated.</p><p>The paper will present the advantages and disadvantages of each BEM solver.</p>","authors":"M. Penalba, T. Kelly, J. Ringwood","topic":"5","file":"WAVHYD-01-631.pdf","bib":"WAVHYD-01-631.bib"},
{"paperid":"633","title":"Continuously Adaptive PI-Control of Wave Energy Converters under Irregular Sea-State Conditions","keywords":"The main objective in hydrodynamic control of wave energy converters (WECs) is the maximisation, for a broad range of sea states, of the energy captured from the waves.  Latching control, model predictive control and ``PID'' control are examples of implementable strategies surveyed in the literature.  ``PID'' control, while suboptimal, has the merit of being simple, requiring only straightforward calculations and can be considered a standard solution for WECs with a four-quadrant power take-off system (PTO), in particular in its ``PI'' variant. Adaptive PI control has been already discussed in the literature, usually using a  gain-scheduling approach,  with optimal gains precomputed offline for a representative set of sea states and applied as a function of estimated sea state conditions. In most literature, only average online estimations of sea states have been proposed, with time windows of several minutes. Such intermittent (or switching) adaptive control laws are clearly suboptimal in terms of energy recovery, since the control gains are not continuously updated whereas the sea state is continuously time-varying.   In this paper we present a continuously adaptive PI control strategy, which takes into account (non-ideal) PTO efficiency. The problem of optimising the gains of the PI controller is converted into a convex optimisation problem, thus guaranteeing that a unique and optimal solution can be found offline. The gains of the PI controller are continuously adapted online, on a wave-to-wave basis, based on a real-time estimate of the dominant wave frequency of the wave force, which is in turn estimated from (normally) available WEC measurements.   Validation is performed on a case study based on a lab-scale point-absorber WEC. Simulation results show that the proposed adaptive control scheme can recover more energy than a fixed-gain PI controller even in a sea state with constant spectral characteristics. Furthermore, in a changing sea state, it outperforms switching gain-scheduled PI control where the gains are updated from time to time based on an evaluation of the current sea conditions.  Though some preliminary wave basin tests have already given encouraging results, further experiments are needed to precisely quantify its energy harvesting potential. Moreover, further research is needed to include WEC motion or actuator constraints in the optimisation procedure.","authors":"H. Nguyen, P. Tona","topic":"7","file":"GRDPTO-01-633.pdf","bib":"GRDPTO-01-633.bib"},
{"paperid":"636","title":"Dynamics analysis of the movement of a wave energy converter with more than one degree of freedom","keywords":"This work proposes an analytical model by the Newton-Euler approach that describes the motion of a novel wave energy converter (WEC). The WEC design is based on the concept of the Stewart-Gough platform (SGP), which enables to use the six freedom degrees of structure motion. The SGP is a six-degree-of-freedom mechanism with two bodies connected by six legs. One of the bodies is the base and the other is the platform. The WEC based on the SGP (WEC-SGP) consists of three rigidly interconnected buoys to forming an upper platform connected with six cables to a lower submerged platform. The cables that originate in the lower platform enter through the shell of the buoy and travel towards the upper part of the platform, where they are connected to the power take-off system. A force analysis is developed to find the leg forces required to support the effect of an external force and moment acting on the platform. This analysis formulated with a Newton-Euler approach allows to arrive at a system of six linear equations in six unknowns from which the required forces at the legs can be obtained directly. This system of equations have to be resolved so that the platform follows a planned path in order to compute the legs forces.","authors":"D. Galvan Pozos, F. Ocampo Torres","topic":"3","file":"WAVDEV-PP-636.pdf","bib":"WAVDEV-PP-636.bib"},
{"paperid":"638","title":"Integration of a direct drive contra-rotating generator with point absorber wave energy converters","keywords":"<p>Simplifying the drive train and power take-off system is key to improving reliability and reducing the costs of wave energy technologies. This paper investigates whether technology developed in the tidal energy industry can be transferred to wave energy converters to realise the benefits of systems which have already been tailored for operation in the marine environment. The direct drive contra-rotating generator of Nautricity Ltd. has proven to be robust and efficient during in-sea prototype testing. The design facilitates an increase in the generator rotational speed while in a direct drive configuration, thereby reducing the size and weight requirements and improving reliability. To ascertain the feasibility of integrating this system within a point absorber wave energy converter a conceptual model has been developed. By connecting the float to both sides of the generator the torque is halved while the relative speed between the rotor and stator is doubled, enabling a compact generator design to be fitted within a gear-free drivetrain. A preliminary costing was completed for the proposed power take-off option and compared with a conventional hydraulic system. It was estimated that the LCOE could be reduced by approximately 37%.</p>","authors":"K. Porter, S. Ordonez-Sanchez, C. Johnstone, S. Conesa","topic":"7","file":"GRDPTO-01-638.pdf","bib":"GRDPTO-01-638.bib"},
{"paperid":"639","title":"A coupled Monte Carlo-Evolutionary approach to optimise offshore renewables O&M","keywords":"<p>In this paper, the authors propose an integrated approach of Monte Carlo Simulation and Evolutionary Algorithm Optimization. This combined approach is here applied to the characterization and reduction of the operational expenses of an offshore farm. The Monte Carlo model developed is used to simulate the operation and maintenance procedures of the devices. This permits to obtain valuable information on reliability, availability, maintainability and profitability of the farm. A Genetic Algorithm is then implemented to conduct a multi-objective optimization on the input set of the model. This permits to establish the best combination of preventive measures to consider in order to produce the optimal maintenance strategy. Specific objective-functions are created for this purpose. A case-study will be used to show this methodology.</p>","authors":"G. Rinaldi, P. Thies, L. Johanning","topic":"11","file":"OPANDM-01-639.pdf","bib":"OPANDM-01-639.bib"},
{"paperid":"640","title":"An analysis of the wave climate in South Wales, UK","keywords":"<p class=IEEEParagraph>South Wales is one of the prime wave resource areas in the UK. The Crown Estate has designated a zone in the region for demonstration arrays up to 30MW. This paper will describe the wave climate using both buoy and model data. Two wave buoys are used: a one year record from a DWRIII deployed at 51.56N, 4.86W and 20 years of data from the Met Office Turbot Bank Buoy located 51.603N, 5.1W. Seasonality is observed in both datasets with greater power in the winter months. Data from the DWRIII shows that 78% of spectra are unimodal. There is large variability in annual mean power for the Turbot Bank Buoy, ranging between 10-24kW/m. Extreme value analysis predicts the 50 year return wave height to be 11.7m.</p> <p class=IEEEParagraph>A WWIII model has been used to simulate wave conditions around the Welsh coast. Three grids were used varying from a North Atlantic model with resolution of 0.5º to a model of Wales with resolution of 0.025º. This model is being used to force a higher resolution Swan model of the Pembrokeshire resource area to better understand variability in resource around the demonstration zone.</p>","authors":"I. Fairley, H. Williams, J. Horrillo-Caraballo, D. Thompson, I. Masters, D. Reeve, H. Karunarathna","topic":"1","file":"WAVRES-01-640.pdf","bib":"WAVRES-01-640.bib"},
{"paperid":"641","title":"On the distribution of complex sea-states in the Bay of Biscay","keywords":"<p class=IEEEParagraph>An efficient way of optimizing wave energy devices in terms of power extraction is to design these systems, so that their response is efficient and optimal over the widest span of the sea-states spectral bandwidth. Hence in order to correctly design such devices a proper description of the actual wave energy spectral distribution should be taken into account, especially in areas with wave climates dominated by complex sea-states. Indeed, analytical spectra such as JONSWAP functions aren’t adapted to the description of multimodal sea-states and their use when evaluating the response of a structure, as for instance when assessing the power extracted by a wave energy converter, might introduce a rather significant bias. It seems then interesting to statistically assess the occurrence of complex sea-states in areas where deployment of ocean renewable energy devices can be expected in the future.</p> Taking advantage of the existing HOMERE 19-year sea-states hindcast database, a statistical analysis of the occurrence of complex sea-states is conducted over the area of the Channel and the Bay of Biscay. The database includes a large set of global parameters for each of the various wave systems constituting of a sea-state, including one wind-sea and up to five swells, obtained after partitioning of the sea-states. Based on this dataset a mapping of the statistics of occurrences of the various unimodal and multimodal sea-states is made, taking into account various combinations of wind-sea and swells","authors":"C. Maisondieu","topic":"1","file":"WAVRES-01-641.pdf","bib":"WAVRES-01-641.bib"},
{"paperid":"642","title":"Mechanical properties and damage analyses of fatigue loaded CFRP for tidal turbine applications","keywords":"Tidal turbine blades are routinely subjected to conditions of fatigue loading, which over time results in structural damage that negatively affects blade durability. Structural materials (such as fibre reinforced plastics, FRPs) within a tidal turbine blade are therefore of considerable importance, and design parameters for such materials should be reviewed and optimised to decrease fatigue-related losses in strength and stiffness. Carbon fibre reinforced plastics (CFRP) are high strength and stiffness composites that are relatively lightweight compared to other FRPs. Here, we characterise the fatigue performance of uni-directional, laminated CFRPs using both experimental and computational methods combined. In particular we assess its ability to maintain mechanical strength and stiffness under water immersed conditions, and as a function of accelerated aging. More specifically, S-N curves and E-N curves are compared and contrasted for dry, oven-aged and hygrothermally-aged conditions. Damage evolution is furthermore detailed using finite element methods. Through virtual experimentation we elucidate damage evolution as a function of fibre orientation, laminate thickness and stress amplitude. Our work provides insights to the engineering design of tidal turbine blades with an aim to improving blade durability.","authors":"P. Alam, A. Lafferty, C. Brádaigh","topic":"8","file":"STRMAT-PP-642.pdf","bib":"STRMAT-PP-642.bib"},
{"paperid":"643","title":"Consistency of Viscous Drag Identification Tests for Wave Energy Applications","keywords":"<p>Viscous drag effect are usually described by a Morison-like term included in an otherwise linear model based on the Cummins’ equation. Notwithstanding the Morison equation has been known for several decades, there are still a lot of uncertainties about the drag coefficient choice, especially in wave energy applications, leading to some degree of inconsistency between different sources in the literature.</p> <p>The purpose of this paper is to analyse different approaches to identify the drag coefficient term. Particular focus is put on consistency and accuracy of the results.</p> <p>Considering a piercing heaving point absorber, several identification experiments are performed, including radiation tests (force harmonic motion of a piercing body in calm water), current tests (fixed body subject to constant unidirectional flow) and prescribed motion tests (forced harmonic motion of a fully submerged body in calm water). While the previous approach are already found in the literature, a novel identification approach is considered as well, similar to the prescribed motion test but imposing a saw signal motion (zero acceleration and periodic motion). Finally, the drag coefficient is identified directly from the body response to regular waves under controlled conditions.</p>","authors":"G. Giorgi","topic":"5","file":"WAVHYD-01-643.pdf","bib":"WAVHYD-01-643.bib"},
{"paperid":"644","title":"Importance of Nonlinear Waves for Nonlinear Froude-Krylov Force Calculation","keywords":"<p class=IEEEParagraph>Linear mathematical models for wave energy converters can be improved by the inclusion of nonlinear Froude-Krylov (FK) forces, which are computed as the integral of the pressure over the instantaneous wetted surface of the device. Therefore, possible sources of nonlinearities are the free surface elevation, the pressure field distribution and the geometry (in the case the cross sectional area is not constant along the direction of motion). The free surface elevation and the pressure field distribution can be described by the linear Airy’s wave theory or by nonlinear theories such as Rienecker-Fenton waves. Finally, an extension of the results of the Airy’s theory can be applied using the Wheeler stretching approach.</p> <p class=IEEEParagraph>This paper tries to discuss whether it is worth to increase the complexity of the nonlinear FK forces calculation including the nonlinear free surface elevation and nonlinear pressure distribution. Only the power production region is considered, therefore extreme events are neglected since the device enters the survivability mode.</p> <p class=IEEEParagraph>Three aspects are considered, namely the frequency of occurrence of nonlinear waves in power production region, the difference between pressure field descriptions in the proximity of the free surface (where the device operates) and the additional complexity of nonlinear descriptions.</p>","authors":"G. Giorgi","topic":"5","file":"WAVHYD-01-644.pdf","bib":"WAVHYD-01-644.bib"},
{"paperid":"645","title":"Experimental assessment of an innovative management system for mooring loads","keywords":"INNOSEA and Laminaria (the concept developer) have been engaged in the testing of a WEC concept based on a coupled PTO and taught moored system within the LAMWEC project. The WEC mooring system manages the mooring loads by varying the device submergence as a function of the incident sea states.<br />The paper describes the device and the data analysis methods, and the relevant results are presented. Specifically, it is shown that the 95 percentile of the mooring loads is controlled by the submergence and largely independent of Hs. Additionally, the distributions with regards to the incident sea states of the statistical function's parameters fitted to the data are presented and commented.<br />Altogether, INNOSEA employed advanced data analysis techniques to post process the tank test data and provide a clear proof of concept. The work presented in this study will support Laminaria in the development of its concept and has already informed the design of the mooring lines. <br />","authors":"R. Pascal, A. Combourieu, S. Nauwelaerts, A. Foschini","topic":"3","file":"WAVDEV-01-645.pdf","bib":"WAVDEV-01-645.bib"},
{"paperid":"646","title":"Applicability of linear and non-linear potential flow models on a Wavestar float","keywords":"<p class=IEEEParagraph>IFPEN work on wave energy focuses on control design. Accurate numerical model of the device to be controlled, is needed to efficiently develop a control strategy:</p> <p class=IEEEParagraph>-          the control strategy itself may require a numerical model of the controlled device,</p> <p class=IEEEParagraph>-          the control strategy can be tested on the numerical platform before being plug into a model test or a prototype.</p> <p class=IEEEParagraph>The control strategy developed at IFPEN was applied to the Wavestar technology. Consequently a numerical model of this device was developed based on potential flow theory. The device is intrinsically submitted to large motions, outside of the validity domain of linear potential flow theory. Different models are built in order to account for some of the non-linear effects:</p> <p class=IEEEParagraph>-          linear model, hydrodynamic coefficients computed at:</p> <ul><li>the rotation centre,</li><li>the centre of buoyancy,</li></ul> <p class=IEEEParagraph>-          linear model, nonlinear hydrostatic,</p> <p class=IEEEParagraph>-          linear model, nonlinear hydrostatic and Froude-Krylov forces.</p> <p class=IEEEParagraph>A model based on non-linear potential flow theory and the weak-scatterer hypothesis is also tested. A model test campaign was carried out in Aalborg University. The experimental and numerical data are compared in order to evaluate the validity of the simulations and the complexity needed to properly predict the float behaviour.</p>","authors":"P. Bozonnet, V. Dupin, P. Tona, C. Chauvigné, M. Kramer","topic":"5","file":"WAVHYD-01-646.pdf","bib":"WAVHYD-01-646.bib"},
{"paperid":"647","title":"Evaluating the Dynamics of Mooring Tidal Turbines","keywords":"<p class=IEEEParagraph>This paper reports the design of a tidal turbine station keeping system based on the adoption of a tensioned mooring system and investigates potential capabilities of introducing dampening into the system and the capabilities to reduce the peak loads tidal turbines experience during operations in high energy wave-current environments.</p> <p class=IEEEParagraph><span lang=EN-AU>In this context, a neutrally buoyant turbine is supported from a tensioned cable based mooring system, where tension is introduced by a buoy are fully submersed in water. The loading on the turbine rotor blades and buoy are calculated using a wave coupled BEMT code developed at the University of Strathclyde for the analysis of the turbine rotor-drive train analysis when operating in energetic wave-current flow conditions. </span>In addition, due the turbine being able to move and respond to the moving flow field, the resulting motions due to flow field interactions should be taken into consideration.</p><p class=IEEEParagraph><span lang=EN-US>The modeling algorithm developed have been based on an inverted double pendulum, responding to different sea state conditions in order to understand the response behavior of the system and the loads on blades in different flow conditions. Then a comparation between mooring turbine and rigid turbine will be summarized.</span></p>","authors":"S. FU, C. Johnstone","topic":"4","file":"TIDDEV-01-647.pdf","bib":"TIDDEV-01-647.bib"},
{"paperid":"649","title":"Multi-Objective Optimization of Rotor Blades for Horizontal Axis Tidal Stream Turbines","keywords":"<p>Overall objective of this paper is a blade design method utilizing multi-objective optimization. Designers shall be enabled to quantify the trade-off between power output, thrust and cavitation.</p> <p>Based on a design space numerous blade geometries are created covering this design space by utilizing a multi-objective optimization. Objective functions are the non-dimensional turbine power coefficient<em><sub> </sub></em>(to be maximized), the thrust coefficient <em></em>(to be minimized) and the critical cavitation number<sub><em>,</em></sub><em></em> representing the upper bound of cavitating operating conditions (to be minimized). The multi-objective optimization comprising spanwise twist angle and chord distributions was performed by integrating an enhanced semi-analytical performance and cavitation prediction model into an evolutionary algorithm (EA).</p> <p>A data base of optimized geometries was created from the optimizations. Their non-dimensional performance and cavitation characteristics were predicted for a wide operating range. A decision making strategy was developed, finding the best fitting geometry of the data base for a specific design task.</p><p>The method was used to design a blade for the SCHOTTEL HYDRO SIT250 family of fixed-pitch tidal turbines. Design target is the highest annual energy production (AEP). Model-scale tests in a towing tank and cavitation tunnel were carried out to validate the hydrodynamic design.</p>","authors":"N. Kaufmann, T. Carolus, R. Starzmann","topic":"4","file":"TIDDEV-01-649.pdf","bib":"TIDDEV-01-649.bib"},
{"paperid":"650","title":"An Assessment Method of Wave Energy Resources in Finite Water Depths","keywords":"<p>In developing wave energy from seas, nearshore areas with finite water depths (50m or less) are frequently considered, and wave buoys have been deployed to measure the waves in those places for collecting long-term information for assessing wave resources and distributions. Frequently, the existing practice for those wave measurements are often given using the so-called wave scatter diagrams, in which the wave parameters are binned based on the measured significant wave heights (the bin interval: 0.5m or 1.0m) and wave statistic periods (the bin interval: 0.5s or 1.0s), such as the energy period, <em>T<sub>e</sub></em>, or the spectrum peak period, <em>T<sub>p</sub></em>, whilst the detailed spectra (shapes and distributions) are normally unavailable. This may not be ideal when the scatter diagram is the only available information for wave energy resource assessment, especially in the cases of finite water depths, when the wave energy resource assessment becomes inaccurate.</p> <p>Due to the possibility of deploying wave energy converters in relatively small water depths, one question would be how the water depths will affect the wave energy resource assessment. Principally, the effect of the finite water depths on wave energy assessment can be easily conducted for regular waves, and possible for irregular waves if the detailed spectra are available. However, in many cases, the historic wave measurements are frequently given in forms of scatter diagrams only, in which the required spectrum information for assessing the effect of finite water depths is discarded and no long available for such an analysis. Hence, the effect of finite water depths on wave energy and resources becomes impossible when the significant wave height and the characteristic periods are only available as in the practical wave scatter diagrams. In many cases, the formulas for deep-water waves are frequently used, but as it will be shown in this research, ignoring the effect of finite water depth may under-estimate wave energy by up to 20% in regular waves and up to 15% in irregular waves, depending on the water depths. For improving wave energy and resource assessment, a method for improving the assessment of wave energy in finite water depths is studied. The proposed improving method has been examined for the theoretical spectra and measured spectra. It is found that the new assessment method can improve the energy assessment of waves in finite water depths from 15% to less than 5%, and the wave resource assessment from more than 10% to less than 4%.</p>","authors":"W. Sheng","topic":"1","file":"WAVRES-01-650.pdf","bib":"WAVRES-01-650.bib"},
{"paperid":"651","title":"Wave energy absorption by a partially immersed rectangular barge of oscillating water columns","keywords":"In this paper a mathematical model will be developed for an oscillating water column wave energy converter. We consider a partially immersed barge of rectangular planform comprised of a series of adjacent open bottomed chambers each enclosing an internal free surface. As the incident wave passes, the internal free surfaces are subjected to an oscillating pressure distribution causing the enclosed water to rise and fall. Thus, the volume of air trapped above the internal free surface is forced to drive a turbine mounted in the top of the chamber. The solution is decomposed in terms of the incident wave and a set of hydrodynamic problems describing the radiated waves due to an imposed oscillating pressure distribution on the internal free surface of each chamber in turn. Assuming the walls of the barge to be thin and submerged to a negligible depth we exploit the geometry to apply Fourier transforms in the plane of the free-surface. This leads to explicit integral representations for hydrodynamic coefficients describing the induced volume flux across the internal free surfaces. The high efficiency of the solution method allows us to explore a large parameter space quickly, assessing the impact of a variety of factors on performance.","authors":"I. Noad","topic":"5","file":"WAVHYD-PP-651.pdf","bib":"WAVHYD-PP-651.bib"},
{"paperid":"653","title":"Peak force in the connection line of a linear generator WEC","keywords":"<p>In order for wave energy to be a viable energy option, the survivability of wave energy converters (WEC) in harsh offshore environments must be guaranteed. The peak forces of extreme waves must be calculated to design the wave power plant. This paper is focusing on the linear generator developed at Upppsala University, Sweden. The generator has a limited stroke length, and a peak force will occure as the translator hits the upper endstop.The damping force of the generator will decrease when the translator – stator overlap is decreasing. This decreased line force would allow the buoy and the translator to accelerate just before hitting the endstop, which would increase the peak force of the endstop hit. This paper is studying the impact on the peak force of a decreasing translator –stator overlap.  It is also comparing the peak force of a deep water extreme wave event with the peak force generated by a tsunami wave. An OpenFOAM model, previously validated with wave tank experiment, is used for the study.</p>","authors":"L. Sjokvist","topic":"5","file":"WAVHYD-01-653.pdf","bib":"WAVHYD-01-653.bib"},
{"paperid":"654","title":"Validation of a CFD Tool for Studying the Behaviour of Wave Energy Converters","keywords":"<p class=IEEEParagraph>The National Research Council of Canada (NRC) previously conducted a series of physical model studies on point absorber type wave energy converters (WECs) in order to help industry evaluate and optimize different conceptual designs. Different WEC mooring systems and float designs were tested in a range of operational and survival (extreme) wave conditions. In each test case, various hydrodynamic and WEC response parameters such as water levels, wave loads, and WEC motions were measured.</p> <p class=IEEEParagraph>The present study evaluates the performance of a FLOW-3D CFD model in predicting the dynamic behaviour of point absorber type WECs subject to wave forcing. CFD simulations are conducted under irregular and regular incident wave conditions for two different mooring systems. The simulation results are compared with data measured in the physical modelling study. The CFD model predicts most of the measured data with an overall error of less than 10% which demonstrates that FLOW-3D can be considered as a viable alternative for modelling the dynamic response of point absorber type WECs.</p>","authors":"A. Pilechi, S. Baker, A. Cornett","topic":"3","file":"WAVDEV-01-654.pdf","bib":"WAVDEV-01-654.bib"},
{"paperid":"655","title":"The Impact of Waves and Immersion Depth on Horizontal Axis Tidal Turbine Performance","keywords":"The impact of waves and immersion depth on a two-bladed horizontal axis tidal turbine were investigated. This study presents experimental results at five different tip immersion depths and with regular and irregular waves.","authors":"M. Sos, L. Johnston, J. Walker, M. Rahimian","topic":"6","file":"TIDHYD-01-655.pdf","bib":"TIDHYD-01-655.bib"},
{"paperid":"656","title":"Monitoring of Subsea Cable Terminations at FORCE Tidal Turbine Test Site","keywords":"<p class=IEEEParagraph><span lang=EN-AU>The Fundy Ocean Research Center for Energy (FORCE) deployed sensor packages within the terminations of two subsea transmission cables at the tidal test site in the Minas Passage, Nova Scotia, Canada to monitor the stability of the cable terminations on the seafloor.</span></p><p class=IEEEParagraph><span lang=EN-AU>The sensor package was installed in the cable abandonment termination endcaps of two transmission cables prior to the deployment of the subsea cables at the FORCE test site. Each sensor package includes an AHRS sensor and a microphone. The AHRS sensor outputs orientation and accelerometer data. </span></p><p class=IEEEParagraph><span lang=EN-AU>Orientation data collected from the sensor package of each of the cable terminations indicates that the orientations of the abandonment terminations are stable on the seabed over the period of March 28 to April 24, 2015 and April 25 to June 5, 2015.</span></p><p class=IEEEParagraph>Accelerometer data collected from the sensor packages indicate movement of materials on the seabed around the abandonment terminations. This movement has also been recorded by the sensor package microphones.</p><p class=IEEEParagraph><span lang=EN-AU>This paper will present the details and characterization of the sensor package installed in the cable abandonment terminations and analysis of the data collected from the sensor packages deployed in the cable terminations at the FORCE tidal test site. </span></p>","authors":"S. Campbell, D. Groulx, D. Doman, T. Wright","topic":"12","file":"MRGFND-01-656.pdf","bib":"MRGFND-01-656.bib"},
{"paperid":"657","title":"A Frequency-Domain Model for a Novel Wave Energy Converter","keywords":"The Ocean Grazer's WEC  utilizes an adaptable multi-pump multi-piston power take-off (MP2PTO) system that consists of a grid of interconnected floater elements (which we term as a floater blanket), with each floater being connected to a piston-type hydraulic pumping system (a multi-piston pump, MPP). The present work aims to develop a frequency-domain model to investigate the hydrodynamic behaviour of the floater blanket perpendicular to the incident waves, aiming to identify the optimal settings for the PTO system under various sea states. In this work, the hydrodynamic coefficients are calculated by using the open-code NEMOH which enables us to solve the scattering and radiation problems for an array of floating bodies. The interconnections of the floater elements are handled by solving a set of motion equations of the multibody system and additional constraint equations for the hinges. Based on the model, we investigate a floater blanket consisting of ten floater elements. The model is validated by comparisons with our time-domain model developed by SIMULINK and based on the open-code, WEC-Sim. The hydrodynamic behaviour of the floater blanket is quantified by the response amplitude operator (RAO) of each floater element, and the performance of the MP2PTO system is evaluated by the energy extraction of the MPP units. The effects of the diffraction, radiation and interconnection are investigated by performing the simulations of the floater blanket in a channel as well as the open sea. The energy extraction of the PTO system with various configurations is studied to identify the optimal configuration across sea states. The present work will be instrumental in the development of advanced control algorithms for the Ocean Grazer device.","authors":"Y. Wei, J. Barradas Berglind, M. van Rooij, W. Prins, B. Jayawardhana, A. Vakis","topic":"5","file":"WAVHYD-02-657.pdf","bib":"WAVHYD-02-657.bib"},
{"paperid":"660","title":"A New Tool for Selecting Sites for Co-located Wave and Wind Farms – the CLF Index","keywords":"<p class=IEEEParagraph><span lang=EN-AU>Marine energy is one of the most promising solutions to attempt the ambitious renewable energy target of 20% by 2020 due to its very substantial energy resource; however, it is often considered uneconomical and difficult, and this may hinder its development. Combined energy systems such as co-located offshore wind turbines and wave energy converters, have recently emerged as a solution to increase the competitiveness of marine energy by taking advantage of the synergies between renewables; which would lead to a more sustainable use of the marine resource, reductions in the energy cost and improvements in the power output variability. Moreover, combined energy systems would allow to deal with the conflicts between marine energy projects and other sea other activities such as shipping, fishing, sand and gravel extraction, military activities and the exploitation of oil and gas reserves. On this basis, the objective of this paper is to define a new tool to determine suitable locations for deploying a co-located wind and wave energy while maximising the benefits derived from the combination. The tool is implemented by a case study at the North Sea in combination with third generation models.</span></p>","authors":"S. Astariz, A. Vazquez, G. Iglesias","topic":"10","file":"ECONOM-PP-660.pdf","bib":"ECONOM-PP-660.bib"},
{"paperid":"661","title":"Advanced Control Methods for Cross-Flow Turbines","keywords":"<p>Cross-flow (vertical-axis) turbines have a number of potential advantages for applications in marine hydrokinetic energy. Unlike axial-flow (horizontal-axis) turbines, the foils in a cross-flow turbine encounter cyclically varying flow conditions as a function the foil azimuthal position. We show that through varying the angular velocity of the turbine as a function of blade position, it is possible to optimize fluid forcing and kinematics to improve turbine power output. Through experiments we demonstrate a 59% increase in rotor mechanical efficiency over standard control methods. Under some operational conditions, the varying flow conditions encountered by the blade result in the periodic shedding of coherent flow structures into the turbine wake. A second advanced control method is presented whereby two closely spaced turbines are controlled in a coordinated manner. Beneficial interactions between the coherent wake structures shed by the upstream turbine and the foils of the downstream turbine result in an array performance greater than an equivalently sized turbine. Finally, both coordinated control and variable angular velocity control methods are applied to an array of two turbines, resulting in improved array power conversion efficiency.</p>","authors":"B. Strom, S. Brunton, B. Polagye","topic":"4","file":"TIDDEV-01-661.pdf","bib":"TIDDEV-01-661.bib"},
{"paperid":"664","title":"Development of the Tamar River tidal test facility","keywords":"<p class=IEEEParagraph>Tidal energy developers face significant costs associated with the field testing of prototypes. Open field test sites allow developers to test their devices at purpose built test sites at a reduced cost.</p> <p class=IEEEParagraph>The Tamar River is a 60 km estuary in the northern region of Tasmania, Australia with a tidal range of approximately 3 m. At the Batman bridge the river’s width narrows to 225 m resulting in high velocity flow making it an ideal location for the development of an open tidal test facility.</p> <p class=IEEEParagraph>Determining the test site’s exact location within the river required the consideration of a number of factors including environmental, regulatory and practical.</p> <p class=IEEEParagraph>Two sites within the estuary were selected for high and low velocity flows where detailed flow measurements were taken and an assessment of tidal energy resource performed.</p> <p class=IEEEParagraph>Traditional mooring systems require sediment on the sea floor posing a challenge for sites with high tidal flow. A study into mooring solutions was performed and a large gravity anchor system was selected.<em></em></p> <p class=IEEEParagraph>This project has resulted in the development of two open tidal test sites with different flow characteristics within the protected waters of the Tamar River estuary.</p>","authors":"T. Mitchell Ferguson, I. Penesis, N. Kemp, R. Frost, K. Sartipi, J. Nader, R. Cossu","topic":"2","file":"TIDRES-01-664.pdf","bib":"TIDRES-01-664.bib"},
{"paperid":"666","title":"Anchoring strategies for floating wave energy converters","keywords":"<p class=IEEEParagraph>The high levelised cost of wave renewable energy compared to fossil fuel and other renewable energy sources remains an obstacle to full commercial development. Mooring and foundations typically represent a high part of the overall deployment cost, especially for large floating devices (&gt;100kW). This is essentially because foundations solutions and design approach are transferred from the offshore oil and gas industry, which has applied a high level of over conservatism, considering the environmental and human risk associated with structure failure. Besides the risk factor, there are also several scientific and engineering considerations that limit a direct technology transfer from the oil and gas practice.</p><p class=IEEEParagraph>These considerations are discussed in the paper and innovative strategies to reduce the size and hence cost of foundations for floating wave energy converters. This includes the four fsurvivibility, avoidance, temporary additional capacity and laod sharing.</p><p class=IEEEParagraph>The paper reviews the suitability of the existing foundations concepts with respect to these four strategies and proposes new foundation design for floating wave energy converters.</p>","authors":"C. Gaudin","topic":"12","file":"MRGFND-01-666.pdf","bib":"MRGFND-01-666.bib"},
{"paperid":"668","title":"Wake predictions from two turbine models using mesh-optimisation techniques","keywords":"<ul><li>Two turbine models, the actuator disk momentum theory<br />(ADM) model and the actuator line (AL) model have<br />been implemented within the finite element CFD solver<br />Fluidity which possesses mesh-optimisation and mesh<br />adaptivity capabilities. </li><li>The fluid solver is the unsteady RANS with the k-omega SST turbulence model</li><li>The comparison study considers two turbines operating in line with different tip-speed ratios. </li><li>The models’ wake predictions agree well with existing experimental data, while<br />the power and thrust coefficients obtained from the AL model exhibit a maximum discrepancy of 9%.</li><li> The paper summarises the advantages and disadvantages of the<br />two methods and the benefit of using mesh optimisation techniques in reducing the<br />computational cost of turbine array simulations</li></ul>","authors":"G. Deskos","topic":"6","file":"TIDHYD-01-668.pdf","bib":"TIDHYD-01-668.bib"},
{"paperid":"671","title":"Generalization of the hydrostatic force approximation for large angles of rotation","keywords":"<p>A popular methodology used in the literature to study the temporal evolution of WECs involves the solution of Cummin’s equation, based in linear potential theory. The classical approach was to approximate the hydrostatic force by a constant matrix multiplied by the movements of the floating body. The validity of such approximation was restricted to bodies with small rotational movements. In the last years, some WECs have been developed where the angles of rotations are not small, like the ISWEC or the Penguin. Therefore, it is necessary to develop a general methodology that can avoid such restriction of small amplitudes of rotation.</p><p><br />A general methodology to compute the hydrostatic force based in the instantaneous submerged volume and centre of buoyancy using a panelization of the WEC is described in this paper. The methodology is compared against theoretical results from and complicated geometries. A validation, against laboratory results, is presented. The influence of the used approximation to the hydrostatic force is clearly seen, where both nonlinear methods accurately reproduce the laboratory results.<br /><br />In the future paper the influence of the three approximations of the hydrostatic force in the analysis of a generic 3D non-symmetric WEC will be included.<br /><br /></p>","authors":"J. Armesto, R. Guanche, V. Ayllón","topic":"5","file":"WAVHYD-PP-671.pdf","bib":"WAVHYD-PP-671.bib"},
{"paperid":"672","title":"A resource assessment to inform second-generation tidal-stream energy device design","keywords":"<p>Tidal-stream energy sites are currently considered viable in water depths between 25m and 50m, with peak spring tidal velocities that exceed 2.5m/s. As many areas may not be suitable for tidal-stream energy (e.g. environmental constraints or distance to grid connection), the development of so-called “2<sup>nd</sup> generation” sites (lower tidal velocity sites not limited by water depth) could be an important step so the potential of tidal-stream energy can be fully realised. Global ERA-Interim wave data, and wave observations at two tidal-stream energy sites in the UK, suggest the vast majority of tidal energy sites around the world are exposed to a wave climate that may affect resource assessments and engineering considerations. Our analysis reveals the global tidal-stream energy resource is not accurately resolved, and underestimated, by the current suite of freely available products. Further, sea-space for the current design of tidal-stream energy devices is likely to be extremely limited due to challenges such as water depth and waves. Therefore 3D oceanographic data, including wave climate and wave-tide interaction, at kilometre-scale spatial resolution appears necessary to inform the industry for a globally deployable device that can make meaningful contributions to renewable energy targets.</p><span style=white-space: pre;> </span>","authors":"M. Lewis","topic":"2","file":"TIDRES-01-672.pdf","bib":"TIDRES-01-672.bib"},
{"paperid":"673","title":"Deterministic Prediction of Irregular Incident Waves for Wave-by-Wave Control of Wave Energy Converters","keywords":"<p>It has been known since the eighties that wave-by-wave optimum power conversion requires a non-causal control force.  Prediction of incident waves may be obtained using a deterministic propagation model via up-wave measurements.  Two measurement approaches may be used, in order, fully to account for the range of group velocities in practical wave climates: (1) fixed-time, and (2) fixed point.</p><p>This paper reviews prior work related to these two approaches, examines the sensitivity of a uni-directional, fixed-point approach to wave direction, and compares results based on both, fixed-point and fixed-time, approaches.  The fixed-point approach is applied in a bi-directional wave field to obtain predictions for an oscillation-constrained heaving buoy type wave energy converter. These results are compared with results based on a control technique that uses feedback alone, together with power electronics circuitry.</p><p> </p>","authors":"U. Korde, R. Robinett, III, G. Bacelli, D. Wilson, O. Abdelkhalik","topic":"5","file":"WAVHYD-02-673.pdf","bib":"WAVHYD-02-673.bib"},
{"paperid":"674","title":"Energy Generation from Anti-Motion Device of Very Large Floating Structure","keywords":"<p class=IEEEParagraph><span lang=EN-AU>Very large floating structure (VLFS) has been proposed as floating artificial island in land scarce or low lying countries due to its ability in creating additional land parcels to cater for the increase in population and urban development. In order to increase the workability of a VLFS under severe wave condition, the hydroelastic response of VLFS under wave action has to be mitigated and this can be done by using various types of anti-motion devices. This paper focuses on the articulated plate type anti-motion device where plates are hinged connected to the VLFS in order to attenuate the wave forces. Power take-off (PTO) systems are proposed to be installed on the hinged joints in order to convert the rotational kinetic energy into electricity to power the floating artificial island.</span></p> <p class=IEEEParagraph><span lang=EN-AU>The aims of the paper are to seek for the suitable length of the articulated plate and the PTO damping value that could mitigate the hydroelastic response of the VLFS while generating substantial amount of energy from the wave to power the artificial island. The VLFS connected by the articulated plates are subjected to regular waves of different wave periods and power take-off system of different damping values.</span></p>","authors":"Z. Tay","topic":"5","file":"WAVHYD-02-674.pdf","bib":"WAVHYD-02-674.bib"},
{"paperid":"675","title":"CFD Study on Hydrodynamic Performance of Horizontal Axis Tidal Turbine under the Action of Linear Wave","keywords":"Considering the real sea conditions, the hydrodynamic performance of a full-scale horizontal axis tidal turbine was numerically simulated using wave statistic date and velocity data from a real tidal site. The joint influence of wave-current on the performance and thrust force of the turbine  was compared, results of which showed that power output and axis load on the turbine varied periodically while running under the action of wave and current, which not only lead to decrease of power output and dynamic stability of the turbine, but the problem of vibration and shorten fatigue life of the turbine consequently. Therefore, it is necessary to improve the strength of the turbine and its supporting structure in order to improve the service life of the energy conversion device.<br />","authors":"C. Si, J. Wang, J. Li, P. Yuan, Z. Tan","topic":"6","file":"TIDHYD-01-675.pdf","bib":"TIDHYD-01-675.bib"},
{"paperid":"676","title":"Reservoir type WEC for micro-tidal environments","keywords":"<p class=IEEEParagraph>Reservoir wave energy converters consist of a wave ramp, a storage reservoir with a water level above Mean Water, and a low-head hydropower converter. Their advantages are: (a) only mass concrete ramps are exposed to waves, improving survivability, and (b) the reservoir constitutes intermediate storage, improving power quality. The principal disadvantage is the strong effects of tidal water level variations. In the literature, the hydraulic efficiency of reservoir WECs was reported to reach a maximum of 30%. At Southampton University, a series of model tests was conducted for a reservoir WEC for micro-tidal environments. The model comprised the full power conversion chain from wave to shaft, employing a very low-head hydropower converter developed in Southampton. The tests showed that energy dissipation fences are required to suppress internal waves. This increased the hydraulic efficiency to 36%. The total wave-to-shaft efficiency was a function of the wave height to freeboard ratio, reaching 0.18 to 0.2 and 0.10 for 0.75 ≤ H/Rc ≤ 1.8 even though the system had no active control. The experiments demonstrated that tests with a complete power conversion chain allow to address adverse interaction effects, to identify improvements and to obtain a realistic power production prediction.</p>","authors":"G. Muller, F. Buriani","topic":"3","file":"WAVDEV-01-676.pdf","bib":"WAVDEV-01-676.bib"},
{"paperid":"678","title":"Wave energy in California in the late 19th Century","keywords":"<p>In the late 19th Century, the Californian economy expanded, and its demand for energy increased. One solution was seen in the power of the waves. A large number of wave energy projects  was proposed, and more than 20 prototypes were  built. Most of the “Wave Motors” however either did not function, or were soon destroyed by waves. Two interesting projects are described in more detail.  GERLACH’s Wave Motor consisted of two water wheels of 50 feet (16.7 m) diameter, and 20 feet (6.7 m) width mounted on a wooden pier. It was expected to deliver 600 hp (440 kW), but failed to function.  A simple theory indicated that such a converter can reach efficiencies of 44%, this would result in a power of 280 kW. ARMSTRONG’s Wave Motor was a heave WEC with a 1.7 m diameter floating 270 kg weight in a vertical shaft in a rock cliff. The weight was connected with a plunger pump, lifting water 30 m into a container. Theory indicates a power output of 0.9 to 1.2 kW, which could be increased to 5 to 7 kW. It worked continuously for 11 years, making it arguably the most successful WEC so far.</p>","authors":"G. Muller","topic":"3","file":"WAVDEV-01-678.pdf","bib":"WAVDEV-01-678.bib"},
{"paperid":"679","title":"Feasibility study of applying SPH in a coupled simulation tool for wave energy converter arrays","keywords":"The deployment of multiple floating wave energy converters (WEC) at an offshore location influences the incident wave field by reflection, diffraction and radiation. The superposition of these phenomena results in a complex perturbed wave field. In order to accurately simulate wave propagation through a WEC farm, both near field and far field effects need to be accounted for. This can be achieved by coupling of different solvers for the near field and far field. For linear simulation over variable bathymetry, there have been studies coupling a wave propagation solver and a BEM potential flow solver. However, real sea conditions are characterised by irregular, 3D waves with the occurrence of non-linear effects. For this reason a novel coupling methodology is suggested, where a fast wave propagation model (OceanWave3D) accounts for the far field effects and an accurate wave-structure interaction model, based on the smoothed particle hydrodynamics formulation (DualSPHysics) is applied for the near field effects. The combined model allows for simulation of WEC devices in higher order irregular waves and more extreme wave conditions.","authors":"T. Verbrugghe, B. Devolder, J. Domínguez, A. Kortenhaus, P. Troch","topic":"5","file":"WAVHYD-03-679.pdf","bib":"WAVHYD-03-679.bib"},
{"paperid":"680","title":"Estimating the Optimum Installed Capacity of a Tidal Energy Converter Array, an example for the Faro-Olhão Inlet (Portugal)","keywords":"<p>This paper investigates the optimum density of a Tidal Energy Converter (TEC) array at a tidal channel by applying Surrogate-Based Optimisation (SBO), considering both power production aspects and hydro-morphodynamic constraints to avoid detrimental environmental impacts. This method provides a less expensive surrogate model of a more complex model that can be incorporated into a constraint mathematical model to find an optimal solution. Here, we present an example for the Faro-Olhão Inlet in the Ria Formosa, Portugal, a potential site for tidal in-stream energy extraction, where next April 2017 under the research project SCORE, a 1/10th scale Evopod (1 kW floatable prototype from Oceanflow Energy Ltd.) will be deployed, thereby constituting the first TEC deployment in Portuguese waters. The Delft3D-Flow package has been selected to conduct 2DH hydro-morphodynamic simulations to assess the effects on the lagoon of different TEC array densities. TECs are modelled using a quadratic law based on actuator disk theory and included as an additional stress term in the equations of conservation of linear momentum. The hydrodynamic model and TEC parameterisation have been calibrated and validated using time series of water elevation and flow velocity from tide gauge and ADCP data before and during TEC operation.</p>","authors":"E. González-Gorbeña, A. Pacheco, T. Plomaritis, C. Sequeira","topic":"6","file":"TIDHYD-PP-680.pdf","bib":"TIDHYD-PP-680.bib"},
{"paperid":"682","title":"Multi-parameter optimization of  hybrid arrays of point absorber wave energy converters","keywords":"<span style=color: #000000;>In this paper the influence of having different sizes of wave energy converters in the same park is evaluated by the extension of a customizable tool based on a genetic algorithm. Two different cost function are used in the optimization scheme and their results compared. The method has been applied to simultaneous optimization of some important design variables of a wave energy farm, such as the geometry of the buoys and the damping coefficient of the electric generator. Spatial layout optimization has also been performed with hybrids parks, i.e. arrays consisting of point absorbers of different dimensions. It is shown that the choice of the cost function has a great impact on the results of the optimization and that a slightly larger power production can be achieved by deploying devices of different sizes in a hybrid park.</span>","authors":"M. Giassi, M. Göteman, S. Thomas, J. Engström, M. Eriksson, J. Isberg","topic":"5","file":"WAVHYD-03-682.pdf","bib":"WAVHYD-03-682.bib"},
{"paperid":"684","title":"Pitch Control Systems for A Cross-Flow Turbine","keywords":"<p>This work expands upon hydrodynamic research using two-dimensional computational fluid dynamics (CFD) to analyse three passive pitch control systems: one-term harmonic series, two-term harmonic series, and an angle of attack (AOA) limiter function. A primary design consideration for CFTs is dynamic stall, characterized by airfoil lift past the static stall AOA. This research investigates if the management of stall in CFTs through passive pitch control can exceed the performance of a fixed-pitch system. An H-CFT with three blades is simulated and to be compared against an experimental turbine in the future.</p> <p>Two parameters are investigated:  simulated angle of attack derived from individual blade forces and coefficient of power based on total turbine torque.  Preliminary results suggest that passive pitch control systems can increase performance and lessen dynamic stall effects simultaneously. A better choice of maximum AOA may result in improved <em>Limit </em>performance and/or further dynamic stall reduction for both <em>Hmc1 </em>&amp; <em>Hmc2</em>. Extended analysis will include consideration of stall onset angles and wake vortices.</p><p> </p>","authors":"T. Gauthier","topic":"6","file":"TIDHYD-01-684.pdf","bib":"TIDHYD-01-684.bib"},
{"paperid":"685","title":"Australia’s technical wave energy resource","keywords":"<p class=IEEEParagraph>The available total wave energy resource which intersects the 25 m depth contour around the Australian coast in an average year has been estimated at approximately 1800 TWh/yr. This would suggest Australia has the largest wave resource of any country in the world, thus an attractive prospect for ongoing wave energy development.</p><p class=IEEEParagraph>Approximately 85% of Australia’s 23 million population live within 50 km of the coast, which provides further incentive to investigate ocean renewable energy as a means of consistent renewable energy supply to support Australia’s future low-emission energy needs. However, this population is predominantly located along the Pacific east coast of the continent, whereas the available wave resource is most energetic along the southern margin. Further investigation of the technical wave energy resource availability, which is considerate of proximity to Australia’s electricity grid, other spatial constraints, and device capacity factor, is needed.</p><p class=IEEEParagraph>The Australian wave energy atlas now provides more refined information on the spatial variability of the wave energy resource around the Australian coast. Improved resource information, along with more recent technology power matrix information available from public domain physical tank investigations allows the prior technical wave energy resource assessment for Australia to be extended beyond an NEM focussed study, considering also the contribution to other interconnected grids in Australia.</p>","authors":"M. Hemer","topic":"1","file":"WAVRES-01-685.pdf","bib":"WAVRES-01-685.bib"},
{"paperid":"687","title":"Development of a low head tidal turbine Part 2: Model testing and performance evaluation","keywords":"<p class=IEEEParagraph><span lang=EN-AU>In the course of the Eurostars research project Safe*Coast, an innovative concept of a turnable tidal turbine for barrage type power plants has been developed. The axial low-head hydro turbine is capable of four-quadrant operation.</span></p> <p class=IEEEParagraph><span lang=EN-AU> </span></p> <p class=IEEEParagraph><span lang=EN-AU>An extensive concept study has been conducted in order to identify a feasible design and operation strategies. The chosen design has been optimized for both turbine and pump mode using CFD simulations. </span></p> <p class=IEEEParagraph><span lang=EN-AU> </span></p> <p class=IEEEParagraph><span lang=EN-AU>Thereafter, a model turbine based on the optimized hydraulic design has been built and integrated into a closed loop turbine test rig at the Dieter-Thoma-Laboratory at TUM.</span></p> <p class=IEEEParagraph><span lang=EN-AU>As the test rig is suitable for pump and turbine testing, all the relevant parameters for the performance evaluation can be obtained. The paper will describe the test rig and the design of the model turbine. The results of the performed experiments will be presented. Based on these results, a non-dimensional performance hill chart will be compiled, giving exact information on the efficiency as a function of head and operating speed. Additionally, the operation limits with respect to cavitation will be described. A thorough evaluation of the performance in turbine and pump mode in respect to the demanded requirements will be given.</span></p>","authors":"T. Schechtl, S. Hötzl, P. Rutschmann, W. Knapp","topic":"4","file":"TIDDEV-01-687.pdf","bib":"TIDDEV-01-687.bib"},
{"paperid":"689","title":"Structural design effects on hydrodynamic interaction of the combined WindWEC concept","keywords":"<p>Offshore wind energy is widely recognized as a useful renewable energy capable to satisfy the increasing energy need and to increase globally the security of energy supplies; in order to support offshore wind turbines various Floating Wind Turbine (FWT) structures are possible for use. Apart from offshore wind energy, offshore areas contain other potential forms of renewable energy such as ocean waves. It is therefore of interest to investigate the possibility to utilise these energy potentials, offshore wind and wave energy, simultaneously using common support floating structure in order to possibly reduce the overall cost as well as to ensure an efficient usage of the ocean space. A very recently proposed combined wind and wave energy system is the WindWEC; a hybrid offshore energy system that consists of a floating wind turbine supported by a spar-type substructure (e.g. Hywind) and the wave energy converter Wavestar. The evaluation and deep understanding of the hydrodynamic coupling effects between the different floating bodies is of high importance for the further successful development of the combined concept WindWEC. In this paper, the effect of structural design parameters on the hydrodynamic interaction between the different platforms of wind turbine and wave energy converters are evaluated and examined. These structural design parameters are the distance of the Wavestar with respect to the spar platform of the wind turbine, the characteristic diameter of the Wavestar, and/or the number of Wavestar wave energy converters that can be used simultaneously.</p>","authors":"M. Karimirad, C. Michailides","topic":"8","file":"STRMAT-01-689.pdf","bib":"STRMAT-01-689.bib"},
{"paperid":"691","title":"Characterisation of Ocean Energy Resource to IEC standards: Westwave Project Experience","keywords":"<p class=IEEEParagraph><span lang=EN-AU>Increased activity in the marine energy sector has driven the need for improved knowledge of wave climate and design wave conditions, which are fundamental to any marine energy project. This site assessment work has further created the need for a set of unifying standards to address shortcomings in input wave data, analysis and modelling methods.</span></p> <p class=IEEEParagraph><span lang=EN-AU>This paper aims to highlight the implications of fulfilling IEC 62600-101</span><span lang=EN-AU> standards in the context of a utility led wave energy project.</span></p> <p class=IEEEParagraph><span lang=EN-AU>The Westwave project involves the development of a 5MW wave energy converter (WEC) array off the coast of Killard Point in Co. Clare, Ireland. WECs will be installed in either nearshore or offshore areas, depending on technology type selected.</span></p> <p class=IEEEParagraph><span lang=EN-AU> </span></p> <p class=IEEEParagraph><span lang=EN-AU>The paper will firstly detail the wave climate and resource modelling methodology and validation processes being undertaken by the author. The practical considerations of carrying out this process in line with IEC 62600-101 will be demonstrated.</span></p><p class=IEEEParagraph><span lang=EN-AU>The major motivation of this work is to improve the accuracy and dependability of the use of a variety of numerical and real data sources, and to distil these into a consistent form that can be analysed in a standard manner such that to reliably inform the WEC design process.</span></p>","authors":"A. Barker","topic":"1","file":"WAVRES-01-691.pdf","bib":"WAVRES-01-691.bib"},
{"paperid":"693","title":"Distortion effects on Turbulence in a Tidal Flow due to the Mean Flow field of a Horizontal Axis Tidal Turbine","keywords":"This paper is concerned with distortion of incident turbulence in a tidal stream channel by the mean flow field of the rotor. Theoretical assessments of the amplification of the streamwise component of the turbulence are given based on Rapid Distortion of Turbulence theory supported by measured turbulence data from the flow measurement site in islay Sound. The implications for unsteady rotor blade loading are discussed.","authors":"M. Graham, I. Milne","topic":"6","file":"TIDHYD-01-693.pdf","bib":"TIDHYD-01-693.bib"},
{"paperid":"699","title":"Experimental Validation of Receding Horizon Pseudo-Spectral Control on a 1/20 th Scale Hinge-Barge Wave Energy Converter","keywords":"This paper addresses the real-time optimal control of a 1/20th scale three-body hinge-barge Wave Energy Converter (WEC). The relative pitch motions between the central barge and the lateral barges drive PowerTake Off (PTO) systems which extract energy from the device. The objective of the control is to maximize the power extractedby the PTOs. In this paper, an optimal Pseudo-Spectral (PS)control based on the Half-Range Chebyshev-Fourier (HRCF) basis functions is presented. Theoretical simulations are carried out in order to compare the performances of the PS control to the performances of a control strategy based on optimal passive dampers for the PTOs, and to the unconstrained active controller. Tank tests will be carried out on a 1/20 th scale three-body hinge-barge provided by Wave Energy Conversion Corporation of America (WECCA) in order to experimentally validate the PS control.","authors":"F. Paparella, J. Ringwood","topic":"5","file":"WAVHYD-03-699.pdf","bib":"WAVHYD-03-699.bib"},
{"paperid":"702","title":"Advancing Environmental Monitoring through Integrated Instrumentation","keywords":"<p>Environmental monitoring of a marine energy site requires a combination of active acoustic, passive acoustic, and optical sensors. These sensors must meet three objectives to be effective: (1) not affect the environment by operation, (2) capture rare events with high probability, and (3) avoid accumulating and amount of data that cannot practically be stored or analyzed. The Adaptable Monitoring Package is an integrated instrumentation package that meets these objectives through real-time detection and classification of marine animals. Classification results are used to control sensor functionality and data acquisition, resulting in a useful amount of high-value data that describes the environmental interactions at a marine energy site.</p><p> </p>","authors":"E. Cotter","topic":"9","file":"ENVIRO-01-702.pdf","bib":"ENVIRO-01-702.bib"},
{"paperid":"703","title":"Latching and peak-power control of an Oscillating water column based on a Discontinuous Galerkin Method","keywords":"<p>A very important characteristic of the oscillating-water-column (OWC) wave energy converters is the possibility of control or dissipate any excess of energy available to the power take-off system. The IDMEC/IST is developing a novel self-rectifying biradial turbine with a geometry that accommodates a sliding mechanism that operates as a high-speed stop valve (HSSV). The present paper deals with the control of the HSSV for latching combined with peak power control. The contributions of the present paper are: i) formulation of the optimal control problem of latching combined with peak-power based on the Pontryagin's Maximum Principle (PMP); ii) a regularization term is introduced in the PMP formulation to improve the stability and the increase the convergence rate of the numerical solution; and iii) a new numerical method for the solution of the PMP optimal control problem based on a Discontinuous Galerkin Finite Element Method. Results are presented for a spar-buoy OWC under irregular waves. The proposed control algorithm shows large improvements in the extracted mean power while limiting the peak-to-average power ratio, thus improving the power quality. Moreover, the new methodology is also a very effective alternative to the pseudo-spectral methods for linear and non-linear optimal control problems.</p><p> </p>","authors":"J. Henriques, J. Lemos, L. Gato, A. Falcão","topic":"7","file":"GRDPTO-01-703.pdf","bib":"GRDPTO-01-703.bib"},
{"paperid":"704","title":"Effect of Solidity and Gap-to-Chord ratio of a Biplane Wells Turbine","keywords":"<p>Wells turbine is the most used power take-off device installed in Oscillating Water Column wave energy systems. The biplane Wells turbine has higher torque coefficient and wider operating range compared to the conventional monoplane Wells turbine.  Solidity and the gap-to-chord ratio are the two main parameters affecting the performance of this turbine. In this work, the effect of the gap-to-chord ratio is studied numerically for two different values of turbine solidity. In the present investigation, the numerical analysis is carried out in finite volume based commercial software ANSYS-CFX v15.0. The objective of the present work is to find out the optimal gap-to-chord ratio for different turbine solidity.</p>","authors":"T. Das, A. Samad","topic":"3","file":"WAVDEV-02-704.pdf","bib":"WAVDEV-02-704.bib"},
{"paperid":"705","title":"“Mooring replacement: solving conventional problems in an innovative way”","keywords":"<p>The marine energy sector has a clear need to share experiences and lessons learnt from the development of real projects. This paper is focused on this pressing issue.</p> <p> </p> <p>Located in the Basque Country, the Biscay Marine Energy Platform (BiMEP) is an open-sea facility to support technical testing and commercial demonstration of full-scale floating Marine Renewable Energy Devices (MRED). BiMEP provides manufacturers of such devices with ready-to-use facilities to validate their designs and to test their technical and economic feasibility. A number of MRED developers have expressed interest in using BiMEP and the first device was deployed on October 2016.</p> <p> </p> <p>With specific reference to the moorings of our subsea cables marking buoys, a wide-ranging series of problems and unforeseen events have been encountered. When problems come up, there is not room for manoeuvre and these are addressed and resolved in a conventional way. But operation experience and time give the opportunity to apply and develop innovative methods to prevent new similar problems from materializing.</p> <p> </p> <p>The main objective of this paper is therefore to present a real experience on replacing parts of the moorings of the subsea cables marking buoys, describing the initial problems encountered and the solution developed using non-conventional means.</p>","authors":"D. Marina, Y. Torre-Enciso, O. Ajuria","topic":"11","file":"OPANDM-01-705.pdf","bib":"OPANDM-01-705.bib"},
{"paperid":"706","title":"Technology Assessment Processes for marine energy converters","keywords":"<p>The abstract outlines a project to develop and prove a technology assessment process for wave and tidal developers. The areas shown in the abstract are:</p><ul><li>The driver of the project</li><li>The influences of the project</li><li>The areas that the assessment process will focus on</li><li>How the process will deliver reliable results </li><li>The method in which the assessment will be carried out</li></ul><p> </p>","authors":"S. Pyke, C. Johnstone, E. Buck","topic":"4","file":"TIDDEV-01-706.pdf","bib":"TIDDEV-01-706.bib"},
{"paperid":"707","title":"Assessment of Numerical Wave Makers","keywords":"<p>A numerical wave tank (NWT) based on ComputationalFluid Dynamics (CFD) provides a useful tool for the analysis of offshore renewable energy (ORE) systems, such as wave energy converters (WECs). NWT experiments, of WECoperation, rely on accurate wave generation and absorption at the NWT boundaries. To tackle this problem, different methodologies, termed as numerical wave makers (NWMs), are available. The performance of these NWMs are often sensitive to properties of the experiment being performed, such as the frequency spectrum of the input sea state, the CFD solver used and/or the internal settings of the NWM. This paper discusses the desiredNWM capabilities, for effective analysis of marine systems, and then proposes a set of test cases to assess these capabilities for a given NWM. Results are presented for a sample NWM, the OpenFOAM toolbox OLAFOAM, and demonstrate the sensitivity of the NWM to the desired wave conditions and the global solver settings.The assessment methodologies introduced in this paper, and demonstrated for a single type of NWM, lay the groundwork for future evaluation and comparison of different NWM types, enabling appropriate NWM selection for NWT analysis of WECs</p><br /><p> </p><p> </p>","authors":"C. Windt, J. Davidson, P. Schmitt, J. Ringwood","topic":"5","file":"WAVHYD-03-707.pdf","bib":"WAVHYD-03-707.bib"},
{"paperid":"708","title":"High-Efficiency Current-Source Converter for All-Electric Wave Energy Conversion Systems.","keywords":"<p>This Paper relates to the development of an all-electric Power Take-Off (PTO) for a Wave Energy Converter (WEC) as part of the E-Drive project.</p> <p> </p> <p>One of the main objectives of this work is to develop an integrated low speed direct conversion PTO for a WEC. This will take the low speed high torque motion from the prime mover and convert it directly to electrical energy for the grid. The advantage of this approach is the reduction in mechanical complexity of the PTO, however, additional demands are placed on both the electrical machine and the Electrical Power Conversion System (EPCS).</p> <p> </p> <p>The EPCS is optimised to suit the time varying nature of the WEC power output. Further, the proposed EPCS is modular to improve reliability. It incorporates a Current Source Converter (CSC) as the generator interface, localised energy storage and a multilevel inverter as a grid interface.</p> <p> </p> <p>The paper focuses on the development of a CSC generator interface based on Reverse Blocking IGBT’s (RB-IGBT) and compares it to the more conventional voltage source topology.</p>","authors":"S. McDonald, V. Pickert, N. Baker","topic":"7","file":"GRDPTO-01-708.pdf","bib":"GRDPTO-01-708.bib"},
{"paperid":"709","title":"Marine Spatial Planning applied to tidal stream energy – a case study","keywords":"<p class=IEEEParagraph><ins datetime=2017-01-03T19:34 cite=mailto:Usuario>Over the last years Ria de Ribadeo, an estuary in NW Spain, has emerged as a site of interest for the exploitation of tidal stream energy thanks to its substantial tidal velocities</ins><ins datetime=2017-01-03T19:34 cite=mailto:Usuario>.  Due to the many demands of use of the marine space in this estuary, careful planning must be carried out so that the prospective tidal stream farm does not interfere with other activities. </ins></p> <p class=IEEEParagraph><ins datetime=2017-01-03T19:34 cite=mailto:Usuario>This work has two objectives. The first objective is to define the optimum location for a tidal stream farm taking into account the existing uses of the estuarine space. The second objective is to estimate the energy production that would be generated by a farm at the optimum location. A thorough study is carried out in which high-resolution numerical modelling of the estuary, validated with field data of tidal levels and flow velocities, is combined with marine spatial planning techniques. This combined approach, which can be applied elsewhere, is a prerequisite for an estuary management plan that will underpin the sustainable development of this area.</ins></p>","authors":"M. Álvarez, R. Carballo, N. Areán, M. Sánchez, V. Ramos, G. Iglesias","topic":"6","file":"TIDHYD-PP-709.pdf","bib":"TIDHYD-PP-709.bib"},
{"paperid":"711","title":"Development of a Large-Eddy Simulation approach for tidal currents modelling.","keywords":"<p>Tidal currents sites are very interesting for the deployment of turbines. However these sites involve many vortex structures, that can be very powerful. Those turbulent structures are triggered by the combinaison of a complex seabed morphology and extreme current magnitudes. Anticipating the effect of the vortex on the turbines, namely the influence on their performance or lifetime requires a thorough study of turbulence of the tidal stream areas.</p><p>As part of the THYMOTE project, characterizing these turbulent processes is based on Large-Eddy-Simulation (LES) numerical modelling. Indeed, these methods are now applicable for the environmental flow simulations due to the rise of the calculation ressources.</p><p>A LES approach is developed in the CFD code TELEMAC-3D , which aims to simulate free surface flows such as the figure 1. It consists in the implementation of subgrid models for LES, but also appropriate boundary conditions  and numerical schemes for this type of modelling. These developments are then used on simple cases for which experimental and numerical data are available.</p>","authors":"A. Bourgoin","topic":"6","file":"TIDHYD-02-711.pdf","bib":"TIDHYD-02-711.bib"},
{"paperid":"712","title":"Investigation of the benefits of adaptive control applied to the nonlinear CCell Wave Energy Converter","keywords":"<p>CCell is an oscillating surge wave energy converter (OSWEC) distinguished from other devices by its curved geometry which is believed to substantially increase captured power compared to a flat paddle. An effective PTO control strategy is necessary to achieve good efficiency. A previously studied control strategy based on the simple and effective method of Fusco and Ringwood has been tested, whereby a velocity reference is generated based upon knowledge of the measured wave elevation and the plant parameters (hydrodynamics, PTO and sensors). This reference signal keeps the angular velocity of the WEC paddle in phase with the wave excitation torque, which is the condition for efficient power capture. The subject of this paper is the modification of the velocity reference tracking component of the control system to incorporate an adaptive element to reduce performance degradation due to parameter uncertainty. The adaptive element is based upon a form of Model Reference Adaptive Control (MRAC) known as Minimal Controller Synthesis (MCS). Experimental testing and simulation results demonstrate that good performance can be achieved, and that performance is improved over a fixed gain strategy over a wide range of operating conditions when realistic plant PTO nonlinear effects and hydrodynamic parameter variations are imposed.</p>","authors":"A. Hillis","topic":"7","file":"GRDPTO-01-712.pdf","bib":"GRDPTO-01-712.bib"},
{"paperid":"715","title":"Challengers and Solution  for a New Underwater Moored TEC","keywords":"<p>In the paper it will be presented the new underwater moored multi-rotor TEC,named Hive-Tec, concveptual design including the proposal for a nrew simplified mooring syustyem.</p><p>Also it is presentred its control system and the results for the simulation of the critical TEC manoevres.</p>","authors":"L. Nuñez Rivas, A. Lopez Piñeiro, J. Somolinos Sanchez, M. Perez de la Portilla, R. Perez Fernandez","topic":"4","file":"TIDDEV-02-715.pdf","bib":"TIDDEV-02-715.bib"},
{"paperid":"717","title":"Training Wall Effects on Power Generation of Tidal Stream Turbine Arrays","keywords":"<p>Headlands are amongst the most promising features for potential tidal energy extraction sites, but the flow is significantly yawed. It has been suggested that guiding the flow has a positive impact on turbine loading and power production for this type of flow. This paper explores the effect of training walls on power generation and loading at an idealised headland case and a real site geometry with realistic bathymetry and oscillating flow. The open-source code DG ADCIRC is used to solve the depth-averaged shallow water equations (SWEs) and a Linear Momentum Actuator Disc Theory (LMADT) model represents the turbines. A parameter study is undertaken with the idealised headland site for both steady (constant flow rate) and unsteady flow conditions (sinusoidal water elevation). The parameters investigated in the study include shape, length, angle, thickness, and position of the training wall, as well as the length of the turbine array and the gradient of the headland. Differences between steady and unsteady cases are explored for a range of flow rates, frequencies and amplitudes. The most favourable configurations are examined in the real site case. A rough estimate of the economic viability of training walls, as well as their advantages and disadvantages are discussed.</p>","authors":"A. Schnabl, T. Adcock, G. Houlsby","topic":"2","file":"TIDRES-01-717.pdf","bib":"TIDRES-01-717.bib"},
{"paperid":"724","title":"Design, fabrication and testing of wave energy converters(WECs) using different power take-off mechanism with mechanical motion rectifier","keywords":"<p>Power takeoff system, the mechanism converts the wave motion into electricity, is still considered to be immature in the wave energy converter technology. To overcome this situation, in this paper, two PTO concepts and prototypes using electromagnetic generator with different mechanical structure, one using rack pinion structure and the other using ball screw structure, are designed to improve the efficiency of extracting ocean wave energy. In addition to that, a novel mechanism called Mechanical Motion Rectifier(MMR) is introduced, this mechanism is capable of converting bi-directional rotation into uni-directional rotation to further improve the efficiency. Furthermore, dynamic models for both PTO prototypes are built to simulate their performance, the effect of the MMR mechanism is also considered in these models to analytically prove that the MMR can increase the efficiency of the system. Finally, both prototypes are tested, the test results are compared with the simulation results to verify the dynamic model and prove the advantage of the MMR mechanism.</p> <p> </p> <p>Key words: Wave energy converter, power take-off, mechanical motion rectifier</p>","authors":"X. Li, C. Liang, J. Boontanom, L. Zuo","topic":"3","file":"WAVDEV-PP-724.pdf","bib":"WAVDEV-PP-724.bib"},
{"paperid":"725","title":"Cost, time and risk assessment of different wave energy converter technology development trajectories","keywords":"The paper presents a comparative assessment of three fundamentally different wave energy converter (WEC) technology development trajectories. This assessment shows that development trajectories that prioritize technology readiness over technology performance are likely to require twice the development time, consume threefold of the development cost, and are prone to a risk of failure of one order of magnitude higher than those development paths that initially prioritize technology performance over technology readiness.","authors":"J. Weber, J. Roberts","topic":"3","file":"WAVDEV-02-725.pdf","bib":"WAVDEV-02-725.bib"},
{"paperid":"727","title":"Performance of an adaptive pitch marine turbine system in turbulent inflow","keywords":"<div class=WordSection1><p>Marine turbines are typically placed in dynamic, energy-dense locations and are subject to complex spatially and temporally varying flow. To withstand the associated forces, marine turbine blades are increasingly constructed from fiber reinforced polymer (FRP) composites, which provide superior strength- and stiffness-to-weight ratios and improved fatigue resistance compared to metallic alloys. Furthermore, the bend-twist deformation coupling behavior of anisotropic composites can be utilized to develop an adaptive pitch mechanism, where elastic deformations vary dynamically with the loading condition. In this way, the pitch distribution of the blades can passively adjust in order to maintain an effective angle of attack at each blade section. A marine turbine will spend much of its operating life in varying levels of turbulent inflow, and the ability of an adaptive composite blade to passively adjust to the instantaneous flow and shed excess loading may be a valuable asset. To investigate this possibility, the experimental study presented here will explore the behavior of a flume-scale adaptive pitch turbine system in turbulent inflow. The authors will explore the implications of the results in terms of performance, efficiency, and system longevity and discuss possible applications to marine turbine control strategies.</p></div>","authors":"R. Barber, C. Hill, P. Babuska, A. Aliseda, M. Motley","topic":"4","file":"TIDDEV-02-727.pdf","bib":"TIDDEV-02-727.bib"},
{"paperid":"728","title":"Time-Varying Linear Quadratic Gaussian Optimal Control for Three-Degree-of-Freedom Wave Energy Converters","keywords":"Early studies in wave energy conversion (WEC) have pointed out the advantage of harvesting wave energy from an antisymmetric mode such as surge or pitch because the antisymmetric radiation pattern it generates, which can potentially enhance energy conversion for waves approaching from a certain direction.  Optimum conversion requires oscillations to maintain a certain amplitude and phase relation with respect to the exciting force.  This relationship can be challenging to determine when multiple modes are being used for conversion.  Moreover, when motions are large enough (as expected with control), modes such as surge, pitch, and heave become nonlinearly coupled. This nonlinearly coupled WEC dynamic system hinders the use of the linear control design methods. This paper shows that control of a WEC with heave-pitch-surge coupling at the second order can be approached as control of  a linear time-varying system. In this model the heave mode excites the pitch mode, which in turn is coupled with the surge mode. This paper presents a linear quadratic Gaussian optimal control based on this model.","authors":"O. Abdelkhalik, S. Zou, R. Robinett, U. Korde","topic":"7","file":"GRDPTO-02-728.pdf","bib":"GRDPTO-02-728.bib"},
{"paperid":"729","title":"U.S. Navy Wave Energy Test Site - Early Findings","keywords":"<p>The U.S. Navy's Wave Energy Test Site (WETS) is now fully operational and hosting its first two wave energy conversion devices since the commissioning of the full three-berth site, the first of its kind in the United States.  These devices are the Fred. Olsen Lifesaver and Northwest Energy Innovations Azura.  Several additional devices are scheduled for testing beginning with Ocean Energy later this year.  The Hawaii Natural Energy Institute (HNEI) is supporting Department of Energy and U.S. Navy research objectives at the site, and will present key lessons learned with respect to O&amp;M and power performance associated with these first two deployments, as well as a description of a vessel developed specifically for supporting WETS research objectives.  WEC numerical modeling methodologies employed to enhance performance assessment will be discussed, as will a study to examine the WETS resource in potential hurricane-induced wave conditions.  Additionally, a new in-house WEC concept under development at HNEI will be introduced.</p>","authors":"P. Cross, L. Vega, K. Rajagopalan, G. Nihous, N. Li, A. Rocheleau, P. Anderson","topic":"3","file":"WAVDEV-02-729.pdf","bib":"WAVDEV-02-729.bib"},
{"paperid":"730","title":"Acoustic Characteristics of the Lifesaver Wave Energy Converter","keywords":"<p class=IEEEAbtract><span lang=EN-GB>The Fred. Olsen Lifesaver, a point-absorber wave energy converter, has been deployed at the US Navy Wave Energy Test Site in Kaneohe, HI (USA) since March 2016. A combination of free-drifting and stationary measurements are used to characterize its spatial and temporal acoustic signature over a range of sea states and operating conditions. A comparison is presented between co-spatial and co-temporal observations by these observational modes. During normal operation, sound production has at least two regimes, differentiated by a critical wave steepness. Below this critical value, the wave converter produces limited sound, primarily below 10 kHz. Above this critical value, waves break continuously around the wave converter, with the resulting bubble collapse producing sound at frequencies up to several hundred kHz. An abnormal operating state is also characterized, in which a damaged bearing in one power take-off dominates the acoustic signature and reinforces the potential for acoustic monitoring to provide information regarding the health of marine energy systems. As expected for this scale of wave energy converter, no operating states are identified in which the acoustic emissions exceed regulatory thresholds.</span></p>","authors":"B. Polagye, P. Murphy, P. Cross, L. Vega","topic":"9","file":"ENVIRO-01-730.pdf","bib":"ENVIRO-01-730.bib"},
{"paperid":"731","title":"Development of an Embedded Thin-film Strain-sensor-based SHM Network for Composite Tidal Turbine Blades","keywords":"<p>Recently, there has been increasing demand in developing low-cost, effective structure health monitoring system to be embedded into 3D-woven composite marine turbine blades to determine structural integrity and presence of defects. With measuring the strain and temperature inside composites at both blade resin curing and in-service stages, we are developing a novel scheme to embed a resistive-strain-based thin-metal-film sensory into the composite blade spar-cap to measure the structural behaviour. Thus, a low-cost, smart composite laminate is developed. To verify the effectiveness of the proposed approach, the composite laminate with the integrated SHM system were tested under tensile and flexural loading conditions. Our proposed method will provide another SHM alternative to reduce sensing costs during the renewable green energy generation.</p>","authors":"D. Zhao, M. Forde, B. Weafer","topic":"4","file":"TIDDEV-02-731.pdf","bib":"TIDDEV-02-731.bib"},
{"paperid":"735","title":"Preparation of Wave Energy Test Site at the OIST Marine Science Station","keywords":"To verify wave energy converter performance, we will measure actual water speed in the surf zone by using different measurement devices (EM Sensor or ADCP) in 2017.","authors":"h. takebe","topic":"3","file":"WAVDEV-02-735.pdf","bib":"WAVDEV-02-735.bib"},
{"paperid":"738","title":"Exploring Marine Energy Potential in the UK Using a Whole Systems Modelling Approach","keywords":"<p class=IEEEParagraph><span lang=EN-AU>The key market drivers for marine energy are to reduce carbon emissions, and improve security and sustainability of supply. There are other technologies that also meet these requirements, and therefore the marine energy market is dependent on the technology being cost effective, and competitive. The UK marine energy market potential is assessed using the Energy Technologies Institutes (ETI’s), Energy Systems Modelling Environment (ESME), which is based on a whole systems modelling approach. This will be used to identify scenarios where marine energy forms part of the least-cost energy system for the UK by 2050, and will assess what LCOE reductions are required to improve the commercialisation rate of marine energy.</span></p>","authors":"A. Stegman","topic":"10","file":"ECONOM-01-738.pdf","bib":"ECONOM-01-738.bib"},
{"paperid":"739","title":"Towards the numerical simulation of 5 Floating Point Absorber Wave Energy Converters installed in a line array using OpenFOAM","keywords":"<p>In this study, wave energy converters (WECs) of the floating point absorber (FPA) type are selected. Their geometry is represented by a cylindrical buoy with a spherical end. The viscous flow field around and the response of a single WEC unit have been validated with experimental data in previous work of the authors. Now, this study focusses on the hydrodynamics around and the response of a small array of WECs. The presented numerical simulations include free decay tests and regular wave tests. The obtained numerical results are validated with experimental data.</p>","authors":"B. Devolder, P. Rauwoens, P. Troch","topic":"5","file":"WAVHYD-04-739.pdf","bib":"WAVHYD-04-739.bib"},
{"paperid":"743","title":"Intra-annual power performance of WECs: a decision-aid tool for wave farm planning","keywords":"<p class=IEEEParagraph>In this work a decision-aid tool for accurately computing the intra-annual performance of any Wave Energy Converter (WEC) at any coastal location is developed and demonstrated through a case study in a region with great potential for wave energy exploitation in N Spain. The tool is developed by implementing a complex procedure which involves the analysis of a large dataset of deepwater buoy records along with high-resolution numerical modelling. As a result, a large amount of nearshore spectral wave information is made available, allowing the reconstruction of high-resolution intra-annual characterization matrices. This information, combined with the power matrices of the currently available technologies, also stored within the tool, allows the self-contained computation of the intra-annual performance of any WEC-site combination. The results obtained show clearly the importance of accurately analysing the intra-annual performance of different WEC-site combinations prior to installing a wave farm, thereby highlighting the interest of the present tool. Finally, in addition to the performance of WECs, the socioeconomic and environmental aspects play a major role in selecting the most appropriate WEC-site combination. With this in view, this information will be also incorporated within the tool and considered in the decision-making process.</p>","authors":"R. Carballo, N. Arean, M. Sanchez, V. Ramos, M. Alvarez, A. Castro, G. Iglesias","topic":"1","file":"WAVRES-02-743.pdf","bib":"WAVRES-02-743.bib"},
{"paperid":"744","title":"Pressure and Power Control of Hydrostatic Power Take-Offs in Wave Energy Applications","keywords":"<html />","authors":"D. Dießel, H. Murrenhoff","topic":"7","file":"GRDPTO-02-744.pdf","bib":"GRDPTO-02-744.bib"},
{"paperid":"745","title":"Comparison of 0-D,1-D and 2-D model capabilities for tidal range energy resource assessments","keywords":"<!-- pre.cjk { font-family: Droid Sans Fallback,monospace; }p { margin-bottom: 0.25cm; line-height: 120%; }a:link {  } --> <pre class=western style=margin-bottom: 0.5cm;><span style=color: #000000;>Tidal range power plant proposals have been under consideration for UK <br />waters, with their feasibility consistently being under scrutiny.  ---- This is due to a combination of potential environmental and  ---- socio-economic impacts that have proven to be challenging to quantify  ---- in the absence of a standardised methodology. Numerical and  ---- hydrodynamic models are constantly being refined with a view to  ---- providing robust assessments that inform future designs. However,  ---- modelling inconsistencies on the tidal power plant representation  ---- approach, operational algorithm variations and technology parameters  ---- reported to-date has made comparisons between proposed designs, even  ---- for the same site, difficult to accomplish and rely on. We present  ---- the capabilities of a series of models that progressively introduce  ---- more spatial dimensions to the analysis with a distinct feedback on  ---- the resource prediction. The suitability and limitations of each of  ---- these models are highlighted with regards to the evaluation of  ---- energy, hydrodynamic impacts and optimisation of tidal power plant  ---- proposals. The study demonstrates that (i) a range of hydrodynamic  ---- scales should be considered alongside (ii) updated parametric models  ---- relating to the turbine technology capabilities and (iii) the  ---- introduction of indicators that monitor hydrodynamic impacts is  ---- needed to inform optimisation analyses for robust tidal power plant proposals.</span></pre>","authors":"A. Angeloudis, M. Piggott, S. Kramer, A. Avdis, D. Coles, M. Christou","topic":"2","file":"TIDRES-01-745.pdf","bib":"TIDRES-01-745.bib"},
{"paperid":"747","title":"Adaptive control of a wave energy converter simulated in a numerical wave tank","keywords":"<p>Energy maximising controllers for wave energy converters (WECs) based on linear control models are attractive in terms of simplicity and computation. However, the traditional linearization methods lead to poor model validity for realistic WEC motions, especially for a controlled WEC resonating with the incident waves.  To improve the control model’s validity, system identification techniques can be employed to identify a linear model more representative of the actual WEC behaviour under controlled conditions. The method proposed here is to use an adaptive algorithm to estimate the control model in real-time, based on past measured values of position, velocity, wave elevation and control force. The on-line estimation of the WEC model, will therefore estimate the best linear model of the system, capturing its dynamical behaviour under control, where constraints and limitations are also taken into account. Using exponential forgetting, the model can also be continuously adapted to remain representative in the face of changing sea states. To provide an illustrative example, the adaptive controller is applied to a WEC in a computational fluid dynamics simulation (OpenFOAM), allowing the adaptive properties of the controller to be tested by creating the best linear model representative of the conditions encountered in the nonlinear simulation.</p>","authors":"J. Davidson, R. Genest, J. Ringwood","topic":"7","file":"GRDPTO-02-747.pdf","bib":"GRDPTO-02-747.bib"},
{"paperid":"750","title":"Optimisation of tidal stream turbine arrays within the Alderney Race","keywords":"<!-- pre.cjk { font-family: Nimbus Mono L,monospace; }p { margin-bottom: 0.25cm; line-height: 120%; } --><span style=color: #000000;>The energetic flows within the Alderney Race have attracted interest for harnessing tidal energy using large tidal turbine arrays for electricity generation. The Race is split into French territorial waters in the East of the Race and Alderney territorial waters in the West. This presents an interesting optimisation problem, where large scale blockage effects cause array development in the East to enhance the resource in the West and vice versa. This paper presents an initial study investigating the optimal number of turbines and their spatial distribution within the Alderney Race to help establish the most suitable long term development strategy. Computational simulations were conducted using OpenTidalFarm, a 2D non-linear shallow water hydrodynamic solver. The software makes use of efficient gradient-based methods for optimising the  number of turbines and their spatial distribution within large arrays. Results show that the optimal turbine arrays within the East or West Race when considered in isolation are significantly different to those when optimisation is conducted for both the East and West Race together. This demonstrates that developing the sites separately without knowledge of the other sites development plan will have a detrimental effect on the total generated power and the cost of energy within the Alderney Race.</span>","authors":"D. Coles, S. Kramer, M. Piggott","topic":"2","file":"TIDRES-02-750.pdf","bib":"TIDRES-02-750.bib"},
{"paperid":"752","title":"Numerical Modelling Techniques to Predict Rotor Imbalance Problems in Tidal Stream Turbines","keywords":"<p>The variation of loads caused by the unsteady nature of tidal streams can have severe impacts on the turbine components. Val et al. (2014)<sup>1</sup> studied the reliability of rotors and suggested that the dynamic loadings of tidal flows can generate an offset on one or more blade pitch settings. These changes will represent a loss of power capture and perhaps even premature failure of the components if not detected in time.</p> <p class=IEEEParagraph>The aim of this paper is to simulate the effects of a blade offset using 3D CFD and Blade Element Momentum Theory (BEMT) techniques. The results of the BEMT and CFD simulations are thus compared to the experimental data to assess the validity of using both numerical tools.</p> <p class=IEEEParagraph>From initial results, it is observed that the BEMT model provides a reasonable prediction at peak values of C<sub>P</sub>, with a slight reduction in performance coefficient for the offset blade case. However, initial comparative results from CFD show that the latter underestimates power coefficient values. Additional results will show the comparisons including larger values of blade offset cases and the results will also be analysed in terms of torque and thrust.</p> <p class=IEEEReferenceItem> </p> <p class=IEEEReferenceItem><sup>1</sup>D. V. Val, L. Chernin and D. V. Yurchenko, “Reliability analysis of rotor blades of tidal stream turbines,” <em>Reliability Engineering and System Safety, </em>vol. 121 , p. 26–33, 2014.</p><p class=IEEEParagraph> </p>","authors":"S. Ordonez-Sanchez, K. Porter, C. Johnstone, M. Allmark, T. O`Doherty, R. Ellis, C. Frost, T. Nevalainen","topic":"6","file":"TIDHYD-02-752.pdf","bib":"TIDHYD-02-752.bib"},
{"paperid":"753","title":"Linear generator with different types of ferrite permanent magnets for wave energy conversion","keywords":"<p class=IEEEParagraph>The wave energy converter (WEC) with a linear generator (LG) connected to a point absorbing buoy, developed at Uppsala University, includes a stator with coils and a translator with magnets mounted on it.</p> <p class=IEEEParagraph>To further improve the flexibility and sustainability of the WEC system, this paper discusses the possibility to use mixed types of ferrite permanent in the same LG. Mixed types of ferrites (pieces of the type Y30 and Y40) along with different sizes and shapes of the pole shoes (rectangular and T-shaped) were investigated. The software called Ace, built upon Maxwell’s equations and FEM, have been used for the simulations. The simulation generates an estimation on how high the magnetic energy [Ws/m] is in the stator. The results from the previous magnetic circuit, including rectangular pole shoes and Y40 magnets, were compared to the results from the new magnetic designs.</p> <p class=IEEEParagraph>The results show that the magnetic energy in the stator can be similar for the previous magnetic circuit and for the new design, including pieces of different ferrites, along with T-shaped pole shoes. Therefore, it may be possible to increase the sustainability and flexibility of the LG of a WEC using different types of ferrites and pole shoes.</p>","authors":"J. Leijon, J. Sjölund, B. Ekergård, C. Boström, S. Eriksson, I. Dolguntseva, M. Leijon","topic":"7","file":"GRDPTO-PP-753.pdf","bib":"GRDPTO-PP-753.bib"},
{"paperid":"754","title":"Metocean characterization of BiMEP for WEC design","keywords":"<p class=IEEEParagraph><span lang=EN-AU>Wave Energy Converter (WEC) developers and designers are currently involved in the search of the optimal technology to harvest wave energy. The development of any type of ocean energy system requires the testing of the devices and their response at realistic scenarios. For that aim, devices as well as side operations shall be suitably designed, dimensioned or planned for the test site selected. To fulfil this objective, BiMEP and IHCantabria collaborate developing tools to meet the needs of those developers interested in testing in bimep, following the requirements defined in the main international standards. This metocean characterization will serve to design and tune wave energy converters for the specific conditions of BiMEP, optimizing energy output. In addition, devices need to survive to the extreme conditions that they will face during their lifetime/testing time. In order to address these challenges, a high resolution metocean characterization of BiMEP site has been performed (wind, waves, currents), including an extensive analysis of normal and extreme conditions in order to determine the main load cases proposed in the standards and guidelines.</span></p>","authors":"A. Iturrioz, F. del Jesus, R. Guanche, A. Acevedo, H. Chiri, A. Abascal, A. Garcia, A. Espejo, I. Losada, D. Marina, Y. Torre-Enciso","topic":"1","file":"WAVRES-02-754.pdf","bib":"WAVRES-02-754.bib"},
{"paperid":"757","title":"Electric Machine Design for Wave Energy Converters","keywords":"<p>This paper focuses on the development of a direct drive electrical machine for use as the generator in a wave energy converter. The natural motion of many wave energy converters presents two key challenges to the electrical machine designer: it is slow speed and reciprocating. This leads to the use and development of high force density and possibly linear machines. There is a play off between the force density of a machine and its power factor. For the device developer this mannifests as a play off between cost of electrical machine and cost of electronic converter. For a linear machine, a further complication is the need for an overhang of either the translator or stator if a constant active area is requried throughut the mechanical stroke. This also influences the choice of machine type.</p><p>This paper uses a nominal 25kW reciprocating wave energy device to asses 4 esigns of linear electrical machine in terms of performance, material cost and converter rating.</p>","authors":"N. Baker","topic":"7","file":"GRDPTO-02-757.pdf","bib":"GRDPTO-02-757.bib"},
{"paperid":"758","title":"Experimental study of the wakes due to tidal rotors and a shared cylindrical support","keywords":"<p>Prior work by the authors showed how co-location of offshore wind turbines at sites being developed for tidal stream turbines offers increased energy yield compared to operating tidal arrays alone. Coupled with possibilities to share support structures and electrical infrastructure, co-location has the potential to reduce LCoE. Presented are the experimental results of wake measurements made behind scaled tidal rotors operating near a bed-mounted cylindrical tower capable of supporting both wind and tidal turbines. Two different configurations are considered; single rotor with tower and two rotors side-by-side of a central tower. Comparison of resulting wakes is made with rotor-only wakes, alongside a simplified wake model based on linear superposition of wake velocity deficits. The wake velocity deficit due to single rotor and tower is 20% greater than rotor-only operation at 10 diameters (D) downstream, reducing the maximum potential power output of downstream turbines by 49%. This result is well predicted by the superposition model. For the two rotors and tower, increased local blockage results in a far-wake velocity deficit 52% greater than without the tower. This result is poorly predicted by superposition, owing to mixing of differing shear layers. More sophisticated wake models are hence required to predict this behaviour.</p>","authors":"D. Lande-Sudall, T. Stallard, P. Stansby","topic":"6","file":"TIDHYD-02-758.pdf","bib":"TIDHYD-02-758.bib"},
{"paperid":"760","title":"Wave and tidal power measurement using HF radar","keywords":"Wave and tidal power installations need information about the available resource and its temporal, spatial and directional variability in order to optimise siting decisions. The same information is also needed for monitoring performance of devices and for ensuring safe installation, testing and operations. Wave buoys and ADCPs provide very useful information for these applications but, unless they are deployed in large numbers, cannot provide information about spatial variability. Suitably configured HF radars can provide wave measurements to over 100km, and surface currents to over 150km from the coast with spatial resolutions of a few km or over shorter ranges with higher spatial resolution.  Such radars also have the advantage that they are normally located on the coast and thus much more easily accessible for maintenance and repairs than an instrument deployed offshore. The ability to measure both waves and currents simultaneously provides very useful information for renewable system designers and for siting decisions. HF radar are now beginning to be deployed with this application as the main focus. In this paper the technology will be reviewed, measurements demonstrating the capability presented, and two new deployments discussed, one for a tidal stream power application, the other for a wave power application.","authors":"L. Wyatt","topic":"1","file":"WAVRES-02-760.pdf","bib":"WAVRES-02-760.bib"},
{"paperid":"761","title":"The Impact of Marine Renewable Energy Extraction on Sediment Dynamics","keywords":"<p>The extraction of marine energy, through either tidal or wave array operation, will clearly influence the hydrodynamics of a region. Although the influence on tidal currents and wave properties is likely to be very small for most extraction scenarios, the influence on bed shear stress is likely to be greater, because bed shear stress is quadratically related to tidal currents and wave orbital velocities. Further, the transport of sediments is a function of tidal current and wave orbital velocity cubed. Therefore, even small modifications to the flow field through tidal or wave array operation could lead to significant impacts on regional sediment dynamics. In this paper, we explore the impact of tidal energy devices/arrays on regional sediment dynamics. To assess the magnitude of impacts on sedimentary systems, it is essential to consider the scale of the impact in relation to the range of natural variability. We suggest ways in which impacts can be assessed using numerical models, tuned by in situ measurements, which quantify variability over a range of time scales from semi-diurnal and lunar cycles, to seasonal and interannual periods.</p>","authors":"S. Neill, P. Robins","topic":"9","file":"ENVIRO-01-761.pdf","bib":"ENVIRO-01-761.bib"},
{"paperid":"762","title":"Spanwise Flow Corrections for Tidal Turbines","keywords":"A re-calibration of an existing tip correction factor (originally developed for wind turbines by Shen et al. (Wind Energy 2005; 8:457-475)) will be presented, for two different tidal turbine rotor designs. This re-calibration is necessary because spanwise flow effects are stronger on high solidity tidal turbine rotors than typical wind turbines. When applied to actuator line computations of the two tidal turbine rotors, the re-calibrated tip correction factor shows a considerable performance prediction over the original calibration.","authors":"A. Wimshurst","topic":"6","file":"TIDHYD-02-762.pdf","bib":"TIDHYD-02-762.bib"},
{"paperid":"763","title":"Development of a hybrid viscous/inviscid hydrodynamics model for marine current turbines","keywords":"<p>The development of a computational methodology for the hydrodynamic analysis of marine current turbines is presented. A computationally efficient tool to analyse single turbine performance and turbine-turbine interaction in tidal arrays is obtained by a hybrid viscous/inviscid flow approach. A viscous-flow RANS model and an invisciid-flow Boundary Integral Equation Model (BIEM) are coupled into an integrated solver.</p><p>The methodology has been successfully validated for marine propulsors and here is applied for the first time to marine current turbines. The correct prediction of rotor induction by BIEM is the most critical aspect due to the impact of viscous-flow effects on turbine loads. The problem is addressed by a modified BIEM which includes a suitable viscosity correction (VFC) model. The methodology also includes an original model to predict the evolution of the turbine trailing wake.</p><p>A detailed VFC-BIEM model validation study is presented. The accuracy of turbine loads predictions over a full range of operating conditions is analysed with respect to experimental data. Next, numerical applications of the hybrid viscous/inviscid model are presented. The capability of the hybrid RANS/BIEM model to correctly describe turbine flow is discussed by comparing numerical predictions with literature data on experimental characterizations of turbine wakes. <br /><br /><br /></p><br /><p> </p>","authors":"F. Salvatore","topic":"6","file":"TIDHYD-03-763.pdf","bib":"TIDHYD-03-763.bib"},
{"paperid":"764","title":"Experimental study of the Marine Current Turbine behaviour submitted to macro-particle impacts","keywords":"<p>In highly energetic sites it was reported that sediments of medium to upper size particles like gravel and even shingles may be transported by the flow. Positioning obstacles like Marine Current Turbines in such an environment is not without consequences: particles impact on the device will result in deterioration by shock or erosion and an increase of the blade fatigue.</p><p style=margin-bottom: 0cm; line-height: 100%;>In this paper, we will experimentally characterize the physical phenomenon of the macro-particle impacts, based on a new 3-bladed turbine model. Every blade of this laboratory turbine (1:20 scale model) will be provided with an independent 5-components load-cell, combined with a new torque and thrust sensor on the main rotational axis. Particles will be injected in the flume tank of Ifremer (Boulogne-sur-mer, France) in an upstream position and will be carried along by the current. Results will be mainly focused on trajectories and effects of these macro-particles on the 3-bladed turbine behaviour.</p><p style=margin-bottom: 0cm; line-height: 100%;> </p>","authors":"B. Gaurier, G. Germain, J. Facq, G. Pinon","topic":"6","file":"TIDHYD-03-764.pdf","bib":"TIDHYD-03-764.bib"},
{"paperid":"765","title":"Comparison of synthetic turbulence approaches for two numerical tidal turbine models","keywords":"<p>The paper discusses the methods and results of tidal turbines simulated in turbulent flow conditions. The turbulent conditions are synthetic i.e., they are a statistical reconstruction of a full velocity field from a more limited set of real measurements. Two different methods of turbulence synthesis (synthetic eddy method, SEM, and the Sandia method) are used. There are also two different methods of simulation: blade element momentum theory (BEMT) and vortex particle method (VPM).</p> <p>We briefly discuss the extensions to the standard BEMT and VPM models that allow the simulation of turbulent conditions. The relative performance of the SEM and Sandia synthetic turbulence methods is discussed and illustrated: we show that the SEM captures velocity covariances realistically but does not accurately replicate turbulent spectra, while the Sandia method shows the opposite behaviour. A method to improve the spectral representation in SEM is shown.</p> <p>Turbulent flowfields from both synthetic methods are used as inputs to the BEMT and VPM models, and the relative effects on predicted loads are shown and discussed. We conclude by advising under which circumstances particular methods of turbulence synthesis and turbine simulation should be applied.</p>","authors":"M. Togneri, I. Masters, C. Carlier, C. Choma Bex, G. Pinon","topic":"6","file":"TIDHYD-03-765.pdf","bib":"TIDHYD-03-765.bib"},
{"paperid":"768","title":"Cost modelling of turbine blades: Opportunities and challenges","keywords":"<p>Tidal energy is an attractive energy source as unlike wind, ocean currents and tides are predictable. In addition, as the density of water is so much greater than air, the amount of energy extracted is considerable. It is estimated that in the Race of Alderney in the Channel islands of the UK, 1.34TWh of electricity could be generated by an tidal turbine farm each year. Despite this promise, tidal energy has gotten off to a slow start compared to other renewable energy sources due to the difficulties in working in the open ocean.</p> <p>In this work, the costs associated with producing horizontal axis tidal turbine blades. As tidal turbine blades are still at the prototype stage, this work will focus on the lessons learnt through wind turbine blades and see what aspects can be incorporated into tidal turbine blades. Through thinking of the costs associated with making the blades it is hoped this will compliment other research and will point to other avenues of interest.</p>","authors":"T. Dooher","topic":"10","file":"ECONOM-PP-768.pdf","bib":"ECONOM-PP-768.bib"},
{"paperid":"769","title":"Study of the energy collected by a heaving buoy in front of the Artha breakwater, Saint-Jean-de-Luz (SW France)","keywords":"The present work, part of the French project EMACOP (Energies MArines, COtières et Portuaires) aims at studying the energy that could be collected by a heaving buoy wave oscillating floater located in Saint-Jean-de-Luz (SW France) in front of the Artha breakwater, and at comparing the results with the energies recovered at the same place and for the same conditions by an overtopping wave converter and a flap oscillating converter that were determined by a former study.","authors":"J. BAILLS","topic":"7","file":"GRDPTO-03-769.pdf","bib":"GRDPTO-03-769.bib"},
{"paperid":"770","title":"Performance assessment of WECs: a case study","keywords":"<p class=IEEEParagraph><span lang=EN-AU>The Rias Baixas region, located in the NW corner of the Iberian Peninsula, has been shown to have a great potential for wave energy exploitation, with up to 40 kWm<sup>-1</sup> of annual average wave power. In the present work, the energy production parameters are accurately computed for various WECs at a number of locations previously proposed for wave energy exploitation in this region.</span></p> <p class=IEEEParagraph><span lang=EN-AU>Given that an appropriate decision-making should be based on the accurate estimation of the WECs performance, a methodology different from the conventional approach is applied to estimate the energy output – a fundamental prerequisite for the viability analysis of a wave farm project.</span></p> <p class=IEEEParagraph><span lang=EN-AU>The results obtained underline the need for accurately computing and analysing the energy and performance parameters of various WECs at different locations so as to conduct feasibility studies on the installation of a wave farm. It is found that the WECs producing the largest energy outputs are not necessarily those with the best performance and, importantly, the best-performing WECs change between sites in close proximity due to the complex bathymetry. </span></p>","authors":"N. Arean, R. Carballo, M. Sánchez, M. Alvarez, I. Lopez, M. Torres, G. Iglesias","topic":"1","file":"WAVRES-02-770.pdf","bib":"WAVRES-02-770.bib"},
{"paperid":"771","title":"Experimental tidal power site bathymetry representation for turbulence characterization","keywords":"p { margin-bottom: 0.25cm; line-height: 120%; }   <p style=margin-bottom: 0cm; line-height: 100%;>In strong tidal current areas, the seabed presents some high bathymetry variations. For marine energy project development in this kind of area, a good understanding of the physical process is needed in order to properly understand the turbulence production and eddies generation (velocity variations encountered at sea). Flow over different kind of rough bed has been extensively investigated but for relatively low Reynolds and Froude numbers. We propose here to present the methodology used to extent the bathymetry effect studies to experimental configurations representative of real situations.</p> <p style=margin-bottom: 0cm; line-height: 100%;>After a physical description of the Raz Blanchard tidal site, we will first present the flow measurement results obtained around a wall-mounted cube in representative conditions to the mean in-situ structures. These measurements have been done for different kind of upstream flow from laminar to highly turbulent. The obtained results will be classically presented in term of velocity and Reynolds stress maps in order to well characterize the energy exchanges.</p> <p style=margin-bottom: 0cm; line-height: 100%;>Based on the results, an extrapolation to cases with a higher number of cube will be proposed. Afterwards, we will present a more complex experimental set-up, more representative to real bathymetry (a false floor able to receive elements from ridges to trenches).</p> <span style=font-size: x-small;></span><span style=font-size: x-small;></span>","authors":"M. Ikhennicheu, G. Germain, B. Gaurier, P. Druault","topic":"6","file":"TIDHYD-03-771.pdf","bib":"TIDHYD-03-771.bib"},
{"paperid":"772","title":"Determination of loadings on a tidal stream turbine  nacelle during installation by use of CFD modelling","keywords":"<p><span style=font-family: Calibri; font-size: small;>This work uses CFD to investigate the loadings on a tidal stream turbine nacelle during installation onto a support structure fixed to the sea bed. This operation is costly and may only be carried out when sea conditions are favourable. This modelling is informed by real life data for the flow stream velocities which was acquired during the slack period for a neap tide at a location suitable for the deployment of a tidal stream turbine. The</span><span><span style=font-family: Calibri; font-size: small;> </span></span><span style=font-family: Calibri; font-size: small;>intended</span><span><span style=font-family: Calibri; font-size: small;> </span></span><span style=font-family: Calibri; font-size: small;>aim</span><span><span style=font-family: Calibri; font-size: small;> </span></span><span style=font-family: Calibri; font-size: small;>of</span><span><span style=font-family: Calibri; font-size: small;> </span></span><span style=font-family: Calibri; font-size: small;>this</span><span><span style=font-family: Calibri; font-size: small;> </span></span><span style=font-family: Calibri; font-size: small;>process</span><span><span style=font-family: Calibri; font-size: small;> </span></span><span style=font-family: Calibri; font-size: small;>was</span><span><span style=font-family: Calibri; font-size: small;> </span></span><span style=font-family: Calibri; font-size: small;>to</span><span><span style=font-family: Calibri; font-size: small;> </span></span><span style=font-family: Calibri; font-size: small;>better</span><span><span style=font-family: Calibri; font-size: small;> </span></span><span style=font-family: Calibri; font-size: small;>define</span><span><span style=font-family: Calibri; font-size: small;> </span></span><span style=font-family: Calibri; font-size: small;>the range of sea conditions during which the operation could be successfully enacted as well as the suitability of the proposed</span><span><span style=font-family: Calibri; font-size: small;> </span></span><span style=font-family: Calibri; font-size: small;>lifting</span><span><span style=font-family: Calibri; font-size: small;> </span></span><span style=font-family: Calibri; font-size: small;>arrangement.</span><span><span style=font-family: Calibri; font-size: small;> </span></span><span style=font-family: Calibri; font-size: small;>One of the key findings is the case where the flow stream velocity is aligned with the axis of the rotor, with the direction being reversed to that during normal operation so that the flow strikes the rear of the nacelle and the back of the blades. Under this condition the yawing moments as well as the force acting on the nacelle perpendicular to the flow stream become zero. Orientating the nacelle in this position relative to the flow stream during installation therefore has clear benefits.</span></p>","authors":"E. Morrison, T. O'Doherty, P. Prickett, A. Mason-Jones, R. Grosvenor, C. Byrne, D. O'Doherty","topic":"4","file":"TIDDEV-PP-772.pdf","bib":"TIDDEV-PP-772.bib"},
{"paperid":"773","title":"Towing tank and Flume Testing of Passively Adaptive Composite Tidal Turbine Blades","keywords":"<p class=IEEEParagraph><span lang=EN-AU>Passive feathering of tidal turbine blades has the potential to reduce structural loads, increase annual energy production, delay cavitation inception, and reduce hydrodynamic instabilities for horizontal axis tidal turbines (HATTs). Although the advantages of BT blades have been demonstrated using numerical design tools, there is a lack of experimental work to verify these models. Without sufficient model verification, high safety factors are required for turbine and blade design to compensate for the uncertainty in the turbine performance. </span></p> <p class=IEEEParagraph><span lang=EN-AU>This paper presents experimental test results for an 828 mm diameter HATT tested with both rigid aluminium blades and composite BT blades. Hydrodynamic testing was undertaken in both the Kelvin Hydrodynamics Laboratory towing tank at Strathclyde University, and the wave and current flume tank at IFREMER in Boulogne-sur-Mer. Tests were aimed to increase confidence in turbine performance modelling by providing model verification data for a range of conditions. </span>Similar trends were observed between facilities, with the turbine with BT blades having up to 11% lower thrust loads compared to the turbine with rigid blades. Reduced loads on the turbine and support structure mean that smaller, less expensive turbine components can be used, resulting in more cost effective components with higher utilization factors.</p> <p class=IEEEParagraph><em><span lang=EN-AU> </span></em></p>","authors":"R. Murray, S. Ordonez-Sanchez, K. Porter, D. Doman, M. Pegg, C. Johnstone","topic":"4","file":"TIDDEV-02-773.pdf","bib":"TIDDEV-02-773.bib"},
{"paperid":"774","title":"Modelling of extreme environmental loads for tidal current turbines","keywords":"<p class=ieeeparagraph><span lang=EN-AU>The Alderney Race, France, area with very strong currents, is ideal for tidal turbine deployment. We are interested in key environmental parameters (turbine inflow conditions, extreme values prediction, etc.), because the success of tidal energy extraction depends on a proper assessment of these parameters. Environmental loads vary in magnitude, position and direction, affecting the operations and normal use of tidal turbines. The load of interest here is the hydrodynamic load induced by waves and currents, and its dependence on the interaction of waves and currents.</span><span> </span></p> <p class=ieeeparagraph><span>To see the effects of waves on currents and currents on waves individually, we have run three models separately:</span></p> <p class=ieeeparagraph><span lang=EN-AU>SWAN (stand-alone), ROMS (stand-alone) and COAWST (two-way coupled ROMS and SWAN model). </span></p> <p class=ieeeparagraph><span lang=EN-AU>By analysing the IREMARE<span> </span>19-year hindcast (1994-2012) for the Alderney Race area and simulating a strong storm at<span> </span>March 2008, the conclusion is that real extreme events that can be encountered in the area of interest are not expected to affect the normal use of tidal turbines.</span></p> <span lang=EN-AU>However, this area may experience higher waves in the future. For this reason, we analysed the environmental loads on tidal turbines in the case of more extreme waves that are artificially created in the model.</span><p class=IEEEParagraph> </p><p class=IEEEParagraph> </p>","authors":"A. Jakovljevic, S. Paboeuf, F. Dias","topic":"6","file":"TIDHYD-04-774.pdf","bib":"TIDHYD-04-774.bib"},
{"paperid":"775","title":"Impact of cables withdraw length on the dynamics of an undulating membrane tidal energy converter","keywords":"<!-- p { margin-bottom: 0.25cm; line-height: 120%; } --> <p style=margin-bottom: 0cm; line-height: 100%;><span style=font-family: Times,serif;><span style=font-size: x-small;><span style=font-variant: normal;><span lang=en-US>An experimental model of an undulating tidal energy converter has been developed at <span style=font-family: Times,serif;><span style=font-size: x-small;>/20<sup>th</sup> </span></span> scale. This semi-rigid tidal converter undulates when put in interaction with a fluid in motion. Its specificity comes from the buckling ensured by lateral cables. The experimental model enables to study the behaviour of this tidal energy converter in controlled conditions. A parameter is here specifically studied : the length of the compression cables.</span></span></span></span></p><p style=margin-bottom: 0cm; line-height: 100%;><span style=font-family: Times,serif;><span style=font-size: x-small;><span style=font-variant: normal;><span lang=en-US>Flume tank trials highlighted the impact of the cables length on the motion amplitude. However there is no significant influence on undulation frequency. Cables length has also an important role on the cut-in current speed. In the tested configuration, optimal withdraw length was about 6-7 % of the membrane length. For faster water flow, cables should be shorten in order to maximize power conversion. Yet, a special care must be taken because short cables also increase forces exerted on the structure, with a higher risk of failure.</span></span></span></span></p>","authors":"M. Trasch, G. Germain, A. Déporte","topic":"4","file":"TIDDEV-03-775.pdf","bib":"TIDDEV-03-775.bib"},
{"paperid":"776","title":"Modelling of Array Interactions for a Curved OWSC using OpenFOAM","keywords":"<!-- p { margin-bottom: 0.25cm; line-height: 120%; } --> <p style=margin-bottom: 0cm; line-height: 100%;>For smaller-capacity WECs, array deployment is perceived as being the most likely way for grid-scale deployment to be approved. However, the understanding of the hydrodynamic interactions within such arrays, especially for devices with non-conventional modes of oscillation, is still at an early stage. In the present work, a CFD simulation is developed in OpenFOAM to simulate the interaction between pairs of the curved oscillating wave surge converter CCell. Across a series of regular sea state simulations, the spacing and relative orientations of the two devices are varied to enable a detailed study of the hydrodynamics of these interactions to be developed, which can be extended to larger arrays and the development of co-operative control strategies for this type of wave energy device. The simulation results are compared with those from the boundary element solver NEMOH, and it is intended that those for one paddle will be compared with results from deployment of a one third-scale CCell device in the ocean in the near future.</p>","authors":"J. Bridgwater Court, D. Chandel, N. Sell, A. Plummer, A. Hillis","topic":"5","file":"WAVHYD-04-776.pdf","bib":"WAVHYD-04-776.bib"},
{"paperid":"779","title":"Demonstration of a Socio-economic Cost of Energy Analysis of a Wave Energy Converter Array","keywords":"<div class=page title=Page 1><div class=layoutArea><div class=column><pre><!--StartFragment--><span>Levelised</span> Cost of Energy (<span>LCOE</span>) is a well established metric for evaluating the economic viability and competitiveness of energy generation technologies.</pre> <pre><span>LCOE</span> takes account of the energy generated by a technology and the different expenditures incurred during its manufacture, deployment, operation and decommissioning to yield a cost for a unit of electricity.</pre> <pre>Numerous studies have presented the <span>LCOE</span> of Wave Energy Converters (WECs), with many highlighting the difficulty of reducing costs to be competitive with alternative energy generation technologies.</pre><pre><br /></pre><pre> The Socio-economic Cost of Energy (SCOE) method considers how project spend can influence the social environment.</pre> <pre><span>SCOE</span> can be used to demonstrate how spend in a project's cost centres can benefit economies through job creation and the generation of economic activity <span>etc</span>.</pre><pre><br /></pre><pre> This paper presents one method of performing an SCOE evaluation of a WEC array.</pre> <pre>The methodology presented estimates job creation and Gross Value Added (<span>GVA</span>), in a region of interest, that is due to the manufacture, deployment, operation and decommissioning of a WEC array.</pre> <pre>The methodology is accompanied by a case study that demonstrates the <span>SCOE</span> approach and also presents an application of a reverse <span>LCOE</span> methodology.</pre> <pre>The reverse <span>LCOE</span> methodology was adopted to provide estimates of the gross spend on multiple WEC cost centres and to demonstrate the approach.</pre> <pre>The results of the case study demonstrate how the <span>SCOE</span> methodology can be used to sanity check early projections of WEC project cost centre breakdown.</pre> <pre>The <span>SCOE</span> methodology can also be used as a tool, by both project developers and funding bodies, to plan, and estimate the results of, externally beneficial WEC development pathways.<!--EndFragment--></pre><p> </p></div></div></div>","authors":"D. Crooks, A. de Andres, E. Medina-Lopez, H. Jeffrey, P. Ruiz-Minguela","topic":"10","file":"ECONOM-01-779.pdf","bib":"ECONOM-01-779.bib"},
{"paperid":"780","title":"Numerical Modelling of Combined Wave, Tidal Current and Turbulence Interaction at Tidal Energy Sites in the Fall of Warness, Scotland","keywords":"<p class=IEEEParagraph>Results obtained from numerical modelling of waves, tidal currents, and turbulence interaction are reported in this paper. The MIKE 21/3 coupled wave-current model [1] has been applied to tidal energy sites in the Fall of Warness, Orkney Waters, Scotland, which contains a region consented by the Crown Estate for deployment of tidal devices. Figure 1 shows the extent of the computational domain, with colour contours depicting the relatively shallow bathymetry between the mainland and islands which constitute the Fall of Wallness. The colours range from purple (&gt; 84 m mean water depth) to red (0 mean water depth).</p> <p class=IEEEParagraph>Spatial and temporal wind speeds extracted from the European Centre for Medium Range Weather Forecast (ECMWF) have been utilised to drive a North Atlantic scale wave model [2], and the wave parameters computed from this were then fed into the tidal flow model. The coupled wave-current model was driven by boundary inputs of wave and sea level extracted from the Danish Hydraulic Institute (DHI) Global Tidal Model. Turbulence closure was achieved using a two-equation (<em>k</em>–<em>ε</em>) turbulence model where <em>k</em> is turbulence intensity and <em>ε</em> is eddy viscosity (<em>ε</em>).  Model outputs included the spatial distribution of turbulence kinetic energy (TKE) and its dissipation rate due to wave-current interaction. The coupled model has been calibrated and validated using field measurements from acoustic Doppler and current profilers deployed in the Fall of Warness.</p> The paper will compare predicted and observed depth-wise current velocity components over a spring tide and a neap tide at several sites in the Fall of Warness.  The results indicate that the coupled model yields high correlation coefficients and the predicted wave-current-turbulence parameters provide a satisfactory match to site measurements at different depths. Temporal and spatial variations in the tidal current and its direction, depth-wise variation of TKE and its dissipation rate, the turbulence intensity (TI), etc., obtained from the coupled model will be presented and discussed in detail in the full version of the paper.","authors":"V. Venugopal","topic":"2","file":"TIDRES-02-780.pdf","bib":"TIDRES-02-780.bib"},
{"paperid":"781","title":"Reducing Peak & Fatigue Mooring Loads: A Validation Study for Elastomeric Moorings","keywords":"Fibre ropes are often used for wave and tidal energy mooring applications.  Elastomeric tethers have been proposed to achieve yet lower axial stiffness.  This work employs a validated numerical model to assess the advantage of elastomeric mooring lines for floating wave and tidal energy devices.  Real data recorded at the South West Moorings Test Facility (SWMTF) is used to validate a base numerical model of the SWMTF buoy and mooring system using Orcaflex software.  The data corresponds to a high energy sea-state, 9th October 2010.  The validated numerical model is then modified to replace the standard Nylon ropes with elastomeric tethers of the same minimum breaking load (MBL).  Simulations are then performed and the resulting reduction of loads allows an advantageous iteration of mooring system stiffness, achieving an optimal condition of lowest peak load.  The reduction in peak tension is accompanied by an increase in the peak buoy excursion.  However, the mean peak excursion increase is just 21% whilst the mean peak tension reduction is 66%.  The peak mooring loads increase again if the mooring system stiffness is reduced below the optimal level, either by further reduction to axial line stiffness or catenary chain weight.","authors":"D. Parish","topic":"12","file":"MRGFND-01-781.pdf","bib":"MRGFND-01-781.bib"},
{"paperid":"784","title":"Numerical and Physical Modeling of a Quayside Wave Energy Recovery System","keywords":"<p style=text-indent: 0.38cm; margin-bottom: 0cm; lang=en-AU><span style=font-size: x-small;>The aim of this work is twofold. The first is to study the behaviour of a quayside Wave Energy Converter (WEC) in particular its interaction with the dike. The second is to develop a complete modeling of this WEC, i.e. the mechanical and electrical conversion. Near dikes, waves are reflected, which induces large wave heights, and interesting possibilities to produce energy. The present study is based on numerical and physical modeling, with confrontation between numerical and experimental results. The WEC is composed of a floating buoy oscillating in a heave movement along a fixed part (vertical wall breakwater).</span></p>","authors":"S. Neuvéglise, F. Marin, G. Perret, H. Smaoui, P. Sergent","topic":"3","file":"WAVDEV-03-784.pdf","bib":"WAVDEV-03-784.bib"},
{"paperid":"785","title":"Tupperwave - Initial numerical modelling and optimization","keywords":"<p class=IEEEParagraph><span lang=EN-AU>The TUPPERWAVE project is supported by the European Commission’s OceanEraNet program. It aims to design and validate a new floating spar type Oscillating Water Column (OWC) concept at laboratory level. Classical OWCs typically generate bidirectional air flow through a self-rectifying turbine which present inherent disadvantages such as low efficiency and poor starting characteristics. To overcome these weaknesses and to reduce the acoustic impact, the innovative TUPPERWAVE concept generates unidirectional air flow which can be converted into electricity via a conventional, high efficiency, unidirectional turbine. </span></p><p class=IEEEParagraph>The principle is based on the use of two additional chambers above the water column and a pair of non-return valves. One chamber accumulates pressurised air while the other contains depressurised air. A high efficiency unidirectional turbine harnesses energy from the resulting air flow between the two chambers. The closed air circuit avoids air discharge to the atmosphere and therefore makes less noise.</p> Two time-domain models based on hydrodynamic and thermodynamic equations have been developed by UCC and WavEC to model the primary conversion from hydrodynamic to pneumatic power. The output of these models are compared and a set of design parameters chosen which maximize the pneumatic power output flowing through the turbine whilst maintaining a moderate relative displacement of the floater and the water column, in regular and irregular sea states.","authors":"M. Vicente, P. Benreguig, S. Crowley, J. Murphy","topic":"7","file":"GRDPTO-03-785.pdf","bib":"GRDPTO-03-785.bib"},
{"paperid":"787","title":"Cross Flow Turbine Controller Trade-offs in Optimizing LCOE","keywords":"<span>Levelised Cost of Electricity (LCOE) is the industry <span>standard metric for addressing the commercial viability of an <span>electricity producing technology. For the ocean energy industry <span>to become a mainstream source of power, its technologies’ <span>LCOE must be competitive with alternatives. This paper will <span>examine the ways in which different operating regions for a <span>cross-flow turbine can affect the LCOE of that turbine system.</span></span></span></span></span></span><br /><br /></span><span>Due to the interdependencies of turbine drag loads and turbine operating speed, minimized LCOE for a <span>cross-flow turbine may not correspond to the maximum <span>efficiency point. Controller operating points can have a <span>meaningful impact on the economics of a project and can have <span>major consequences for an optimal design.</span></span></span></span><br /><br /></span>","authors":"J. Donegan, J. McEntee, B. Polagye, R. Cavagnaro, D. Forbush","topic":"10","file":"ECONOM-01-787.pdf","bib":"ECONOM-01-787.bib"},
{"paperid":"788","title":"Assessing the performance of the CECO wave energy converter in the Portuguese near-shore","keywords":"<p class=IEEEParagraph><span lang=EN-AU>The CECO concept is novel Wave Energy Converted (WEC), which has shown great potential in the initial tests carried out. </span>The principle of operation of CECO is based on converting simultaneously the kinetic and potential energy of waves into electrical energy based on the oblique motion of two floating lateral mobile modules aligned parallel to the wave fronts. Moreover, CECO offers a great flexibility in terms of operation conditions, since it can be coupled with offshore structures such as wind turbines. According to the current design, CECO is meant to operate in near-shore conditions, in a range covering from 15 to 50 m of water depth. Against the foregoing backdrop, this work is focused on assessing the effects of (i) the operational water depth and inclination between the floating and fixed modules of CECO (Fig.1) and (ii) the temporal variability of the wave regime on the performance of CECO using as a case study the Portuguese near-shore.</p><p class=IEEEParagraph> </p>","authors":"P. Rosa-Santos, F. Taveira-Pinto, V. Ramos, M. Lopez","topic":"3","file":"WAVDEV-03-788.pdf","bib":"WAVDEV-03-788.bib"},
{"paperid":"790","title":"High-resolution numerical model resource assessment of Minas Passage, Bay of Fundy","keywords":"<p>Minas Passage, Bay of Fundy, has one on the world's best resources for in-stream tidal energy. The Fundy Ocean Research Centre for Energy (FORCE) has established a test site for small arrays with a total capacity of 64 MW, with the first grid-connected turbine deployed by Cape Sharp Tidal in November 2016.<br /><br />The further development and deployment of small and large turbine arrays require detailed hydrodynamic information about the tidal resource  on both the site and regional scales. To accomplish this, Acadia University, in collaboration with FORCE, has developed high-resolution (20 to 50 m) coastal-oceanography models of the Minas Passage region. In this paper, we will report on the calibration and validation of the Acadia models using an extensive  ADCP data set and X-band radar velocity measurements.<br /><br />The numerical simulations are analyzed using PySeidon to compile a comprehensive resource database for Minas Passage. The analysis includes the performance of a range of turbines with different power curves, deployment depths, and array layouts. Different sites are assessed in terms of annual energy production, flow variability, ease of deployment, and impacts on tidal dynamics.</p>","authors":"R. Karsten, T. Roc, J. Culina, G. Trowse, M. O'Flaherty-Sproul","topic":"2","file":"TIDRES-02-790.pdf","bib":"TIDRES-02-790.bib"},
{"paperid":"791","title":"Algorithms for marine mammal modelling and an application in Ramsey Sound","keywords":"<p>The main function of a marine renewable energy device is to remove energy from a marine environment and transform it into (generally) electrical energy for further use. This has potential for environmental benefits in the form of reducing global carbon emissions, but also has the potential for impact on the local ecology</p><p>Using computer models and simulations to design and develop devices is not a new or uncommon idea, but this use is often concentrated on the mechanics of a design and its interaction with the physical environment. A simulation framework has been developed in an attempt to mimic the movement of marine mammals in a tidal environment, specifically looking at the potential interaction between tidal stream turbines and harbour porpoise.</p><p>Following from the basic rules and principles presented previously, a set of simulations have been conducted  based on a tidal model of Ramsey Sound - a tidal channel off the south western tip of Wales. Four different simulations are examined, based on combinations of the behavioural influences incorporated into the model - food and noise. This allows the potential interactions between these factors to be examined, as well as how changes in these results might appear in real observational data.</p>","authors":"T. Lake, I. Masters, T. Croft","topic":"9","file":"ENVIRO-01-791.pdf","bib":"ENVIRO-01-791.bib"},
{"paperid":"792","title":"Dynamic analysis validation of the floating EcoSpray tidal energy test platform","keywords":"<p class=IEEEParagraph>Numerical modelling of floating tidal systems is critical to reliably dimension the components and develop a structurally robust platform without over-engineering and overspending due to conservative engineering assumptions regarding loads. Validation of numerical models and the associated assumptions regarding environmental conditions using full scale platform deployment data and accurate wave, current, and wind measurements is an important exercise for the industry.</p><p class=IEEEParagraph><span lang=EN-AU>In the proposed paper, several topics regarding the project will be discussed. The construction of the EcoSpray platform, moorings, and anchor blocks will be presented along with a review of the deployment procedure using small local vessels. The buoys and lights used to mark the region and platform for marine traffic will be reviewed, including community feedback on site selection and marking. Lessons learned during marine operations will also be shared. Next, the development of the floating platform numerical model in ProteusDS and the boundary element method (BEM) code ShipMo3D is reviewed in relation to previous work. A review of the environmental data collected is provided. Finally, the results of the time-domain simulations are compared with the collected data and the design method approach is discussed. Required future work is addressed.</span></p>","authors":"A. Baron","topic":"12","file":"MRGFND-01-792.pdf","bib":"MRGFND-01-792.bib"},
{"paperid":"793","title":"Development and experimental validation of a new methodology to study fatigue crack growth applied to the R5 steel for offshore mooring chains","keywords":"<p class=IEEEParagraph>The presence and propagation of cracks in structures and components is an important challenge for several sectors such as Oil&amp;Gas, Offshore Wind or Nuclear Energy, among others. This study summarizes the research carried out to develop and validate a Finite Element methodology for solving three-dimensional fatigue crack growth situations.</p> <p class=IEEEParagraph>Moreover, the research involves an experimental part performed on the R5 steel, mostly used in offshore mooring chains, in order to characterize its response under fatigue conditions. In this sense, the first step consisted in determining its fatigue behaviour by testing a single edge notch bend specimen.</p> <p class=IEEEParagraph>A statistical study of the results was carried out in order to take into account the intrinsic uncertainty of fatigue crack propagation. Then, the numerical model developed was implemented using the commercial code ANSYS MECHANICAL APDL.</p> Once the fatigue response of the material is introduced, the code is capable of simulating the crack propagation automatically. The fracture parameters such as the stress intensity factors and the J-integral are obtained directly. A sensitivity study to assess the mesh-size effects on the fracture parameters along the crack front was developed and recommendations for 3D crack simulations are provided.<p> </p>","authors":"A. Rodriguez, D. Fernandez, J. Sainz, D. Ferreño, A. Arredondo","topic":"8","file":"STRMAT-PP-793.pdf","bib":"STRMAT-PP-793.bib"},
{"paperid":"794","title":"Blockage Effects on Current Turbine Performance and Wake Characteristics","keywords":"<p>The presence of channel walls during small-scale tidal turbine testing, either experimental or numerical, can influence the performance and wake characteristics of the device. This effect is non-dimensionalised as the “blockage ratio”, the ratio of turbine projected area to channel cross-section. Previous studies have shown that blockage affects a turbine’s thrust and power coefficients and that these changes can be attributed to an altered flow-field. Although blockage effects on turbines and actuator discs have been investigated analytically and numerically, few experimental studies that isolate the effects of blockage, separate from Reynolds number or Froude number, have been conducted. This work characterizes the performance and wake of an axial-flow turbine, a cross-flow turbine, and several porous plates at different levels of channel blockage in laboratory flumes. As predicted by theory and simulation, increased blockage yields increased thrust and power coefficients for all test articles. However, the cross-flow turbine exhibits a counterintuitive inversion of performance with blockage at lower tip-speed ratios. Furthermore, the flow-field is found to be altered by increased blockage. Specifically, initial wake expansion behind the cross-flow turbine is reduced with higher blockage.</p>","authors":"H. Ross, B. Polagye","topic":"4","file":"TIDDEV-03-794.pdf","bib":"TIDDEV-03-794.bib"},
{"paperid":"796","title":"Investigation of model validity for numerical survivability testing of WECs","keywords":"<!-- p { margin-bottom: 0.25cm; direction: ltr; line-height: 120%; text-align: left; }a:link {  } --> <p style=margin-bottom: 0.35cm; line-height: 115%;><span style=font-size: small;><span lang=en-AU>Reliability and survivability are two main challenges for Wave Energy Converter (WEC). Standards from other industries are unadapted for WEC design as their motions are part of their efficiency of power production. Some specific standards were developed, and some of those use an extreme event description with an extreme wave. Physical and numerical models are widely used in the sector. Physical models benefits from control over experiment, its precision and repeatability. Whereas, numerical models are numerous, specific, with unclear capacities and accuracy. Therefore, the aim of this study is to use a physical model to implement numerical ones.</span></span></p> <p style=margin-bottom: 0.35cm; line-height: 115%;><span style=font-size: small;><span lang=en-AU>Two very different numerical models (linear time-domain WaveDyn, and CFD OpenFOAM) were calibrated by a physical model of a single taunt moored buoy – representing a generic WEC – using decay tests (surge, sway, heave). Then, investigations under increasing extreme events, which are described by NewWave wave characterization, spot models strength and weakness, and therefore defined each range of use. This models capacities definition is the first step for the future coupling of those two, where each numerical model advantages can be used to gain speed and accuracy.</span></span></p> <p style=margin-bottom: 0.35cm; line-height: 115%;><br /> <br /></p>","authors":"P. Musiedlak, E. Ransley, D. Greaves, B. Child, M. Hann, G. Iglesias","topic":"5","file":"WAVHYD-04-796.pdf","bib":"WAVHYD-04-796.bib"},
{"paperid":"797","title":"Breaking waves observed during storms at a wave energy test site","keywords":"<p>Breaking waves pose a threat to wave energy converters.  In order to begin characterizing the frequency and intensity of breaking waves at the South Energy Test Site of the Northwest National Marine Renewable Energy Center, wave measurement buoys were deployed by helicopter ahead of large storms.  The Surface Wave Instrumentation Floats with Tracking (SWIFTs) include, among other sensors, a nine degree of freedom inertial measurement unit (IMU) that records float orientation and acceleration at 25 Hz.</p><p>The signature of breaking waves in the IMU data is identified, and the deviation of buoy acceleration from that predicted by linear directional wave theory is examined.  Histograms of vertical and horizontal acceleration and rotation rate are used to quantify the deviation from linear theory, and these histograms may serve as a metric for breaker probability and intensity. Buoy accelerations and rotations induced by breaking waves are larger than would be expected from linear theory, and appear in the tails of the histograms.</p>","authors":"A. Brown, J. Thomson, T. Ozkan-Haller, M. Haller, A. Ellenson","topic":"1","file":"WAVRES-03-797.pdf","bib":"WAVRES-03-797.bib"},
{"paperid":"798","title":"Benchmark of optimisation algorithms for WECs arrays","keywords":"<p>Deployment of WECs in arrays is one apporach to decrease the cost of energy of the different technologies.</p> <p>The European Commision recently founded a project (DTOcean 2013-2016) for the development of an open source tool to optimise the CoE of an array of wave or tidal converters from an economic perspective.</p> <p>Due to the strong interaction between WECs in the array, the optimisation problem is not convex and several local minimums are present in the optimisation space.</p> <p>Using a heuristic optimisation approach is normally the best option because the simulation of large arrays of WEC could become cumbersome due to the required computational power. Genetic algorithms are an appealing to find the best array layout, but this type of algorithm normally requires few thousand-function evaluations in order to converge. On the other hands, metamodel-based optimisation only requires few iterations and it has been recently used for array layout otimisation as well mooring design optimisations in recent years in the wave sector.</p> <p>The goal of this article is to benchmark different optimisation algorithms in terms of computational cost and solution accuracy. In particular three different optimisation algorithms will be compared: a genetic algorithm, an evolutionary strategy and a metamodel based algorithm.</p><p class=IEEEParagraph> </p>","authors":"F. Ferri","topic":"5","file":"WAVHYD-04-798.pdf","bib":"WAVHYD-04-798.bib"},
{"paperid":"799","title":"Effectiveness of Low-order Simulation in Predicting Cross-flow Turbine Controller Performance","keywords":"Cross-flow hydrokinetic turbines often rely on torque control to maintain an operating point in turbulen inflow. The ability of low-order dynamic simulation to predict controller performance on a small-scale, helically-bladed cross-flow turbine was examined in terms of set point holding, torque demands, thurst loads, and available range of stable operation. Experiments were carried out on a small-scale helically-bladed cross-flow turbine in a recirculating water flume. Simulations were carried out in MatLab Simulink provided with an estimate of turbine dynamic parameters and a free-stream velocity time series. Simulation was found to be an excellent predictor of average angular velocity, torque demand, and tip speed ratio. Simulation tended to over-estimate the range of angular velocities and under-estimate range of torque demands, while well-predicting the range of tip speed ratios. The low-speed operating stability limit is also well predicted by simulation, though time-series level agreement is poor for cases near low-speed stall. Provided the limitations of this evaluation method are considered, low-order dynamic simulation is a useful predictor of controller performance and can advise design.","authors":"D. Forbush, B. Polagye","topic":"4","file":"TIDDEV-03-799.pdf","bib":"TIDDEV-03-799.bib"},
{"paperid":"801","title":"Power Collection from Multiple Hydrokinetic Generators","keywords":"A common DC bus power collection scheme is considered for a two-unit array of cross-flow hydrokinetic turbines utilizing advanced control schemes. These controllers increase mechanical rotor efficiency while introducing large, transient spikes of bidirectional electrical current. A numerical simulation in the Simscape Power Systems environment driven by results from laboratory-scale turbine experiments is constructed to evaluate system efficiency from mechanical power input to active power delivered to the grid. The combined effects of advanced control and power collection result in a 13% system efficiency increase over a baseline case, while the design of the collection scheme alone results in a 5% increase. Generator losses are determined to most significantly impact system performance. Results of this study are intended to inform the completion of an electromechanical emulation machine to further evaluate generators and power electronics specified for field deployment. Allowances for heat dissipation and the interconnection of units are anticipated to be major engineering challenges that must be overcome for reliable, cost-effective implementation once deployed at sea or in rivers.","authors":"R. Cavagnaro, B. Strom, B. Polagye, A. Stewart","topic":"7","file":"GRDPTO-03-801.pdf","bib":"GRDPTO-03-801.bib"},
{"paperid":"802","title":"Experimental Observation of Surface Currents Produced by WEC Radiation and Diffraction","keywords":"<p class=IEEEParagraph>The aim of this paper is to report on the observation of surface currents measured in experiments performed on a simple WEC analogue in different experimental conditions. The model is a submerged sphere which is most analogous to a point absorber type WEC, but was chosen to be the most generic of shapes.</p> <p class=IEEEParagraph>The experimental conditions include two main types: 1. Radiation – where the WEC is driven in the absence of waves causing a radiated wave field. 2. Diffraction – where the WEC is held stationary in the presence of waves causing a diffracted/refracted/reflected wave field.</p> We intend to present experimental data for the radiation condition with both monopole and dipole type wave fields","authors":"A. Fleming, R. Manasseh","topic":"3","file":"WAVDEV-03-802.pdf","bib":"WAVDEV-03-802.bib"},
{"paperid":"803","title":"High-Resolution Wave Hindcasts for Regional Wave Energy Resource Assessment in US West Coast","keywords":"<p class=IEEEParagraph>This paper presents a regional wave modeling effort of long-term, high-resolution wave hindcasts to support wave resource characterization in the U.S. West Coast. The model hindcasts are based a nested modeling approach with two state-of-the-art third-generation spectral wave models, WaveWatch III (WWIII) and Unstructured-grid Simulated WAve Nearshore (UNSWAN). Specifically, three nested WWIII model domains, which cover the global ocean to coastal ocean of the entire U.S. west coast at different spatial resolutions (from 0.5 degree to 1 arc-minute), provide open boundary conditions for a high-resolution Un-SWAN model domain. The Un-SWAN model grid covers the nearshore region of ~25 km from coastline and has a spatial resolution of approximately ~300 m. Both WWIII and Un-SWAN are driven by the hourly, 0.5-degree wind forcing from NOAA NCEP’s CFSR datasets. Long-term simulations were conducted from 1979 – 2010. Model skills for simulating the six IEC TS recommended wave energy resource parameters at selected NDBC and CDIP buoys are presented. This study demonstrates that the nested-grid modeling approach by coupling WWIII and Un-SWAN models provides a powerful and efficient tool to accurately characterize wave energy resources over greater temporal and regional scales with sufficient fine resolutions that can serve as feasibility class assessment.</p>","authors":"Z. Yang, T. Wang, W. Wu","topic":"1","file":"WAVRES-03-803.pdf","bib":"WAVRES-03-803.bib"},
{"paperid":"804","title":"Application of Horizontal Axis Tidal Current Turbine to Energy Independent Island in Korea","keywords":"<html />","authors":"Y. Choi, S. Kim, P. Singh","topic":"4","file":"TIDDEV-03-804.pdf","bib":"TIDDEV-03-804.bib"},
{"paperid":"807","title":"Estimation of Tidal Peak Velocity by an Empirical Approach","keywords":"<p class=IEEEParagraph>Within tidal current energy technology, recent papers have been focused on the response of turbines to different flow turbulence conditions, which importance lies, not only in the turbulence itself, but also in the peak velocity values far from estimates. While the capability of different numerical methods has been tested for turbulence parameters such as turbulence intensity or turbulent kinetic energy, among others, peak velocities have been only treated by field measurements. The purpose of this study is getting a correlation between peak velocity and turbulence intensity based on the high frequency data measured by two ADCP and two ADV at different points, depths and sampling frequencies in Goto Islands, Japan, an area proposed for a future tidal current energy pilot plant. Based on turbulence intensity results of a numerical model and the abovementioned correlation, peak velocity maps of the whole area of interest are presented.</p><p class=IEEEParagraph><span lang=EN-US> </span></p>","authors":"P. Garcia Novo, Y. Kyozuka, M. Tsuda","topic":"2","file":"TIDRES-PP-807.pdf","bib":"TIDRES-PP-807.bib"},
{"paperid":"810","title":"Effects of machine nonlinearity on the performance of idealised wave-energy converters","keywords":"Calculations are presented on the behaviour of generic wave-energy converters when their dynamics is nonlinear. The machines are also coupled together by wave scattering as they would be when deployed in an array. Two classes of nonlinearity are considered: nonlinearities due to turbulent boundary layers and to vortex formation; and nonlinearities due to inertia varying during the machine displacement cycle. The objective is to estimate any modifications that arise from nonlinearities to the 'q factor' representing power output of the array relative to that of the same number of independent machines. For Southern Ocean conditions, it is found that nonlinearites can adversely affect array performance.","authors":"R. Manasseh, M. Hasan, L. Puticiu, J. Leontini","topic":"5","file":"WAVHYD-05-810.pdf","bib":"WAVHYD-05-810.bib"},
{"paperid":"813","title":"Improving energy capture by varying the geometry of a novel wave energy converter","keywords":"<p class=IEEEParagraph>Marine Power Systems have developed a novel wave energy converter [WEC], WaveSub which has the potential to exploit the significant global wave energy resource at a financially acceptable cost.</p> <p class=IEEEParagraph>The device consists of two submerged bodies, the power capturing float and a high inertia reaction barge.  The float is connected to a power take-off system on the reaction barge via flexible tether lines.  Relative movement between the power capturing float and reactor barge therefore activates the power take off system, producing power.</p> <p class=IEEEParagraph>Positioning these bodies at different depths and separations between the two bodies is possible by operating winches to change mooring line length and tether line length between float and reactor.</p> <p class=IEEEParagraph>An investigation of the effect on performance of changing separation and depth of the two bodies was conducted.  A study of fourteen discrete float and reactor depth combinations were investigated using panel method frequency domain models in WAMIT combined with time domain modelling in DNV.GL’s WaveDyn.</p> <p class=IEEEParagraph>The results showed that power capture can be significantly improved by varying the separation between bodies for different sea state periods as this changes the frequency response of the system.</p>","authors":"J. Chapman, J. LeDreff, G. Foster, G. Stockman, A. Brask","topic":"3","file":"WAVDEV-03-813.pdf","bib":"WAVDEV-03-813.bib"},
{"paperid":"815","title":"Open sea OWC motions and mooring loads monitoring at BiMEP","keywords":"<p class=IEEEParagraph><span lang=EN-AU>Despite the large number of wave energy converter concepts proposed to-date, few field measurement datasets are available in the public domain, hampering technological and economic learning across the sector. Fundamental to ensuring device efficiency and survivability is the acquisition of long-term, open sea, device and mooring system response data, combined with comprehensive numerical modelling. </span></p> <p class=IEEEParagraph><span lang=EN-AU> </span></p> <p class=IEEEParagraph><span lang=EN-AU>On 16<sup>th</sup> November 2016 the Marmok-A-5 device was deployed at the BiMEP site. This milestone signals the start of two years of open-sea operational data collection as part of the Horizon 2020 OPERA project. With a view to reducing the capital cost of array mooring systems, the project features one square cell of a shared ‘Karratu’ system. In addition to power take-off instrumentation an on-board data acquisition system handles measurements from a 6 degree of freedom inertial motion unit and tensions recorded by load shackles installed at the two seaward corners of the Karratu system. Wave buoy measurements are also captured by a nearby directional wave buoy.</span></p> <p class=IEEEParagraph><span lang=EN-AU> </span></p> <p class=IEEEParagraph><span lang=EN-AU>This paper will report on design of the mooring load monitoring system as well as preliminary analysis of field data recorded during the winter of the first deployment with comparisons made to simulations of the Marmok-A-5– Karratu system. </span></p>","authors":"S. Weller","topic":"3","file":"WAVDEV-04-815.pdf","bib":"WAVDEV-04-815.bib"},
{"paperid":"817","title":"A risk assessment methodology for combining marine renewables with other blue economy activities via multi-use of spaces and platforms.","keywords":"<p class=ieeeparagraph><span lang=EN-AU>Per the European Commission economic activity in the maritime sector, referred to as the blue economy, currently represents roughly 5.4 million jobs and generates a gross added value of almost €500 billion a year, with further potential for growth.</span><span> </span></p> <p class=ieeeparagraph><span lang=EN-AU>However, this growth may be limited due to competition for space in coastal areas. This has led to interest in promoting more sustainable use of the sea, through the sharing of space. The MARIBE project has investigated the potential of combining marine renewable energy technologies with other emerging industries, in either multi-use of space, or together on a multi-use platform.</span></p> <p class=ieeeparagraph><span lang=EN-AU>The work assessed potential combinations, and identified the technical and non-technical challenges facing these. As one of these challenges is the perception of risk due to the use of new technologies and combining them, a rigorous risk assessment was required as part of this work. This would allow all relevant parties to make informed decisions on the viability of each project. This is important where two industries are working together, potentially with limited understanding and knowledge of each other’s technology. This paper will detail the approach that the MARIBE project took in producing these risk assessments as guidance for future projects.</span></p><p class=IEEEParagraph> </p>","authors":"H. Williams, I. Masters, D. Pletsas, C. Fuentes Grunewald, R. Callaway, G. Dalton, M. Blanch","topic":"10","file":"ECONOM-02-817.pdf","bib":"ECONOM-02-817.bib"},
{"paperid":"818","title":"Laboratory tests and numerical modelling in the development of WaveCat","keywords":"<p class=mdpi17abstract>The WaveCat Wave Energy Converter is a novel overtopping WEC tested with the aim of establishing a starting point for numerical model validation using device performance and motions under different sea states. The tests were carried out at a 1:30 scale in the Ocean Basin of the COAST Laboratory at the University of Plymouth. A state-of-the-art control system was implemented, and overtopping rates and device motions were recorded alongside the wave field.</p> <p class=mdpi17abstract>The WaveCat consists of two converging hulls containing four tanks in each hull to capture overtopping water. The captured water is then released through low head turbines to generate power. The device has a length of 3 m, height of 0.6 m and maximum width of 0.4 m at model scale.</p> <p class=MDPI17abstract0>The device motion was measured using a Qualisys motion capture system and a series of reflective markers placed along the model to capture translational and rotational movement. The numerical validation of the device is performed in STAR-CCM+ using the movement and power data collected during the laboratory tests. Once validated, the numerical model will be used to optimise the device and further experimental campaigns will be carried out.</p><p class=MDPI17abstract> </p>","authors":"J. Allen, K. Sampanis, J. Wan, J. Miles, D. Greaves, G. Iglesias","topic":"3","file":"WAVDEV-04-818.pdf","bib":"WAVDEV-04-818.bib"},
{"paperid":"819","title":"Novel Predictive Latching Control for an Oscillating Water Column Buoy","keywords":"<div class=page title=Page 1><div class=layoutArea><div class=column><p><span style=font-size: 9.000000pt; font-family: 'NimbusRomNo9L'; font-weight: 500;>The work investigates a novel non-linear predic- tive control strategy to optimise the power production of a floating OWC buoy equipped with a biradial turbine coupled to an induction generator. The numerical development of two complementary control algorithms is detailed. The first one is a predictive pressure threshold latching control which actuates a high-speed shut-off valve. The second one optimally controls the turbine rotational speed setting both the turbine and the generator at their best operation ranges while taking into account the components limitations and efficiencies. The strategy used is predictive as it performs the optimisation of key control parameters in order to perform latching using the knowledge of the future wave excitation and applies the control law during a re-planning time. Simulations are performed in irregular waves and results of the proposed control law are compared with the simple turbine speed control. </span></p></div></div></div>","authors":"F. Faÿ, M. Marcos, E. Robles","topic":"7","file":"GRDPTO-03-819.pdf","bib":"GRDPTO-03-819.bib"},
{"paperid":"822","title":"Experimental Evaluation of the Hydraulic Power Take-Off System of  a Wave Energy Converter","keywords":"Experimental dry testing was carried out for a WaveNET prototype, a hydraulic wave energy array with multiple generators and an interconnected hydraulic system. The power output and efficiency was evaluated for different numbers of simultaneously operational generators. This was done in order to establish the performance of each power-take-off unit (PTO) individually and to compare the efficiency of different PTO configurations. The WaveNET comprises of six SQUID PTO units which are connected to form an array. Each PTO contains hydraulic pumping modules and a hydraulic motor-generator set, so the WaveNET array can have up to six generators operating simultaneously, depending on input wave energy. In the test rig the hydraulic input to the system was provided by a powerpack, which was controlled to provide a quasi-steady energy input, rather than a dynamic input. Input hydraulic power and output electrical power were measured for each PTO configuration. Some results for individual and multiple PTO tests are presented.","authors":"S. Acheson","topic":"3","file":"WAVDEV-04-822.pdf","bib":"WAVDEV-04-822.bib"},
{"paperid":"823","title":"Reduction of power oscillations combining energy storage with prediction techniques","keywords":"One of the main issues of the wave energy nowadays is the oscillation of the generated power supplied to the electric grid, which is due to the oscillating nature of the waves. These power fluctuations may have an important undesired impact on the electrical grid. An optimal combination of the relative distribution of the wave energy converters, a convenient control strategy and the use of appropriate energy storage devices is usually enough to ensure the power quality required by the electric grid codes. However that can be improved by the use of prediction techniques. This paper evaluates the use of prediction techniques based on autoregressive models (AR). This technique is integrated in the control of a power smoothing system (PSS) based on the use of an energy storage device with supercapacitors connected to the DC-link of the electric drive through a DC/DC converter. Simulations using Matlab-Simulink as well as experimental results using a laboratory test bench will validate the use of this control strategy to improve the energy storage dimensioning and use, as well as the complete system performance.","authors":"M. Lafoz","topic":"7","file":"GRDPTO-04-823.pdf","bib":"GRDPTO-04-823.bib"},
{"paperid":"824","title":"HYDRODYNAMIC CONSEQUENCES OF BIOFOULING ORGANISMS ON MARINE ENERGY CONVERTERS","keywords":"Biofouling by benthic organisms must be considered for tidal turbine operation and maintenance because it modifies hydrodynamics (drag and resistance) [1][2] and could be detrimental to the turbine performance. We investigate vortices modification downstream a tidal turbine due to biofouling using numerical modeling. Firstly, an airfoil with barnacles is modeled in two dimensions (2D) for various fouling height and spacing with different flow incidences. Barnacle height has more influence on flow than the barnacle density. Simulations are very sensitive to turbulence modeling. To ensure an acceptable computing time, only LES and RANS are used. Then 2D flow downstream a clean Darrieus vertical axis tidal turbine is simulated using a dynamic mesh for different tip speed ratio. Results agree the former studies [3], [4] and [5]. Finally, barnacles and mussels with various characteristics are fixed on blades. Vorticity fields are strongly changed by organism shapes (Figures 1 and 2). Mussels size has little impact on vorticity patterns. A few mussels could have stronger impact than a fully colonization. 2D and 3D simulations will be performed from new in-situ measurements that will allow to characterize more precisely species characteristics and combinations.","authors":"A. Rivier, A. Bennis, G. Jean, J. Dauvin","topic":"9","file":"ENVIRO-02-824.pdf","bib":"ENVIRO-02-824.bib"},
{"paperid":"825","title":"Hydrodynamics of a flexible piezoelectric wave energy harvester moored on a breakwater","keywords":"<p>In this paper, we analyse the interaction of linear water waves with a flexible piezoelectric structure submerged in water of finite depth.</p><p>The converter consists of two piezoelectric layers (PVDF) attached to a flexible membrane structure (silicone rubber). One end of the converter is clamped to a rigid support system in the ocean, while the other end is moored on a vertical wall, e.g. a caisson breakwater.</p><p>Whitin the framework of a linearised potential-flow theory, we determine new analytical expressions for the hydroelectromechanical dispersion relation and the velocity potentials. The results will be shown in the full paper, together with a formula to predict the power output of the system.</p>","authors":"F. Buriani, E. Renzi","topic":"5","file":"WAVHYD-05-825.pdf","bib":"WAVHYD-05-825.bib"},
{"paperid":"826","title":"Assessing accuracy of hindcast spectral content in the estimation of wave energy resource","keywords":"<p class=IEEEParagraph>This paper aims at extending to a larger set of locations and conditions the diagnosis on spectral accuracy between measurements and hindcast data presented for three measurement locations related to the SEMREV test site in Perignon (2017, <em>submitted</em>). Despite the sensitivity of the response of many marine structures to the frequency content of the forcing, the capabilities of spectral estimations has hardly been investigated for hindcast wave models providing either fully resolved spectra, or  as is more generally the case to this date parameterised spectra evaluated from integral parameters.</p> <p class=IEEEParagraph>This work takes advantage of the HOMERE high-resolution public wave hindcast data set [Boudiere et al. (2013)] for long-term analysis and mainly its set of directional and frequency spectra available over the whole Channel and Bay of Biscay area (Fig 1). Time series of spectral quantities such as the variance spectral density or wave power are compared with chosen concomitant and collocated in-situ measurement data sets (Fig 2).</p> Such a diagnosis aims at clarifying questions related to local variability and site dependency of the accuracy of wave energy assessment. For instance is a shallower water depth the leading factor in the increase of spectral error or not, as suggested by preliminary results in Perignon (2017). Including comparisons to equivalent parametric spectra from hindcast integral parameters provides in addition a meaningful estimate of the spectral error induced by those simplified representations.","authors":"Y. Perignon","topic":"1","file":"WAVRES-03-826.pdf","bib":"WAVRES-03-826.bib"},
{"paperid":"827","title":"A Carbon Fibre Reinforced Powder Epoxy Manufacturing Process for Tidal Turbine Blades","keywords":"Tidal turbine blades pose a range of challenging material requirements due to the harsh and inaccessible operating conditions associated with marine environments. Composites reinforced with carbon fibre are promising materials for marine applications and it is vital to understand fully both their material properties and potential failure mechanisms in order to ensure a robust and cost-effective design. This paper studies the mechanical and chemical properties of powder-epoxy composites reinforced with carbon fibres of two different types i.e. T700S (TORAYCA®) and PX35 (Zoltek<sup>TM</sup>). Unidirectional (UD) carbon-fibre epoxy laminates were prepared using a novel powder hand lay-up process and tensile, flexural and interlaminar shear strength behaviour based on the fibre orientation, fracture modes and interfacial bonding were assessed. Carbon fibre straightness was enhanced by using a tensioning apparatus during the fabrication process. The distribution of functional groups of the sizing agents on the surface of the fibre was analysed using Fourier Transform Infrared (FTIR) Spectroscopy showing that different surface activity on the interface significantly affected the physicochemical interactions. The analysis of the results showed that the ultimate performance of the UD composites depended significantly on the properties of the reinforcements and the interfacial bonding strength between fibres and matrix.<br />","authors":"D. Mamalis, A. Doyle, C. Ó Brádaigh, T. Flanagan","topic":"8","file":"STRMAT-01-827.pdf","bib":"STRMAT-01-827.bib"},
{"paperid":"829","title":"Power Shedding from Stall and Pitch Controlled Tidal Stream Turbines","keywords":"To meet the growing requirements of the tidal stream renewable energy sector, investment in improving current tidal stream power extraction knowledge and technology is necessary. This can be achieved through the study of practical experiment, or numerical and analytical modelling. The ability to capture and understand the flow characteristics of a Horizontal Axis Tidal Turbine (HATT) poses challenges. CFD simulation is one of many useful tools for deriving the required information. Previous research focusses on the use of Blade Element Momentum Theory (BEMT) and Blade Element Momentum CFD (BEM-CFD). The advantage of the BEM-CFD method is the prediction of a time averaged downstream velocity field, and thus the turbine wake. In this work the performance of HATT's in power limiting mode, i.e. in stall or pitch control, is studied. The two techniques for power limiting are compared with respect to $C_P$, $C_T$, and wake characteristics. Pitch control power limiting generates less thrust than stall control, and thus allows greater flow through the rotor. Also differences in turbulence intensity in the near wake region are observed. The net effect of these characteristics are reflected in the wake recovery rate, i.e. the wake recovers more quickly for pitch control power limiting.","authors":"m. edmunds","topic":"2","file":"TIDRES-02-829.pdf","bib":"TIDRES-02-829.bib"},
{"paperid":"830","title":"Tidal Stream Turbine Rotor Imbalance Fault Diagnosis for Turbulent Flow Conditions and Optimal Tip Speed Ratio Control.","keywords":"<p class=IEEEReferenceItem>Tidal Stream Turbines (TST) are certain to be subjected to harsh marine environments that will impose extreme and cyclic loading scenarios upon turbine sub-assemblies. TST blades in particular are going to experience the full effect of these loading cases. This is known to be causing operational issues linked to reliability concerns including the possibility of early failure [1]. Whilst these loading regimes and associated rotor faults are to a degree unavoidable the impact of such failures could be reduced with the intelligent monitoring of TST rotors.</p> <p class=IEEEReferenceItem> </p> <p class=IEEEReferenceItem>A variety of approaches to turbine rotor monitoring have been researched. However these approaches have normally required the installation of transducers and/or monitoring sensors and systems within the turbine rotor assembly. As with any complicated instrumentation based systems the operation of this monitoring system can itself lead to reliability issues. To enhance the monitoring functions available for TST applications condition monitoring approaches based upon the acquistion and analysis of generator signals have been developed [2]. These have the added benefit of not requiring additional sensors and associated data acquisition and management systems, since they utilise signals and repsonses used by the TST control system for normal operations.  To date these approaches have primarily utilised a steady-state turbine operation assumption and were based on the characteristics observed within the frequency domain [3].</p> <p class=IEEEReferenceItem> </p> <p class=IEEEReferenceItem>The paper presents research undertaken considering the application of these developed approaches to transient turbine operation utilising a drive train test rig shown in Figure 1.The drive train test rig and TST simulation process are briefly outlined along with the method utilised for optimum tip speed ratio (TSR) control. The approach utilises a parameteric turbine model which caputures mean and transient rotor behaviour. The data used to parameterise the model in this case was acquired via flume testing [2].</p>","authors":"M. Allmark, P. Prickett, R. Grosvenor","topic":"4","file":"TIDDEV-04-830.pdf","bib":"TIDDEV-04-830.bib"},
{"paperid":"831","title":"A competition for WEC control systems","keywords":"<p class=IEEEParagraph>This paper describes, and serves as an official announcement for, a proposed WEC control competition where a variety of WEC controllers would be evaluated on a benchmark WEC problem, under identical wave excitation conditions. Two levels/stages of evaluation are proposed:</p> <ol><li>An evaluation in simulation, using the WEC-Sim open-source environment, followed by</li><li>An evaluation of each shortlisted control system entry on a small-scale prototype WEC system in a tank test.</li></ol> <p class=IEEEParagraph>While 1. above will test the <em>achievable performance</em> of each WEC controller, 2. examines the control performance <em>under realistic conditions</em>, including noisy measurements, imperfect system model, etc. The rationale for choosing WEC-Sim is its release as an open-source platform, so the same simulation tool can be used by both the competitors and evaluators. Following a short-listing exercise, a number of final entries will be selected for evaluation on the tank-based WEC system, which will consist of a 1 DoF device similar to a leg of the Wavestar prototype device. Details of the competition, including the WEC system to be controlled, will be given in the full EWTEC paper.</p>","authors":"J. Ringwood, F. Ferri, K. Ruehl, Y. Yu, R. Coe, J. Weber, M. Kramer","topic":"7","file":"GRDPTO-04-831.pdf","bib":"GRDPTO-04-831.bib"},
{"paperid":"835","title":"The effect of solidity on a tidal turbine in low speed flow","keywords":"<p class=IEEEParagraph><span lang=EN-AU>The Cardiff Marine Research Group (CMERG) designed a horizontal axis three bladed tidal turbine for a flow velocity of 6 knots (~3.1 m/s). This paper aims to determine how the variation in solidity will affect the turbine’s performance under low flow velocities, around 1 m/s. The study will be made using computational fluid dynamics software to facilitate the changes made to the geometry and determine the basic operation characteristics of the turbine using steady state conditions. </span></p> <p class=IEEEParagraph><span lang=EN-AU>Previous work done by the research group has determined the best solidity-blade configuration for the designed inlet parameters. These findings will be used as a reference for modifications to the turbine’s geometry to maximise its power output when located in lower speed flows. </span></p> <p class=IEEEParagraph>This research is made with the intention to propose a tidal turbine that can be used in sea conditions similar to the ones in Costa Rica, following their initial approach to the use of the marine resources once the technology is available.</p>","authors":"T. Hernández Madrigal, A. Mason-Jones, T. O'Doherty, D. O'Doherty","topic":"4","file":"TIDDEV-PP-835.pdf","bib":"TIDDEV-PP-835.bib"},
{"paperid":"836","title":"Observations and modelling highlight the importance of micro-siting of tidal-stream arrays: A case study off northwest Wales, UK","keywords":"<p class=papertitle>We investigate variability of the tidal-stream energy resource of a demonstration site at high spatial and temporal resolutions. The site, off northwest Wales, UK, requires a broad understanding of the entire resource to be managed appropriately for different device specifications. A rigorous field campaign has been conducted, consisting of multibeam echo sounder bathymetric surveys, geophysical surveys, ADCP deployments, a wave buoy active deployment, and various sediment sampling surveys. In addition, a coupled tide-wave-sediment model has been applied to simulate the high-resolution spatial distribution of tidal currents, wave-tide interactions, sediment transport, and tidal-stream energy extraction. We find that topography, bathymetry, morphology, and wave-tide interactions result in markedly different flow and turbulence fields over the site, leading to significant variance in power generation. Some areas are ebb-dominant, while others flood-dominant with significant rectlinear misalignment. Waves may alter the tidal flows by up to 10%. The vertical velocity profile varies in accordance with bed friction. Our results suggest that careful consideration should be given to micro-siting of devices; in our case, potential annual energy yield varies by 180% based on undisturbed depth-averaged velocities.</p>","authors":"P. Robins, M. Piano, S. Ward, M. Lewis, R. Hashemi, S. Neill","topic":"2","file":"TIDRES-03-836.pdf","bib":"TIDRES-03-836.bib"},
{"paperid":"837","title":"Design Process of a Novel Dual Rotor Tidal Energy Convertor Platform","keywords":"<p>This paper will provide an overview of the newly developed design process followed to complete the design of a novel, dual rotor, seabed fixed Tidal Energy Convertor (TEC) support structure and will be based on the techniques employed by Black &amp; Veatch during the Energy Technologies Institute (ETI) Tidal Energy Convertor Project. The design of TEC support structures is still an emerging field and the guidance and standards available for this particular application remain limited. The publication of DNV-GL's tidal standard (DNVGL-ST-0164) during the detailed design phase of this project is recognised as an important building block for the industry. However, the mass and cost optimisation requirements for this project (in order to achieve the required LCoE) required further novel methods, particularly focussing on Finite Elelment techniques and validation through testing, as opposed to a more traditional standards-based approach. In the design process Black &amp; Veatch drew on the guidance available, assessing the validity of the existing guidance in this application and developing new methodologies to supplement existing approaches. This paper will summarise the methodologies used for the following key areas of design: fatigue design, structural testing, hydrodynamic testing, application of hydrodynamic loads, dynamic amplification, FMECA, fabrication and installation.</p>","authors":"T. Baker, A. Jones, M. Abbattista, H. Bower, O. Chaloupka, K. O'Sullivan","topic":"8","file":"STRMAT-01-837.pdf","bib":"STRMAT-01-837.bib"},
{"paperid":"838","title":"Validation of Variable Depth Operation of a Novel Wave Energy Converter Using Scale Model Testing","keywords":"<p class=IEEEParagraph>Marine Power Systems Ltd., has developed a novel wave energy convertor known as the WaveSub. One key advantage of the WaveSub is its variable depth operation functionality. This functionality allows the floater and reactor depths to be independently tuned to suit current wave field conditions, thereby optimising device energy capture.</p> <p class=IEEEParagraph>A 1:30 scale model of the WaveSub was tested in the Ocean basin of Plymouth University’s COAST laboratory. The model was tested in its operational state (generating mode) at different depth configurations under regular and irregular wave conditions. The test cases were representative of those for the forthcoming 1:4 scale device, which is due to be deployed at FaBTest in Falmouth, England, in 2017. The device’s motion was tracked using the Qualisys tracking system and PTO system data logged by a bespoke instrumentation system.</p> <p class=IEEEParagraph>The investigation allowed the power flow, absorbed power and RAO’s to be calculated for both regular and irregular wave cases, for different device depth configurations.</p> <p class=IEEEParagraph>The power capture shows that an increasing reactor to floater separation leads to greater absorbed power as wave period increases, this will be further validated by the 1:4 scale device.</p>","authors":"C. Whitlam, J. Chapman, A. Hillis, J. Rosener, G. Foster, G. Stockman, D. Greaves, M. Hann","topic":"3","file":"WAVDEV-04-838.pdf","bib":"WAVDEV-04-838.bib"},
{"paperid":"839","title":"Turbulence Metrics in Wave-Current Interactions","keywords":"<p>Theoretical modelling studies have suggested that surface waves will affect tidal turbine power and fatigue loadings. Further evidence has been provided by laboratory investigations of wave-current interactions. However, there have been few studies of interactions of surface waves with the complex turbulent flow conditions typical of tidal energy sites.  Such research that has been undertaken has tended to focus on near surface effects or on sites where the current has low magnitude.</p> <p>This work presents turbulence metrics from the Fall of Warness site at the European Marine Energy Centre (EMEC) where currents regularly exceed 3 m/s, over a range of wave and tidal conditions.  Turbulence metrics at a given location are found to vary with flow speed, acceleration, and direction, and wave height, period, and direction; this presents a complicated challenge for numerical modellers and designers. The full submission will present common turbulence metrics across a range of tidal flow and wave conditions, and highlight key challenges in deconstructing the driving factors to be considered in resource assessment and device design for such complicated environments.</p>","authors":"D. Sutherland, B. Sellar, A. Borthwick, V. Venugopal","topic":"2","file":"TIDRES-03-839.pdf","bib":"TIDRES-03-839.bib"},
{"paperid":"840","title":"Optimising structural loading and power production for floating wave energy converters","keywords":"<p>This paper looks at the design trade-off between power production and structural loading for floating wave energy converters. Maximising power production potential across all sea states increases the overall opportunities for revenue generation but can result in large structural loads in extreme sea states, which impacts on the overall LCOE. It is therefore important to consider the trade-off between maximising power production and minimising structural loading at an early developmental stage to ensure that it is possible to design a reliable and robust WEC structure, while achieving an acceptable LCoE. The paper investigates this trade-off for the Albatern 12S WEC, (a floating multi-body device) using results from tank testing carried out in the Flowave Ocean Energy Research Facility. Indicative results from the testing show that for some sea states, a small increase in the power production can result in a significant increase in structural loading, therefore maximising power production may not the most optimal solution. The work will feed into the design development process for the device, particularly the identification of “operational” and “survival” sea states for the device to allow for the selection of the design load cases (DLCs) for detailed design.</p>","authors":"L. Barker Ewart","topic":"3","file":"WAVDEV-05-840.pdf","bib":"WAVDEV-05-840.bib"},
{"paperid":"844","title":"Wave Farm Representation in the MIKE 21 Spectral Waves Model","keywords":"For ocean wave energy to become commercially viable, it is expected that wave energy converters (WECs) will need to be installed in large wave farms consisting of many 10s to 100s of devices. Changes to hydrodynamics due to the introduction of such infrastructure to the marine environment may impact many physical and biological processes. This paper presents the implementation of a farm of typical WECs in the MIKE 21 SW model developed by DHI which is part of a suite of modelling tools which cover most of the physical, chemical and biological processes in the coastal environment. Since the 2012 release of the MIKE21 SW model new methods for the representation of the behavior of WECs in terms of transmission, absorption, radiation and reflection of wave energy are included.   The WECs are implemented individually using transmission and reflection coefficients as derived from the experimental data. Comparisons are made with simplified representations used elsewhere and finally, the effect of radiated waves from individual WECs is accounted for within the WEC representation. The results show the influence of the specific WEC representation on the results and offer guidance for future implementation of the model.","authors":"R. McKee, B. Elsaesser, L. O'Boyle, L. Kregting","topic":"9","file":"ENVIRO-02-844.pdf","bib":"ENVIRO-02-844.bib"},
{"paperid":"845","title":"Simulation of turbine groups with support structures for energy yield modelling","keywords":"<!--[if gte mso 9]><xml> <w:WordDocument> <w:View>Normal</w:View> <w:Zoom>0</w:Zoom> <w:TrackMoves /> <w:TrackFormatting /> <w:PunctuationKerning /> <w:ValidateAgainstSchemas /> <w:SaveIfXMLInvalid>false</w:SaveIfXMLInvalid> <w:IgnoreMixedContent>false</w:IgnoreMixedContent> <w:AlwaysShowPlaceholderText>false</w:AlwaysShowPlaceholderText> <w:DoNotPromoteQF /> <w:LidThemeOther>EN-GB</w:LidThemeOther> <w:LidThemeAsian>X-NONE</w:LidThemeAsian> <w:LidThemeComplexScript>X-NONE</w:LidThemeComplexScript> <w:Compatibility> <w:BreakWrappedTables /> <w:SnapToGridInCell /> <w:WrapTextWithPunct /> <w:UseAsianBreakRules /> <w:DontGrowAutofit /> <w:SplitPgBreakAndParaMark /> <w:EnableOpenTypeKerning /> <w:DontFlipMirrorIndents /> <w:OverrideTableStyleHps /> <w:UseFELayout /> </w:Compatibility> <m:mathPr> <m:mathFont m:val=Cambria Math /> <m:brkBin m:val=before /> <m:brkBinSub m:val=&#45;- /> <m:smallFrac m:val=off /> <m:dispDef /> <m:lMargin m:val=0 /> <m:rMargin m:val=0 /> <m:defJc m:val=centerGroup /> <m:wrapIndent m:val=1440 /> <m:intLim m:val=subSup /> <m:naryLim m:val=undOvr /> </m:mathPr></w:WordDocument> </xml><![endif]--> <p class=IEEEParagraph><span lang=EN-AU>A numerical study will be presented assessing the performance of tidal stream turbines and drag force of support structures. The study is undertaken using 3-dimensional RANS-CFD. The turbines are modelling using an embedded Blade Element (BE) model. The support structures are represented as momentum sinks based on the drag coefficient corresponding to the geometry of the support structure and the simulated flow conditions. Results are evaluated against experimental results. </span></p> <p class=IEEEParagraph><span lang=EN-AU>This study is part of the development of a multi-scale approach to model the energy yield of large-scale farms. It aims to describe the formulation of the correlation between drag and enhanced bed-friction of large-scale arrays. As a first step, the flow around pile groups will be assessed and compared to published experimental work.</span></p>","authors":"C. Hachmann","topic":"6","file":"TIDHYD-04-845.pdf","bib":"TIDHYD-04-845.bib"},
{"paperid":"847","title":"Value-driven design for wave energy converters","keywords":"<p class=IEEEParagraph>The purpose of this work is to introduce a method for scanning and assessing the totality of the wave energy converter design space, to make sure every potential winner is covered. In order to do this the ‘value’ of proposed solutions will be assessed objectively from both a performance and an economic perspective. For this work a range of materials, power take-off types, sizes and capacities will be considered and modelled for a range of resource characteristics.</p><p class=IEEEParagraph> </p>","authors":"O. Roberts","topic":"10","file":"ECONOM-02-847.pdf","bib":"ECONOM-02-847.bib"},
{"paperid":"848","title":"Non-Linear Frequency-Domain WEC Simulation: Numerical Case Studies and Practical Issues","keywords":"<p>Computationally-efficient numerical modelling of wave energy converters (WECs) is essential in applications requiring extensive simulations, such as power production assessment, parametric optimisation, or statistical studies. The challenge of combining computational efficiency with accurate modelling of the WEC dynamical nonlinearities can be successfully addressed through a non-linear frequency-domain (NLFD) simulation method. In the NLFD formulation, the steady-state dynamical equations are projected onto a basis of trigonometric polynomials. The resulting non-linear vector equation is solved through a gradient-based method. In many cases, NLFD exhibits a degree of accuracy equal or superior to classical time-domain integration procedures (that are generally used for nonlinear WEC modelling), while keeping computational requirements lower by at least two orders of magnitude.</p> <p>This conference paper contributes making the wave energy community familiar with the NLFD method, showing its promising potential, as well as its practical issues and limitations. For this purpose, a range of case studies are presented, including parametric optimisation for a non-linear WEC model, a non-linear WEC model with multiple degrees of freedom, and a WEC model with non-smooth output (for which the NLFD method shows to be inadequate). The possible convergence issues associated with the resolution method are discussed in detail.</p>","authors":"A. Merigaud, J. Ringwood","topic":"5","file":"WAVHYD-05-848.pdf","bib":"WAVHYD-05-848.bib"},
{"paperid":"850","title":"Hydrodynamic modelling of a vertical axis tidal turbine using CFD and BEM methods","keywords":"<p class=IEEEReferenceItem>A methodology has been developed to establish a dataset of lift and drag coefficients, using computational fluid dynamics (CFD) methods, as a function of angle of attack and Reynolds number for a NACA0015 hydrofoil. This dataset covers angles of attack ranging from 0<sup>o</sup> to 30<sup>o</sup> and Reynolds numbers from 1×10<sup>5</sup> to 2×10<sup>6</sup>. An extensive study is carried out on the grid refinement and simulation parameters using ANSYS ICEM CFD and ANSYS Fluent. Converged lift and drag coefficients are compared to previously published empirical and panel method based data. The CFD dataset is implemented in an enhanced BEM code to analyse the power performance of a vertical axis tidal turbine. Previous studies incorporated lift and drag coefficients from panel method data. By adopting the CFD dataset, there is a marked improvement in the accuracy of the power predictions when comparing to experimental data. The validated CFD methodology presented allows for the generation of further, more extensive, hydrodynamic datasets for a wider variety of blade profiles.</p>","authors":"S. Heavey, P. McGarry, S. Leen","topic":"4","file":"TIDDEV-04-850.pdf","bib":"TIDDEV-04-850.bib"},
{"paperid":"851","title":"A Numerical Study on Optimum Conditions of Multi-buoy Wave Energy Converter with Hydraulic PTO System","keywords":"The aim of this study is to investigate the optimum conditions of a moveable two-body-type wave energy converter (WEC) for maximum energy extraction. The present WEC consists of two hemispherical buoys and hydraulic-cylinder type PTO system. we solved wave radiation and diffraction problems to obtain hydrodynamic coefficients of two hemispherical buoys. The optimum angle of incident wave and gap distance between two buoys were determined to magnify the response of the body in regular waves, in which wave energy extraction can be maximized. The hydraulic PTO system was modeled as in the form of a Coulomb damping force, and the numerical modeling of hydraulic motors and generators were added to the governing equation to predict the final energy extraction in the time domain. Various wave heights and periods with different wave angles were considered to investigate optimum wave angle and distance between buoys. Under optimum body position and PTO condition, the latching control in irregular waves was tested for the maximum energy extraction of the present WEC.","authors":"S. Kim, W. Koo, M. Shin","topic":"5","file":"WAVHYD-05-851.pdf","bib":"WAVHYD-05-851.bib"},
{"paperid":"855","title":"Onshore evaluation of  a linear generator for Wave Power","keywords":"The full version of this paper will summarize and evaluate the results from extensive onshore testing of the point absorber wave energy converter developed by Uppsala University [1]. During the experiments the linear generator is driven with a crane (recreating a buoy line force), at different speeds and with the generator connected to different resistive load cases. By measuring translator position and acceleration, buoy line force, voltage and current output, the generator performance and behavior at different speeds and load cases was studied. The generator behavios was studied by calculating and evaluating translator speed, mechanical input power, electrical output power and generator damping coefficient throughout the full stroke of the generator. Parts of the methods and results have already been published for an older WEC model [2], or will be published before the conference. This paper will compare and evaluate the gathered results.","authors":"L. Ulvgård, A. Frost","topic":"7","file":"GRDPTO-04-855.pdf","bib":"GRDPTO-04-855.bib"},
{"paperid":"859","title":"Numerical investigation of Lashy Sound, Orkney","keywords":"<p>In this work we use a new MIKE 3 three-dimensional numeric hydrodynamic model of the Pentland Firth and Orkney Waters area to study Lashy Sound. Lashy Sound is a channel in northern Orkney that is of interest for tidal energy development, but has been little studied in the academic literature. The model is validated against ADCP data in Lashy Sound and in the Fall of Warness.</p> <p>The hydrodynamics of the channel will be described in the context of the wider Orkney circulation, and then energy extraction introduced using generic turbines with realistic parameters. Predictions will be made of the power available and the effects of energy extraction at different levels of exploitation.</p> <p>A correction to the representation of tidal turbines in regional-scale models will be tested, and its effect on the predicted resource reported.</p>","authors":"S. Waldman, S. Baston, D. Woolf, J. Side","topic":"6","file":"TIDHYD-04-859.pdf","bib":"TIDHYD-04-859.bib"},
{"paperid":"861","title":"Optimal sizing of submarine cables from an electro-thermal perspective","keywords":"<p>In similar fashion to most renewables, wave energy is CapEx intensive: the cost of the wave energy converter (WEC), infrastructure, and installation is estimated to represent 60-80% of the final energy cost In particular, grid connection and cable infrastructure is expected to represent up to 40% of the total project costs. However, substantial economical savings could be realised by further optimising the electrical design of the farm, and in particular by optimising the submarine cable sizing.</p> <p>Two complementary approaches specific to wave energy can be envisaged. Both exploit the variable nature of wave energy and are intended to reduce the cabling cost by minimizing the cable cross-sectional area while preserving the safe and reliable operation of the wave farm network. This paper will present the results of a comparative study focussing on submarine cables temperature response to fluctuating electrical current profiles and  obtained through the simple model and through the finite element analysis tool COMSOL. This study is intended to determine whether a simple model may be sufficient for rating optimisation studies, and if so, how this simple model should be parameterised. In addition, this paper will present an estimation of the potential savings in terms of cable costs that could be realised over an entire farm by using this approach, while considering also the revenue loss increase which would be generated by decreasing the cable cross-sectional area.</p>","authors":"A. Matine, C. Bonnard, A. Blavette, S. Bourguet, F. Rongère, T. Kovaltchouk, E. Schaeffer","topic":"7","file":"GRDPTO-04-861.pdf","bib":"GRDPTO-04-861.bib"},
{"paperid":"862","title":"INFLUENCE of POWER TAKE-OFF DAMPING on the HYDRODYNAMIC PERFORMANCE of an OSCILLATING WATER COLUMN","keywords":"<p class=IEEEParagraph>Oscillating Water Column (OWC) device made up of a chamber with a bottom opening and air trapped at the top, has proved to harness the wave energy. This device uses the wave motion to compress and decompress the air column, thereby, pressurizing the entrapped air due to damping from an air hole, the Power Take - Off (PTO) device. One of most important parameter governing the efficiency of the OWC is optimum PTO damping. The objective of the present study is to investigate the hydrodynamic performance of the OWC subjected to different PTO damping through numerical modelling and laboratory investigations. Initially, the numerical model is validated by comparing numerical results of five different PTO damping [0.10 %, 0.40 %, 0.68 %, 1.00 %, and 1.30 % of a/A] with the laboratory measurements. A good agreement between the computed and the experimental results is seen for the air pressure measurements and free surface oscillations inside the OWC chamber. In this paper, the influence of PTO damping on the variations of hydrodynamic efficiency, wave power absorption coefficient, wave amplification factor, and pressure ratios are studied and the results are reported as a function of relative water depth.</p>","authors":"J. SAMUEL, S. SANNASI ANNAMALAISAMY, S. VALLAM","topic":"7","file":"GRDPTO-04-862.pdf","bib":"GRDPTO-04-862.bib"},
{"paperid":"864","title":"Dynamics of moored buoys in non-linear wave with the aim of improvement of wave energy absorption","keywords":"<p class=IEEEParagraph>In the present research, the process of wave energy absorption and its conversion to electricity in the point absorber single-body converter has been simulated to the spring-linear damper system and dynamics of a moored converter is investigated in a nonlinear wave both in the time and frequency domain.</p> <p>Four geometries are considered for the buoy of modeled converter that two geometries are non-routine and innovation. Equalization of environmental conditions has been discussed. A method has been suggested for the comparison of buoys dynamic in a wave under identical conditions. Hydrodynamic analysis is performed with the aid of the boundary element code AQWA under identical modeling and environmental conditions.</p> <p>The incident wave to the models has been regarded a second order stokes wave. In order to compare the obtained results from the effective energy of wave on each model has been used. The effective energy of wave has been calculated based on the geometric characteristics of buoys. Afterward, the wave energy absorption percentage by each model was calculated.</p>","authors":"M. Berenjkoob","topic":"3","file":"WAVDEV-05-864.pdf","bib":"WAVDEV-05-864.bib"},
{"paperid":"865","title":"Cost of energy for starting a  Vertical Axis Marine Current Turbine","keywords":"A vertical axis marine current turbine is not self-starting. It needs some starting energy to increase the rotational speed enough for the turbine to start absorbing the kinetic energy in the water. This paper investigates the electric energy needed for startup and discusses the requirement for installed power. The startup process is investigated using experimental data from an experimental hydro-kinetic power station in Söderfors, Sweden.","authors":"J. Forslund, K. Thomas, M. Leijon","topic":"4","file":"TIDDEV-04-865.pdf","bib":"TIDDEV-04-865.bib"},
{"paperid":"866","title":"Grid integration for marine renewable energy devices in a real time application","keywords":"<p class=IEEEParagraph><span lang=EN-AU>This paper will describe the integration of real time hardware-in-the-loop (HiL) equipment into a marine renewable test bed. The HiL equipment will be used to test and compare the effects of a simulated marine renewable energy (MRE) model and emulated MRE system on a microgrid. The marine applications include tidal turbines, ocean current turbines, and wave energy converters.</span></p><p class=IEEEParagraph><span lang=EN-AU>An Opal-RT power HiL system provides advanced grid specific emulation capabilities. This will allow investigation into large microgrids including dc microgrids, and the effects of long transmission lines, and the interaction between these software-based grid models and lab hardware.</span></p><p class=IEEEParagraph>The Opal-RT offers a simulation environment to facilitate MRE power take-off integration. An islanded microgrid model with loads, sources, transformers, transmission lines, and batteries can be created in Matlab/Simulink. Utilising the Opal-RT and Triphase NV power converter, the effects of the power generated from the available MRE emulation generator in the laboratory on the software model and vice versa can then be investigated in this HiL system. Power quality including frequency, voltage and THD levels can be studied. An existing hydrodynamic model in Matlab/Simulink will reproduce the PTO forces on a simulated MRE device in the sea environment.</p> <p class=IEEEParagraph> </p>","authors":"A. Monterrat, D. Murray, R. Christie, J. Kelly","topic":"7","file":"GRDPTO-05-866.pdf","bib":"GRDPTO-05-866.bib"},
{"paperid":"868","title":"Navier-Stokes CFD Analysis of a Tidal Turbine Rotor in Steady and Planar Oscillatory Flow","keywords":"<p class=IEEEParagraph>This paper will report the main results of a numerical study of tidal current turbine (TCT) rotor stall carried out using Navier-Stokes (NS) Computational Fluid Dynamics (CFD). The study considers the experiment reported in [1], in which a TCT rotor translates in a flume tank animated by a translational velocity resulting from the superposition of a uniform and a harmonic velocity component. The experiment provided time-accurate measurements of the out-of-plane root bending moment. The significant hysteresis of such moment and the relatively low Reynolds number pointed to the existence of dynamic stall.</p> <p class=IEEEParagraph>The study aims at determining the patterns and assess the strength of the stall phenomena occurring in the TCT rotors of this experiment. This information is deemed relevant to future TCT design. The study also aims at assessing the capabilities of NS CFD to predict this challenging flow field. It is envisaged that the outcome of this investigation will provide further insight into unsteady hydrodynamics of TCTs relevant to design, and also a valuable assessment of the potential of CFD to predict this type of complex flows.</p> <p class=IEEEReferenceItem>[1] I.A. Milne et al.,, <em>Blade loads on tidal turbines in planar oscillatory ﬂow</em>, Ocean Eng., 60, 163-174, 2013.</p>","authors":"G. Amato, S. Doyle, S. Petley, M. Campobasso, I. Milne, G. Aggidis","topic":"6","file":"TIDHYD-PP-868.pdf","bib":"TIDHYD-PP-868.bib"},
{"paperid":"870","title":"Wave energy extraction in the North Atlantic: Future wave climate availability","keywords":"<p><span>Ireland is ideally positioned for ocean energy extraction with its exposure to the Atlantic Ocean. However, depending on how wave energy potential may change in the future, wave energy extraction can become impractical. For this reason, we examine in detail the percentage of time for which energy extraction is possible. This provides a useful analysis of locations around the coast of Ireland for Wave Energy Converter deployment. We estimate the changes in the wave energy flux outputted from a three-grid WAVEWATCH III model ensemble, focusing on the Northeast Atlantic region. The largest regular grid has 0.75º x 0.75º horizontal grid spacing and covers the North Atlantic, the middle regular grid has a resolution of around 25 km in the Northeast Atlantic and the grid closest to the shore of Ireland is an unstructured grid with a resolution ranging from 15 km offshore to 1 km nearshore. The first two grids are two-way nested and the unstructured grid is forced with the spectrum from the middle grid. The model is forced by EC-Earth data and ERA-Interim fields. We analyse how wave energy might change towards the end of the twenty first century under two Representative Concentration Pathways (RCPs) RCP4.5 and RCP8.5.</span></p>","authors":"J. Janjic, S. Gallagher, F. Dias","topic":"1","file":"WAVRES-03-870.pdf","bib":"WAVRES-03-870.bib"},
{"paperid":"871","title":"Analytical Cost Modeling for Co-Located Wind-Wave Energy Arrays","keywords":"<p class=IEEEParagraph>In this paper, we investigate current methods in quantifying synergistic effects of co-located floating wind-wave arrays, propose a cost model that accounts for these synergistic effects, and identify areas in which this model needs improvement through future research efforts.</p>","authors":"C. Clark, A. Miller, B. DuPont","topic":"10","file":"ECONOM-02-871.pdf","bib":"ECONOM-02-871.bib"},
{"paperid":"872","title":"Long Term Wave Climate at the Danish Test Site DanWEC Based on 30 Years Hindcast Data","keywords":"This work is on the long term wave climate at the danish test site DanWEC based on 30 years hindcast data obtained for MIKE 21 spectral wave model. This includes seasonal and annual variation of the wave climate at the site together with an analysis of extreme events at the DanWEC test site based on different methods.","authors":"A. Tetu, P. Jensen, K. Nielsen, F. Schlütter, J. Kofoed","topic":"1","file":"WAVRES-04-872.pdf","bib":"WAVRES-04-872.bib"},
{"paperid":"873","title":"Turbulence effects on tidal turbines: Modelling of tidal turbine performance in CFD","keywords":"<p class=IEEEParagraph> </p><p class=IEEEParagraph>The main aim of the research is to understand the effect of turbulence on the performance and loading of a tidal turbine.</p><p class=IEEEParagraph>In order to achieve this aim, a parametric 2D CFD study was undertaken focusing on turbulence length scales and turbulence intensity on a 63-415 NACA hydrofoil. This study is aided by other numerical methods as well as comparison to past experimental studies.</p><p class=IEEEParagraph><span lang=EN-AU>Results in this study show the particular importance of the turbulence parameters in the increase of shear force contributing to drag and the decrease of lift performance on a NACA hydrofoil as well as a discussion of the hydrodynamics from which they originate. </span></p>","authors":"M. Reta Palacios, V. Venugopal, D. Sutherland","topic":"6","file":"TIDHYD-PP-873.pdf","bib":"TIDHYD-PP-873.bib"},
{"paperid":"874","title":"WEC-GA optimisation tool for an oscillating wave surge converter","keywords":"<p>We present a novel optimisation tool for wave <span style=font-size: 10px;>energy converters based on a genetic algorithm, WEC-GA. In </span><span style=font-size: 10px;>this study, we use a Genetic Algorithm (GA) to find new sets </span><span style=font-size: 10px;>of high-power configurations starting from a large search </span><span style=font-size: 10px;>space, for which traditional numerical methods are not </span><span style=font-size: 10px;>efficient. Genetic Algorithms (GAs) are powerful techniques </span><span style=font-size: 10px;>that implement the basic principles of genetics and Darwinian </span><span style=font-size: 10px;>natural selection, traversing large search spaces in a stochastic </span><span style=font-size: 10px;>manner.</span></p><p>Solving the governing equations of the <span style=font-size: 10px;>system allows us to derive a new fitness function, suitable for </span><span style=font-size: 10px;>being implemented into a GA optimisation model. The fitness </span><span style=font-size: 10px;>function physically represents the average capture factor over </span><span style=font-size: 10px;>a reference period interval, e.g. 5 – 15 seconds for the North </span><span style=font-size: 10px;>Atlantic Ocean.</span></p><p>Our method is capable of identifying clusters of optimal <span style=font-size: 10px;>solutions at parametric values that </span><span style=font-size: 10px;>were not identified in previous studies on the oscillating wave surge converter.</span></p><p><span style=font-size: 10px;><br /></span></p>","authors":"E. Renzi, J. Leech, I. Phillips","topic":"5","file":"WAVHYD-06-874.pdf","bib":"WAVHYD-06-874.bib"},
{"paperid":"878","title":"Electrical Approach to Output Power Optimization  for a Point Absorbing Wave Energy Converter with a  Direct Drive Linear Generator Power Take Off","keywords":"<p class=IEEEParagraph>Since Budal and Falnes showed that maximal power output from a point absorber can be achieved if the device velocity and the excitation force are in phase, different  control strategies has been proposed and investigated to improve power output from a wave energy converter. Among them are reactive power control, latching and declutching, suboptimal control strategies, optimization of damping coefficients.</p>All the studies are limited to the linear potential wave theory and either present linear models or include damping force with a constant damping factor. <br /><p class=IEEEParagraph>Wave energy converter (WEC) considered in the paper is a point absorber with a direct drive linear generator power take off (PTO). The generator is placed on the sea floor anchored by a gravity-based foundation. The buoy on the water surface moves driven by ocean waves and is connected via a stiff steel wire rope to a translator inside the generator. When the translator moves relative the stator, a voltage is induced in the stator windings.</p> The aim of the present paper is to study optimization of output power for this type of WEC using a combined hydro-mechanical and electrical models. The model is implemented using a non-linear numerical wave tank (NWT) based on Reynold-averaged Navier-Stokes (RANS) equations and in Matlab based on the boundary element method (BEM).","authors":"I. Dolguntseva, S. Eriksson, M. Leijon","topic":"7","file":"GRDPTO-05-878.pdf","bib":"GRDPTO-05-878.bib"},
{"paperid":"879","title":"Relative Velocity at the Rotor of a Vertical Axis Tidal Stream Turbine on a Floating Platform","keywords":"<p>Over recent years the tidal energy sector has seen a move towards smaller turbines, often combined with a floating platform, with the aim of producing a commercial device with lower capital cost than megawatt scale turbines.  Instream Energy Systems (Instream) has taken this a step further by focusing on a low cost tidal turbine technology suitable for community scale and shallow water resources of 5 to 40 metre water depth.</p> <p>ITPEnergised and Instream have been developing a floating platform to support Instream’s vertical axis rotor and drivetrain. Preliminary design of the floating platform has been carried out and hydrodynamic modelling of selected concepts has been completed for a range of typical and extreme load cases.</p> This paper presents an analysis of the relative velocity measured between the rotor and the sea water based on results from the hydrodynamic model which incorporated random sea states and tidal currents. The effect of the platform design, moorings, and location of the rotors on the variation in the relative velocity throughout the rotor swept volume is presented.","authors":"S. Jeddere-Fisher, G. Bawn, D. Leboe, R. Conron","topic":"4","file":"TIDDEV-04-879.pdf","bib":"TIDDEV-04-879.bib"},
{"paperid":"880","title":"Near Wake Flow Structure behind an Axial Flow Hydrokinetic Turbine in the Presence of Waves","keywords":"<p>Two dimensional PIV measurements in the near wake flow field (x/D&lt;2, x-downstream location from the rotor plane) are presented for a 1/25 scale, 0.8 m diameter (D) two bladed horizontal axis tidal turbine. All measurements were obtained in the United States Naval Academy 110m tow tank with turbine towed at a constant carriage speed U<sub>tow</sub> = 1.68m/s, at the nominal tip speed ratio (TSR) of 7 and tip immersion depth of 0.5D. Regular waves with a period of 2.3s and 0.17m wave height generated by the upstream wave maker were traveling in the opposite direction of the carriage travel, representing a case of current superimposed with the incident waves.</p><p>This paper will focus on characterizing the flow structure in the near wake with emphasis on the downstream evolution of coherent tip vortices shed by the rotor blades and their vertical/horizontal displacements by the wave induced fluctuations.</p>","authors":"L. Luznik, E. Lust, K. Flack","topic":"4","file":"TIDDEV-05-880.pdf","bib":"TIDDEV-05-880.bib"},
{"paperid":"883","title":"‘VETT’ – Reducing the Cost of Tidal Power Generation","keywords":"<p>Venturi-Enhanced Turbine Technology (‘VETT’) is a new, patented, technique for radically improving the cost-effectiveness of low head (1 to 4m) hydropower generation.</p> <p>This paper will describe developments made in the last four years to improve hydrodynamic efficiency, to re-configure its layout for more economical use in bi-directional tidal flows, and to further establish its benign environmental characteristics.</p> <p>The paper covers the following aspects:</p> <ul><li>operating principles</li><li>hydrodynamic development</li><li>configuring for tidal power, and</li><li>environmental impact</li></ul> <p>including results from large scale laboratory work at BHRGroup, Cranfield and HRWallingford in the UK, Vis Advies in Utrecht, The Netherlands; and with the Mathematical Institute at University of Oxford.</p>","authors":"P. Bird, P. Roberts, G. Benham, S. Downie","topic":"4","file":"TIDDEV-05-883.pdf","bib":"TIDDEV-05-883.bib"},
{"paperid":"886","title":"Modelling and calibration of a direct drive hydraulic PTO","keywords":"<p>The Power Take-Off (PTO) is an integral part of allWave Energy Converters (WECs). As well as fulfilling its primary purpose of extracting power from the WEC it is frequently the main control member within the device too. This means that its dynamic response can be as important as its efficiency in governing Levelised Cost of Energy (LCoE) as this directly affects the success of the control methods applied to the WEC.This paper presents a model of the hydraulic PTO intended for deployment on a third scale CCell device which has been developed to enable the investigation of control methodology and to inform design. The simulation model is then compared to data from initial testing of the PTO in the laboratory of the Centre for Power Transmission and Motion Control at the University ofBath.</p>","authors":"N. Sell, A. Plummer, A. Hillis, D. Chandel","topic":"7","file":"GRDPTO-05-886.pdf","bib":"GRDPTO-05-886.bib"},
{"paperid":"887","title":"Opportunities for Tidal Stream Energy in Indonesian Waters","keywords":"<p class=ieeeparagraph><span lang=EN-AU>Indonesia has great potential for exploitation of its tidal resources. There are many narrow straits between the islands of the Indonesian archipelago. The Indonesian government’s “Ocean Energy Resources Map” shows the available power based on flow current measurement in 10 potential sites. The available power can be assessed at three levels: theoretical resources, technical resources and practical resources. Very substantial figures have been suggested for the theoretically available resource, but this needs to be assed in more detail and the technical and practical limitations taken into account. </span></p> <p class=ieeeparagraph><span lang=EN-AU>This paper aims to presents an overview, to understand the general characteristics of the region, before detailed tidal resource assessment of the Indonesian region is undertaken</span></p>","authors":"A. Firdaus, G. Houlsby, T. Adcock","topic":"2","file":"TIDRES-03-887.pdf","bib":"TIDRES-03-887.bib"},
{"paperid":"888","title":"Survey of the Near Wake of an Axial-Flow Hydrokinetic Turbine","keywords":"Two-dimensional PIV measurements in the near wake flow field (x/D&lt;2, x-downstream location from the rotor plane) are presented for a 1/25 scale, 0.8 m diameter (D) two bladed axial flow hydrokinetic turbine (Figure 1). All measurements were obtained in the United States Naval Academy 110m tow tank with the turbine towed at a constant carriage speed U<sub>tow</sub> = 1.68m/s, at the nominal tip speed ratio (TSR) of 7 and tip immersion depth of 0.5D. Near wake mapping is accomplished by “tiling” individual 2D PIV fields of view (nominally 30x30 cm<sup>2</sup>) with approximately 5 cm overlap. PIV ensembles were obtained for phase locked conditions with the reference blade at the 90<sup>○</sup> position. This paper will focus on characterizing the velocity and flow structure in the near wake with emphasis on the downstream evolution of coherent tip vortices shed by the rotor blades.","authors":"K. Flack","topic":"4","file":"TIDDEV-05-888.pdf","bib":"TIDDEV-05-888.bib"},
{"paperid":"889","title":"Seasonal occurrence of seabirds and marine mammals at a wave energy test site","keywords":"Two years of baseline data on the seasonal occurrence and distribution of sensitive marine species was conducted at the WESTWAVE wave energy test site, Co. Clare, Ireland. Monthly strip transect aerial surveys were conducted for seabirds and marine mammals, while monitoring for cetacean species was also undertaken using static Passive Acoustic Monitoring (PAM). Seabirds were recorded on all transects of all surveys, with 7161 seabirds representing 22 species recorded across all surveys. High seabird abundance occurred throughout the year, with ‘hotspots’ of abundance widely distributed during spring &amp; autumn, and concentrated coastally in summer, reflecting more limited foraging ranges during the breeding season. 25 visual sightings of seven marine mammal species were recorded. However PAM monitoring recorded more frequent use of the area by cetaceans. Nearshore, detections of harbour porpoise and dolphins were regular during the summer of the first monitoring year, but fell dramatically thereafter. Offshore, harbour porpoise were rarely detected while dolphin species were regularly recorded. The rate of acoustic detections exceeded the visual sightings, which reflects the increased temporal coverage of PAM compared to visual surveys<ins datetime=2017-01-06T14:23 cite=mailto:Kavanagh,%20Ailbhe>.</ins> Further monitoring will determine impacts on sensitive marine species during construction and operational phases of wave energy development at the site.","authors":"W. Hunt, A. Bennison, A. Kavanagh, M. Nykanen, B. O'Connor, M. Jessopp","topic":"9","file":"ENVIRO-02-889.pdf","bib":"ENVIRO-02-889.bib"},
{"paperid":"890","title":"Application of Complex Wave and Current Conditions in a Laboratory Environment","keywords":"In this paper we discuss the merits and applications of using advanced conditions for tank testing, highlighting the role they can play in the effective development of offshore renewable technologies. Additionally, examples of such complex sea states are created at the FloWave Ocean Energy Research Facility, including site-specific directional wave spectra, and wave-current conditions. The process of creating a validated set of these sea states is focussed on and described, and the benefits of being able to produce these real-world-like conditions is stressed.","authors":"S. Draycott, D. Noble, T. Davey, J. Steynor, D. Ingram","topic":"3","file":"WAVDEV-05-890.pdf","bib":"WAVDEV-05-890.bib"},
{"paperid":"891","title":"Ocean energy in Europe: assessing support instruments and cost-reduction needs","keywords":"<p class=IEEEParagraph><span lang=EN-AU>The ocean energy sector has made considerable progress over the past few years.  Significant developments have taken place in the EU and Canada, with the deployment of the first tidal energy demonstration farms, a milestone for the creation of the ocean energy market. In Europe,  tidal and wave energy are those poised to provide the most significant contribution in the short-term., with about 71 MW of tidal and 37 MW of wave energy capacity expected to be deployed within the EU  by 2020.</span></p><p class=IEEEParagraph><span lang=EN-AU>The sector is therefore required to achieve significant cost-reduction in the next 10 to 15 years, and to achieve this it is extremely important that support schemes are tailored to the needs of the technology. In addition to existing support systems, novel R&amp;D and financial instruments need to be identified to support the technological development of wave energy technology and to help reduce the risk associated with demonstration farms, hindering in particular the progression of tidal energy technology. The cost of tidal and wave energy technology has to be reduced by 75% and 85% to meet the targets agreed in the SET-Plan.</span></p><p class=IEEEParagraph><span lang=EN-AU>By taking into consideration the current ratio of public/private funds required to ensure financial close of fist-of-a-kind ocean energy arrays,  recommendations will be made to what type of effort will be required to support the sector in 2020, 2025 and 2030.</span></p>","authors":"D. Magagna, R. Monfardini, A. Uihlein","topic":"10","file":"ECONOM-02-891.pdf","bib":"ECONOM-02-891.bib"},
{"paperid":"892","title":"Toward the modelling of turbulence at tidal stream power sites with the Lattice Boltzmann Method","keywords":"<p>Tidal power extraction sites are characterized by turbulent flows. An accurate turbulence characterization is required to optimize power extraction and to assess structural damages on tidal turbines. In particular, the influence of the seabed morphology on the turbulence is not well understood yet.</p> <p>H2020 THYMOTE project aims to investigate this issue by combining in-situ measurements, flume experiments, and numerical modelling based on Large Eddy Simulation (LES). The study site is the Alderney Race which is the most promising tidal stream power site in France.</p> <p>In the framework of the THYMOTE project, we intend to use LBM (Lattice Boltzmann Method) in combination with LES to better understand the processes controlling the turbulence in the Alderney Race. Prior to model the flow in the Alderney Race, the model should be validated with experimental data. The purpose of this contribution is to present the LBM-LES model and its validation.</p> <p>The model results are compared to experimental measurements performed in a free surface flow over macro-roughness. Preliminary results show that the model results fit well the experimental data. Finally, a sensitivity analysis is performed on the Reynolds number and the characteristics of the macro-roughness.</p>","authors":"P. Mercier, M. Grondeau, S. Guillou, J. Thiébot, E. Poizot","topic":"2","file":"TIDRES-03-892.pdf","bib":"TIDRES-03-892.bib"},
{"paperid":"893","title":"An Examination of Marketplace Support Options for Marine Renewable Energy Development with Particular Reference to the Experience in Nova Scotia, Canada","keywords":"<p class=IEEEParagraph>This paper will examine the market options available to support the development of marine renewable energy projects within the context of policy drivers such as acceleration of renewable energy, economic development, and managing public concerns over the cost of renewables. The paper will consider the history of competitive calls for proposals, renewable electricity standards and Feed-in-Tariffs (FIT’s) as instruments to grow renewable electricity supplies in North America and Europe within the context of national and sub-national government objects. It will then examine the policy drivers for marine renewable energy and the unique characteristics associated with encouraging diverse emerging technologies. Following the establishment of the general policy considerations when designing market support for marine renewable energy, the paper will explore the experience of Nova Scotia – a Province in Canada - in the use of renewable electricity standards as a policy tool that has been accompanied by utility built projects on a cost-of-service basis; independent power producer projects on a competitive basis and both community feed-in-tariffs and tidal sector specific tariff programs. The experience under each model, the alignment with policy objectives and factors leading to change in models used will the documented. The paper will conclude with an analysis of issues that will need to be addressed as the jurisdiction moves from a FIT policy tool into a new marine renewable licencing regime and competitive process to receive market supports.</p>","authors":"B. Cameron","topic":"10","file":"ECONOM-03-893.pdf","bib":"ECONOM-03-893.bib"},
{"paperid":"894","title":"Coupled ADCP measurements for tidal turbulence characterization","keywords":"<p>Tidal turbines are placed in high-energetic environments, with large tidal range, where flow velocities and the potential for energy generation are large. At these locations, turbines will encounter strong turbulent flows. Typically, turbulence intensity is used as a parameter to quantify turbulence. Additional parameters can be considered for coherent turbulence quantification, such as anisotropy magnitude and (coherent) turbulent kinetic energy (McCaffrey et al. 2015). These parameters allow for better characterization of the coherence, intermittency and anisotropy of the turbulence.<br /><span style=white-space: pre;> </span>An experiment was conducted during 15 days to measure flow using two upward looking acoustic Doppler current profilers (ADCPs). The two ADCPs were coupled (master-slave set-up) and measured alternately at 2 Hz. Mean water depth at the field site was approximately 25 m, with 6 m tidal range and semi-diurnal tides. Variations in velocity were large during flood tide, possibly due to large coherent structures shedding off the headland. By combining the beams of two coupled ADCPs, all 6 Reynolds stress terms can be resolved (Vermeulen et al. 2011). The resulting Reynolds stress tensors are then used to estimate turbulence characteristics, such as coherence and anisotropy, and their vertical variation.</p>","authors":"A. Pieterse","topic":"2","file":"TIDRES-04-894.pdf","bib":"TIDRES-04-894.bib"},
{"paperid":"897","title":"Mooring load management for SR2000 floating tidal device using non-linear polymer components","keywords":"<p>Mooring floating tidal platforms is challenging due to the high base load on the mooring lines. This high base load is generated by the thrust of the turbines and pulls traditional mooring lines taut, leaving no give in the system to absorb wave loads above the mooring load.</p><p>This paper presents a novel mooring component designed to overcome this problem. The polymer based component has a non-linear resposen curve which is very stiff up to the thrust load, but which then softens substantilyl beyond the thrust load allowsing for the mooring line to stretch with the individual waves, greatly reducing the peak overall loads.</p><p>The paper presents the initial results from the mooring development work undertaken as part of the H2020 FloTEC project led by ScotRenewables. It loos at the Orcaflex modelling to determine the desired non-linear component response, the FEA modelling to determine the polymer componetn shape needed to deliver that response and the overall design of the robust deployable physical component which delviers that response in the coean. Data and resutls from each stage of the project are presented and analysed.</p>","authors":"P. mcevoy","topic":"12","file":"MRGFND-02-897.pdf","bib":"MRGFND-02-897.bib"},
{"paperid":"900","title":"Upscaling of Tidal Turbine Blades: Glass or Carbon Fibre Reinforced Polymers?","keywords":"<p>Building larger tidal turbine blades with the traditionally used glass fibre reinforced polymers (GFRP) requires an increase in the thickness of structural laminates used, bringing increased difficulty and costs of manufacture. In highly loaded areas of the blade, the external shape is a compromise between hydrodynamic and structural efficiency and strongly influenced by the resistance of the materials used against short-duration and fatigue loading. Alternative materials such as carbon fibre reinforced polymers could, therefore, offer a natural choice for use in tidal blade design given their high strength and resistance to fatigue. Hence, the subject of this study is to investigate possible benefits of replacing GFRP with carbon fibre reinforced polymers (CFRP) in the design of tidal turbine blade structures. Use of high-strength CFRP could sidestep material processing issues that might be associated with very large glass blades. Additionally, CFRP composites could allow for more slender blades which could increase power capture.</p> <p> </p>","authors":"V. Jaksic, F. Wallace, C. Ó Brádaigh","topic":"8","file":"STRMAT-01-900.pdf","bib":"STRMAT-01-900.bib"},
{"paperid":"902","title":"Modelling Wave Breaking Statistics for MRE Applications","keywords":"<p><span>Wave breaking induces large loads on marine structures and is therefore a key element of the extreme design of Marine Renewable Energy (MRE) Devices devices. However neither the wave breaking statistics or the loads on marine structures can be predicted with acceptable accuracy.</span></p> <p><span>This paper will focus on the estimation of the wave breaking statistics of extreme sea state obtained from the phase-averaged wave model WaveWatchIII<sup>TM</sup>. The different wave breaking dissipation parameterizations available in the model will be discussed along with the breaking statistics that can be derived from them.  The wave model will then be applied to storm events of the 2013-14 winter in the Iroise Sea, Brittany, France (see Figure), famous for its severity. The model output will be compared to observations of  breaking statistics obtained in similar sea state conditions. The paper ends with two discussions :</span></p> <p><span>- a first on the adequacy between the type and accuracy of the breaking statistics that can be produced by phase-averaged wave models  in relation with the needs of the MRE sector in the context of extreme design of MRE devices,</span></p> <p><span>- a second on the research to be pursued to improve the wave breaking dissipation parameterizations in WaveWatchIII<sup>TM</sup>.</span></p>","authors":"J. Filipot","topic":"5","file":"WAVHYD-06-902.pdf","bib":"WAVHYD-06-902.bib"},
{"paperid":"904","title":"Development of a Polymer Spring Pump based PTO","keywords":"<p>This paper presents the initial work from the WES Gator project looking at a novel polymer spring based PTO system. The project was funed under the Wave Energy Scotland Novel PTO funding call and successfully transitioned from stage 1 to stage 2 at the end of 2016. The Gator PTo uses a polymer spring pump, with a non-linear response, operating at 5-10 bar pressure, to drive water through an existing hydro-power turbine. The system avoids many of the key failure mechaisms of other fluidic power take off systems. It has no moving seals, has short fluidic pipelines, using existing mature hydro-power technology, and uses longlife marine compatible polymer components.</p><p>The paper presents some of the initial design work and experiments which were undertaken to explore the feasibility of the concept. Initial empirical work and simulation / modelling work explored the performance expectations and operational ranges which the spring pump would need to operate at, while experimental work investigated the behaviour and performance of a range of polymer spring pumps in different potential system configurations.</p><p>Results from all thiswork are presented and discussed.</p>","authors":"C. Casey","topic":"7","file":"GRDPTO-05-904.pdf","bib":"GRDPTO-05-904.bib"},
{"paperid":"905","title":"Shape Optimization for the Submerged Body of a Two-Body Wave Energy Converter","keywords":"<p class=IEEEParagraph><span lang=EN-AU>The shape of the submerged body on a two-body wave energy converter is studied in this paper. For this study, varying shapes and sizes of the submerged body are investigated to see the influence the submerged body has on the absorption power of a two-body system. Three different submerged body shapes are investigated; plate, cylinder and sphere. The hydrodynamic parameters for the varying shapes and sizes of the submerged body are calculated using boundary element method software (WAMIT). The two-body dynamics are modelled in WEC-Sim. Simulations were completed for both regular and irregular wave conditions. It is found that the maximum power for each shape will occur at a certain mass ratio. It is also found that for small to no viscous effects, the power of the two-body system can exceed that of a single body system. Small viscous effects however become unrealistic with increasing submerged body size. Simulations show the cylinder performing the best, the sphere performing slightly worse than the cylinder, and the plate performing the worst.</span></p>","authors":"D. Martin, A. Wise, C. Liang, L. Zuo","topic":"3","file":"WAVDEV-05-905.pdf","bib":"WAVDEV-05-905.bib"},
{"paperid":"906","title":"Modelling the Effect of Turbulence Length Scale on Tidal Turbine Wakes using Advanced Turbulence Models","keywords":"<p>Understanding the length and character of tidal turbine wakes is crucial for array optimisation and assessment of the environmental impacts of turbine arrays.</p><p><br />This study examines the ability of the Detached Eddy Simulation (DES) hybrid turbulence model to model the effects of turbulence length scale on the wakes of tidal stream turbines. DES is a scale-resolving turbulence model which seeks to combine the computational efficiency of a 2-equation RANS model with the high resolution of a Large Eddy Simulation in the wake region. When compared to RANS turbulence models, this allows for better modelling of the mixing of the free stream with the turbine wake, and yields much more information about not only the length, but also the character of the turbine wake. This is accomplished whilst still retaining the full 3D rotor geometry. In addition to this, the CFD results are compared to detailed wake measurements obtained in a recirculating flume experiment.</p><p><br />Hybrid turbulence models such as DES have the potential to allow better modelling of turbine wakes at a reasonable computational cost, leading to better understanding of the interactions between turbines within an array, as well as possible effects of a turbine array on the wider marine environment.</p>","authors":"T. Ebdon, D. O'Doherty, T. O'Doherty, A. Mason-Jones","topic":"6","file":"TIDHYD-04-906.pdf","bib":"TIDHYD-04-906.bib"},
{"paperid":"907","title":"Interactions and Implications of Tidal Energy Arrays","keywords":"<p>A 3D ROMS model of the Pentland Firth has been created, and a mid-depth force term applied in regions of interest, to simulate the cumulative interaction and impacts of multiple tidal energy developments within a region. This research questions resource assessment methodology and identifies how tidal energy extraction at one site may affect the available resource at another. Finally, a mechanism to determine sediment type from the modelled bed shear stress has been employed to identify prospective sediment transport implications. The overall aim of this PhD research is to contribute to research investigating the extent of the impact of tidal energy extraction, and to determine whether tidal energy array developments will be a useful tool in future coastal defence plans.</p>","authors":"A. Goward Brown","topic":"9","file":"ENVIRO-02-907.pdf","bib":"ENVIRO-02-907.bib"},
{"paperid":"909","title":"Protocols for marine current energy converter tank testing. Where are we ?","keywords":"<!-- p { margin-bottom: 0.25cm; line-height: 120%; } --> <p style=text-indent: 0.38cm; margin-top: 0.2cm; margin-bottom: 0cm; line-height: 100%;><span style=font-size: x-small;><strong><span style=font-weight: normal;>T</span></strong><span style=font-weight: normal;>a</span>nk testing is primarily undertaken to establish the behaviour of a tidal energy converter at model scale and to identify the impact of different test configurations on device performance. Due to the fact that marine renewable testing centres are not uniformly configured or constructed, standardisation in test practices is an important aspect for industrial development. At present there is no consensus on appropriate test methodologies and practices to be implemented. In order to improve the work already done, experimental trials will be undertaken on tidal energy devices under the Interreg 2 seas Met-Certified project. During these tests, the IEC Tidal Scale testing procedures will be applied and evaluated for being fit for purpose. When necessary, a risk-based approach will be presented to define the reference set of certification requirements.</span></p> <p style=text-indent: 0.4cm; margin-top: 0.2cm; margin-bottom: 0cm; line-height: 100%; orphans: 2; widows: 2;><span style=font-size: x-small;>We propose to present the first results obtained under the Met-Certified project from the first experimental campaigns carried out in the wave and current flume tank of Ifremer. For the studied cases, the experimental set-up and protocol trials, tacking into account the actual guidelines, will be presented. We should be able to present recommendations for procedures adaptation.</span></p>","authors":"G. Germain, p. Scheijgrond","topic":"4","file":"TIDDEV-05-909.pdf","bib":"TIDDEV-05-909.bib"},
{"paperid":"910","title":"Physical Model Testing and System Identification of a Cylindrical OWC Device","keywords":"Ocean Wave Energy Converter (WEC) arrays may benefit<br />from coordinated control and strategic array placement. In<br />order to investigate these topics, a scaled physical model of an<br />Oscillating Water Column (OWC) has been designed,<br />constructed, and tested. This paper will focus on one OWC<br />device, with the intention of extending to an array of devices<br />leveraging both optimal array placement and coordinated<br />control to improve energy capture of the system. Focus will<br />be placed on the device design, construction, and<br />characterization. This includes a numerical model of the<br />device created using system identification techniques. This<br />model will be used in single device control and further work<br />will then incorporate array level control.","authors":"B. Bosma, T. Brekken, P. Lomonaco, A. McKee, B. Paasch, B. Batten","topic":"3","file":"WAVDEV-05-910.pdf","bib":"WAVDEV-05-910.bib"},
{"paperid":"911","title":"Phase-resolving wave modeling for Marine Renewable Energy sites characterization","keywords":"The objective is to study how the use of a phase-resolving model can benefit to wave charaterization for Marine Renewable Energy (MRE) applications in nearshore areas. Numerical simulations of waves are performed with the Boussinesq Ocean and Surf Zone model, BOSZ.  The goal is not to assess the wave resource but rather to discuss the capabilities of existing wave <br />modeling approaches to achieve a proper wave characterization assessment in order to provide guidance to MRE engineers.<br /><br />The phase-resolving approach provides an improved description of the nonlinear wave fields found in shallow waters. However, due to their high computational cost, phase-resolving models are restricted to single wave events representation and therefore they can not provide the long term time series needed for deriving proper statitistics.<br /><br />In this context, BOSZ outputs will be compared to wave simulations achieved with the high-resolution configuration of the spectral wave model WAVEWATCH III (WW3). Then, the present paper also aims at demonstrating the complementary between phase-resolving and phase-averaged spectral modeling approaches.<br /><br />The output of both models are compared to wave observations. This work is expected to provide advanced wave characterization assessment for the MRE actors.<br /><br />","authors":"A. Varing","topic":"1","file":"WAVRES-04-911.pdf","bib":"WAVRES-04-911.bib"},
{"paperid":"913","title":"Numerical simulation of a tidal turbine model in a turbulent flow with the Lattice Boltzmann Method","keywords":"<p>Milne et al (2013) showed that tidal sites like Alderney Race are characterized by a high turbulence rate. Clark (2015) showed that turbulence has a high influence on machine wake and performance. So the upcoming exploitation of high current areas implies a good knowledge of the turbulent flow interaction with tidal turbines.</p><p>As a tool for characterizing the flow, a numerical method is established for studying tidal turbines in their environment. The method used is based on the Lattice Boltzmann Method (LBM) coupled with Large Eddy Simulation (LES). The LBM approach is easily parallelizable and takes full advantage of modern parallel computers. Moreover, as an explicit method, it is well suited for LES.</p><p>For this paper, three main difficulties are overcome: LBM stability at high Reynolds numbers, blades rotation and a realistic turbulence implementation. A tank test study provides the complete dataset needed to validate the method. The simulation of a tidal turbine model with a LBM method and its validation with Mycek et al (2014) measurements is proposed in this paper. A comparison with a Navier-Stokes solver is also presented.</p><p> </p><p> </p>","authors":"M. Grondeau, P. Mercier, S. Guillou, J. Poirier, E. Poizot, Y. Méar","topic":"6","file":"TIDHYD-04-913.pdf","bib":"TIDHYD-04-913.bib"},
{"paperid":"914","title":"Engineering analysis of the submergence as a survivability strategy for floating OWCs","keywords":"<p class=ieeeparagraph>Device submergence under extreme sea conditions is expected to increase survivability and reduce the structural requirements. The base model created in Orcaflex is used to perform a parametric study, where the lengths of the mooring lines are gradually decreased, mimicking a winching system, to observe their impact in the static submergence depth and inclination and the mooring line tensions for an extreme sea state condition. Comparisons of these loads are made with the lines minimum breaking load and with the reference case scenario where the device is kept at surface. Furthermore, experimental testing of the OWC spar buoy in selected submerged configurations at the FloWave facility will provide complementary insight on the motion and loads experienced by the OWC spar buoy under extreme wave conditions. In parallel, a concept engineering analysis has been carried out to evaluate technical feasibility of submergence and potential impacts of the submergence on the device.</p>","authors":"P. Vicente, K. Krugel, M. Lopes, R. Gomes, J. Doussal, S. Girardin, F. Gorintin, M. Philippe","topic":"12","file":"MRGFND-02-914.pdf","bib":"MRGFND-02-914.bib"},
{"paperid":"915","title":"Experimental determination of the hydrodynamic parameters of an OWC","keywords":"<p>A novel technique to measure the frequency dependent hydrodynamic parameters of an oscillating water column (OWC) using tank testing is proposed and implemented. This technique arose from an investigation into the effect of air compressibility in the chamber above the water column on the power absorbed by OWCs. Two models of an OWC were constructed for that investigation. For the first model, the volume of the air chamber above the water column was scaled geometrically by the factor to which the water column was scaled. For the second, the volume of the air chamber was scale by the square of the factor. The proposed technique to measure the hydrodynamic parameters, which eliminates the need for a forced oscillation rig, uses these two OWC models, and relies on water column motion which takes place due to air compression when the air chamber of the second model is sealed from atmosphere. The technique is first described for monochromatic waves. Results obtained from the testing of an OWC presented. Spectral methods are then applied to the technique, which is demonstrated using computer models and then implemented using the model OWC. This allows multiple frequencies to be analysed using a single set of tests.</p>","authors":"T. Kelly, T. Dooley, J. Ringwood","topic":"5","file":"WAVHYD-06-915.pdf","bib":"WAVHYD-06-915.bib"},
{"paperid":"917","title":"Wave and Tidal energy devices offer environmental opportunities as artificial reefs","keywords":"<p><span style=font-family: Calibri; font-size: small;>Wave and tidal energy devices provide structures that are naturally colonised by marine flora and fauna. While it may be desirable to inhibit fouling of some parts of the energy devices, the colonisation of other features may not compromise the overall functionality. The EU project SEACAMS explored opportunities to design features deliberately attracting marine organisms and the creation of artificial reefs. Positive effects of artificial reefs include the enhancement of biodiversity of invertebrates and fish. Existing features and materials may be altered to improve settlement conditions, such as changes in the roughness of surfaces or the creation of niches and shelter. Reef- habitat may be added, such as rocks of different size, shape and erodibility. Marine energy devices often create shelter in or around the infrastructure and this allows the establishment of new features such as kelp-forests or seagrass meadows which would not survive more exposed conditions. Hard substratum such as rock armour provides attachment surfaces for reef-creating species like oysters, mussels or honeycomb tube-worms. Diversity promoting design solutions can be included in the planning and construction phase of wave or tidal energy devices to attract large numbers of species and to reduce the impact on the surrounding environment. </span></p>","authors":"R. Callaway","topic":"9","file":"ENVIRO-03-917.pdf","bib":"ENVIRO-03-917.bib"},
{"paperid":"918","title":"Coupled CFD-FEM structural analysis of tidal turbine blades","keywords":"<p class=IEEEParagraph><span lang=EN-AU>In recent years, there has been a growing interest in establishing renewable sources of energy to alleviate the global reliance on fossil fuels. Tidal energy, with its reliability and predictability, offers an excellent opportunity for a number of countries worldwide, such as Ireland, France, the UK and Canada. However, the harshest environments, where tidal energy devices will perform most efficiently, cause severe loading on the devices. The most commonly used method for initially estimating the hydrodynamic loads on horizontal axis turbine blades is the blade element momentum theory (BEMT)</span><span lang=EN-AU>. Computational fluid dynamics (CFD) is gaining ground due to increased computational capabilities and higher accuracy under a range of operating conditions</span><span lang=EN-AU>. In this paper, a methodology for developing a CFD model capable of accurately simulating the interaction between tidal flow and turbine is presented. This model is then coupled with a finite element method (FEM) solver in order to determine the total deformation and global stress and strain fields in the turbine blades.</span></p>","authors":"W. Finnegan, E. Edward Fagan, S. Leen, J. Goggins","topic":"8","file":"STRMAT-02-918.pdf","bib":"STRMAT-02-918.bib"},
{"paperid":"919","title":"Inclusion of Structural Flexibility in Design Load Analysis for Wave Energy Convertors","keywords":"Using composite materials and flexible designs have been proposed as a potential cost reduction pathway for wave energy convertors. The structural flexibility as well as its integrity has become increasingly important for evaluating the design loads of these devices. To consider the interaction between wave loading and structural deformation, a computationally efficient way to couple the structural and hydrodynamic analyses is highly desired, particularly during the system design phase. This paper details a method for the inclusion of structural flexibility in aero-hydro-servo-elastic dynamic simulations for wave energy convertors. The WEC-Sim multibody dynamic tool, coupled with the linearized frequency-domain analysis of wave radiation and diffraction in WAMIT is used for simulating dynamic response. This method is applied to a two-body point absorber to evaluate the effects of structural flexibility on response amplitude operators and loads. Preliminary results suggest that structural flexibility can significantly affect structure internal loads during extreme events.","authors":"Y. Guo, Y. Yu, J. van Rij","topic":"5","file":"WAVHYD-06-919.pdf","bib":"WAVHYD-06-919.bib"},
{"paperid":"920","title":"Verification of the SNL-SWAN Spectral WEC-wave Model with Phase-resolved Linear Wave Fields","keywords":"The eventual deployment of wave energy converters (WECs) at utility-scale in the form of wave farms could meaningfully alter the wave field, which may have down-wave effects on near-shore environments and processes such as benthic habitats and shoreline erosion and accretion. SNL-SWAN is an open-source extension of SWAN for modeling WEC impacts on the nearshore. It implements WECs via frequency-dependent absorption. A preliminary validation of SNL-SWAN was conducted by comparing results to WEC array experiments However, the implementation of WECs in spectral wave models via 2D transmission and reflection coefficients only partially describes the physics. Validation against experiments and verification against other codes of WECs in spectral wave models is limited.The goal of this work is to verify the results of the spectral wave model SNL-SWAN by comparing the wave fields it produces to those produced by phase-resolved linear wave theory using WAMIT. The comparison is both qualitative and quantitative, looking at a variety of WEC geometries and wave conditions. The focus is on the wave shadow, that is, the region down-wave which will have the greatest impact on nearshore processes. Results will help to clarify the appropriateness and best practices for implementing WECs in spectral wave models.","authors":"J. McNatt, K. Reuhl, A. Porter, J. Roberts","topic":"5","file":"WAVHYD-07-920.pdf","bib":"WAVHYD-07-920.bib"},
{"paperid":"921","title":"A Physical Mooring Comparison for a Floating  OWC","keywords":"<p>In order to advance the wave energy sector, the WETFEET project was set up under the EU Horizon 2020 programme to work towards six technology breakthroughs.  One of these breakthroughs concerns mooring line cost reduction strategies for arrays of wave energy devices.  The research is designed to be applicable to a generic floating WEC, but experiments were carried out using a SparBuoy OWC as the energy absorber.</p> <p class=IEEEParagraph>A physical experimental programme was carried out in the Plymouth University COAST Ocean Basin in order to test the effects on performance and survivability of two mooring configurations: a pure chain catenary and a hybrid chain, rope, float and sinker system, comparing the effect on performance and survivability.</p><p class=IEEEParagraph>Results showed a performance differnece in regular conditions as well as an effect on the line tensions during storm conditions.</p><p class=IEEEParagraph> </p><p class=IEEEParagraph> </p><p class=IEEEParagraph> </p>","authors":"B. Howey, K. Collins, P. Vicente, R. Gomes, V. Harnois, M. Hann, G. Iglesias, D. Greaves","topic":"12","file":"MRGFND-02-921.pdf","bib":"MRGFND-02-921.bib"},
{"paperid":"923","title":"Tidal Energy Scenario Analysis: Holistic Stakeholder Considerations for Sustainable Development","keywords":"This research spans socio-technical disciplines to better understand holistic perspectives of tidal energy development. Future tidal turbine arrays must be cost-effective and reliable, but also guided by environmental and societal priorities. Incorporating holistic considerations may increase the likelihood for tidal energy projects to be accepted and ensure that they are sustainable. Future design scenarios were explored and used to conduct interviews with a variety of tidal energy stakeholders. The focus was on perceptions of risks and benefits, particularly societal concerns about new uses of ocean spaces. This research is motivated by a recently proposed tidal energy project in Puget Sound, WA. A grounded theory research study was conducted and analyzed to understand various stakeholder perspectives of tidal energy scenarios across holistic considerations. This research is contributing to this knowledge for tidal energy’s sustainable development.","authors":"K. McTiernan, A. Copping","topic":"10","file":"ECONOM-PP-923.pdf","bib":"ECONOM-PP-923.bib"},
{"paperid":"926","title":"Slipstream Dynamics of a Tidal Turbine","keywords":"<p><!-- p { margin-bottom: 0.1in; line-height: 120%; } --><span style=font-size: small;>The turbulent wake behind a tidal current turbine is investigated in order to understand the coherent flow structures released by the blades and the mechanisms of the kinetic energy recovery behind the turbine. For this purpose, a 500-mm diameter model of a 5-blade horizontal axis tidal turbine was tested in the CNR-INSEAN circulating water channel. Two different studies were performed: 1)  performance analysis of the turbine; 2) PIV (Particle Image Velocimetry) analysis of the downstream near wake.</span><span style=font-size: small;> </span></p><p><span style=font-size: small;>The performance tests were carried out for different Reynolds numbers and tip speed ratios (TSR). Five operative conditions were identified for the PIV study of the velocity field in the near wake of the turbine: maximum C<sub>P</sub>, maximum C<sub>T</sub>, incipient stall and 2 unloaded conditions at higher TSRs. The PIV measurements were done at several rotor angular positions, bringing phase-locked and detailed insight into the important fluid dynamics aspects of the turbine operation, in relation with the design of the rotor and with the different operating conditions. This analysis allows to understand the mechanisms that govern the energy transport and the wake re-energizing.</span></p><p><span style=font-size: small;><br /></span></p>","authors":"J. Allo, C. Del Frate, D. Dhomé, F. Di Felice, F. Alves Pereira","topic":"4","file":"TIDDEV-05-926.pdf","bib":"TIDDEV-05-926.bib"},
{"paperid":"927","title":"Numerical Simulations and Experiments of Wake Interactions in Axial-Flow Turbines","keywords":"<div class=page title=Page 1><div class=layoutArea><div class=column><p><span>Impacts produced by changes in the flow field induced by marine hydrokinetic (MHK) devices and the interactions of the turbulent wakes can span a wide range of temporal and spatial scales, and include interactions with bathymetry, and with local ambient turbulence. </span>We investigate physical aspects of wake interactions through laboratory experiments using Acoustic Doppler Velocimeters (ADV) and numerical methods that capture both: (a) The temporal and spatial averaged effects, such as velocity deficits and turbulent kinetic energy at high Reynolds numbers; and (b) The influence and changes produced by the MHK devices in the channel. As part of our research, we develop and implement models that can incorporate turbines with different degrees of detail, from models that resolve the coherent structures of the wake, which can also account for the ambient turbulence, to large-scale models that can represent the flow for several tidal cycles.  The work will be carried out in conjunction with future field measurements in specific sites in southern Chile.</p></div></div></div>","authors":"C. Escauriaza, D. Gajardo, D. Ravazzolo, K. Soto, D. Ingram","topic":"6","file":"TIDHYD-05-927.pdf","bib":"TIDHYD-05-927.bib"},
{"paperid":"929","title":"Experimental Investigation of Array Effects for a Mechanically Coupled WEC Array","keywords":"<p>Array effects of a mechanically coupled WEC was investigated by completion of two sets of tank tests at the FloWave facility. The first set of tests were completed on a 1/18 scale model of a new concept for an Albatern Squid WEC, which is made up of four conical buoyancy modules mechanically connected via three link arms.  The second set of tests focused on the investigation of a WaveNET array, built up in a modular fashion from individual Squid devices such that an understanding of the array effects and in particular the effect of combined mechanical and hydrodynamic coupling on a multi-degree-of-freedom WEC array could be obtained.</p> <p>Here we show that the combination of mechanical and hydrodynamic coupling reduces the normalised standard deviation of the power output and the loads experienced per node for the array compared with the individual device.  While the interaction factor is not significantly altered from what would be expected for a mechanically uncoupled array.</p> <p>The study highlights the effects of mechanically coupling devices within an array on device performance and the potential benefits in terms of power smoothing and cost reduction.</p>","authors":"A. McDonald, Q. Xiao, D. Forehand, D. Findlay","topic":"3","file":"WAVDEV-06-929.pdf","bib":"WAVDEV-06-929.bib"},
{"paperid":"931","title":"Tidal turbine collision assessment using the bulk and shear modulus of marine mammals' soft tissue","keywords":"Installing tidal energy devices poses a possible risk to marine mammals, which can introduce a barrier to permitting and installing devices worldwide. Marine mammals are often present in tidal channels, using them for feeding and traveling. One such risk is collision with the moving parts of these devices. To further understand that risk, we modeled the marine mammals' soft tissue and geometry, combined with calculating the forces delivered by the energy producing devices. In addition to using existing uniaxial tension testing data, we conducted additional material testing of the shear modulus and bulk modulus of the skin and blubber. The new tissue testing allows for more robust modeling of the animal's soft tissue. Ultimately, this work will aid in our ability to permit devices based on the potential risk posed to marine animals or choose specific turbine designs based on indigenous species.","authors":"M. Grear, M. Motley","topic":"9","file":"ENVIRO-03-931.pdf","bib":"ENVIRO-03-931.bib"},
{"paperid":"933","title":"Optimisation of Elementary Arrays of Wave-Power Devices in Irregular Waves","keywords":"<p class=IEEEParagraph>This paper describes the optimisation of arrays of wave energy converters (WECs) of point absorber type.  The WECs are spherical in shape and operate in heave only.  Previous research is extended to an irregular wave regime.  To simplify the analysis, the WECs are constrained to lie in a straight line and are optimised from a hydrodynamic perspective with respect to the spacing between the devices.  The aim is to find array geometries that give constructive interaction over the majority of the wave spectrum considered, which is assumed to be JONSWAP type, with narrow and broad band spectra examined.  The objective function of the optimisation is taken to be the frequency integral of the product of the power spectrum and the hydrodynamic power absorbed by the array, with an appropriate scaling applied.  By optimising over the entire range of a given spectrum, it is hoped that arrangements can be obtained which exhibit stable and good performance for the majority of this range.  Non-optimal WEC motions are considered and appropriate constraints are applied to the motion amplitudes.  Optimal layouts are identified and the results are discussed.  A comparison is drawn between the optimal layouts and WEC displacements for each spectrum type considered.</p>","authors":"J. McGuinness, G. Thomas","topic":"5","file":"WAVHYD-07-933.pdf","bib":"WAVHYD-07-933.bib"},
{"paperid":"935","title":"Applying a simple model for estimating likelihood of collision of marine mammals with tidal turbines","keywords":"<p class=IEEEParagraph>This paper will explore the application of a simple collision risk model for marine mammals interacting with tidal turbines at three potential tidal sites in the US, the UK, and Canada to provide a first order estimate of the risk of serious injury or death to the animals. The model was developed to examine the potential probability and consequences of a harbor seal collision with a two-bladed tidal turbine.  This paper will examine two different turbine types at each location, with species of indigenous marine mammal at each site. This approach allows us to explore collision risk based on the unique characteristics of that channel, as well as tidal energy device designs that may be suited to that location.</p>","authors":"A. Copping, M. Grear","topic":"9","file":"ENVIRO-03-935.pdf","bib":"ENVIRO-03-935.bib"},
{"paperid":"936","title":"Mitigating Uncertainty in Tidal Turbine Performance Characteristics from Experimental Testing","keywords":"<p class=IEEEReferenceItem>To promote confidence and reduce the uncertainty associated with the power performance of Tidal Energy Converters (TECs) the International Electrotechnical Commission (IEC) published a technical specification. The specification provides the methodology for determining velocity at a site and rated power output from a device, in order to determine the power curves. Using this methodology the performance of a 1.5m diameter horizontal axis tidal turbine from Queens University Belfast has been experimentally tested in Strangford Lough, Northern Ireland. The performance characteristics of the device was assessed using the rotor and flow measurement instrumentation in accordance with IEC/TS 62600-200. Experimental Set-up schematic and example results are included.</p>","authors":"C. Frost","topic":"4","file":"TIDDEV-06-936.pdf","bib":"TIDDEV-06-936.bib"},
{"paperid":"937","title":"A CFD study on the balance of energy in a fixed bottom-detached Oscillating Water Column Wave Energy Converter","keywords":"<p class=IEEEParagraph><span lang=EN-GB>Energy losses inside the OWC greatly penalises the hydrodynamic performance of the device, however, only few researchers focused on quantifying such losses. For this purpose, fully non-linear numerical models, e.g. Computational Fluid Dynamics (CFD) models, validated and calibrated versus physical tests, are essential tools since they allow the observation of physical phenomena with the needed accuracy in the time domain and in the space domain.</span></p> <p class=IEEEParagraph><span lang=EN-GB>In this work, a CFD model of a fixed, bottom-detached OWC device is simulated in order to study the energy balance for the device. The CFD model is implemented in the open source OpenFOAM® environment. The CFD model is validated against laboratory tests and once validated, it is used to investigate the hydrodynamic performance of the OWC by applying the wave energy balance for the device. Considering the energy balance, it is possible to clearly define the total energy losses taking place in the OWC as a consequence of, e.g., wave breaking, viscous, turbulence and vortex losses at the front wall lip.</span></p> <p class=IEEEParagraph><span lang=EN-GB>The energy losses corresponding to different design parameters are comparatively analysed, giving an insight on the physics involved in the losses phenomenon and on the design conditions leading to the highest hydrodynamic efficiency. </span></p>","authors":"I. Simonetti, L. Cappietti","topic":"3","file":"WAVDEV-06-937.pdf","bib":"WAVDEV-06-937.bib"},
{"paperid":"938","title":"Integration of a hydrodynamic negative spring concept into the OWC spar buoy","keywords":"<p>This work has been focused on an innovative concept of increasing the energy extracted from ocean waves, using point absorber type Wave Energy Converters (WECs). This concept involves the reduction of a WEC’s natural frequency, such that its excitation response better matches the resource spectra of typical wave climates. The operating principle of the investigated phase control strategy has been presented for point absorbers in general, without bias towards any particular device. To explore its potential integration with an existing technology, numerical hydrodynamic modelling of the OWC spar buoy has been performed in the frequency-domain and time-domain. Simulation results showed that its application to a previously unoptimized converter could lead to a significant increased energy yield. The implication of this work’s outcomes is that a smaller converter could be made to behave like a larger converter, resulting in reduced capital costs. In the near future, this work will serve as a comparison for the device’s experimental wave tank results which are also going to be documented in this article.</p>","authors":"M. Gradowski, M. Alves, R. Gomes, J. Henriques","topic":"5","file":"WAVHYD-07-938.pdf","bib":"WAVHYD-07-938.bib"},
{"paperid":"942","title":"How harmful is the wave energy penetration in an electric grid?","keywords":"<span style=font-size: x-small;><span style=font-size: 10pt;>The aim of this paper is to  analyse the influence in electric grids of the power injected by a wave  energy converters (WEC) generation plant comprising several point  absorbers. <br /> The methodology will start with the development of an analytical model  to generate the time power profile obtained from different sea states,  obtained from measure buoys data. Additionally, a parametric electric  grid model will be developed in order to generate the grid frequency variations. The grid used to accomplish this study is  a weak grid comprising other renewable power sources such as wind  energy farms. The definition of a certain amount of generation power  obtained from a wave farm will determine whether it produces frequency and voltage problems or not. A second analysis  will be carried out taking into account the impact in the grid when  varying the operation parameters, location of the WECs, etc. Most of the  problems in the grid will be due to the effects of the power oscillations produced by the wave farm. They will be  studied by means of: definition of the location of the WECs within the  wave farm, control strategy variations or energy storage introduction.</span></span>","authors":"M. Blanco","topic":"7","file":"GRDPTO-06-942.pdf","bib":"GRDPTO-06-942.bib"},
{"paperid":"943","title":"From real scale demonstration to tidal turbine pilot power plant in the Fromveur strait","keywords":"<p>After one year of testing, D10 has delivered lots of results in order to help SABELLA improves its marine current turbine technology and develop its insular energy model. Results are mainly from mechanical and e</p><p>Main learnings from this first of a kind grid connected ocean energy project in France are useful for the next upcoming campaign in 2017 and, more importantly, for the pilot farm and other projects abroad.</p>","authors":"J. ALLO, D. DHOME","topic":"4","file":"TIDDEV-06-943.pdf","bib":"TIDDEV-06-943.bib"},
{"paperid":"944","title":"Horizon scanning for commercial wave energy technology","keywords":"<!-- p { margin-bottom: 0.25cm; direction: ltr; color: rgb(0, 0, 0); line-height: 120%; }p.western { font-family: Times New Roman,serif; font-size: 12pt; }p.cjk { font-family: SimSun,宋体; font-size: 12pt; }p.ctl { font-family: Times New Roman,serif; font-size: 12pt; }a:link {  } --><span style=font-size: x-small;>This paper will introduce the Simply Blue Energy horizon scanning project and present generalised results. The project, undertaken in conjunction with the Sustainable Energy Authority of Ireland (SEAI) and  Wave Venture Ltd, focuses on identifying and reviewing current and new wave energy technologies. The goal of the project is to determine which wave energy technologies and companies are on a path to commercial readiness and how close each is to achieving market entry. A further focus is the identification of the most promising technologies and on areas where increased anticipation of market needs will accelerate and smoothen the commercialisation process. The paper presents anonomised results of the assessment process and highlights common threads, strengths and weaknesses in the expectation that these insights will be beneficial to the wider wave energy community.<br /></span>","authors":"R. Costello, B. Kennedy, H. Kelly, S. Roch Perks","topic":"3","file":"WAVDEV-06-944.pdf","bib":"WAVDEV-06-944.bib"},
{"paperid":"945","title":"Good practices for environmental impacts assessment and social acceptance of tidal projects","keywords":"Sabella D10 marine current turbine was immersed in the Fromveur Strait in June 2015 and connected to Ushant island grid, becoming the first grid-connected full scale tidal turbine in France. The installation area is a highly environmentally protected zone, with many human activities. Strong effort thus had to be brought to the environmental innocuousness of the device and to the social acceptance, especially among the inhabitants of the island. For this, all potential stakeholders were involved at a very early stage of the project and a strong concertation process was organised. This led to a very strong acceptance and even support from the islanders. A lot of work was also carried out in partnership with the Marine Nature Park of Iroise Sea in order to assess and minimize the environmental impacts of the turbine. A lot of environmental sensors were installed on the turbine and first results of the initial campaign are available. This environmental monitoring will be continued when the turbine will be reimmersed in Spring 2017.","authors":"D. Dhomé, J. Allo","topic":"9","file":"ENVIRO-PP-945.pdf","bib":"ENVIRO-PP-945.bib"},
{"paperid":"946","title":"Assessment of a Spar buoy oscillating-water-column wave energy converter including a fully dynamic model","keywords":"<p class=IEEEParagraph>The present work aims to present a new wave-to-wire model of a spar-buoy OWC that includes a detailed cost analysis. The major contributions of the paper for the state-of-the art of the OWC technology are:</p> <ul><li>A new detailed wave-to-wire model based on a 6 degrees-of-freedom time-domain simulation of the spar-buoy OWC including a non-linear model of the self-rectifying biradial turbine and the mooring lines.</li><li>A complete assessment of the spar-buoy performance for a wave climate off the west coast of Portugal. </li><li>An exhaustive estimation of the power production and life-cycle plant costs from construction to O&amp;M </li></ul> <p class=IEEEParagraph>The spar-buoy OWC geometry selected to be used in the current work is the result of an optimization procedure [2]. Wave energy convertor electrical power output is based in a non-linear dynamic PTO model coupled to a six degrees of freedom diffraction-radiation hydrodynamic model including a 3D dynamic mooring layout. The hydrodynamic model has been adjusted based on an extensive 1:16 tank testing developed in NAREC. Turbine and generator models have been adjusted from 1:3 and 1:1. laboratory testing and include optimized feedback control [3,4]. Plant costs are based in a detailed parametric model including hundredths of cost factors.</p>","authors":"I. Zabala, J. Henriques, A. Falcão, A. Amezaga, R. Gomes, L. Gato","topic":"5","file":"WAVHYD-07-946.pdf","bib":"WAVHYD-07-946.bib"},
{"paperid":"947","title":"A Method of Approximating Surface Elevation form a Shore Mounted X-band Radar","keywords":"<p class=IEEEParagraph><span lang=EN-AU>The work presented in this paper looks at the application of a new real-time method to approximate surface elevation from X-band radar backscatter. The development of this method allows the spatial measurement of surface elevation over a 3km radius at a 3m resolution. When the scaled radar backscatter is directly used to measure surface elevation, a crude representation is achieved. The approach outline in this study replaces radar shadow regions with second order Stokes waves to create an artificial wave trough. This allows the estimation of the surface that can retain peak features whist having realistic phase and magnitudes of wave troughs.</span></p> <p class=IEEEParagraph><span lang=EN-AU> This was applied to dataset collected over two days using multiple wave sensors for calibration and validation. The radar and sensor data are compared using a Pierson correlation and a normalised RMS error. The results reveal that the application of the artificial wave troughs causes an increase in the correlation in both phase and magnitude. When the wave spectra were compared, the addition of artificial wave troughs provides a much better description of the distribution of energy in the frequency domain. This results in an increase in accuracy of the spectral wave parameters Hm0 and Tp.</span></p>","authors":"C. Greenwood","topic":"1","file":"WAVRES-PP-947.pdf","bib":"WAVRES-PP-947.bib"},
{"paperid":"948","title":"Application of a simulation model for a heave type wave energy converter","keywords":"<p class=IEEEParagraph><span lang=EN-AU>The  goal  of  this  study  is  to  estimate  the  best  set or combination of PTO stiffness and damping, of a wave energy converter (WEC) to increase its performance. The WEC is a heave buoy developed by Aquaharmonics. To find the best set, it is essential to study how different combinations of stiffness and damping could affect the response. First, the range of the PTO stiffness and damping which could make resonance in the system are approximated by a simplified model. The concept of this model is that the natural period is equal or a fraction of the incoming waves. Then, the more complex numerical model was developed and validated with the experimental results performed in the large wave flume at the Hinsdale Wave Research Laboratory, Oregon State University. This model is used to simulate free oscillation for the primary combinations of PTO stiffness and damping. From the results, it is checked if the selected combination can make the required period of oscillation. Finally, the numerical model is used to simulate the WEC behaviour to regular wave excitation with the selected combinations. These analyses are used to control, if the selected sets can increase the heave motion of the device.</span></p>","authors":"S. SAEIDTEHRANI, P. Lomonaco, A. Hagmuller, M. Levites-Ginsburg","topic":"3","file":"WAVDEV-06-948.pdf","bib":"WAVDEV-06-948.bib"},
{"paperid":"950","title":"Manufacturing Thick-Section Tidal Turbine Blades using Low-Cost Fibre Reinforced Polymers","keywords":"The submitted abstract focuses on the development of numerical processing models for a low-cost composite material. This is specifically aimed at the production of tidal turbine blades with this material, as well as thick-section components of large wind turbine blades. Due to the scale of modern tidal energy convertors (TECs), cost-effective processing of thick sections, such as the root section of a tidal turbine, creates many challenges for manufacturers. Without effective process simulation, manufacturers are reduced to trial and experiments to adapt their material technology for TEC developers, which can be costly and time-consuming. By developing a coupled resin flow and heat transfer model for the low-cost composite material, it will be possible to minimise the initial capital investment required for designing a suitable heated mould, and will reduce processing times while maintaining, or improving, the quality of the finished part. The models will be experimentally validated and aimed towards implentation in commercial manufacturing software so that they can be used to realistic 3D blade geometries.","authors":"J. Maguire, A. Doyle, C. Ó Brádaigh","topic":"8","file":"STRMAT-02-950.pdf","bib":"STRMAT-02-950.bib"},
{"paperid":"952","title":"Effective offshore operations in strong marine currents areas","keywords":"<p>The Sabella D10 tidal turbine was immersed in the Fromveur Strait in June 2015 and thus became the first grid-connected industrial scale marine current turbine in France. The initial authorizations were carried out using a standard heavy lift vessel, kept in position by two anchors and three tugs, which appeared not adequate. The turbine was then retrieved in July 2016, at the end of the initial authorizations period. This second operation was carried out with MOJO MARITME, using a DP vessel, which proved to be much more reliable, safer and effective. Specific tools were also developed for this operation. An offshore berth had to be designed in order to guide, support and transport the turbine on deck to shore. A “LARS” (Launch And Recovery System) was also designed and built in order to lift the turbine out of its foundation. The challenge in this design was to develop this hydraulically activated tool while the turbine was already immersed. These return on experience and innovative methods and tools bring cost reduction perspectives thanks to the use of smaller vessels, with lower lifting capacities.</p>","authors":"D. Dhomé, J. Allo, A. Blangy, M. Morandeau, R. Argall, R. Parkinson","topic":"11","file":"OPANDM-01-952.pdf","bib":"OPANDM-01-952.bib"},
{"paperid":"953","title":"Hydrodynamics and Scaling of Heave Plates for Point Absorbing Wave Energy Converters","keywords":"<p>Point absorbing wave energy converters require a mechanism for reaction forces, either in the form of a connection to the seabed or a heave plate with high inertia. Asymmetric heave plates may be beneficial when the coupling to the surface float is compliant, but these designs have not been well-studied. This work experimentally investigated the hydrodynamic properties of asymmetric heave plates across three scales using bulk (i.e., period-averaged) and instantaneous (i.e., phase-averaged) representations of the coefficients of drag and added mass. Bulk values scale with the well-established Keulegan-Carpenter number, while instantaneous values provide insight into intra-cycle hydrodynamic variations. The results of this investigation should increase confidence in scaling the hydrodynamic performance of novel heave plate designs to larger scales.</p>","authors":"C. Rusch, B. Maurer, T. Mundon, A. Stewart, B. Polagye","topic":"3","file":"WAVDEV-07-953.pdf","bib":"WAVDEV-07-953.bib"},
{"paperid":"954","title":"Performance of the Self-rectifying Biradial Air Turbine with Fixed Guide Vanes Arranged into Concentric Annular Rows","keywords":"<p class=IEEEParagraph><span lang=EN-GB>The biradial turbine is an impulse turbine proposed for OWC applications, in two versions: (i) with axially-sliding guide vanes and (ii) with fixed guide vanes. Version (ii) is mechanically simpler, but does not prevent the losses that occur at the outlet guide vane row. To reduce these losses, the guide vanes are radially offset from the rotor. This allows the flow from the rotor to be decelerated in the radial diffusor prior to entering the guide vane row. An additional feature consists in replacing the single guide vane row located on each side of the rotor by two concentric rows of guide vanes, with allows a wider circumferential spacing for the exit flow (and hence less pressure losses) while appropriately deflecting the flow admitted to the rotor. The paper concerns the fixed guide vane version (ii), with the concentric blade-row topology. Numerical results from CFD simulations are presented and compared with results from model testing, with rotor diameter equal to 488 mm. The tests were performed in unidirectional flow. Measured quantities were flow rate, pressure head, rotational speed and torque. Detailed measurements of the velocity and pressure fields in the flow through the turbine were also performed.</span></p>","authors":"A. Carrelhas, A. Maduro, L. Gato, J. Henriques, A. Falcao","topic":"7","file":"GRDPTO-06-954.pdf","bib":"GRDPTO-06-954.bib"},
{"paperid":"956","title":"Identification and Validation of Excitation Force for a Heaving Point Absorber Wave Energy Converter","keywords":"<p class=IEEEParagraph>Current hydrodynamic modelling approaches of Wave Energy Converters (WECs) assume that the wave excitation force is a known input to drive the WECs. However, the excitation force cannot be measured directly. This study aims to identify a Wave-elevation-To-excitation-Force (W2F) model from its frequency-domain response and to verify the identified model via tank tests.</p><p>A 1/50 scale cylindrical Point Absorber Wave Energy Converter (PAWEC) has been designed, constructed, and tested, as shown in Fig. 1. For simplicity, only heave motion is discussed in this study. A Boundary Element Method (BEM) code, NEMOH [1], is adopted to compute the wave-buoy interaction. Based on the NEMOH results, system identification methods [2, 3] are applied to deduce a W2F model to estimate the excitation force with short-term wave prediction.</p><p>Tank tests are conducted and the experimental data show high accordance to the simulation results of NEMOH and the identified W2F model, both in the frequency-domain (see Fig. 2) and time-domain (see Fig. 3). Therefore, this identified W2F model can be integrated to existing WEC models to form wave-to-wire models, which is straightforward and convenient for wave-by-wave power optimization control of WECs.</p>","authors":"B. Guo, R. Patton, S. Jin","topic":"5","file":"WAVHYD-08-956.pdf","bib":"WAVHYD-08-956.bib"},
{"paperid":"957","title":"Geometry Influences on Hydrodynamic Reponses of a Heaving Point Absorber Wave Energy Converter","keywords":"<p>This paper investigates the impacts of geometry on the hydrodynamics of the designed 1/50 scaled Point Absorber Wave Energy Converter (PAWEC) and proposes an improved shape to improve conversion efficiency via numerical simulations in ANSYS/LS-DYNA. Three types of PAWECs are studied：cylinder, cylinder with sphere and cylinder with 45° cone and fillet. A symmetrical numerical model is built to improve the computational efficiency. In free-decay tests, similar resonance periods are kept for all three of PAWECs to compare different damping properties mainly caused by viscosity. The normalised displacement results show that the device with cone head and smoothing edge geometry reduces the viscosity significantly, resulting in less energy lost during oscillation. In addition, under free motion tests, the cylinder-cone45°-fillet device reveals the superiority in hydrodynamic response with response amplitude operator (RAO) around 4, about 1.37 and 1.7 times as much as the RAO of cylinder-sphere and cylinder types, respectively. This study illustrates that changing the geometry of the PAWEC to lower the viscosity influence is an efficient way to improve conversion efficiency.</p><p> </p>","authors":"S. Jin, R. Patton","topic":"3","file":"WAVDEV-07-957.pdf","bib":"WAVDEV-07-957.bib"},
{"paperid":"958","title":"Numerical and experimental studies of an offshore multi – purpose floating structure supporting a wind turbine","keywords":"<p class=IEEEParagraph><span lang=EN-AU>This paper summarizes the coupled hydro - aero - elastic analysis behind the modelling of a multi - purpose floating structure suitable for offshore wind and wave energy sources exploitation. The floating structure is supporting a 5 MW Wind Turbine and encompasses an array of hydrodynamically interacting Oscillating Water Column devices. Theoretical analysis for such types of floating supporting structures which more realistically allow the renewable electricity generation from the combined wind and wave action have been reported in the literature.</span></p> <p class=IEEEParagraph><span lang=EN-AU> </span></p> <p class=IEEEParagraph><span lang=EN-AU>Based on the theoretical studies on multiple body floating systems reported in recent years the numerical implementation involves the hydrodynamic modelling of the floater through an analytical method that accounts for the hydrodynamic interactions among adjacent floating OWC’s and the mooring modelling, the aerodynamic modelling of the rotor and the elastic modelling of the turbine components, namely the blades, the drive train and the tower. </span></p> <p class=IEEEParagraph><span lang=EN-AU> </span></p> <p class=IEEEParagraph><span lang=EN-AU>The numerical results are supplemented by corresponding experimental ones that have been obtained in an experimental campaign carried out in the wave tank of the Laboratory of Ship and Marine Hydrodynamics at National Technical University of Athens in the framework of the operational program ‘Education and Lifelong Learning’ of the National Strategic Reference Framework (NSRF) 2007 - 2013: Research Funding Program: ARISTEIA, Program POSEIDON (2041). A good agreement between numerical and experimental results has been obtained. </span></p>","authors":"T. Mazarakos, D. Konispoliatis, G. Katsaounis, S. Polyzos, D. Manolas, S. Voutsinas, S. Mavrakos","topic":"3","file":"WAVDEV-07-958.pdf","bib":"WAVDEV-07-958.bib"},
{"paperid":"959","title":"Performance analysis of the CCell wave energy device","keywords":"<p class=IEEEHeading1>CCell is a novel oscillating wave surge converter (OWSC) featuring a curved paddle as the prime mover, which differs from previous flat, flap-type devices. The curvature aims to improve hydrodynamic performance as well asprovide additional strength to the structure. This could improve the economics of wave energy converters by reducing material costs and maximising the energy extraction.</p><p>To investigate the impact of paddle curvature on the capture width of the device, both numerical and physical modelling was undertaken.This paper discusses the set-up of this model and how it was used to dynamically simulate the paddle using the CFD package OpenFOAM.</p><p>Key results and analysis from a series of numerical and laboratory studies undertaken during 2016 on the full multi-body CCell device are presented, which support a step-change improvement in the performance and reliability of WEC technology.</p><p> </p>","authors":"C. Worden Hodge, W. Bateman, Z. Yuan, P. Thies, T. Bruce","topic":"3","file":"WAVDEV-07-959.pdf","bib":"WAVDEV-07-959.bib"},
{"paperid":"960","title":"Full scale turbine test in real turbulent flow in a tidal estuary","keywords":"<p>A vertical axis tidal turbine of the Dutch company “Water2Energy” was tested during several weeks in real sea conditions in a tidal estuary - the Sea Scheldt, Belgium. The experiment was designed to assess the turbine performance and to study a dynamically rich interaction of a fully developed turbulent flow with the turbine. The three components of tidal current velocity were continuously measured upstream the turbine by a downward-looking acoustic Doppler current profiler (ADCP), operating at 1 Hz, and by an Acoustic Doppler Velocimeter (ADV), operating at 16 and 32 Hz. The measurements covered different tidal current regimes, strong ebb and flood flow with velocity above 1.5 m/s. The intermittency was studied using traditional scaling approach. The results show that in the inertial frequency band fluctuations of the instantaneous power generated by the turbine are modulated by the turbulent structure of the approach flow. The performance coefficient was found to vary in a wide range from 0.3 to 0.42.</p>","authors":"A. Sentchev","topic":"4","file":"TIDDEV-06-960.pdf","bib":"TIDDEV-06-960.bib"},
{"paperid":"961","title":"A Critical Comparison of AR and ARMA Models for Short-term Wave Forecasting","keywords":"<p>In the paper a critical comparison between two prediction models used to predict the free surface elevation is going to be explained. The two models are the Autoregressive model (AR) and the Autoregressive Moving Average model (ARMA). A previous comparison has been made where, using a single sea state, ARMA has been declared better than AR in all the analyzed cases. However, having analyzed different sea states (with different power spectrums), the first results demonstrated that AR is better in some scenarios. These scenarios are mainly low frequency waves seas, which are more powerful than mainly high frequency waves seas. Thus, in the paper we will show in which scenarios AR is better and in which one is ARMA.</p>","authors":"Y. Pena Sanchez, J. Ringwood","topic":"7","file":"GRDPTO-06-961.pdf","bib":"GRDPTO-06-961.bib"},
{"paperid":"963","title":"Hydrodynamic Loads on a Tidal Turbine in Random Seas","keywords":"<div class=page title=Page 1><div class=layoutArea><div class=column><p>The dynamic response characteristics of a 3-bladed, horizontal axis tidal turbine in random seas have been studied by time domain simulations. The numerical model was based on the modified unsteady BEM theory. A series of environmental conditions with aligned irregular waves and uniform current was defined to investigate loads and responses of a tidal turbine, including the generator power production, the thrust and torque on the shaft, the edgewise and flapwise blade bending moments. The load response amplitude operators (RAOs) were obtained and proved to be sensitive to the incident wave frequency and submergence. The dynamic responses were clearly dominant by wave-frequency. Response spectra of the flapwise and edgewise blade bending moments, both low- and high-frequency responses were excited by the incident waves. The mean value of power production in irregular waves was the same for the case with the corresponding constant inflow conditions. Sensitivity studies have been carried out in different wave conditions with varying significant wave heights and peak periods. The present results may contribute to the general understanding of the wave induced loads on tidal turbines in random seas.</p><p> </p></div></div></div>","authors":"X. Guo, Z. Gao, J. Yang, T. Moan","topic":"4","file":"TIDDEV-06-963.pdf","bib":"TIDDEV-06-963.bib"},
{"paperid":"964","title":"Dynamic load measurements on a scale-model axial-flow MHK turbine","keywords":"A laboratory scale, three-bladed axial-flow turbine (<em>d<sub>T</sub></em> = 0.45 m) instrumented with six-axis force/torque sensors on the main shaft and on one blade root was used to investigate instantaneous loading while operating over a range of tip-speed ratios (<em>λ </em>= 3 to 9), Reynolds numbers (<em>Re<sub>c</sub></em><sub> </sub>= 6<em>x</em>10<sup>4 </sup>– 2<em>x</em>10<sup>5</sup>), blockage ratios (<em>β</em> = 11-33%), and inflow turbulence intensities (<em>I<sub>u</sub></em> = 2-20%) in an open channel flume. Phase-averaged data and correlations between rotor loads, blade loads, and inflow conditions provide further insight into unsteady dynamic load sensing during an individual blade’s rotation. Results are used to inform passive and active blade pitch control strategies aimed at reducing structural loading, improving device resiliency, and increasing turbine efficiency.","authors":"C. Hill, K. Van Ness, A. Stewart, B. Polagye, A. Aliseda","topic":"8","file":"STRMAT-02-964.pdf","bib":"STRMAT-02-964.bib"},
{"paperid":"965","title":"Composite Design of a Curved OSWEC","keywords":"<p>This abstract summarises a paper that will be produced detailing the composite design of Zyba's CCell wave energy device. Composites have extensive use in the marine energy industry although applications within the wave energy industry remain limited. The paper will explore the composite design and manufacturing methods of both 1:15 scale laboratory paddles, and 1:3 scale devices to be deployed in a preliminary sea trial. Using numerical and experimental results, a light weight design and optimised manufacturing methodology has been developed for the CCell device. It is believed that composites can offer cost reductions compared to conventional materials and support the successful production of a small scale wave energy device.</p>","authors":"W. Jamieson, W. Bateman, E. Oterkus, P. Thies, A. Robinson","topic":"8","file":"STRMAT-02-965.pdf","bib":"STRMAT-02-965.bib"},
{"paperid":"966","title":"Performance of the BOLT Lifesaver Wave Energy Converter at Kaneohe Bay, Hawaii","keywords":"Fred. Olsen built the Wave Energy Converter (WEC) system BOLT Lifesaver in UK during 2011-2012. The WEC was launched in April 2012 at the FabTest WEC site outside Falmouth Bay, England. After two years of operation, and several rounds of system improvements, the system was moved to the “WETS” site outside Kaneohe bay, Hawaii in 2016. This is a significantly more energetic site which poses great challenges for prolonged operation of a WEC system. Nevertheless, with the exception of one incident during the summer of 2016, the system has maintained continuous operation, and has of today produced power continuously since 20. July 2016.  Although the device has a rated capacity of 30 kW in its current configuration, the system has been operated with conservative settings that have kept the power output between 0.4 and 15 kW. The system has low self-consumption, and has been able to supply continuous power surplus for the entire period. This paper presents detailed performance data of the BOLT Lifesaver system at WETS including power output per wave state, system up-time, required maintenance and general performance.","authors":"J. Sjolte","topic":"3","file":"WAVDEV-08-966.pdf","bib":"WAVDEV-08-966.bib"},
{"paperid":"967","title":"Experimental testing of Dielectric Elastomer Generators for Wave Energy Converters","keywords":"<p>This paper presents results from experimental test campaigns on a new class of Wave Energy Converters (WECs) based on Dielectric Elastomer Generators (DEGs).</p><p class=IEEEParagraph>DEGs are high-voltage electrostatic generators based on lightweight low-cost compliant polymeric materials. Recently, it has been suggested that DEGs can be used to build Power Take-Off (PTO) systems for WECs.</p><p class=IEEEParagraph>With reference to a particular class of DEGs (namely, circular diaphragm inflating DEGs), this paper presents a survey of experimental results accomplished within the last three years.</p><p class=IEEEParagraph>Two classes of tests are described: dry-run laboratory tests on DEG samples, and wave tank tests on scaled Oscillating Water Column (OWC) prototypes housing functional DEG PTO.</p><p class=IEEEParagraph>Dry-run tests have been carried out with the aim of characterizing and optimizing the technology before in-field tests. Wave-tank tests have demonstrated the effectiveness of DEGs and their capability to provide positive electricity generation from waves,</p>","authors":"G. Moretti","topic":"3","file":"WAVDEV-08-967.pdf","bib":"WAVDEV-08-967.bib"},
{"paperid":"971","title":"CFD Modelling coupled with Floating Structures and Mooring Dynamics for Offshore Renewable Energy Devices using the Proteus Simulation Toolkit","keywords":"<p class=IEEEParagraph><span lang=EN-AU>With many countries showing a growing interest in offshore renewables, the development of floating support structures able to withstand extreme environmental loads is key to winning the race in offshore renewable energy deployment.</span></p> <p class=IEEEParagraph><span lang=EN-AU>Numerical modelling of these structures allows relatively inexpensive testing and selection of suitable designs. The research presented here focuses on the numerical analysis of the behaviour of different floating structure designs and the associated mooring dynamics under various wave conditions. Simulations are performed with Proteus, a relatively new and open-source computational fluid dynamics (CFD) software actively developed by the ERDC and HR Wallingford using the Finite Element Method (FEM) to model two phase flows. </span></p> <p class=IEEEParagraph><span lang=EN-AU>In order to allow the simulation of moving bodies in Proteus, a moving mesh module has been developed, where the mesh motion is taken into account directly in the Navier-Stokes equation that are solved in the Eulerian frame. Floating body and mooring dynamics are solved with the open source C++ library Project Chrono, allowing a fully coupled simulation of rigid and flexible bodies and FEM cable dynamics with collision detection.</span></p> <p class=IEEEParagraph><span lang=EN-AU>Validation cases are presented as building blocks towards more representational scenarios in the context of floating support structures for offshore renewable energy devices.</span></p>","authors":"T. de Lataillade, A. Dimakopoulos, C. Kees, L. Johanning, D. Ingram, T. Tezdogan","topic":"5","file":"WAVHYD-08-971.pdf","bib":"WAVHYD-08-971.bib"},
{"paperid":"972","title":"A Search Group Algorithm  for Wind and Wave Farm Layout Optimization","keywords":"<p class=Default>The performance of wind or wave farms can be significantly influenced by the geometrical positioning of the devices, that is, the layout of the farm. This research deals with a metaheuristic optimization method based on the Search Group Algorithm1 (SGA), to deal with the optimization of a wind or wave farm layout. To determine the optimal positions for each WEC in a wave farm, the total power of the farm is calculated using the method based on the analytical interaction theory described by McNatt et al. considering interactions between the WECs. The SGA calculates the optimal WEC positions for a maximal power production respecting a minimum distance between the devices. As example, the optimal positions in a 5 WEC array are calculated. The combination of the interaction method presented by McNatt et al. with this algorithm allows to determine the optimal WEC positions in large farms at a reasonable computational cost. Part of the research is the further implementation of a cost function. With these insights the optimal power-cost layout can be determined and a comparison can be made between a wind and a wave farm.</p>","authors":"S. Bossuyt, V. Stratigaki, R. Lopez, P. Troch, A. Kortenhaus","topic":"5","file":"WAVHYD-08-972.pdf","bib":"WAVHYD-08-972.bib"},
{"paperid":"973","title":"Classification Systems for Wave Energy Resources and WEC Technologies","keywords":"<p class=IEEEParagraph>This paper proposes a wave energy resource classification system for U.S. wave climates and a WEC technology classification system built on previous work by Cruz [1]. A core objective is to further refine the preliminary WEC classes conceptualised in [1], focusing on a single WEC technology archetype (a point absorber). The resource opportunity and risk metrics are used to define dozens of different wave energy resource classes for U.S. wave climates, which then feed in the WEC technology classes.</p>","authors":"V. Neary, K. Haas, S. Ahn, J. Cruz, P. Weywada","topic":"1","file":"WAVRES-04-973.pdf","bib":"WAVRES-04-973.bib"},
{"paperid":"974","title":"Robust Control of a Wave Energy Converter with Soft Sensing of Wave Excitation Force","keywords":"<p>This paper presents a new architecture for the robust control and observation of a scaled Point Absorber Wave Energy Converter (PAWEC). The proposed architecture combines robust control and estimation algorithms in order to achieve reliable, high efficiency and low-cost PAWEC operation.</p> <p>First, the mathematical model of the PAWEC is divided into two coupled subsystem. A decoupling between the two subsystems is achieved by subtracting the disturbance (coupling) terms from the control input voltages of each subsystem. This simplifies the control problem and allows using linear techniques. Then, a Backstepping controller is designed to track an optimal reference position. While, a simple PI controller is designed to regulate the d-axis current in the second subsystem.</p> <p>Since the wave excitation force is not easily measured and measuring the velocity requires expensive sensor, an unknown input observer is proposed to estimate online these two signals and passes them with other measured states to the controllers.</p> <p>The suggested architecture is simulated with irregular wave inputs and shows that the observer can satisfactorily provide required estimates and the controllers are able to achieve good tracking and regulation targets. The architecture also shows robustness against parameters uncertainty.</p><p class=IEEEParagraph> </p>","authors":"M. Abdelrahman, R. Patton","topic":"7","file":"GRDPTO-06-974.pdf","bib":"GRDPTO-06-974.bib"},
{"paperid":"976","title":"Advanced metocean planning tools for the wave and tidal energy sectors","keywords":"<p>The combined cost of operations and maintenance (O&amp;M) and installation activities are estimated to represent 35% and 46% of the lifetime cost of wave and tidal energy arrays respectively. Reducing these costs represents one of the best opportunities for accelerating development in this industry, particularly for the tidal energy sector with its first commercial arrays nearing deployment.</p> <p>The common factor that impedes all marine operations is limited access to offshore locations due to adverse meteorological and oceanographic (’metocean’) conditions. The inherent risks associated with working in the harsh, complex and ever-changing marine environment are clear. To help minimise these risks, this paper explores the use of advanced metocean planning tools to assess the marginal benefits between alternative strategies to aid the development of a site-specific plan for marine operations.</p> <p>This work describes and evaluates a comprehensive metocean planning tool, known as ForeCoast® Marine. The tool extends the theory of Sequential Downtime Analysis which enables the time-domain simulation of a marine operation using hindcast metocean data. The impacts of using time-domain simulations to plan off-shore operations are assessed through a case study based at the European Marine Energy Centre Ltd. (EMEC).</p><p> </p>","authors":"B. Hudson, E. Kay, M. Lawless, T. Bruce","topic":"11","file":"OPANDM-01-976.pdf","bib":"OPANDM-01-976.bib"},
{"paperid":"977","title":"Effect of a varying current direction on the energy production of a pilot tidal farm by a pseudo steady approach","keywords":"<p class=IEEEParagraph><span lang=EN-AU>Some places in the Alderney race have a bidirectional currents and in some other ones the currents can have an incidence </span><span lang=EN-US>with respect to the predominant direction until 30°. </span><span lang=EN-AU>This incidence could have an impact on the power produced along one tidal cycle by pilot farm</span><span lang=EN-US>. </span></p> <p class=IEEEParagraph><span lang=EN-US>The objective of the present study is to consider the impact of this incidence on the power production considering several parameters. </span></p> <p class=IEEEParagraph><span lang=EN-AU>For the present purpose, we model the 3D-flow resolving the Navier-Stokes equations with FLUENT ANSYS 14.5 and we apply the Actuator Disk theory for representing the thrust of the turbines as described by Nguyen et al. (2016). The method is applied to tidal farms in two configurations (regular and staggered) and with several thrust coefficients. The current speed during a mean tide was calculated by a regional 2D model  and a log law is used as the vertical evolution of the velocity. The depth is 55m. Turbines are represented by disks having a 20m diameter and 2m thickness. The powers of the machines and of the farm are then calculated and compare. </span></p>","authors":"V. Nguyen, S. Guillou, J. Thiébot, A. Santa Cruz","topic":"6","file":"TIDHYD-05-977.pdf","bib":"TIDHYD-05-977.bib"},
{"paperid":"978","title":"Optimal constant damping control of a Point Absorber with linear generator in different sea states: Comparision of simulation and scale test","keywords":"<p>To generate electric energy out of waves, floating bouy point absorbers with linear electric generators are a simple and effective way. In this paper we focus on Point Absorber with a linear electric generator with constant damping as Power Take Off, as it is used by the University Uppsala in the Lysekil Wave Power Project. The optimal damping depends on the sea state the point absorber is working in. For this device, we simulate a power matrix with 47 sea states always using the optimal constant damping for each sea state. The results from the simulation are compared to 1:10 scale wave tank tests. To simulate the Power Take Off, an electrical tubular linear motor was connected to the bouy, which mimics a linear generator with constant damping; The damping coefficent could be set arbitary.<br />It can be seen that in the scale tests the wave period is less important for the generated power output than predicted in the simulation.</p>","authors":"S. Thomas","topic":"7","file":"GRDPTO-07-978.pdf","bib":"GRDPTO-07-978.bib"},
{"paperid":"979","title":"THE WAVE FIELD BEFORE A U-OWC BREAKWATER","keywords":"<p class=IEEEParagraph><span lang=EN-AU>REWEC devices are a new family of U-OWC. In this work, we carried out a numerical experiment aiming to analyze the interaction between waves and a U-OWC breakwater. The numerical method adopted is the numerical integration of Reynolds averaged Navier-Stokes equation. The water-air interaction is taken into account by means of the Volume Of Fluid model implemented in the commercial CFD code Ansys Fluent. To validate the numerical flume, we carried out some preliminary tests to compare numerical results of a vertical reflecting wall with the analytical solution of linear standing waves. A careful check of the field of motion (pressure, velocities, free surface displacement) permitted us to assess the effectiveness of the numerical simulation. </span><span lang=EN-US>The numerical experiment has been carried out by substituting the vertical wall with the U-OWC,</span><span lang=EN-AU> the same as the 1:6 scale physical model of breakwater tested by Boccotti et al, 2007, directly, at sea, off the coast of Reggio Calabria (in the eastern coast of the Messina Straits). To check the plant working conditions, we made several simulations, varying the wave period. Finally, we compared the numerical results with the experimental data described by Boccotti et al.</span></p>","authors":"L. Gurnari, P. Filianoti","topic":"5","file":"WAVHYD-08-979.pdf","bib":"WAVHYD-08-979.bib"},
{"paperid":"980","title":"Optimising multiple multibeam sonars to assess marine life interactions with an underwater kite","keywords":"<p class=IEEEParagraph>Multibeam sonar has emerged has a powerful tool for environmental monitoring of marine renewable energy (MRE) devices. Moving away from manned operations, self-contained multibeam sonar systems may be costly at purchase, but are cost-effective for long-duration autonomous deployments. However, there is no single multibeam sonar configuration that suits all environments and MRE devices currently being tested, and licence requirements may vary by federal regulator.</p> <p class=IEEEParagraph>A novel turbine called the Deep Green kite is under test in a tidal channel (Strangford Lough, Northern Ireland, UK). The kite consists of a wing with a small turbine attached, tethered to the seabed. The kite uses hydrodynamic lift, resulting in a figure-eight shaped trajectory underwater, similar to the movement of a wind kite.</p> <p class=IEEEParagraph>Strangford Lough is a Special Area of Conservation for harbour seals and a multibeam sonar configuration needs to track seals and other marine life with high spatial and temporal resolution for several months.</p> <p class=IEEEParagraph>Developed through a collaboration between the research team, local regulative authorities, the kite developer and the sonar manufacturers, we describe the transition from a marine mammal detection system to a configuration that eventually aims to understand the four-dimensional movement and interactions of animals around the kite.</p> <p> </p>","authors":"L. Lieber, L. Kregting","topic":"9","file":"ENVIRO-03-980.pdf","bib":"ENVIRO-03-980.bib"},
{"paperid":"981","title":"Laboratory tests on the predictability of the natural frequencies of oscillation in resonant wave energy converters","keywords":"<p class=IEEEParagraph>REWEC2 is a breakwater embodying an OWC plant characterized by the fact that can be regulated whilst working in order to maintain the resonance conditions with the different frequencies of the waves. the REWEC2 has two possibility of variation. Indeed, if we want a strong variation of the oscillation frequencies we can vary the air volume in the reservoirs; if we want a small modification in respect to the working conditions, we can vary the volume of the air in the chamber In order to obtain the natural oscillation frequencies in resonance conditions with the frequencies of the waves on the outer opening, the air volume in the chamber can be regulated. In these cases, the incoming waves are in resonance with the plant and consequently the fluctuating pressure in the chamber is very high and the water velocity in the vertical duct is very strong. The modification of the air volume in the plenum, was made by varying the value of the pressure inside the chamber. Several tests on a model of a REWEC2 were conducted. In order to measure the natural oscillation frequency of the plant, oscillations of the water in the vertical duct and in the chamber, were induced. These oscillations were produced by a rapid pressure drop of the air in the caisson, quickly opening the valve that links the caisson with the atmosphere.</p>","authors":"P. Filianoti, L. Gurnari","topic":"5","file":"WAVHYD-09-981.pdf","bib":"WAVHYD-09-981.bib"},
{"paperid":"982","title":"On Defining Wave Energy Pilot Sites in Swedish Seawaters","keywords":"<span>This paper introduces a recently started national Swedish project funded by the Swedish Energy Agency to map conditions of relevance for the prospects of establishing and operating offshore wave energy devices in Swedish Seawaters, including the Swedish Exclusive Economic Zone (EEZ). The mapping will cover geological, meteorological and oceanographic variables in high resolution, including wave climate, conditions on the seabed, sea-ice conditions, sea-level fluctuations and how surface currents influence drifting sea-ice. Mapping will also include ecosystem components, maritime activities and regulated areas. Furthermore, the project will predict power production for the purpose of locating suitable pilot sites for offshore wave energy conversion and to identify favourable zones for establishing and operating future large scale installations in Swedish seawaters from the point of view of the physical conditions. This paper presents methodology and initial results for high-resolution wave modelling, mapping of geological conditions and ecosystem components for a selected focus area outside the Swedish east coast in the Baltic Sea. The paper also presents methodology for modelling predicted power production with a generic point absorber type wave energy converter technology.</span>","authors":"E. Strömstedt, K. Haikonen, J. Engström, M. Eriksson, M. Göteman, J. Sundberg, J. Nyberg, L. Zillén Snowball, E. Nilsson, A. Dingwell, A. Rutgersson","topic":"1","file":"WAVRES-PP-982.pdf","bib":"WAVRES-PP-982.bib"},
{"paperid":"983","title":"Wave Energy in Chile: A Case Study of the Overtopping Breakwater for Energy Conversion (OBREC)","keywords":"<p class=IEEEParagraph>This paper constructs an optimal configuration assessment, in terms of the financial returns, of the Overtopping BReakwater for wave Energy Conversion (OBREC). This technology represents a hybrid wave energy harvester, totally embedded in traditional rubble mound breakwaters. The first OBREC prototype is in operation since 2016 at the Naples Harbour (Italy). The pilot plant represents the first overtopping wave energy converter totally embedded in a breakwater. The aim of this manuscript is to analyse the application of the OBREC on specific sites along the coast of Chile. The region is known as one of the most energetic areas around the world with very low seasonal variability of the power. The technique provides also tips on how to estimate the quality of the investments, for benchmarking with different turbine strategy layouts and overlapping with the costs of traditional rubble mound breakwaters. Analyses of the offshore and nearshore wave climate have been studied by a high resolution coastal propagation model, forced with wave data from the European Centre for Medium-Range Weather Forecasts. Inshore wave conditions have been used to quantify the exploitable resources. The work emphasizes the importance of integrating energy production predictions in an economic decision framework for prioritizing adaptation investments.</p>","authors":"E. Di Lauro, P. Contestabile, D. Vicinanza","topic":"3","file":"WAVDEV-08-983.pdf","bib":"WAVDEV-08-983.bib"},
{"paperid":"986","title":"Design and Bench Testing of a Model-Scale WEC for Advanced PTO Control Research","keywords":"<p>Advanced control of the power take-off (PTO) in a wave energy converter (WEC) has shown significant promise for increasing wave energy absorption in simulation. We discuss the design of a model-scale WEC for obtaining data to inform limitations of the simulations and provide better insight into control design and implementation for full scale systems. This model WEC is a 3 degree-of-freedom (3-DOF) system actuated by high-torque permanent magnet alternating current (PMAC) motors. The device’s motors are designed provide high-fidelity torque control of the heave, surge, and pitch PTOs achieving &gt;10Hz bandwidth at each of the three DOFs. In addition to the design process for this device, we present a hardware load simulator for dry system performance and dynamics characterization. This load simulator system, which comprises the components of the classical spring-mass-damper, approximates the wave tank test environment, including linear inertia and stiffness, as well as some damping. By allowing a PTO excite the load simulator system, we are able to perform valuable bench testing experiments within the operating regimes that will be tested in the wave tank. Results from these bench tests, which include system ID, model validation and assessment of some controllers, will be presented and discussed.</p><p> </p>","authors":"G. Bacelli, S. Spencer, A. Mazumdar, R. Coe","topic":"3","file":"WAVDEV-08-986.pdf","bib":"WAVDEV-08-986.bib"},
{"paperid":"988","title":"CFD simulation of the unsteady flow in an Oscillating Water Column: comparison between numerical and experimental results for a small scale experimental device","keywords":"<p>The unsteady flow inside an Oscillating Water Column (OWC) device is subjected to combined effects of wave propagation, flow field and viscous losses, related to the geometrical characteristics of the device. These combined effects influence the dynamic response of the system, mainly for OWC devices designed to enhance the resonance effects. A reliable knowledge of such effects is helpful to improve the analytical models that are quite generally used for performance analysis and control system development.</p> <p>In order to evaluate the capability of CFD to reproduce the unsteady flow conditions of an OWC system, a scaled experimental device has been set up able to generate oscillations in a broad range of frequencies. The experimental tests have been numerically reproduced by means of two-dimensional CFD simulations by means of the Reynolds Average Navier-Stokes equations written for an unsteady two-phase flow, with a k-ω turbulence model. The equations have been discretized according to a Finite Volume approach, adopting a pressure-based algorithm in its implicit formulation. The two-phase interaction is taken into account by means of the Eulerian Volume Of Fluid (VOF) Model. Air is assumed to be compressible, in order to take into account the compressibility of the air pocket inside the chamber.</p> <p>The CFD simulations show a good agreement with experiments, within the examined frequency range. Time plots of air pressure are well reproduced and also the peak frequency is well captured.</p>","authors":"F. Scarpetta, M. Torresi, S. Camporeale, P. Filianoti","topic":"5","file":"WAVHYD-09-988.pdf","bib":"WAVHYD-09-988.bib"},
{"paperid":"989","title":"Effects of tidal energy converters on a tidal channel turbulence conditions","keywords":"The turbulence appears as a key aspect in relation to optimise the design of tidal turbines.The present paper tries to assess the far-field impacts of a tidal energy turbine in the turbulence conditions of a tidal flow by means of a case study (Orkney region, North of Scotland). The results obtained, offered interesting insight in relation to the variations of the turbulence conditions due to the park effects of the tidal farm, which can play an important role for tidal layout optimisation.","authors":"P. Garcia Novo, V. Ramos","topic":"6","file":"TIDHYD-PP-989.pdf","bib":"TIDHYD-PP-989.bib"},
{"paperid":"990","title":"EFFECTS OF FREE STREAM TURBULENCE ON TIDAL TURBINES. PART I – BLADE HYDRODYNAMICS & LOADING","keywords":"<p><strong>Tidal turbines operate in flow conditions with elevated levels of free-stream turbulence (FST) that affect the loads acting on components, which in turn affects the performance. The current work focuses on the use of controlled laboratory experiments to investigate the effects of free stream turbulence on an SG-6043 turbine blade section. Elevated levels of FST are generated using an active grid generator at turbulence intensities (</strong><em>T</em><sub>i</sub><strong>) varying between 1.5-9.2%.  It was observed that</strong><strong> elevated levels of FST increased the coefficient of lift (C_L</strong> <strong>) and caused a subsequent delay in flow separation. In addition, the coefficient of drag (C_D</strong> <strong>) also increases at high angles of attack in elevated levels of FST, leading to a reduction in hydrodynamic performance. </strong><strong>The measured standard deviations indicate that elevated FST leads to considerable fluctuations in measured forces, which in turn will accelerate fatigue damage to the blade. We report our findings of experiments conducted with the hydrofoil over a wider range angles of attack at various turbulence intensities. Acoustic Doppler Velocimetry measurements are made at several downstream locations to provide insight into the flow mechanism that causes a delay in separation observed at higher values of <em>T</em><sub>i</sub> (3.74-9.20%). Characteristics of the wake downstream of the blade is also discussed. A Blade Element Momentum analysis was performed to evaluate the performance of a representative marine current turbine at different FST levels. It was observed that elevated levels of FST led to </strong><strong>higher values of C<sub>p</sub> at lower TSR with a shift in TSR corresponding to maximum C<sub>p</sub> value; a result in direct contradiction with reported experiments. The results are discussed and provides future motivation of a BEM method to accurately capture the effect of free-stream turbulence.</strong></p> <div></div>","authors":"A. Lawrence, A. Vinod, A. Banerjee","topic":"4","file":"TIDDEV-07-990.pdf","bib":"TIDDEV-07-990.bib"},
{"paperid":"992","title":"Efficient Modelling of Bottom Friction  and Multi-Floater Mooring Systems in MoorDyn","keywords":"<p class=IEEEParagraph>MoorDyn is a lumped-mass model for simulating the dynamics of mooring systems with an emphasis on computational efficiency.  This paper will describe the formulation, implementation, and preliminary validation of two new capabilities in MoorDyn: modelling bottom friction and simulating mooring systems interconnecting multiple floating bodies.</p> <p class=IEEEParagraph>Friction between mooring lines and the seabed can be important to catenary mooring design, but is difficult to model in dynamic mooring models with coarse discretizations.  Modelling with few line segments can cause nonphysical tension transients from the step changes in friction that occur when nodes arrive or depart from the seabed.  An approach that avoids these transients is being developed so that seabed friction can be accurately modelled without necessitating an increase in discretization and computation time.  The formulation will be presented and a preliminary validation discussed.</p> <p class=IEEEParagraph>A second capability under development is for mooring systems attached to more than one floating body.  This involves modelling mooring line interconnections and enabling multiple independent couplings at different points in the mooring system.  The developed methods will be described and demonstrated with simulation results.  Lastly, wave tank testing strategies will be discussed that may ease validation of these more-complex mooring systems.</p>","authors":"M. Hall","topic":"12","file":"MRGFND-02-992.pdf","bib":"MRGFND-02-992.bib"},
{"paperid":"993","title":"EFFECTS OF FREE STREAM TURBULENCE ON TIDAL TURBINES. PART II – TURBINE PERFORMANCE AND NEAR WAKE CHARACTERISTICS","keywords":"<p><strong>Tidal turbines are designed to be deployed in flows which are turbulent in nature. Accounting for the effects of turbulence in the free stream on the operation of such devices become vital from a design standpoint. This paper investigates the effects of turbulence on performance and near wake characteristics of a 1:20 scale model tidal turbine. Three levels of turbulence intensities; 1.5%, 3.7%, and 9.2% were used in the experiments, with the two higher turbulence cases generated using an active grid. Turbulence was found to have a considerable impact on the load fluctuations and wake characteristics of the turbine. Flow features such as velocity deficit, turbulence intensity, skewness, kurtosis and swirl number are discussed in detail to understand the process of momentum transfer and distribution in the near wake region of a tidal turbine. </strong></p>","authors":"A. Vinod, A. Lawrence, A. Banerjee","topic":"4","file":"TIDDEV-07-993.pdf","bib":"TIDDEV-07-993.bib"},
{"paperid":"996","title":"Assessing the environmental impacts of wave energy converters: do we know what the baseline tells?","keywords":"<p class=IEEEParagraph><span lang=EN-AU>Research efforts are increasing on the side of the ocean energy technological development but several non-technical barriers still need to be overcome for wave energy to become an established energy source. The most significant of these non-technical barriers is the necessity to comply with the EU Environmental Impact Assessment (EIA) Directive and associated national legislation. The potential effects of WECs on marine organisms have been comprehensively discussed.  However, most of the discussed effects and impacts are still poorly known. The standardization of the EIA process of WECs is also far from being sorted out and a good deal of variation exists in the considered parameters and receptors as in the methods adopted during the EIA process. The aim of this paper is to discuss the definition of the reference scenario for the environmental impact studies and to highlight the importance of open data, such as EMODnet or OBIS Seamap data, to compose this scenario. Moreover, potential correlations of the wave-wind climate, as obtained from the ECMWF 40 (ERA- 40) Global Wave Forecast Data Set with the general environmental context will be also analysed and discussed with the aim to highlight the not obvious implications for the scenario definition. </span></p>","authors":"A. Azzellino, C. Lanfredi, L. Riefolo, D. Vicinanza","topic":"9","file":"ENVIRO-04-996.pdf","bib":"ENVIRO-04-996.bib"},
{"paperid":"997","title":"Reaction Body Hydrodynamics for a Multi-DOF Point-Absorbing WEC","keywords":"<p>Submerged heave plates are commonly employed in point-absorbing WECs as a reaction body. The hydrodynamic forces acting on this reaction body, in the form of added mass and drag, are important contributors to the overall inertial reaction force provided by the heave plate. Newer WECs are using increasingly complex geometries for the submerged reaction body and an emerging challenge in creating mid-fidelity models lies in accurately determining the hydrodynamic coefficients. Only simple canonical heave plate geometries have previously been characterized using heave-limited forced oscillation experiments, while little research has looked at reaction body hydrodynamics in additional degrees of freedom.</p> <p>The recent emergence of some multi-DOF compliantly connected two-body WECs, such as the Oscilla Power Triton, mean it is necessary to characterize the full matrix of hydrodynamic coefficients in all relevant degrees of freedom. Here we present a series of experiments in which laboratory-scale ring-shaped Triton reaction bodies are sinusoidally forced to characterize the hydrodynamic coefficients across multiple modes of motion, as functions of the two governing nondimensional parameters, Keulegan Carpenter number (<em>KC</em>) and Reynolds number (<em>Re</em>). Numerical CFD is then used to replicate a number of these model-scale tests and provide comparative simulations at full-scale.</p><p> </p>","authors":"T. Mundon, B. Rosenberg, J. Rij","topic":"5","file":"WAVHYD-09-997.pdf","bib":"WAVHYD-09-997.bib"},
{"paperid":"999","title":"Methodologies of Determining the ACE Wave Energy Prize Metric","keywords":"<p>The United States’ Department of Energy’s Wave Energy Prize contest encouraged the development of innovative deep-water wave energy technologies that at least double device performance above the state-of-the-art. Levelized cost of energy (LCOE) metrics are challenging to equitably apply to new technologies where significant uncertainty exist in design and operation. Therefore, the prize developed the ACE metric, a reduced metric as proxy for LCOE, which provides an equitable comparison of low Technology Readiness Level (TRL) Wave Energy Converter, WEC, concepts. The paper describes the methodology and application of the ACE metric used to evaluate the performance of the technologies that competed in the Wave Energy Prize. This paper first provides an overview of the wave energy prize and how the ACE metric was developed. Next, a description of the averaging method used to determine the ACCW from power performance measurements at the Naval Surface Warfare Center, Carderock Divisions’ Maneuvering and Sea Keeping Test Facility is provided. The methodology used to calculate the CCE from structural models and estimates of material and manufacturing costs is overviewed with examples. Finally, non-dimensionalized results from the final testing are provided.</p>","authors":"F. Driscoll, S. Jenne, J. Weber, R. Thresher, D. Bull, A. Dallman, D. Newborn, M. Quintero, A. LaBonte","topic":"3","file":"WAVDEV-09-999.pdf","bib":"WAVDEV-09-999.bib"},
{"paperid":"1000","title":"Designing Multi-Rotor Tidal Turbine Fences","keywords":"<!-- p { margin-bottom: 0.25cm; line-height: 120%; } --> <p style=margin-bottom: 0cm; line-height: 100%;><span style=font-size: x-small;>The uplift in turbine performance theoretically available in blocked conditions requires turbines to be designed specifically to achieve the high levels of thrust. This is typically achieved either by increasing the tip speed ratio or the rotor solidity (or a combination of the two). This process relies on design consideration of the blockage conditions in which the turbines are to be deployed.</span></p> <p style=margin-bottom: 0cm; line-height: 100%;><span style=font-size: x-small;>This paper shows that overall tidal fence efficiency is not optimised by designing turbines specifically for either the local (turbine frontal area to flow passage cross-sectional area) or global (sum of turbine frontal area to channel cross-sectional area) blockage ratios, but rather an intermediate blockage ratio. Furthermore, the interference effects between adjacent turbines are thrust dependent, as turbines above rated flow speed controlled with pitch-to-feather pitch control (to reduce thrust above rated flow speed) have less effect on neighbouring turbines than those at exerting greater levels of thrust at rated flow speed.</span></p> <p style=margin-bottom: 0cm; line-height: 100%;><span style=font-size: x-small;>This paper explores these and other challenges that arise in the design and control of multi-turbine fences partially spanning tidal flows through 3D Reynolds-averaged Navier Stokes embedded Blade Element Actuator Disk (RANS-BE AD) simulations, with particular focus on recovering the turbine performance lost in multi-rotor configurations.</span></p>","authors":"C. Vogel","topic":"6","file":"TIDHYD-05-1000.pdf","bib":"TIDHYD-05-1000.bib"},
{"paperid":"1001","title":"Improving Fault Tolerance in a Newly Commissioned Wave Energy Array","keywords":"<p class=IEEEParagraph>The installation and commissioning of a wave energy array comes with several challenges. Some failure events can be predicted using a Failure Mode and Effects Analysis, however many unprecedented failures were encountered upon installation of 6 Squid 6 Series devices in Mingary Bay on the Ardnamurchan peninsula. Failing subsystems include hydraulic, instrumentation, structural and mooring systems.</p><p class=IEEEParagraph>This study discusses the uses of the FMEA to inform risk based inspection, the improvement of control and instrumentation to operate reliabily and detect component faults, and the development of the alarming system and move towards automated fault detection. An effort to design devices that are not simply fault tolerant, but robust and resilient, is discussed.</p>","authors":"C. Kenny, D. Findlay, I. Lazakis, J. Shek, P. Thies","topic":"3","file":"WAVDEV-09-1001.pdf","bib":"WAVDEV-09-1001.bib"},
{"paperid":"1003","title":"Analysis of a triangular array of floating Oscillating Water Column devices with inter-body mooring connections in regular waves","keywords":"<p>Floating wave energy converters (WECs) should be arranged into arrays with a relatively small spacing between devices, for the extraction of large quantities of ocean energy. Inter-body mooring connections could reduce the number of bottom mooring lines, reducing the overall mooring cost. This paper investigates the effects of the mooring system on the power output of a triangular array of floating oscillating water column (OWC) devices, Spar buoy OWC. The hydrodynamic coefficients for the array were calculated using WAMIT, considering six degrees-of-freedom (DoF) for the device and one DoF (heave) for the OWC. Each WEC is anchored to the bottom via a bottom mooring line. The inter-body mooring consists of three cables connecting the devices to a weight located in the centre of the array. The equations of motion are solved in the frequency domain for the devices, each with seven DoF, considering the hydrodynamic characteristics of the devices in the array and the dynamic effects from the weight and mooring lines from the inter-body connections. The results indicate that by including mooring lines, additional peaks appear on the displacement amplitudes of the devices. A coupling effect, between the surge/sway modes and the heave mode, is introduced by the inter-body connections.</p>","authors":"C. Oikonomou, R. Gomes, L. Gato, A. Falcão","topic":"12","file":"MRGFND-03-1003.pdf","bib":"MRGFND-03-1003.bib"},
{"paperid":"1005","title":"CREATING VALUE IN OCEANOGRAPHY WITH WAVE ENERGY CONVERTERS: USER NEEDS","keywords":"<p><a name=OLE_LINK15></a><a name=OLE_LINK14><span><span lang=EN-AU><span style=font-family: Times New Roman; font-size: x-small;>This work concerns with an exploratory study about the potential applicability of using wave energy converters as isolated systems for supplying energy for specific needs within various sectors. The concept of operational oceanography and the network of infrastructure and collaboration behind the concept is introduced, identifying the main sectors and stakeholders. 42 semi-structured interviews were performed to individuals of diﬀerent sectors of interest. From the interviews the common problems and needs are identiﬁed according to their processes, and main ﬁndings are presented. Some sectors act only as end-users such as the people in the leisure sector and in the transport sector, but some of them can be operators, added-value intermediates, and/or end-users such in the case of the environment, energy and military sectors. Operators, intermediates and end-users suﬀer from similar pains regarding the reliability of forecasting and observational data. Failure of systems are in general related to auxiliary systems, such as batteries, PV panel failures, bio-fouling, transmission systems and sensors. Wave energy converters designed for small dimensions can fulﬁl some of the needs of a bunch of sectors, especially in terms of increased power capacity and continuity, reducing some of the limitations of the current systems. </span></span></span></a></p>","authors":"J. PORTILLO, D. Ferreira, J. Henriques, L. Gato","topic":"10","file":"ECONOM-03-1005.pdf","bib":"ECONOM-03-1005.bib"},
{"paperid":"1006","title":"Wave Energy Prize Testing and Data Analysis","keywords":"The United States’ Department of Energy’s Wave Energy Prize contest encouraged the development of innovative deep-water wave energy technologies that at least double device performance above the state-of-the-art. Wave Prize finalists tested their technologies at the Naval Surface Warfare Center, Carderock Divisions’ Maneuvering and Sea Keeping Test facility to provide measured performance data that was used to evaluate their design. This paper overviews the development of the testing program, the successful execution of nine sequential tests, and the consistent and equitable analysis of the measurements. Non-dimensionalized and anonymous results are also presented. Finally, a section of lessons learned is provided to disseminate the experience gained in the intensive test program<br />","authors":"F. Driscoll, D. Newborn, M. Quintero, B. Gunawan, D. Bull, A. Dallman, L. Fingersh, K. Ruehl","topic":"3","file":"WAVDEV-09-1006.pdf","bib":"WAVDEV-09-1006.bib"},
{"paperid":"1007","title":"Seasonal effects on probability of fish  encounter with MHK devices","keywords":"<p class=IEEEParagraph><span lang=EN-AU>The effects of marine hydrokinetic (MHK) devices on fish are generally unknown, but of high concern to industry, regulators, the scientific community, fishers, and other stakeholders.  Multiple MHK technologies will be deployed at the Fundy Ocean Center for Energy test site in the coming years.  As the fish assemblage of this region changes seasonally, and temperature causes changes in fish physiology and behaviour, the risk turbines pose to fish will also vary seasonally.  The goal of this project is to compare the vertical distribution of fish at the site in winter and summer and how this affects the likelihood of fish encountering the Cape Sharp Tidal MHK device (OpenHydro) installed in November 2016, which spans 0-20 m above the bottom. Hydroacoustic data were collected with an upward-facing Acoustic Zooplankton and Fish Profiler on a remote bottom-mounted platform, deployed in December 2015 and June 2016. The vertical distribution of fish will be compared between time periods of interest, e.g. day vs. night and ebb tide vs. flood tide in winter and summer.  The proportion of backscatter at turbine depth allows assessment of seasonal differences in the likelihood of fish encountering the tidal turbine.</span></p>","authors":"H. Viehman, T. Boucher, A. Redden","topic":"9","file":"ENVIRO-04-1007.pdf","bib":"ENVIRO-04-1007.bib"},
{"paperid":"1009","title":"Modelling of a Combined Tension Moored Wind and Wave Energy Convertor System","keywords":"<p class=IEEEParagraph><span lang=EN-AU>This paper presents a novel combined tension moored wind and wave energy convertor (WEC). The wind turbine is NREL’s 5 MW reference wind turbine (WT), while the WEC’s are composed of four torus shaped pitch restrained heaving point absorbers, rated at 250 kW each, resulting in a combined system rated at 6MW. A novel survival mode for the WEC’s in above rated sea-states is also proposed which helps reduce the overall platform motions and mooring tendon loads. The system is designed for deployment on the west coast of Ireland in a water depth of 120m.</span></p><p class=IEEEParagraph><span lang=EN-AU>Modelling for the platform design was carried out in the frequency domain using ANSYS AQWA and in the time domain using the fully coupled <span>nonlinear aero-hydro-servo-elastic FASTLINK, which couples ORCAFLEX and FAST v.8. This allows detailed modelling of the WEC’s and WT operating simultaneously, enabling analysis of any resulting complex interactions.</span></span></p> <p class=IEEEParagraph><span lang=EN-AU>The combined power matrix of the device is presented, along with the motions and forces experienced in numerous configurations of the survival mode.</span></p>","authors":"C. Wright, V. Pakrashi, J. Murphy","topic":"3","file":"WAVDEV-09-1009.pdf","bib":"WAVDEV-09-1009.bib"},
{"paperid":"1011","title":"Environmental Monitoring - From Theory to Practice","keywords":"<p>The environmental impact assessment process for the marine renewable energy industry is costly due to high uncertainties.  To reduce the cost of impact assessment the process for environmental monitoring and interpretation will be examined, and aspects that are transferable between different developments discussed.  A framework for assessment will be considered that has three stages: define the interaction of the device with the environment, measure or model the disturbance, and interpret the data to establish any impacts.</p><p>The design of devices will determine the nature of the interaction, and recent projects have been focussing on measuring the disturbance and improving the interpretation.  How to take this framework forward will be discussed with examples of how each stage is implemented and can be improved.</p>","authors":"G. Harker, A. Copping, S. Eaves","topic":"9","file":"ENVIRO-04-1011.pdf","bib":"ENVIRO-04-1011.bib"},
{"paperid":"1012","title":"Power Maximisation of a Wave Energy Converter using Predictive Control: Robustness to System Mismatch","keywords":"<p>It is argued that the performance of model based controllers depends on the accuracy of the model. Since WEC dynamics can be uncertain and may indeed vary over their lifetime due for example to biofouling, the performance may therefore in reality become sub-optimal. Here a study is presented to investigate how the performance of a point absorber under MPC depends on the model accuracy. The mismatch assumed between the system and the control model include changes in the WEC mass, radiation kernel, hydrostatic stiffness and added non-linear viscosity due to biofouling. As the system model diverges from the MPC control model, the amount of average electrical power extracted decreases. However, even with these model variations the closed-loop system itself remains stable and acceptable though reduced power was extracted.</p><p> </p>","authors":"A. O'Sullivan","topic":"7","file":"GRDPTO-07-1012.pdf","bib":"GRDPTO-07-1012.bib"},
{"paperid":"1014","title":"A CFD simulation of a full scale U-OWC breakwater","keywords":"<div class=WordSection1><p><br />Many different concepts of marine renewable energy sources are currently being developed. Wide research efforts are focused on OWC (Oscillating Water Column) systems that are under study for onshore as well as for floating applications. In particular U-OWC systems, embodying a U-duct on the wave-beaten side, have raised large interest and found application in a harbour breakwater. In order to analyse the interaction between the waves and the U-OWC, in terms of reflection and transmission coefficients, as well as the overall performance of the system, a CFD simulation of a full-scale U-OWC breakwater has been carried out in order to simulate the flow field in front of breakwater and inside the OWC device, taking into account the characteristics of the air turbine adopted as power take-off device. In order to reduce the huge need of computational resources, CFD unsteady simulation have been carried out in a two dimensional (2D) reference frame by solving the Reynolds-Averaged Navier-Stokes (RANS) equations while the water-air interaction is taken into account by means of the Volume Of Fluid (VOF) model.  In order to  overcome the problems related to the simulation of the air turbine in the 2D domain, the connection between the chamber and the external ambient is modelled as a porous zone where analytical equations able to model air duct and  turbine are implemented. A further outcome of the present work is the calibration of the analytical model used for performance analysis and control system design.</p></div>","authors":"f. scarpetta, l. gurnari, m. torresi, p. filianoti, S. Camporeale","topic":"5","file":"WAVHYD-09-1014.pdf","bib":"WAVHYD-09-1014.bib"},
{"paperid":"1016","title":"Array Optimization of Fixed Oscillating Water Columns for Active Device Control","keywords":"<p>As the wave energy industry advances towards real-sea deployment, the need to consider the implementation of arrays for optimal grid-integration is pressing. Currently, most research consists of pre-described array design with only a few researchers considering more advanced techniques of layout design and optimization. To date we have built off of existing research and developed a genetic algorithm (GA) specific to wave energy converter (WEC) array optimization. This paper will discuss a continuation of our previous work through the application of our GA on fixed oscillating water columns. Employing elitism, crossover, mutation, and random solution generation the GA is applied to five, fixed oscillating water columns to determine their best layout(s). Given the fixed nature of the oscillating water column, the optimal arrays will be based on an interaction factor which is the ratio of the power of an array to the power of an isolated device multiplied by the number of devices in the array. The results provided will aid in understanding array design and the impact of factors such as minimum required device spacing and device type. Ultimately, these results will be used by fellow researchers studying active controls in a tank-test scenario of fixed OWCs.</p>","authors":"C. Sharp, B. DuPont, B. Bosma, P. Lomonaco, B. Batten","topic":"5","file":"WAVHYD-09-1016.pdf","bib":"WAVHYD-09-1016.bib"},
{"paperid":"1017","title":"Balancing Power Absorption and Structural Loading for a Novel Bottom Fixed Wave Energy Converter with Nonideal Power-Take-Off in Regular Waves","keywords":"<pre>The focus of this work is to balance power absorption against structural loading for a novel fixed-bottom oscillating surge wave energy converter. The power-to-load ratio will be evaluated using <span>pseudospectral</span> control to determine the optimum power-take-off (PTO) torque based on a <span>multiterm</span> objective function. This work extends the pseudo-spectral optimal control problem to not just maximize the time-averaged absorbed power but also include measures for the surge-restraining force and PTO torque in the optimization. The objective function now includes potentially three competing terms that the optimizer must balance. Separate penalty weights are attached to the surge-restraining force and PTO control torque that can be used to tune the optimizer performance to emphasize either power absorption or load shedding. Furthermore, the analysis considers the use of a <span>nonideal</span> PTO unit to more accurately evaluate controller performance. The PTO efficiency is not directly included in the objective function but rather the penalty weights are utilized to limit the PTO torque amplitudes, thereby reducing the losses resulting from the bidirectional energy flow through a <span>nonideal</span> PTO. Results from pseudo-spectral control show that shedding a portion of the available wave energy can lead to greater reductions in structural loads, peak-to-average power ratio, and reactive power requirement.</pre>","authors":"N. Tom","topic":"7","file":"GRDPTO-07-1017.pdf","bib":"GRDPTO-07-1017.bib"},
{"paperid":"1021","title":"On numerical uncertainty of VOF-RANS simulations of wave energy converters through V&V techniques","keywords":"<p>Computational fluid dynamics (CFD) is becoming increasingly popular for wave energy applications. However, while CFD – and here we by CFD mean the standard two-phase Reynolds-Averaged Navier-Stokes (RANS) equations using the volume of fluid (VOF) approach for free surface capturing – offer much in terms of completeness of the hydrodynamic model, the solutions do include numerical uncertainties and errors. This has so far largely been overseen in the CFD studies dealing with WECs. Often a basic grid convergence study is performed to illustrate that the solutions are “grid-independent”. However, a grid-independent solution does not mean that there are no errors in the solutions. This is, of course, well known and in ship hydrodynamics there exists standard verification and validation (V&amp;V) procedures to assess the numerical uncertainty associated with the solutions.</p> <p class=IEEEParagraph>In the paper we will present estimates of numerical uncertainty for VOF-RANS simulations of wave energy converters using two different solvers: (i) the open-source finite volume solver OpenFOAM and (ii) the community based open-usage finite volume solver ReFRESCO. We present assessment of numerical error (discretization and iteration errors) as well as modelling error (geometrical and turbulence errors) for heaving point absorbers. It is shown that in general we can obtain less that 5% uncertainty of the result for properly designed meshes having less that 10 million cells.</p> <p> </p>","authors":"C. Eskilsson","topic":"5","file":"WAVHYD-10-1021.pdf","bib":"WAVHYD-10-1021.bib"},
{"paperid":"1022","title":"Design and optimization of fixed guide vanes arranged into concentric annular rows for a self-rectifying biradial air-turbine","keywords":"<p class=IEEEParagraph><span lang=EN-GB>The focus of this paper is the design and optimization of the guide-vane system of a self-rectifying biradial air turbine for use in oscillating water column systems. Since the turbine is required to be self-rectifying, there are two sets of guide vanes, placed symmetrically on both sides of the rotor, instead of a single set. The efficiency of the biradial turbine with fixed guide vanes is affected by the losses at the entry to the downstream row of guide vanes, due to the misalignment between the flow direction and the exit guide-vanes. The goal of this paper is to perform a numerical design and optimization of a fixed guide vanes system arranged into concentric annular rows so as to increase the turbine efficiency by reducing the losses at the exit guide-vane system. This concentric blade-row topology was first proposed in 2009 for an axial impulse turbine. </span>Time dependent flow calculations are performed to assess the performance and to evaluate the pressure losses for each guide-vane system configuration, due to the relatively large separated region at the exit guide vane system. Finally, the turbine operating curves are obtained by calculating the three-dimensional flow thorough the complete turbine.</p>","authors":"A. Maduro, L. Gato, J. Henriques, D. Ferreira","topic":"7","file":"GRDPTO-07-1022.pdf","bib":"GRDPTO-07-1022.bib"},
{"paperid":"1024","title":"Development of a Wave-Powered Desalination Device: Numerical Modelling","keywords":"<p class=IEEEParagraph>The lack of fresh water is an increasing world-wide problem originated due to the over exploitation and pollution of the aquifers and water reserves by industrial and housing activities. This contamination and lack of water supply, coupled with extreme poverty and lack of hygiene, provokes the proliferation of infectious diseases that can affect the population, especially in isolated communities with almost null potable water network. In coastal regions, there is an alternative for obtaining clean water from the ocean by desalination processes. The aim of this paper is to describe the first stages of development of a Wave Energy Converter which instead of generating electricity desalinates water for human use. This type of technology is still under development<sup>[1, 2, 3, 4, 5, 6]</sup>. This prototype (Fig. 1) consists of two main subsystems, a wave-powered high-pressure pump, and a reverse osmosis system. The wave-powered pump is a point-absorber type wave energy converter. Most point absorbers suffer from two key challenges: an inability to easily adjust to tidal changes and variations in wave amplitude, and an inability to efficiently resist the motion of the buoy to produce work. This device presents a solution to both of those issues through a spooled anchor line attached to a vertical load anchor. As each wave passes, the buoy rises up with the wave, and forces the unspooling of rope from the buoy. This forced unspooling drives a shaft that in turn drives positive displacement pumps, which are capable of pressurizing the water for reverse osmosis. Through numerical modelling (FLOW-3D), three different size ratios of the buoy were tested in order to evaluate its efficiency and overall hydrodynamic performance, and to find the best setup for the pumping system, giving a specific sea state associated with the Mexican Pacific Coast. These results obtained under controlled conditions, will help in the further design of the prototype in order to improve its reliability, survivability as well to reduce its maintenance costs and environmental impact.</p>","authors":"M. Verduzco-Zapata","topic":"3","file":"WAVDEV-09-1024.pdf","bib":"WAVDEV-09-1024.bib"},
{"paperid":"1025","title":"Technical R&D on Breaking Wave WEC","keywords":"Since the power density of water flow in the breaking wave is extremely high, a small size turbine will be able to harness useful power. If the device size is smaller than the vortex size (diameter of rolling flow is typically 2~3 m before the wave breaks), the flow intersecting the device becomes fairly uniform. We chose open-rotor turbine having &lt; 1 m diameter. We distribute a number of WECs right near to the shore, thus the power cable becomes much smaller than the offshore technologies. To simplify the system, the turbine is directly connected to the electric generator without using speed-up gear, which is important to eliminate risk of failure and reduce the cost. The spinning speed of the generator is as low as 300 rpm, while peak output power should reach to 12 kW, as a result, the electric generator has to have higher torque capability. To meet this request, we employ array of the neodymium iron boron (NdFeB) magnets on the rotor because of its high coercive force. In this paper, these technical R&amp;Ds will be reported more in detail.","authors":"T. Shintake","topic":"3","file":"WAVDEV-10-1025.pdf","bib":"WAVDEV-10-1025.bib"},
{"paperid":"1026","title":"Investigation of a dual-pontoon WEC type floating breakwater","keywords":"A dual-pontoon wave energy converter (WEC) type floating breakwater, which is expected to overcome the shortcoming of the single pontoon system with the narrow frequency bandwidth for the effective transmission coefficient (i.e., Tc&lt;0.5) and the capture width ratio (i.e., CWR&gt;20%), is proposed and investigated numerically and experimentally in the present study. The dual-pontoon system consists of a pair of single-pontoon WEC-type floating breakwaters. An analytical method based on linear potential flow theory is adopted to predict the hydrodynamic performance of the single-pontoon and dual-pontoon WEC type floating breakwater, separately. The frequency bandwidth for the effective transmission coefficient and the CWR is given. Results showed that the effective frequency bandwidth for the dual-pontoon system is obviously broader than that for the single-pontoon case. Note that, economically, the volume of the dual-pontoon system equals to that of the original single pontoon system. Furthermore, the corresponding experimental study is conducted to investigate the hydrodynamic performance of the WEC-type floating breakwater. The PTO system consists of the magnetic powder brake, the current controller and the torque-power sensor. The Coulomb damping force, which is often used in the case of the hydraulic PTO system, can be simulated. Experimental results also reveal that the dual-pontoon system performs more effective than the single-pontoon system in terms of the frequency bandwidth for the effective transmission coefficient and the CWR.","authors":"D. Ning, X. Zhao, J. Zang, L. Johanning","topic":"3","file":"WAVDEV-10-1026.pdf","bib":"WAVDEV-10-1026.bib"},
{"paperid":"1027","title":"Cavitation Observations of a Full- and Model-Scale Instream Turbine","keywords":"SCHOTTEL HYDRO´s commercial SIT 250 is a horizontal axis free-flow turbine. SIT 250 is a passive-adaptive, three-bladed rotor, with a planetary gearbox and asynchronous generator; the system is cooled by ambient water. The full scale SIT 250 is available in rotor diameters from 3m to 6.3m. Full-scale as well as the model-scale experimental setups are used in this study to investigate the cavitation behaviour of a SIT 250 turbine blade. During the pushing tests also pressure pulse measurements and cavitation observations were carried out to determine the cavitation behaviour of the full-scale blade for different operating points. Detailed cavitation observation is presented for the model scale cavitation tunnel tests. This includes the cavitation inception and the various cavitation types, as they occurred for different tip speed ratios. Due to the ambient conditions in Rotterdam harbour only a limited amount of data is available from the full-scale tests. However a cavitation inception bucket vs. tip speed ratio was derived and compared to the model-scale tests.","authors":"R. Starzmann, S. Bischof","topic":"4","file":"TIDDEV-07-1027.pdf","bib":"TIDDEV-07-1027.bib"},
{"paperid":"1028","title":"Development of a methodology for collaborative control within a WEC array","keywords":"<!-- p { margin-bottom: 0.25cm; direction: ltr; color: rgb(0, 0, 0); line-height: 120%; }p.western { font-family: Times New Roman,serif; font-size: 12pt; }p.cjk { font-family: SimSun,宋体; font-size: 12pt; }p.ctl { font-family: Times New Roman,serif; font-size: 12pt; }a:link {  } --> <p style=text-indent: 0.38cm; margin-bottom: 0cm; line-height: 100%; lang=en-AU><span style=font-size: x-small;>The work discussed here is aimed at applying the optimal control on a WEC in an array by using state informations retrieved from the other WECs of the array. The expression of the optimal controller is well known from the linear system modelling but it is not directly achievable as its impulse response is not causal. </span><span style=font-size: x-small;>The principle of the method is to get close to the optimal control of a WEC array by substituting the excitation force forecast by a forecast of the optimal velocity of the controlled bodies deduced from the velocity of the other bodies. In this way, a forecast of the state vector of the controlled WEC is obtained which solve the non-causal issue of the optimal controller. The results obtained with this control strategy have confirmed the near-optimal nature of the control. The velocity of the controlled bodies appears to be synchronised with the excitation force and the energy recovered is far higher than the energy retrieved with a passive PTO.</span></p>","authors":"P. Meunier","topic":"7","file":"GRDPTO-08-1028.pdf","bib":"GRDPTO-08-1028.bib"},
{"paperid":"1029","title":"Spectral wave models sensitivity to boundary conditions and wind forcing","keywords":"<p>The characterisation of wave energy resources is largely done from hindcasts, using long-term predictions of spectral wave models. These models prove to be sensitive to both wind forcing and open boundary conditions, but to a different level depending on the domain size and configuration. State-of-the-art spectral models offer a range of possible specifications for both wind forcing and boundary conditions.</p><p>The model predictions sensitivity to various boundary conditions and wind forcing is investigated from a series of test applying SWAN on a continental shelf model. The response of the model is scrutinised through intercomparison of time series predictions, one-dimensional and two-dimensional energy spectra at various key locations, and with available monitoring data. The study evaluates in particular the effect of boundary conditions specification on the predictions for different wind and wave configurations, and its impact on wave energy resource assessment.</p>","authors":"P. Gleizon","topic":"1","file":"WAVRES-PP-1029.pdf","bib":"WAVRES-PP-1029.bib"},
{"paperid":"1030","title":"Far-field effects by arrays of oscillating wave surge converters and heaving point absorbers: a comparative study","keywords":"<p class=IEEEParagraph>The objective of this paper is to illustrate the far-field effects of a small array of heaving point absorbers and a small array of OWSCs using a recently-developed one-way coupling methodology between the Boundary Element Method (BEM) solver Nemoh and the wave propagation model MILDwave.</p>The two WEC arrays are modelled for different regular waves of varying periods. The difference in the effects between the surging and heaving WECs are quantified. Furthermore a sloping bathymetry will be modelled to study the influence of the bathymetry on the far-field effects for the different type of WECs.","authors":"G. Verao Fernandez","topic":"5","file":"WAVHYD-10-1030.pdf","bib":"WAVHYD-10-1030.bib"},
{"paperid":"1031","title":"Optimisation of control algorithm for tidal turbines with consideration of wave effect","keywords":"<p class=IEEEParagraph>In the tidal energy sector, horizontal axis tidal turbine configurations dominate the technologies under development. Most horizontal axis turbines incorporate rotor blades, a speed increaser gearbox and a generator to convert the mechanical rotation into electrical energy.</p> <p class=IEEEParagraph>Variable speed turbines often employ active pitch control and generator torque control to maximise energy yield at different tidal flow speeds.</p> <p class=IEEEParagraph>These turbines, just like wind turbines, are subject to varying flow conditions brought about by turbulence and vertical shear profiles of the flow. However, unlike wind applications, wave actions should also be considered; wave actions often increase the variation and complexity in tidal flow fields and lead to sub-optimal turbine power capture, thus warranting further study.</p> <p class=IEEEParagraph>In this paper, the development of a two-mass model of the tidal turbine is presented. The model represents the tidal turbine dynamics. Torque only load cases are used to compare the outputs from the two-mass model with and without consideration of wave effect.</p> Using the result from this comparison, an optimisation procedure for the tidal turbine controller is suggested which can increase the energy production of a tidal turbine.","authors":"P. McKeever","topic":"4","file":"TIDDEV-PP-1031.pdf","bib":"TIDDEV-PP-1031.bib"},
{"paperid":"1032","title":"Alteration of Shallow-Water Tides by Tidal-Stream Turbines and Implications for Transport Processes","keywords":"<p>The work outlined in this abstract is comprised of two elements, an analytical element and a numerical modelling element. In the analytical element, the non-linear terms in the 1-dimensional Navier-Stokes equation for a uniform, rectangular channel, are expanded for a monoharmonic and biharmonic tide, for the baseline case, and the case where tidal-stream turbines (TSTs) are deployed in the channel. The later expansion illustrates that both odd and even shallow-water harmonics are impacted by TSTs. Order of magnitude arguments are then used to estimate the size of array required to match the effect of friction in the channel, and the impact the impact that this size array would have on suspended and bed load transport. In the numerical modelling element, a model of the Pembrokeshire coast, including Ramsey Sound and St. David’s Head is developed (using FVCOM). This model is used to explore the impact of bathymetry, TSTs and a constant/variable thrust coefficient on the shallow water tide.</p>","authors":"D. Potter","topic":"9","file":"ENVIRO-04-1032.pdf","bib":"ENVIRO-04-1032.bib"},
{"paperid":"1035","title":"Influence of the wave dispersion phenomenon on the flicker generated by a wave farm","keywords":"<p>The inherently fluctuating nature of waves may be reflected to some extent in the power output of wave energy converters (WECs). These fluctuations can induce voltage fluctuations which can potentially generate flicker. Hence, wave farm managers will be required to demonstrate that their farm is compliant with grid codes and similar regulations, in order to be granted grid connection. This is usually performed through grid impact assessment studies by means of numerical power system simulators. However, in many studies, the electrical power output of a wave farm is calculated as the sum of identical power profiles corresponding to a single WEC, each shifted by a random time delay. Hence, this approach does not take into account the wave dispersion phenomenon nor the hydrodynamic interactions between the WECs. A comparative study was performed, and is presented in this paper, for assessing the validity of neglecting the influence of the wave dispersion phenomenon on flicker. This study is expected to contribute in defining the required level of hydrodynamic detail necessary for simulating the output power of a wave farm when it is to be used for flicker analyses.</p>","authors":"A. Blavette, T. Kovaltchouk, F. Rongère, M. Jourdain de Thieulloy, P. Leahy, B. Multon, H. Ben Ahmed","topic":"7","file":"GRDPTO-08-1035.pdf","bib":"GRDPTO-08-1035.bib"},
{"paperid":"1036","title":"Tidal Energy Yield Uncertainties: Learnings from the Wind Energy Industry","keywords":"<p class=IEEEParagraph>The wind energy industry is approximately 30 years ahead of the tidal stream industry. Experience has shown that wind resource assessment is complex and subject to inherent uncertainty. There is an historic tendency to overestimate wind farm performance which adversely affects investment, impacting on sector growth. Nowadays, wind resource assessment methods allow developers and investors to determine the uncertainty in project return estimates. As the tidal stream industry moves towards array development, similar approaches are needed to evaluate uncertainty and minimise risk.</p><p class=IEEEParagraph>This paper proposes a transfer of existing experience of estimating uncertainties from the established processes within the wind energy industry to the nascent tidal stream energy industry, based on similarities in approaches to calculating the annual energy yield for both industries. In many cases, the uncertainties within an energy yield are difficult to quantify at this early stage in the development of the marine industry. Uncertainty values will inevitably decrease in time with greater validation from array deployments. However there are many lessons that the tidal industry can learn from past wind experience. Understanding how to reduce uncertainties around energy yield assessments is the most effective way to increase investor confidence in the growing marine sector.</p>","authors":"R. Clayton, R. Fahey, A. Mortimer, H. Smith, A. Borthwick, Q. Xiao","topic":"2","file":"TIDRES-04-1036.pdf","bib":"TIDRES-04-1036.bib"},
{"paperid":"1037","title":"Improving reliability in a sea of risk","keywords":"<p class=IEEEParagraph>The Reliability in a Sea of Risk (RiaSoR) project addresses the need to learn lessons on the key engineering challenges that underpin the reliability and future Levelised Cost of Energy reductions of emerging wave and tidal technology. RiaSoR brings together three European research and testing sites from Scotland, England and Sweden in order to develop industry approved reliability testing practices. These practices will be applied by the research and testing sites, ensuring consistency and robustness of testing to demonstrate reliability across wave and tidal technologies.</p> <p class=IEEEParagraph>The Variation Mode and Effect Analysis (VMEA) methodology is used in other sectors such as the automotive and aerospace industries. This project has created a marine VMEA version. The reliability testing practices using the marine VMEA at present focus on structural, electrical and support systems (moorings and foundations), as these are principal parts across all wave and tidal devices.</p> <p class=IEEEParagraph>This paper presents marine VMEA methodologies developed via the RiaSoR project aiming to enhance the testing programmes and support the ongoing review and establishment of reliability standards. The methodologies will bring developers closer to the ultimate aim of reducing: health, safety and environmental risks; technological risks; and O&amp;M costs, all which will lower the sector’s LCoE.</p> <p> </p>","authors":"P. McKeever","topic":"4","file":"TIDDEV-07-1037.pdf","bib":"TIDDEV-07-1037.bib"},
{"paperid":"1038","title":"Validation of the U-Oscillating Water Column model by full-scale experimental data","keywords":"<p class=IEEEParagraph><span lang=EN-AU>The development of the U-Oscillating Water Column (U-OWC) wave energy converter was pursued in recent years. Boccotti proved that the device is able to reach the resonance condition in random sea states without the need of phase control devices. The proposed theoretical model was based on the unsteady Bernoulli equation for real fluids incorporating a representation of the head losses based on the typical models adopted in the open literature for steady flows. <a title=Malara, 2017 #2299 href=#_ENREF_4><!--[if supportFields]><span style=color:windowtext;text-decoration:none;text-underline:none _mce_style=color: windowtext; text-decoration: none; text-underline: none;><span style=mso-element:field-begin _mce_style=mso-element: field-begin;></span><span style=mso-spacerun:yes _mce_style=mso-spacerun: yes;> </span>ADDIN EN.CITE &lt;EndNote&gt;&lt;Cite AuthorYear=&quot;1&quot;&gt;&lt;Author&gt;Malara&lt;/Author&gt;&lt;Year&gt;2017&lt;/Year&gt;&lt;RecNum&gt;2299&lt;/RecNum&gt;&lt;DisplayText&gt;Malara&lt;style face=&quot;italic&quot;&gt; et al.&lt;/style&gt; [4]&lt;/DisplayText&gt;&lt;record&gt;&lt;rec-number&gt;2299&lt;/rec-number&gt;&lt;foreign-keys&gt;&lt;key app=&quot;EN&quot; db-id=&quot;ewp92vawqzpfe8ea5w2vv9fxte5x0aavv2ze&quot;&gt;2299&lt;/key&gt;&lt;/foreign-keys&gt;&lt;ref-type name=&quot;Journal Article&quot;&gt;17&lt;/ref-type&gt;&lt;contributors&gt;&lt;authors&gt;&lt;author&gt;Malara, G.&lt;/author&gt;&lt;author&gt;Romolo, A.&lt;/author&gt;&lt;author&gt;Fiamma, V.&lt;/author&gt;&lt;author&gt;Arena, F.&lt;/author&gt;&lt;/authors&gt;&lt;/contributors&gt;&lt;titles&gt;&lt;title&gt;On the modelling of water column oscillations in U-OWC energy harvesters&lt;/title&gt;&lt;secondary-title&gt;Renewable Energy&lt;/secondary-title&gt;&lt;/titles&gt;&lt;periodical&gt;&lt;full-title&gt;Renewable Energy&lt;/full-title&gt;&lt;/periodical&gt;&lt;pages&gt;964-972&lt;/pages&gt;&lt;volume&gt;101&lt;/volume&gt;&lt;dates&gt;&lt;year&gt;2017&lt;/year&gt;&lt;/dates&gt;&lt;urls&gt;&lt;/urls&gt;&lt;/record&gt;&lt;/Cite&gt;&lt;/EndNote&gt;<span style=mso-element:field-separator _mce_style=mso-element: field-separator;></span></span><![endif]--><span>Malara<em> et al.</em> [2017]</span><!--[if supportFields]><span style=color:windowtext; text-decoration:none;text-underline:none _mce_style=color: windowtext; text-decoration: none; text-underline: none;><span style=mso-element:field-end _mce_style=mso-element: field-end;></span></span><![endif]--></a> showed that this specific model leads to overestimation of the water column oscillations in the time domain. For overcoming this limitation, a model involving a representation of unsteady head losses was proposed and proved to be more reliable by processing a number of experimental records.</span></p> <p class=IEEEParagraph><span lang=EN-AU>A full scale U-OWC device has been constructed in the port of Civitavecchia (Italy), composed by 124 independent chambers distributed over 17 caissons. The monitoring activity is currently under progress. </span></p> <p class=IEEEParagraph><span lang=EN-AU>This paper considers the problem of validating the dynamic model used for describing the water column oscillations of the U-OWC. Considering the fact that current models were validated only against data from small-scale models, the paper overcomes this limitation by employing the data recorded via the full-scale U-OWC.</span></p>","authors":"F. Arena","topic":"3","file":"WAVDEV-10-1038.pdf","bib":"WAVDEV-10-1038.bib"},
{"paperid":"1041","title":"Development of a low head tidal turbine Part 1: CFD simulations, design and optimization","keywords":"<br /><table class=data width=100%><tbody><tr valign=top><td class=value><p>An innovative turbine concept is being reviewed in the course of the Eurostars research project Safe*Coast. It proposes to install a turbine in a reversible cylinder in order to allow for four-quadrant operation. To evaluate the feasibility of the concept, the authors designed a compact low head axial tidal turbine and simulated its characteristics.</p><p>This paper presents the methods used in the design and optimization process of the turbine. The paper also shows numerically obtained turbine characteristics and a hill chart as well as cavitation limits. High efficiencies as well as high unit discharge in turbining as well as pumping mode and safe cavitation characteristics are the major requirements of the turbine. The final design after optimization is a three bladed axial turbine with adjustable guide vanes and a rim generator.</p><p>Symmetrical inlet and outlet geometries and the relatively compact layout permit to integrate the turbine in a reversible cylinder.</p><p>The simulation results are very favourable and indicate that all the relevant design criteria can be satisfied. The project partners thus decided to take the next step and build a model of the turbine for physical testing in order to verify the results and to conduct further investigations.</p></td></tr></tbody></table>","authors":"S. Hötzl, T. Schechtl, P. Rutschmann, W. Knapp","topic":"4","file":"TIDDEV-08-1041.pdf","bib":"TIDDEV-08-1041.bib"},
{"paperid":"1042","title":"Return Periods of Extreme Loads on Wave Energy Converters","keywords":"<p class=IEEEParagraph>Much of the work on extreme loads on wave energy converters published to date has focused on the calculation of loads in response to a specific set of environmental conditions. Little consideration has been given to how to calculate the return periods associated with a given load value. Existing procedures, such as the ‘environmental contour’ method, where loads are calculated for a range of sea states with equal joint probability of occurrence, provide no information about the return periods associated with the loads observed in these sea states. This paper presents a method to combine the short-term distribution of loads within a sea state with the long-term distribution of sea states, and calculate return periods of extreme load values. A time series of metocean data (waves, currents, tides, etc.) is combined with the model for loads conditional on sea state, to produce a time series of loads. A statistical analysis is then conducted on this load time series to calculate return periods of storms where the maximum load exceeds a given value.</p>","authors":"E. Mackay","topic":"3","file":"WAVDEV-10-1042.pdf","bib":"WAVDEV-10-1042.bib"},
{"paperid":"1043","title":"Wake generated downstream of a vertical axis tidal turbine","keywords":"<p lang=en-AU>The flow around a comprised of three NACA 0018 blades rotating at tip speed ratio of 2 is simulated using the Large-Eddy Simulation (LES) based in-house code Hydro3D. The results of the wake developed downstream of the device are compared with experimental data and RANS results. The eddy-resolving nature of LES allows to resolve the energetic large-scale flow structures present in the flow together with accurate power predictions. The complex blade-vortex interaction, characterised by the dynamic stall which dominates the blades’ dynamics, is identified as one of the major challenges in the simulation of VATTs. The rotation of the turbine blades and their interaction with the oncoming turbulent flow induces large-scale flow structures that dominate both the turbine wake and blade forces.</p><p lang=en-AU> </p><p lang=en-AU> </p>","authors":"P. Ouro","topic":"4","file":"TIDDEV-08-1043.pdf","bib":"TIDDEV-08-1043.bib"},
{"paperid":"1044","title":"What does it Really Cost? – Understanding, Comparing and Applying Financial Metrics","keywords":"<p><span style=font-family: Calibri; font-size: small;>Last year 286 Billion dollars was spent on new renewable projects around the world and estimates are that 85 Trillion of renewable assets will be under management by 2030.</span></p> <p><span style=font-family: Calibri; font-size: small;>Although onshore wind has dominated much of this certainly in Europe, there are growth opportunities in Wave and Tidal Energy.</span><span><span style=font-family: Calibri; font-size: small;> </span></span><span style=font-family: Calibri; font-size: small;>The forecasts show that these up and coming markets have growth potential well beyond the current status quo.</span><span><span style=font-family: Calibri; font-size: small;> </span></span><span style=font-family: Calibri; font-size: small;>The trend in private equity is for Environmental, Social and Governance investments demanding double bottom line. The Wave and Tidal sector is well positioned to meet this demand.</span></p> <p><span style=font-family: Calibri; font-size: small;>To exploit this potential will require an agility and responsiveness right across the renewables supply chain to quickly identify, quantify, optimise and capitalise each opportunity.</span></p> <p><span style=font-family: Calibri; font-size: small;>Now in the renewables sector, with the advent of secure cloud based services, we can take our cues from others, change our ways and move towards better and faster analytics.</span><span><span style=font-family: Calibri; font-size: small;> </span></span><span style=font-family: Calibri; font-size: small;>This has already happened in accounting, insurance, CRM and is happening in banking, agricultural and transport. </span></p> <p><span style=font-family: Calibri; font-size: small;>There is an opportunity for a suite of sector specific techno and financial tools that will enable</span><span><span style=font-family: Calibri; font-size: small;> </span></span><span style=font-family: Calibri; font-size: small;>decision support right across the supply chain, from product developers, project developers, consultants, governments, utilities, banks and fund managers.</span><span><span style=font-family: Calibri; font-size: small;> </span></span><span style=font-family: Calibri; font-size: small;>Transparency and standards will reduce risk and inspire confidence all of which make investment much more sustainable.</span></p> <p><span style=font-family: Calibri; font-size: small;>We will present all the background as well as referencing all the drivers and forecasts.</span><span><span style=font-family: Calibri; font-size: small;> </span></span><span style=font-family: Calibri; font-size: small;>As Exceedence, we will show some of what we have been doing in developing one part of the solution as well as showing other trends and examples that we have seen along our journey. </span><span><span style=font-family: Calibri; font-size: small;> </span></span><span style=font-family: Calibri; font-size: small;>We will show our cloud based tools some of which will be free to use for wave and tidal product and project developers </span><span><span style=font-family: Calibri; font-size: small;> </span></span><span style=font-family: Calibri; font-size: small;>.</span><span><span style=font-family: Calibri; font-size: small;> </span></span><span style=font-family: Calibri; font-size: small;>We are working with Microsoft and other multinationals to bring blue chip software solutions to the sector in order to enable trust and confidence in the costs and the financial models.</span></p>","authors":"R. Alcorn","topic":"10","file":"ECONOM-03-1044.pdf","bib":"ECONOM-03-1044.bib"},
{"paperid":"1045","title":"The Importance of a Multi-Method Monitoring Approach to Assess the Effects of Anthropogenic Activity on Marine Mammals","keywords":"<p class=IEEEParagraph><span lang=EN-AU>Regulators are under increasing pressure to ensure adequate protection of sensitive marine species in the face of multiple economic drivers for development in the marine industry. We present a study on the impacts of anthropogenic activity on marine mammals in an area of high species diversity on the west coast of Ireland. During the construction of a gas pipeline from an offshore gas field in Broadhaven Bay, Co. Mayo in northwest Ireland, a year-round marine mammal monitoring programme was undertaken over a period of eight years (2009-2016), using both visual and acoustic monitoring techniques. Noise generating activities, in this case associated with the oil and gas industry, are also applicable to the marine renewable energy industry and, in the absence of commercial scale marine renewable energy projects in Irish waters, much can be learned about potential impacts on the marine environment from existing industries such as oil and gas exploration and production. We assessed the potential impacts of construction-related (noise generating) activity and vessel traffic on the occurrence of harbour porpoises (<em>Phocoena phoconea</em>), a protected species under the EU Habitats Directive and compares model outputs from data solely from visual surveys to models incorporating both visual and acoustic survey data. The study demonstrated the significant added value that acoustic monitoring contributes, particularly for a species such as the harbour porpoise, which is quite often difficult to detect visually. </span></p>","authors":"D. Maldini, A. Foley, R. Culloch, R. Pinfield, M. Nykänen, M. Cronin, M. Jessopp","topic":"9","file":"ENVIRO-05-1045.pdf","bib":"ENVIRO-05-1045.bib"},
{"paperid":"1047","title":"Comparison of combined wave and turbulence model with field measurements","keywords":"<p class=IEEEParagraph><span lang=EN-AU>Field measured water particle kinematics are used to validate a linear model for tidal flows, combining waves and turbulent current. Using a ‘Virtual’ Acoustic Doppler Profiler (VADP), to measure the simulated flow, direct comparisons are made between model and site kinematics recorded using Acoustic Doppler technology. </span></p>","authors":"G. Crossley, S. Parkinson, A. Alexandre, H. Smith, A. Day, D. Ingram","topic":"2","file":"TIDRES-04-1047.pdf","bib":"TIDRES-04-1047.bib"},
{"paperid":"1049","title":"Experimental investigation of the effects of oblique waves and current on the loadings and performance of tidal turbines","keywords":"<p>Tank testing of a tial turbine was conducted at FloWave to assess the effects of oblique waves and current on the performance and laoding of the turbine. Tests were performed at different wave and current angles and 3 different wave conditions.</p><p>Preliminary results are shown along with the quality check of the data.</p>","authors":"R. Martinez Mejia, G. Payne, T. Bruce","topic":"4","file":"TIDDEV-08-1049.pdf","bib":"TIDDEV-08-1049.bib"},
{"paperid":"1050","title":"Utilising GIS to assess the development potential of offshore energy on the Western European coast.","keywords":"<p>Offshore wind has become an increasingly cost competitive source of electricity with large deployments existing already and this number set to grow. The more nascent wave energy sector faces many similar challenges to its older brother. The current deployment initiatives for wave and wind are primarily focused on relatively shallow water depths around the more accessible coastlines of the resource rich areas within the EEZ (European Economic Zone). In particular it is understood that the North Sea and Atlantic coastline have the highest energy potentials, as well as being identified as the most fertile for technology development.</p> <p>The trade-off is between the costs of development due to the engineering challenges posed and the resource potential.  As the engineering competence increases and costs reduce the previously ‘unavailable’ sites, due to high costs, are becoming potentially exploitable.</p> <p>Therefore, this research aims to use a series of engineering models coupled with a GIS (geographical information system) to assess the current potential for development at a full array scale. This will take into account the present infrastructure, with detailed regards to the requirements for transmission level grid connectivity and port requirements. The research will then assess the engineering technology and resource currently available to establish the locations and size of space for deployment that is currently available. The GIS models will be used to illustrate a series of development tranches with levels of attractiveness.</p> <p>This research will highlight the relative benefits and influences in cost between the types of energy. It will also show the need to improve or pre-emptively develop infrastructure, develop new engineering practise or refine current methods in order to bring technologies to array scale and contribute to a cleaner cost effective energy mix. <br /> <br /></p> <p class=IEEEParagraph> </p> <p class=IEEEParagraph> </p>","authors":"T. van Lanschot","topic":"10","file":"ECONOM-PP-1050.pdf","bib":"ECONOM-PP-1050.bib"},
{"paperid":"1051","title":"A Study of System Dynamics for a Kuroshio Turbine System","keywords":"In Taiwan, the floating Kuroshio turbine (FKT) system is under development as shown in Fig. 1. It is a system composed of four main parts, the foil float, the nacelle with a pair of turbines, the vertical supports, and the cross beam. One of the issues which need be studied is dynamics of system moored in deep sea regions. To capture the system dynamic motion, we integrate several commercial and in-house packages. The system buoyancy and weight and their centers were estimated using the Rhino software. The system hydrodynamic coefficients were obtained through WAMIT, system drag coefficient through FLUENT, turbine propulsive force through lifting surface code, and system dynamics through OrcaFlex. Several scenarios in association with the deployment, effects of ever-changing ocean environments, and unexpected system failures were studied. They include sudden failure of a turbine, change of flow direction, effects due to mooring line system, system resonance, and random incoming flows.","authors":"J. Wu, J. Chen, C. Hsin, F. Chiu","topic":"6","file":"TIDHYD-05-1051.pdf","bib":"TIDHYD-05-1051.bib"},
{"paperid":"1054","title":"Test Results of a Twin-rotor Radial-inflow Air Turbine for OWC Wave Energy Converters","keywords":"<p>One main problem with OWC wave energy converter is the energy conversion efficiency of the air turbine. The reciprocating air flow generated by the waves does not allow conventional air turbines to be used unless rectifying valves are employed. Alternatively, rectifying air turbines have been developed for converting the pneumatic power into mechanical power, but they normally have limited energy conversion efficiency. Results of numerical modelling of the newly invented twin-rotor turbine has shown superb performance under time-varying flow.</p> <p>The turbine is characterized by a twin rotor, i.e. two rows of rotating blades axially offset from each other, mounted on the same shaft, complemented by corresponding guide vanes, as in a conventional axial-flow or radial-flow turbine. The reciprocating air flow takes place as unidirectional flow alternately through one or the other bladed set. This is made possible by a double set of curved ducts manifold and axisymmetric connecting ducts and by a two-position axially-sliding cylindrical valve.</p> <p>A 0.5m rotor diameter turbine model was built within the framework of the European project WETFEET. The paper reports the design and construction of the prototype, and its dry testing in at IST, simulating the oscillating flow induced by irregular waves.</p>","authors":"L. Gato, B. Lopes, A. Carrelhas, J. Henriques, A. Falcão, J. Borges","topic":"7","file":"GRDPTO-08-1054.pdf","bib":"GRDPTO-08-1054.bib"},
{"paperid":"1057","title":"Design Envelope Approach for Assessing Environmental Impacts of Tidal Developments. Fair Head Tidal Case Study","keywords":"<p class=IEEEHeading2>This paper discusses the design envelope approach and specific Project Design Criteria developed for the Fair Head Tidal (FHT) Project.</p> <p class=IEEEHeading2>The ES was submitted for gatecheck in December 2016 in support of an application for consent for the 100MW FHT Project a proposed tidal energy development, covering an area of approximately 4.2km2, less than 1km off the North Antrim Coast in Northern Ireland.</p><p class=IEEEHeading2>The principle of the Design Envelope permits the developer to provide broad or alternative project engineering and construction parameters, of which one or a subset of the scenarios or parameters will ultimately be constructed.</p> <p class=IEEEHeading2>The design that could result in the most significant impact may be different for different environmental receptor types. Understanding the cause and effect specific to each receptor leads to the definition of the appropriate “Project Design Criteria” for that receptor and, therefore, identifies the ‘realistic worst case’. Taking the ‘realistic worst case’ scenario, it can be assumed if no significant impact is demonstrated at the ‘realistic worst case’, then no significant impact is likely for any scenario.</p>","authors":"C. McGrath","topic":"9","file":"ENVIRO-PP-1057.pdf","bib":"ENVIRO-PP-1057.bib"},
{"paperid":"1059","title":"Optimisation of Tidal Range Schemes","keywords":"<p>There has been much interest in Marine Renewable Energy (MRE) schemes in the past decade. There have been several proposals to build a number of Tidal Range Schemes (TRSs), such as tidal lagoons and barrages, around the UK, and globally. It is estimated that the tidal range resource in the UK will be up to 30 GW (<a title=DECC, 2013 #7 href=#_ENREF_1><em>1</em></a>) and the independent Hendry Review commissioned by the UK government recommended  construction of the world’s first tidal lagoon in Swansea Bay, in January 2017. One of the potential disadvantages of TRSs is their high capital cost, which consequently can lead to a high cost of electricity generation. However, TRSs have a significant advantage that they are highly predictable and the predictability of TRSs provide us with the potential of active planning and optimising the operation of such schemes, which is not possible with less predictable sources. Optimisation of the operation could potentially result in higher electricity generation and lower hydro-environmental impacts and therefore lower electricity costs which could lead to further schemes becoming economically viable. This study investigates optimisation of TRSs and their operation. The hydro-environmental impacts of these scenarios are also considered to avoid significant adverse impacts of the optimised schemes.</p>","authors":"R. Ahmadian, J. Xue, R. Falconer, N. Hanousek","topic":"2","file":"TIDRES-04-1059.pdf","bib":"TIDRES-04-1059.bib"},
{"paperid":"1060","title":"Testing and Modeling the RTI F2 QD High Efficiency Low CapEx WEC","keywords":"RTI tank tested, its 6th generation WEC as 1 of 9 finalists (of 92 entrant teams) in the recent US DOE Wave Energy Prize Competition . RTI WEC development efforts have focused on developing a utility scale WEC (&gt; 1 MW) with an installed capital cost (CapEX) below large wind farms ($2-3 Million/MW) or at least offshore wind farms approaching $4 Million/MW. This requires wave-to-wire efficiency exceeding 50% in realistic random seas, low CapEx, and secure severe sea survivability. WEC weight and CapEx, like boats and other marine vessels, are primarially determined by total WEC vessel volume. Low CapEx/MW WECs, therefore, must intercept maximum energy containing wave front per unit WEC vessel volume and capture a majority of that intercepted wave energy (both heave and surge). To accomplish this RTI has focused on WECs with one or more adjacent Elongated Wave Front Parallel surface floats deployed in deep water (where wave energy is greatest) which self-orient (weathervane) parallel to oncoming wave fronts. Such WECs are best protected from severe seas via float seawater flooding and submergence safely well below even 15 meter wave troughs and avoiding any end stops. The RTI F2 QD, using hydrodynamic principles similar to the U.of Edinburgh Salter Duck and Sloped IPS buoy, achieves comparable capture efficiencies while utilizing about 1/4 of the Duck's vessel volume, weight, and CapEx.","authors":"J. Rohrer","topic":"3","file":"WAVDEV-11-1060.pdf","bib":"WAVDEV-11-1060.bib"},
{"paperid":"1065","title":"Development of a Multi-Rate Wave-to-Wire Modelling Tool","keywords":"<p><span style=color: #000000;><span style=font-family: Verdana, Arial, Helvetica, sans-serif;><span>Due to the nature of wave energy extraction, which tends to operate at low frequencies with large time periods, it can be difficult to model the electrical aspects of the PTO and control system with high fidelity in a reasonable amount of </span></span></span><span style=color: #000000;><span style=font-family: Verdana, Arial, Helvetica, sans-serif;><span>computation</span></span></span><span style=color: #000000;><span style=font-family: Verdana, Arial, Helvetica, sans-serif;><span> time. This is due to the </span></span></span><span style=color: #000000;><span style=font-family: Verdana, Arial, Helvetica, sans-serif;><span>tendency</span></span></span><span style=color: #000000;><span style=font-family: Verdana, Arial, Helvetica, sans-serif;><span> of electrical systems to operate at much higher frequencies and lower time periods between events which must be captured by any transient simulation. The result is that time consuming hydrodynamic computations must be performed more </span></span></span><span style=color: #000000;><span style=font-family: Verdana, Arial, Helvetica, sans-serif;><span>frequently</span></span></span><span style=color: #000000;><span style=font-family: Verdana, Arial, Helvetica, sans-serif;><span> than required, if the </span></span></span><span style=color: #000000;><span style=font-family: Verdana, Arial, Helvetica, sans-serif;><span>electrical</span></span></span><span style=color: #000000;><span style=font-family: Verdana, Arial, Helvetica, sans-serif;><span> system is to be simulated at the same time in detail. In this paper we describe a multi-rate method of simulating the system, loosely coupled via forces, positions and velocities where multiple smaller time steps are taken for subsystems in between the larger time steps suitable for the hydrodynamic calculations. This allows reduced computation times while retaining high fidelity. It also allows the application of different solver types to the different simulation components which can also significantly improve performance versus using the same solver type for the entire system. Details of model implementation and some initial reference results and interesting outputs are presented.</span></span></span></p>","authors":"R. Crozier, M. Mueller","topic":"7","file":"GRDPTO-08-1065.pdf","bib":"GRDPTO-08-1065.bib"},
{"paperid":"1067","title":"Study on unsteady dynamic performance of impulse turbine for the OWC wave energy converter","keywords":"<p class=ieeeparagraph><span lang=EN-US>The impulse turbine is an essential component of an Oscillating Water Column wave energy converter, which can convert the low-pressure pneumatic energy to the mechanical shaft power. It has wider range of flow coefficient, better self-starting performance, no stalling condition and lower working noise. The above characteristics make the impulse turbines popularly used for recent OWC plants.</span></p> <p class=ieeeparagraph><span lang=EN-US>The work takes the impulse turbine as the investigating object, and aims at studying the operating discipline under the unsteady flow with the experimental method. A piston apparatus was designed and manufactured to generate the oscillating air flow. And the effects of the peak flow velocity and generator loading on self-starting and power output characteristics of impulse turbine are studied with series of experiments. The results were shown and analysed with the time history curves of rotational velocity, the torque, the pressure drop, and the output power. In addition, a 3D transient numerical model of impulse turbine is established through the secondary development of the CFD code FLUENT. The sliding mesh model and the User Defined Function are taken as the principle technology in the numerical calculations. This model has been validated using the unsteady experimental data.</span></p>","authors":"Y. Cui, Z. Liu","topic":"3","file":"WAVDEV-11-1067.pdf","bib":"WAVDEV-11-1067.bib"},
{"paperid":"1069","title":"A highly efficient and low-cost linear TFM generator for wave power","keywords":"<p>A force-dense, low-cost and highly efficient direct driven linear transverse flux generator specialized for low speeds is being developed at KTH Royal Institute of Technology in Stockholm, Sweden, and a prototype will be constructed during 2017. The prototype is aimed for a damping force of 200 kN, a stroke length of 4 meters and an efficiency of around 98% in the speed range 0.7-3 m/s. The design procedure is very demanding, but it is anyhow expected that the assembly process will be fairly low cost if the mechanical design proves to be appropriate. Maintenance intervals will hopefully be long with the current bearing design, and we aim for maintenance free operation although it is very hard to predict the maintenance needs of the machine. In this text, the current status of the construction is given as well as the main characteristics of the machine.</p>","authors":"A. Hagnestål, E. Guldbrandzén","topic":"7","file":"GRDPTO-08-1069.pdf","bib":"GRDPTO-08-1069.bib"},
{"paperid":"1072","title":"Improvements of Wave Energy Resources in Finite Water Depths","keywords":"<p>In developing wave energy from seas, nearshore areas with finite water depths (50m or less) are frequently considered, and wave buoys have been deployed to measure the waves in those places for collecting long-term information for assessing wave resources and distributions. Frequently, the existing practice for those wave measurements are often given using the so-called wave scatter diagrams, in which the sea states are characterised by the wave parameters including the measured significant wave heights and wave statistic periods, such as the energy period, <em>T<sub>e</sub></em>, the spectral mean period, <em>T</em><sub>01</sub> and the zero upcrossing period <em>T</em><sub>02</sub>, whilst the detailed spectra (shapes and distributions) are unavailable. This may not be ideal when the limited information is only available for wave energy resource assessment, especially in the cases of finite water depths, when the effect of water depth on the wave energy resource assessment becomes important.</p>","authors":"W. Sheng, H. Li","topic":"1","file":"WAVRES-04-1072.pdf","bib":"WAVRES-04-1072.bib"},
{"paperid":"1075","title":"Comparisons of Self-rectifying Air Turbines for OWC Wave Energy Converters","keywords":"<p>The oscillating water column (OWC) is a major class of wave energy converter that has been object of extensive research and development effort over many years, including the deployment of prototypes into the sea. Unless rectifying valves are used, the turbines are self-rectifying. Several types of such special turbines have been developed. The axial-flow Wells turbine, invented in the mid-1970s, is the most popular self-rectifying turbine, but other types have also been proposed, studied and used. The paper presents a comparative study of the performance, suitability and limitations of the various types of air turbines to different OWC applications and energy levels of the local wave climate. The study is based on available information on the aerodynamic performance of the various types of air turbines, which is used in theoretical/numerical simulations of the whole wave energy conversion chain in representative wave climates. Constraints are introduced, especially maximum allowed rotational speed (or rotor blade tip speed), which is known to affect especially the Wells turbines. The comparisons include efficiency, turbine size, flow rate and rotational speed control, suitability to latching control, and rough estimates of turbine cost. Reference is made to turbine aerodynamic noise.</p>","authors":"A. Falcao, J. Henriques, L. Gato","topic":"7","file":"GRDPTO-09-1075.pdf","bib":"GRDPTO-09-1075.bib"},
{"paperid":"1077","title":"Power-take-off Control in a Scaled Experiment of a Point Absorber Wave Energy Converter","keywords":"<p class=IEEEParagraph><span lang=EN-GB><span style=font-family: Times New Roman; font-size: x-small;>This paper investigated the design of a power-take-off control system for the study of a model scaled point absorber wave energy converter in a wave flume experiment, where the scale of the experiment must be kept low to reduce the blockage effects of the buoy in the wave flume. In keeping the model small, the parasitic loss in the experimental set-up due to friction in the PTO was significant in comparison to the power absorption capability of the model scaled wave energy converter, and consequently, the power absorbed by the wave energy converter was significantly underestimated. To address this major limitation, a simple friction compensation algorithm was tested in the power-take-off control. Experimental results were benchmarked against those obtained from potential wave theory solvers for the understanding of the efficacy of the proposed method. It was evident that the proposed power-take-off control provided high fidelity results under both regular and irregular incident waves as long as the dynamic power-take-off control force was able to overcome the friction force in the experimental set-up.</span></span></p><p class=IEEEParagraph><span style=font-family: Times New Roman; font-size: small;> </span></p>","authors":"B. Ding, N. Sergiienko, B. Bleckly, L. Souza Pinheiro da Silva, B. Cazzolato, M. Arjomandi","topic":"3","file":"WAVDEV-11-1077.pdf","bib":"WAVDEV-11-1077.bib"},
{"paperid":"1078","title":"A numerical study of wave power maximisation based on active control and mechanical design","keywords":"<p>It is well-known and widely confirmed by many experiments and theories that wave energy converters (WEC) have high efficiency for extracting more energy in resonance with waves. So it is generally desired to use resonance property to improve the efficiency of WEC. To achieve this, the problems, such as fluid-solid coupling, geometric nonlinearity, irregularity of wave and so on, must be solved so to tune the device resonance with wave.</p><p>In this research, an active resonance wave energy converting technology(ARWECT) is proposed by making the device resonant with the waves, in which the converter is tuned by adjusting the internal stiffness so that the dynamic characteristics is optimized to adapt to the principal frequency of irregular wave.</p><p>The dynamic characteristic adjustment model, mainly about the computational formula of adjustable stiffness tuning values, was derived based on potential flow theory and multi-rigid-body dynamics theory.</p> <p>Some results are obtained by numerical simulation experiments, the peak vibration frequency of the pendulum is the same with the waves. The adjusting model can realize the natural vibration frequency adjustment of wave energy system accurately.</p><p> </p>","authors":"L. Mingfang, C. Yuanqi, S. Lijiao","topic":"3","file":"WAVDEV-11-1078.pdf","bib":"WAVDEV-11-1078.bib"},
{"paperid":"1079","title":"Magnetic Gear Design for an Oscillating Wave Surge Converter","keywords":"<p>This paper details the process taken in designing a magnetic gear system for an oscillating wave surge converter. The design process was undertaken using modelling tools developed by the author in XFEMM, a FEMM compatible Matlab function used for 2D analysis, and MagNet, a 3D electromagnetics field simulation software, with the design requirements specific to the Aquamarine Oyster device in terms of required torque and gear ratio. The advantages of using a magnetic gear system in place of a traditional mechanical gear are discussed and the designed system is presented showing its operational characteristics, dimensions and material quantities. The work concludes with a brief discussion of some challenges facing the proposed system and recommendations for implementation in similar devices.</p>","authors":"B. McGilton","topic":"7","file":"GRDPTO-09-1079.pdf","bib":"GRDPTO-09-1079.bib"},
{"paperid":"1080","title":"Derivation and Validation of a hindcast model incorporating wave current interaction at a tidal race site","keywords":"<p>This paper describes work that was carried out by DNV GL for DP Energy in order to characterise the wave conditions at the Fairhead Tidal Energy site ahead of development of the project. To characterise the wave conditions a wave hindcast was simulated for a 20 year period using a third generation spectral wave proprgation model SWAN. The paper focuses on the methodology and validation of the model and the relevance of the model outputs for tidal stream turbine and array design.</p><p>The results of the numerical hindcast are validated against on-site measurements taken using Acoustic Doppler instruments. A focus is placed on the uncertainties in the comparison of the model and measurement data sets. In particular the short-comings of the use of Acoustic Doppler instruments with divergent beams for the collection of wave data is discused.</p><p>The paper will act as a guide for the appropriate setup methodology and validation of wave hind casts for other tidal energy developers in order to derive appropriate site information for the design of a tidal stream array. An emphasis is placed on industry best-practise and guidelines technology and project developers should follow. The study will help outline potential sources of uncertainties that can be introduced via model inputs and the type of Acoustics instruments used to collect wave data. This will enable further research &amp; development work can build on these areas.</p>","authors":"S. Parkinson, D. Fitzgerald, G. Crossley","topic":"2","file":"TIDRES-04-1080.pdf","bib":"TIDRES-04-1080.bib"},
{"paperid":"1084","title":"Experimental Investigation into Unsteady Loads on Horizontal Axis Tidal Turbines","keywords":"<p class=IEEEParagraph>Understanding the complex nature of hydrodynamic loads on tidal turbines is important to inform the design of full scale machines. The study reported herein focuses on the experimental investigation of loads due to turbulences and waves. The tidal device considered is a generic three bladed horizontal axis turbine. The model is fitted with sensors to measure the streamwise bending moment at the root of each blade and the torque and thrust loads on the rotor. The tower of the turbine is bolted to the bottom of the flume via a six degrees of freedom load cell. Tests were carried out at the IFREMER recirculating flume in Boulogne-sur-Mer, France, with flows of turbulence intensity levels of 3 and 12%. Measured loads are analysed in the frequency domain. Difference in loads level between high and low turbulence cases are observed and can be correlated to the difference in normalised velocity spectral density of the onset flow. Measurements are also used to derive probability distributions of extreme force on the model which are  compared to similar probability distributions previously established with a 1/70 scale model. Finally the impact of the absolute angular position of the rotor on the load is investigated.</p>","authors":"G. Payne","topic":"4","file":"TIDDEV-08-1084.pdf","bib":"TIDDEV-08-1084.bib"},
{"paperid":"1085","title":"Risk-reduction through strategic investment timing: Implications for government policy","keywords":"<p><span><span style=font-size: small;>Progress toward commercial deployment of in-stream tidal energy devices and commercial arrays has met with delay, particularly in the UK and Canada. While there are many reasons, this study probes the rationale of project and technology developers that hold seabed leases for opting to delay for strategic reasons. The study consists of ten semi-structured interviews with executives and senior managers of companies in the international tidal energy industry. Themes emerging from the interviews suggest strategic timing decisions are being made and, in some cases, on a portfolio of sites, consistent with the exercise of real options. The conditions for exercising the options and implications for jurisdictions wanting to develop their tidal energy resources are discussed.</span></span></p>","authors":"S. MacDougall","topic":"10","file":"ECONOM-03-1085.pdf","bib":"ECONOM-03-1085.bib"},
{"paperid":"1087","title":"Impulse Turbine Harvesting Wave Energy: Effect of Blade Lean","keywords":"The whole oscillation water column(OWC) wave energy system faces low efficiency because of turbine's poor performance.In this article, the steady and unsteady behavior of an impulse turbine  of 0.3m diameter with two rows of fixed guide vanes used in OWC is numerically simulated in commercial CFD code Ansys CFX ®v.15.0 .The numerical simulation is done for steady case and the results are validated with existing experimental data after grid independency check and extended to study unsteady running characteristics under sinusoidal flow for two wave cycles.Hysteresis characteristics of this turbine under sinusoidal flow are studied for different wave period.The effect of blade leaning is numerically studied for six different leaning angles using steady analysis. Leaning angle at which maximum relative efficiency occurs is found to be 10°.Flow physics for this performance increase is analyzed using numerical results obtained. Unsteady performance of this turbine with 10° leaning angle is also studied to account for real sea scenario.","authors":"R. B","topic":"3","file":"WAVDEV-12-1087.pdf","bib":"WAVDEV-12-1087.bib"},
{"paperid":"1088","title":"Non-linear Responses of a Point Absorber Wave Energy Converter","keywords":"<p class=IEEEParagraph>Understanding the dynamics of wave energy converters (WECs) under operational and extreme wave conditions is crucial. In this paper, we investigate non-linear responses of the CETO WEC, which is a buoyant submerged taut-moored point absorber WEC developed by Carnegie Wave Energy.</p> <p class=IEEEParagraph>Results from model-scale laboratory experiments involving regular wave tests, long-duration irregular random wave tests as well as short-duration deterministic focused wave groups are presented.</p> <p class=IEEEParagraph>Transverse (sway motion) instability of the buoy in uni-directional wave conditions is studied. The buoy motion measurements from the regular wave tests are used to validate a simple mathematical model for the buoy dynamics with Mathieu-type instability in sway. The time-varying restoring spring force coefficient in the Mathieu equation is due to non-linear sway-heave coupling, which arises thanks to the PTO extension (the dynamic change in tether length).</p> <p class=IEEEParagraph>The irregular wave tests, representative of severe wave conditions, are analysed to study extreme responses. A 60<sup>o</sup> phase shifted focused wave group is found to be a representative “design wave” leading to the maximum PTO extension.  NewWave in response calculations are performed and this maximum response prediction agrees well with the largest measured responses in the irregular wave experiments, though it is clear that non-linearity is important.</p><p class=IEEEParagraph> </p>","authors":"J. Orszaghova","topic":"5","file":"WAVHYD-10-1088.pdf","bib":"WAVHYD-10-1088.bib"},
{"paperid":"1090","title":"Performance of PLAT-I, a Floating Tidal Energy Platform for Inshore Applications","keywords":"Sustainable Marine Energy Ltd have developed a floating tidal energy platform, a surface variant of the PLAT-O platform, named PLAT-I (Platform for Inshore Applications). The platform hosts four SCHOTTEL HYDRO GmbH Instream Turbines (SITs). The platform and turbines are designed for lower flow speeds (&lt;2.5m/s) sites, so target new UK and international tidal sites. The platform has been tested conceptually at FloWave, to determine the performance of the platform in terms of loads and motions, in different operational and environmental conditions. The paper presents the results of this tank testing campaign.","authors":"P. Jeffcoate","topic":"4","file":"TIDDEV-08-1090.pdf","bib":"TIDDEV-08-1090.bib"},
{"paperid":"1091","title":"Reinforcement Learning Based Maximum Power Point Tracking Control of Tidal Turbines","keywords":"<p>This paper explores the use of a reinforcement learning (RL) based maximum power point tracking (MPPT) algorithm for tidal turbines using numerical simulations. RL is an online learning algorithm in which an agent learns from its own experience by interacting with its environment.</p> <p>This paper proposes an approach by which the optimal speed-power curve of a tidal turbine is learnt through RL. The advantages of this approach are that there is no need for instantaneous current velocity measurements or prior knowledge of the system and that the control system can adapt to changes in the turbine characteristics.</p> <p class=IEEEParagraph>This control algorithm was applied to a tidal turbine in different current velocity, wave loading and turbulence conditions. The extended paper will discuss these results and comment on the applicability of two RL algorithm variants on tidal turbine control. A brief description of the tide-to-wire model used in this work will also be provided.</p> <p> </p><br />","authors":"A. Nambiar, E. Anderlini, G. Payne, D. Forehand, A. Kiprakis, R. Wallace","topic":"4","file":"TIDDEV-09-1091.pdf","bib":"TIDDEV-09-1091.bib"},
{"paperid":"1092","title":"Monitoring methods of marine renewable energy – A review of technologies for examining the environmental impact from wave and tidal power installations","keywords":"<p>A continued expansion of the marine renewable energy sector will result in an increased demand in monitoring the natural marine environment. This may be due to a basic scientific interest but is foremost linked to the requirement of pre- and post-construction studies in relation to environmental impact assessments and consenting processes for marine energy projects.<br />With focus on wave and tidal power, but without attempting to provide a comprehensive list, we intend to summarize methods, technologies and other scientific tools used for monitoring and predicting possible impacts from marine energy installations, on both population and behavioural levels.<br />This paper is intended to serve as a guidance for technology developers as well as authorities, regulators and decision makers with interests in general techniques, and naturally for scientists and consultants commonly being executors of studies and monitoring programs. By giving relevant and up to date references this paper may also be useful in finding more detailed information on study methods and variants, finally, give recommendations on where development of technologies is needed in order to face future requirements.</p>","authors":"A. Bender, F. Francisco, J. Sundberg","topic":"9","file":"ENVIRO-05-1092.pdf","bib":"ENVIRO-05-1092.bib"},
{"paperid":"1094","title":"NonLinear Modelling of a Linearly Damped, Neutrally Bouyant Generic Submerged Spherical Wave Energy Converter","keywords":"This work investigates the response of a generic submerged spherical WEC operating with optimised damping (power take off) in high order nonlinear wave conditions. The results focus on the coupling between nonlinear effects generated from both the diffraction and radiation and are compared against previous nonlinear studies. The outcomes highlight the effect off nonlinear interactions on WEC performance operating at resonance.","authors":"A. Bharath, J. Nader, I. Penesis, G. Macfarlane","topic":"3","file":"WAVDEV-12-1094.pdf","bib":"WAVDEV-12-1094.bib"},
{"paperid":"1096","title":"Experimental Uncertainty Analysis of an OWC Wave Energy Converter","keywords":"<p class=IEEEParagraph>This paper primarily consists of a practical example of an uncertainty analysis for model scale wave energy converter experiments. The uncertainty analysis includes design of experiment (DoE), installation, and measurements. Tank tests were conducted in the Australian Maritime College (AMC) Model Test Basin in Tasmania, Australia. We studied a 1:20 scale bent duct oscillating water column (OWC) wave energy converter (WEC), which was integrated into a fully reflective flat-faced breakwater (Fig. 1).</p><p>The uncertainty analysis was carried out using methodologies recommended by ITTC [2] and EquiMar [3]. Three categories of uncertainty are presented: standard uncertainty of Type A and Type B, combined uncertainty, and expanded uncertainty. Monte-Carlo numerical simulations are compared with these analytical uncertainty analysis results and discussed. Finally, we discuss whether using phase averaged results as a means to quantify measurement uncertainty is valid by comparing against Type A standard uncertainty measurement results.</p>","authors":"J. Orphin, D. Howe, J. Nader, I. Penesis","topic":"5","file":"WAVHYD-10-1096.pdf","bib":"WAVHYD-10-1096.bib"},
{"paperid":"1098","title":"The Effect of Lip Extrusion on Performance of a Breakwater Integrated Bent Duct OWC WEC","keywords":"The submitted abstract details a paper written regarding an experimental investigation undertaken at the Australian Maritime College, Tasmania, Australia. The experimental testing was conducted on a bent duct type Oscillating Water Column (OWC) Wave Energy Converter (WEC), and focuses primarily on a design characteristic associated with maritime structure integration of the device, that being inlet lip extrusion. The experimental investigation aimed at identifying the effect that inlet lip extrusion of a device integrated into a flat-faced breakwater would have on the mean power hydrodynamic absorption of the WEC. To test this, an experimental test matrix consisting of monochromatic regular wave regimes varying in frequency from 0.5Hz – 1.2Hz were applied to the experimental apparatus, from which data was logged and recorded by a configuration of wave and pressure probes. Inlet lip extrusion distances were varied incrementally from 0mm (flush to the face of the breakwater) to 200mm to aid in the identification of any trends associated with lip extrusion. Phase averaging was then used as a post-processing technique to analyse the raw data acquired from experimental investigation and present the results of the study which indicated that variation in lip extrusion affects the mean power hydrodynamic absorption of the integrated device.","authors":"D. Howe, J. Orphin, J. Nader, G. MacFarlane","topic":"3","file":"WAVDEV-12-1098.pdf","bib":"WAVDEV-12-1098.bib"},
{"paperid":"1102","title":"Marine Energy Harvesting Turbine: Design based on Analytical and Numerical Modelling","keywords":"One of the methods for harvesting marine energy, converting wave energy to electrical energy, is oscillating water column (OWC) technique using a bidirectional flow impulse (BDI) turbine. The BDI turbine can operate in reversing air flow conditions which are natural to OWC devices at the cost of its operational efficiency, which gives further scope for improvisation in arriving at optimum damping provided to OWC by the turbine at varying wave climate. In the present article, an analytical and numerical approach has been reported for the redesigning of a BDI turbine and compared with the features of an existing unidirectional flow impulse (UDI) turbine from a small wave energy device based on pressure drop across the turbine with respect to volume flow rate. The analytical approach exercises the velocity triangle method and similitude laws for redesigning the BDI turbine and reappraised with CFD approach. The results evince the analogy between the BDI and UDI, and detailed analysis has been presented.","authors":"A. George, R. B, A. Samad, N. D, P. Dudhgaonkar","topic":"3","file":"WAVDEV-12-1102.pdf","bib":"WAVDEV-12-1102.bib"},
{"paperid":"1104","title":"Performance and Wake Characteristics of a Tidal Turbine under Yaw","keywords":"<p><strong>In tidal streams and rivers, the flow of water can be at a yaw to the turbine rotor plane causing performance degradation and a skewed downstream wake. The current study aims to quantify the performance variation and associated wake behavior caused by a tidal turbine operating in a yawed inflow environment. A three-dimensional computational fluid dynamics study was carried out using multiple reference frame approach using </strong><strong><em>κ-ω SST </em></strong><strong>turbulence model with curvature correction. The computations were validated by comparison with experimental results on a 1:1 scale prototype for a 0° yaw case performed in a laboratory flume. The simulations were performed using a three-bladed, constant chord, untwisted tidal turbine operating at uniform inflow. Yaw effects were observed for angles ranging from 5° to 15°. An increase in yaw over this range caused a power coefficient deficit of 26% and a thrust coefficient deficit of about 6% at a tip speed ratio of 5 that corresponds to the maximum power coefficient for the tested turbine. In addition, wake propagation was studied up to a downstream distance of ten rotor radius, and skewness in the wake, proportional to yaw angle was observed. At higher yaw angles, the flow around turbine rotor was found to cushion the tip vortices, accelerating the interaction between the tip vortices and the skewed wake, thereby facilitating a faster wake recovery. Second order moments in the wake were also investigated. The center of the wake was also tracked using a center of mass technique. The center of wake analysis was used to better quantify the deviation of the wake with increasing yaw angle. It was observed that with an increase in yaw, the yaw recovery distance moved closer to the rotor plane and the flow behind and around the turbine rotor was observed to be increasingly turbulent and experienced high Reynolds stress values. The propagating wake was noticed to meander around the turbine centerline with increasing downstream distance and deviate by 5° towards the free surface above the turbine centerline for the case of 15º yaw.</strong></p><br />","authors":"P. Modali, N. Kolekar, A. Banerjee","topic":"6","file":"TIDHYD-05-1104.pdf","bib":"TIDHYD-05-1104.bib"},
{"paperid":"1105","title":"An experimental study on the reduction of the dynamic instability in the oscillating water column spar buoy","keywords":"<p class=IEEEParagraph>Parametric resonance is a dynamic instability commonly observed in spar-type wave energy converters that use their vertical motion to extract energy. This problem can occur due to instantaneous variations of hydrostatic restoring moment, or due to nonlinear pressure variations induced by the wave on the instantaneous converter wetted surface. During the wave cycle the device can become unstable, engaging in high roll/pitch amplitudes and consequently reducing the power extraction. This undesirable nonlinear effect can be particularly problematic under low cycle resonant conditions, i.e., when the converter has significant heave motion at wave periods that are half the natural pitch and roll periods. This work presents the model-scale testing of an oscillating-water-column spar buoy in a wave flume under regular waves. The attachment of different fins on the converter is considered for the reduction of the roll/pitch dynamic instability. The model was moored to the flume floor through three slack-mooring lines. Free decay tests were carried out to assess the natural period of oscillation and estimate the viscous damping coefficient of each degree of freedom. The motion of the device was measured by a six degree-of-freedom camera tracking system. Results compare the effectiveness of each configuration for the reduction of the roll and pitch motions and its impact in wave energy extraction.</p>","authors":"R. Gomes, J. Malvar Ferreira, S. Ribeiro e Silva, J. Henriques, L. Gato","topic":"3","file":"WAVDEV-13-1105.pdf","bib":"WAVDEV-13-1105.bib"},
{"paperid":"1106","title":"Control Algorithm Development for WRAM using a Real-Time Hybrid Test Platform","keywords":"<p class=IEEEParagraph><span lang=EN-AU>The research taking place here is to develop a suitable control algorithm for optimising power capture of the WaveRAM (WRAM) wave energy converter (WEC). It is intended that the algorithm will be suitable for sea deployment. Some design constraints are immediately established. It must: 1) perform better than simple linear damping; 2) execute in real-time; 3) be insensitive to model inaccuracies. The control algorithm should be ideally tested on a real WEC however due to cost limitations this is currently impossible.</span></p> <p class=IEEEParagraph><span lang=EN-AU>Real-time hybrid testing has been conducted at Trinity College Dublin as an ideal compromise at a manageable scale. The testing framework provides the means of incorporating simulated dynamics of the WRAM and control algorithm with realistic scaled down PTO components similar to those that would be used at full scale. The WRAM has been modelled specifically such that it can be executed efficiently in real-time.</span></p> <p class=IEEEParagraph><span lang=EN-AU>Various tests were carried out for controlled and uncontrolled turbine speeds such that optimal control algorithm could be verified. The outcomes of this work feed directly into SGL’s development program for the WRAM, and additionally the newly developed test rig has shown independent commercial potential for exploiting its functionality for a variety of applications.</span></p>","authors":"C. Signorelli, B. Basu","topic":"7","file":"GRDPTO-09-1106.pdf","bib":"GRDPTO-09-1106.bib"},
{"paperid":"1108","title":"Assessment of Flow Characteristics at Two Locations in an Energetic Tidal Channel","keywords":"<p><strong><span style=font-size: x-small;><span style=font-family: Times New Roman;><span lang=EN-AU>Inflow turbulence can impact a turbine’s power performance and load conditions and also affects wake recovery. At array scale, changes in flow conditions across a site impact the energy yield, performance and load conditions of turbines. </span>Understanding the variation of flow conditions in time and space <span lang=EN-AU>at deployment sites is therefore important to the tidal stream energy industry. </span></span></span></strong></p> <p><span lang=EN-AU><strong><span style=font-family: Times New Roman; font-size: x-small;>Tidal flow field data of sufficient detail to allow turbulence characterisation remains relatively scarce. Traditional three or four beam Acoustic Doppler Current Profilers (ADCPs), which are commonly used for tidal flow resource characterisation, are limited by their spatial and temporal resolution and by the assumption of flow homogeneity across their beams. Higher resolution methods of measurement should therefore be implemented.</span></strong></span></p> <p><span lang=EN-AU><strong><span style=font-family: Times New Roman; font-size: x-small;>This paper presents flow measurements that were conducted concurrently from two moored platforms in Strangford Narrows, an energetic tidal channel, separated by approximately 500 m. Between the two locations a rocky outcrop exists in the channel and the characteristics of the flow vary significantly. Two collocated instruments were used to measure the flow characteristics at each location: a five beam ADCP (Nortek Signature 1000) and an ADV (Nortek Vector). </span></strong></span></p> <p><span lang=EN-AU><strong><span style=font-family: Times New Roman; font-size: x-small;>This paper compares both the flow characteristics at each location and the turbulence measurements using the different instrumentation types. The combination of instrumentation enables improved characterisation of the flow.</span></strong></span></p>","authors":"H. Torrens-Spence, P. Schmitt, C. Frost, I. Benson, P. MacKinnon, T. Whittaker","topic":"2","file":"TIDRES-05-1108.pdf","bib":"TIDRES-05-1108.bib"},
{"paperid":"1109","title":"A performance assessment methodology for floating pitching WEC arrays","keywords":"The purpose of this paper is to present a performance assessment methodology in order to compare different solution of floating pitching WEC array layouts. A boundary element method (BEM) has been used to estimate the hydrodynamic coefficients of the array's WECs. The case of ISWEC, a floating pitching device, has been used in this study. Pitch RAOs of the single devices in the array has been adopted as farm performance index.","authors":"S. Sirigu, G. Vissio, G. Bracco, P. Dafnakis, B. Passione, N. Pozzi, G. Mattiazzo","topic":"5","file":"WAVHYD-11-1109.pdf","bib":"WAVHYD-11-1109.bib"},
{"paperid":"1110","title":"Experimental validation of different hydrodynamic modelling techniques applied to the ISWEC","keywords":"<p class=Default>This paper deals with the implementation of the 3 DOFs linear hydrodynamic model developed for the time-domain simulation of ISWEC (Inertial Sea Wave Energy Converter) floater dynamics. The main advantage of the model here presented is low computational cost.</p><p class=Default>The most difficult aspect to be modelled is the floater motions prediction at resonance conditions, where motions amplitude are larger.</p><p class=Default>Experimental results are used for the identification of the non-linearity due to the viscous effects. A novel approach for the identification of the non-linearity contribution along each DOF taken into account in the linear model is presented.</p> <p class=Default>The model is then compared with the open source code Wec-Sim  that allows the calculation of the instantaneous wetted surface of the floater, with the aim to obtain the cost-benefit evaluation of different modelling techniques .</p> <p class=Default>The cost-benefit analysis plays a role of considerable importance, in fact the main purpose of this work is to obtain a sufficiently fast and accurate hydrodynamic model, that can be also coupled with the converstion system dynamic model.</p>","authors":"N. Pozzi, A. Castino, G. Vissio, B. Passione, S. Sirigu, G. Bracco, G. Mattiazzo","topic":"5","file":"WAVHYD-11-1110.pdf","bib":"WAVHYD-11-1110.bib"},
{"paperid":"1112","title":"Target tracking using sonars for marine life monitoring around tidal turbines","keywords":"<span style=font-size: 11.0pt; line-height: 107%; font-family: &quot;Calibri&quot;,sans-serif; mso-ascii-theme-font: minor-latin; mso-fareast-font-family: Calibri; mso-fareast-theme-font: minor-latin; mso-hansi-theme-font: minor-latin; mso-bidi-font-family: &quot;Times New Roman&quot;; mso-bidi-theme-font: minor-bidi; mso-ansi-language: EN-GB; mso-fareast-language: EN-US; mso-bidi-language: AR-SA;>Sonars have been used successfully as part of an overall strategy for environmental monitoring around tidal turbines since 2011. Historically targets of interest were marine mammals. More recently, however, requirements include fish. Sonars are particularly useful in this aggressive environment where visibility is minimal and monitoring is required round the clock. The SeaTec software examines multibeam sonar data and extracts moving targets before performing rudimentary classification. Classification includes targets determined to be drifting with the tide or those that appear to have their own source of propulsion. This paper contains a description of the techniques used to detect, track and perform rudimentary classification of targets. Image processing techniques are used to perform target identification, followed by a geometric approach to target tracking, and human-observer inspired techniques for classification. The work described in this paper is related to the use of the SeaTec software in the first stage of the Integrated Active and Passive Acoustic System for Environmental Monitoring of Fish and Marine Mammals in Tidal Energy Sites (ISEM) project. The next stage is analysis of SeaTec’s interpretation of the collected data by SMRU and ACER scientists. The results of their analysis will inform the second iteration of the SeaTec software.</span><div id=_mcePaste class=mcePaste style=position: absolute; left: -10000px; top: 0px; width: 1px; height: 1px; overflow: hidden;><span style=font-size: 12.0pt; font-family: &quot;Times New Roman&quot;,serif; mso-fareast-font-family: SimSun; mso-ansi-language: EN-AU; mso-fareast-language: ZH-CN; mso-bidi-language: AR-SA; lang=EN-AU>Sonars have been used successfully (as part of the overall monitoring strategy) for environmental monitoring around tidal turbines since 2011[1]. Historically targets of interest were marine mammals. More recently, however, requirements have extended to include fish</span></div>","authors":"P. Jepp","topic":"9","file":"ENVIRO-05-1112.pdf","bib":"ENVIRO-05-1112.bib"},
{"paperid":"1113","title":"Tidal Flyer; Innovation, Design & Evolution (TIDE)","keywords":"<p>Open Ocean Energy (OOE) Ltd. is a Tidal Energy Device developer developing the Tidal Flyer system.  Over the past 3 years OOE have been working with Black &amp; Veatch (B&amp;V) on the optimisation of the Tidal Flyer system. This paper will outline the Stage 1 physical testing of various aspects of the design of the system and on-going CFD work on system dynamics.  Stage 1 testing was designed to inform the design of full, scaled system for testing at Flowave to undertaken in Stage 2.  At the end of the Stage 2, OOE will have completed TRL 4.</p> <p>The physical tests encompass the following aspects of the system:</p> <ul><li>Position of the self-trimming tail directly behind the foils in the downwash;</li><li>Self-trimming tail and foil flaps as controlling mechanisms for system velocity;</li><li>Extent of the wake between the upstream and downstream lines;</li><li>Effects of drag in the side channels.</li><li>No end plates for the foils</li></ul> CFD analysis undertaken at UCC as part of the MaREI scheme and some work is presented here.  The programme of testing involved two visits (8 testing days) to Ifremer in Boulogne-sur-Mer.","authors":"T. Devaney, B. Holmes, M. Bhinder","topic":"4","file":"TIDDEV-09-1113.pdf","bib":"TIDDEV-09-1113.bib"},
{"paperid":"1115","title":"Scoring the Technology Performance Level (TPL) Assessment","keywords":"For energy generation devices such as WECs, techno-economic performance considerations should be considered early in the development process when fundamental conceptual, operational, and design choices are being made.  Hence, the Technology Performance Levels (TPL) were designed to consider a wide range of WEC attributes that define the techno-economic performance potential as well as identify potential showstoppers at the earliest stages of WEC development.  The original groups and attributes of the TPL assessment used in the Wave Energy Prize have been updated using a formal Systems Engineering approach. This paper will detail the process of determining the assessment questions and scoring criteria for each capability in the TPL taxonomy.   A description of how the different levels of the taxonomy are combined into a single numerical ranking is then given.","authors":"D. Bull, R. Costello, A. Babarit, K. Nielsen, B. Kennedy, C. Bittencourt Ferreira, J. Roberts, J. Weber","topic":"3","file":"WAVDEV-13-1115.pdf","bib":"WAVDEV-13-1115.bib"},
{"paperid":"1116","title":"B.C. Marine Energy Resource Atlas and Decision Support System","keywords":"<p>Exploitation of renewable energy sources has become increasingly important as jurisdictions worldwide transition away from reliance on fossil fuels in favour of sustainable energy solutions. In particular, the idea of harvesting energy from river currents, tidal currents and ocean waves has attracted growing interest in Canada over the past decade. In this paper we present a geo-spatial decision support system (DSS) to facilitate marine renewable energy (MRE) development feasibility investigations in coastal British Columbia, Canada. The DSS hosts an extensive database of geo-spatial information on resource availability as well as many constraints and factors pertinent to MRE development. The constraints and factors encompass a multitude of physical, operational, environmental, and socio-economic data sets. The data are integrated via multi-criteria analysis (MCA) to identify hot spots for MRE development. The DSS offers a flexible investigative framework through which users may perform customized interrogations based on user-defined criteria. This flexibility enables users to tailor preliminary investigations to suit their needs and to quickly assess a variety of alternative scenarios. The DSS presented herein is expected to aid industry stakeholders in identifying potential sites for detailed investigation regarding the deployment of MRE technologies in coastal British Columbia.</p>","authors":"S. Ferguson, J. Cousineau","topic":"2","file":"TIDRES-05-1116.pdf","bib":"TIDRES-05-1116.bib"},
{"paperid":"1119","title":"The optimal force for wave power devices","keywords":"With the world being ever more hungry for power, electricity generation from<br />devices driven by ocean waves is ever more attractive. One generic problem<br />is to determine the force profile that will extract the most power. In this<br />paper is derived the Phi method. It is an algorithmic method determining<br />the optimal profile from an explicit description of the device dynamics. It<br />works over a broad family of devices. It covers non linear forces such as<br />square law drag and surface bouyancy. It systematically determines the optimal<br />controls from the literature, and interesting cases not in the literature,<br />such as depth dependant added mass. Compared to spring damper, under<br />empirical conditions the method commonly gives 25% improvement in power<br />extraction.","authors":"B. Mills, B. Ding","topic":"3","file":"WAVDEV-13-1119.pdf","bib":"WAVDEV-13-1119.bib"},
{"paperid":"1120","title":"Adapting Conventional Tools to Analyse Ducted and Open Centre Tidal Stream Turbines","keywords":"<p>An adjusted blade element momentum theory model is presented, incorporating a duct model based on an analytical / empirical approximations of flow parameters through the diffuser. Modification and application of the duct model to bidirectional ducts is detailed, based on calibrations against the OpenHydro device, and verified with blade resolved CFD. The ducted BEMT model is validated compared to coupled RANS BEM, showing excellent agreement of rotor power and thrust forces for the majority of tip speed ratios considered. Limitations in relation to model simplifications are detailed, as well as benefits such as the significantly reduced computational requirements.</p> <p>An analytical method of computing blade stresses from the blade forces output from the BEMT model is also presented. Multiple inflow conditions are analysed, and their fatigue damage calculated in order to determine the lifetime of the blades.</p>","authors":"S. Allsop, P. Thies, C. Peyrard, P. Bousseau","topic":"6","file":"TIDHYD-06-1120.pdf","bib":"TIDHYD-06-1120.bib"},
{"paperid":"1122","title":"Feasibility of a Tidal Turbine-Fish Interaction Study in the Aquatron Controlled Lab Space","keywords":"<p>To date there remains limited lab studies on the interaction of marine life with marine renewable energy devices.  The Aquatron Laboratory at Dalhousie University has a long history of studying marine life in a controlled marine lab environment. The installation of a 0.9 m diameter 3 blade vertical axis turbine is described. The performance of the turbine is validated against previous towing tank experiments at NRC St. John’s. The tests were run continuously for 3 weeks. The first interaction tests are reported using Striped Bass (Morone saxatilis). This study is to demonstrate the feasibility of using this tank for turbine-fish interaction studies. The test had 40 free swimming Striped Bass varying in age from 2 to 3 yrs and 3 cages of fish at specific distances away in the outflow/wake of the turbine. The fish behaviour was monitored through counting of the fish as they passed specific locations in the tank, measurements of speed, and general observations. Cortisol blood testing was conducted on the fish in the cages to indicate if stress was being experienced at varying distances from the turbine. Results presented should not be considered as definitive behaviour analysis.</p><p class=IEEEParagraph> </p>","authors":"S. Molloy","topic":"9","file":"ENVIRO-PP-1122.pdf","bib":"ENVIRO-PP-1122.bib"},
{"paperid":"1123","title":"An Assessment of the TKE Balance at a Tidal Energy Site Using ADCP and Shear Probe Measurements","keywords":"<p><span><span style=font-family: 'Times New Roman', serif;>The </span><span style=font-family: 'Times New Roman', serif;>characterisation</span><span style=font-family: 'Times New Roman', serif;> of natural turbulence levels is a critical component of a tidal energy resource assessment </span><span style=font-family: 'Times New Roman', serif;>because</span><span style=font-family: 'Times New Roman', serif;> it provides insight into </span><span style=font-family: 'Times New Roman', serif;>the</span><span style=font-family: 'Times New Roman', serif;> loads that would be applied to an in-stream turbine. </span><span style=font-family: 'Times New Roman', serif;>Typically, the flow in these passages is well-mixed </span><span style=font-family: 'Times New Roman', serif;>and rates of production (</span><span style=font-family: 'Times New Roman', serif;><em>P</em></span><span style=font-family: 'Times New Roman', serif;>) and dissipation (</span><span style=font-family: 'Times New Roman', serif;><em>ε</em></span><span style=font-family: 'Times New Roman', serif;>) are assumed to be in balance; however, for the strong flows that are present at tidal energy sites, it is expected that both the vertical diffusive transport (</span><span style=font-family: 'Times New Roman', serif;><em>T</em></span><span style=font-family: 'Times New Roman', serif;>) and non-local effects (e.g. advection) could be significant. </span></span></p> <p><span><span style=font-family: 'Times New Roman', serif;>In this paper, </span><span style=font-family: 'Times New Roman', serif;>we </span><span style=font-family: 'Times New Roman', serif;>estimate each of the terms in </span><span style=font-family: 'Times New Roman', serif;>the governing equation for the turbulent kinetic energy (TKE) using</span><span style=font-family: 'Times New Roman', serif;> measurements collected in Grand Passage, Nova Scotia where the </span><span style=font-family: 'Times New Roman', serif;>flow speed reaches </span><span style=font-family: 'Times New Roman', serif;>2</span><span style=font-family: 'Times New Roman', serif;> m/s and the Reynolds number is 8x10</span><sup><span style=font-family: 'Times New Roman', serif;>7</span></sup><span style=font-family: 'Times New Roman', serif;>. </span><span style=font-family: 'Times New Roman', serif;>Two instrumentation techniques were used</span><span style=font-family: 'Times New Roman', serif;>: </span><span style=font-family: 'Times New Roman', serif;>an acoustic Doppler current profiler (ADCP) was mounted on a bottom frame,</span><span style=font-family: 'Times New Roman', serif;> </span><span style=font-family: 'Times New Roman', serif;>and shear probes were positioned</span><span style=font-family: 'Times New Roman', serif;> in the nose of an underwater, streamlined buoy “flown” at </span><span style=font-family: 'Times New Roman', serif;>middepth</span><span style=font-family: 'Times New Roman', serif;>. </span><span style=font-family: 'Times New Roman', serif;>We present two main conclusions: (1) speed-bin averages of </span><span style=font-family: 'Times New Roman', serif;><em>ε</em></span><span style=font-family: 'Times New Roman', serif;> </span><span style=font-family: 'Times New Roman', serif;>from the shear probes and ADCP measurements exhibit significant ebb/flood asymmetry, and (2) an imbalance in</span><span style=font-family: 'Times New Roman', serif;> </span><span style=font-family: 'Times New Roman', serif;><em>ε, </em></span><span style=font-family: 'Times New Roman', serif;><em>P </em></span><span style=font-family: 'Times New Roman', serif;>and</span><span style=font-family: 'Times New Roman', serif;><em> T </em></span><span style=font-family: 'Times New Roman', serif;>exists, which</span><span style=font-family: 'Times New Roman', serif;><em> </em></span><span style=font-family: 'Times New Roman', serif;>suggests that nonlocal effects</span><span style=font-family: 'Times New Roman', serif;> </span><span style=font-family: 'Times New Roman', serif;>are significant. </span></span></p><p> </p>","authors":"J. McMillan, A. Hay, R. Lueck, F. Wolk","topic":"2","file":"TIDRES-05-1123.pdf","bib":"TIDRES-05-1123.bib"},
{"paperid":"1124","title":"Integration of an Acoustic-Inertial Positioning Device in the Design of a Wave Energy Converter","keywords":"<p>Carnegie Clean Energy is working towards the deployment of the 6<sup>th</sup> generation of its wave energy conversion technology, CETO, a submerged bottom referenced point absorber. CETO 6 captures the energy from the waves through the motion of its Buoyant Actuator and transmits it to a hydraulic pump, referenced to the sea bed, which converts it into hydraulic energy. For design verification, mooring load monitoring and model validation purposes, it is necessary to measure the absolute position of the Buoyant Actuator in real time, under the constraint that no GPS antenna be used, due to the CETO technology being submerged some 2m below sea level. Advanced Navigation’s Subsonus technology, which combines bi-directional acoustic communication with an Inertial Navigation System, was identified as a suitable candidate for the task. A test set-up was deployed off Fremantle, Western Australia with a dynamic buoy and a sea floor mounted reference unit. This test allowed assessment of Subsonus’ ability to provide the required measurement accuracy while responding to the challenges that are inherent to the industry, such as strict reliability requirements and the specifics of the motions of a wave energy converter. Significant outcomes of the testing phase included the quantification of the accuracy of the technology, assessment of the multipath effect from close mounting of Subsonus on the wave energy converter, and optimisation of the positioning algorithm.</p>","authors":"M. Cocho","topic":"3","file":"WAVDEV-13-1124.pdf","bib":"WAVDEV-13-1124.bib"},
{"paperid":"1125","title":"How to reduce the nonlinearities of a single point wave absorber to capture more energy?","keywords":"The majority of analyses on the wave energy converters (WECs) is based on the usual assumption of linear water–wave theory and assuming that the body is suspended relative to some stable reference platform by a system of linear springs and dampers which provide restoring forces in addition to any natural buoyancy force. In this study we show that how important the effect of non-linearity is and to what extend it can mislead the estimation of the computed output power of the system. For this purpose, the tank-testing data are used beside the open–source CFD code of OpenFoam and in-house developed codes.<br />","authors":"A. Valizadeh, A. Rafiee","topic":"5","file":"WAVHYD-11-1125.pdf","bib":"WAVHYD-11-1125.bib"},
{"paperid":"1126","title":"Internal model control of a three-tether axisymmetric wave energy converter","keywords":"<p>In the current study, the causal controller will be designed for a three-tether axisymmetric wave energy converter where several motion modes are involved in the power generation. The control strategy will be based on the concept of an internal model control where no future knowledge of the incident wavefront is required. The performance of the controller will be studied in several ways including its robustness to the model uncertainties and its sensitivity to the direction of wave propagation. In conclusion, the IMC will be compared with other existing non-causal solutions in order to validate its effectiveness.</p>","authors":"N. Sergiienko, B. Cazzolato, P. Hardy, B. Ding, M. Arjomandi","topic":"7","file":"GRDPTO-09-1126.pdf","bib":"GRDPTO-09-1126.bib"},
{"paperid":"1127","title":"A Dual-turbine System for Wave Energy Conversion","keywords":"The Oscillating water column (OWC) principle is the most widely used method of acquiring the energy of waves in the ocean. In the OWC based wave energy conversion (WEC) system, the wave motion drives the air above the water surface alternately to rotate an air turbine coupled to a generator. In the previous study, authors proposed a WEC system of Wells turbine with a booster turbine in order to overcome the inherent drawbacks of Wells turbine, and investigated the efficiency of this dual-turbine system. The proposed dual-turbine topology consists of a large Wells turbine, a small impulse turbine, known as Setoguchi turbine, and a generator. The Setoguchi turbine is used as the booster turbine. It was hypothesized that, by coupling these two turbines, the Wells turbine would acquire energy at low flow rates, while the Setoguchi turbine would do the same at high flow rates, and it would finally enhance the efficiency of the system at high flow rates. In the present study, the performance of each turbine under unsteady flow has been conducted by CFD analyses. The total efficiency of the dual-turbine system and the ratio of flaw rate of each turbine have been predicted in the study.","authors":"M. Takao, S. Fukuma, M. Alam, S. Okuhara, Y. Kinoue","topic":"3","file":"WAVDEV-14-1127.pdf","bib":"WAVDEV-14-1127.bib"},
{"paperid":"1128","title":"Numerical wave tank experiment on a submerged single-tethered asymmetric mass point absorber","keywords":"This abstract is about numerical wave tank experiment on a submerged single-tethered asymmetric mass point absorber. In previous works, a single-tethered asymmetric mass point absorber (PA) has been proven to be 2-3 times more efficient than a generic single-tethered PA for long waves. However, the hydrodynamics of PAs were modelled by using potential wave theory, and therefore the studies had the risk to overestimate the power absorption efficiency of the asymmetric mass PA by ignoring nonlinear hydrodynamic effects. In this paper, the efficiency of the asymmetric mass PA is assessed for various sea states in a numerical wave tank, in which the hydrodynamics are calculated by solving Navier-Stokes equations. The tank is originally developed by and then updated for this study. The functions of the tank are realized by using the computational fluid dynamic toolbox OpenFOAM and the open-source library ‘wave2foam’ for wave generation. In addition, the yaw stability of the asymmetric mass PA subjected to wave direction change is investigated in the numerical wave tank.","authors":"F. Meng","topic":"3","file":"WAVDEV-14-1128.pdf","bib":"WAVDEV-14-1128.bib"},
{"paperid":"1129","title":"Performance Prediction of a Counter-rotating Impulse Turbine for Wave Energy Conversion","keywords":"Wave energy can be converted into the electrical energy by using a wave energy converter. The wave energy converter with oscillating water column (OWC) is one of the most promising devices. In this device, the water column due to the wave motion drives an air column above it to rotate an air turbine. The counter-rotating impulse turbine for wave energy conversion has been proposed and tested so far, and the average efficiency has been shown to about 0.3. On the contrary, in an offshore experiment, it has been reported that the power generation efficiency of this turbine is larger than the Wells turbine in the case of small waves. However, there is a scarcity of the detailed characteristics data of counter-rotating impulse turbine. In a previous study, authors investigated the effect of rotor blade solidity and setting angle of guide vane on the performance of this counter-rotating turbine, and clarified that the efficiency of this turbine is higher than the impulse turbine with single rotor in the range of high flow coefficients. The present study aims to investigate the effect of turbine geometries on the performance by using the computation fluid dynamic (CFD) analyses.","authors":"M. Takao, K. Yamada, M. Alam, S. Okuhara, Y. Kinoue","topic":"3","file":"WAVDEV-14-1129.pdf","bib":"WAVDEV-14-1129.bib"},
{"paperid":"1130","title":"Predicting coastal impacts of wave farms using a wave-resolving model","keywords":"<p>The objective of this work is to study the coastal impact of a cluster of wave energy converters (wave farm). In the past decade, numerous efforts have been made to analyse the potential coastal impact of wave farms through i) phase-averaged (or spectral) wave models and ii) phase-resolving wave models based on the mild slope equations. However, both approaches suffer from inherent limitations, restricting their applicability. For example, spectral wave models do not fully represent all wave processes (e.g., diffraction), and wave-WEC interactions. On the other hand, mild slope models resolve these interactions and diffraction more accurately, but are limited to linear waves over mildly sloping beaches.</p> <p>In the present work, we set out to develop a fully nonlinear phase-resolving model that can intrinsically resolve both the nonlinear evolution of waves in an arbitrary coastal region and the wave-WEC interactions. To this end, we extend SWASH, an existing non-hydrostatic wave-flow model, to account for the interactions between the waves and a submerged heave-buoy (inspired by the Carnegie CETO device). This approach allows for realistic simulations of the wave field and their interactions with the WECs, improving our understanding of potential coastal impacts by a wave farm.</p>","authors":"D. Rijnsdorp, J. Hansen, R. Lowe","topic":"5","file":"WAVHYD-11-1130.pdf","bib":"WAVHYD-11-1130.bib"},
{"paperid":"1132","title":"PLAT-O at FloWave: A validation of ProteusDS at modelling response of a taut-moored tidal platform at tank-testing scale","keywords":"<p>An accurate estimation of offshore structure response is essential for designing a successful tidal stream generator. Two numerical methods are available: dynamic analysis tools, e.g. ProteusDS, and Computational Fluid Dynamics (CFD) codes. ProteusDS is an effective first-pass tool, limited at resolving fluid-structure interaction and reliant on empirical hydrodynamic coefficients. CFD is not as limited, but is more time and computer intensive. This paper explores the reach of ProteusDS in providing desired confidence in modelling tidal platform responses.</p> <p>PLAT-O#2 is a subsea floating platform in development by Sustainable Marine Energy, Scotland. A 1:17 physical model was tested in combined wave and current at FloWave, Edinburgh. The full details are published in an AWTEC 2016 paper with an initial validation study of ProteusDS and the tank testing results. This paper builds on that, using an alternative modelling approach and a higher comparison resolution, for further insight into the robustness of the model.</p> <p>This paper will present:</p> <ul> <li>Tank-scale comparison of measured and predicted (by ProteusDS)      response timeseries, line loads and platform motions, in magnitude and      frequency, of the PLAT-O#2 tank tested model</li> <li>Testing of dynamic analysis software ProteusDS in terms of      robustness and limitations in capturing hydrodynamics at tank testing scale</li> </ul><p class=IEEEParagraph> </p>","authors":"I. Bivol, P. Jeffcoate, L. Johanning","topic":"4","file":"TIDDEV-09-1132.pdf","bib":"TIDDEV-09-1132.bib"},
{"paperid":"1133","title":"A Review of Tidal Current Turbine Technology: Present and Future","keywords":"<p class=IEEEParagraph>Tidal energy has an advantage over the solar and the wind energy due to its predictability. This makes it a desirable candidate from the viewpoint of grid integration. The harnessing of tidal energy has recently moved from the building of barrages to the tidal current turbines. The latter is likely to be more cost-effective and have less impact on the local biodiversity. In essence, the tidal current turbines are similar to the wind turbines. However, the challenges of operating the power conversion devices in marine conditions has proved to be a bottleneck, and thus the technology is still in its earliest stages of developments.</p> <p class=IEEEParagraph>The paper aims at outlining the recent developments in the field, and categorize these solutions based on certain criteria such as the turbine type, the generator type, presence of gearbox, etc. In addition to market solutions which shall include both the grid connected and the proof-of-concept types, this work shall also cover the various solutions proposed in the literature. We shall conclude with the present trends in the market and the challenges to be tackled in order to bring down the levelized cost of electricity from the tidal energy.</p>","authors":"F. Wani, H. Polinder","topic":"4","file":"TIDDEV-PP-1133.pdf","bib":"TIDDEV-PP-1133.bib"},
{"paperid":"1135","title":"Dynamic Simulation of a Bidirectional Air Turbine for OWC Device Based on In-Field Measurement","keywords":"<p style=margin: 0mm 0mm 0pt; text-indent: 5pt;><span lang=EN-AU style=mso-fareast-font-family: 游明朝; mso-fareast-theme-font: minor-fareast; mso-fareast-language: JA;><span style=font-family: Times New Roman; font-size: x-small;>This research focuses on more realistic performance measurement and estimation of air turbines used in OWC devices under real unsteady operating condition. First, dynamic performance of the turbine is measured with turbine characteristics estimator implemented in turbine control system. Tested system is an OWC wave energy Test Plant in Fukui Prefecture Japan. </span></span><span lang=EN-AU style=mso-fareast-font-family: &quot;ＭＳ 明朝&quot;; mso-fareast-language: JA;><span style=font-family: Times New Roman; font-size: x-small;>The diameter of the air-turbine is 0.8m. Turbine is connected to a 30kW generator connected to an inverter controlled by a Programmable Logic Controller (PLC). Using torque estimator and some basic measured parameters, torque and thrust coefficient is calculated from in-field measurement. </span></span><span lang=EN-GB style=mso-fareast-font-family: 游明朝; mso-fareast-theme-font: minor-fareast; mso-ansi-language: EN-GB; mso-fareast-language: JA;><span style=font-family: Times New Roman; font-size: x-small;>Based on measured torque and pressure characteristics, dynamic simulation of the turbine is carried based on 1 degree of freedom rotational equation of motion. Measured pressure time series is used as input to the simulation. Rotational speed time-series reproduced by simulation is compared to the measured data. </span></span><span lang=EN-AU style=mso-fareast-font-family: 游明朝; mso-fareast-theme-font: minor-fareast; mso-fareast-language: JA;><span style=font-family: Times New Roman; font-size: x-small;>The reproduced rotational speed or performance from simulation showed good agreement to measured data. Therefore, the estimated turbine characteristics is valid for turbine performance estimation including dynamic behaviour including maximum turbine speed or pressure prediction or also applicable for control system design.</span></span></p> <p style=margin: 0mm 0mm 0pt;><span lang=EN-AU><span style=font-family: Times New Roman; font-size: x-small;> </span></span></p>","authors":"M. Iino, T. Miyazaki, M. Iida","topic":"3","file":"WAVDEV-14-1135.pdf","bib":"WAVDEV-14-1135.bib"},
{"paperid":"1137","title":"Application of a passive control technique to the ISWEC","keywords":"<p>The ISWEC is a floating, slack-moored, gyroscopic Wave Energy Converter.</p><p>The full scale prototype has an electric-mechanical PTO composed by a gearbox and a brushless torque motor. At present, the linear control law regulating the torque on the PTO includes a stiffness term and a damping term to extract active power. The torque needed to perform the stiffness effect is provided by the PTO, resulting in an increase of the PTO load and in a flux of reactive power. To overcome this problem, an eccentric mass held at the gyroscope base is used to provide the stiffness term.</p><p>Numerical analyses of the time domain, non-linear ISWEC model confirmed the improvement of the performances with the reduction of generator stresses as it does not provide any elastic recall. Annual productivity and generator torque are evaluated to obtain a complete comparison between the two different control solutions.</p>","authors":"M. Bonfanti, S. Sirigu, G. Bracco, B. Passione, G. Vissio, N. Pozzi, G. Mattiazzo","topic":"3","file":"WAVDEV-15-1137.pdf","bib":"WAVDEV-15-1137.bib"},
{"paperid":"1140","title":"Comparison of X-Band Radar at two sites in the Western Isles, Scotland","keywords":"X-Band radar has been used extensively to extract wave statistics via spectral analysis of the radar images. The success of the technique depends on the strength of the backscatter received by the radar. The sea states at two coastal locations with different geographical and bathymetric characteristics were studied using X-Band radar. One site, Taransay, is in a partially sheltered location, while the Butt of Lewis is fully exposed to Atlantic weather systems. The Taransay radar was deployed for two days in March 2016, while the Butt of Lewis radar has been continuously recording for eight months to date. In the latter case, a two-day period in December 2016 was chosen in a comparison study. The radar data was processed to produce time-series of backscatter corresponding to the locations of Waverider buoys deployed at the two locations. Radar backscatter is affected by a number of mechanisms, including range, azimuth, wind speed, tilt and shadowing modulation. By considering these phenomena, a method to identify the areas in the radar footprint, most likely to produce reliable results is described.","authors":"A. Vogler, A. Murray, J. Morrison, C. Greenwood","topic":"1","file":"WAVRES-04-1140.pdf","bib":"WAVRES-04-1140.bib"},
{"paperid":"1141","title":"On Mooring Solutions for Large Wave Energy Converters","keywords":"<pre><p>The present paper describes the work carried out in the project 'Mooring Solutions for Large Wave Energy Converters’, which is a Danish research project carried out in a period of three years from September 2014, with the aim of reducing cost of the moorings for four wave energy converters and improving the applied design procedure. The paper presents the initial layouts and costs and illustrates which solutions could potentially reduce cost. Different methods for analysis of the systems were applied, ranging from simple quasi-static analysis to full dynamic analysis and experimental work. The numerical methods were compared to the experimental data, and results showed significant underestimation of tensions in the quasi-static model while reasonable overestimation was found in the dynamic analysis even without major tuning of the model. The dynamic analysis has then been implemented in a meta-model based optimization process with the aim of optimizing the mooring layout for each WEC according to cost of the systems.</p><br /></pre>","authors":"J. Thomsen, J. Kofoed, F. Ferri, C. Eskilsson, L. Bergdahl, M. Delaney, S. Thomas, K. Nielsen, K. Rasmussen, E. Friis-Madsen","topic":"12","file":"MRGFND-03-1141.pdf","bib":"MRGFND-03-1141.bib"},
{"paperid":"1142","title":"Present and future impacts of large tidal stream turbine arrays.","keywords":"This work examines the multi-scale ocean response to tidal stream energy extraction by large theoretical arrays in Scottish Waters (UK). A typical annual cycle of the present NW European Shelf hydrodynamics was reproduced by the Scottish Shelf Model, an unstructured grid three-dimensional FVCOM (Finite Volume Community Ocean Model) implementation, and compared with output for the same period of time perturbed by tidal stream energy extraction. It is shown that the very large tidal stream arrays can introduce noticeable changes to the tidal elevation, marine currents and ocean stratification patterns. In order to determine if those impacts may ameliorate or exacerbate the effects of future climate change on the marine system, the Scottish Shelf Model has been used to reproduce the hydrodynamic conditions representative of the projected future climate in 2050. Two climate scenarios have been modelled, one without tidal energy extraction devices and a second with the possible very large scale tidal stream array layouts. This allows us to evaluate the potential effect of climate change on the hydrodynamics and compare it with the future state of the seas modified by large scale energy extraction.","authors":"M. De Dominicis, R. O'Hara Murray, J. Wolf","topic":"6","file":"TIDHYD-06-1142.pdf","bib":"TIDHYD-06-1142.bib"},
{"paperid":"1144","title":"Impacts of a Tidal Lagoon on Urban Drainage and Pollutant Dispersion Impacts in a Coastal Embayment","keywords":"This abstract relates to a marine modelling study examining the effect of a tidal lagoon on water quality using Swansea Bay as a case study. The study centred on the application of a suite of integrated network, hydrological, river and coastal models to understand the water qwuality issues, optimise solutions and predict compliance with a range of water quality standards.","authors":"E. Langley, P. Evans","topic":"9","file":"ENVIRO-05-1144.pdf","bib":"ENVIRO-05-1144.bib"},
{"paperid":"1145","title":"The Influence of Seabed Structure on Combined Wave-Current Flow Interactions","keywords":"<!-- p { margin-bottom: 0.1in; line-height: 120%; } --> <!-- p { margin-bottom: 0.1in; line-height: 120%; } --> <p style=margin-bottom: 0in; line-height: 100%; page-break-before: always;>Waves and ocean currents are the two main sources of loading on tidal energy converters ; however, on top of that deployment sites can have seabed variations. Seabed changes have a direct impact in in the behavior of waves and currents and by extend affecting the fluid velocities near these topographic changes. In order to quantify better the loadings on a tidal turbine converter, an estimation of the variability of the loads due to changes of bathymetry will increase the survivability of the TEC. <br /> <br /> Therefore, thus  paper presents a methodology to develop an analytical model to address the current-wave interactions under the influence of  variable bathymetry. The model takes a first approach to develop analytical expressions for the velocity potential of linear waves hitting perpendicular to an obstacle under the influence of a steady current. The obstacle is regular in nature and also acts as a barrier for the current flow. Functions related to the wave velocity field are obtained from this expressions and their behavior is compared to a simple plain sea bed  that is a typical model in many tidal turbine simulations.</p> <p style=margin-bottom: 0in; line-height: 100%;> </p>","authors":"j. rivera camacho","topic":"5","file":"WAVHYD-12-1145.pdf","bib":"WAVHYD-12-1145.bib"},
{"paperid":"1146","title":"Mitigation of Torque Pulsations in Variable Pitch Tidal Current Turbines Using Speed Control","keywords":"<p class=IEEEParagraph>The sudden changes and the variability of the tidal flow velocity have the effect of creating pulsations on tidal current turbines. These pulsations have an adverse effect on the tidal turbine fatigue and ultimate loading as well as the operation of the drivetrain. These all lead to premature components failure, system overdesign and costly maintenance. This paper presents a novel control strategy with which pulsations created by the unsteady flow are reduced by changing the generator speed. The control strategy is based on changing the maximum power point tracking reference speed so that the generator absorbs less power from the tidal currents during a sudden flow speed increase and increase power generation during a flow speed dip. The system in which the control strategy is tested is a hypothetical 1.5MW three-bladed variable-pitch horizontal-axis tidal current turbine using a permanent magnet synchronous generator with gearbox controlled by a voltage-source converter. Results show that the ultimate loading generated by sudden flow pulses can be reduced by over-speeding the generator. In addition, initial tests on fatigue loading show that a smoother torque input can be achieved without adversely affecting power generation.</p>","authors":"M. Sousounis, J. Shek","topic":"4","file":"TIDDEV-09-1146.pdf","bib":"TIDDEV-09-1146.bib"},
{"paperid":"1148","title":"Hydrodynamic response of a jacket-frame mounted WEC sub-system of a novel hybrid wind-wave energy converter","keywords":"A sustainable exploitation of offshore wind and wave energy resources is crucial for the consolidation of both industries on a global scenario of climate change and raising threats to the marine environment. Is in relation to this, and with the shared challenge for both industries to reduce costs, the combination of wind and wave technologies has arisen. In particular, this research deals with a novel hybrid system that integrates an OWC, type of WEC, with a jacket-frame mounted offshore wind turbine. The hydrodynamic response of the OWC when attached to a jacket-frame offshore wind substructure was investigated by means of physical modelling. A 1:50 model was tested in Plymouth University’s COAST laboratory. The Wave Hub site, a 50 m depth wave energy test centre in the North coast of Cornwall, was considered for selecting the wave conditions. Based on the results from the experimental campaign, the interaction between the device and the wave field, as well as the effect of the different model and damping configurations on the device performance will be analysed. These results will be the base for an initial evaluation of this novel concept and the baseline scenario for future development.","authors":"C. Perez-Collazo, J. Skämberg-Tippen, D. Greaves, G. Iglesias","topic":"5","file":"WAVHYD-12-1148.pdf","bib":"WAVHYD-12-1148.bib"},
{"paperid":"1149","title":"Ocean Energy for Ireland in 2050: Techno-Economic Feasibility and Innovation System Needs","keywords":"<p class=ieeeparagraph><span lang=EN-AU>This paper examines ocean energy feasibility in Ireland by assessing the innovation system needs to deploy wave and tidal technologies to the market within the context of a long-term energy system. In the first part, Irish TIMES optimization model is used to develop scenarios to evaluate the cost reductions necessary to achieve deployment by 2050.<span> </span></span><span>Three base scenarios that adhere to policy recommendations that achieve an 80% reduction in CO</span><sub><span>2 </span></sub><span>emission by 2050, restrict bioenergy imports, and restrict intermittent renewable electricity generation to 70% are set up.</span> <span lang=EN-AU>Initial results indicate the minimum cost reduction required and the amount of deployment achieved in each scenario. In the second part a TIS analysis of ocean energy in Ireland is developed. This aims to identify the state of innovation of the sector in Ireland. The methodology is developed through seven innovation functions. The outputs will help identify (1) coherence between the present innovation system and modelled ocean energy scenarios, (2) barriers that limit innovation, such as the oppositions of competitors and incumbent technologies, (3) the ocean energy R&amp;D knowledge depreciation in time if not well supported, and (4) possible future directions of policies and investments to allow ocean costs reduction and deployment.</span></p>","authors":"A. Elia, A. Chiodi, F. Rogan, B. O' Gallachoir","topic":"10","file":"ECONOM-03-1149.pdf","bib":"ECONOM-03-1149.bib"},
{"paperid":"1150","title":"Quantifying detections of acoustically tagged fish for probability of encounter with MHK devices","keywords":"In the Bay of Fundy, quantifying the interaction of fish with marine hydrokinetic (MHK) devices is an unarguable requirement for environmental impact and appraisal.  To this end, 69 kHz acoustic tags have been implanted within the body cavities of fish so their movements and presence could be monitored.  Here we report results from multiple range test experiments that provide a mathematical foundation to convert fish detections into probabilities of encounter with MHK devices.  Measurements from moored acoustic receivers show detection efficiency is greatly diminished as current speed increases.  Separate hydrophone measurements showed  ambient sound levels also increased with current but this was not sufficient to explain the reduced detection efficiency.  Range test experiments were undertaken using drifters and these showed current speed having little effect on detection efficiency. We propose that an improved mooring design can improve the utility of acoustic fish tracking in fast currents.","authors":"B. Sanderson, C. Buhariwalla, M. Adams, M. Stokesbury, A. Redden","topic":"9","file":"ENVIRO-06-1150.pdf","bib":"ENVIRO-06-1150.bib"},
{"paperid":"1151","title":"The impact of wave energy converters on the Bay of Skaill, Orkney.","keywords":"<p class=IEEEParagraph>Reduction in wave energy by wave energy converters has the potential to impact on the morphodynamics of beaches in the lee of deployments. This has implications for coastal protection and management. This paper presents work conducted on the geologically constrained beach at the Bay of Skaill in Orkney, a location typical of the high energy environments where wave energy converters may be deployed.</p> <p class=IEEEParagraph>The MIKE3 FM 2012 model is used to simulate waves, hydrodynamics and non-cohesive sediment transport in a fully coupled mode for a nine day period incorporating calm and storm conditions. Inclusion of energy extraction impacts on the predicted bed level change. Magnitude of change is reduced over the upper intertidal and increased in the lower intertidal. Changes are greatest for the southern portion of the embayment. Given the short timescale of simulation, predicted differences are large. However, confidence in model results are limited due to the lack of hydrodynamic calibration data. Comparison with measured morphological change is reasonable for the northern portion of the embayment but the model less well replicates change in the southern section where predicted impact is greatest. Nonetheless, the level of impact predicted means it is recommended that further analysis is conducted.</p>","authors":"I. Fairley, H. Karunarathna","topic":"9","file":"ENVIRO-06-1151.pdf","bib":"ENVIRO-06-1151.bib"},
{"paperid":"1154","title":"Aspects of small scale flume correlation with a BEM-CFD Model","keywords":"The ability to capture and understand the characteristicsof a Horizontal Axis Tidal Turbine (HATT) is of particularinterest when designing such devices. CFD simulation is one ofmany useful tools for deriving the required information. Howeversimulating fully resolved HATT geometry for a time periodgreat enough to resolve a fully developed wake, and accuratelypredict power and thrust characteristics, is computationally veryexpensive. One approach to resolve this issue is the use of BladeElement Momentum CFD [1]. This work aims to correlate aBlade Element Momentum CFD model with experimental resultsusing a 0.28m diameter HATT rotor in a laboratory flumeat Lehigh University. During the process the model, and theapproach, are evaluated identifying important considerations forthis type of study. The main difference with the numericalapproach used in this work, compared to traditional CFD [2]with fully resolved hydrofoil geometry, is the use of tabulatedlift/drag data combined with tabulated geometry representingthe hydrofoils of the turbine. This approach can be reduced toa steady state or time averaged simulation which has significantperformance benefits over transient fully resolved CFD (i.e.smaller mesh size). However to benefit from this approach theinput data must be justified/validated. This study highlights thekey issues with using this type of model for turbine prediction,and discusses the lessons learnt in detail. The initial results showthat the correlation fails to predict either the resolved CFD orexperimental data. The initial results (not shown) under predictwith the peak Cp at just under TSR 4. After a study of the fullyresolved CFD conducted in [2], probable areas of divergencefrom the experimental results are identified. These included; liftand drag data at correct Reynolds number, turbulence effectson lift and drag characteristics, boundary layer induced flowacceleration, overtopping bypass Flow. It is of importance tounderstand how the model physics effect the results. This paperexplores this idea and establishes some lessons learnt whenattempting this type of model correlation.","authors":"I. Masters, M. Edmunds, A. Williams, N. Kolekar, A. Vinod, A. Banerjee","topic":"4","file":"TIDDEV-10-1154.pdf","bib":"TIDDEV-10-1154.bib"},
{"paperid":"1155","title":"Design features of the upcoming  Coastal and Ocean Basin in Ostend, Belgium,  for marine renewable energy applications","keywords":"<p>The new Coastal and Ocean Basin (COB) at the Greenbridge Science Park in Ostend, Belgium is under design. The laboratory will provide a versatile facility that will make a wide range of testing possible, including the ability to generate waves in combination with currents and wind at a large range of model scales. This facility is part of the Gen4Wave project on offshore renewable energy and coastal engineering in Flanders, Belgium. The COB is funded by the Hercules foundation, the Agency for Innovation by Science and Technolo-gy (IWT), Ministry of Public Works and Mobility, Ghent University (UGent) and University of Leuven (KU Leuven). The basin will be part of a larger building complex that will also host a towing tank from the Maritime Access Division of the Ministry of Mobility and Public Works. This new infrastructure will offer the opportunity to companies and government agencies to develop innovative designs thereby strengthening the position of Flanders in coastal engineering and offshore renewable energy. This paper presents an overview of the basin’s capabilities, the ongoing works, and presents and discusses some results of the design work.</p>","authors":"P. Troch, V. Stratigaki, P. Devriese, A. Kortenhaus, N. Silin, V. Nelko, J. De Maeyer, J. Monbaliu, E. Toorman, P. Rauwoens, D. Vanneste, T. Suzuki, T. Van Oyen, T. Verwaest","topic":"5","file":"WAVHYD-12-1155.pdf","bib":"WAVHYD-12-1155.bib"},
{"paperid":"1156","title":"Durable winch-based point absorbers","keywords":"<p>In this article, winch-based point absorbers are explored. Winch-based PTO systems for point absorbers have many advantages. The stroke length is not limited, and no end stops are required. Thereby, the maximum forces of the WEC during storms are grossly reduced, and the device can have a considerably lighter and less costly structure.  Also, the WEC size is not in practice related to the stroke length of the machine, which reduces WEC size and cost. Standard rotating seals and a rotating PTO can be used, which are smaller in size, less costly and more reliable. However, the winch solution itself is difficult to accomplish and standard winches are not sufficiently durable for a WEC application. Ropes and wires suffer from fatigue and wear, and ordinary chains suffer from too much wear to be a viable option. In this article, different approaches to find a durable winch solution that can deal with the large forces associated with WEC operation is explored and evaluated.</p>","authors":"A. Hagnestål, U. Sellgren, K. Andersson","topic":"7","file":"GRDPTO-10-1156.pdf","bib":"GRDPTO-10-1156.bib"},
{"paperid":"1157","title":"Combined Performance and Loading Assessment of Pitching Flap-Type Wave Energy Converters","keywords":"As marine renewables progress towards and through the pre-commercial prototype deployment stage, it is essential that increased attention is given to the efficient and intelligent design of machines with a view to minimising the Levelised Cost of Energy (LCOE) generated. Wave Energy Converters (WECs) are designed to couple heavily to incident water waves, extracting the maximum amount of energy possible from a sea. Devices will be subjected to many millions of high intensity load cycles over a typical deployment and so the combined consideration of hydrodynamic performance alongside the undertaking of an accurate fatigue assessment is extremely important. <p class=IEEEParagraph><span lang=EN-AU>This paper uses both frequency and time domain numerical methods to assess the performance and fatigue loading of pitching flap-type wave energy converters, often also referred to as Oscillating Wave Surge Converters (OWSCs). The paper grants perspectives on the performance/fatigue load ratio for flap-type WEC concepts alongside a demonstration of the deviations in both performance and loading estimations obtained from traditional frequency and time domain modelling methodologies. </span></p>","authors":"P. Lamont-Kane, M. Folley, T. Whittaker","topic":"5","file":"WAVHYD-12-1157.pdf","bib":"WAVHYD-12-1157.bib"},
{"paperid":"1160","title":"InSTREAM: Measurement, Characterisation and Simulation of Turbulence from Test Tank to Ocean","keywords":"<p>In this paper, we will introduce and disseminate results from the InSTREAM programme, which is a follow-on project (funded jointly by UK and Canada as a follow-on from the Scottish Government funded 'Turbulence in Marine Environments').<br /><br />Here, we extend the TiME methodology to encompass two additional sites and the FloWave test tank. We use Computational Fluid Dynamics (OAS' `TurbineGRID' Free Vortex Method tool) to undertake site specific simulation, and demonstrate a process whereby simulation is combined with model testing, to provide a robust process for determining the effects of site-specific turbulence on turbine performance.</p><p> </p>","authors":"T. Clark, A. Hay, R. Lueck, T. Davey","topic":"6","file":"TIDHYD-06-1160.pdf","bib":"TIDHYD-06-1160.bib"},
{"paperid":"1163","title":"Power-take-off system with spring characteristics for resonating, heaving wave energy converters","keywords":"<p class=IEEEParagraph>The novel Power-Take-Off (PTO) combines a linear guiding system based on a bellow frame with hydraulic driver characteristics, a special turbine and an adjustable spring characteristic, that can give in combination with mass, for most heaving devices, a resonating characteristic in the range of dominant wave frequencies and provide an attenuating dynamic behaviour which is needed for an efficient pointabsorber.</p><p class=IEEEParagraph>The design of this technology has been completed, and parts that are currently being build will be tested in 2017 within the EU program Wetfeet.</p><p class=IEEEParagraph>This PTO has an adjustable spring stiffnes which even can be tuned to obtain a partially negative spring stifness. Combination of this PTO with a floating buoy will lead to an efficient point absorber with favourable end-buffer characteristics. The critical components such as the turbine and the bellow frame are being developed within the EU program Wetfeet,</p> <p class=IEEEParagraph>In the present paper we will show the PTO components, the theory that led to the specific properties and simulation results of the PTO being used in a novel wave energy device called  “Symphony Wave Power”.</p><p class=IEEEParagraph> </p>","authors":"F. Gardner","topic":"7","file":"GRDPTO-10-1163.pdf","bib":"GRDPTO-10-1163.bib"},
{"paperid":"1164","title":"Optimising Tidal Lagoons","keywords":"<p class=IEEEParagraph>A key part in developing real tidal lagoon projects is revenue optimisation, in order to make for financially viable projects. Under the current subsidy regime, this is the same as optimising annual energy production.</p> <p class=IEEEParagraph>Starting from academic research, Tidal Lagoon Power (‘TLP’) have subsequently developed significant expertise in energy modelling in the course of progressing the Swansea Bay Tidal Lagoon project.</p><p class=IEEEParagraph>This paper describes the development journey, illuminated by real-world experiences from developing a world-first infrastructure project.</p>","authors":"N. Yates, B. Tatlock","topic":"6","file":"TIDHYD-06-1164.pdf","bib":"TIDHYD-06-1164.bib"},
{"paperid":"1165","title":"Introduction of a hybrid tidal system","keywords":"<p>This paper proposes a solution to convert Newport Docks, Wales, UK into a tidal lagoon system, to provide renewable energy to the local area. The proposed hybrid system features a pumping system which is powered by a tidal turbine, allowing the control of the head difference between the dock and the local tide. A Matlab programme is used to simulate the tidal barrage system, results are compared with the standard barrage system. By shifting the generation time , the results show there is an increase in maximum power (by 7%), total power produced (by 6%) and generation time (by 30 mins more per day) when using the hybrid system. Moreover, another advantage of the hybrid system is that it can be used as a power storage for peak demand. This methodology as the potential to enable other tidal energy sites, to supply energy to the grid.</p>","authors":"s. deng, C. Byrne, A. Mason-Jones","topic":"4","file":"TIDDEV-10-1165.pdf","bib":"TIDDEV-10-1165.bib"},
{"paperid":"1166","title":"Fish monitoring to assess effects of a tidal turbine","keywords":"<p>The Bay of Fundy has the largest tides in the world. The Fundy Ocean Research Center for Energy (FORCE) has taken advantage of these tides near Minas Passage (Nova Scotia, Canada) and created a facility to allow industry to demonstrate and evaluate tidal in-stream energy conversion (TISEC) technology. The effect of TISEC devices on fish populations remains mainly unknown and long term fish monitoring is essential to assess changes in fish distributions associated with turbines.</p><p class=IEEEReferenceItem>The goal of this project is to quantify fish distribution changes associated with the presence of deployed TISEC devices in the FORCE CLA (Crown Lease Area) by performing mobile surveys using down-looking hydroacoustics (Simrad EK80). Surveys last 24 hours (night and day data during two ebb tides and two flood tides), are performed at neap tides several times per year and include a CLA sample as well as a control location sampling.</p> <p class=IEEEReferenceItem>Five surveys have been performed: May, August, October 2016 before the Open Hydro turbine deployment and November 2016 and January 2017 after the deployment. To date, relative fish densities vary among months but there are no major differences between CLA and control locations.</p><p class=IEEEReferenceItem> </p><ul> </ul><p> </p>","authors":"A. Daroux","topic":"9","file":"ENVIRO-06-1166.pdf","bib":"ENVIRO-06-1166.bib"},
{"paperid":"1167","title":"First Steps toward a Multi-Parameter “Location & Layout” Optimisation Tool for Arrays of Floating Tidal Platforms","keywords":"<p class=IEEEParagraph>Currently, tidal site selection and array analyses are heavily skewed towards maximising power output by optimising for maximum resource and minimal wake effects. While these parameters are undoubtedly of high importance, they are but two of many that should be factored into an optimisation, to lower the LCOE of a tidal stream array.</p> <p class=IEEEParagraph>This paper aims to facilitate the transition towards array deployment by assessing and altering the procedure through which inter-site location and intra-site layout are decided upon, with focus towards lowering LCOE through genetic algorithm based multiple parameter optimisation.</p> <p class=IEEEParagraph>This paper will contrast several high and low output potential array deployment sites within the UK, and provide optimum array locations based around minimising LCOE. In addition to the standard site assessment parameters, this paper seeks to quantify the less apparent but still constraining parameters associated with installation, operation and maintenance: device downtime; callout distance; hostile environmental limitations; weather windows; component lifetime reduction; and operational risk.</p> <p class=IEEEParagraph>Through partnership with SME, it will be possible to produce case studies based around the deployment of the PLAT-O and PLAT-I tidal platforms, and thus explore platform specific and generic sensitivity of project LCOE to the aforementioned site parameters.</p>","authors":"J. McDowell, P. Jeffcoate, M. Khorasanchi","topic":"2","file":"TIDRES-05-1167.pdf","bib":"TIDRES-05-1167.bib"},
{"paperid":"1168","title":"Impulsive Loading Mechanisms Experienced by an Oscillating Wave Surge Converter","keywords":"<p class=IEEEAbtract>The presented paper introduces three separate forms of impulsive loading mechanisms an Oscillating Wave Surge Converter (OWSC) during a large sea state. The loading mechanisms were discovered using experimental wave tank testing of a baseline OWSC scale model. The processes involved in each mechanism are discussed and the induced foundation loads are examined. To date research in the area published by Queen’s University Belfast has focused on slamming events, the paper seeks to provide more insight as to why this has been the case; concluding that slamming events are much more frequent with no obvious load reduction techniques. <span class=IEEEAbstractHeadingChar> </span></p><p> </p>","authors":"A. McKinley, P. Lamont-Kane, M. Folley, T. Whittaker","topic":"8","file":"STRMAT-02-1168.pdf","bib":"STRMAT-02-1168.bib"},
{"paperid":"1170","title":"Numerical and experimental analysis of the efficiency of an Oscillating Water Column","keywords":"<p>The aim of this work is to investigate its efficiency of a OWC when it is deployed in the Mediterranean sea and to give guidelines for the choice of the most suitable PTO.</p> <p>First a numerical algorithm WaveFoam is used to simulate the interaction between the WaveSax and a regular wave with a period in the range of those characteristics of the coasts in central Italy.</p> <p>The presence of the turbine is modelled with a porous sect whose porosity parameter is set so to obtain a pressure jump across it similar to that experienced for the same turbine in previous experiments.</p> <p>Experimental analysis performed in the wave tank focused on the control parameters (torque and angular velocity), which  are varied to maximize the efficiency.</p> <p>In a second numerical analysis the optimized parameters and the consequent pressure jump across the turbine are used to drive the numerical simulation, where the presence of the harbour is taken into account.</p> <p>The experimental results show that the control strategy acting on the angular velocity are the most efficient.</p> <p>Furthermore the numerical simulations show that the presence of a wall behind the device increases the captured power because of partial reflections on it.</p> <p> </p><p class=IEEEParagraph> </p>","authors":"G. Colicchio, I. Santic, M. Peviani, A. Danelli, A. Colucci","topic":"3","file":"WAVDEV-15-1170.pdf","bib":"WAVDEV-15-1170.bib"},
{"paperid":"1172","title":"Turbulent flow within multi-row tidal stream turbine arrays","keywords":"<p class=IEEEParagraph><span lang=EN-AU>As tidal stream turbine deployment grows to multi-row arrays containing tens/hundreds of devices, superimposed wakes from upstream devices will create the onset conditions for downstream turbines. Wake generated turbulence augments turbulence intensities to above ambient levels within arrays to enhance wake recovery, possibly allowing turbines to be positioned closer together to improve spatial efficiency. However wake generated turbulent fluctuations from upstream devices increase the likelihood of blade fatigue on downstream devices. This can be prevented by moving devices further apart to allow the turbulence to decay. These wake generated effects must be considered to establish the optimal turbine placement within arrays. In this paper we present experimental results that characterise the streamwise velocity, turbulence intensity and Reynolds normal stresses within multi-row porous fence arrays. The experiments were conducted in response to the lack of array scale experimental/field data, which has limited our understanding of flow development through multi-row tidal stream turbine arrays, whilst also limiting opportunities for validating computational models. Results show that wake added turbulence within the arrays increased the streamwise turbulence intensity by up to 840% in comparison with the ambient flow. Similarly the Reynolds stresses reached levels 40% greater than the ambient flow.</span></p>","authors":"D. Coles, L. Blunden, A. Bahaj","topic":"4","file":"TIDDEV-10-1172.pdf","bib":"TIDDEV-10-1172.bib"},
{"paperid":"1173","title":"Wave Farm Design: Optimisation of O&M With Respect to Weather Window Criteria","keywords":"<p class=IEEEParagraph>The operations and maintenance of wave energy converters in the marine environment is a costly and difficult process. One of the main difficulties is the access to the devices and the restrictions imposed by weather windows. Due to the considerable impact that weather windows can reasonably be expected to have on wave farms and wave energy converter access it is sensible to consider the impact on the design and development of a wave farm at an early stage.  Failure to consider weather windows at an early stage in the wave farm project design process will likely lead to significant delays and wasted effort or maybe even project cancellation. While failure to consider weather windows at an early stage in the WEC technology design process will almost certainly lead to failure of the technology development.</p> <p class=IEEEParagraph>The paper aims to present the results of a logistics simulation which includes the impact of weather windows. Understanding this impact allows wave farm developers to implement an optimised operations and maintenance strategy which will ultimately increase the chance of a successful technology development and subsequent project development.</p>","authors":"B. Kennedy, J. Weber, K. Nielsen, J. Hanafin, R. Costello","topic":"11","file":"OPANDM-01-1173.pdf","bib":"OPANDM-01-1173.bib"},
{"paperid":"1174","title":"Effect of bed roughness coefficient uncertainty on tidal stream power assessment","keywords":"<p>The bed roughness coefficient is often used as a tuning parameter in the hydrodynamic models that are utilised to assess tidal stream power potential. As such, there is significant uncertainty associated with the correct value that should be applied throughout the modelling domain. The aim of the research is to quantify the effect that this uncertainty has on the potential power yield of a site, and to optimise this power within a stochastic framework. In a simplified, 1-D channel, for which an analytic solution has been previously derived, the background friction is expressed as a random variable (RV) and expressions for the expectation of and the variance in power are derived in terms of the mean and standard deviation of the RV. The expected power is maximised with respect to the turbine drag. This optimisation is shown to give a greater expected power than the deterministic optimum applied in the stochastic scenario.</p>","authors":"M. Kreitmair, T. van den Bremer, A. Borthwick","topic":"2","file":"TIDRES-05-1174.pdf","bib":"TIDRES-05-1174.bib"},
{"paperid":"1176","title":"Assessing the Impact on Power Production of WEC array separation distance in a wave farm using one-way coupling of a BEM solver and a wave propagation model","keywords":"<p>In this paper we apply a novel one-way coupling method between the BEM model NEMOH and the wave propagation model MILDwave to investigate the influence on power output of the separation distance between two densely packed WEC arrays in a wave farm.  An iterative method of applying the one-way coupling to interacting WEC arrays is used to compute the wave field in a WEC farm and to calculate its power output.  The wave farm is modelled for regular waves for a number of wave periods, wave incidence directions and various  inter-array separation distances.  The notion of WEC array independence is defined and discussed for a 2-array WEC farm with a view towards simplifying the modelling calculations.</p>","authors":"P. Balitsky, G. Verao Fernandez, V. Stratigaki, P. Troch","topic":"5","file":"WAVHYD-13-1176.pdf","bib":"WAVHYD-13-1176.bib"},
{"paperid":"1178","title":"The effect of tip-speed-ratio and freestream turbulence on blade fatigue of a horizontal axis tidal turbine","keywords":"<p class=IEEEParagraph>The tidal energy industry is making significant steps towards larger scale deployment and commercialisation of the industry. However, the continued development and success of the industry will be dependent on proving that the technology is reliable, efficient, and financially viable. In order to achieve this, turbines must be reliable and this must be demonstrable to source financial backing for installation of larger arrays.</p> <p class=IEEEParagraph>The tidal flows in which the turbines operate are highly turbulent and dynamic with a broad range of length scales and intensities that are site specific.  Work is therefore required to assess turbine performance and reliability across a broad range of different flow conditions, including turbulence.</p> <p class=IEEEParagraph>In this paper we consider the fatigue damage occurring at the blade root as a function of turbine tip-speed-ratio (TSR). This is compared over a range of different turbulent flows with different characteristics. This paper presents detailed analysis of the ambient flow conditions and the fatigue loads acting on the turbine blade under these different flow conditions. The impact of turbulence and fatigue on large scale turbine performance is also discussed in the paper.</p>","authors":"T. Blackmore, A. Bahaj, L. Myers","topic":"4","file":"TIDDEV-10-1178.pdf","bib":"TIDDEV-10-1178.bib"},
{"paperid":"1179","title":"The near-wake of  Horizontal Axis Tidal Turbines  in a storm surge barrier","keywords":"The flow dynamics of the near-wake of Horizontal Axis Turbines are often studied using large eddy simulation (LES) or using physical models.  We present a 24hour set of Acoustic Doppler Current Profiler (ADCP) data of the near-wake of a full scale HATT installation. The data set shows potential for the validation of HATT near-wake simulations. It captures the mean flow in the wake and the propagation of turbulence structures resulting from the blade hub and blade tip. <br />","authors":"M. Verbeek, R. Labeur, W. Uijttewaal, P. de Haas","topic":"9","file":"ENVIRO-06-1179.pdf","bib":"ENVIRO-06-1179.bib"},
{"paperid":"1180","title":"Wave focusing with submerged structures","keywords":"<p class=IEEEParagraph><span lang=EN-US>The use of the energy from waves to generate electricity depends on both the conditions of the waves in the area of interest and on the available technology to extract such energy. Therefore, it is imperative to correctly choose, or even develop, the appropriate device for the conditions of the waves from the target area. The use of submerged structures has been proposed as a mechanism to focus wave energy and optimize space usage and to improve wave energy extraction has been. This could be a very useful technic particularly for places where wave power availability is low.</span></p> <p class=IEEEParagraph><span lang=EN-US>In this document we analyze the wave energy focalization capacity of ellipsoidal and biconvex submerged structures with the aim to concentrate the energy to extracted with a wave energy converter (WEC).</span></p> <p class=IEEEParagraph><span lang=EN-US>Our objective is to determine the optimal design characteristics for a submerged structure in order to better concentrate wave energy in a particular area so as to increase the capacity of WEC’s to produce electric energy.</span></p><p class=IEEEParagraph>The analysis of the capacity of the structure to concentrate wave energy was done through a series of numeric simulations with the RefDif model (Kirby et al, 2012).</p><p class=IEEEParagraph><span lang=EN-US><br /></span></p><p class=IEEEParagraph> </p>","authors":"R. Silvestre","topic":"5","file":"WAVHYD-PP-1180.pdf","bib":"WAVHYD-PP-1180.bib"},
{"paperid":"1184","title":"A reliable optimal controller design method for sea wave energy converters.","keywords":"<p>This paper investigates a novel and reliable robust feedback model predictive control (MPC) strategies for WECs. The objective of maximising energy output while reducing the potential risk of device damage under persistent and irregular waves can be converted into a constrained robust optimisation problem. The novelty of the proposed control strategy compared with the existing MPC strategies for WECs is that the stability and feasibility of the MPC strategy are guaranteed without inducing significant computational burden. A feasible and stable region of the WECs with the proposed controller can also be used as an indicator of WECs’ safe operation mode.</p><p>The proposed method in this paper not only provides a safe and reliable control method for the WECs, but also provides some design guidance for the WECs as well as the corresponding PTO systems.</p>","authors":"S. Zhan, G. Li","topic":"7","file":"GRDPTO-PP-1184.pdf","bib":"GRDPTO-PP-1184.bib"},
{"paperid":"1185","title":"Validation of hydrodynamic numerical model of a pitching wave energy converter","keywords":"<p>Wave energy is not a mature technology, commercial software has not been proved to be suitable for all the broad variety of wave energy converters (WECs) yet. Thus, validated numerical models are needed. This paper will present a hydrodynamic numerical model experimentally validated. The device studied and tested has been Floating Power Plant's WEC. Floating Power Plant’s device is a hybrid offshore platform for wind a wave energy. FPP is a semisubmersible offshore platform for water depths greater than 45 meters, and has a wind turbine (5MW) and four WECs (2MW in total) . FPP’s WECs move in close proximity and this hydrodynamic interaction amplifies their magnitude of motion within the wave frequency range, but also results in large fluid velocities and large pressure gradients and therefore numerical complications. FPP configuration is simplified in this paper to a single pitching WEC moving in close proximity to a fixed structure. Several hydrostatic situations and surrounding substructures have been tested in the wave flume and wave basin and also different incident wave angles. This whole package of quality experimental data confirms the numerical model performs well for all the validation cases and helps to understand the hydrodynamic behaviour predicted numerically.</p>","authors":"P. Heras, S. Thomas, M. Kramer","topic":"5","file":"WAVHYD-PP-1185.pdf","bib":"WAVHYD-PP-1185.bib"},
{"paperid":"1186","title":"Optimization of mechanical design and control parameters of an oil-hydraulic power take-off system","keywords":"<span style=font-family: Times New Roman; font-size: small;> </span><span style=font-family: Times New Roman; font-size: small;> </span><span style=font-family: Times New Roman; font-size: small;> </span><p style=margin: 0cm 0cm 0pt; line-height: 115%; text-indent: 36pt;><span lang=EN-GB style=line-height: 115%; mso-bidi-font-size: 12.0pt; mso-ansi-language: EN-GB;><span style=font-family: Times New Roman; font-size: small;>A concept of an oil-hydraulic PTO with two reciprocating cylinders allows the use of single-rod cylinders with larger diameters and smaller strokes relatively to a state-of-the-art design double rod cylinder, with the advantage of increasing the maximum admissible force. However this solution brings new challenges on the mechanical design because geometric interference between the two cylinders must be avoid and the mechanism interface, such as distance between joints, cylinder dimensions, lever arm, should be optimized. Also cylinder strokes are limited and a minimum average pressure in the PTO circuit should be guaranteed.</span></span></p><span style=font-family: Times New Roman; font-size: small;> </span><p style=margin: 0cm 0cm 0pt; line-height: 115%; text-indent: 36pt;><span lang=EN-GB style=line-height: 115%; mso-bidi-font-size: 12.0pt; mso-ansi-language: EN-GB;><span style=font-family: Times New Roman; font-size: small;>This paper presents a study where the harvested wave power of a PTO based on reciprocating oil-hydraulic cylinders is maximized, with an optimization of the mechanical design and PTO control parameters. The study includes technological constraints on the PTO, which are a minimum average hydraulic power of 170 (bar) and the cylinders stroke are limited to 3 (m). The interface mechanism of the Wavestar prototype is used with modifications on the mechanical design and a float cone type is used instead of a hemispheric one. The optimal parameters are determined with genetic algorithms.</span></span></p><span style=font-family: Times New Roman; font-size: small;> </span>","authors":"M. Calvário","topic":"7","file":"GRDPTO-10-1186.pdf","bib":"GRDPTO-10-1186.bib"},
{"paperid":"1190","title":"Modelling alternatives for a heaving point absorber with and without stiffness modulation","keywords":"<p>Results of different numerical models are presented against experimental data for a point absorber developed by the Swedish company CorPower Ocean AB. Different theories are used in the models, including linear potential theory, Morison equation force terms and strip theory, as well as nonlinear corrections of the hydrostatic and Froude Krylov terms. Mathworks Simulink and Orcaflex have been used for the implementation of the models.</p><p>Comparisons are made for regular and irregular wave cases, and the experimental waves have been used as model inputs. Several motions variables and forces acting on the system are compared in order to assess the ability of the models to represent the WEC behaviour.</p><p>Besides, runs are made with and without a negative spring component in order to emphasize the effect of this component on the WEC.</p><p>The differences between the numerical models are analysed and highlighted, and the range of validity for each type of model is discussed.</p><p> </p><p> </p>","authors":"M. Guérinel, E. Jansson, J. Todalshaug, M. Jesmani, K. Guijt","topic":"5","file":"WAVHYD-13-1190.pdf","bib":"WAVHYD-13-1190.bib"},
{"paperid":"1194","title":"OVERTOPPING BREAKWATER FOR WAVE ENERGY CONVERSION: STATUS AND PERSPECTIVES","keywords":"The OBREC (Overtopping BReakwater for Energy Conversion) is a new typology of overtopping wave energy converter (OTD) integrated into a traditional rubble mound breakwater. The device can be considered as an innovative non-conventional breakwater that has the same functions as the traditional maritime defense structures with the added-valued of the energy production. The paper presents a comprehensive overview of the OBREC, offering a synthesis of the complete design process, from the results of the two complementary test campaigns in small scale carried out in 2012 and 2014, to the description of the full-scale device installed in Naples in 2015. The device represents the first OTD device in full-scale integrated into an existing rubble mound breakwater and it has been equipped by an instrumental apparatus to measure its response to the wave interaction. The monitoring of the full-scale device in the port of Naples, particularly during storm conditions, is aimed to study the scaling effects in wave loading and the overall performance of this breakwater-integrated OTD, included performance in terms of the energy production.","authors":"D. Vicinanza, P. Contestabile, E. Di Lauro","topic":"3","file":"WAVDEV-15-1194.pdf","bib":"WAVDEV-15-1194.bib"},
{"paperid":"1195","title":"Experimental Study into the Diffracted Wave Field Downstream of an Array of Wave Energy Converters in Irregular Waves","keywords":"It is shown that the experimental diffracted wave field <br />matches the existing numerical models  within the region <br />measured, showing shadows of attenuation and amplification <br />of the wave energy flux spreading from the array. These lead <br />to possibilities for optimisation of arrays making use of <br />constructive interference present. Ultimately,  these results<br />offer a contribution to the acknowledged need for <br />experimental validation of existing models.  Furthermore, this <br />study presents videogrammetry as a viable alternative to <br />traditional wave measurement technologies for investigations <br />where resolution in the wave analysis is central","authors":"M. Bennet, I. Penesis, A. Fleming, G. Macfarlane, J. Nader","topic":"5","file":"WAVHYD-13-1195.pdf","bib":"WAVHYD-13-1195.bib"},
{"paperid":"1197","title":"OES Task 10 WEC Modelling Verification and Validation","keywords":"<p>This paper will be the first joint reference paper for the OES Task 10 WEC modelling verification and validation, introduced to the OES by Bob Thresher (NREL) in 2015. The kick-off workshop took place in September 2016 where the initial base line task was defined. Lessons from similar offshore wind validation/verification projects (OC3-OC5 conducted within IEA Wind Task 30) showed that a simple test case would help the initial co-operation in order to present results in a comparable way.A heaving sphere was chosen for the first test case of the group and will be presented in the paper.</p><p>Verification and validation involves different “numerical experiments” such as heave decay test, regular wave cases of varying steepness and periods – irregular wave cases, with and without external damping. The models used to simulate the “experiments” include Cummins’ equation based linear and slightly nonlinear models fully nonlinear time-domain boundary element method (BEM) as well as computational fluid dynamics (CFD) simulations.</p><p>The interest for co-operation is demonstrated by the number of involved experts from 13 countries and their different codes that will be described in the paper.</p>","authors":"K. Nielsen","topic":"5","file":"WAVHYD-13-1197.pdf","bib":"WAVHYD-13-1197.bib"},
{"paperid":"1198","title":"Multi-float performance of WEC M4 in swell","keywords":"The WEC M4 is a moored multi-float attenuator/line absorber system. The configurations have consisted of three floats increasing in size from bow to stern to facilitate heading into the wave direction. The bow and mid floats are rigidly connected by a beam and a beam from the stern float is connected to the hinge point above the mid float for power take off (PTO) with easy access  [1]. This has been tested in wave basins [2] and through linear diffraction modelling in the frequency [3] and time domains [4]. The variation of float size gives a range of natural periods in heave and pitch, providing a broad band response so that significant power generation may be obtained across the range of wave periods occurring at a typical site. The distance between floats is about half a typical wavelength so that forces and adjacent float motions are predominantly in anti-phase. Recently it has been shown that increasing the beam length between bow and mid floats improves performance [4]. The effectiveness of linear modelling has also been shown to extend to extreme (non-breaking) waves in intermediate depth [5]. While the three-float system provides good capture width ratios (CWR), normalised by wavelength not body width, the inclusion of extra floats has been explored through linear diffraction modelling. The float configuration described as 111 means 1 bow, 1 mid and 1 stern float. Here we consider configurations 121, 122 and 132 with various cross spacings. Capture width ratio variation with peak period are shown in Fig.2 with 121 and 132 configurations giving best results. The ratio of energy yield to steel mass is also best for 121 and 132 configurations for several sites with available scatter diagrams. In the paper previous work is reviewed and new multi-float results are presented and discussed with cost implications.","authors":"P. Stansby","topic":"3","file":"WAVDEV-15-1198.pdf","bib":"WAVDEV-15-1198.bib"},
{"paperid":"1200","title":"Investigation of the Influence of Arrangement and Spacing on Wake Flow of Three Tidal Current Turbines by CFD analysis","keywords":"<p>Tidal current power farm should be efficient to increase electrical power and economic feasibility. The efficiency of tidal current power farm can be evaluated by mean efficiency of devices and power per unit farm area. Although there are several studies for arrangement of tidal current devices, optimal array arrangement is not established.</p><p>This study introduces the rectilinear grid array and staggered grid array of three tidal current turbines. 3D CFD(Computational Fluid Dynamics) analysis was used to estimate the performance of turbines and longitudinal and lateral optimization was conducted. The turbine diameter is 18 m and rated power assumed 1MW at 2.8m/s. The depth was assumed 36 m to secure the tip clearance of 0.5D. The results shows that the staggered grid array has higher mean efficiency and power per unit area than rectilinear grid array. Therefore the power extracted from a staggered grid array is much more than rectilinear grid array when the operating conditions are same.</p>","authors":"J. Chul, M. Kim, S. Hwang, H. Park, J. Chan","topic":"6","file":"TIDHYD-06-1200.pdf","bib":"TIDHYD-06-1200.bib"},
{"paperid":"1201","title":"Development and Testing of a Ballscrew Electro-Mechanical Generator (EMG) for Wave Energy Conversion","keywords":"This paper presents the results obtained through experimental tests during the development of a 20 kW Power Take-Off (PTO) unit for wave energy conversion. This system, named Electro-Mechanical Generator (EMG), consists of a recirculating ballscrew integrated with a permanent magnet three-phase generator. The performance of the EMG was first measured and assessed on a dry test bench, under a wide range of imposed input conditions. Then, the EMG was connected to a point-pivoted Wave Energy Converter (WEC) and tested in a wave tank under both regular and irregular wave conditions. In both dry and wet experiments, different damping factors were tested connecting the terminals of the EMG to a varying resistive load. Appropriate transducers were used to measure all the relevant system parameters, among them: wave elevation, PTO input axial speed and force, output voltages and currents. Experimental data was also compared to numerical results of ad-hoc developed models. The performances of the PTO are presented for a wide range of operating conditions. These include not only regular waves, but also irregular sea states with different wave heights, peak periods and spectrum shapes. Results indicate that the EMG is able to generate electricity at a high average efficiency, for a very wide range of wave conditions. The full paper is structured as follows: (1) Introduction to wave energy and brief state-of-the-art review for PTO systems; (2) technical description of the EMG and main advantages over other PTO systems; (3) description and analysis of dry tests; (4) description and analysis of wet tests; (5) critical assessment of numerical model accuracy; (6) conclusions.","authors":"M. Martini, L. Castellini","topic":"7","file":"GRDPTO-10-1201.pdf","bib":"GRDPTO-10-1201.bib"},
{"paperid":"1202","title":"Multi-Objective Optimization of Mooring Systems for Offshore Renewable Energy","keywords":"This paper presents a method for the optimizationof mooring systems in offshore renewable energy systems. Thismethodology considers the location of anchors as well as thelength, material, and diameter of the mooring lines in order tosimultaneously minimize the tension in the lines, the cost of themooring system, and the fatigue damage in the system. By consideringthese three objectives using a multi-objective approachrather than reduction to a single objective optimization problemallows a Pareto hull of solutions to be obtained representinga range of solutions which balance the three objectives. Fromthis, a system designer can select the design which appropriatelybalances the trade-off between the competing objectives. Inthis work, a set of mooring designs that represent efficientsolutions for the constraints are found and presented consideringthe OC4 DeepCWind semi-submersible at Wave Hub. Thisreliability-based design optimization approach will be applicableto other offshore technology subsystems allowing reliability tobe considered in a multi-objective optimization from the designphase.","authors":"A. Pillai","topic":"12","file":"MRGFND-03-1202.pdf","bib":"MRGFND-03-1202.bib"},
{"paperid":"1203","title":"Analysis of a 6-DOF tensegrity-based water wave energy harvester","keywords":"During the past fifty years, the use of tensegrity systems as structures has been extensivelyresearched. However, their development for use in ocean waves or energy-related applications isquite recent. In this work, a 6-DOF tensegrity-based wave energy harvester was proposed. By usingthe MMG (Manoeuvring Mathematical Model Group) model, the equations of motions of theconverter are derived. Then, the energy harvesting of the converter is discussed. Finally, byemploying Runge-Kutta method, the motions of the float are simulated and the efficiency ofelectricity generating is computed. The results indicate that the float generates reciprocating motionsalong X and Y axis. The velocity of surge motions is nearly the same as that of sway motions.Furthermore, if all the available power for take-off can be harvested with electrical generators, theefficiency of electricity generating can reach up to 87.9%. Therefore, tensegrity systems can beviewed as one alternative solution to conventional wave energy harvesting systems.","authors":"Z. Ji","topic":"5","file":"WAVHYD-13-1203.pdf","bib":"WAVHYD-13-1203.bib"},
{"paperid":"1204","title":"Power Performance Prediction for a Vented Oscillating Water Column Wave Energy Converter with a Unidirectional Air Turbine Power Take-off","keywords":"This paper presents experimental performance results for a new concept of Oscillating Water Column Wave Energy Converter hereby referred as UniWave. The operating principle for this device utilises air valves that open during times of positive pressure, thereby venting the air chamber, and shut when the air chamber pressure is negative, thus drawing air through a unidirectional air turbine power take-off system. Results are presented for both regular and irregular seas for the planned full scale equivalent OWC prototype of Wave Swell Energy (WSE), an Australian wave energy developer planning an installation in ten metres of water off the west coast of King Island, Tasmania. Prototype top lip and front wall geometry are novel modifications which appear to positively affect the operational characteristics of the device. Results indicate this unidirectional prototype will exhibit very good energy harvesting capability over a wide range of wave frequencies thus potentially permitting impressive wave to wire conversion efficiency.","authors":"A. Fleming","topic":"3","file":"WAVDEV-15-1204.pdf","bib":"WAVDEV-15-1204.bib"},
{"paperid":"1206","title":"Active Suction Anchors for Floating Renewable Energy","keywords":"—The development of a tensile capacity able to sustain high tensile loads is the main factor influencing the design of foundation systems for floating renewables. Active suction, applied on bucket foundations, may offer temporary additional capacity to resist the most extreme loads, enabling a significant reduction of the design loads and hence of the size and cost of the foundation. An analytical model is presented to quantify the increase in uplift capacity resulting from the application of active suction. Limitations are discussed, notably associated with liquefaction. In optimal conditions an increase of capacity up to a ratio of 4.3 may be expected","authors":"N. Fiumana","topic":"12","file":"MRGFND-03-1206.pdf","bib":"MRGFND-03-1206.bib"},
{"paperid":"1207","title":"Investigation into Energy Extraction using Pitch & Roll Motions for Wave Energy Converters","keywords":"<p class=IEEEAbtract>Abstract— This study investigates the possibility of using pitch and roll motions to increase the airflow in floating oscillating water columns by configuring 4 spar buoy type columns into a quadrangle shaped device (Fig 1). For this analysis, the Boundary Element Method (BEM) solver Ansys Aqwa is used. The BEM solver uses numerical methods based on potential flow theory to compute the hydrodynamic performance of the device. It is found that by extracting energy using pitch and roll motions in addition to heave motions, a significant increase of airflow is possible due to the larger capture width of the device. Linear waves have been applied during the numerical modelling for this analysis and the simulations show that optimal performance of the device is obtained when the ratio of column diameter / wavelength λ = 0.042, column length / λ = 0.133 and the distance between the centres of the columns / λ = 0.180. Several ideal conditions have been assumed for this analysis, meaning the results of this research are most likely somewhat optimistic, therefore further research would be required to obtain more realistic results and validation of said results.</p> <p><strong> </strong></p> Keywords— Oscillating Water Columns, Spar Buoy, wave energy, Boundary Element Method, Roll &amp; Pitch motions","authors":"A. Otter","topic":"5","file":"WAVHYD-02-1207.pdf","bib":"WAVHYD-02-1207.bib"}
]